// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {DashboardResourceAlertsPresenter}
 */
define(['hp/services/IndexService',
    'hp/services/IndexFilter',
    'hp/core/EventDispatcher'], 
function(indexService, IndexFilter, EventDispatcher) {"use strict";

    var DashboardResourceAlertPresenter = ( function() {

        /**
         * @constructor
         */
        function DashboardResourceAlertPresenter() {
          
            var dispatcher = new EventDispatcher();
            var configuration;
            var filter;
            
            function onGetTotalSuccess(indexResults) {

                var summary = '';
                
                if (indexResults.members && indexResults.total === 1) {
                    summary = indexResults.members[0].name;
                }
                dispatcher.fire('summaryChange', { total: indexResults.total, summary: summary });
            }
            
            /**
             * @public
             */
            this.init = function (configurationArg) {
                configuration = configurationArg;
                
                filter = new IndexFilter();
                filter.ensureDefaults('alerts', 0, 1);
                filter.setSort('created', 'desc');
                
                // no cleared alerts
                filter.setProperty('state',
                    ['locked', 'active']);
                // turn off validation errors
                filter.setNotProperty('stateReason', 'ValidationError');
                // turn off lifecycle alerts
                filter.setNotProperty('lifeCycle', 'true');
                
                if (configuration.resourceUri) {
                    filter.setProperty('associatedResourceUri', configuration.resourceUri);
                }
            };
            
            this.resume = function () {
            };
            
            this.pause = function () {
            };
            
            this.update = function () {
                indexService.getFilteredIndexResources(filter, { success: onGetTotalSuccess });
            };
            
            this.getResourceUri = function () {
                return configuration.resourceUri;
            };
            
            /**
             * Add a listener for a specified event.
             * @public
             * @param {string} eventName The name of the event.
             * @param {function(...)}
             */
            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
            };
            
            this.off = function(eventName, callback) {
                dispatcher.off(eventName, callback);
            };
        }

        return DashboardResourceAlertPresenter;
    }());

    return DashboardResourceAlertPresenter;
});
