// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/core/Localizer',
        'hp/core/HashManager',
        'jquery'],

function (localizer, hashManager) {
"use strict";

    var MasterErrorView = (function () {
        
        var presenter;
        var lostSessionDialogContainer;

        /**
         * @class View script for handling REST error
         */
        function MasterErrorView() {

            function handleItemError(errorInfo) {
                // errorInfo.errorCode is "AUTHORIZATION" when the server returns error 401 Unauthorized
                if (errorInfo.errorCode && errorInfo.errorCode === "AUTHORIZATION") {
                    if (!lostSessionDialogContainer) {
                        lostSessionDialogContainer = $('#hp-session-lost');
                        localizer.localizeDom(lostSessionDialogContainer);
                        lostSessionDialogContainer.dialog({
                            modal: true,
                            autoOpen: false,
                            position : "center",
                            draggable : false,
                            resizable : false,
                            dialogClass: 'hp-simple-dialog'
                        });
                        $('button', lostSessionDialogContainer).on('click', function () {
                            lostSessionDialogContainer.dialog('close');
                            // Reload and redirect to log in page. After a
                            // successful login, the page is restored.
                            hashManager.setHashAndReload(hashManager.getHash());
                        });
                    }
                    $(lostSessionDialogContainer).dialog("open");
                    $('#hp-body-div').removeClass('hp-sessioned');
                }
            }
            
            function closeLostSessionDialog() {
                if (lostSessionDialogContainer && $(lostSessionDialogContainer).dialog("isOpen")) {
                    $(lostSessionDialogContainer).dialog("close");
                }                
            }

            function onSuccess() {
                closeLostSessionDialog();
                $('#hp-body-div').addClass('hp-sessioned');
            }

            function onError(errorInfo) {
                if (errorInfo) {
                    handleItemError(errorInfo);
                }
            }

            this.pause = function () {
                closeLostSessionDialog();
                presenter.off("indexResultsChange", onSuccess);
                presenter.off("indexResultsError", onError);
            };

            this.resume = function () {
                presenter.on("indexResultsChange", onSuccess);
                presenter.on("indexResultsError", onError);
            };
            
            this.init = function (presenterArg) {
                presenter = presenterArg;
            };

        }

        return new MasterErrorView();

    }());

    return MasterErrorView;

});
