// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['hp/view/dashboard/DashboardCategoryView',
  'hp/view/dashboard/DashboardResourceView',
  'hp/view/dashboard/DashboardResourceAlertView',
  'hp/view/dashboard/DashboardIndicatorView',
  'jquery',
  'hp/lib/jquery.hpSafeClone',
  'hp/lib/jquery.hpGridPanels',
  'hp/lib/jquery.hpSelect',
  'hp/lib/jquery.hpTimestamp'],
function(DashboardCategoryView, DashboardResourceView, DashboardResourceAlertView,
    DashboardIndicatorView) { "use strict";

    var DashboardView = (function() {
      
        var PANELS = '.hp-grid-panels';
        var DELTA_BASE = '#hp-dashboard-delta-base';
      
        /**
         * Constructor
         */
        function DashboardView() {
          
            var categoryTemplate;
            var indicatorTemplate;
            var resourceAlertsTemplate;
            var configuration;
            var views = [];
            
            function initConfig(config, container, height, count) {
                var panel, view;
                if (config.type === 'resourceAlerts') {
                    panel = resourceAlertsTemplate.hpSafeClone();
                    view = new DashboardResourceAlertView();
                }
                else if (config.hasOwnProperty('category')) {
                    panel = categoryTemplate.hpSafeClone();
                    view = new DashboardCategoryView();
                } else if (config.hasOwnProperty('resourceUri')) {
                    panel = categoryTemplate.hpSafeClone();
                    view = new DashboardResourceView();
                } else if (config.hasOwnProperty('query')) {
                    panel = indicatorTemplate.hpSafeClone();
                    view = new DashboardIndicatorView();
                }
                if (view) {
                    panel.addClass(
                        'hp-grid-span-' + Math.round(12/count) +
                        ' hp-grid-height-' + height);
                    container.append(panel);
                    view.init(config, panel);
                    views.push(view);
                }
            }
          
            /**
             * @public
             */
            this.pause = function () {
                $.each(views, function (index, view) {
                    view.pause();
                });
            };
            
            this.resume = function () {
                $(PANELS).hpGridPanels('reset');
                $.each(views, function (index, view) {
                    view.resume();
                    view.update(); // initial poll
                });
            };

            this.update = function () {
                $.each(views, function (index, view) {
                    view.update();
                });
            };
            
            this.init = function () {
                $(PANELS).hpGridPanels();
                $(DELTA_BASE).hpSelect();
                $('.hp-timestamp').hpTimestamp();
                
                categoryTemplate = $('#hp-dashboard-category-template').
                    remove().attr('id', '').removeClass('hp-template');
                indicatorTemplate = $('#hp-dashboard-indicator-template').
                    remove().attr('id', '').removeClass('hp-template');
                resourceAlertsTemplate = $('#hp-dashboard-resource-alerts-template').
                    remove().attr('id', '').removeClass('hp-template');
                
                $.each(configuration.primaries, function (index, config) {
                    // 6 grid height for primary row
                    initConfig(config, $('#hp-dashboard-primary'), 6,
                        configuration.primaries.length);
                });
                $.each(configuration.secondaries, function (index, config) {
                    // 3 grid height for secondary row
                    initConfig(config, $('#hp-dashboard-secondary'), configuration.indicators.length > 0 ? 3 : 6,
                        configuration.secondaries.length);
                });
                $.each(configuration.indicators, function (index, config) {
                    // 3 grid height for indicator row
                    initConfig(config, $('#hp-dashboard-indicators'), 3,
                        configuration.indicators.length);
                });
                
                document.title = 'Dashboard';
                
                this.resume();
            };
            
            this.configure = function (configurationArg) {
                configuration = configurationArg;
            };
        }

        return new DashboardView();
    }());
    
    return DashboardView;
});
