// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/presenter/settings/DevelopmentPresenter',
        'hp/view/FormStateView',
        'hp/core/Notifications',
        'hp/core/Localizer',
        'jquery',
        'hp/lib/jquery.hpSearchCombo'],
function(presenter, FormStateView, notifications, localizer) {"use strict";

    var DevelopmentEditView = (function() {

        var FORM = '#hp-settings-development-form',
            OK = '#hp-settings-edit-ok',
            CANCEL = '#hp-settings-edit-cancel',
            REFRESH_INTERVAL = '#hp-settings-edit-refresh-interval',
            MAX_INDEX_ITEMS = '#hp-settings-edit-max-index-items',
            EXPERIMENTAL_FEATURES = '#hp-settings-edit-experimental-features',
            ROUTING_LOG_LEVEL = '#hp-settings-edit-routing-log-level',
            LABEL_LENGTH_FACTOR = '#hp-settings-edit-label-length-factor',
            AUDIO = '#hp-settings-edit-audio',
            DISABLE_IPV6 = '#hp-settings-edit-ipv6-disable',
            DISABLE_FACTORY_RESET ="#hp-settings-edit-factory-reset-disable",
            HIGH_CONTRAST = '#hp-settings-edit-high-contrast',
            TRACK_TIMING = '#hp-settings-edit-track-timing',
            LOCALE = '#hp-settings-edit-development-locale',
            DEFAULT_LOCALE = '_default_';

        /**
         * @class View script for the Development Settings panel of the Edit view of the Settings page.
         */
        function DevelopmentEditView() {

            var formStateView = new FormStateView();

            function fillForm() {
                $(REFRESH_INTERVAL).val(presenter.getRefreshInterval());
                $(MAX_INDEX_ITEMS).val(presenter.getMaxIndexItems());
                if (presenter.isExperimentalFeatures()) {
                    $(EXPERIMENTAL_FEATURES).attr('checked','checked');
                } else {
                    $(EXPERIMENTAL_FEATURES).removeAttr('checked');
                }
                $(ROUTING_LOG_LEVEL).val(presenter.getRoutingLogLevel());
                $(LABEL_LENGTH_FACTOR).val(presenter.getLabelLengthFactor());

                if (presenter.getDisableAudio()) {
                    $(AUDIO).removeAttr('checked');
                } else {
                    $(AUDIO).attr('checked','checked');
                }
                if (presenter.getDisableIPv6()) {
                   $(DISABLE_IPV6).attr('checked','checked');
                } else {
                   $(DISABLE_IPV6).removeAttr('checked');
                }
               if (presenter.getDisableFactoryReset()) {
                   $(DISABLE_FACTORY_RESET).attr('checked','checked');
                } else {
                   $(DISABLE_FACTORY_RESET).removeAttr('checked');
                }
                if (presenter.getHighContrast()) {
                    $(HIGH_CONTRAST).attr('checked','checked');
                } else {
                    $(HIGH_CONTRAST).removeAttr('checked');
                }
                if (presenter.getTrackTiming()) {
                    $(TRACK_TIMING).attr('checked','checked');
                } else {
                    $(TRACK_TIMING).removeAttr('checked');
                }

                var locale = presenter.getLocale();
                if (locale) {
                    $(LOCALE).hpSearchCombo('set', {id:locale, name: locale});
                }
                else {
                    $(LOCALE).hpSearchCombo('set', {id: DEFAULT_LOCALE, name: '(default)'});
                }
                formStateView.reset();
            }

            function apply() {
                var locale = $(LOCALE + ' :selected').val();

                presenter.save({
                    refreshInterval : $(REFRESH_INTERVAL).val(),
                    maxIndexItems : $(MAX_INDEX_ITEMS).val(),
                    experimentalFeatures : $(EXPERIMENTAL_FEATURES).is(':checked'),
                    routingLogLevel : $(ROUTING_LOG_LEVEL).val(),
                    labelLengthFactor : $(LABEL_LENGTH_FACTOR).val(),
                    disableAudio : (! $(AUDIO).is(':checked')),
                    disableIPv6 : ($(DISABLE_IPV6).is(':checked')),
                    disableFactoryReset : ($(DISABLE_FACTORY_RESET).is(':checked')),
                    highContrast : ($(HIGH_CONTRAST).is(':checked')),
                    trackTiming : ($(TRACK_TIMING).is(':checked')),
                    locale: (locale === DEFAULT_LOCALE) ? null : locale
                });
                if (presenter.isExperimentalFeatures()) {
                    $('html').addClass('experimental');
                } else {
                    $('html').removeClass('experimental');
                }
                if (presenter.getHighContrast()) {
                    $('html').addClass('hp-high-contrast');
                } else {
                    $('html').removeClass('hp-high-contrast');
                }
                var alertMsg = localizer.getString('core.settings.development.edit.success');
                notifications.show(alertMsg);
            }

            this.init = function (validator) {
                var locales = [{id: DEFAULT_LOCALE, name: '(default)'}];
                $.each(hp.supportedLocales, function(index, locale) {
                    var lang = (typeof locale === 'string') ? locale : locale.lang;
                    locales.push({id:lang, name:lang});
                });
                $(LOCALE).hpSearchCombo({results: locales});

                formStateView.init({form: FORM, autoTrack: true});

                // Handlers for the buttons.
                $(OK).click(function(ev) {
                    apply();
                    ev.preventDefault();
                    $(CANCEL).trigger('click');
                });

                // Handlers for the buttons.
                $(CANCEL).click(function(ev) {
                    formStateView.reset();
                });

                fillForm();
            };

            this.pause = function() {
                formStateView.reset();
            };

            this.resume = function () {
                fillForm();
            };
        }

        return new DevelopmentEditView();
    }());

    return DevelopmentEditView;
});
