// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define([ 'hp/presenter/settings/FactoryResetPresenter',
         'fs/presenter/status/StatusPresenter',
         'hp/view/FormStateView',
         'hp/view/DialogView',
         'hp/core/Localizer',
         'hp/core/Router',
         'jquery',
         'hp/lib/jquery.hpCollapsible' ],
function(presenter, statusPresenter, FormStateView, DialogView,
         Localizer, router) {"use strict";

         // buttons/links in the form
         var FACTORY_RESET_FORM = '#hp-factory-reset-form',
             FACTORY_RESET_CONFIRMATION = '#hp-factory-reset-dialog .hp-form-confirmation',
             FACTORY_RESET_OK = '#hp-start-factory-reset',
             FACTORY_RESET_YES= '#hp-confirm-factory-reset',
             FACTORY_RESET_CANCEL = '#hp-cancel-factory-reset',
             FACTORY_RESET_PRESERVE_NETWORK_CHECKBOX = '#hp-factory-reset-network-checkbox',
             FACTORY_RESET_CONFIRM_CANCEL = '#hp-confirm-factory-reset-cancel',
             FACTORY_RESET_CONFIRM_REQUIRED = '#hp-confirm-factory-reset-required',
             FACTORY_RESET_CONFIRM_CHECKBOX = '#hp-factory-reset-confirmation-checkbox',
             FACTORY_RESET_NETWORK_WARNING = '#hp-factory-reset-network-confirmation';
         
         var CONFIRMATION_ERROR_HIDDEN_CLASS = "hp-element-hidden";

    var FactoryResetView = (function() {

        /**
         * Constructor
         */
        function FactoryResetView() {

            var formStateView = new FormStateView();
            var dialog =  new DialogView();

            function settingsPage(){
                router.go("/settings", "factory reset confirmation - cancel");
            }

            function preserveNetworkCheckbox() {
                // Only show the reset network warning when not selecting to preserve the network
                if ($(FACTORY_RESET_PRESERVE_NETWORK_CHECKBOX).is(':checked')) {
                    $(FACTORY_RESET_NETWORK_WARNING).hide();
                } else {
                    $(FACTORY_RESET_NETWORK_WARNING).show();
                };
            }
            
            function onOk() {
                // clear the confirmation checkbox and required error message every time show confirmation dialog
                $(FACTORY_RESET_CONFIRM_CHECKBOX).removeAttr('checked');
                $(FACTORY_RESET_CONFIRM_REQUIRED).addClass(CONFIRMATION_ERROR_HIDDEN_CLASS);
                $(FACTORY_RESET_CONFIRMATION).show();
            }
            
            function onCancel() {
                formStateView.reset();
                $(FACTORY_RESET_CONFIRMATION).hide();
                settingsPage();
            }
            
            function onConfirmationCancel() {
                $(FACTORY_RESET_CONFIRMATION).hide();
                $(FACTORY_RESET_CONFIRM_CHECKBOX).removeAttr('checked');
                $(FACTORY_RESET_CONFIRM_REQUIRED).addClass(CONFIRMATION_ERROR_HIDDEN_CLASS);
            }
            
            function onConfirmCheckbox() {
                // remove the required message if user selects the confirmation checkbox
                $(FACTORY_RESET_CONFIRM_REQUIRED).addClass(CONFIRMATION_ERROR_HIDDEN_CLASS);
            }
            function onFactoryResetFailure(errorInfo) {
                var factoryResetError = {
                    summary : Localizer.getString('fs.settings.factoryReset.startFailure'),
                    status : "error",
                    // must include errorMessage, otherwise the message is only highlighted when it has focus
                    errorMessage : Localizer.getString('fs.settings.factoryReset.startFailure'),
                    changing: false
                };
                $(FACTORY_RESET_CONFIRMATION).hide();
                formStateView.reset();
                // Per UX input 3/1/13, error needs to be reported only one way
                // in only one place, so the notifications call is not needed.
                // notifications.add(factoryResetError, true, true, true);
                formStateView.setMessage(factoryResetError);
            }

            function onFactoryResetSuccess(result) {
                formStateView.reset();
                statusPresenter.setFactoryReset(true);
                router.go("/status", "waiting for factory reset to finish"); 
            }

            function startFactoryReset() { 
                // show the required message if try to start factory reset with out selecting the checkbox
                // acknowledging the factory reset impact. Follows same UX as restore dialog confirmation
                if (! $(FACTORY_RESET_CONFIRM_CHECKBOX).is(':checked')) {
                    $(FACTORY_RESET_CONFIRM_REQUIRED).removeClass(CONFIRMATION_ERROR_HIDDEN_CLASS);
                    return false;
                } 
            
                var option = "FULL";
                if ($(FACTORY_RESET_PRESERVE_NETWORK_CHECKBOX).is(':checked')) {
                    option = "PRESERVE_NETWORK";
                } 
                presenter.startFactoryReset(option, { 
                    success: function(result) {
                        onFactoryResetSuccess(result);
                    },                
                    error: onFactoryResetFailure
                });
            }

            this.pause = function() {
                dialog.pause();
                $(FACTORY_RESET_CONFIRMATION).hide();
            };

            this.resume = function() {
                dialog.resume();
                formStateView.reset();
            };

            this.init = function() {
                presenter.init();
                dialog.init();
                formStateView.init({form: FACTORY_RESET_FORM,
                    routePattern : '/settings/reset/factoryReset' + '.*',
                    autoTrack : true}
                );
                $(FACTORY_RESET_CONFIRMATION).hide();

                $(FACTORY_RESET_OK).on('click', onOk);
                $(FACTORY_RESET_YES).on('click', startFactoryReset);
                $(FACTORY_RESET_PRESERVE_NETWORK_CHECKBOX).on('click',preserveNetworkCheckbox);
                $(FACTORY_RESET_CONFIRM_CANCEL).on('click', onConfirmationCancel); 
                $(FACTORY_RESET_CANCEL).on('click',onCancel);
                $(FACTORY_RESET_CONFIRM_CHECKBOX).on('click',onConfirmCheckbox);
            };

        }

        return new FactoryResetView();
    }());

    return FactoryResetView;
});