// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define([ 'hp/presenter/settings/ApplianceShutdownPresenter', 
         'hp/core/Localizer',
         'fs/presenter/status/StatusPresenter',
         'hp/view/FormStateView',
         'hp/core/Router', 'jquery',
         'hp/lib/jquery.hpCollapsible' ],
function(presenter, localizer, statusPresenter, FormStateView, router) {
            "use strict";

    var ApplianceShutdownView = (function() {
              
        var SHUTDOWN_START = '#hp-start-shutdown',
            SHUTDOWN_CANCEL = '#hp-cancel-shutdown',
            FORM = '#hp-shutdown-restart-form',
            HEADER ='#hp-shutdown-header',
            WARNING = '#shutdown-warning',
            USER_PROMPT = '#shutdown-prompt';
           
         /**
           * Constructor
         */
        function ApplianceShutdownView() {

            // buttons/links in the form
             
            var option;
            var formStateView = new FormStateView();  
            
            
 
            function settingsPage(){
                formStateView.reset();
                router.go('/settings');
            }

            function onApplianceShutdownFailure() {
                
                statusPresenter.setRestartRequested(false);  
                var notif = {                    
                    summary : localizer.getString('fs.settings.shutdown.errorMsg'),
                    status : 'error'
                };    
                formStateView.setMessage(notif);
   
            }
            
            function onApplianceShutdownSuccess(){    
                formStateView.reset();   
                statusPresenter.setUserRestart(option == 'restart');                
                router.go("/status");    
            }

            function startApplianceShutdown() { 
                          
                presenter.startApplianceShutdown(option == 'restart', { 
                    success:  onApplianceShutdownSuccess,       
                    error: onApplianceShutdownFailure
                });                                          
                
                
            }
            function initializePage() {
                  
                $(HEADER).text(localizer.getString('fs.settings.'+ option +'.title'));
                $(WARNING).text(localizer.getString('fs.settings.' + option + '.warning'));
                $(USER_PROMPT).text(localizer.getString('fs.settings.' + option + '.start_prompt'));
                $(SHUTDOWN_START).text(localizer.getString('fs.settings.' + option + '.ok'));
            }
              

            this.pause = function() {                
            };

            this.resume = function() {
                initializePage();
                formStateView.reset();               
            };
            
            this.setOption = function(args) {
                option=args.option;               
            };
           

            this.init = function(args) {
                initializePage();
                formStateView.init({
                    form : FORM,
                    routePattern : '/settings/shutdown' + '.*',
                    autoTrack : false
                });  
                $(SHUTDOWN_START).on('click', startApplianceShutdown); 
                $(SHUTDOWN_CANCEL).on('click', settingsPage);
            };

        }

        return new ApplianceShutdownView();
    }());

    return ApplianceShutdownView;
});