// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define([], function() {
    "use strict";
    return {
        baseline: {
            add: {
                abortedBaseline: "Aborted Baseline",
                availableBundles: "Available Web Bundles",
                title: "Add Baseline",
                deleteBaseline: "Delete Baseline",
				revalidateBaseline: "Revalidate Baseline",
				revalidate :"Revalidate",
				continueReval :"continue with revalidate?",
				revalidateMessage: "The following nodes need inventory after the baseline re-validation.",
				revalWarning: "Cannot revalidate baseline because ",
                deletedBaseline: "Deleted Baseline",
                enterDirectory: "Enter directory path",
                reportPathLabel: "Set report output path:",
                enterHTTPURL: "Enter HTTP URL",
                enterWorkingDirectory: "Enter working directory",
                enterURIPath: "Enter URI for the baseline",
                enterValidHTTPURL: "Enter HTTP URL with valid baseline XML file",
                baselineAdded: "A new Baseline is added successfully",
                browseText: "Browse or manually enter a directory path where the components for the baseline are located.",
                errorReportText: "Selected location is read-only. Select a writable location for report generation",
                emptyReportText: "Provide valid report directory",
                emptySelectionReportText: "Select valid report directory",
                browseReportText: "Browse or manually enter a directory path where the reports should be generated.",
                browsePFWText: "Browse or manually enter a directory path where the Available Web Bundles list and components being downloaded from hpe.com can be stored. Please select an empty folder.",
                browseHTTPText: "Enter a directory path where the components being downloaded can be stored. Please select an empty folder.",
                browseUNCText: "Enter a URI where the components for the baseline are located.",
                getList: "Retrieve List",
                invalidDirectoryPath: "The directory path specified is invalid",
                locationAdded: "A new Location is added successfully",
                locationAlreadyExists: "Baseline location already exists",
                locationType: "Location type",
                locationDetails: "Location Details",
                scheduleInformation: "Schedule and Recurrence Options",
                selectLocation: "Select the location type",
                local: "Browse SUM server path",
                unc: "UNC path  (for example \\\\host\\dir )",
                http: "HTTP",
                httpshare: "Download from http share",
                httpshareurl: "HTTP Share URL",
                httpText: "Provide an HTTP URL to validate a bundle file (bpxxxxxx.xml). All components must be present in the same directory on the HTTP server.",
                httpPrefix: "http://",
                httpsPrefix: "https://",
                httpSuffix: ".xml",
                ftp: "Download from hpe.com",
                enableSchedule: "Schedule download from web?",
                port: "Port",
                proxySettings: "Proxy Settings",
                proxyOptions: "Proxy Options",
                proxyOptionshelp: "Options for adding the proxy if needed.",
                proxyServer: "Proxy server",
                proxyuser: "Username",
                proxypasswd: "Password",
                required: "Required",
                scheduleDatetime: "Select schedule date and time",
                scheduleType: "Recurrence pattern",
                daily: "daily",
                weekly: "weekly",
                monthly: "monthly",
                onetime: "one time",
                noProxyNeeded: "No Proxy Needed",
                none: "none",
                selectBundles: "Select one of the available web bundles to be downloaded from hpe.com. Note: If a component included in the initial release of " +
                    "the web bundle has been unpublished from hpe.com, then it  will not be downloaded from hpe.com with the web bundle. " +
                    "An SPP-sized bundle download may take more than several minutes to complete. Monitor the baseline page for download progress.",
                scheduleRecurring: "Recur every",
                script: "Script",
                scriptconfiguration: "Automatic Configuration Script",
                url: "Address",
                usehp: "Use hpe.com",
                useScript: "Proxy script",
                username: "Please enter the username",
                password: "Please enter the password",
                usecurrentcreds: "Use Current Credentials",
                inValidLocation: "Please enter a valid location!",
                addInProgress: "Baseline addition is in progress. Please wait...",
                abortInProgress: "Baseline Abort is in progress. Please wait...",
                retrieveInProgress: "Retrieving  list of  Web bundles. Please wait...",
                HPEntitlementPassportToken: "Hewlett Packard Enterprise Support Center entitlement token",
                HPPassportTokenDescription: "Hewlett Packard Enterprise has made significant investments in our intellectual capital to provide the best value and experience to our customers." +
                    "We continue to offer a differentiated customer experience with our comprehensive support portfolio.Only  Customers and authorized channel " +
                    "partners may download and use support materials.",
                HPPassportIntellectualCapitalManagementSingleSignIn: "Hewlett Packard Enterprise Support Center Entitlement Token Single Sign In",
                HPPassportICMSingleSignIn: "Hewlett Packard Enterprise Passport ICM Single Sign In",
                HPPassportTokenWarning: "Please enter a valid Hewlett Packard Enterprise Support Center Entitlement Token to access ProLiant Firmware " +
                    "or else leave it blank in order to access only publicly available updates.",
                HPPassportTokenValidation: "Support validation required",
                HPPassportTokenValidationStr1: "An active warranty or support agreement covering HPE ProLiant servers must be linked to your Hewlett Packard Enterprise Support Center profile to access ProLiant firmware. Please enter a valid ",
                HPPassportTokenValidationStr2: "to continue",
                HPPassportTokenValidationStr3: "More Information",
                HPPassportTokenValid: "Hewlett Packard Enterprise Passport Token given is valid.",
                retrytitle: "Retry Download",
                revalidateall: "Revalidate All",
                HPPassportTokenNote: "Note: An Hewlett Packard Enterprise Support Center entitlement token provides access to Hewlett Packard Enterprise support materials (e.g. HPE ProLiant firmware) based on the active contracts & warranties associated to your Hewlett Packard Enterprise Support Center profile.",
                osFilterOpt: "Download components based on OS type",
				HPPassportICMTokenLoginURL: "Login to Hewlett Packard Enterprise Support Center to obtain an Hewlett Packard Enterprise Support Center entitlement token",
				HPPassportICMTokenSupportCenterHelpURL: "Help about Hewlett Packard Enterprise Support Center entitlement tokens",
				HPPassportICMTokenFirmwareAccessHelpURL: "Help about access to firmware for HPE ProLiant servers",
				HPPassportICMTokenURL: "Hewlett Packard Enterprise Support Center entitlement token",
                HPPFWNotes: "Note: Download from hpe.com has been removed starting with SUM version 7.6.0. The SPP ISO or Custom SPP ISO can be created and manually downloaded from",
                HPPFWNotes2:  "After it is downloaded extract or mount the SPP and add it as a local baseline in SUM.",
                MYSPPURL: "SPP Custom Downloads.",
                MYCSMURL: "Cloud System Matrix Downloads Page.",
                HPCSMPFWNotes:"Note: Downloading Latest MatrixConfig.xml has been removed starting with SUM version 7.6.0. " +
                              "MatrixConfig.xml can be manually downloaded to a local directory from ",
                HPCSMPFWNotes2:"Custom baselines can be created by choosing the downloaded XML from the local directory."
            },
            addBaseline: {
                configured: "Configured",
                description: "Description",
                id: "ID",
                select: "Select baselines",
                system: "System"
            },
            custom: {
                add: "Add...",
				addBaselineMsg : "Do you want to add a baseline to the SUM library <br/> or create a new custom baseline?",
			    addBaselineOptions : "Add Baseline Options",
                advancedFilters: "Advanced Filters",
				applyfilters: "Apply Filters",
                applyfiltersHelp: 'Apply filters on the selected baseline source. The filtered components will be displayed below',
                applyfiltersError: 'No baseline source(s) selected. Select one or more baseline source(s)',
                applyfiltersMsg: "Wait while retrieving baseline details...",
                architecture: "Architecture",
                arrayctrl: "Array Controller",
                baselines: "Baselines",
                bootableiso: "Make Bootable ISO File",
                bootableisoHelp: "Check this option to create a bootable ISO with selected baseline.",
                bootableisoHelpLinux: "To create UEFI bootable ISO, xorrisofs must be installed on the system or else the ISO created will only be bootable on legacy BIOS based systems.",
                matchCloudSystem: "Select this to create a custom baseline compliant with a CloudSystem Matrix recipe.",
                both: "Firmware and Software",
                comptype: "Component Type",
                comptypehelp: "Select which component type",
                customCompCountMsg: "Components in baselines: {0}   After filter: {1}   Selected: {2}",
                createBaseline: "Create Custom Baseline",
                createCBLMsg: "Creating custom baseline",
                createCBLMsgSuccess: "Custom baseline creation request accepted successfully",
                createCBLMsgError: "Failed to create custom baseline",
                createiso: "Create ISO and save Baseline",
                criticalUpdates: "Critical Updates",
				customCancel: {
					warning: "Warning: Your changes will be lost.",
					prompt: "Do you wish to proceed?"
				},
                customCreateMsgError: "Baseline has been saved successfully. ISO creation failed. Baseline has been added successfully.",
                customCreateMsgSuccess: "Baseline has been saved successfully. ISO creation was successful. Baseline has been added successfully.",
                customCreateMsgInProgress: "{0} Custom Baseline(s) creation already in progress. Maximum limit reached. Please try after sometime.",
                customSaveMsgSuccess: "The custom baseline has been saved and added to the list of baselines successfully",
                c7000EnclosureComponent: "C7000 Enclosure Components",
                description: "Description *",
                descriptionError: "Description error: ",
                descriptionRequired: "Custom Baseline description is required.",
                descriptionValidationMsg: "Enter only alpha-numeric, hyphen or underscore.",
                deviceType: "Enclosures",
                SynergyEnclosure: "All Synergy Frame Components",
				DevIndependentSoftware: "Device Independent Software Components",
                Synergy: "HPE Synergy",
                IndividualTypes: "Individual Device Types",
                deviceTypehelp: "Display components for device type",
                categoryTypehelp: "Display components for category type",
                categoryDisabledFirmware: "This component category is disabled as selected Component Type is 'Firmware'",
                categoryDisabledSoftware: "This component category is disabled as selected Component Type is 'Software'",
                commonconfig: "Common Configuration",
				DL360p: "DL360 G6 Server",
                DL320p: "DL320 G6 Server",
                DL: "HPE ProLiant DL Series",
                BL: "HPE ProLiant BL Series",
                SL: "HPE ProLiant SL Series",
                WS: "HPE ProLiant WS Series",
                APOLLO: "HPE Apollo Series",
                MICROSERVER: "HPE ProLiant Microserver Series",
                OTHERSERIES: "Other",
                SW: "Software",
                BIOS: "BIOS",
                FW: "Firmware",
                DR: "Driver",
                deselectall: "Deselect all",
                DL480p: "DL480 G6 Server",
                fcHbaCna: "FC HBA/CNA",
                fcswitches: "Fibre Channel Switches",
                powerpic: "Power Management Controller",
                filters: "Step 2 - Filters",
                filterMsg: "Server Model filters are disabled since hardware information is unavailable in one or more selected baseline(s).",
                filterInternalErrMsg: "Server Model filters are disabled, current SUM installation does not contain required metadata file(s).",
                firmware: "Firmware",
                firmwareInclusionWarning: "Note: Onboard Administrator, iLO firmware, x64, SLES11, SLES 12, and BL series firmware components will be included by default. Total size of the ISO should not exceed 4GB to work with Enclosure Firmware Management.<br/><br/>",
                harddrive: "Hard Drive",
                hardwareType: "Server Model",
                categoryType: "Component Category",
                hardwareTypehelp: "Display components for server models",
                ilo: "iLO",
                isolocation: "Extracted Source ISO Location *",
                isolocRequired: "Extracted Source ISO location required",
                isolochelp: "Select directory where an extracted SPP or SUM ISO is located. This is required to create a custom SPP ISO.",
                information: "Information",
                customCreateMsgErr: "Cannot create custom baseline when some of the baselines are still being inventoried",
                maxlen: "Maximum length can be ",
                ML: "HPE ProLiant ML Series",
                ML440p: "ML 440 G6 Server",
                ML280p: "ML280 G6 Server",
                ML560p: "ML560 G6 Server",
                name: "Baseline Name",
                nic: "NIC",
                nonUEFIiso: "Create non-UEFI bootable ISO *",
                nonUEFIisoError: "Please read the warning and select `Create non-UEFI bootable ISO` option to create non-UEFI bootable ISO.",
                nonUEFIisoHelp: "Warning: xorriso was not found on the system running SUM. Any bootable ISO created will not be bootable on UEFI systems.",
                oa: "OA",
                oaefmUpdate: "Enclosure Firmware Management",
                oaefmConfigHelp: "This is disabled because Make Bootable ISO File option is not selected.",
                oaefmHelp: "Select this to create an Enclosure Fimrware Management compatible ISO.",
                optionalUpdates: "Optional Updates",
                osType: "OS Type",
                osFilterOpt: "OS Filter Options",
                osTypeMsg: "*Note : These fields are available based on components in the selected baselines.<br/><br/>If no filters are selected under a category, then all items in that category will be included.",
                operatingsystem: "Operating System",
                osTypes: {
                    rhel5: "RHEL 5",
                    rhel6: "RHEL 6",
                    sles10: "SLES 10",
                    sles11: "SLES 11",
                    vmwareEsxi50: "VMware vSphere 5.0",
                    vmwareEsxi51: "VMware vSphere 5.1",
                    vmwareEsxi55: "VMware vSphere 5.5",
                    windows2003R2: "Windows 2003 R2",
                    windows2008: "Windows 2008",
                    windows2008R2: "Windows 2008 R2",
                    windows2012: "Windows 2012",
                    windows2012R2: "Windows 2012 R2"
                },
                outputDirWarning: "Specify an empty directory where SUM saves the custom baseline.",
                noBaselinesAvailable: "No baselines available!",
                noMatchingComponents: "No matching components found!",
                overview: "Overview",
                populateComponentOsMsg: "Populating component OS details. Please wait...",
                populateComponentOsErrorMsg: "Error occurred while populating component OS details. Error: ",
                populateSourcesMsg: "Populating sources. Please wait...",
                populateSourcesErrorMsg: "Error occurred while populating sources. Error:",
                recommendedUpdates: "Recommended Updates",
                remove: "Remove",
                retrieveCompMsg: "Retrieving components",
                retrieveCompMsgDone: "Completed retrieving components",
                retrieveCompMsgError: "Error retrieving components",
                review: "Step 3 - Review",
                runinback: "Run in Background",
                runinbackHelp: "Create Custom Baseline in background. The status will be available in Activity screen",
                saveBaseline: "Save Baseline",
                sasswitches: "SAS BL switch Interconnects",
                server: "Server",
                software: "Software",
                selectall: "Select all",
                sources: "Step 1 - Baseline Sources",
				specialconfig: "Special Configuration",
                storage: "Storage",
                systemrom: "System ROM/Board",
                tape: "Tape",
                targetlocation: "Output Location *",
                targetlocRequired: "Output location required",
                unknown: "Unknown",
                validationErrorMsg: "Validation errors - Field value required",
                vc: "Virtual Connect (VC)",
                version: "Version *",
                versionError: "Version error: ",
                versionRequired: "Version required",
                versionValidationMsg: "Enter only numeric value.",
                x64: "x64 (64 bit)",
                x86: "x86 (32 bit)",
                versionHelp: "Enter a one or two-character Version identifier, for example, 00, 01, 1A.",
                versionIdentifierError: "Please enter a one or two character version identifier.",
                XL: "HPE ProLiant XL Series",
                hpsumSourcePath: "SUM Path",
                hpsumSourcePathHelp: "This is the location where SUM binary files are located. SUM files will be copied from this location to output location.",
                hpsumSource: "SUM Source Location",
                hpsumSourceTooltip: "To include SUM, select source location type",
                doNotInclude: "Do not include SUM",
                extractedISODirectory: "Extracted Source ISO Directory",
                currentWorkingDirectory: "Current Working Directory",
                customDirectory: "Custom Directory",
                hpsumVersionSelected: "SUM Version Selected : ",
                hpsumlocationRequired: "SUM source path required",
                nosupportedcomps: "No applicable components selected for this model family.",
                nosupportedcompscat: "No applicable components available in the selected baseline(s) for this category.",
                selectingAll: "Selecting components. Please wait...",
                deselectingAll: "Deselecting components. Please wait...",
				sigfiledetails: "Signature file details",
				unsignedcompwarning : "Warning:Unsigned components are not listed in the table.",
				fwpkgcompwarning: "Warning:The selected  SUM version doesn't support processing of .fwpkg components. Those components will not be included in the created custom baseline. The minimum SUM version which supports processing of .fwpkg components is 8.3.5."
            },
            matrix: {
                matchCSMVersion: "Match CloudSystem Matrix Version",
                locationType: "Select Location",
                defintionXML: "CloudSystem Matrix Definition XML file:",
                csmVersion: "CloudSystem Matrix Version:",
                sppBase: "Starting baseline required:"
            },
            start_inventory: "Start Inventory",
            schedule_download: "Schedule Download",
            download_now: "Download Now",
            starting_download: "Starting Download",
            compDownloadInProgress: " Component download in progress",
            compDownloadingFinished: "Components downloading finished",
            locations: "Locations",
            nodeInventoryFailed: "Node inventory failed",
            nodeInventoryInProgress: "Node inventory in progress",
            selectLocation: "Select a valid baseline location.",
            show: {
                yesAbort: "Yes, Abort",
                allBaselinesSelected: "No baselines available for selection.",
                addFromMedia: "Add",
                baselineComponentWarnings: "Baseline has component warnings.",
                baselineReferTo: "Refer to the ",
                detailsAboutWarnings: " for details about warnings.",
                component: "Component",
                componentHelp: "Component help",
                componentTitle: "Component title",
                componentVersion: "Component version",
                componentConfig: "Component Configuration",
                componentConfigError: "There was an error saving the configuration values for this component. Please configure the component outside SUM.",
                componentConfigExport: "Component Configuration - Export",
                componentConfigFor: "Component Configuration for {0}",
                componentConfigImport: "Component Configuration - Import",
                componentConfigSaved: "Status: Component configuration data saved successfully in SUM.",
                configuration: "Configuration State",
                createCustom : "Create Custom",
                credentialsmsg: "Include credentials while exporting the configuration",
                credentialsNote: "Note: The files will be in plain text",
                criticality: "Criticality",
                downloadingComponents: "Downloading {0} of {1} component(s)",
                emptyimportpath: "Folder Path should not be empty for importing the configuration",
                enhancements: "Enhancements",
                exportwarning: "The component configuration could potentially contain credentials that are stored in plain text. Please deselect the checkbox if you don't want to export the credentials.",
                compConfigExportImportFooter: "Note : Any existing component configurations in the specified location will be overwritten.",
                componentWarnings: "Component Errors/Warnings",
                components: "Components",
                folderpath: "Enter Directory Path",
                importConfig: "Import Configuration",
                importConfigMsg: "Warning: Importing configuration will overwrite any existing configuration in this baseline",
                missingcomponents: "Missing Components",
                retry: "Retry",
                ICMtokenInvalid: "An active warranty or support agreement covering HPE ProLiant servers must be linked to your Hewlett Packard Enterprise Support Center profile to access ProLiant firmware.  To download all available ProLiant firmware, please cancel this operation and confirm the status of your contracts and warranties in Hewlett Packard Enterprise Support Center. ",
                inventoryCompleted: "Baseline successfully added",
		hostInventoryCompleted: "Inventory completed",
                inventoryCompletedMissingComponents: "Inventory completed. There are missing components.",
                inventoryFailed: "Inventory failed",
                reinventory: "Re-inventory",
                inventoryError: "Inventory error",
                downloadNeeded: "Download needed to complete the processing",
                inventoryNeeded: "Inventory needed",
                inventoryInProgress: "Inventory in progress",
				revalidationInProgress : "Revalidation in progress",
                locationdetails: "Location Details",
                locationimporttext: "Browse or manually enter the folder name from where the configuration should be imported",
                locationexporttext: "Browse or manually enter the folder name to where the configuration should be exported",
                locationerrormsg: "Selected location is not writable. Select a writable location for export",
                name: "Name",
                needConfig: "Configurable",
                loadOrInvInProgress: "Loading or inventory in progress",
                noComponentsFound: "There are no components",
                noMissingComponents: "There are no missing components",
                numMissingComponents: "{0} components are missing.",
                parDesc: "Parameter Description",
                parName: "Parameter Name",
                processedComponents: "{0} components processed successfully",
                processingComponents: "Processing {0} of {1} components",
                releaseDate: "Release date",
                revisionHistory: "Revision History",
                versionDetails: "Version Details",
                seeComponentWarnings: "Refer to the component warnings section for more details.",
                seeActivityScreen: "Activity Screen",
                subType: "Subtype",
                totalComponents: "Total components",
                type: "Type",
                validate: "Validate",
                value: "Value",
                yesDelete: "Yes, Delete",
                bundleFileDownloadFailed: "Bundle file location is invalid or download failed",
                componentDownloaded: "Components Downloaded",
                componentMissing: "Components Missing",
				baselineToApply: "Baseline to apply",
				baselineDetails: "Baseline details",
				baselineAssigned: "Baseline assigned :",
                additionalPckgAssigned: "Additional Package assigned :",
				invalidSignatureError :"Component not signed",
				sigFileMissingWarning : "Component signature file missing",
				sigFileMissingHover: "Components must have a .compsig file to be used with iLO Repository. Compsig files for Gen 10+ components can be found on the SPP with the component, or downloaded from HPE.com along with the component.",
				invalidSignatureHover : "Component not signed by HPE, and will not be included in update. Verify this file originated from HPE.",
				revalidateHover : "Components with bad signatures and missing component signature files will be validated." 
            },
            storageRemaining: "Storage remaining",
            version: "Version",
            remove: {
                baseline: "Baseline ",
                association: " is associated with ",
                assigned: "Assigned to",
                nodes: " node(s), ",
                continueDel: "continue with delete?",
                deleteMessage: "The following nodes need inventory after deleting the baseline.",
                currentlyAssign: " is currently assigned to ",
                assignNodes: " node(s).",
                delWarning: "Cannot delete baseline because ",
                activelyUse: " node(s) are actively accessing the baseline.",
                device: " Node",
                devices: " Nodes",
                type: "Type",
                status: "Status",
                deleteBaseline: "Delete Baseline",
                delWarningNoNode: "Baseline is not assigned to any node(s), continue with delete?",
                deletingBaselineInProgress: "Delete is in progress...",
                close: "Close"
            },
            validate: {
                blUsedLabel: "Starting baseline used:",
                blUsedLabelValue: "Service Pack for ProLiant",
                bundle: "Validate",
                csmPath: "Select CloudSystem Matrix XML",
                csmTitle: "Validate Baseline",
                csmLabel: "CloudSystem Matrix Version",
                ftp: "Latest MatrixConfig.xml from hpe.com",
                getMatrixFile: "Retrieve File",
                local: "Latest MatrixConfig.xml from local",
                locationType: "CloudSystem Matrix Definition XML File",
                locationTypehelp: "Location of the Matrix config XML file",
                retrieveInProgress: "Retrieving CloudSystem Matrix recipe file... Please wait...",
                selectedBaseline: "Selected Baseline",
                selectedBaselineXML: "bp****.xml",
                sppBundleLocation: "Baseline bundle file location",
                validateBundle: "Validate against bundle file",
                validateCSM: "Validate against CloudSystem Matrix version",
                validationType: "Validation Type",
                validationTypehelp: "Validate against a bundle or version",
                vblBundleSummary: "Summary of validate baseline against bundle",
                saveInProgress: "Save in progress..... Please wait.",
                validationInProgress: "Validation in progress..... Please wait.",
                totalSummary: " components specified in the baseline",
                missingSummary: " components are missing"
            }
        },
        common: {
            /******** Begine - move most strings into new sub group to avoid wrong translation */
            button: {
                cancel: "Cancel",
                no: "No",
                ok: "OK",
				runNow: "Run Now",
                yes: "Yes",
				yesProceed: "Yes, proceed",
                DepliloComp: "Deploy iLO Queued components",
		DeplUefiComp:"Reboot and Deploy iLO Queued components",
                DeplBLoriloSet:"Deploy selected baseline or saved iLO Install Set"
            },
            number: {
                first: "First",
                fourth: "Fourth",
                second: "Second",
                third: "Third"
            },
            status: {
                error: "Error",
                ok: "OK",
                unknown: "Unknown",
                warning: "Warning"
            },
			reboot_required: {
				value:{
					no: "No",
					yes: "Yes"
					},
				text: {
					no: "Reboot may not be required after installation for updates to take effect and hardware stability to be maintained.",
					yes: "Reboot is required after installation for updates to take effect and hardware stability to be maintained.",
				}
			},
			reboot_details: {
				value:{
					no: "No",
					yes: "Yes",
					optional: "Optional",
					required: "Required",
					environmentdependent: "Environment Dependent"
					},
				text:{
					No: "Reboot is not required after installation for updates to take effect and hardware stability to be maintained.",
					Yes: "Reboot is required after installation for updates to take effect and hardware stability to be maintained.",
					Optional: "Reboot is optional after installation. Updates will be effective after reboot. Hardware stability will be maintained without reboot.",
					Required: "Reboot is required after installation for updates to take effect and hardware stability to be maintained.",
					EnvironmentDependent: "Reboot may be required after installation for updates to take effect and hardware stability to be maintained."
				}
			},
            /******** End - move most strings into new sub group to avoid wrong translation */
            abort: "Abort",
            abortdeploy: "Abort Deploy",
            abortMessage: "Abort Baseline",
            missingComponentsInfo: "Missing Components While Downloading",
            abortWarning: "Abort will stop the download, inventory and deletes the baseline. Do you want to Continue?",
            actions: "Actions",
            activity: "Activity",
            activitywait: "Activity page is loading...",
            activeFirmwareVersion: "Active Firmware Version",
            activeROMVersion: "Active ROM Version",
            add: "Add",
            adding: "Adding",
            addMessages: "Add Messages...",
            addNote: "Add note",
            addPlus: "Add +",
            added: "Added",
            addSingleNode: "Add a single node or known range of nodes",
            addType: "Select operation",
            all: "All",
            allDevices: "All Devices",
            allLabels: "All labels",
            allStatuses: "All statuses",
            allTypes: "All types",
            always: "Always",
            analysisErrors: "Analysis Errors",
            analysisWarnings: "Analysis Warnings",
            anyone: "Anyone",
            apply: "Apply",
            arrayController: "Array Controller",
            assignAlert: "Assign alert",
            associatedDevices: "Associated devices",
            associatedOACredentials: "Associated Onboard Administrator Credentials",
            associatedOAIp: "Associated Onboard Administrator IP/DNS",
            associatedOAIpOptMsg: "Optional: required when installing VC firmware prior to 4.01",
            associatedservers: "Device Bays",
            associatedswitches: "Interconnect Bays",
            atiLORepository: "(at iLO Repository)",
            back: "Back",
            bandwidth: "Bandwidth",
            baseline: "Baseline",
            baselines: "Baseline Library",
        baselineLibraryGuide: "No baseline found in the current directory.<br/> Click here to add a new baseline from another directory.",
        baselineToApply: "Baseline to Apply",
        bayNumber: "Bay Number",
        bios: "BIOS",
        bpm: "BPM",
        broadcom: "Broadcom",
        brocade: "Brocade",
            doyouwanttoretry: "Do you want to retry?",
            powerpic: "PMC",
            cpld: "CPLD",
            browse: "Browse",
			createdir: "Create New Folder",
			newdir: "New folder",
			newdirError: "Invalid characters entered. Please enter a valid folder name.",
			cartridges: "Cartridges",
            proceed: "Proceed",
            confirmMessage: "All User Selections will be lost",
            switchMode: "Do you want to change the mode?",
            proceedMessage: "Proceed to new page?",
			emptyFloderIconPresent : " indicates an empty folder that is suitable as an Output Location for baseline creation. If",
 	        emptyFloderIconNotPresent : " not shown, then create new folder using the 'Create New Folder' button.",
            confirm: "Confirm",
            confirmWarning: "Click {0} to continue and enable updates or {1}.",
            applyUserSelection: "Applying user selection, Please wait..",
            confirmSelected: "The configuration warnings have been confirmed and updates will continue. Please wait...",
            cancelSelected: "Updates will be blocked because user has selected to cancel it. Please wait...",
            rerunInventory: "To re-enable updates, please rerun {0}.",
            bootDiskWarningSummary: "Configuration Warnings: If the boot disks on this node are not configured with LVM or if LVM is configured without failover capability, IO firmware update can cause significant system downtime in case any error occurs during the ROM update.",
            category: "Category",
            clearAlert: "Clear alert",
            close: "Close",
            clusterWarningSummary1: "The node ",
            clusterWarningSummary2: " is currently an active member of a Serviceguard cluster.",
            clusterWarningConfirm: "Continue with updates",
            clusterWarningDetails: "       or       ",
            clusterWarningCancel: "Cancel updates",
            clusterWarningContinueInventory: "Continuing with inventory",
            clusterWarningCancelInventory: "Cancelling inventory",
            collapseContent: "Collapse Content",
            comments: "Comments",
            complex: "Complex",
            connections: "Connections",
            continueWithAbort: "Continue with abort?",
            continueWithDelete: "Continue with delete?",
            continueWithDeleting: "Continue with deleting",
            currentdatetime: "Current date/time:",
            core: "Core",
            cores: "Cores",
            count: "Count",
            credentials: "Credentials",
            critical: "Critical",
            daily: "Daily",
            dashboard: "Dashboard",
            date: "Date",
            compName: "Component name",
            prerequisite: "Prerequisites",
            days: {
                friday: "Friday",
                monday: "Monday",
                saturday: "Saturday",
                sunday: "Sunday",
                thursday: "Thursday",
                tuesday: "Tuesday",
                wednesday: "Wednesday"
            },
            deleteAlert: "Delete alert",
            deleteArg: "Delete {0}",
            deleteStr: "Delete",
            dependencyHeader: "{0} items depend on {1}",
            depot: "Depot",
            description: "Description",
            details: "Details",
            dhoa: "DHOA",
            disabled: "Disabled",
            directDeploy: "Direct Deploy",
            doActionInventory: "Perform inventory by clicking the link below or using the Actions menu to get the complete listing of updates available.",
            doInventory: "Inventory",
            download: "Download",
            driver: "Driver",
            edit: "Edit",
            emulex: "Emulex",
            enabled: "Enabled",
            enclosure: "Enclosure",
            enclosureName: "Enclosure Name",
            enterAdministratorCredentials: "Enter administrator credentials",
            enterRootCredentials: "Enter super user credentials to update components",
            enterVcenterAdministratorCredentials: "Enter vCenter details to get ticket (for authentication to host)",
            vcenterCredentials: "vCenter Credentials",
            useVcenter: "Use vCenter",
            evaController: "EVA Controller",
            evaDrive: "EVA Drive",
            every: "Every",
            exit: "Exit", 
			compsigMissingMessage: "Component Signature file is not present and cannot be used with save install set option",
            exportMsg: "Save and Export",
            fcbha: "FCBHA",
            F_VMWARE_NIC_DISC_ERR_MSG: "VMware node inventory failed while reading NIC information.",
            F_VMWARE_FCHBA_DISC_ERR_MSG: "VMware node inventory failed while reading FCHBA information.",
            F_VMWARE_ILO_DISC_ERR_MSG: "VMware node inventory failed while reading iLO information.",
            F_VMWARE_OS_DISC_ERR_MSG: "VMware node inventory failed while reading Operating System information.",
            F_VMWARE_SYSHW_DISC_ERR__MSG: "VMware node inventory failed while reading System Hardware information.",
            F_VMWARE_GENERAL_DISC_ERR_MSG: "VMware node inventory failed while reading Hardware / Operating System information.",
            F_VMWARE_SA_DISC_ERR_MSG: "VMware node inventory failed while reading Smart Array information.",
            F_VMWARE_PCI_DISC_ERR_MSG: "VMware node inventory failed while reading PCI information.",
			F_VMWARE_POSTGEN9_SERVER_FOUND_MSG: "VMware server of generation post Gen9 identified",
            F_VMWARE_ESXI_6_7_UNSUPPORTED_MSG: "Online updates on ESXi 6.7 are not supported via Smart Update Manager.",
			F_VMWARE_ESXI_7_0_UNSUPPORTED_MSG: "Online update on a Gen9 server running ESXi 7.0 and it's updates are not supported via Smart Update Manager.",
            F_VMWARE_MSG: "Please check your network connectivity and WBEM Provider status in the VMware node.",
            F_VMWARE_SECOND_MSG: "{0} after checking the above.",
            F_VMWARE_SELF_DISC_DNL_ERROR_MSG: "VMware node inventory failed to download ",
            F_VMWARE_SELF_DISC_CIM_ERROR_MSG: "This error may be due to stale data in the VMware CIM Service.Try restarting the CIM Service and then running the update again.To restart the CIM service on the ESXi host,login and run the following command on the console /etc/init.d/sfcbd-watchdog restart.",
			F_VMWARE_PROVIDERS_ERROR_MSG: "VMware CIM providers are missing. Install HPE providers to update VMware using SUM.",
			failedComponents: "component(s).",
            fieldRequired: "This field is required.",
            file: "File",
            filter: "Filter",
            filters: "Filters",
            find: "Find Nodes",
            findNodesWithIPRange: "Find nodes on network",
            typesOfNodesSearch: "Choose type of search to use to find nodes",
            ipAddressRange: "IP Address Range",
            portAddress: "Port Address",
            ldapScan: "LDAP Scan",
            firmware: "Firmware",
            firmwareBaseline: "Firmware Baseline",
            firmwareVersion: "Firmware Version",
            found: "Found",
            general: "General",
            group: "Node Group",
            healthStatus: "Health Status",
            help: "Help",
            hpux: "HP-UX",
            hpuxsmif: "HPUXSMIF",
            id: "ID",
            ifNeeded: "If needed",
            ignoreWarnings: "Ignore Warnings",
            ilo: "iLO",
            iloDomain: "iLO Domain:",
            iloDomainNotifyMsg: "The iLO domain is ready to deploy",
            iloFederation: "iLO Federation",
            iloFederationGroupName: "iLO Federation Group Name",
            iloFederationGroupNameError: "iLO Federation group name is necessary",
            iloFederationInterfaceIP: "Interface IP",
            iloFederationWarning: "Node will be converted to a regular iLO node if the iLO Federation service is not detected on it or if the specified iLO Federation group does not exist.",
            iloType: "iLO Type",
            importMsg: "Import",
            incorrectCredentials: "Incorrect username/password or user does not have admin rights.",
			loginDelayed: "Failed login attempts, Unauthorized. Login Delayed for 10 seconds.",
            installedROM: "Installed ROM",
            important: "Important",
            infiniband: "Infiniband",
            initiator: "Initiator",
            installationNotes: "Installation notes",
            installedFirmwareVersion: "Installed Firmware Version",
            integritysfw: "Integrity SFW",
            intelBroadcom: "Intel and Broadcom",
            inventoryhelp: "Gather information about the node",
            ipDns: "IPV4 / IPV6 / DNS",
            ipDnshelp: "IP address or DNS name of the node",
            ipDnshelpedit: "IP address or DNS name of the node added",
            ipdu: "iPDU",
            label: "Label",
            languages: "Languages",
            last: "Last",
            library: "Library",
            linux: "Linux",
            linuxcredentials: "Access Level",
            linuxcredentialsApplicable: "Access Level (Not applicable for use current credentials. Applicable only for administrator credentials)",
            loading: "Loading",
            local: "Local",
            localHostGuidedUpdateGuide: "Launch wizard to update server running SUM.",
            locationStr: "Location",
            loggedIn: "Logged in",
            logout: "Logout",
            managementProcessor: "Management Processor",
            ManagementSWat: "Management Software is accessible at: {0}",
        message: "Message",
            menuGuide: "Click here to open the main menu.",
            model: "Model",
            moonshot: "Moonshot",
            more: "More",
            na: "N/A",
            name: "Name",
            next: "Next",
            nic: "NIC",
            nicIntel: "Intel NIC",
            nicNetXEN: "NetXEN NIC",
            nicEmbedded: "Embedded NIC",
            none: "none",
            noAssociatedDevicesFound: "No associated devices found.",
            noWarnings: "No Warnings found.",
            nodes: "Nodes",
            noderange: "Node Range",
            oa: "OA",
            oddeven: "Odd-Even",
            serial: "Serial",
            parallel: "Parallel",
            manual: "Manual",
            oneTouchUpdate: "Localhost Guided Update",
            open: "Open",
            operatingSystems: "Operating Systems",
            optional: "Optional",
            os: "OS",
            overview: "Overview",
            password: "Password",
            PartnerIpduCredentials: "Partner iPDU Credentials",
            PartnerIpduIP: "Partner iPDU IP/DNS",
            pci: "PCI",
            power: "Power",
            progress: "Progress",
            previous: "Prev",
            qlogic: "QLogic",
            query: "?",
            questionMark: "?",
            reboot: "Reboot",
            recommended: "Recommended",
            reenterCredentials: "Re enter Credentials",
            rebootRequired: "Reboot Required",
            related: "Related",
            reset: "Reset",
            resetAll: "Reset all",
            retry: "Retry",
            rpm: "RPM",
            rollbackSupported: "Rollback Supported",
            rollbackVersion: "Rollback Version",
            saController: "SA Controller",
            sas: "SAS",
            sashba: "SASHBA",
            sasHD: "SAS Hard Drive",
            continueDownload: "Continue download",
            save: "Save",
            savetohpsum: "Save in SUM",
            saveAs: "Save As",
            scalableUpdate: "iLO Federated Update",
            scalableUpdatePhrase: "Scalable Update",
            discoveringDevice: "Discovering device...",
            sdoa: "SD2OA",
            search: "Search",
            selectDevices: "Select Devices",
            selectOption: "Select option",
			sep: "SEP",
            server: "Server",
            servers: "Servers",
            session: "Session",
            slot: "Slot",
            shutdownMsg: "SUM Engine is Shutdown. Please restart the engine to Login.",
            shutdownRequestFailed: "There was an error processing the request. Please try again.",
            software: "Software",
            solex: "Solex",
            source: "Source",
            staging: "Staging",
            start: "Start",
            startOver: "Start Over",
            state: "State",
            statusStr: "Status",
            commandStr: "Command",
            strDelete: "Delete",
            switchBrocade: "Brocade Switch",
            switchCisco: "Cisco Switch",
            switchQLogic: "QLogic Switch",
            switchStr: "Switch",
            switches: "Switches",
            succeeded: "Succeeded",
            tape: "Tape",
            task: "Task",
            tasks: "Activity",
            the: "The",
            time: "Time",
            timezone: "Timezone:",
            type: "Type",
            typetoadd: "Node type",
            typetoaddhelp: "Check this option to add all the enclosure nodes",
            undefinedStr: "Undefined",
            updateType: "Update Type",
            updating: "Updating",
            uploads: "Uploads",
            useCurrentCredentials: "Use current credentials (requires existing trust relationship with the node).",
            user: "User",
            username: "Username",
            useSudoCredentials: "Use sudo to update components",
            utility: "Utility",
            utilization: "Utilization",
            version: "Version",
            vc: "VC",
            vmware: "VMware",
            vmwareDriver: "VMware Driver",
            viewAllActivity: "View all activity",
            viewDetails: "View Details",
            weekly: "Weekly",
            weeks: "weeks",
            welcome: "Welcome to Smart Update Manager",
            windows: "Windows",
            yesDelete: "Yes, delete",
            unsupportedBrowser: "Warning: The browser you are using is not officially supported by SUM.  Some features may not work properly. Supported browsers are: Internet Explorer 9 or greater, Firefox 17 (Linux)/ 18 (Windows) or greater, Chrome 24 or greater",
            unsupportedBrowserVersion: "Warning: The browser version you are using is below the version officially supported by SUM.  Some features may not work properly. Supported browsers are: Internet Explorer 9 or greater, Firefox 17 (Linux)/ 18 (Windows) or greater, Chrome 24 or greater",
            unknownNodeError: "Unable to identify node as a supported node type. Please ensure that node is supported, reachable on the network and credentials are correct.",
            vmwareLoginError: "Login Error",
            vmwareLockDownMode: "Unable to login. Please ensure that login credentials are correct or enter the vCenter credentials if the host is in lockdown mode.",
            unknownNodeFederationGrpError: "The specified iLO Federation group was not found in the network. Please ensure that the specified iLO is part of the iLO Federation group. Delete the node and add again with a valid iLO Federation group.",
            deleteBaseline: "Delete Baseline",
            minimumResolutionWarning: "A minimum screen resolution of 1024 x 768 is recommended when using Smart Update Manager in order to ensure all functionality is available.",
            enterSSHKeyCredentials: "Enter SSH key credentials",
            SshKeyFile: "Private Keyfile (PEM format)",
            SshKeyFilePassphrase: "Passphrase",
            SshKeyFilePassphraseHint: "Required only if a passphrase is required for the private key file",
			installSetSerialNo: "No",
			installSetName: "Name",
			installSetDesc: "Description",
			installSetDate: "Date Created",
			installSetSize: "Size",
			installSetIsRecoverySet: "Recovery Set",
			installSetDelete: "Delete",
			installSetHead: "iLO Repository Install Set",
			noApplicableinstallsetsFound: "No Install Sets are available",
			installSetTitle: "iLO Repository Install Set component details",
                        installSetTitleLGU:"iLO Repository Install Set summary",
			installSet: "Install set",
			installSetComponentsTotal: "Number of components",            
			installSetSumComponents: "SUM/iSUT updatable components",
			installSetUEFIComponents: "UEFI updatable components",
			installSetILOComponents: "iLO updatable components",
			installSetILOComponentsLGU:"iLO updatable components",
			installSetDetails: "iLO Installation Queue details",
			installSetUpdatedBy: "Updated by",
			installSetCompVersion: "Version",
			installSetCompInstalledVersion: "Installed version",
			installSetCompType: "Type",
			installSetCompFileName: "File name",
			installSetCompActivates: "Activates",
			installSetNoCompFound: "No Components found",
			installSeCompOrder: "Order",
			installSeCompWaitTime: "Wait time in seconds",
			installSeCompAction: "Action",
			installSeCompState: "State",
			pendingTaskQueue: "Pending updates already exist in iLO Installation Queue",
			warnings: "Warnings",
			iLOUdateListDetails: "iLO Installation Task Details",
			iLOInstallSetDetails: "iLO Repository Install Set details",
			iLOInstallSet: "iLO Repository Install Set name ",
			iLOInstallSetSize: "iLO Repository Install Set size ",
            applicableForGen10: "Applicable only for Gen 10 servers",
            updateTaskQueueTitle: "iLO Installation Queue Details",
            pendingTaskQueueWarning: "The node has not been inventoried yet, but the iLO Installation Queue contains pending items. <br /> You may continue to deploy a pending item, select a local baseline to deploy, or choose a saved iLO Install Set to deploy. <br /> To review recommendations and make component selections before deploying, click Inventory in the Action menu.",
            pendingTQWarningForDeployWithexState: "The top of Installation Queue Item is in an exception or expired state. Clicking deploy will clear these tasks in iLO.",
	     pendingTQWarningForDeployWithPendingState: "Unfinished tasks were found in iLO Repository. Clicking Deploy will clear the unfinished tasks in iLO.",
		 pendingTQWarningForDeployWithScheduledState: "Scheduled tasks were found in iLO Repository. Clicking Deploy will clear the Scheduled tasks in iLO.",
	     installSetComponents: "Install set components",
          installSetSequenecNum:  "No.",
          postDeployexecutablesExist: "Some components are queued to be executed only after a reboot and will not be included in this deploy.",
          iLOTaskQueueScheduledWarning: "Warning: Installation Tasks are scheduled in iLO. Continuing with deployment will clear all of the iLO queued items.",
		  iLOTaskQueuePendingWarning: "Warning: Installation Tasks are pending in iLO. Use inventory to customize and queue a new set of additional components.",
          iloTaskqueueTopItemWarning: "Warning: One or more iLO queued items are in an exception state. Continuing with deployment will clear all of the iLO queued items.",
          installsetDeleteInProgress: "Deleting the Install Set. Please wait...",
          installsetDeleteConfirm: "Clicking OK will delete the selected iLO saved Install Set from iLO. Do you still want to continue with delete?",
          installsetCannotDeleteDuetoInProgressState: "Deleting Install Set is not allowed as node is in {0} state",
          installsetCannotDelete: "Cannot delete a protected recovery set.",
          installsetDeleteWarningMessage: "Because this Install Set is the assigned baseline, the node will be reset to the uninventoried state.",
          installsetWarningDuetoGroup: "Because this node is part of a Node Group with this Install Set as the assigned baseline, the node will be removed from the Node Group and reset to the uninventoried state.",
          notApplicable: "NA",
          iLOUnrefCompDetails: "iLO Repository Unreferenced Component details",
          iLOUnrefComponents: "iLO Repository Unreferenced Components",
          unrefCompDeleteConfirm: "Clicking OK will delete the Unreferenced Components from iLO. Do you still want to continue with delete?",
          unrefCompDeleteInProgress: "Deleting Unreferenced Components. Please wait...",
          actionApplyUpdate: "ApplyUpdate",
          installsetCompNeedsReboot: "(Needs Reboot)"
        },
        dashboard: {
            age: "Age",
            sinceLastMonth: "Since last month",
            sinceLastWeek: "Since last week",
            sinceYesterday: "Since yesterday",
            totals: "Totals"
        },
        enclosure: {
            addEnclosure: "Add Enclosure",
            deviceType: "Device type",
            deployEnclosure: "Deploy Enclosure",
            embedded: "Embedded",
            ended: "Ended",
            expected: "Expected",
            hostnameOrIpAddress: "Hostname or IP address",
            link: "Link",
            longModelDescription: "Long Model Description",
            matrixEnabled: "CloudSystem Matrix enabled",
            matrixVersion: "CloudSystem Matrix version",
            measured: "Measured",
            notes: "Notes",
            started: "Started",
            units: "Units",
            usage: "Usage"
        },
        host: {
            addVmHost: "Add VM host",
            connectionError: "Encountered a communication problem with {0}. Try again.",
            history: "History",
            memoryAlloc: "Memory allocated",
            sortBy: "Sort by",
            storageAlloc: "Storage allocated",
            vCoreAlloc: "vCore allocated",
            uptime: "Uptime",
            vmHosts: "VM hosts",
            vms: "VMs"
        },
        menu: {
            deploymentTypes: "Deployment Types",
            enclosures: "Enclosures",
            sources: "Options",
            vmHosts: "VM hosts",
            welcome: "Home",
            general: "General",
            pageTypes: "Deployment Types",
            dashboard: "Dashboard",
            node: "Node",
            ilo: "iLO",
            vc: "Virtual Connect",
            ipdu: "Intelligent Power Distribution Units (iPDU)",
            ilofederation: "iLO Federation"
        },
        group: {
            groups: "Node Groups",
            addGroup: "Create Node Group", //Changes done as part of HFS requirement dated 07/25/2014
            addNew: "Add New Node Group",
            addedNewGroup: "Added a new Node Group",
            addingNewGroup: "Adding a new Node Group",
            abortInProgress: "Node group abort is in progress",
            general: "General",
            groupName: "Node Group Name",
            enterGroupName: "Please enter Node Group Name",
            managegroups: "(Manage Groups)",
            inValidGroupName: "Should start with an alphabet followed by an alphabet, a space, - or a digit.",
            groupDescription: "Node Group Description",
            groupBaseline: "Node Group Baseline",
            groupBaselinehelp: "Select a baseline for the Node Group. Individual nodes can override this selection",
            groupHotfix: "Node Group Additional Package",
            groupHotfixhelp: "Select an additional package for the Node Group. Individual nodes can override this selection",
            description: "Description",
            deployMsg: "Click on the {0} components link to view the component details for the node",
            groupStatus: "Node Group Status",
            groupscheduledatetime: "Node Group Schedule DateTime",
            scheduleInventoryWarning: "Performing inventory now causes the node schedules below to be cancelled",
            scheduleGroupOverviewDesc: "Updates will be scheduled for this Node Group at the time set below. The time is based on the local time where SUM engine is running. ",
            scheduleAddWarning: "The nodes being added to this Node Group are scheduled as below:",
            scheduledatetime: "Schedule DateTime",
            scheduleMessage: "Nodes in the Node Groups are scheduled for deployment",
            scheduledStaging: "Nodes in the Node Group are scheduled for Staging",
            scheduleUnMatchedMessage: "One or more nodes in the Node Group have node schedules different from the Node Group schedule",
            scheduleToggleWarning: "Creating a Node Group schedule will override node schedules for the nodes below",
            scheduleDeployWarning: "Performing Deploy causes the below node schedules to be cancelled",
            selectNodes: "Select Nodes",
            deleteschedule: "Continue with Node Group schedule delete? ",
            selectAll: "Select All",
            deselectAll: "Unselect All",
            name: "Name",
            type: "Type",
            addNode: "New Node",
            addNewNode: "Add a new Node",
            edit: "Edit Node Group",
            noMoreNodesAvailable: "No more Node(s) available",
            noNodesInGroup: "No Node(s) in the Node Group",
            groupAlreadyExists: "Node Group already exists",
            status: "Status",
			stage: "Stage",
            addNodesToGroup: "Assign existing Node(s) to Node Group",
            removeNodesFromGroup: "Remove Node(s) from Node Group",
            editCredentials: "Change Node Group credentials",
            requiredUserName: "Required User Name along with Password",
            requiredPassword: "Required Password along with User Name",
            editedGroup: "Edited Node Group",
            groupNodes: "Node Group Nodes",
            nodeName: "Node Name",
            groupInitSummary: "Node Group initialization is in progress",
            groupNoNodesSummary: "No Node(s) in the Node Group",
            groupPendingFwUpdate: "One or more nodes are in pending firmware updates",
            groupNodeActivatingPendingFw: "One or more nodes are activating firmware updates",
            groupIntNodePendingFw: "One or more nodes require activation of pending firmware",
            groupInActiveSummary: "Node Group is inactive",
            groupInActiveDetails: "Please Activate/Remove inactive node(s)",
            groupErrorSummary: "An error occurred on Node Group",
            groupErrorDetails: "Node Group has error node(s)",
            groupDiscoveringSummary: "Discovery is in progress",
            readyForInventory: "Ready to start inventory",
			inventoryDetails: "Inventory must be performed to gather iLO Federation group member details.",
            startInventory: "Start Inventory",
            inventory: "Inventory",
            inventoryGroup: "Inventory Node Group",
            selectedBaseline: "Currently selected Baseline",
            selectBaseline: "Select a Baseline",
            currentlySelectedBaseline: "Currently selected baseline for this Node Group",
            currentBaselineSelected: "Current Baseline",
            additionalPackageSelected: "Current additional package",
            selectBaselineInventory: "Select the baseline you want to use to do the inventory.",
            baselines: "Baselines",
            baseline: "Baseline",
            additionalPackage: "Additional Package",
            groupBaseLines: "Node Group Baselines",
            //inventoryProgress: "Inventory and/or Staging is in progress",
            inventoryProgress: "Inventory is in progress",
            stageProgress: "Stage is in progress",
            selfInventoryProgress: "Self inventory is in progress",
            startInventoryAgain: "Start inventory again",
            inventoryError: "Inventory error",
            readyForDeploy: "Ready to start deploy",
            readyForDeployStatus: "Ready for deployment.",
            stageComplete: "Stage complete.",
            groupAtBaseline: "Group is at the baseline version",
            groupAboveBaseline: "Group is above the baseline version",
            startDeploy: "Online Review/Deploy",
            analysisProgress: "Analysis is in progress",
            analysisProgressPW: "Analysis is in progress. Please wait...",
            applyingInstallationOptions: "Applying installation options. Please wait...",
            applyingSelectionChanges: "Applying user selection changes. Please wait...",
            applicableComps: "Applicable components are repopulated after applying changes.",
            deployProgress: "Deployment is in progress",
            noApplicableComp: "Node Group is up to date. No applicable components found.",
            deployGroup: "Deploy Node Group",
			stageGroup: "Stage Node Group",
            deployErrorSummary: "Deployment error",
            deployHoldSummary: "Deployment on hold.",
            deployDone: "Deployment done",
            deployStarted: "Deployment started",
            deletedGroup: "Deleted Node Group",
            deleteConfirm: "Continue to remove Node Group. ",
            abortConfirm: "Continue to abort Node Group operation?",
            yesAbort: "Yes, abort",
            abortedGroup: "Aborted Node Group",
            okGroupNodes: "Node(s) up to date",
            errorGroupNodes: "Node(s) with Error",
            warningGroupNodes: "Node(s) waiting or with warnings",
            inProgressGroupNodes: "Busy Node(s)",
            unKnownGroupNodes: "Node(s) in an unknown state",
            defaultName: "Default",
            defaultGroup: "This is the default Node Group",
            noBaseline: "No baseline",
            noAdtPackage: "No additional package",
            baselineWarning: "Assigning a baseline {0} will replace the existing baselines of all the nodes in this Node Group",
            credentialsWarning: "Changing Node Group credentials will override credentials of all nodes in this Node Group",
            noBaselineWarning: "No Baseline associated with this Node Group.<br/><br/>Select baseline(s) to apply to all nodes in this group. Applying this baseline will override the baseline assigned to the individual nodes currently. Not assigning any baseline will retain the baseline(s) that are already assigned to the individual nodes.",
            //Changes done as part of HFS requirement dated 07/25/2014
            noBaselineNodes: "No Baseline selected. A Baseline should be associated with the Node Group",
            noNodes: "No Nodes available",
            useSchedule: "Use Node Group Schedule",
            retainSchedule: "Retain Node Schedule",
            timezone: "Node Group TimeZone",
            useNodesPage: "Use Nodes Page to add new nodes. An existing Node Group can be assigned to a new node on Add Node Page.",
            stageNodeGroup: "Stage Node Group",
            nodesToInventory: "Nodes to inventory",
			nodesToStage: "Nodes to stage",
            skipInventoriedNodes: "Exclude already inventoried nodes",
            skipStagedNodes: "Exclude already staged nodes",
			nodeStatusMsg: "Applicable component count is available for Inventoried node.",
            //nodeAndGrpStateNotSameDoInventory: "The new node(s) included are not in same state. You can Inventory/Stage the node using group baseline and then include in the group.",
			nodeAndGrpStateNotSameDoInventory: "The new node(s) included are not in same state. You can Inventory the node using group baseline and then include in the group or press 'OK' to reset the node and group state.",
			nodeAndGrpStateNotSame: "The new node(s) included are not in initial state, press 'OK' to reset node state.",
			nodeAndGrpBaselineNotSame: "The new node(s) included are not using the same baseline as assigned to this group. Adding node(s) to the group will reassign group baseline.",
			nodeAndGrpInUANWithNotSameBaseline: "The new node(s) included are not using the same baseline as assigned to this group. Adding node(s) to the group will reassign group baseline and also reset node and group state to idle.",
			nodePartOfOtherGrp: "Some of the node(s) are already part of another group. Do you want to remove node(s) from their respective group(s) and add it to this group?",	
			addNodeConfirmation: "Do you still want to include them ?",
			currentGrp: "Node group",
			nodeError: "Node in error state can not be added to the group",
			nodeProcessingError: "Node in {0} state can not be added to the group",
			currentNodeBaseline: "Node Baseline",
			currentNodeAddPckg: "Node additional Package",
			groupdirectDeploy: "Group Direct Deploy",
			selectBaselineWarning: "Use a local baseline and/or additional package {0} if present.",
			groupWarningMsg: "Some node(s) contain warnings. Please check the node update details section below for more information.",
			nodeGroupDetails: "Node Group details",
			nodeGroupName: "Name : ",
			groupBLNotPresentInNode: "Node and Group baseline are not same,so cannot be added in the Group",
			groupDeployDisabledDueToMissingSigFile: "Deploy is disabled as some of the node(s) have missing component signature file(s). Please enable skip component with missing component signature file/failed dependency option or deselect component(s) not having signature file to continue with deployment.",
			skipCompsigAndFailedDependency: "Skip components with missing component signature file along with failed dependency",
            missingCompSigAndFailedDepWarning: "Component(s) with missing signature file or failed dependency will not be considered for update if skip component with missing component signature file or failed dependency option is selected.",
            DeployDisabledDueToDependencyFailureGrp: "Deploy is disabled due to dependency failures. Please enable skip component with missing component signature file/failed dependency option or deselect component(s) having dependency failures to continue with deployment.",
            groupStageDisabledDueToMissingSigFile: "Stage is disabled as some of the node(s) have missing component signature file(s). Please enable skip component with missing component signature file/failed dependency option or deselect component(s) with missing signature files to continue with staging.",
            stageDisabledDueToDependencyFailureGrp: "Stage is disabled due to dependency failures. Please enable skip component with missing component signature file/failed dependency option or deselect component(s) having dependency failures to continue with staging.",
			deployDisabledDueToNameDesc:"Deploy is disabled as Name and Description in the iLO Repository Options tab are incorrect. Please correct these values to proceed with deployment",
			stageDisabledDueToNameDesc : "Stage is disabled as Name and Description in the iLO Repository Options tab are incorrect. Please correct these values to proceed with staging"
			
        },
        node: {
            abortActionSuccessful: "Abort Successful",
            abortFor: "Abort for {0}",
            abortInProgress: "Abort in progress...",
            abortInstallFor: "Abort installation for {0}",
            activeProcess: "If active update process is detected on the remote node, SUM should",
            activeVersion: "Active Version",
            ActivationOrder: "Activation Order",
            activationDelay: "Activation Delay",
            addassociatednodes: "Automatically add associated nodes",
            addBaselineOptional: "(Optional) Select an already added and inventoried baseline and/or additional package to apply to this node.  If not added now, a baseline or additional package must be specified when Inventory is started on the node.",
            addBaselineOptionalGU: "(Optional) Select an already added baseline and/or additional package to apply to this node. The location from where SUM is running is used as the default.",
            addBaselineMandatory: "Select an already added and inventoried baseline and/or additional package to apply to this node.Components from the selected baseline(s) will be used to gather some information from the node.",
            associatedNodeDetails: "Associated Node Details",
            additionalPackages: "Additional Packages",
            additionalPackageshelp: "Components that are not part of any bundle",
            addNew: "Add New",
            addNewEnclosure: "Add New Enclosure",
            addNewIlo: "Add New iLO",
            addNewIpdu: "Add New IPDU",
            addNewMoonshot: "Add New Moonshot",
			addNewSdFlex: "Add New Superdome Flex RMC",
            addNewServer: "Add New Server",
            addNewSwitch: "Add New Switch",
            addNewVC: "Add New Virtual Connect",
            addNewVM: "Add New VMware Host",
            addNode: "Add Node",
            addnodes: "Add Nodes",
            addedNodes: "Added Nodes",
            selectnodes: "Select Nodes",
            editingDisabledDueToGroup: "Cannot edit field as node is part of a group. Please remove the node from the group to edit this field.",
            //adding on going activity details..
            AddingNodesMsg: "Adding Nodes",
            AddingNodesSuccessMsg: "Completed adding nodes",
            nodesAddedSuccessfully: " node(s) added successfully",
            addnodesError: "Errors while adding nodes: ",
			addIntegrityNodeError: "Node type {0} is not supported",
			integrityNodeErrDetails: "The {0} node type is no longer supported for updates. Use SUM versions prior to 8.0.0 for {1} updates.",
			moonshotNodeError: "Node type {0} is not supported",
			moonshotNodeErrDetails: "The {0} node type is no longer supported for updates. Use SUM versions prior to 8.3.0 for {1} updates.",
			//Changes done as part of HFS requirement dated 07/25/2014
            addMoonshotNode: "Add Moonshot",
            addIloNode: "Add iLO",
            addIloFedarationNode: "Add iLO Federation",
            addSwitch: "Add Switch",
            addServer: "Add Server",
            addVC: "Add Virtual Connect",
            addIPDU: "Add iPDU",
            addGroup: "Add Group",
            addEnclosure: "Add Enclosure",
            addVmWare: "Add VM Host",
            agentlessManagementService: "Agentless Management Service",
            always: "Always",
            analysis: "Analysis",
            applicableComponents: "Applicable Components",
            assignTo: "Assign to",
            groupDescMsg : "Optional: Assign the node to an existing node group. The group's baseline overrides a baseline selected here.",
            assignTohelp: "Optional: The node can be assigned to an existing node group.",
            addHelp: "Enter a single IP or DNS name (ex: 10.1.2.3 or server.ab.com) <br>Enter Multiples using comma seperator (ex: 10.1.2.3, 10.1.4.45) <br>Enter ranges using a dash (ex: 10.2.3.51 - 10.2.3.64)",
            assignNewBaseline: "Assign a new baseline to the node.",
            availableNodes: "Available Nodes",
            availableVersion: "Available Version",
            cancelSchedule: "DeleteSchedule",
            cannotDelete: "Cannot delete localhost!",
            prereqs: "Prerequisites Installation Option",
            installPrereqs: "Install Prerequisite components if not already installed",
            prereqsHelp: "Prerequisite components such as iLO Channel Interface Driver are required to communicate with iLO to get complete inventory and status",
            installPrereqsWarning: "Warning: if Prerequisite components are not already installed, inventory and deploy may be incomplete.",
            installPrereqsWarningOEM: "Warning: Servers require Prerequisite Components to be installed.",
            close: "Close",
            combinedReport: "Combined report",
            combinedReporthelp: "All report types in one file.",
            componentDetails: "Component Details",
            compFailedDep: "Components with failed dependencies selected",
            compSelect: "{0} Components Selected",
            compSelectZero: "0 Components Selected",
            cpuSockets: "CPU Sockets",
            csv: "CSV",
            csvhelp: "Generates reports in CSV format that can be opened in any application that supports CSV format.",
            currentBaselineSelected: "Current baseline selected",
            currentlySelectedBaseline: "Currently selected baseline for this node",
            currentStatus: "Current Status",
            daily: "Daily",
            dayOfEveryMonth: "day of every month",
            days: "days",
            deleteschedule: "Continue with schedule delete? ",
            deletedNode: "Deleted node",
            deletenode: "Continue with delete? ",
            deleteNodes: "Delete the node(s).",
            deploy: "Deploy",
            descriptionPlaceholder: "Description placeholder",
			details: "Details",
            doActionDeploy: "Ready for deployment.  Deploy",
            doDeploy: "Deploy",
            dummyIpAddress: "99.99.99.240",
            duplicateNode: "Node already added. Use Edit Node option to change attributes",
            invalidIP: "Invalid IP/DNS name entered",
            enableSchedule: "Enable schedule",
            encryptionKey: "Encryption Key *",
            encryptionKeyHelp: "Requires minimum 8 characters",
            encryptionSettings: "VC FIPS Encryption Settings",
            enterAssociatedOADetails: "Enter associated Onboard Administrator details",
			enteriLOCredentials : "Enter valid iLO administrator credentials",
            enterIPAddress: "Enter IP Address",
            enterPartnerIpduDetails: "Enter Partner iPDU Details",
            enterRebootMessage: "Enter reboot message",
            errorPleaseSelectBaseline: "Error - Select baseline",
            estimatedDeploymentTime: "Estimated deployment time: 15 mins",
            EnetOrder: "VC Enet Modules Activation Order",
            EnetDelay: "VC Enet Modules Activation Delay",
            FCDelay: "VC FC Modules Activation Delay",
            Fips_VC_Msg: "Note: If FIPS support is enabled on the Virtual Connect (VC), perform deploy from the Virtual Connect(VC) node deploy page where  FIPS settings and other options can be set.",
	FIPS_OA_Msg: "Note: If FIPS is enabled on the Onboard Administrator(OA), downgrade/re-write of Onboard Administrator (OA) firmware is not allowed.",
            every: "Every",
            failedAnalysis: "Analysis failed.",
            failedDependencyDetails: "Failed dependency details",
            failedDependencyDetailshelp: "This report provides information about the failed dependencies for the node.",
            family: "Family",
            fibreChannelSwitch: "Fibre Channel Switch",
            filteringIsInProgressPleaseWait: "Filtering Components. Please wait...",
            findNodeRange: "Find Node Range",
            firmwareDetails: "Firmware details",
            firmwareDetailshelp: "This report provides information about the firmware versions that are currently installed on the node.",
            FCOrder: "VC FC Modules Activation Order",
            forceOptions: "Force Options",
            forceOptionFirmware: "Firmware",
            forceOptionMessage: "Firmware and Software options must be used in conjunction with Downgrade and/or Rewrite options.",
            forceOptionSoftware: "Software",
            forceOptionSoftwareError: "Firmware and/or Software option must be selected.",
            forceOptionsCanBeAppliedTo: "Firmware/Software options can be applied to",
            friday: "Friday",
            generate: "Generate",
            hpSasBlInterconnectSwitch: "HPE SAS B/L Interconnect Switch",
            html: "HTML",
            htmlhelp: "Generates reports as HTML files that you can view in a JavaScript-enabled web browser.",
            ifNeeded: "If needed",
            iloHpCom: "ilo.hpe.com",
            iLOCredentials: "iLO Credentials",
            iLOCredentialsNote: "Note: Only applies to systems with iLO. iLO domain credentials cannot be used to update an iLO Recovery Install Set.",
			iLORepositoryOptions: "iLO Repository Options",
			iloCacModeError: "CAC is enabled on the iLO for the node {0}. The operation cannot proceed.",
			iloHighSecurityModeError: "The iLO for the server {0} has been configured in a high security mode or 'Require Host Authentication' is enabled. \niLO administrator credentials are required for SUM to interact with iLO from the host OS. This account must have 'Configure iLO Settings' permissions.",
			biosPasswordEnabledError: "BIOS password is set for the server {0}. \niLO administrator credentials are required for SUM to interact with iLO from the host OS. This account must have 'Configure iLO Settings' permissions.",
			iloCredentialsOptional: "iLO credentials are required in addition to host OS credentials when the iLO for a server is configured in one of the high security modes or if 'Require Host Authentication' is enabled. The account provided must have 'Configure iLO Settings' permissions in order to perform firmware updates, 'Recovery Set' permissions are necessary to update the iLO recovery set.",
			iloRecoveryCredentialsNote: "Note: iLO domain credentials cannot be used to update an iLO Recovery Install Set.",
			iLOInvalidCredentials: "Incorrect iLO credentials.",
			helpDoc: "Refer to SUM Help for more details",
            installableDetails: "Deploy preview",
            installableDetailshelp: "This report provides information about components that SUM would install on the node",
            iLOFedTechPreviewWarning: "The current version of SUM only provides a technology preview of iLO Federation.  Firmware Deploy functionality is unavailable in this version.",
            /* wrong merge? Bring back by Boa since still using in html */
            installDone: "Install done.",
            installDoneWithErrors: "Install done with error(s)",
            installDoneSee: "Install done. See component logs for more information.",
            installDoneSeeErrors: "Install done with error(s). See component logs for more information.",
            stageDone: "Stage complete.",
            stageDoneWithErrors: "Stage done with error(s)",
            stageDoneSee: "Stage done. See component logs for more information.",
            stageDoneSeeErrors: "Stage done with error(s). See component logs for more information.",
            installProgress: "Install in progress.",
            installProgressMoonshot: "Install in progress. This deploy may take several minutes per cartridge in the system.",
            compVerboseLog: "Enable verbose logging from components",
            compVerboseLogForWindows: "Enable verbose logging (Applicable for Windows only)",
            removeGrpDesc: "Remove the node from {0}, and apply a new baseline, Install Set, or update using already queued components in the iLO update list.",
            removeNodeFromGrp: "To assign another baseline, remove the node from {0}.", 
            noComponentsInstalledDes: "None of the components were installed because either none of them were selected/applicable for deployment or node is up to date.",
            noComponentsInstalled: "No component(s) deployed.",
            installationOptions: {
                applyingOptions: "Applying Installation options...",
                optionsSuccess: "Successfully applied installation options",
                message: "Installation Options allow you to choose Downgrade, Rewrite and other settings.",
                help: "Upgrade/Downgrade/Rewrite options",
                header: "Installation Options",
                options: "Options",
                upgradeBoth: "Upgrade Firmware and Software",
				upgradeFirmware: "Upgrade Firmware",
				upgradeSoftware: "Upgrade Software",
				downgradeFirmware: "Downgrade Firmware",
				downgradeSoftware: "Downgrade Software",
				downgradeBoth: "Downgrade Both",
				rewriteFirmware: "Rewrite Firmware",
				rewriteSoftware: "Rewrite Software",
				rewriteBoth: "Rewrite Both",
				firmware: "Downgrade & Rewrite Firmware",
				software: "Downgrade & Rewrite Software",
				both: "Downgrade & Rewrite Both"
            },
            installedDetails: "Deploy details",
            installedDetailshelp: "This report provides information about what SUM installed on the node.",
            installedBios: "Installed BIOS",
            installedIlo: "Installed iLO",
            installedPowerpic: "Installed PMC",
            installedCPLD: "Installed CPLD",
            installedVersion: "Installed version",
            installing: "Installing",
            intelligentPowerDistributionUnit: "Intelligent Power Distribution Unit (iPDU)",
            invalid: "Invalid IP Address or Range or Port specified",
            invalidLdapDetails: "Invalid LDAP Server or username or password specified",
            invalidBaseline: "Please select a valid baseline",
            invalidAdtPackage: "Please select a valid additional package",
            inventory: "Inventory",
            inventoryhelp: "This report provides information on the applicable components  in the specified baseline.",
            inventoryInProgress: "Inventory in progress.",
            ip: "IP Address",
            ipCannotBe: "IP cannot be",
            ipend: "End IP Address",
            iprangeError1: 'There can be only two IPs separated by "-" provided as an IP range',
            iprangeError2: "Start and end IP provided in an IP range cannot be same",
            iprangeError3: "Start IP cannot be greater than end IP provided in an IP range",
            iprangeError4: 'The first three numbers of IPs separated by "-" must be same',
			iprangeError5: 'Incorrect IP range',
            ipstart: "Start IP Address",
            portToScan: "Port to Scan",
            other: "Other",
            enterLDAPAddress: "Enter LDAP server address",
            maxReturn: "Max Return",
            ldapServer: "LDAP Server",
            ipdu: "iPDU",
            keyPemForSshAuth: "PEM key for SSH authentication access",
            last: "Last",
            leaveAlone: "Leave the update running and bypass the node",
            monday: "Monday",
            monthly: "Monthly",
			masternodetime: "Master Node Time:",
            needAssociatedOADetails: "Requires associated Onboard Administrator credentials to continue inventory",
            needAssociatediPDUDetails: "Requires partner iPDU credentials to continue inventory",
            never: "Never",
            no: "No",
            noAddedNodes: "No nodes added!",
            noNodesAddedYet: "No nodes added yet.",
            noApplicableComponentsFound: "No applicable components found",
            noFoundNodes: "No nodes found!",
            noNodesFoundYet: "No nodes found yet.",
            noItemsFound: "No items found!",
			noItemsFoundInstallsetInventory: "Inventory of the local baseline is not required when iLO saved Install Set is selected.",
            noStorageDeviceFound: "No Storage devices found!",
            noNicDeviceFound: "No NIC/FC-HBA/CNA devices found!",
            noPSDeviceFound: "No Programmable Power Supplies found",
            nodeInfoNotAvailable: "This information is not available. Perform node inventory to view the data.",
            firewallBlocking: "Verify no firewalls are blocking HTTP/FTP traffic between the system running SUM and the remote node.",
            noAssociatedNodes: "No associated nodes found!",
            noBaselineAvailable: "No baseline available to proceed with deployment.",
            noBaselineDefined: "No baseline defined",
            noBaselineSelected: "No baseline selected",
            nodesBelowList: "Nodes selected from the below list will be deployed along with {0}.",
            nodeCount: "{0} Node(s)",
            nodeDetails: "Node Details",
            nodeInventoryInProgress: "Node inventory in progress ...",
            nodesPopulatedAfterSearch: "Nodes will be populated after search.",
            nodeUpToDate: "Node up to date",
            node_name: "DNS Node Name",
            nodeNotReady: "Node not ready for deployment.",
            none: "None",
            notValidIpOrDns: "Not a valid IP (IPV4/IPV6) or DNS",
            ofEveryMonth: "of every month",
            offlineDeploy: "Offline Deploy",
            offlineReviewDeploy: "Offline Review/ Deploy",
            onboardAdministrator: "Onboard Administrator",
            onlineDeploy: "Online Deploy",
            onlineReviewDeploy: "Online Review/ Deploy",
            optional: "Optional",
            openFirewall: "Click here to open the SUM ports in firewall and start inventory", //"Open Firewall",
            openFirewallMsg: "SUM ports are blocked in firewall", //"Restart SUM with open_firewall option or click here to open the ports",
            openFirewallSuccessNotifMsg: "SUM ports unblocked successfully for ",
            openFirewallErrorNotifMsg: "Failed to unblock SUM ports for ",
            openFirewallInventoryStartNotifMsg: "Inventory has started for the node ",
            openFirewallInventoryErrorNotifMsg: "Failed to start inventory for the node ",
            openFirewallDeploy: "Click here to open the SUM ports in firewall and start deploy",
            openFirewallDeployStartNotifMsg: "Deploy started for the node ",
            openFirewallDeployErrorNotifMsg: "Failed to start deploy for the node ",
            osManagementOptions: "OS Management Options",
            phase: "Phase",
            pleaseSelectAPorB: "Please select a Baseline or Additional Package.",
            pleaseSelectType: "Please select a type.",
            pleaseSelectCorrectNode: "Please select the correct node.",
            proliantBl460cG7: "ProLiant BL460c G7",
            readyForDeploy: "Ready for deployment.",
            rebootAndForceOptions: "Reboot and Force Options",
            rebootDelay: "Reboot Delay (1 - 60 Minutes)",
            rebootMessage: "Rebooting at user request in order to activate deployed firmware or software",
            rebootMessageLength: "Message up to 255 characters",
            rebootOptions: "Reboot Options",
            rebootSystemAfterInstallation: "Reboot system after installation",
            iloManagementOptions: "iLO Repository Options",
            saveInstallSets: "Save Components as an Install Set on iLO Repository",
			updateRecoverySet: "Update components in the recovery set with applicable components from this run",
			updateRecoverySetiLOCredentialsRequired: "iLO credentials are required to update the recovery set. The account provided must have \'Recovery Set\' privileges.",
			updateRecSetDisableiLOVerErr: "The minimum required iLO5 version to update the existing recovery set is 1.30",
			updateRecSetDisableAuthenticationErr: "The current credentials used for iLO do not include permissions to change the Recovery Set. Use Edit Node to change iLO credentials or edit the permissions for this iLO user and try again.",
			updateRecSetDisableNoRecoverySetPresent: "No recovery install set exists currently in iLO",
			updateRecSetDisableNoRecoveryComponentPresent: "No applicable recovery set components present in the install set",
			updateRecDisableSaveInstallSetNotSelected: "Updating recovery install set is applicable only when save install set is selected",
			stage: "Stage",
            availableIloSpace: "Available iLO space:",
            installSetNameDesc: "Name:",
            installsetDescTitle: "Description:",
            replaceExistingIloupdateLists: "Replace existing iLO update lists with new updates",
            appendNewUpdatestoExistingIloUpdates: "Append new updates to existing iLO update lists",
            deleteOldInstallSets: "SUM manages iLO Repository space<br> &emsp; &emsp;(SUM might remove old sets to make space.)",
            chooseExistingInstallsetForDelete: "Manually manage iLO Repository space<br> &emsp; &emsp;(Deployment does not proceed if there is not enough free space.)",
            deleteInstallsetTitle: "Delete existing Install Set/Unreferenced Components",
            nodeTypeErrorMessage: "Select a node type.",
            nodeNameErrorMessage: "Provide a valid IP/DNS or range.",
            nodeCredentialsErrorMessage: "Provide the credentials with administration privileges or member of a administrators group.",
            nodeSudoCredentials: "Provide the Sudo credentials.",
            nodeUsername: "Provide the Username",
            nodePassword: "Provide the Password",
            validationErrorMsg: "Validation errors - Field value(s) required",
            rebootRequired: "Reboot required after install",
            refresh: "Refresh",
            runNow: "DeployNow",
            nodeUptoDate: "Node is at its assigned baseline.",
            nodeAboveBaseline: "Node is above baseline",
            nodeRebooted: "Node is rebooted",
            rangeIpsNotOfSameType: "Please provide start IP and end IP of same type - IPV4 or IPV6.",
            rangeNotInSameSubnet: "Please provide start and end IP address from same subnet mask.",
            rebootDelaySecondsErrMsg: "Valid reboot delay required",
            rebootDelayNotANumber: "Please enter a number here",
            recurEvery: "Recur every",
            replaceSession: "Stop any currently running update process on the node and replace it with updates from this session",
            reports: "Reports",
            reportsDesc: "Reports description (TBD)",
            reportInProgress: "Report generation is in progress",
            required: "Required",
            invalidIPV4orIPV6: "Enter valid IP (IPV4/IPV6)",
            reviewDeploy: "Review/ Deploy",
            reviewAndDeploy: "Review and deploy updates",
            reportsLocationMessage: "All Reports are located at: ",
            saturday: "Saturday",
            sd2HasErrors: "SDX has FW analysis errors. Check the Deploy screen for details",
            sd2HasWarnings: "SDX has FW analysis warnings. Check the Deploy screen for details",
            scanning: "Scanning",
            schedule: "Schedule",
			scheduling: "Scheduling",
            schedulehelp: "Options to schedule the deployment",
            scheduledate: "Schedule Date",
            scheduletime: "Schedule Time [hh:mm (24hr) format]",
			schedulfrom: "From: ",
			scheduleto: "To: ",
			schedulefromerror: "Schedule From time should be 30 minutes later than system current time.",
			scheduletoerror: "Schedule To time should be atleast 1 hour later than Schedule From time.",
            scheduledeploy: "Schedule Deploy",
            scheduleNodes: "Schedule Nodes",
            scheduleset: "Schedule is set at ",
            scheduleOverviewDesc: "Updates will be scheduled for this node at the time set below. The time is based on the local time where SUM engine is running. ",
            scheduletimeformat: "Time should be entered in hh:mm (24 hr) format",
            scheduleDisableiLOVerErr: "The minimum required iLO5 version to use scheduling is 1.30",
            searchIsInProgressPleaseWait: "Search is in progress. Please wait...",
            selectBaseline: "Select the baseline you want to associate with this node",
            selectBaseline2: "Select the baseline you want to use to do the inventory",
            selectType: "Select Type",
            serial: "Serial",
            servers: "{0} Servers",
            shutdownNodeDeploy: "The following nodes are scheduled for deployment. The deployments for these nodes will occur at the scheduled time even if SUM engine is shutdown:",
            shutdownNodeError: "Shutdown cannot be done, because one or more nodes are currently doing operations that cannot be aborted. Manually abort those nodes; then, proceed to shutdown.",
            start: "Start",
            sunday: "Sunday",
            superdome2onboardAdministrator: "Superdome X Onboard Administrator",
			superdomeFlexRMC: "Superdome Flex RMC",
            moonshot: "Moonshot",
            the: "The",
            thisNodeAlready: "This node was already added.",
            thursday: "Thursday",
            tuesday: "Tuesday",
            type: "Node Type",
            vcOptionstitle: "Virtual Connect Options",
            virtualConnect: "Virtual Connect",
            useCredentialsAbove: "Use credentials above",
            useroptions: "User Options",
            userSshAuth: "User SSH Authentication Access",
            useSnmp: "Use SNMP",
            useWebem: "Use WBEM",
            vmWareHost: "VMware Host",
            vmwareRewriteWarning: "VMware does not support rewrite of driver and software components.",
			OAFIPSForceWarning: "FIPS mode is ON. Downgrade/Re-write of OA firmware is not allowed.",
			uefiCompSelectionWarning: "Note: Windows components are selected if the firmware is updatable by UEFI when doing iLO Repository based updates. This is intended as UEFI can understand only zip packages.",
			EsxiDowngradeCompSelectionWarning: "Note: The downgrade of software and driver components are not allowed in VMware ESXi 7.0.",
            vcOptions: "VC Activation Options",
            vcOptionsMsg: "VC options such as VC activation order can be set via the Edit Node or Review/Deploy pages.",
            vcFIPSEncryptionKeyHelp: "VC Domain is in FIPS mode. Encryption Key is mandatory (minimum 8 characters)",
            vcDomainNotConfigured: "VC Domain not configured. Please configure domain to discover and update firmware",
            waitingforAssoc: "Deployment on hold. Waiting for associated node to finish installation.",
            waitingforComp: "Waiting for component information...",
            pendingfwUpdate: "The firmware update is pending. Waiting for associated nodes to finish installation",
            activatingPendingfwUpdate: "Activating the pending firmware update",
            scheduledStaging: "Scheduled for staging",
            scheduledDeploy: "Scheduled for deploy",
            wednesday: "Wednesday",
            weekly: "Weekly",
            weeks: "weeks",
            xml: "XML",
            xmlhelp: "Generates reports as XML files that you can view in a JavaScript-enabled web browser.",
            selectReportTypes: "Select Report Types",
            selectReportFormats: "Select Report Format",
            advancedReportOptions: "Advanced Report Options",
            runbackReport: "Generate Report in Background",
            runbackReporthelp: "Check this box to hide the dialog window",
            analysisProgress: "Analysis is in progress. Please wait...",
            applicableComps: "Applicable components are re-populated after analysis",
            runningReportInBack: "Report generation running in Background for {0}",
            runningReportInBackMulti: "Report generation running in Background for Multiple Nodes.",
            doneReportMulti: "Report generated successfully for Multiple Nodes.",
            partialReportMulti: "Report generated Partially for Multiple Nodes.",
            failedReportMulti: "Failed to generate Report for Multiple Nodes",
            referForReportStatus: "Please refer the Activity screen, or the Reports center section in the Reports page for more details about the report generation.",
            doneReport: "Report generated successfully for {0}",
            failedReport: "Failed to generate Report for {0}",
            pleaseWait: "Please Wait...",
            partialReport: "Report generated Partially for {0}",
            viewLogs: "View installation log(s)",
            defaultLiveLogMessage: "Gathering livelog information. The log information is refreshed every 15 seconds.",
            installationLogs: "Installation logs",
			noInstallationLogs : "No installation logs available",
			errorInstallationLogs :"ERROR: Unable to retrieve installation logs at this time.",
            logDetails: "Log details",
            nodeName: "Node(s)",
            nodeScheduled: "Node is scheduled for deployment at ",
            timeStamp: "Generated At",
            reportLocationPath: "Report Path",
            reportFormat: "Format",
            reportStatus: "Status",
            reportDelete: "Delete?",
            completed: "Completed",
            partiallyCompleted: "Partially Completed",
            inProgress: "In Progress",
            failed: "Failed",
            firmWareType: "Firmware",
            installableType: "Installable",
            installedType: "Installed",
            failledDepencyType: "Failed Dependency",
            reportPath: "Location",
            noReports: "No Reports Available",
            allReports: "Reports Center",
            deleteReportConfirm: "Continue with Delete Report?",
            vcDomain: "VC Domain",
            vcModules: "VC Modules",
            viewDetails: "View Details",
            accessType: "Access Type",
            requiresTrustRelationship: "Requires existing trust relationship with the node.",
			validNameDesc: "Enter only alpha-numeric, hyphen or underscore.",
			maxlen: "Maximum length can be {0} characters",
			readyToProceedToolTip: "Ready to proceed. No Errors found",
			compUpToDateToolTip: "Component is up to date. No Errors found",
			CompSigToolTip: "Component signature file is not present and cannot be used with save install set option.",
			dependencyErrorsToolTip: "Dependency Errors. Double click to view details",
            nodeCommonPanel: {
                always: "Always reboot after installation",
                applyTo: "Apply to:",
                assignBaseline: "Assign different baseline",
                autoAddAssoNodes: "Automatically add associated nodes",
                forceOptionAll: "All components",
                forceOptionFirmware: "Only firmware components",
                forceOptionSoftware: "Only software components",
                ifNeeded: "Reboot after installation if needed",
                installationforceOptions: "Installation / Force Options",
                suUsername: "su Username",
                suPassword: "su Password",
                rootCredentials: "Enter root level credentials",
                sudoCredentials: "Enter user with Sudo permissions credentials",
                selectManagementOptions: "Select Management Options to Install",
                noManagementOptions: "Select no Management Options",
                normalCredentials: "Enter normal user and su user credentials",
                noreboot: "Do not reboot after installation",
                currentCredentials: "Use current credentials",
                assoAddPack: "Additional Package at",
                assoBaselineSPP: "SPP at ",
                baselineSelection: "Baseline selection"
            },
            liveLog: "LiveLog",
            liveLogInstalling: "Deploying the package ",
            liveLogInstalled: "Deployed the package ",
            liveLogInprogress: "Deploy in progress ",
            liveLogCompleted: "Deploy Completed",
            allImmediate: "All Immediate",
            allDeferred: "All Deferred",
            stageAddBaselineMandatory: "Select an already added and inventoried baseline and/or additional package to apply to this node.",
            selectBaselineStageDirectdeploy: "Select the baseline you want to use to ",
            scheduledStageNote: "This SUM Service must remain running until scheduled time.",
            stageDetails: "Stage details",
            stageNodeIPAdress: "IP Address:",
            totalStageComponents: "Total components staged for update:",
            criticalStageUpdates: "Critical updates:",
            recommendedStageUpdates: "Recommended updates:",
            optionalStageUpdates: "Optional updates:",
            nonCategorizedStageUpdates: "Non-Categorized updates:",
            nodeStageScheduled: "Node scheduled for staging at ",
            nodeDeployScheduled: "Node deploy scheduled at ",
			temporaryAbort: "Pausing schedule temporarily.",
			nodesNumber: "Number of nodes :",
			nodeDeployCount: "Nodes selected for deployment : ",
			nodeStageCount: "Nodes selected for staging : ",
			nodeUpdateDetails: "Node update details",
			readyToDeployNodes: "Only ready to Deploy Nodes will be displayed",
			saveBaselineAsRollbackOniLO: "iLO Repository on Gen10 servers can save baselines on the server to use as future rollback points. Even components already current will be uploaded. Provides a better solution in case of a need for rollback in the future.",
			unfinishedTask: "Unfinished tasks were found in iLO update list:",
            sigFileExists: "Signature File Exists",
			invDisableRevalBaseline : "Inventory is disabled as revalidation is in progress for the baseline associated with the node",
			groupinvDisableRevalBaseline: "Inventory is disabled as revalidation is in progress for the baseline associated with the group",
			invDisabledDueRecoverySet: "Using Recovery Install Set as a baseline is not supported. Use another baseline."
        },
        notLocalized: "FIXME: NOT LOCALIZED",
        oneTouchUpdate: {
            actionTitle: "Localhost Guided Update",
            activation: "Activation",
            activeVersion: "Active Version",
            addBaseline: "Add Baseline",
            addBaselineOptional: "(Optional) Select an already added and inventoried baseline and/or additional package to apply to this node.",
            addBaselines: "Select Baselines",
            addBaselinesError: "Failed to get results",
            additionalPackage: "Additional Package",
            addNodes: "Select Nodes",
            addedNode: "Added node",
            advancedOptions: {
                applyFilters: "Apply Filters",
                dayOfEveryMonth: "day of Every month",
                days: "days",
                downgrade: "Downgrade",
                enableSchedule: "Enable Schedule",
                enterRebootMessage: "Enter reboot message",
                firmware: "Firmware",
                forceOptions: "Global Force Options",
                installOptions: "Global install options",
                ofEveryMonth: "of Every month",
                reboot: "Global reboot options",
                rebootDelay: "Reboot Delay (1 - 60 Minutes)",
                rebootDelaySecondsErrMsg: "Valid reboot delay required",
                rebootDelayNotANumber: "Please enter a number here",
                rebootMessageLength: "Message up to 255 characters",
                rebootNodesAfterInstallation: "Reboot nodes after installation",
                rebootOptions: "Global reboot options",
                recurEvery: "Recur every",
                rewrite: "Rewrite",
                schedule: "Schedule",
                scheduleOptions: "Schedule options",
                software: "Software",
                title: "Advanced options"
            },
			installPreReqsTitle: "Install Prerequisites",
			installPreReqs: "Installing Prerequisites. Please wait...",
			installPreReqsFailed: "Failed to install Prerequisites",
			iloHighSecurityMode: "The iLO on this server has been configured in a high security mode.",
			iloBIOSPasswordEnabled: "BIOS password is set on this server.",
			iloHighSecurityModeExpress: "<br>Provide iLO administrator credentials with express install.",
			iloHighSecurityModeOffline: "<br>Please run SUM in Online mode or Offline interactive mode or disable high security mode to update this server.",
			iloBIOSPasswordEnabledOffline: "<br>Please run SUM in Online mode or Offline interactive mode or disable BIOS password to update this server.",
			iLOInvalidCredentials: "Incorrect iLO credentials. <br>Enter valid iLO administrator credentials.",
			enteriLOCredentials: "<br>Enter iLO administrator credentials.",
			iLOCACError: "CAC is enabled on the iLO for this server. <br>The operation cannot proceed.",
			otuHelpDoc: "<br>Refer to SUM Localhost Guided Update Help for more details.",
			preReqsNotFound: "Prerequisites are not installed on this node. Would you like to proceed to install?",
		    inventoryAbortInProgress : "Node inventory abort in progress",
		    deployAbortInProgress : "Node deploy abort in progress",
            applicableComponents: "- applicable components",
            assignBaseline: "Assign Baseline",
            availableVersion: "Available Version",
            analyze: "Analyze",
            assoAddPack: "Additional Package at ",
            assoBaselineSPP: "Service Pack for ProLiant at ",
            baselineAdded: "Baseline added",
            baselineNodeInvTitle: "Inventory of baseline and node",
            baselines: "Baselines",
            baselineSelection: "Baseline Selection",
            component: "Component",
            componentDetails: "Component details",
            componentDetailsFor: "Component details for {0}",
            componentHelp: "Component help",
            componentLog: "Component log",
            componentTitle: "Component title",
            componentVersion: "Component Version",
            confirmAutoUpdate: "Continue with full automatic inventory and deploy all suggested updates on the system running SUM?",
            criticality: "Criticality",
            deployment: "Deployment",
            deploymentCompleted: "Deployment completed",
            deploymentError: "Deployment error",
            deploymentInProgress: "Deployment in progress",
            deploymentLog: "Deployment log",
            deploymentResults: "Deployment results",
            deploymentStatus: "Deployment status",
            deploymentSummary: "Deployment summary",
            enterCredentials: "Enter credentials",
            enterPassword: "Enter password",
            enterUserName: "Enter user name",
            errorDeployProgress: "Currently node deploy is in progress, cannot change the baseline.",
            errorInvProgress: "Currently node inventiory is in progress, cannot change the baseline.",
            failedToAddBaseline: "Failed to add baseline",
            failedToAddNode: "Failed to add node",
            family: "Family",
            force: "Force",
            forced: "Forced",
            installedVersion: "Installed Version",
            interactive: "Interactive",
            inventory: "Inventory",
            inventoryBaselineNode: "Inventory of baseline and node",
            inventoryOfBaseline: "Inventory of baseline",
            inventoryOfNode: "Inventory of Localhost",
            localhostOnly: "Localhost only",
            log: "Log",
            manageBaselines: "Add Baselines",
            manageNodes: "Add Nodes",
            mode: "Mode",
            moreBundles: "Multiple baselines found in the location ",
            moreDetails: "Automatic mode will inventory and deploy all applicable updates without user interaction on the system running SUM.",
            multipleNodesBaselines: "Multiple nodes/baselines",
            noBaselineDefault: "No default baseline found.",
            noCompFound: "No components found at the location",
            noComponentsInstalled: "No components were installed or there was an error retrieving logs",
			iLO5NoComponentsInstalled: "No components were installed or components were staged in the iLO Repository or there was an error retrieving logs",
            nodeInventoryAborted: "Node inventory aborted",
            nodeInventoryTitle: "Inventory of node",
            nodeDeployAborted: "Node deploy aborted",
            nodes: "Nodes",
            nonInteractive: "Automatic",
            onlyOneAllowed: ". Only one baseline is acceptable in the specified location.",
            overview: "Overview",
            packageStr: "Package",
            password: "Password",
            reboot: "Reboot",
            localhost: "Localhost",
            alreadyadded: "Already added node",
            newnode: "New node",
            node: "Node",
            rebootDelayErrMsg: "Enter delay value between 60 and 3600 seconds",
            never: "Never",
            reports: {
                csv: "CSV",
                description: "Description",
                failedDependencyDetails: "Failed Dependency details",
                firmwareDetails: "Firmware details",
                html: "HTML",
                installableDetails: "Installable details",
                installedDetails: "Installed details",
                overview: "Overview",
                reports: "Reports",
                type: "Type",
                xml: "XML"
            },
            review: "Review",
            select: "Select",
            selectComponents: "Select Components",
            selected: "Selected",
            selectModeTypeDeployment: "Select deployment mode",
            statusStr: "Ready to proceed",
            step: "Step",
            title: "Localhost Guided Update",
            totalComponentsApplicable: "Applicable Components: ",
            totalComponentsSuggested: "Suggested Components: ",
            totalComponentsSelected: "Selected Components: ",
            useCurrentCredentials: "Use current credentials",
            useCurrentCredentialsHelp: "Select to use current credentials",
            userAborted: "Aborted by user",
            userAbortedError: "Error occurred while aborting operation",
            userName: "User name",
            viewLog: "View log",
            warningsSummary: "Deploy may encounter issues due to the following warning(s): ",
            warningsHead: "Warnings/Alerts",
			selectAll: "Select all",
			deselectAll: "Deselect all",
			updatependingilo: "Warning: Previous updates not deployed on the iLO",
			updatescheduledinilo: "Warning: Previous updates are scheduled for deployment in  iLO",
			updatescheduleilodetails_1: "The iLO Smart Update Repository contains updates that are scheduled.<br>To cancel the queued scheduled updates and deploy a new set of updates, select a Baseline or Install Set.<br>To deploy the scheduled queued updates, select iLO Installation Queue and start a direct deploy. ",
			updatependingilodetails_1: "The iLO Smart Update Repository contains queued updates.<br>To cancel the queued updates and deploy a new set of updates, select a Baseline or Install Set.<br>To deploy the queued updates, select iLO Installation Queue and start a direct deploy. ",
			updatependingilodetails_2:".",
			updatependingilodetails_3:" and is scheduled at time ",
			updatependingilodetails_4: "<br>Do you want to deploy these updates? Then use this option to cancel the schedule and deploy.",
			okBtnDisabledDueRecoverySet: "OK button is disabled because using Recovery Install Set as a baseline is not supported. Use another baseline.",
			iLoInstallsetmgmtoption: "iLO Install Set management options",
			clearupdatelist: "Clear update list and add these components",
			appendComponenttolist: "Append these components to update list keeping existing updates in the list",
			detectiloinformation: "Discovering server version information. Please wait... ",
			selectiLOtaskORInstallsets: "OR",
			taskinprogresswarning_1: "Warning: ",
			taskinprogresswarning_2: " update is in progress wait until deployment is completed.<br>Auto refreshes in 30 seconds.",
			stillPendingUpdatesQueued: "There are still some updates queued on the iLO update list. This will replace those components",
			componentsinInstallset: "Total component(s) in the Install Set",
			blorInstallset: "Baseline or Install Set",
			iLOtaskQ: "iLO Installation Queue",
			taskQueueComponent: "Components"

            
        },
        server: {
            addServer: "Add server",
            advancedMemoryProtection: "Advanced Memory Protection",
            cpu: "CPU",
            controller: "Controller",
            controllerFV: "Controller Firmware Version",
            defaultStr: "Default",
            defaultEnabled: "Default enabled",
            defaultOn: "Default On",
            deviceWriteCache: "Device write cache",
            diskFV: "Disk Firmware Version",
            driverVersion: "Driver version",
            editSettings: "Edit settings",
            embeddedSataConfiguration: "Embedded SATA Configuration",
            embeddedSerialPort: "Embedded serial port",
            intelAmdVirtualizationTechnology: "Intel/AMD Virtualization Technology",
            intelHyperthreadingOptions: "Intel Hyper-threading options",
            intelTurboBoostTechnology: "Intel Turbo Boost Technology",
            intelVtdAmdVi: "Intel VT-d/AMD-Vi (IOMMU)",
            manageBios: "Manage BIOS",
            managedByFusion: "Managed by HPE OneView",
            memory: "Memory",
            associatediLO: "Associated iLO",
            associatedOA: "Associated OA",
            associatedServer: "Associated Server",
			osinstalled: "OS Installed",
            group: "Node Groups",
            modified: "Modified",
            modifiedSettings: "Modified settings",
            msExchange: "Microsoft Exchange 2010 Gold, 5000 Users",
            nicFcHbaCna: "NIC/FC-HBA/CNA",
            powerSupplyUnit: "Power Supply",
            serialNumber: "Serial Number",
            bay: "Bay ",
            noExecuteMemoryProtection: "No-Execute Memory Protection",
            noSupportedNicFcHbaCnaFound: "No supported NIC/FC-HBA/CNA found",
            noSupportedStorageArraysFound: "No supported storage arrays found",
            numlockPowerOnState: "NUMLOCK Power-On State",
            onlineSpareWithAdvancedEccSupport: "Online spare with advanced ECC support",
            npar: "nPar",
            optimizedForLowPower: "RM-Optimized for low power",
            optimizedForPerformance: "Optimized for performance",
            processorOptions: "Processor options",
            proliant: "ProLiant BL460c G7, mezz1",
			runNow: "Run Now (no schedule)",
            sataControllerOptions: "SATA controller options",
            serialNo: "Serial no",
            serialPortConfiguration: "COM2; IRQ3; IO: 2F8h-2FFh",
            serialPortOptions: "Serial port options",
            serverType: "Server model",
            storage: "Storage",
            systemOptions: "System options",
            systemRomVersion: "System ROM version",
            tbd: "TBD",
            virtualSerialPort: "Virtual serial port",
            virtualSerialPortConfiguration: "COM1; IRQ4; IO: 3F8h-3FFh",
            stage: "Stage",
            stageslashDeploy: "Stage/Deploy",
            stageandDeploy: "Stage and Deploy",
            stageDeploy: "Staged Deploy",
            startStageDeploy: "Start deploy after staging",
            scheduleStartTime: "Schedule Start Time",
            stageImmediatly: "Now",
			setSchedule: "Set Schedule",
            scheduled: "Scheduled",
			abortStage: "Abort Stage",
            stagedirectdeployDescription: " will copy all the relevant components from the baseline that is selected below to the remote node(s) along with SUM",
			directdeploySchedInfo: "Components will be staged immediately in case of Scheduled Direct deploy.",
			andInitiateDeploy: " and will initiate deploy."

        },
        shell: {
            serverFirmwareDistribution: "Server firmware distribution",
            switchPortsInUse: "Switch ports in use",
            terrabytesInUse: "Terabytes in use"
        },
        switchUI: {
            activeFirmwareVersion: "Active firmware version",
            adapterPort: "Adapter port",
            added: "Added",
            address: "Address",
            addressType: "Address type",
            addSwitch: "Add switch",
            allCategories: "All categories",
            average: "Average",
            bandwidthGbs: "Bandwidth GB/s",
            bitTransferRate: "Bit transfer rate",
            connectionState: "Connection state",
            connectivity: "Connectivity",
            connector: "Connector",
            deleted: "Deleted {0}",
            deletedNo: "Deleted",
            detailsTitle: "Details title",
            devices: "Devices",
            discoveredTime: "Discovered time",
            doThis: "do this",
            downlinks: "Downlinks",
            ethernet: "Ethernet",
            extended: "Extended",
            fibreChannel: "Fibre Channel",
            FTPUpdatesFailure: "FTP server on the SUM Service is currently not running. The switch inventory requires ftp server to be enabled and running. <br>Enable ftp port, restart the SUM service and then perform switch Inventory.",
            flexNic: "Flex NIC",
            hasStatus: "{0} has a {1}.",
            identifier: "Identifier",
            linkState: "Link state",
            noConnectionsDiscovered: "No connections discovered",
            networks: "Networks",
            oui: "OUI",
            packetTransferRate: "Packet transfer rate",
            partnerSwitch: "Partner switch",
            partNumber: "Part number",
            port: "Port",
            portDescription: "Port description",
            portId: "Port ID",
            portType: "Port type",
            received: "Received",
            receivedErrors: "Received errors",
            remoteConnection: "Remote connection",
            revision: "Revision",
            serialNumber: "Serial number",
            serverHardware: "Server hardware",
            serverProfile: "Server profile",
            speed: "Speed",
            statistics: "Statistics",
            systemDescription: "System description",
            systemName: "System name",
            toFixIt: "To <b>Fix</b> it, {0}",
            transmitErrors: "Transmit errors",
            transmitted: "Transmitted",
            transmittedErrors: "Transmitted errors",
            updated: "Updated",
            uplinks: "Uplinks",
            vendor: "Vendor",
            weHaveNoIdeaWhy: "Notification is undefined.",
            writtenFirmwareVersion: "Written Firmware Version",
            wwn: "WWN"
        },
        task: {
            active: "Active",
            alerts: "Alerts",
            allTime: "All time",
            assign: "Assign (TBD)",
            clear: "Clear",
            cleared: "Cleared",
            finished: "Finished",
            from: "From",
            lastUpdated: "Last updated",
            mine: "Mine",
            olderThan1Year: "Older than 1 year",
            olderThan3Months: "Older than 3 months",
            pending: "Pending",
            resetToDefaults: "Reset to defaults",
            running: "Running",
            selectAll: "Select all",
            source: "Source",
            specificDateRange: "Specific date range",
            to: "To",
            today: "Today",
            withinLastMonth: "Within last month"
        },
        integrityilo: {
            haspendingupdate: "Node has a pending firmware update",
            hasprevious: "{0} has a previous firmware update pending activation.",
            activateorcancel: "Activate or cancel pending firmware update.",
            activatepending: "Activate pending",
            pendingwarning: "Firmware updates cannot be performed on the node until the previous firmware update is either activated or canceled.",
            activatependingfw: "Activate the pending firmware update",
            activatependingWarning: "This will shutdown the OS on the node and let the firmware activation process complete",
            cancelpendingfw: "Cancel the pending firmware update",
            cancelpendingWarning: "WARNING: This may leave the system with an unbootable mix of iLO/System FW. Only use this if you are about to upgrade this server to a new version.",
            doDeployDomain: "Review and Deploy updates to Domain",
            deployDomain: "Deploy Domain",
            rebootToActivate: "Reboot node to activate firmware",
            rebootNotNeeded: "Reboot is not required. The node is powered off",
            activateOnNodeScreen: "Node has a pending firmware update. The pending firmware update can be activated or canceled from the node screen"
        },
        sd2oa: {
            activeFirmware: "Active Firmware",
            allDevices: "All Devices",
            bay: "Bay",
            blades: "Blades",
            cplxFW: "Complex Firmware",
            cplxMismatchDetails: "Complex mismatch details",
            complexName: "Complex Name",
            complexOnly: "Complex Only",
            complexVer: "Complex Version",
            fwBaseline: "Firmware Baseline",
            installedFW: "Installed Firmware",
            mismatch: "Mismatch",
            noActivePartitions: "No active partitions.",
            noBladesUnassigned: "No unassigned Blades.",
            noPartitions: "No available partitions.",
            number: "Number",
            parFW: "Partition Firmware",
            partitions: "Partitions",
            partitionsBlades: "Partitions / Blades",
            rebootActivePartitions: "Reboot active partitions",
            serialNumber: "Serial Number",
            unassignedBlades: "Unassigned Blades",
            vpars: "vPars"
        },
		sdflex: {
            systemName: "System Name",
            firmwareName: "Firmware Name",
            firmwareVersion: "Firmware Version",
            firmwareHealth: "Firmware Health",
            serialNumber: "Serial Number",
            uuid: "UUID",
			sdflexCompDisabledWarning: "Superdome Flex firmware component is disabled because installed firmware does not support updates when system is in powered on state. Power off the system, and re-run inventory to proceed with the update.",
            partitions: "Partitions",
            activeFirmware: "Active Firmware",
            nextFirmware: "Next Firmware",
            number: "Number",
            excludenparfw: "Exclude nPar Firmware",
            rebootToActivate: "Reboot nPar(s) to activate firmware",
            rebootNotNeeded: "Reboot is not required, nPar(s) are powered off"
        },
        moonshot: {
            chassisName: "Chassis Name",
            credentials: "iLO CM Administrator Credentials",
            edit: "Edit Moonshot switch credentials",
            enablePassword: "Enable Password",
            enterSwitchCredentials: "Enter switch credentials (Required only if switch firmware is to be updated)",
            failedtoValidateSwitchCredentials: "Failed to verify Moonshot switch credentials",
            invalidSwitchCredentials: "Invalid switch credentials",
            installedChassisVersion: "Installed chassis version",
            installedSwitchVersion: "Installed switch version",
            moonshotCompDisabledWarning: "Moonshot component is disabled as one or more m710 cartridges is in power on state. ",
            productName: "Product Name",
            noCartridges: "No cartridges found.",
            noSwitches: "No switches found.",
            noSwitchCredentialsSet: "Credentials are not set for the switch",
            noSwitchBCredentialsSet: "Credentials are not set for the switch B",
            serialNo: "Serial Number",
			switchAuthenticationPwd: "Password Authentication(Applies to XG and XGc only)",
            switchCredentials: "Switch Credentials",
            switchBCredentials: "Switch B Credentials",
			switchFullAuthentication: "Full Authentication",
            switchUseSameCredentials: "Credentials are the same on both switches",
            switchCompDisabledWarning: "Switch component is disabled because switch credentials were not entered, to enable it, go to the Edit node page to add the credentials. ",
            productID: "Product ID",
            uuid: "UUID",
			switchUsernameNotRequired  : "A username is not required when authentication is not enabled for the switch.",
			switchPasswordNotRequired  : " A password is not required when credentials are not set for the switch.",
			switchEnablePasswordNotRequired : "An enable password is not required when not configured for the switch."
        },
        ipdu: {
            extbars: "Ext Bars",
            noExtBars: "No supported Ext bars found.",
            paired: "Paired IPDU"
        },
        title: "Smart Update Manager ",
        welcome: {
            baselinesDescription: "Import software and firmware for use in deploying updates.",
            dashboardDescription: "Overview of what is happening with your infrastructure",
            getStarted: "Get started",
            scalableUpdateDescription: "Scalable update powered by iLO Federation",
            nodesDescription: "Manage, analyze, and deploy updates to nodes.",
            oneTouchUpdateDescription: "Simplified deployment in three steps."
        },

        AbortConfirm: {
            title: "Abort {0}",
            dependencyHeader: "{0} items depend on {1}",
            prompt: "Continue with delete?",
            ok: "Yes, Abort"
        },

        RebootConfirm: {
            title: "Reboot",
            dependencyHeader: "{0} items depend on {1}",
            errorReboot: "Error occurred while performing reboot operation.",
            node: "Node rebooted.",
            prompt: "Are you sure you want to reboot the node?",
            ok: "Yes, Reboot"
        },
        confirmation: {
            title: "Confirmation",
            dependencyHeader: "{0} items depend on {1}",
            prompt: "Are you sure you want to continue with the selected action?",
            promptDeploy: "Are you sure you want to continue with deploy?",
            ok: "Yes, Continue"
        },
        logout: {
            zeroScheduled: "0 tasks are currently scheduled.",
            logoutWarningMessage2: " tasks are currently scheduled. The SUM session must be left running for these to run. Logging off or shutting down SUM will cancel all the scheduled tasks.",
            closeBrowserConnection: "Close Browser Connection - Leave session and scheduled tasks running.",
            logoff: "Log Off - Current user.",
            shutdown: "Shutdown - This option will shutdown SUM engine.",
            title: "Log Off/Shutdown"
        },
        shutdown: {
            title: "Shutdown",
            shutdown: "Continue with shutdown of SUM engine?",
            ok: "Yes, Shutdown",
            cancel: "Cancel",
            shutdownButton: "Shutdown"
        },
        linuxAccess: {
            useAdminCredentials: "Use administrator credentials",
            useSudoWithCredentials: "Use sudo with credentials entered above",
            useSuperUserCredentials: "Use super user credentials"
        },
        ilofederation: {
            viewversion: "View all versions of :",
            ilotype: "iLO type",
            powerpictype: "PMC type",
            cpldtype: "CPLD type",
            isoimage: "ISO Image",
            filtering: "Filters",
			continueButton : "Continue",
			specifyBaselineOnlineDeploy : "Specify Baseline for Online Review/Deploy",
			specifyBaselineText : "A Baseline must be selected in order to continue to Online Review/Deploy",
            filterMsg: "Select a subset of servers within the group to perform the update on",
            groupInActiveSummary: "Group is being discovered",
            interfaceilo: "Interface iLO",
            onlinedeploymessage: "<br>Online Deploy applies the update while the OS is up and running.<br>Reboot may be needed to activate the update. Reboot must be done manually to activate.",
            inventoryError: "Inventory error",
            enterManual: "Enter an iLO manually by IP or DNS",
            offlinedeploymessage: "SUM will use iLO to mount the specified ISO image to all servers in the group and then reboot all of the servers in the group. If the ISO is a valid update ISO, all servers will run an automatic offline update and then reboot",
            additionalofflinedeploymessage: "All Applicable updates on the ISO baseline will be performed on the specified servers.",
            selected: "Selected",
            selectDiscovered: "Select from discovered list of member iLO IPs",
            useISOandhpsum: "Use local ISO image and SUM as HTTP server",
            useISOandother: "Use ISO on a user specified HTTP server",
            add: "Add group",
            edit: "Edit iLO federation group",
            editError: "Failed to edit iLO federation group",
            deletemsg: "Deleted iLO federation group",
            addedbyUser: "Auto discovered",
            iLOFederationGroup: "iLO Federation group",
            lastDiscovered: "Last discovered on",
            groupname: "iLO Federation group name",
            groupDescr: "iLO Federation group description",
            rebootAndDeploy: "Power off and Deploy",
            offlineDeployConfirmHeader: "Confirm Offline Deployment",
            offlineDeployConfirmMsg: " server(s) will be immediately powered off if needed and rebooted to the specified ISO to start automatic offline update.",
            confirmOk: "Continue with Reboot",
            filternotSelectedError: "Please select at least one server model filter",
            abortedGroup: "Aborted iLO Federation Group",
            abortConfirm: "Continue with abort operation?",
            validISOrequired: "Please enter a valid Service Pack for ProLiant ISO URL.",
            addGroup: "Add Group",
            powerByIloFederation: " - powered by iLO Federation",
            rescan: "Rescan",
            noIloDiscovered: "No iLO discovered",
            notOnNetwork: "Unable to find the previously discovered iLO Federation group on the network",
            selectall: "Select All",
            deselectall: "Deselect All",
            deleteConfirm: "Continue with the deletion of iLO Federation group?",
            addTextInfo: "Enter an existing iLO Federation group name for SUM to work with. iLO Federation groups can be created in the iLO management user interface.",
            addextraTextInfo: "After the iLO Federation group has been added, go to the Inventory page to complete setting up the group so SUM can work with it.",
            editTextInfo: "Edit group allows you to modify iLO Federation group information so SUM can work with the group. You cannot modify the contents of the group from SUM. The contents of the iLO Federation group can be modified in the iLO management user interface.",
            enterCredentialsDescription: "Please enter the credentials for the interface iLO IP address specified above.",
            iLOFederationFWItemDetails: "Inventoried firmware versions of the group",
            numNodes: "Group iLO node count",
            poweredOnServersCount: "Powered On servers count",
            serverModel: "Server Model",
            onlineDeploy: "Online deploy",
            validateInProgress: "Validating ISO image. Please wait...",
            isoUrlEmpty: "ISO image URL cannot be empty",
            gatherServerInfo: "must be performed to gather iLO Federation group member details",
            selectedModel: "Selected {0} for deploy, Click Apply Filters button to apply the filters",
            deselectedModel: "Deselected {0}, Click Apply Filters button to apply the filters",
            allselected: "All server models selected for deploy, Click Apply Filters button to apply the filters",
            alldeselected: "All server models deselected, Click Apply Filters button to apply the filters",
            requiredFieldMissing: "Required Field {0} is empty.",
            toassignInterfaceIlo: "to assign an interface iLO to this group",
            notDiscoveredinthisSession: "This iLO Federation group can not be discovered in this SUM session. Please rescan to check if this group still exists",
            gatherFwInfo: "must be performed to gather firmware details"
        },
        advanceMode: {
            upgradeBoth: "Upgrade Firmware and Software",
            upgradeFirmware: "Upgrade Firmware",
            upgradeSoftware: "Upgrade Software",
            downgradeFirmware: "Downgrade Firmware",
            downgradeSoftware: "Downgrade Software",
            downgradeBoth: "Downgrade Both",
            rewriteFirmware: "Rewrite Firmware",
            rewriteSoftware: "Rewrite Software",
            rewriteBoth: "Rewrite Both",
            firmware: "Downgrade & Rewrite Firmware",
            software: "Downgrade & Rewrite Software",
            both: "Downgrade & Rewrite Both",
            rebootDelay: "Reboot Delay (1 - 60 Minutes)",
            DeployDisabledDueToWarning: "Deploy is disabled due to warnings.Please select 'Ignore Warnings' to continue with deployment.",
            noComponentsSelectedFromAdvMode: "Deploy is disabled because node is already at baseline version or no components are selected. Either apply one or more installation options (if applicable), select or force components manually, or select associated nodes (if applicable) for deployment. ",
            InvalidEncryptionKey: "Deploy is disabled because encryption key is invalid or empty. Please enter a valid encryption key. ",
            DeployDisabledDueToDependencyFailure: "Deploy is disabled due to dependency failures. Please deselect components having dependency failures to continue with deployment. ",
            deployDisabledDueToMissingSigFile: "Deploy is disabled due to missing component signature files. Please deselect component(s) with missing signature files to continue with deployment. ",
            deployDisabledDueToMissingSigFileInAssocNode: "Deploy is disabled as some of the node(s) have missing component signature file(s). Please deselect component(s) with missing signature files to continue with deployment. ",
			deployDisabledDueToNameDesc:"Deploy is disabled as Name and Description in the iLo repository tab are incorrect. Please correct these values to proceed with deployment",
			deployDisabledDueToScheduleDateTime:"Deploy is disabled as Schedule From or To time in the iLo repository tab are incorrect. Please correct these values to proceed with deployment",
            StageDisabledDueToWarning: "Stage is disabled due to warnings.Please select 'Ignore Warnings' to continue with Stage.",
            StageDisabledDueTonoComponentsSelected: "Stage is disabled because node is already at baseline version or no components are selected. Either apply one or more installation options (if applicable), select or force components manually, or select associated nodes (if applicable) for stage. ",
            StageDisabledDueToDependencyFailure: "Stage is disabled due to dependency failures. Please deselect components having dependency failures to continue with staging. ",
            StageDisabledDueToMissingSigFile: "Stage is disabled due to missing component signature files. Please deselect component(s) with missing signature files to continue with staging. ",
			stageDisabledDueToNameDesc : "Stage is disabled as Name and Description in the iLO Repository tab are incorrect. Please correct these values to proceed with staging",
			deployDisabledDueToiLOCredentialsReqd: "Deploy is disabled because iLO credentials are required. Please enter iLO credentials to proceed with deployment",
			StageDisabledAsNoPrereqInstallPermission:"Stage is disabled as prerequisite components needs to be installed and user have not given the permission for prerequisite installation. Edit the node to give install prerequisite permission.",
			DeployDisabledAsNoPrereqInstallPermission:"Deploy is disabled as prerequisite components needs to be installed and user have not given the permission for prerequisite installation. Edit the node to give install prerequisite permission."

        },
        easymode: {
            InstallationOptions: "Installation Options",
            SkipDependencies: "Skip components with dependency failures",
            SelectWhenToReboot: "Slide bar to select reboot delay:",
            NeverReboot: "Never </br> Reboot",
            EnableDowngrade: "Enable Downgrade",
            EnableRewrite: "Enable Re-write",
            VMwareWarning: "VMware does not support Re-write of driver components",
            SwitchWarning: "Switch does not support downgrade of firmware components",		
            VCEncryptionsettings: "VC FIPS Encryption Settings",
            ILOActivateSettings: "Reboot node to activate firmware",
            DeployDisruptive:	"Selected components will be deployed. Some components may require a reboot to activate.",
            DeployNonRebootOnly: "Deploy only updates that do not require a reboot to activate",
            EncryptionSettings: "Encryption Settings",
            VCFIPSEncryption: "VC FIPS Encryption Settings",
            VCFIPSEncryptionKey: "Encryption Key *",
            VCFIPSKeyHelp:	"VC Domain is in FIPS mode. Encryption Key is mandatory </br>(minimum 8 characters)",
            RebootActivateFirmware: "Reboot node to activate firmware",
            ComplianceLevel: "Compliance Difference between Node and Baseline",
            ToggleButton: "Enable Advanced Mode for more options and to see component details",
            confirmMessage: "All User Selections on {0} Mode will be lost",
            EstimatedDeploymentTime: "Estimated Deployment Time",
            nodeType: "Type:&nbsp&nbsp&nbsp&nbsp&nbsp",
            NodeDetailsTitle: "Node details",
            baselineDetailsTitle: "Baseline details",
            nodeIPDNS: "IP/DNS:&nbsp&nbsp",
            CriticalUpdates: "Critical Updates",
            RecommendedUpdates: "Recommended Updates",
            OptionalUpdates: "Optional Updates",
            NonCategorized: "Non-Categorized",
            Compliant: "Compliant",
            NonCompliant: "Non-Compliant",
            SkipDependencyWarning: "Deploy is disabled due to dependency failures. Either enable Skip Components with Dependency Failures or switch to Advanced Mode to view more details.",
            NoComponentsToDeploy: "Deploy is disabled because node is already at baseline version or no components are selected. Either apply one or more installation options or switch to Advanced Mode to view more details.",
            SkipDependencyWarningtoStage: "Stage is disabled due to dependency failures. Either enable Skip Components with Dependency Failures or switch to Advanced Mode to view more details.",
            NoComponentsToStage: "Stage is disabled because node is already at baseline version or no components are selected. Either apply one or more installation options or switch to Advanced Mode to view more details.",
            Mins60: "60 Mins",
            ComplianceHelp: "The overall difference between the node and the selected baseline is shown. </br> The criticality and number of components that need an upgrade are used to show a relative compliance level.</br>� Installation options do not change this difference.",
            DonutHelp: "The number of selected components is shown broken down by criticality. </br> Selecting different installation options will change this value.",
            dataPopulationInProgress: "Node details are being populated. Please wait...",
            componentsSelectedForUpdate: "Components Selected for an Update",
            noUpdatesRequired: "No Updates Selected",
			totalSize: "Total Size : ",
			selectedComponents: "Selected components : ",
			size: "Size: ",
            componentsSelectedForStaging: "Components Selected for Staging",
            notApplicableForStaging: "Not applicable for Staged Deploy",
            StagingDonutHelp: "The number of components to be staged is shown broken down by criticality",
            DeployStaged: "Deploy Staged",
			StagingOptions : "Staging Options",
			StagingOptionsMessage : "Staging Options allow you to choose Downgrade, Rewrite and other settings.",
            cleanuponexit: "Clean up temporary files after deploy",
			cleanuponexitstage: "Clean up temporary files after stage",
            cleanupallonexit: "Clean up all debug logs and temporary files after deploy",
			cleanupallonexitstage: "Clean up all debug logs and temporary files after stage",
			chooseExistingInstallsetForDeleteStaging: "Manually manage iLO Repository space.<br> &emsp; &emsp;(Staging does not proceed if there is not enough free space.)",
            SkippingDependencies: "Skipping failed dependency components",
            partOfGroupMsg: "All actions are disabled as the Node is part of a group. To continue, remove this node from the group and inventory again",
            partOfGroupMsgDeploy: "All actions are disabled as the Node is part of a group. To continue, remove this node from the group",
            stageInfo: "Upload components and create installset only. No Deploy done.",
            deployInfo: "Upload components and create an install set if selected, then deploy components.",
            stageInProgress: "Stage in progress",
            stageAborted: "Stage aborted ",
			hours: "Hours",
			minutes: "Minutes",
			seconds: "Seconds"
        },
        thankyou: {
            closeBrowserConnection: "You can close the browser tab. SUM service will still run in background.",
            shutdown: "Smart Update Manager has been successfully shutdown",
            thank: "Thank you for using Smart Update Manager",
            reference_videos: "Some reference documentation and videos."
        }
    };
});
