// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {TypeRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var HostRoutes = ( function() {

        var CONTAINER = '#hp-page-container';
        var CHANGE_CONTAINER = '#hp-change-page-container';

        function HostRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) return;
                registered = true;
                
                router.map('host',
                    '/host/show' + urlFragment.pagePatternTerminal, {
                    enter: function (location, result) {
                        result.noAction();
                    }
                });

                router.map('host add',
                    '/host/add' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/host/add.html',
                            'hpsum/view/host/HostAddView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.map('host edit',
                    '/host/edit' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/host/edit.html',
                            'hpsum/view/host/HostEditView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                router.filter('host default redirector',
                    '/host' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show'));
                    }
                });

                router.map('host no route', '/host/.+', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/core/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new HostRoutes();
    }());

    return HostRoutes;
});
