// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {iloFederationRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var iloFederationRoutes = ( function() {

        var CONTAINER = '#hpsum-ilofederation-page .hp-details-pane';
        var CHANGE_CONTAINER = '#hp-change-page-container';
        var CONFIRM_CONTAINER = '#hp-dialog-container';

        function iloFederationRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.map('ilofederation show',
                    '/ilofederation/show' + urlFragment.pagePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require([//'text!hpsumpages/node/show.html', 
                        	'text!hpsumpages/ilofederation/show.html',
                            //'hpsum/view/node/NodeShowView',
                            'hpsum/view/ilofederation/iloFederationShowView',
                            'hpsum/model/ilofederation/iloFederationShowRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });

                router.map('ilofederation add',
                    '/ilofederation/add' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        
                        require(['text!hpsumpages/ilofederation/add.html',
                            'hpsum/view/ilofederation/iloFederationAddView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        
                    }
                });

                router.map('ilofederation edit',
                    '/ilofederation/edit' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        
                        require(['text!hpsumpages/ilofederation/edit.html',
                            'hpsum/view/ilofederation/iloFederationEditView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
             router.map('ilofederation inventory', '/ilofederation/inventory' +
				urlFragment.viewSinglePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/ilofederation/doinventory.html',
						'hpsum/view/ilofederation/iloFederationInventoryDView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
                
             
				router.map('ilofederation offlinedeploy',
                    '/ilofederation/offlinedeploy' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/ilofederation/offlinedeploy.html',
                            'hpsum/view/ilofederation/iloOfflineDeployView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.map('ilofederation onlinedeploy',
                    '/ilofederation/onlinedeploy' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/ilofederation/onlinedeploy.html',
                            'hpsum/view/ilofederation/iloOnlineDeployView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.map('ilofederation specifybaselineonline',
                    '/ilofederation/specifybaselineonline' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/ilofederation/specifybaselineonline.html',
                            'hpsum/view/ilofederation/iloSpecifyOnlineReview'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                                
               router.map('ilofederation reports', '/ilofederation/reports' +
				urlFragment.pagePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/reports.html',
						'hpsum/view/node/NodeReportsView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});



                router.map('ilofederation deploy-results', '/ilofederation/deploy-results' +
                urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function(location, result) {
                        require(['text!hpsumpages/node/install_results.html',
                        'hpsum/view/ilofederation/iloFederationDeployResults'],
                        function (page,view){
                            result.load(page,view);
                        });
                    }
                });
 
                router.filter('ilofederation default redirector',
                    '/ilofederation' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show'));
                    }
                });

                router.map('ilofederation no route', '/ilofederation/.+', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/core/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            };
        }

        return new iloFederationRoutes();
    }());

    return iloFederationRoutes;
});
