// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {EnclosureShowRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var ipduShowRoutes = ( function() {

        var CONTAINER = '#hpsum-ipdu-page .hp-details-show-view';

        function ipduShowRoutes() {

            var registered = false;
            var activityView = null;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.map('ipdu show overview',
                    '/ipdu/show/overview' +
                    urlFragment.viewSinglePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/ipdu/ipduOverview.html',
                            'hpsum/view/ipdu/IpduOverviewView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.map(' ipdu show overview multi',
                   '/ipdu/show/overview' +
                    urlFragment.viewMultiPatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/overview_multi.html',
                            'hpsum/view/node/NodeShowOverviewMultiView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        }
                    });
                
                
				router.map('ipdu ipdu overview', '/ipdu/show/ipdu/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/ipdu/ipduOverview.html',
						'hpsum/view/ipdu/IpduOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});

                router.filter('ipdu show default redirector',
                    '/ipdu/show' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show/overview'));
                    }
                });

                router.map('ipdu show no route', '/ipdu/show/.*', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new ipduShowRoutes();
    }());

    return ipduShowRoutes;
});
