// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {moonshotRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var moonshotRoutes = ( function() {

        var CONTAINER = '#hpsum-moonshot-page .hp-details-pane';
        var CHANGE_CONTAINER = '#hp-change-page-container';
        var CONFIRM_CONTAINER = '#hp-dialog-container';

        function moonshotRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.map('moonshot show',
                    '/moonshot/show' + urlFragment.pagePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/show.html',
                            'hpsum/view/node/NodeShowView',
                            'hpsum/model/moonshot/moonshotShowRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });
				//Human Factor changes req:HF03 dated 07/25/2014
                                router.map('moonshot add',
                    '/moonshot/add' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        
                        require(['text!hpsumpages/node/add.html',
                            'hpsum/view/node/NodeAddView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        
                     
                    }
                });
				//Human Factor changes req:HF03
                router.map('moonshot edit',
                    '/moonshot/edit' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                       
                        require(['text!hpsumpages/node/edit.html',
                            'hpsum/view/node/NodeEditView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        

                    }
                });
                
				// router for find action.
				router.map('moonshot find',
                    '/moonshot/find' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/find.html',
						'hpsum/view/node/NodeFind'],
                        function (page, view) {
                        	//routes.register();
                            result.load(page, view);
                        });
                    }
                });
				
             router.map('moonshot inventory', '/moonshot/inventory' +
				urlFragment.viewSinglePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/doinventory.html',
						'hpsum/view/node/NodeInventoryDView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
                
             
				router.map('moonshot deploy',
                    '/moonshot/deploy' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/deploy.html',
                            'hpsum/view/node/NodeDeployView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                                
               router.map('moonshot reports', '/moonshot/reports' +
				urlFragment.pagePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/reports.html',
						'hpsum/view/node/NodeReportsView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});


                router.map('moonshot deploy-results', '/moonshot/deploy-results' +
                urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function(location, result) {
                        require(['text!hpsumpages/node/install_results.html',
                        'hpsum/view/node/NodeDeployResults'],
                        function (page,view){
                            result.load(page,view);
                        });
                    }
                });
 
                router.filter('moonshot default redirector',
                    '/moonshot' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show'));
                    }
                });

                router.map('moonshot no route', '/moonshot/.+', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/core/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new moonshotRoutes();
    }());

    return moonshotRoutes;
});
