// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {sdflexRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var sdflexRoutes = ( function() {

        var CONTAINER = '#hpsum-sdflex-page .hp-details-pane';
        var CHANGE_CONTAINER = '#hp-change-page-container';
        var CONFIRM_CONTAINER = '#hp-dialog-container';

        function sdflexRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.map('sdflex show',
                    '/sdflex/show' + urlFragment.pagePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/show.html',
                            'hpsum/view/node/NodeShowView',
                            'hpsum/model/sdflex/sdflexShowRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });
				//Human Factor changes req:HF03 dated 07/25/2014
                                router.map('sdflex add',
                    '/sdflex/add' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        
                        require(['text!hpsumpages/node/add.html',
                            'hpsum/view/node/NodeAddView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        
                     
                    }
                });
				//Human Factor changes req:HF03
                router.map('sdflex edit',
                    '/sdflex/edit' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                       
                        require(['text!hpsumpages/node/edit.html',
                            'hpsum/view/node/NodeEditView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        

                    }
                });
                
				// router for find action.
				router.map('sdflex find',
                    '/sdflex/find' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/find.html',
						'hpsum/view/node/NodeFind'],
                        function (page, view) {
                        	//routes.register();
                            result.load(page, view);
                        });
                    }
                });
				
             router.map('sdflex inventory', '/sdflex/inventory' +
				urlFragment.viewSinglePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/doinventory.html',
						'hpsum/view/node/NodeInventoryDView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
                
             
				router.map('sdflex deploy',
                    '/sdflex/deploy' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/deploy.html',
                            'hpsum/view/node/NodeDeployView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                                
               router.map('sdflex reports', '/sdflex/reports' +
				urlFragment.pagePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/reports.html',
						'hpsum/view/node/NodeReportsView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});


                router.map('sdflex deploy-results', '/sdflex/deploy-results' +
                urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function(location, result) {
                        require(['text!hpsumpages/node/install_results.html',
                        'hpsum/view/node/NodeDeployResults'],
                        function (page,view){
                            result.load(page,view);
                        });
                    }
                });
 
                router.filter('sdflex default redirector',
                    '/sdflex' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show'));
                    }
                });

                router.map('sdflex no route', '/sdflex/.+', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/core/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new sdflexRoutes();
    }());

    return sdflexRoutes;
});
