// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {sdflexShowRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var sdflexShowRoutes = ( function() {

        var CONTAINER = '#hpsum-sdflex-page .hp-details-show-view';

        function sdflexShowRoutes() {

            var registered = false;
            var activityView = null;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.map('sdflex show overview',
                    '/sdflex/show/overview' +
                    urlFragment.viewSinglePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/sdflex/sdflexOverview.html',
                            'hpsum/view/sdflex/sdflexOverviewView'],
                        function (page, view) {
                            result.load(page, view);
                        });

                    }
                });

                router.map(' sdflex show overview multi',
                   '/sdflex/show/(unknown|host|windows|linux|vmware|hpux|ilo|ilo2|ilo3|ilo4| \
                     integrityilo2|integrityilo3|moonshot|switch|fc_switch|sas_switch|oa|sd2|sdx|sdflex|virtual_connect|ilo_federation)/overview' +
                    urlFragment.viewMultiPatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/overview_multi.html',
                            'hpsum/view/node/NodeShowOverviewMultiView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        }
                    });
                
               /* 
				router.map('sdflex sdflex overview', '/sdflex/show/sdflex/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/sdflex/sdflexOverview.html',
						'hpsum/view/sdflex/sdflexOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
				*/

                router.filter('sdflex show default redirector',
                    '/sdflex/show' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show/overview'));
                    }
                });

                router.map('sdflex show no route', '/sdflex/show/.*', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new sdflexShowRoutes();
    }());

    return sdflexShowRoutes;
});
