// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {TypeRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var ServerRoutes = ( function() {

        var CONTAINER = '#hpsum-servers-page .hp-details-pane';
        var CHANGE_CONTAINER = '#hp-change-page-container';
        var CONFIRM_CONTAINER = '#hp-dialog-container';

        function ServerRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.map('server show',
                    '/server/show' + urlFragment.pagePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/show.html',
                            'hpsum/view/node/NodeShowView',
                            'hpsum/model/server/ServerShowRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });
				//Human Factor changes req:HF03 dated 07/25/2014
                router.map('server add',
                    '/server/add' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        
                        require(['text!hpsumpages/node/add.html',
                            'hpsum/view/node/NodeAddView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        
                     
                    }
                });
				//Human Factor changes req:HF03
                router.map('server edit',
                    '/server/edit' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        
                        require(['text!hpsumpages/node/edit.html',
                            'hpsum/view/node/NodeEditView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        
 
                    }
                });
                
				// router for find action.
				router.map('server find',
                    '/server/find' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/find.html',
						'hpsum/view/node/NodeFind'],
                        function (page, view) {
                        	//routes.register();
                            result.load(page, view);
                        });
                    }
                });
				
             router.map('server inventory', '/server/inventory' +
				urlFragment.viewSinglePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/doinventory.html',
						'hpsum/view/node/NodeInventoryDView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
				
			router.map('server stage', '/server/stage' +
             	urlFragment.viewSinglePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function(location, result) {
                        require(['text!hpsumpages/node/deploy.html',
                        'hpsum/view/node/NodeDeployView'],
                        function (page,view){
                            result.load(page,view);
                        });
                    }
                });
                
				router.map('server directDeploy',
                    '/server/directdeploy' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
					    require(['text!hpsumpages/node/stage.html',
                        'hpsum/view/node/NodeDirectStagedDeployView'],
                        function (page, view) {
						    result.load(page, view);
                        });
                    }
                });
             
				router.map('server deploy',
                    '/server/deploy' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/deploy.html',
                            'hpsum/view/node/NodeDeployView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                                
               router.map('server reports', '/server/reports' +
				urlFragment.pagePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/reports.html',
						'hpsum/view/node/NodeReportsView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});


                router.map('server deploy-results', '/server/deploy-results' +
                urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function(location, result) {
                        require(['text!hpsumpages/node/install_results.html',
                        'hpsum/view/node/NodeDeployResults'],
                        function (page,view){
                            result.load(page,view);
                        });
                    }
                });
                
                router.filter('server default redirector',
                    '/server' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show'));
                    }
                });

                router.map('server no route', '/server/.+', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/core/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new ServerRoutes();
    }());

    return ServerRoutes;
});
