// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {ServerShowRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var ServerShowRoutes = ( function() {

        var CONTAINER = '#hpsum-servers-page .hp-details-show-view';

        function ServerShowRoutes() {

            var registered = false;
            var activityView = null;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.map('server show overview',
					'/server/show/overview' +
				urlFragment.viewSinglePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/server/overview.html',
                            'hpsum/view/server/ServerShowOverviewView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('server show each overview',
					'/server/show/(windows|linux|hpux)/overview' +
				urlFragment.viewSinglePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/server/overview.html',
                            'hpsum/view/server/ServerShowOverviewView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                router.map(' server show overview multi',
                   '/server/show/overview' +
                    urlFragment.viewMultiPatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/overview_multi.html',
                            'hpsum/view/node/NodeShowOverviewMultiView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        }
                    });
                
                router.map('server show activity',
                    '/server/show/activity' + urlFragment.viewPatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/activity/resource.html',
                            'hpsum/view/activity/ActivityResourceView'],
                        function (page, View) {
                            if (! activityView) {
                                activityView = new View();
                            }
                            result.load(page, activityView);
                        });
                    }
                });
                

                router.filter('server show default redirector',
                    '/server/show' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show/overview'));
                    }
                });

                router.map('server show no route', '/server/show/.*', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new ServerShowRoutes();
    }());

    return ServerShowRoutes;
});
