// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['jquery'], function() {
    (function($) {
        // jQuery plugin definition
        $.fn.hpTooltip = function(options) {
          
            function hpTooltip(elem) {
              
                var source;
                var tip;
				var tiptype;
                // forward reference to avoid a Sonar complaint
                var onMove;
                
                function hide(ev) {
					if (tip) {
                        $('body').off('mousemove', onMove);
                        $('body').off('click', onMove);
                        source.off('focus', hide);
                        source.off('click', hide);
                        tip.remove();
                        tip = null;
                    }
                }
                
                onMove = function(ev) {
					if (tip && ((ev.pageX < source.offset().left ||
                        (ev.pageX > (source.offset().left + source.outerWidth()))) ||
                        (ev.pageY < source.offset().top ||
                        (ev.pageY > (source.offset().top + source.outerHeight()))))) {
                        hide();
                    }
                };
                
                function onOver(ev) {
                    var refId, tipId, sourceOffset, tipStyle, tipWidth, tipHeight;
                    
                    if (! tip && source.attr('data-tooltip')) {
                        // add tooltip div
                        refId = source.attr('id');
                        tipId = refId + '-tooltip';
                        tip = $('<div id="' + tipId + '" class="hp-tooltip">' +
                            source.attr('data-tooltip') + '</div>');
                        if (source.parents('.hp-global').length > 0) {
                            tip.addClass('hp-global');
                        }
                        $('body').append(tip);
                        
                        tipWidth = tip.outerWidth();
                        tipHeight = tip.outerHeight();
                        
                        sourceOffset = source.offset();
                        tipStyle = {position: 'absolute',
                            top: sourceOffset.top - tipHeight - 10,
                            left: sourceOffset.left};
                        if (tipStyle.top < 0) {
                            // put it below
                            tipStyle.top = sourceOffset.top + source.outerHeight() + 10;
                            
                            if ((tipStyle.left + tipWidth) > $(window).width()) {
                                tipStyle.left = $(window).width() - tipWidth;
                                tip.css(tipStyle).addClass('hp-below-right');
                            } else {
                                tip.css(tipStyle).addClass('hp-below');
                            }
                        } else {
                            // keep it above
                            if ((tipStyle.left + tipWidth) > $(window).width()) {
                                tipStyle.left = $(window).width() - tipWidth;
                                tip.css(tipStyle).addClass('hp-above-right');
                            } else {
                                tip.css(tipStyle).addClass('hp-above');
                            }
                        }
						// debugger;
						// tip.css('top',(source.offset().top - 50)+'px');
						// tip.css('left',(source.offset().left)+'px');
						
                        if(tiptype == undefined){
							$('body').on('mousemove', onMove);
							$('body').on('click', onMove);
							source.on('focus', hide);
							source.on('click', hide);
						}
                        
                    }
                }

                function initialize(elem) {
                    // get 'tooltip' text
                    var text = $(elem).attr('tooltip');
					tiptype = $(elem).attr('tooltip_menu');
                    if (typeof options === 'string') {
                        text = options;
                    }

                    source = $(elem);
                    if(tiptype == undefined)
						source.attr('data-tooltip', text); // could remove it
					else
						source.attr('data-tooltip', tiptype); // could remove it
                    if ((text || tiptype) && ! source.hasClass('hp-tooltipped')) {
                        source.addClass('hp-tooltipped');
						if(tiptype == undefined)
							source.on('mouseenter', onOver);
						else
							onOver();
                        
                    }
                }

                initialize(elem);
            }

            // pluginify
            var instance, ret;
            this.each(function() {
				var $elem = $(this);
                instance = new hpTooltip($elem[0]);
                ret = ret ? ret.add($elem) : $elem;
            });
            return ret;

        };
    }(jQuery));
});
