// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {DashboardPresenter}
 */
define(['hp/services/IndexService',
    'hp/services/IndexFilter',
    'hp/core/EventDispatcher'], 
function(indexService, IndexFilter, EventDispatcher) {"use strict";

    var DashboardPresenter = ( function() {
      
        var STATII = ['error', 'warning', 'ok'];

        /**
         * @constructor
         */
        function DashboardPresenter() {
          
            var dispatcher = new EventDispatcher();
            var categories = [];
            
            function getSummaries() {
                var filter;
                var summaries = {};
                var pending = categories.length * (STATII.length + 1);
                $.each(categories, function (index, category) {
                    summaries[category] = {};
                    
                    filter = new IndexFilter();
                    filter.ensureDefaults(category, 0, 0);
                    summaries[category].total = -1;
                    indexService.getFilteredIndexResources(filter,
                        {success: function (indexResults) {
                            pending -= 1;
                            summaries[category].total = indexResults.total;
                            if (0 === pending) {
                                dispatcher.fire('summariesChange', summaries);
                            }
                        }}
                    );
                    
                    $.each(STATII, function(index, status) {
                        filter = new IndexFilter();
                        filter.ensureDefaults(category, 0, 0);
                        filter.setProperty('status', status);
                        summaries[category][status] = -1;
                        indexService.getFilteredIndexResources(filter,
                            {success: function (indexResults) {
                                pending -= 1;
                                summaries[category][status] = indexResults.total;
                                if (0 === pending) {
                                    dispatcher.fire('summariesChange', summaries);
                                }
                            }}
                        );
                    });
                });
            }
            
            /**
             * @public
             */
            this.init = function () {
            };
            
            this.resume = function () {
                getSummaries();
            };
            
            this.pause = function () {
            };
            
            this.setCategories = function (categoriesArg) {
                categories = categoriesArg;
            };
            
            /**
             * Add a listener for a specified event.
             * @public
             * @param {string} eventName The name of the event.
             * @param {function(...)}
             */
            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
            };
            
            this.off = function(eventName, callback) {
                dispatcher.off(eventName, callback);
            };
        }

        return new DashboardPresenter();
    }());

    return DashboardPresenter;
});
