// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/services/Log', 'jquery'], function(log) {"use strict";
    var SessionService = ( function() {

        /**
         * @type {SessionService}
         * @constructor
         */
        function SessionService() {
          
          	/**
             * Create the session for the log in credentials entered by user.
             */
            this.createSession = function(username, password, data, handlers) {
              
                $.ajax({
                    url : "/session/create",
                    type : 'POST',
                    contentType : "application/json",
                    data: JSON.stringify(data),
                    dataType : "json",
                    success : handlers.success,
                    error : handlers.error,
                    headers : {
                        "Accept-language" : '',
                        "Session-ID" : '',
                        "Session-KeepAlive": true
                    }
                });
            };
            
            /**
             * Accesses the session of the current logged in user.
             */
            this.accessSession = function(token, lang, handlers) {
              
                $.ajax({
                    url : "/session/" + token + "/getdata",
                    type : 'GET',
                    contentType : "application/json",
                    dataType : "json",
                    success : handlers.success,
                    error : handlers.error,
                    headers : {
                        "Accept-language" : lang,
                        "Session-ID" : token,
                        "Session-KeepAlive": true
                    }
                });
            };
			
			this.setMainMenuGuideText = function(token, lang, data){
			     $.ajax({
                    url : "/session/" + token + "/setmainmenuguidetext",
                    type : 'POST',
                    contentType : "application/json",
					data : JSON.stringify(data),
                    dataType : "json",
                    headers : {
                        "Accept-language" : lang,
                        "Session-ID" : token,
                        "Session-KeepAlive": true
                    }
                });	
			}
			
           this.numberOfSessions = function(token, lang, handlers) {
              
                $.ajax({
                    url : "/session/getSessions",
                    type : 'POST',
                    contentType : "application/json",
                    dataType : "json",     
                    success : handlers.success,
                    error : handlers.error,
                    headers : {
                        "Accept-language" : '',
                        "Session-ID" : token,
                        "Session-KeepAlive": true
                    }
                });
            };
			
			/*
			* authenticateUser 
			* Usage: Used to authenticate user and enable shutdown button on index page for valid users.
			*/
			this.authenticateUser = function(userName,password,handlers)
			{
				var data = { hapi: {
						username : userName,
						password : password
						}};
						
				$.ajax({
                    url : "/session/authenticateUser",
                    type : 'POST',
                    contentType : "application/json",
                    dataType : "json",     
					data: JSON.stringify(data),
                    success : handlers.success,
                    error : handlers.error,
                    headers : {
                        "Accept-language" : '',
                        "Session-ID" : '',
                        "Session-KeepAlive": true
                    }
                });		
			}
            
            /**
             * Closes the session of the current logged in user.
             */
            this.closeSession = function(token, lang, handlers) {
              
                $.ajax({
                    url : "/session/" + token + "/close",
                    type : 'GET',
                    contentType : "application/json",
                    dataType : "json",
                    success : handlers.success,
                    error : handlers.error,
                    headers : {
                        "Accept-language" : lang,
                        "Session-ID" : token,
                        "Session-KeepAlive": true
                    }
                });
            };
            
             /**
             * Shuts down the HPSUM service.
             */
            this.shutDown = function(token, lang, data, handlers) {
              
                $.ajax({
                    url : "/session/" + token + "/shutdown",
                    type : 'POST',
                    contentType : "application/json",
                    dataType : "json", 
					data : JSON.stringify(data),
                    success : handlers.success,
                    error : handlers.error,
                    headers : {
                        "Accept-language" : '',
                        "Session-ID" : token,
                        "Session-KeepAlive": true
                    }
                });
            };
			
			/**
             * 
             */
            this.isLocalhost = function(token, lang, handlers) {
              
                $.ajax({
                    url : "/session/isLocalhost",
                    type : 'POST',
                    contentType : "application/json",
                    dataType : "json",     
                    success : handlers.success,
                    error : handlers.error,
                    headers : {
                        "Accept-language" : '',
                        "Session-ID" : token,
                        "Session-KeepAlive": true
                    }
                });
            };
        }

        return new SessionService();
    }());
    return SessionService;
});
