// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

require.config({
    baseUrl : './',
    paths : {
        hp : '../../../../uihp/src/main/webapp/js/hp',
        fs : '../../../../uihp/src/main/webapp/js/fs',
        lib : '../../../../uihp/src/main/webapp/js/lib',
        text : '../../../../uihp/src/main/webapp/js/lib/text',
        use : '../../../../uihp/src/main/webapp/js/lib/use',
        mocha : '../../../../uihp/src/test/js/lib/mocha/mocha',
        chai : '../../../../uihp/src/test/js/lib/chai/chai',
        hpsum : 'js/hpsum',
        lang : 'js/hpsum/lang',
        hpPages : '../../../../uihp/src/main/webapp/pages',
        fsPages : '../../../../uihp/src/main/webapp/pages/fs',
        hpsumpages : 'pages/hpsum',
        tests : '../../test/js',
        'hp/services/authn' : 'js/hpsum/services/hpsumAuthn',
        'hp/services/authz' : 'js/hpsum/services/hpsumAuthz',
        jquery : '../../../../uihp/src/main/webapp/js/lib/jquery-1.7.1',
        jqueryUI : '../../../../uihp/src/main/webapp/js/lib/jquery-ui-1.8.16.piano.min',
        modernizr : '../../../../uihp/src/main/webapp/js/lib/modernizr'
    },
    priority : ['modernizr', 'jquery'],
    waitSeconds : 20,
    use : {
      "mocha": {},
      "chai": {attach: "chai"}
    }
});

require(['hp/Application',
    'hpsum/shell/MainPageRoutes',
    'mocha', 'chai',
    'jquery', 'jqueryUI', 'modernizr'],
function(application, routes, Mocha, chai) { "use strict";

    $.ajaxSetup({
        // Disable caching of AJAX responses for development
        cache : false
    });
    $(document).ready(function() {

        application.init("HPSUM");

        routes.load();

        mocha.setup('bdd');
        chai.should();

        application.start();

        $('#hp-test-start').click(function () {
            require(['tests/test'],
            function(Test) {
                mocha.run();
            });
        });
    });
});
