// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

require.config({
    baseUrl : './',
    paths : {
        //If you changed something here, you should change it in src/tour/build/tour.build.js
        //and consider if changes need to be made to src/main/webapp/js/cic/shell-require.js
        hp : 'js/hp',
        fs: 'js/fs',
        lib : 'js/lib',
        text : 'js/lib/text',
        use : 'js/lib/use',
        mocha : 'js/lib/mocha/mocha',
        chai : 'js/lib/chai/chai',
        hpsum : 'js/hpsum',
        lang : 'js/hpsum/lang',
        hpPages : 'pages',
        fsPages : 'pages/fs',
        hpsumpages : 'pages/hpsum',
        tests : 'js',
        'hp/services/authn' : 'js/hpsum/services/hpsumAuthn',
        'hp/services/authz' : 'js/hpsum/services/hpsumAuthz',
        jquery : 'js/lib/jquery-1.7.1',
        jqueryUI : 'js/lib/jquery-ui-1.8.16.piano.min',
        modernizr : 'js/lib/modernizr'
    },
    priority : ['modernizr', 'jquery'],
    waitSeconds : 20,
    use : {
      "mocha": {},
      "chai": {attach: "chai"}
    }
});

require(['hp/Application',
    'hpsum/shell/MainPageRoutes',
    'mocha', 'chai',
    'jquery', 'jqueryUI', 'modernizr'],
function(application, routes, Mocha, chai) { "use strict";

    $.ajaxSetup({
        // Disable caching of AJAX responses for development
        cache : false
    });
    $(document).ready(function() {

        application.init("HPSUM");

        routes.load();

        mocha.setup('bdd');
        chai.should();

        application.start();

        $('#hp-test-start').click(function () {
            require(['tests/test'],
            function(Test) {
                mocha.run();
            });
        });
    });
});
