// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type (BaselineCustomView)
 * This is a view class for Custom Baseline Add menu option.
 */
define(['hpsum/presenter/baseline/BaselinePresenter',
	'hp/core/Router',
    'hp/core/Notifications',
	'hp/core/HelpMenu',
    'hp/core/Localizer',
    'hp/view/DialogView',
    'hpsum/presenter/baseline/BaselinePresenter',
    'hp/view/FormStateView',
    'hp/model/Session',
    'hp/view/DialogView',
	'hp/lib/jquery.hpTooltip',
    'text!hpsumpages/common/confirm_dialog.html',
    'jquery',
    'hpsum/common/jquery.hpsumBrowse',
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpToggle',
	'hp/lib/jquery.hpSearchCombo',
	'lib/jquery-ui-timepicker-addon'],
function(presenter, router, notifications, helpMenu, localizer, DialogView, BaselinePresenter, FormStateView, session, dialogview, dialogContent) { "use strict";

    var BaselineCustomView = (function() {
      
        var FORM = '#hpsum-custom-baselines-add-form',
        	SAVEAS = '#hpsum-custom-baselines-saveas',
        	CREATE = '#hpsum-custom-baselines-create',
        	RESET = '#hpsum-baselines-reset',
            CANCEL = '#hpsum-custon-baselines-close',
			ADDBASELINE = '#hpsum-cbl-add-baseline-button',
			PANEL_SELECTOR = '#hpsum-cbl-panel-selector',
			COMPONENT_TYPE = '#component-type',
            PANELS = '#hpsum-custom-baselines-panels',
			COLLAPSE = '#hpsum-custom-baseline-collapsible',
			COLLAPSE_SYSTEM = '#hpsum-custom-baseline-collapsible-system',
			COLLAPSE_STORAGE = '#hpsum-custom-baseline-collapsible-storage',
			COLLAPSE_NIC = '#hpsum-custom-baseline-collapsible-nic',
			COLLAPSE_FCHBA = '#hpsum-custom-baseline-collapsible-fchba',
			COLLAPSE_ADVFILTERS = '#hpsum-custom-baseline-collapsible-advfilters',
			COLLAPSE_ARCH = '#hpsum-custom-baseline-collapsible-arch',
			COLLAPSE_DEVTYPE = '#hpsum-custom-baseline-collapsible-devtype',
			COLLAPSE_OSTYPE = '#hpsum-custom-baseline-collapsible-ostype',
			COLLAPSE_HWTYPE = '#hpsum-custom-baseline-collapsible-hardwaretype',
			COLLAPSE_HWTYPE_DL = '#hpsum-custom-baseline-collapsible-hardwaretype-DL',
			COLLAPSE_HWTYPE_ML = '#hpsum-custom-baseline-collapsible-hardwaretype-ML',
			COLLAPSE_HWTYPE_BL = '#hpsum-custom-baseline-collapsible-hardwaretype-BL',
			COLLAPSE_HWTYPE_SL = '#hpsum-custom-baseline-collapsible-hardwaretype-SL',
			COLLAPSE_HWTYPE_XL = '#hpsum-custom-baseline-collapsible-hardwaretype-XL',
			COLLAPSE_HWTYPE_WS = '#hpsum-custom-baseline-collapsible-hardwaretype-WS',
			COLLAPSE_HWTYPE_APOLLO = '#hpsum-custom-baseline-collapsible-hardwaretype-APOLLO',
			COLLAPSE_HWTYPE_MICROSERVER = '#hpsum-custom-baseline-collapsible-hardwaretype-MICROSERVER',
			COLLAPSE_HWTYPE_OTHERSERIES = '#hpsum-custom-baseline-collapsible-hardwaretype-OTHERSERIES',
			COLLAPSE_HWTYPE_SYNERGY = '#hpsum-custom-baseline-collapsible-hardwaretype-Synergy',
			COLLAPSE_CATEGORY = '#hpsum-custom-baseline-collapsible-specific-comp-category',
			COMPONENT_CATEGORY = '#hpsum-custom-baseline-category-',
			COMPONENT_CATEGORY_BIOS = '#hpsum-custom-baseline-category-BIOS',
			COMPONENT_CATEGORY_FIRMWARE = '#hpsum-custom-baseline-category-Firmware',
			COMPONENT_CATEGORY_SOFTWARE = '#hpsum-custom-baseline-category-Software',
			COMPONENT_CATEGORY_DRIVER = '#hpsum-custom-baseline-category-Driver',
			DESCR = '#hpsum-custom-baselines-descr',
			VERSION = '#hpsum-custom-baselines-version',
			VERSION1 = '#hpsum-custom-baselines-version1',
			DATE_VERSION = '#hpsum-custom-baselines-datepicker-version',
			VERSION2 = '#hpsum-custom-baselines-version2',
			ROUTE_PREFIX = '/baseline/custom',
			HARDWARE_TYPE = '#hpsum-hardware-type',
			OPERATING_SYSTEM = '#hpsum-operating-system-type',
			CUSTOM_PANEL = '#hpsum-custom-baselines-panels',
			MATRIX_PATH = '#hpsum-vbl-location-path',
			LOCATION_TYPE = '#hpsum-vbl-location-type',
			PROXY_OPTIONS = '#hpsum-vbl-proxy-options',
            CSM_VERSION = '#hpsum-csm-version',
            BROWSE_MATRIX_LOCATION_BUTTON = '#hpsum-vbl-browse-location',
            BROWSE_MATRIX_LOCATION_ERROR = '#hpsum-vbl-invalid-location-error',
            TOTAL_SUMMARY = '#hpsum-vbl-total-summary',
            MISSING_SUMMARY = '#hpsum-vbl-missing-summary',
            SPLASH_DIALOG = '#hpsum-validate-wait-dialog',
            SPLASH_SPINNER = '#hpsum-validate-spinner',
            RETRIEVE_MATRIX_BUTTON = '#hpsum-baselines-getmatrix',
			MATRIX_LABEL = '#hpsum-vbl-location-label-path',
			INVALIDSIG_WARNING = '#hpsum-cbl-invalidcomp-warn',
			FWPKG_SUM_LOW_VERSION='#hpsum-cbl-fwpkgcomp-warn'; //SUM version lower than MIN_SUM_VER_FWPKG warning label
            
     	var 	CREATEISO_CHKBOX = '#chkbox-createiso',
     		BOOTABLEISO_CHKBOX = '#chkbox-bootableiso',
     		MATCHMATRIXVERSION_CHKBOX = "#chkbox-match-csm-version",
     		OAEFM_CHKBOX = "#chkbox-oaefm",
     		SELECT_COMPTYPE = '#select-comptype',
     		SOURCES_TABLE = '#baseline-sources-table',
     		COMPONENTS_TABLE = '#hpsum-cbl-table-review',
     		COMPONENTS_CSM_TABLE = '#baseline-validate-table',
     		BASELINE_NAME_LABEL = '#hpsum-custom-baselines-id',
     		TARGET_BROWSE_BUTTON = '#hpsum-cbl-browse-target',
     		ISO_BROWSE_BUTTON = '#hpsum-cbl-browse-iso',
     		CONFIRM_DIALOG = '#hpsum-confirm-dialog',
     		HPSUM_SOURCE_LOCATION_OPTION = '#custom-baseline-hpsum-source-location',
     		HPSUM_SOURCE_LOCATION_TYPE = '#custom-baseline-hpsum-source-location-type',
     		HPSUM_VERSION_SELECTED = "hpsum-cbl-version-selected",
     		NONUEFI_CHECKBOX = "#hpsum-cbl-chkbox-nonUEFI-bootableiso",
     		APPLYFILTERS_MSG = "#hpsum-cbl-applyfilters-msg-label",
			SYNERGY_CONTENTS ="#dev-synergy-enclosure",
			SYNERGY_CHKBOX ="#chkbox-dev-synergy-enclosure",
	    	NO_COMP_SELECTED = true,
	    	MAX_DESCR_LENGTH = 50,
	    	MAX_VER_LENGTH = 10,
			HP_PROLIANT = "HP ProLiant ",
			HPE_PROLIANT = "HPE ProLiant ",
			HPE_SYNERGY = "HPE Synergy ",
			HPE_APOLLO = 'HPE Apollo ',
			COMPONENTS_COUNT_LABEL = "#hpsum-cbl-comp-count-msg",
			HPE_SOFTWARE = "Software",
			HPE_FIRMWARE = "Firmware",
			HPE_BIOS = "BIOS",
			HPE_DRIVER = "Driver",
			ELEMENT_PER_ROW = 3,
			VALUE_BLADE = "Firmware - Blade Infrastructure",
			VALUE_FRAME = "Firmware - Frame Infrastructure",
			OTHERS_VALUE = "Others",
			CATEGORY_SOFTWARE = '#hpsum-category-type-Software',
			CATEGORY_FIRMWARE = '#hpsum-category-type-Firmware',
			CATEGORY_BIOS = '#hpsum-category-type-BIOS',
			CATEGORY_DRIVER = '#hpsum-category-type-Driver',
			HPSUM_CATEGORY = '#hpsum-category-type-',
			LOCATION = "location",
		ENTER_KEY = 13,		
		baslinesAdded = 0;
		var filtered_comp_list = [];
		var hpsum_current_directory = '',
			hpsum_version = '';
		var TARGET_LOC_BROWSE = '#hpsum-custom-baselines-targetloc',
			ISO_LOC_BROWSE = '#hpsum-custom-baselines-isoloc',
			CSM_LOC_BROWSE = '#hpsum-cbl-csm-filter-browse',
			HPSUM_LOC_BROWSE = '#custom-baseline-source-hpsum-path',
			CUSTOM_INPUT_BROWSE_TEXT = '#hpsum-custom-baselines-targetloc-hpsumBrowse-input-text',
			CUSTOM_INPUT_SOURCE_TEXT ='#custom-baseline-source-hpsum-path-hpsumBrowse-input-text';
		var totalOSRequest = 0;
		var completedOSRequest = 0;
		var errorOSRequest = 0;
		var isHPSUMBrowseButtonClicked = false;
		var isxorriso_present = true;
		var restOsInfoCount = 0;
		var restHwInfoCount = 0; 
		var uniqueCategory = [];
		var REBOOT_REQ_DETAILS_REQUIRED = "Required",
			REBOOT_REQ_DETAILS_NO = "No",
			REBOOT_REQ_DETAILS_YES = "yes",
			REBOOT_REQ_DETAILS_OPTIONAL = "Optional",
			REBOOT_REQ_DETAILS_ENVIRONMENTDEPENDENT = "Environment Dependent",
			REBOOT_DEFAULT_NO = false,
			REBOOT_DEFAULT_YES = true,
			SLES_15 = "SLES 15";
		
		var UI_DATEPICKER_DIV = "#ui-datepicker-div";
		var MIN_SUM_VER_FWPKG=835;//minmum sum version supported for fwpkg selection
		var gblHPESUMVersion="";
		
        /**
         * Constructor
         */
        function BaselineCustomView() {
            var berror = false;
			var errorDetails = '';
			var addInProgress = false;
			var operating_system_new = new Array();
			var hardware_checked_final = new Array();
			var operating_system_final = new Array();
			var category_checked_final = new Array();
			var components_hardware_checked = new Array();
			var components_operating_system = new Array();
			var hardware_info = new Array();
			var category_info = [];
			var operating_system_array = new Array();
            var browseDialogContents;
			var confirmDialogContents;
            var selectedTablesID = [];
            var filtered_comp_list = {};
            var compDoneCount = 0;
            var comp_selector_list;
            var compTimer;
            var updatingCompTable = false;
			var operating_system_list;
			var dl_array = [];
			var ml_array = [];
			var bl_array = [];
			var sl_array = [];
			var xl_array = [];
			var ws_array = [];
			var otherseries_array = [];
			var synergy_array = [];
			var firmware_cat_array = new Array();
			var software_cat_array = new Array();
			var driver_cat_array = new Array();
			var bios_cat_array = new Array();
			var list_os;
			var bundle_os_id;
			var session_address;
			var bundle_id;
			var waitDialog;
			var proxyOptionValue;
			var csmfilterselected = false;
			var nodeTable = null; 
			var disable_hardwareFilter_flag = false;
			var contains_gen10_flag = false;
			var baselineLog;
			var internal_error_flag = false;
            var CreateCustomBaselinehandlers =	{
                    			success : function(data) {
                        			createCustomBaselineOnCreateSuccess(data);
                    		 	},
                    			error : function(errorInfo) {
                        			createCustomBaselineError(errorInfo);
                    			}
                		};
            
            var formStateView = new FormStateView();
            var oTableBaselines;
            var totalCompCount=0, filterCompCount=0, selectedCompCount=0;
          
            function onItemAddSuccess(item) {
                
            }

            /**
             * @private
             */
            function onItemAddError(errorMessage) {
                notifications.show(errorMessage, 'error');
                addInProgress = false;
                $(CANCEL).trigger('click');
            }

            
            
            /**
             * @private
             * Call presenter's addItem() to add a new baseline item into Indexservice
             */
            function onCreate(bsaveas) {
				//Validate the input before proceeding with adding new custom baseline
				var berror = false;
				var errorDetails = '';
				var descr = $(DESCR).val(); 
				if (descr.length <= 0 )
				{
					$('#hpsum-cbl-descr-error').html(localizer.getString("hpsum.baseline.custom.descriptionRequired"));
					berror = true;
					errorDetails = '<p>' + localizer.getString("hpsum.baseline.custom.descriptionRequired") + '</p>';
				}
				
				if (descr.length > MAX_DESCR_LENGTH) { 
		 			$('#hpsum-cbl-descr-error').html(localizer.getString("hpsum.baseline.custom.maxlen") + MAX_DESCR_LENGTH);
		 			berror = true;
					errorDetails = '<p>' + localizer.getString("hpsum.baseline.custom.maxlen") + MAX_DESCR_LENGTH + '</p>';
				}
				
				if($(VERSION2).val().length <= 0)
				{
					$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.versionRequired"));
					berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.versionRequired") + '</p>';
				}
				
				if($(VERSION2).val().length > MAX_VER_LENGTH)
				{
					$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.maxlen") + MAX_VER_LENGTH);
					berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.maxlen") + MAX_VER_LENGTH + '</p>';
				}
				
				var instTargetLocBrowse = $(TARGET_LOC_BROWSE).data('plugin_hpsumBrowse');
				if(instTargetLocBrowse && instTargetLocBrowse.getLocation().length <=0)
				{
					$('#hpsum-cbl-targetloc-error').html(localizer.getString("hpsum.baseline.custom.targetlocRequired"));
					berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.targetlocRequired") + '</p>';
				}

				var descrcheck = /^[\w\-\s]+$/;   
					
			    if ( !descrcheck.test(descr) )
			    {       				
			    	$('#hpsum-cbl-descr-error').html(localizer.getString("hpsum.baseline.custom.descriptionValidationMsg"));
		 			berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.descriptionError") + localizer.getString("hpsum.baseline.custom.descriptionValidationMsg") + '</p>';
		 		}
				
				//var versioncheck = /^[\d]+$/;   
					
			   // if ( !versioncheck.test($(VERSION2).val()) )
			    if ($(VERSION2).val() == '')
			    {       				
			    	$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.versionIdentifierError"));
		 			berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.versionError") + localizer.getString("hpsum.baseline.custom.versionIdentifierError") + '</p>';
		 		}
				
				
				
				var instIsoLocBrowse = $(ISO_LOC_BROWSE).data('plugin_hpsumBrowse');
				if($(BOOTABLEISO_CHKBOX)[0].checked && instIsoLocBrowse && instIsoLocBrowse.getLocation().length <=0) 
				{
					$('#hpsum-cbl-isoloc-error').html(localizer.getString("hpsum.baseline.custom.isolocRequired"));
					berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.isolocRequired") + '</p>';
				}
				
				if($(BOOTABLEISO_CHKBOX)[0].checked && isxorriso_present == false && $(NONUEFI_CHECKBOX)[0].checked == false) {
					berror = true;
					$('#hpsum-cbl-chkbox-nonUEFI-bootableiso-error').html(localizer.getString("hpsum.baseline.custom.nonUEFIisoError"));
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.nonUEFIisoError") + '</p>';
				}

				var hpsumPath = '';
				var hpsumSourceType = 'do_not_include';
				
				var instHPSUMLocBrowse = $(HPSUM_LOC_BROWSE).data('plugin_hpsumBrowse');
				
				// Check HP SUM source selection type and location
				if ($(HPSUM_SOURCE_LOCATION_OPTION).val() != 'DNI' && instHPSUMLocBrowse)
				{
					hpsumPath = instHPSUMLocBrowse.getLocation();
					if (hpsumPath.length <=0)
					{
						$('#hpsum-cbl-isoloc-error').html(localizer.getString("hpsum.baseline.custom.hpsumlocationRequired"));
						berror = true;
						errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.hpsumlocationRequired") + '</p>';	
					}
				}
				
				if ($(HPSUM_SOURCE_LOCATION_OPTION).val() == 'ISD')
					hpsumSourceType = 'iso_location';
				else if ($(HPSUM_SOURCE_LOCATION_OPTION).val() == 'CWD')
					hpsumSourceType  = 'current_location';
				else if ($(HPSUM_SOURCE_LOCATION_OPTION).val() == 'CD')
					hpsumSourceType = 'custom_location';
					
				if(berror)
				{
					formStateView.setMessage({
                                summary: localizer.getString("hpsum.baseline.custom.validationErrorMsg"),
                                status: 'error',
                                details: errorDetails});
                                
					return false;
				}
					
				var verstr = $(DATE_VERSION).val();
				verstr = verstr.replace(/\-/g, '.');
				verstr = verstr + '.' + $(VERSION2).val();
				
				var bundlename = $(BASELINE_NAME_LABEL).html();
				
				var criticalityopt = '';
				if($('#chkbox-critical')[0].checked)
				{
					criticalityopt = "critical";
				}
				
				if($('#chkbox-recommended')[0].checked){
					if(criticalityopt.length > 0)
						criticalityopt += "|" + "recommended";
					else
						criticalityopt = "recommended";
				}
				
				if($('#chkbox-optional')[0].checked){
					if(criticalityopt.length > 0)
						criticalityopt += "|" + "optional";
					else
						criticalityopt = "optional";
				}
				
				var oslist = [], devicelist = [];
				//if($('#chkbox-os-win2k3r2')[0].checked) {
				//	oslist.push('Window2003');
				//}
				
				var updatetype='';
				
				if($(SELECT_COMPTYPE).val().toLowerCase().match(/both/i))
                {
                	updatetype = 'software|firmware';	
                }
                
                if($(SELECT_COMPTYPE).val().toLowerCase().match(/software/i))
                {
                	updatetype = "software";
                }
                
                if($(SELECT_COMPTYPE).val().toLowerCase().match(/firmware/i))
                {
                	updatetype = "firmware";
                }
				
				var isolocation = '';
				// Fix for QXCR1001408592, get ISO location only when bootable ISO is selected
				if($(BOOTABLEISO_CHKBOX)[0].checked && instIsoLocBrowse) {
					isolocation = instIsoLocBrowse.getLocation(); 
				}
					 
				var targetlocation = '';
				if(instTargetLocBrowse) 
					targetlocation = instTargetLocBrowse.getLocation(); 
				
				var bcreateiso = false, bbootableiso = false;
				if($(CREATEISO_CHKBOX)[0].checked)
					bcreateiso = true;
					
				if($('#chkbox-bootableiso')[0].checked)
					bbootableiso = true;
				
					
				var archopt='';
				if($('#chkbox-arch-x86')[0].checked)
				{
					archopt = "x86";
				}
				
				if($('#chkbox-arch-x64')[0].checked){
					if(archopt.length > 0)
						archopt += "|" + "x64";
					else
						archopt = "x64";
				}
				
				var createoaefm = false;
				if ($(OAEFM_CHKBOX)[0].checked) {
					createoaefm = true;
				}

				var serverlist = [];
				/*if($('#chkbox-server-dl380')[0].checked) {
					serverlist.push('Window2003')
				}*/
				
				var selBaselines = [];
				
				for(var i=0; i < selectedTablesID.length; i++)
				{
					var oTable = $(selectedTablesID[i].table_id).dataTable();
					if(oTable == undefined)
						continue;
					
					// This will clear out search strings and will repopulate all the rows
					oTable.fnFilter('');
					
					var allRows = $(selectedTablesID[i].table_id + ' tbody tr');
					
					var comps = oTable.fnGetData();
					var components = [];
					
					for(var tmp=0; tmp < allRows.length; tmp++){
		 				var compData = oTable.fnGetData(allRows[tmp].rowIndex-1);
		 				
		 				var bselected = false, bforce = false;
		 				
		 				if(allRows[tmp].className.indexOf('hp-selected') != -1)
		 					bselected = true;
		 				else
		 					bselected = false;
		 					
		 				if(bselected && (compData.baselineid === selectedTablesID[i].baseline) && (compData.locationid === selectedTablesID[i].location))
		 					components.push(compData.component_file_name);
		 			}
					
					var baselineinfo = {
					          baseline_name : selectedTablesID[i].baseline,
					          location_id : selectedTablesID[i].location,
					          component: components
					       };
					
					selBaselines.push(baselineinfo);	
				}
				bcreateiso = !bsaveas;
				if(bsaveas) {
					bbootableiso = false;
					CreateCustomBaselinehandlers.success = function(data) {
                    			createCustomBaselineOnSaveSuccess(data);
                    	 	};
				} else {
					CreateCustomBaselinehandlers.success = function(data) {
                    			createCustomBaselineOnCreateSuccess(data);
                    	 	};
				}
								
				var item = {
					  hapi: {
					    bundle_name: bundlename,
					    bundle_header: descr,
					    criticality: criticalityopt,
					    os_type_list: {
					      os_type: oslist
					    },
					    device_type_list: {
					      device_type: devicelist
					    },
					    update_type: updatetype,
					    target_location: targetlocation,
					    iso_location: isolocation,
					    hpsum_source_path : hpsumPath,
					    hpsum_source_type : hpsumSourceType,
					    create_ISO: bcreateiso,
					    bootable_ISO: bbootableiso,
					    version: verstr,
					    architecture: archopt,
					    create_oaefm_iso: createoaefm,
					    server_type_list: {
					      server_name: serverlist
					    },
					    baseline_list: {
					      baseline: selBaselines
					    }
					  }
					}; 
				
				if(! addInProgress) {
                    addInProgress = true;
                    $("#hpsum-custom-baselines-add-form :input").prop("disabled", true);
                    
					presenter.getCBStatus(item, {
						success : function(data) {
									var customBaselineProcessesSupported  = data.hapi.customBaselineProcessesSupported;
									var customBaselineProcessesInProgress = data.hapi.customBaselineProcessesInProgress;
									if( customBaselineProcessesInProgress < customBaselineProcessesSupported) {
										addInProgress = true;
										$("#hpsum-custom-baselines-add-form :input").prop("disabled", true);
                    
										formStateView.setMessage({summary: localizer.getString("hpsum.baseline.custom.createCBLMsg"),
										status: 'unknown', changing: true});
                    
										presenter.createCustomBaseline(item, CreateCustomBaselinehandlers);
									}
									else 
									{
										addInProgress = false;
										var value = localizer.getString('hpsum.baseline.custom.customCreateMsgInProgress', 
																					[data.hapi.customBaselineProcessesInProgress]);
										formStateView.setMessage({
										summary: 'Failed to create Custom Baseline',
										status: 'error',
										details: value,
										});
										$("#hpsum-custom-baselines-add-form :input").prop("disabled", false);
										enableAll();
									}
                    		 	},
                    			error : function(data) {
                    			}
						}
					);
                }
				
				return false;
            }
            
            function createCustomBaselineOnSaveSuccess(data) {
            	getCustomBaselineStatusUpdate(data, "SAVE");
            }
			
            function createCustomBaselineOnCreateSuccess(data) {
            	getCustomBaselineStatusUpdate(data, "CREATE");
            }
			
            // Fix for QXCR1001408695
            // On acceptiing SaveBaseline or Create Baseline command successfully start getting status update
            function getCustomBaselineStatusUpdate(data, eventType)
            {
            	formStateView.setMessage({
                                summary: localizer.getString("hpsum.baseline.custom.createCBLMsgSuccess"),
                                status: 'ok',
                                details: ''});

            	// Run in background is selected then reset events and close CB dilaog				
            	if($('#chkbox-runinback')[0].checked){
                    formStateView.reset();
                    $(CANCEL).trigger('click');
            	}
            	else 
            	{
                    cblCreateStatusUpdate(data, eventType);	
            	}				
            }
            
            function cblCreateStatusUpdate(data, eventType){
            	
            	var bStopTimer = false, message;
            	
            	var timer = setInterval(function () {
            		BaselinePresenter.getCustomBaselineStatus(data, {
            					success : function(data) {
                    				formStateView.setMessage({
		                                summary: localizer.getString("hpsum.baseline.custom.createCBLMsg"),
		                                status: 'ok',
		                                changing: true,
		                                details: data.hapi.location_info}
		                            );
									
                    	if(data.hapi.location_state === "custom_baseline_creation_completed" || data.hapi.location_state === "custom_baseline_creation_completed_with_warn" || data.hapi.location_state === "custom_baseline_creation_completed_with_error") {
										
								if(data.hapi.location_state === "custom_baseline_creation_completed" || 
								data.hapi.location_state === "custom_baseline_creation_completed_with_warn")
								{
										if(eventType == "SAVE")
										{
											message = localizer.getString("hpsum.baseline.custom.customSaveMsgSuccess");
										}
										else
										{
											message = localizer.getString("hpsum.baseline.custom.customCreateMsgSuccess");
										}
					
									var finalStatus = 'ok';
								}
								else
								{
									message = localizer.getString("hpsum.baseline.custom.customCreateMsgError");
									var finalStatus = 'error';
								}
                    					formStateView.setMessage({
			                                summary: message,
			                                status: finalStatus,
			                                changing: false,
			                                details: data.hapi.location_info
			                                }
		                              	);
		                              	
		                              	clearInterval(timer);
	                					timer = null;
										
								var targetLocation = '';
								var instTargetLocBrowse = $(TARGET_LOC_BROWSE).data('plugin_hpsumBrowse');
								if(instTargetLocBrowse)
								{
									targetLocation = instTargetLocBrowse.getLocation(); 
								}
								
								presenter.addItem({
								location:targetLocation,
								username:"",
								password:"",
								locationType:"local",
								proxy_settings:""},{
								success : onItemAddSuccess,
								error : onItemAddError
								});
								$(CANCEL).attr("disabled", true);
								addInProgress = false;
	                					$("#hpsum-custom-baselines-add-form :input").prop("disabled", false);
	                					reset(false);
	                					enableAll();
	                				 }
                    			},
                    			error : function(errorInfo) {
                        			formStateView.setMessage({
		                                summary: data.hapi.location_info,
		                                status: 'error',
		                                changing: false,
		                                details: data.hapi.location_state
		                                }
		                            );
		                            
		                            clearInterval(timer);
	                				timer = null;
                    			}
                			});
                }, 3000);
            }
            
            function createCustomBaselineError(errorinfo) {
            	addInProgress = false;
            	
            	formStateView.setMessage({
                                summary: localizer.getString("hpsum.baseline.custom.createCBLMsgError"),
                                status: 'error',
                                details: errorinfo});
                
                $("#hpsum-custom-baselines-add-form :input").prop("disabled", false);
                enableAll();
                $(SAVEAS).attr("disabled", $('#chkbox-bootableiso')[0].checked);
            }
            
			function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }
			
			function onAddBaseline() {
                if(addInProgress)
                	return;
                $(INVALIDSIG_WARNING).hide();
                $(FWPKG_SUM_LOW_VERSION).hide();
                selectedTablesID = [];
                filtered_comp_list.length = 0;

                if(csmfilterselected)
                {
                	validateAgainstCSM();
                	return;
                }

                showFilterSplash();
                var bfirmware, bsoftware;
                if($(SELECT_COMPTYPE).val().toLowerCase().match(/both/i))
                {
                	bfirmware = true;
                	bsoftware = true;
                }
                
                if($(SELECT_COMPTYPE).val().toLowerCase().match(/software/i))
                {
                	bfirmware = false;
                	bsoftware = true;
                }
                
                if($(SELECT_COMPTYPE).val().toLowerCase().match(/firmware/i))
                {
                	bfirmware = true;
                	bsoftware = false;
                }
            		
                var val;
				
                //filters list
                var filters = {
                	firmware: bfirmware,
                	software: bsoftware,
                	critical: val = $('#chkbox-critical')[0].checked ? true : false,
                	recommended: val = $('#chkbox-recommended')[0].checked ? true : false,
                	optional: val = $('#chkbox-optional')[0].checked ? true : false,
                	arch_x86: val = $('#chkbox-arch-x86')[0].checked ? true : false,
                	arch_x64: val = $('#chkbox-arch-x64')[0].checked ? true : false,
                	device_oa: val = $('#chkbox-dev-oa')[0].checked ? true : false,
                	device_vc: val = $('#chkbox-dev-vc')[0].checked ? true : false,
                	device_sasswitches: val = $('#chkbox-dev-sasswitches')[0].checked ? true : false,
					device_enclosure: val = $(SYNERGY_CHKBOX)[0].checked ? true : false,
					custom_oaefm: val = $(OAEFM_CHKBOX)[0].checked ? true : false,
					
					
                	
                };
                
                populateComponents(filters);
                
                enableActionButtons();
            }
            
            function populateBaselines() {
            	
            	if(oTableBaselines)
				{
					oTableBaselines.fnClearTable();
				}
				
            	//get all the baselines based on filter condition
            	var handlers =	{
                    			success : function(data) {
                        			getBaselineSuccess(data);
									$(RESET).attr('disabled', false);
                    		 	},
                    			error : function(errorInfo) {
                    				formStateView.setMessage({summary: localizer.getString("hpsum.baseline.custom.populateSourcesErrorMsg") + errorInfo, status: 'error', changing: true});
                        			getBaselineError(errorInfo);
                    			}
                		};
                
                BaselinePresenter.getBaselinesAll(handlers);
            }
            
            function getBaselineSuccess(locations) {
            	totalOSRequest = 0;
		        completedOSRequest = 0;
				errorOSRequest = 0;
				restOsInfoCount = 0;
				restHwInfoCount = 0;
            	if(oTableBaselines)
            	{
            		var HAS_AVAIABLE_BASELINE=false;
            		var baselines = [];
            		for (var idx = 0; idx < locations.length; idx++)
            		{
            			baselines = baselines.concat(locations[idx].baselines.baseline);
            		}

            		for(var i=0; i < baselines.length; i++)
            		{
            			hpsum_current_directory = baselines[i].current_directory;
            			hpsum_version = baselines[i].hpsum_version;
            			if( baselines[i].baseline_state === "inventory_completed") {
            				HAS_AVAIABLE_BASELINE=true;
            				break;
            			}
            				//We shall show the warning and close this dialog
           			 
           			}

           			if(HAS_AVAIABLE_BASELINE===false){
           				var dialog = new dialogview();
            			 dialog.init({
                       				 contents: confirmDialogContents,
                        				ok: function(elem) {
                            					$(CANCEL).trigger('click');
                        				}	
                    				});
            			    $('#'+'hpsum-confirmation-dialog-title').html(localizer.getString("hpsum.baseline.custom.information"));
            			    $('#'+'hpsum-confirm-text').html(localizer.getString("hpsum.baseline.custom.customCreateMsgErr"));

            				return;
           			}

            		hardware_info = new Array();
            		category_info = [];
					dl_array = [];
					ml_array = [];
					bl_array = [];
					sl_array = [];
					xl_array = [];
					ws_array = [];
					otherseries_array = [];
					synergy_array = [];
					firmware_cat_array = new Array();
					software_cat_array = new Array();
					driver_cat_array = new Array();
					bios_cat_array =new Array();
					uniqueCategory = [];
					
					//disable the Apply Filters button till all REST calls are received response from engine 
					$(ADDBASELINE).attr('disabled', true);
					$(APPLYFILTERS_MSG).show();
					
					for (var idx = 0; idx < locations.length; idx++)
					{
						baselines = locations[idx].baselines.baseline;
						for(var i=0; i < baselines.length; i++)
						{
							hpsum_current_directory = baselines[i].current_directory;
							hpsum_version = baselines[i].hpsum_version;						
							if(baselines[i].baseline_state !== "inventory_completed")
							    continue;
							var toggleId = oTableBaselines.fnGetData().length;
							var item = [{
								select: '<input id="toggle-' + toggleId + '" type="checkbox" />',
								name: baselines[i].baseline_name,
								version: baselines[i].baseline_version,
								location: baselines[i].baseline_url,
								baselineid: baselines[i].baseline_id,
								locationid: locations[idx].locationid,
								uri: baselines[i].baseline_uri,
								containsSynergyEncl: baselines[i].includes_synergy_encl,
								osdata: null
								}];
							if(baselines[i].baseline_url.indexOf("/") == 0) {
								$('#bootable-iso-help').html(localizer.getString("hpsum.baseline.custom.bootableisoHelp") + '<br><br>' + localizer.getString("hpsum.baseline.custom.bootableisoHelpLinux"));
								}
							oTableBaselines.fnAddData(item);
							$('#toggle-' + toggleId).hpToggle({
								unchecked : localizer.getString("hpsum.oneTouchUpdate.select"),
								checked : localizer.getString("hpsum.oneTouchUpdate.selected")
							});
							//get os data for the baseline
							getOSData(baselines[i].baseline_uri);
							getCategoryInfo(baselines[i].baseline_uri);
							gethardwareInfo(baselines[i].baseline_uri);
						}
						
            		}
            	
					var url=router.location();
					var list=url.split("/");
					var index= list.indexOf("bundle");
					var idx = list.indexOf(LOCATION);
					if(index>-1 && idx>-1)
					{
						var baselineId=list[index+1];
						var locationid = list[idx+1];
						var rows = $(SOURCES_TABLE + ' tbody tr');
						var selectid;
						for(var rowIndex=0; rowIndex < rows.length; rowIndex++){
							var data = oTableBaselines.fnGetData(rows[rowIndex].rowIndex-1);
							if(baselineId==data.baselineid && locationid==data.locationid)
							{
								rows.eq(rowIndex).addClass('hp-selected');
								selectid = data.select.split('"'); 
								selectid ='#'+ selectid[1];
								$(selectid).prop('checked', true); 
								$(selectid).trigger('change'); 
							}	
						}
					}				
			
					checkSynergyEnclFlag();
					
            		//enable selection and deselection of row
					$(SOURCES_TABLE + " tbody tr").click( function( e ) {
						//toggle row selection	
						$(this).toggleClass('hp-selected');
						disableActionButtons(); //fix for QXCR1001347960 
						var rows = $(SOURCES_TABLE + ' tbody tr');
						for (var tmp = 0; tmp < rows.length; tmp++) {
						var rowData = oTableBaselines.fnGetData(rows[tmp]._DT_RowIndex);
						for (var i=0;i<hardware_info.length ;i++)
						{
							if(hardware_info[i].data.BaselineServerData != undefined) {
								if(rowData.baselineid === hardware_info[i].data.BaselineServerData.bundle_id) {
									if(rows[tmp].className.indexOf('hp-selected') != -1)
									{
										hardware_info[i].isselected = true;						
									}
									else
									{
										hardware_info[i].isselected = false;						
									}
								}
							}
						}
						}
						dl_array = [];
						ml_array = [];
						bl_array = [];
						sl_array = [];
						xl_array = [];
						ws_array = [];
						otherseries_array = [];
						synergy_array = [];
						uniqueCategory = [];
						firmware_cat_array = [];
						software_cat_array = [];
						driver_cat_array = [];
						bios_cat_array = [];
						gethardwaresuccess();						
						populateServerTypes();
						checkSynergyEnclFlag();
					
						for (var tmp = 0; tmp < rows.length; tmp++) {
						var rowData = oTableBaselines.fnGetData(rows[tmp]._DT_RowIndex);
						for (var i=0;i<operating_system_array.length ;i++)
						{
							if(rowData.uri === operating_system_array[i].uri)
							{	
								if(rows[tmp].className.indexOf('hp-selected') != -1)
								{
								operating_system_array[i].isselected = true;
								}
								else
								{
								operating_system_array[i].isselected = false;
								}
							}
						}
						}
						
						getossuccess();
						updateCategoryInfo(rows);
						uniquecategorylist();	
						populatecategoryinfo();
						displaycategories();
						OnComponentTypeSelectionChange();
						checkBaselineSelected();
						
						var selectElem = this.innerHTML.split('"');
						var selectId = '#' + selectElem[3];
						if(selectId.indexOf('hpToggle')>=0)
						selectId = '#' + selectElem[3].slice(0, -9);
						else
						selectId = '#' + selectElem[5].slice(0, -9);
						 if(this.outerHTML.match(/hp-selected/i)){
								 $(selectId).prop('checked', true);
								 $(selectId).trigger('change');
							 } else {
								 $(selectId).removeAttr('checked');
								 $(selectId).trigger('change');
							 }
						
					});	
					onBootableIsoClick();
            	}
            }
            function checkBaselineSelected()
            {
            	var selectedrows = $(SOURCES_TABLE + ' tbody tr.hp-selected');
						if(selectedrows.length > 0)
							$(ADDBASELINE).attr("disabled", false);
						else
							$(ADDBASELINE).attr("disabled", true);
            }
            function getBaselineError(error) {
                
            } 
			function checkSynergyEnclFlag(flag) {
				// Iterate through the baselines to see if they contain any 
				// Synergy components. If atleast one of them have, the checkbox will be displayed. 
				var rows = $(SOURCES_TABLE + ' tbody tr');
				for (var tmp = 0; tmp < rows.length; tmp++) {
					var rowData = oTableBaselines.fnGetData(rows[tmp]._DT_RowIndex);
					if(rows[tmp].className.indexOf('hp-selected') != -1 && rowData.containsSynergyEncl == true ) 
					{
						$(SYNERGY_CONTENTS).show();
						$(SYNERGY_CHKBOX)[0].checked = false;
						$(COLLAPSE_HWTYPE_SYNERGY).hide();

						break;
					}
					else
					{
						$(SYNERGY_CONTENTS).hide();
						$(SYNERGY_CHKBOX)[0].checked = false;
						$(COLLAPSE_HWTYPE_SYNERGY).hide();
					}
						
				}	
			}
            
            function getOSData(uri) {
            	restOsInfoCount++;
            	
            	//get all the baselines based on filter condition
            	var handlers =	{
                    			success : function(data) {
                        			getOsDataSuccess(data,uri);
                        			restOsInfoCount--;
                        			if(restOsInfoCount == 0)
                                    {
                                    	enableApplyFilters();
                                    }
                    		 	},
                    			error : function(errorInfo) {
                    				restOsInfoCount--;
                    				formStateView.setMessage({summary: localizer.getString("hpsum.baseline.custom.populateComponentOsErrorMsg") + errorInfo, status: 'error', changing: true});
                        			getOsDataError(errorInfo);
                        			if(restOsInfoCount == 0)
                                    {
                                    	enableApplyFilters();
                    			}
                        		}
                		};
                
                BaselinePresenter.getOsInfo(uri,handlers);
            }
            function getCategoryInfo(uri) {
            	var handlers =	{
                    			success : function(data) {
                        			getCategoryDataSuccess(data,uri);
                    		 	},
                    			error : function(errorInfo) {
                        			getCategoryDataError(errorInfo);
                        		}
                		};
                BaselinePresenter.getCategoryInfo(uri,handlers);
            }
			
			function gethardwareInfo(uri) {
						var list = uri.split("/");
				        var locid = list[5];
				        var baselineid = list[7];
						var item = 	{
                				location_id: locid,
				        		baseline_id: baselineid
				        	};
			
				restHwInfoCount++;
			var handlers =	{
                    			success : function(data) {
                        			gethardwareInfoSuccess(data);
                        			restHwInfoCount--;
                        			if(restHwInfoCount == 0)
                                    {
                                    	enableApplyFilters();
                                    }
                    		 	},
                    			error : function(errorInfo) {
                    				restHwInfoCount--;
                    				if(restHwInfoCount == 0)
                                    {
                                    	enableApplyFilters();
                                    }
                        			gethardwareInfoError(errorInfo);
                    			}
                		};
				BaselinePresenter.getHardwareInfo(item, handlers);		
						
			}
            function gethardwareInfoSuccess (data)
			{
			
			var item = {
						isselected :false,
						data : data.hapi
						
						};
						
			
			hardware_info.push(item);
			var rows = $(SOURCES_TABLE + ' tbody tr');
						
						for (var tmp = 0; tmp < rows.length; tmp++) {
						  var rowData_initial = oTableBaselines.fnGetData(rows[tmp]._DT_RowIndex);
						  for (var i=0;i<hardware_info.length ;i++)
						{
							if(hardware_info[i].data.BaselineServerData != undefined) {
								if(rowData_initial.baselineid === hardware_info[i].data.BaselineServerData.bundle_id) {
									if(rows[tmp].className.indexOf('hp-selected') != -1)
									{
									hardware_info[i].isselected = true;
									}
									else
									{
									hardware_info[i].isselected = false;
									}
								}
							}
						}
						}
			gethardwaresuccess();
			
			if (hardware_info.length === rows.length)
				populateServerTypes();
			}
			
			// servername = HP ProLiant ML350e Gen8 Server
			// hardware = ML350e Gen8 Server
			// hardware_new = ML350e Gen8
			// modified the code for the Issue QXCR1001384763
			function hardwaredata(  data, servername )
			{
				var hardware_new = "";
				var hardware ="";
				if(servername.match(/ProLiant/i)) {
					hardware = servername.slice(12);
					if(servername.match(/MicroServer/i) || servername.match(/WS460c/i)){
						hardware_new = hardware;
					}
					else
					{
						hardware_new = hardware.slice(0,-6);
					}
				}
				else if(servername.match(/Synergy/i)) {
					 hardware = servername.slice(11);
					 hardware_new = hardware.slice(0,-14);
				}
				else if(servername.match(/Apollo/i)) {
					 hardware = servername.slice(10);
					 hardware_new = hardware.slice(0,-6);
				}
				if ( hardware_new.length > 0 && $.inArray(hardware_new, data) == -1 )
					data.push(hardware_new);
					data.sort();				
			}
			function gethardwaresuccess()
			{
			disable_hardwareFilter_flag = false;
			internal_error_flag = false;
			contains_gen10_flag = false;
			//var html = "<ol><fieldset>";
			for(var n=0;n<hardware_info.length;n++)
			{
				if(hardware_info[n].isselected == true)
				{
					if(hardware_info[n].data.BaselineServerData != undefined)
					{
					 var isSPP=	hardware_info[n].data.BaselineServerData.bundle_id;
					 if(isSPP.indexOf("bp0") != -1)
					 {
						for (var l =0;l<hardware_info[n].data.BaselineServerData.servers_name.length;l++)
						{
							var hardware_name_new = hardware_info[n].data.BaselineServerData.servers_name[l];
							if(hardware_name_new.indexOf("Gen10") != -1)
							{
									contains_gen10_flag = true;
									break;
							}
						}
					 }
					}
				}
				if(contains_gen10_flag == true)
				{
					break;
				}
			}
			for(var n=0;n<hardware_info.length;n++)
			{

			if(hardware_info[n].isselected == true)
			{
				if(hardware_info[n].data.BaselineServerData != undefined) {
				for (var l =0;l<hardware_info[n].data.BaselineServerData.servers_name.length;l++)
				{
					var hardware_name_new = hardware_info[n].data.BaselineServerData.servers_name[l];
					if(contains_gen10_flag)
					{
						if ( hardware_name_new.indexOf("EC200a") != -1 || hardware_name_new.indexOf("TM200") != -1 )
						{
							hardwaredata(otherseries_array,hardware_info[n].data.BaselineServerData.servers_name[l]);
						}
						else if(( hardware_name_new.indexOf("Gen10") != -1 ) || ( hardware_name_new.indexOf("Gen9") != -1 ))
						{
							if ( hardware_name_new.indexOf("DL") != -1 )
							{
									hardwaredata(dl_array,hardware_info[n].data.BaselineServerData.servers_name[l]);
							}
							else if ( hardware_name_new.indexOf("ML") != -1 )
							{
								hardwaredata(ml_array,hardware_info[n].data.BaselineServerData.servers_name[l]);
							}
							else if ( hardware_name_new.indexOf("BL") != -1 )
							{
								hardwaredata(bl_array,hardware_info[n].data.BaselineServerData.servers_name[l]);
							}
							else if ( hardware_name_new.indexOf("SL") != -1 )
							{
								hardwaredata(sl_array,hardware_info[n].data.BaselineServerData.servers_name[l]);
							}
							else if ( hardware_name_new.indexOf("XL") != -1 )
							{
								hardwaredata(xl_array,hardware_info[n].data.BaselineServerData.servers_name[l]);
							}
							else if ( hardware_name_new.indexOf("WS") != -1 )
							{
								hardwaredata(ws_array,hardware_info[n].data.BaselineServerData.servers_name[l]);
							}
							else if ( hardware_name_new.indexOf("Synergy") != -1 )
							{
								hardwaredata(synergy_array,hardware_info[n].data.BaselineServerData.servers_name[l]);
							}
						}
					}
					else
					{
					if ( hardware_name_new.indexOf("DL") != -1 )
					{
						hardwaredata(dl_array,hardware_info[n].data.BaselineServerData.servers_name[l]);
					}
					else if ( hardware_name_new.indexOf("ML") != -1 )
					{
						hardwaredata(ml_array,hardware_info[n].data.BaselineServerData.servers_name[l]);
					}
					else if ( hardware_name_new.indexOf("BL") != -1 )
					{
						hardwaredata(bl_array,hardware_info[n].data.BaselineServerData.servers_name[l]);
					}
					else if ( hardware_name_new.indexOf("SL") != -1 )
					{
						hardwaredata(sl_array,hardware_info[n].data.BaselineServerData.servers_name[l]);
					}
					else if ( hardware_name_new.indexOf("XL") != -1 )
					{
						hardwaredata(xl_array,hardware_info[n].data.BaselineServerData.servers_name[l]);
					}
					else if ( hardware_name_new.indexOf("WS") != -1 )
					{
						hardwaredata(ws_array,hardware_info[n].data.BaselineServerData.servers_name[l]);
					}

					else if ( hardware_name_new.indexOf("EC200a") != -1 || hardware_name_new.indexOf("TM200") != -1 ||  hardware_name_new.indexOf("MicroServer") != -1 || hardware_name_new.indexOf("Apollo") != -1)
					{
						hardwaredata(otherseries_array,hardware_info[n].data.BaselineServerData.servers_name[l]);
					}
					else if ( hardware_name_new.indexOf("Synergy") != -1 )
					{
						hardwaredata(synergy_array,hardware_info[n].data.BaselineServerData.servers_name[l]);
						}					
					}
				}
				}
			if(hardware_info[n].data.BaselineServerData != undefined) {
			if(hardware_info[n].data.BaselineServerData.disable_hardware_filter == true)
			{
				disable_hardwareFilter_flag = true;
				baselineLog = hardware_info[n].data.BaselineServerData.logfile_name;
				
					if(hardware_info[n].data.BaselineServerData.filter_internal_error == true)
					{
						internal_error_flag = true;
					}
			}
			}
			}			
			}
			if(disable_hardwareFilter_flag)
			{
				$('#hpsum-all-hardware').hide();				
				$('#hpsum-filter-error').show();
				if (internal_error_flag == true)
				{
					$('#hpsum-hardware-filter-error').html(localizer.getString("hpsum.baseline.custom.filterInternalErrMsg"));					
				}
				else				
				{
					$('#hpsum-hardware-filter-error').html(localizer.getString("hpsum.baseline.custom.filterMsg"));					
				}
			}
			else
			{
				$('#hpsum-all-hardware').show();
				$('#hpsum-filter-error').hide();			
			}

			}
			function gethardwareInfoError(errorInfo){}

			function sortServerModels(serverModelArray)
			{
				var unique_sorted_array;	
				for (var index=0; index < serverModelArray.length; index++)
				{
    				serverModelArray[index] = serverModelArray[index].trim();
				}

				serverModelArray.sort();
				unique_sorted_array  = uniqueComponents(serverModelArray);
				return unique_sorted_array;		
			}
			
			function populateServerTypes() {
			var dl_count= 0;
			var dl_data ="<table>";
			if(dl_array.length != 0)
			{
			
			dl_array= sortServerModels(dl_array);
			dl_data += "<tr><td><input id =hpsum-select-all-dl type = checkbox></td><td>"+ localizer.getString("hpsum.baseline.custom.selectall") +"</td>";
			dl_data += "<td><input id =hpsum-deselect-all-dl type = checkbox></td><td>" + localizer.getString("hpsum.baseline.custom.deselectall") + "</td></tr>";
			}
			else 
			{
			  dl_data += "<tr><td><div id = 'No-Supported-comps-to-device-dl'>&nbsp;" + localizer.getString("hpsum.baseline.custom.nosupportedcomps") + "</div></td></tr>";
			}
			for(var idx = 0;idx < dl_array.length;){
				var dl_remaining = dl_array.length - dl_count;
				if(dl_remaining > 5)
					dl_remaining = 5;
					
				dl_data += "<tr>";
				
				switch(dl_remaining)
				{
					case 5: dl_data+= "<td><input  id =\"hpsum-hardware-type-dl-"+idx+"\" class = \"hpsum-dl-hardware\" type = \"checkbox\" data-model=\""+dl_array[idx]+"\"</td><td>" + dl_array[idx]+ "</td>";
							idx++;
							dl_count++;
					case 4: dl_data+= "<td><input  id =\"hpsum-hardware-type-dl-"+idx+"\" class = \"hpsum-dl-hardware\" type = \"checkbox\" data-model=\""+dl_array[idx]+"\"</td><td>" + dl_array[idx]+ "</td>";
							idx++;
							dl_count++;
					case 3: dl_data+= "<td><input  id =\"hpsum-hardware-type-dl-"+idx+"\" class = \"hpsum-dl-hardware\" type = \"checkbox\" data-model=\""+dl_array[idx]+"\"</td><td>" + dl_array[idx]+ "</td>";
							idx++;
							dl_count++;
					case 2: dl_data+= "<td><input  id =\"hpsum-hardware-type-dl-"+ idx +"\" class = \"hpsum-dl-hardware\" type = \"checkbox\" data-model=\""+dl_array[idx]+"\"</td><td>" + dl_array[idx]+ "</td>";
							idx++;					
							dl_count++;
					case 1: dl_data+= "<td><input  id =\"hpsum-hardware-type-dl-"+ idx +"\"  class = \"hpsum-dl-hardware\" type = \"checkbox\" data-model=\""+dl_array[idx]+"\"</td><td>" + dl_array[idx]+ "</td>";
							idx++;		
							dl_count++;
				}
				dl_data += "</tr>";
			}
			dl_data+= "</table>";
			
			$('#hpsum-hardware-DL').html(dl_data);
			var ml_count= 0;
			var ml_data ="<table>";
			if(ml_array.length != 0)
			{
			ml_array = sortServerModels(ml_array);
			ml_data += "<tr><td><input id =hpsum-select-all-ml type = checkbox></td><td>"+localizer.getString("hpsum.baseline.custom.selectall")+"</td>";
			ml_data += "<td><input id =hpsum-deselect-all-ml type = checkbox></td><td>"+localizer.getString("hpsum.baseline.custom.deselectall")+"</td></tr>";
			}
			else 
			{
			  ml_data += "<tr><td><div id = 'No-Supported-comps-to-device-ml'>&nbsp;" + localizer.getString("hpsum.baseline.custom.nosupportedcomps") + "</div></td></tr>";
			}
			for(var idx = 0;idx < ml_array.length;){
				var ml_remaining = ml_array.length - ml_count;
				if(ml_remaining > 5)
					ml_remaining = 5;
					
				ml_data += "<tr>";
				
				switch(ml_remaining)
				{
					case 5: ml_data+= "<td><input  id =\"hpsum-hardware-type-ml-"+idx+"\" class = \"hpsum-ml-hardware\" type = \"checkbox\" data-model=\""+ml_array[idx]+"\"</td><td>" + ml_array[idx]+ "</td>";
							idx++;
							ml_count++;
					case 4: ml_data+= "<td><input  id =\"hpsum-hardware-type-ml-"+idx+"\" class = \"hpsum-ml-hardware\" type = \"checkbox\" data-model=\""+ml_array[idx]+"\"</td><td>" + ml_array[idx]+ "</td>";
							idx++;
							ml_count++;
					case 3: ml_data+= "<td><input  id =\"hpsum-hardware-type-ml-"+idx+"\" class = \"hpsum-ml-hardware\" type = \"checkbox\" data-model=\""+ml_array[idx]+"\"</td><td>" + ml_array[idx]+ "</td>";
							idx++;
							ml_count++;
					case 2: ml_data+= "<td><input  id =\"hpsum-hardware-type-ml-"+ idx +"\" class = \"hpsum-ml-hardware\" type = \"checkbox\" data-model=\""+ml_array[idx]+"\"</td><td>" + ml_array[idx]+ "</td>";
							idx++;					
							ml_count++;
					case 1: ml_data+= "<td><input  id =\"hpsum-hardware-type-ml-"+ idx +"\"  class = \"hpsum-ml-hardware\" type = \"checkbox\" data-model=\""+ml_array[idx]+"\"</td><td>" + ml_array[idx]+ "</td>";
							idx++;		
							ml_count++;
				}
				ml_data += "</tr>";
			}
			ml_data+= "</table>";
			
			$('#hpsum-hardware-ML').html(ml_data);
			var bl_count= 0;
			var bl_data ="<table>";
			if(bl_array.length != 0)
			{
			bl_array = sortServerModels(bl_array);
			bl_data += "<tr><td><input id =hpsum-select-all-bl type = checkbox></td><td>" + localizer.getString("hpsum.baseline.custom.selectall") + "</td>";
			bl_data += "<td><input id =hpsum-deselect-all-bl type = checkbox></td><td>" + localizer.getString("hpsum.baseline.custom.deselectall") + "</td></tr>";
			}
			else 
			{
			  bl_data += "<tr><td><div id = 'No-Supported-comps-to-device-bl'>&nbsp;" + localizer.getString("hpsum.baseline.custom.nosupportedcomps") + "</div></td></tr>";
			}
			for(var idx = 0;idx < bl_array.length;){
				var bl_remaining = bl_array.length - bl_count;
				if(bl_remaining > 5)
					bl_remaining = 5;
					
				bl_data += "<tr>";
				
				switch(bl_remaining)
				{
					case 5: bl_data+= "<td><input  id =\"hpsum-hardware-type-bl-"+idx+"\" class = \"hpsum-bl-hardware\" type = \"checkbox\" data-model=\""+bl_array[idx]+"\"</td><td>" + bl_array[idx]+ "</td>";
							idx++;
							bl_count++;
					case 4: bl_data+= "<td><input  id =\"hpsum-hardware-type-bl-"+idx+"\" class = \"hpsum-bl-hardware\" type = \"checkbox\" data-model=\""+bl_array[idx]+"\"</td><td>" + bl_array[idx]+ "</td>";
							idx++;
							bl_count++;
					case 3: bl_data+= "<td><input  id =\"hpsum-hardware-type-bl-"+idx+"\" class = \"hpsum-bl-hardware\" type = \"checkbox\" data-model=\""+bl_array[idx]+"\"</td><td>" + bl_array[idx]+ "</td>";
							idx++;
							bl_count++;
					case 2: bl_data+= "<td><input  id =\"hpsum-hardware-type-bl-"+ idx +"\" class = \"hpsum-bl-hardware\" type = \"checkbox\" data-model=\""+bl_array[idx]+"\"</td><td>" + bl_array[idx]+ "</td>";
							idx++;					
							bl_count++;
					case 1: bl_data+= "<td><input  id =\"hpsum-hardware-type-bl-"+ idx +"\"  class = \"hpsum-bl-hardware\" type = \"checkbox\" data-model=\""+bl_array[idx]+"\"</td><td>" + bl_array[idx]+ "</td>";
							idx++;		
							bl_count++;
				}
				bl_data += "</tr>";
			}
			bl_data+= "</table>";
			
			$('#hpsum-hardware-BL').html(bl_data);
			var sl_count= 0;
			var sl_data ="<table>";
			if(sl_array.length != 0)
			{
			sl_array = sortServerModels(sl_array);
			sl_data += "<tr><td><input id =hpsum-select-all-sl type = checkbox></td><td>" + localizer.getString("hpsum.baseline.custom.selectall") + "</td>";
			sl_data += "<td><input id =hpsum-deselect-all-sl type = checkbox></td><td>" + localizer.getString("hpsum.baseline.custom.deselectall") + "</td></tr>";
			}
			else 
			{
			   sl_data += "<tr><td><div id = 'No-Supported-comps-to-device-sl'>&nbsp;" + localizer.getString("hpsum.baseline.custom.nosupportedcomps") + "</div></td></tr>";
			}
			for(var idx = 0;idx < sl_array.length;){
				var sl_remaining = sl_array.length - sl_count;
				if(sl_remaining > 5)
					sl_remaining = 5;
					
				sl_data += "<tr>";
				
				switch(sl_remaining)
				{
					case 5: sl_data+= "<td><input  id =\"hpsum-hardware-type-sl-"+idx+"\" class = \"hpsum-sl-hardware\" type = \"checkbox\" data-model=\""+sl_array[idx]+"\"</td><td>" + sl_array[idx]+ "</td>";
							idx++;
							sl_count++;
					case 4: sl_data+= "<td><input  id =\"hpsum-hardware-type-sl-"+idx+"\" class = \"hpsum-sl-hardware\" type = \"checkbox\" data-model=\""+sl_array[idx]+"\"</td><td>" + sl_array[idx]+ "</td>";
							idx++;
							sl_count++;
					case 3: sl_data+= "<td><input  id =\"hpsum-hardware-type-sl-"+idx+"\" class = \"hpsum-sl-hardware\" type = \"checkbox\" data-model=\""+sl_array[idx]+"\"</td><td>" + sl_array[idx]+ "</td>";
							idx++;
							sl_count++;
					case 2: sl_data+= "<td><input  id =\"hpsum-hardware-type-sl-"+ idx +"\" class = \"hpsum-sl-hardware\" type = \"checkbox\" data-model=\""+sl_array[idx]+"\"</td><td>" + sl_array[idx]+ "</td>";
							idx++;					
							sl_count++;
					case 1: sl_data+= "<td><input  id =\"hpsum-hardware-type-sl-"+ idx +"\"  class = \"hpsum-sl-hardware\" type = \"checkbox\" data-model=\""+sl_array[idx]+"\"</td><td>" + sl_array[idx]+ "</td>";
							idx++;		
							sl_count++;
				}
				sl_data += "</tr>";
			}
			sl_data+= "</table>";
			
			$('#hpsum-hardware-SL').html(sl_data);
			
			var xl_count= 0;
			var xl_data ="<table>";
			if(xl_array.length != 0)
			{
			xl_array = sortServerModels(xl_array);
			xl_data += "<tr><td><input id =hpsum-select-all-xl type = checkbox></td><td>" + localizer.getString("hpsum.baseline.custom.selectall") + "</td>";
			xl_data += "<td><input id =hpsum-deselect-all-xl type = checkbox></td><td> " + localizer.getString("hpsum.baseline.custom.deselectall") + "</td></tr>";
			}
			else 
			{
			  xl_data += "<tr><td><div id = 'No-Supported-comps-to-device-xl'>&nbsp;" + localizer.getString("hpsum.baseline.custom.nosupportedcomps") + "</div></td></tr>";
			}
			for(var idx = 0;idx < xl_array.length;){
				var xl_remaining = xl_array.length - xl_count;
				if(xl_remaining > 5)
					xl_remaining = 5;
					
				xl_data += "<tr>";
				
				switch(xl_remaining)
				{
					case 5: xl_data+= "<td><input  id =\"hpsum-hardware-type-xl-"+idx+"\" class = \"hpsum-xl-hardware\" type = \"checkbox\" data-model=\""+xl_array[idx]+"\"</td><td>" + xl_array[idx]+ "</td>";
							idx++;
							xl_count++;
					case 4: xl_data+= "<td><input  id =\"hpsum-hardware-type-xl-"+idx+"\" class = \"hpsum-xl-hardware\" type = \"checkbox\" data-model=\""+xl_array[idx]+"\"</td><td>" + xl_array[idx]+ "</td>";
							idx++;
							xl_count++;
					case 3: xl_data+= "<td><input  id =\"hpsum-hardware-type-xl-"+idx+"\" class = \"hpsum-xl-hardware\" type = \"checkbox\" data-model=\""+xl_array[idx]+"\"</td><td>" + xl_array[idx]+ "</td>";
							idx++;
							xl_count++;
					case 2: xl_data+= "<td><input  id =\"hpsum-hardware-type-xl-"+ idx +"\" class = \"hpsum-xl-hardware\" type = \"checkbox\" data-model=\""+xl_array[idx]+"\"</td><td>" + xl_array[idx]+ "</td>";
							idx++;					
							xl_count++;
					case 1: xl_data+= "<td><input  id =\"hpsum-hardware-type-xl-"+ idx +"\"  class = \"hpsum-xl-hardware\" type = \"checkbox\" data-model=\""+xl_array[idx]+"\"</td><td>" + xl_array[idx]+ "</td>";
							idx++;		
							xl_count++;
				}
				xl_data += "</tr>";
			}
			xl_data+= "</table>";
			
			$('#hpsum-hardware-XL').html(xl_data);
			var ws_count= 0;
			var ws_data ="<table>";
			if(ws_array.length != 0)
			{
			ws_array = sortServerModels(ws_array);
			ws_data += "<tr><td><input id =hpsum-select-all-ws type = checkbox></td><td>" + localizer.getString("hpsum.baseline.custom.selectall") + "</td>";
			ws_data += "<td><input id =hpsum-deselect-all-ws type = checkbox></td><td> " + localizer.getString("hpsum.baseline.custom.deselectall") + "</td></tr>";
			}
			else 
			{
			  ws_data += "<tr><td><div id = 'No-Supported-comps-to-device-ws'>&nbsp;" + localizer.getString("hpsum.baseline.custom.nosupportedcomps") + "</div></td></tr>";
			}
			for(var idx = 0;idx < ws_array.length;){
				var ws_remaining = ws_array.length - ws_count;
				if(ws_remaining > 5)
					ws_remaining = 5;
					
				ws_data += "<tr>";
				
				switch(ws_remaining)
				{
					case 5: ws_data+= "<td><input  id =\"hpsum-hardware-type-ws-"+idx+"\" class = \"hpsum-ws-hardware\" type = \"checkbox\" data-model=\""+ws_array[idx]+"\"</td><td>" + ws_array[idx]+ "</td>";
							idx++;
							ws_count++;
					case 4: ws_data+= "<td><input  id =\"hpsum-hardware-type-ws-"+idx+"\" class = \"hpsum-ws-hardware\" type = \"checkbox\" data-model=\""+ws_array[idx]+"\"</td><td>" + ws_array[idx]+ "</td>";
							idx++;
							ws_count++;
					case 3: ws_data+= "<td><input  id =\"hpsum-hardware-type-ws-"+idx+"\" class = \"hpsum-ws-hardware\" type = \"checkbox\" data-model=\""+ws_array[idx]+"\"</td><td>" + ws_array[idx]+ "</td>";
							idx++;
							ws_count++;
					case 2: ws_data+= "<td><input  id =\"hpsum-hardware-type-ws-"+ idx +"\" class = \"hpsum-ws-hardware\" type = \"checkbox\" data-model=\""+ws_array[idx]+"\"</td><td>" + ws_array[idx]+ "</td>";
							idx++;					
							ws_count++;
					case 1: ws_data+= "<td><input  id =\"hpsum-hardware-type-ws-"+ idx +"\"  class = \"hpsum-ws-hardware\" type = \"checkbox\" data-model=\""+ws_array[idx]+"\"</td><td>" + ws_array[idx]+ "</td>";
							idx++;		
							ws_count++;
				}
				ws_data += "</tr>";
			}
			ws_data+= "</table>";
			
			$('#hpsum-hardware-WS').html(ws_data);


			var otherseries_count= 0;
			var otherseries_data ="<table>";
			if(otherseries_array.length != 0)
			{
			otherseries_array = sortServerModels(otherseries_array);
			otherseries_data += "<tr><td><input id =hpsum-select-all-otherseries type = checkbox></td><td>"+localizer.getString("hpsum.baseline.custom.selectall")+"</td>";
			otherseries_data += "<td><input id =hpsum-deselect-all-otherseries type = checkbox></td><td>"+localizer.getString("hpsum.baseline.custom.deselectall")+"</td></tr>";
			}
			else 
			{
			  otherseries_data += "<tr><td><div id = 'No-Supported-comps-to-device-otherseries'>&nbsp;" + localizer.getString("hpsum.baseline.custom.nosupportedcomps") + "</div></td></tr>";
			}
			for(var idx = 0;idx < otherseries_array.length;){
				var otherseries_remaining = otherseries_array.length - otherseries_count;
				if(otherseries_remaining > 5)
					otherseries_remaining = 5;
					
				otherseries_data += "<tr>";
				
				switch(otherseries_remaining)
				{
					case 5: otherseries_data+= "<td><input  id =\"hpsum-hardware-type-otherseries-"+idx+"\" class = \"hpsum-otherseries-hardware\" type = \"checkbox\" data-model=\""+otherseries_array[idx]+"\"</td><td>" + otherseries_array[idx]+ "</td>";
							idx++;
							otherseries_count++;
					case 4: otherseries_data+= "<td><input  id =\"hpsum-hardware-type-otherseries-"+idx+"\" class = \"hpsum-otherseries-hardware\" type = \"checkbox\" data-model=\""+otherseries_array[idx]+"\"</td><td>" + otherseries_array[idx]+ "</td>";
							idx++;
							otherseries_count++;
					case 3: otherseries_data+= "<td><input  id =\"hpsum-hardware-type-otherseries-"+idx+"\" class = \"hpsum-otherseries-hardware\" type = \"checkbox\" data-model=\""+otherseries_array[idx]+"\"</td><td>" + otherseries_array[idx]+ "</td>";
							idx++;
							otherseries_count++;
					case 2: otherseries_data+= "<td><input  id =\"hpsum-hardware-type-otherseries-"+ idx +"\" class = \"hpsum-otherseries-hardware\" type = \"checkbox\" data-model=\""+otherseries_array[idx]+"\"</td><td>" + otherseries_array[idx]+ "</td>";
							idx++;					
							otherseries_count++;
					case 1: otherseries_data+= "<td><input  id =\"hpsum-hardware-type-otherseries-"+ idx +"\"  class = \"hpsum-otherseries-hardware\" type = \"checkbox\" data-model=\""+otherseries_array[idx]+"\"</td><td>" + otherseries_array[idx]+ "</td>";
							idx++;		
							otherseries_count++;
				}
				otherseries_data += "</tr>";
			}
			otherseries_data+= "</table>";
			
			$('#hpsum-hardware-OTHERSERIES').html(otherseries_data);
			
			
			var synergy_count= 0;
			var synergy_data ="<table>";
			if(synergy_array.length != 0)
			{
			synergy_array = sortServerModels(synergy_array);		
			synergy_data += "<tr><td><input id =\"hpsum-select-all-synergy\" type = checkbox></td><td>" + localizer.getString("hpsum.baseline.custom.selectall") + "</td>";
			synergy_data += "<td><input id =\"hpsum-deselect-all-synergy\" type = checkbox></td><td> " + localizer.getString("hpsum.baseline.custom.deselectall") + "</td></tr>";
			}
			else 
			{
			  synergy_data += "<tr><td><div id = 'No-Supported-comps-to-device-synergy'>&nbsp;" + localizer.getString("hpsum.baseline.custom.nosupportedcomps") + "</div></td></tr>";
			}
			for(var idx = 0;idx < synergy_array.length;){
				var synergy_remaining = synergy_array.length - synergy_count;
				if(synergy_remaining > 5)
					synergy_remaining = 5;
					
				synergy_data += "<tr>";
				
				for (var syn_idx=0; syn_idx < synergy_remaining; syn_idx++) {
					synergy_data+= "<td><input  id =\"hpsum-hardware-type-synergy-"+idx+"\" class = \"hpsum-synergy-hardware\" type = \"checkbox\" data-model=\""+synergy_array[idx]+"\"</td><td>" + synergy_array[idx]+ "</td>";
					idx++;
					synergy_count++;
				}
		
				synergy_data += "</tr>";
			}
			synergy_data+= "</table>";
			
			$('#hpsum-hardware-Synergy').html(synergy_data);
			
			}
			
            function  getOsDataSuccess(data, uri) {
			var item = {
						isselected :false,
						data : data.hapi,
						uri : uri
						
						};
			//check for xorriso presence and show warning/NonUEFI check box if xorriso is not present on the system			
			if(data.hapi.xorriso_present == false) {
				isxorriso_present = false;
				if($(BOOTABLEISO_CHKBOX)[0].checked)
				{
					$('.hpsum-nonUEFI').show();
				}
				else
				{
					$('.hpsum-nonUEFI').hide();
				}
			}
			else
			{
				$('.hpsum-nonUEFI').hide();
				isxorriso_present = true;
			}
						
			operating_system_array.push(item);
			
			
			var rows = $(SOURCES_TABLE + ' tbody tr');
						
						for (var tmp = 0; tmp < rows.length; tmp++) {
						  var rowData_initial = oTableBaselines.fnGetData(rows[tmp]._DT_RowIndex);
						  for (var i=0;i<operating_system_array.length ;i++)
						{
						list_os = operating_system_array[i].uri.split("/");

				        bundle_os_id = list_os[7];
						if(rowData_initial.baselineid === bundle_os_id)
						if(rows[tmp].className.indexOf('hp-selected') != -1)
						{
						operating_system_array[i].isselected = true;
						}
						else
						{
						operating_system_array[i].isselected = false;
						}
						}
						}
			getossuccess();
            	}
			/* To check duplicate OS names are not present in the final list to be populated in the OS type filter*/
			function isosexists()
			{
			var alreadyexists=false;
			for(var m=0;m<=operating_system_final.length;m++)
			{
			if(operating_system_final[m] === operating_system_list)
			{
				alreadyexists = true;
				break;
			}
			}
			if(!alreadyexists)
			operating_system_final.push(operating_system_list);
			}
            function getossuccess()
			{
			operating_system_final = [];
			for(var n=0;n<operating_system_array.length;n++)
			{
			if(operating_system_array[n].isselected == true)
			{
			//$(ADDBASELINE).attr("disabled",false);
		    var operating_system = new Array();
			var a = true;
		    operating_system_new = new Array();
			for (var j=0;j<operating_system_array[n].data.baseline_os.os.length;j++)
			{
		    operating_system = operating_system_array[n].data.baseline_os.os[j];
			for(var k =0;k<operating_system_new.length;k++)
			{
			if(operating_system == operating_system_new[k])
				a = false;
				break;
			}
			if(a)
				operating_system_new.push(operating_system);
			}
			for (var l =0;l<operating_system_new.length;l++)
			{
			   if (operating_system_new[l].match(/Microsoft Windows Server 2008 R2/i))
			   {
			   operating_system_list = "Windows 2008 R2";
			   }
			   else if (operating_system_new[l].match(/Microsoft Windows Server 2008/i))
			   {
			   operating_system_list = "Windows 2008";
			   }
			   else if (operating_system_new[l].match(/Microsoft Windows Server 2012 R2/i))
			   {
			   operating_system_list = "Windows 2012 R2";
			   }
			   else if (operating_system_new[l].match(/Microsoft Windows Server 2012/i))
			   {
			   operating_system_list = "Windows 2012";
			   }
               else if (operating_system_new[l].match(/Microsoft Windows Server 2016/i))
			   {
				operating_system_list = "Windows 2016";  
			   }
               else if (operating_system_new[l].match(/Microsoft Windows Server 2019/i))
			   {
				operating_system_list = "Windows 2019";  
			   }			   
			   else if (operating_system_new[l].match(/Red Hat Enterprise Linux 6/i))
			   {
			   operating_system_list = "RHEL 6";
			   }
			   else if (operating_system_new[l].match(/Red Hat Enterprise Linux 5/i))
			   {
			   operating_system_list = "RHEL 5";
		       }
			   else if (operating_system_new[l].match(/Red Hat Enterprise Linux 7/i))
			   {
			   operating_system_list = "RHEL 7";
		       }
			   else if (operating_system_new[l].match(/Red Hat Enterprise Linux 8/i))
			   {
			   operating_system_list = "RHEL 8";
		       }
			   else if (operating_system_new[l].match(/VMware ESXi 5.0/i))
			   {
			   operating_system_list = "VMware ESXi 5.0";
			   }
			   else if (operating_system_new[l].match(/VMware vSphere 5.1/i))
			   {
			   operating_system_list = "VMware vSphere 5.1";
			   }
			   else if (operating_system_new[l].match(/VMware vSphere 5.5/i))
			   {
			   operating_system_list = "VMware vSphere 5.5";
			   }
			   else if (operating_system_new[l].match(/VMware vSphere 6.0/i))
			   {
			   operating_system_list = "VMware vSphere 6.0";
			   }
			   else if (operating_system_new[l].match(/VMware vSphere 6.5/i))
			   {
			   	operating_system_list = "VMware vSphere 6.5";
			   }	
			   else if (operating_system_new[l].match(/VMware vSphere 6.7/i))
			   {
			   	operating_system_list = "VMware vSphere 6.7";
			   }
			   else if (operating_system_new[l].match(/VMware ESXi 7.0/i))
			   {
			   	operating_system_list = "VMware vSphere 7.0";
			   }			   
			   else if (operating_system_new[l].match(/SUSE LINUX Enterprise Server 11/i))
			   {
			   operating_system_list = "SLES 11";
			   }
			   else if (operating_system_new[l].match(/SUSE Linux Enterprise Server 12/i))
			   {
			   operating_system_list = "SLES 12";
			   }
			   else if(operating_system_new[l].match(/SUSE Linux Enterprise Server 15/i))
			   {
				   operating_system_list = SLES_15;
			   }
			   isosexists();
			}
			operating_system_final.sort();
			var os_count= 0;
			var os_data ="<table>";
			for(var idx = 0;idx <operating_system_final.length;)
			{
				var os_remaining = operating_system_final.length - os_count;
				if(os_remaining > 4)
			    os_remaining = 4;
			    os_data += "<tr>";
				switch(os_remaining)
				{
				
					case 4: os_data+= "<td><input  id =\"hpsum-os-type-"+idx+"\" class = \"hpsum-os-info\" type = \"checkbox\" data-model=\""+operating_system_final[idx]+"\"</td><td>" + operating_system_final[idx]+ "</td>";
							idx++;
							os_count++;
					case 3: os_data+= "<td><input  id =\"hpsum-os-type-"+idx+"\" class = \"hpsum-os-info\" type = \"checkbox\" data-model=\""+operating_system_final[idx]+"\"</td><td>" + operating_system_final[idx]+ "</td>";
							idx++;
							os_count++;
					case 2: os_data+= "<td><input  id =\"hpsum-os-type-"+ idx +"\" class = \"hpsum-os-info\" type = \"checkbox\" data-model=\""+operating_system_final[idx]+"\"</td><td>" + operating_system_final[idx]+ "</td>";
							idx++;					
							os_count++;
					case 1: os_data+= "<td><input  id =\"hpsum-os-type-"+ idx +"\"  class = \"hpsum-os-info\" type = \"checkbox\" data-model=\""+operating_system_final[idx]+"\"</td><td>" + operating_system_final[idx]+ "</td>";
							idx++;		
							os_count++;
				}
				os_data += "</tr>";
			}
			os_data+= "</table>";
			$('#hpsum-operating-system-info').empty();
			$('#hpsum-operating-system-info').html(os_data);			
			}
			else{
			//$(ADDBASELINE).attr("disabled",true);
			    }
			}
            }
            
		function getCategoryDataSuccess(data,uri)
		{
			var item = {
				isselected :false,
				data : data.hapi,
				uri: uri
			};
			category_info.push(item);
			var rows = $(SOURCES_TABLE + ' tbody tr');		
			if(rows.length === category_info.length)
			{
				updateCategoryInfo(rows);
				//Populate the category information.
				uniquecategorylist();	
				populatecategoryinfo();
				displaycategories();
			}
		}
		function populatecategoryinfo()
		{
			parsecategoryinfo(bios_cat_array,HPE_BIOS);
			parsecategoryinfo(firmware_cat_array,HPE_FIRMWARE);
			parsecategoryinfo(software_cat_array,HPE_SOFTWARE);
			parsecategoryinfo(driver_cat_array,HPE_DRIVER);            	
		}
	    function DisableOrEnableCategoryElements(array,category,bool_value)
	    {
	    	if(array.length > 0)
			{
				$(COMPONENT_CATEGORY+category)[0].disabled = bool_value;
				if(bool_value)
				{
					$(COMPONENT_CATEGORY+category)[0].checked = false;
					$(COMPONENT_CATEGORY+category+'-'+category)[0].style.color = "gray";
				}
				else
				{
					$(COMPONENT_CATEGORY+category+'-'+category)[0].style.color = "#425563";
				}
			}
	        for (var idx = 0; idx < array.length; idx++)
			{
				$( HPSUM_CATEGORY+category+'-'+idx)[0].disabled = bool_value;
				if(bool_value)
				{
					$(HPSUM_CATEGORY + category+'-'+idx)[0].checked = false;
					$(HPSUM_CATEGORY + category+'-'+idx+idx)[0].style.color = "gray";
				}
				else
				{
					$(HPSUM_CATEGORY + category+'-'+idx+idx)[0].style.color = "#425563";
				}
			}
	    } 
	    function  OnComponentTypeSelectionChange()
	    {
	    	AddOrRemoveTooltip();
			if($(SELECT_COMPTYPE).val().toLowerCase().match(/both/i))
            {
				DisableOrEnableCategoryElements(bios_cat_array, HPE_BIOS, false);
				DisableOrEnableCategoryElements(firmware_cat_array, HPE_FIRMWARE, false);
				DisableOrEnableCategoryElements(software_cat_array, HPE_SOFTWARE,false);				  		 	
				DisableOrEnableCategoryElements(driver_cat_array, HPE_DRIVER, false);				  			
            }
            else if($(SELECT_COMPTYPE).val().toLowerCase().match(/firmware/i))
            {
                DisableOrEnableCategoryElements(bios_cat_array, HPE_BIOS, false);
				DisableOrEnableCategoryElements(firmware_cat_array,HPE_FIRMWARE, false);
				DisableOrEnableCategoryElements(software_cat_array, HPE_SOFTWARE,true);
				DisableOrEnableCategoryElements(driver_cat_array, HPE_DRIVER, true);
            }
            else if($(SELECT_COMPTYPE).val().toLowerCase().match(/software/i))
            {
                DisableOrEnableCategoryElements(bios_cat_array, HPE_BIOS, true);
				DisableOrEnableCategoryElements(firmware_cat_array, HPE_FIRMWARE, true);
				DisableOrEnableCategoryElements(software_cat_array, HPE_SOFTWARE,false);				  		 	
				DisableOrEnableCategoryElements(driver_cat_array, HPE_DRIVER, false);	
           } 
	    }        
        function displaycategories()
		{
			//BIOS
			printArrayElements(bios_cat_array, ELEMENT_PER_ROW , HPE_BIOS);  
			//Firmware
			printArrayElements(firmware_cat_array, ELEMENT_PER_ROW , HPE_FIRMWARE);
			//Driver
			printArrayElements(driver_cat_array, ELEMENT_PER_ROW, HPE_DRIVER);            	
			//Software	
			printArrayElements(software_cat_array, ELEMENT_PER_ROW , HPE_SOFTWARE);
		}
        function printArrayElements(array_to_display, elements_per_row , type)
        {
	    	var table_data ="<table>";
			$(COMPONENT_CATEGORY+type)[0].checked = false;
            if(array_to_display.length == 0)
            {
				table_data += "<tr>";
				table_data += "<td style=\"padding-right:32px;\"></td>";
				table_data += "<td><div id = 'No-Supported-comps-to-category-type'>&nbsp;" + localizer.getString("hpsum.baseline.custom.nosupportedcompscat") + "</div></td>";
				table_data += "</tr>";
				$(COMPONENT_CATEGORY+type)[0].disabled = true;
            }
			else
			{
				$(COMPONENT_CATEGORY+type)[0].disabled = false;
			}
            for(var idx = 0;idx < array_to_display.length;)
			{
                    var array_elements_remaining = array_to_display.length - idx;
                    if(array_elements_remaining > elements_per_row)
                    {
                        array_elements_remaining = elements_per_row;
                    }
                    table_data += "<tr>";
					table_data += "<td style=\"padding-right:32px;\"></td>";
                    for (var index = 0 ; index < array_elements_remaining ; index++)
                    {
                        table_data+= "<td><input  id =\"hpsum-category-type-"+type+"-"+idx+"\" type = \"checkbox\" data-model=\"" + array_to_display[idx] +"\"</td><td style=\"width:175px; padding-left: 0px;\">" + "<label id=\"hpsum-category-type-"+type+"-"+idx+idx+"\">" + array_to_display[idx]+ "</label></td>";
						idx++;
                    }
                     table_data += "</tr>";
            }
			table_data+= "</table>";
			var display_ele = HPSUM_CATEGORY + type ;
			$(display_ele).html(table_data);
        }
        function parsecategoryinfo(array, category)
        {
			for(var cat=0;cat<uniqueCategory.length;cat++)
            {
				var splitCategory = uniqueCategory[cat].split(/-(.+)?/);
				for(var splitcat=0; splitcat < splitCategory.length; splitcat++)
				{
					splitCategory[splitcat] = splitCategory[splitcat].trim();
				}
				if(splitCategory[0] === category)
				{
					if(splitCategory[1] != undefined)
					{
						array.push(splitCategory[1]);
					}
				}            		
			}
            array.sort();
            pushValueToEnd(array);
        }
        function uniquecategorylist()
	    {
	    	var temp_item;
			for(var tmp=0;tmp<category_info.length;tmp++)
			{
				if((category_info[tmp].isselected == true) && (category_info[tmp].data.components != undefined))
				{
					for (var idx =0; idx<category_info[tmp].data.components.category.length;idx++)
					{
						temp_item= category_info[tmp].data.components.category[idx].category.trim();
						uniqueCategory.push(temp_item) ;
					}
				}
			}
			//uniqueComponents removes duplicate entries in the array
			uniqueCategory = uniqueComponents(uniqueCategory);
			removeByValue(uniqueCategory, VALUE_BLADE);
			removeByValue(uniqueCategory, VALUE_FRAME);
	    }
	    //removeByValue function filters out the "Firmware - Blade Infrastructure" and "Firmware - Frame Infrastructure"Category.
	    function removeByValue(arr, val)
	    {
    	    for(var index=0; index<arr.length; index++)
			{
       			if(arr[index] === val)
				{
           			arr.splice(index, 1);
           			break;
      			}
    		}
	    }
	    //If there is sub-category "Others" in the category,move it to the end of the array
	    function pushValueToEnd(arr)
	    {
	    	var matchedVal;
			for(var index=0; index<arr.length; index++)
			{
				if(arr[index] === OTHERS_VALUE) 
				{
					matchedVal=arr[index];
					arr.splice(index, 1);
					break;
				}
			}
			if(matchedVal === OTHERS_VALUE)
			{
				arr.push(matchedVal);		
			}
	    }
	    function removeToolTipAttrAndClass(source)
	    {
			var attr= $(source).attr('data-tooltip');
			if(typeof attr !== typeof undefined && attr !== false)
			{
				$(source).removeClass('hp-tooltipped').removeAttr('tooltip data-tooltip');
			}
	     }
		 function AddToolTipAttrAndClass(source,tip)
		 {
			$(source).attr('tooltip', localizer.getString(tip)).hpTooltip();		
		 }
	     function AddOrRemoveTooltip()
	     {
	     	if(($(SELECT_COMPTYPE).val().toLowerCase().match(/both/i)) || (bios_cat_array.length == 0 && firmware_cat_array.length == 0 && software_cat_array.length == 0 && driver_cat_array.length == 0))
			{
				removeToolTipAttrAndClass(CATEGORY_SOFTWARE);
				removeToolTipAttrAndClass(CATEGORY_DRIVER);
				removeToolTipAttrAndClass(CATEGORY_BIOS);
				removeToolTipAttrAndClass(CATEGORY_FIRMWARE);
			}
	        else if($(SELECT_COMPTYPE).val().toLowerCase().match(/firmware/i))
	        {
				AddToolTipAttrAndClass(CATEGORY_SOFTWARE,'hpsum.baseline.custom.categoryDisabledFirmware');
				AddToolTipAttrAndClass(CATEGORY_DRIVER,'hpsum.baseline.custom.categoryDisabledFirmware');
				removeToolTipAttrAndClass(CATEGORY_BIOS);
				removeToolTipAttrAndClass(CATEGORY_FIRMWARE);  	
	        }
            else if($(SELECT_COMPTYPE).val().toLowerCase().match(/software/i))
            {
				removeToolTipAttrAndClass(CATEGORY_SOFTWARE);
				removeToolTipAttrAndClass(CATEGORY_DRIVER);
				AddToolTipAttrAndClass(CATEGORY_BIOS,'hpsum.baseline.custom.categoryDisabledSoftware');
				AddToolTipAttrAndClass(CATEGORY_FIRMWARE,'hpsum.baseline.custom.categoryDisabledSoftware');	            	
			}
	     }
	     function updateCategoryInfo(baseline_rows)
	     {
	     	for (var tmp = 0; tmp < baseline_rows.length; tmp++)
			{
				var rowData_initial = oTableBaselines.fnGetData(baseline_rows[tmp]._DT_RowIndex);
				for (var idx=0;idx<category_info.length ;idx++)
				{
					session_address = category_info[idx].uri.split("/");
					bundle_id = session_address[7];
					if((typeof bundle_id !== typeof undefined)&&(rowData_initial.baselineid === bundle_id))
					{
						if(baseline_rows[tmp].className.indexOf('hp-selected') != -1)
						{
							category_info[idx].isselected = true;
						}
						else
						{
							category_info[idx].isselected = false;
						}
					}
				}
	        }
	     }
		function getCategoryDataError(data)
		{
		}
            function  getOsDataError(data) {
            }
            
            function populateComponents(filters) {
            	
            	$('#all-cbl-baselines').empty();
            	
            	//var oTableBaselines = $(SOURCES_TABLE).dataTable();
            	var baselines = [], selectedRows;
            	if(oTableBaselines)
            	{
					baselines = oTableBaselines.fnGetData();
					
					selectedRows = $(SOURCES_TABLE + ' tbody tr.hp-selected');
			 	} 
			 	
			 	var tableid = '#hpsum-cbl-table-review'; //+ nodeData.baselineid;
            	filtered_comp_list = []; // Fix for QXCR1001387787
				if(selectedRows.length>0)
				{
					//Hide the select all and de-select all options till the check we will do in populate table success case. 
					$('#all-cbl-baselines').append('<input id="chkbox-hw-selectall" type="checkbox" style="padding-left:10px;display:none;" />' +  
						'<label id="chkbox-hw-selectall-lbl" for="chkbox-hw-selectall" style="padding-right:100px;display:none;">' + localizer.getString("hpsum.baseline.custom.selectall") + '</label>'); 
					$('#all-cbl-baselines').append('<input id="chkbox-hw-deselectall" type="checkbox" style="padding-left:10px;display:none;" />' + 		
						'<label id="chkbox-hw-deselectall-lbl" for="chkbox-hw-deselectall" style="display:none" >' + localizer.getString("hpsum.baseline.custom.deselectall") + '</label>');
						
					$('#all-cbl-baselines').append('<table class="hp-selectable" id="hpsum-cbl-table-review"><thead><tr><td><b>'+	 localizer.getString("hpsum.oneTouchUpdate.selectComponents") + '</b></td><td><b>' + 
						localizer.getString("hpsum.baseline.addBaseline.id") + '</b></td><td><b>' +
						localizer.getString("hpsum.baseline.addBaseline.description") + '</b></td><td><b>' + 
						localizer.getString("hpsum.baseline.version") + '</b></td><td><div align="center"><b>' + 
						localizer.getString("hpsum.baseline.custom.sigfiledetails") + '</b></div></td><td><b>' + 
						localizer.getString("hpsum.common.rebootRequired") + '</b></td>' + //<td><b>' + 
						//localizer.getString("hpsum.baseline.addBaseline.configured") + '</b></td>
						'</tr></thead></table>');
				}
				
				baslinesAdded = 0;
				//initialize all counts to zero and hide the label
				totalCompCount = 0, filterCompCount = 0, selectedCompCount = 0;	
				$(COMPONENTS_COUNT_LABEL).html('').hide();		
				
            	for(var tmp=0; tmp < selectedRows.length; tmp++){
	 				var nodeData = oTableBaselines.fnGetData(selectedRows[tmp].rowIndex-1);
	 				
	 				selectedTablesID.push({table_id : tableid, baseline: nodeData.baselineid, location: nodeData.locationid});
                    
					//initialize table
					initBaselineTable(tableid);
					
					//populate table rows 
					populateTable(tableid, nodeData.uri, filters, nodeData.osdata, selectedRows.length);	 					
	 			}
		 	}
            
            function populateTable(tableid, uri, filters, osdata, selectedBlCount){
            	var list = uri.split("/");
				var locid = list[5];
				var baselineid = list[7];
            	
            	//get all the baselines based on filter condition
            	var handlers =	{
                    			success : function(data) {
                        			getBundleDataSuccess(data, tableid, filters, osdata, baselineid, selectedBlCount, locid);
									
									var nodeData =  $(tableid).dataTable().fnGetData();                             
                                    //Show the hidden select all de-select all options if there are components more then zero
									if(nodeData.length > 0)
			                        {
			                            $('#chkbox-hw-selectall').show();
			                            $('#chkbox-hw-deselectall').show();
			                            $('#chkbox-hw-selectall-lbl').show();
			                            $('#chkbox-hw-deselectall-lbl').show();
			                        }
			                        else{
			                            $('#chkbox-hw-selectall').hide();
			                            $('#chkbox-hw-deselectall').hide();
			                            $('#chkbox-hw-selectall-lbl').hide();
			                            $('#chkbox-hw-deselectall-lbl').hide();
			                            }
									
                    		 	},
                    			error : function(errorInfo) {
                        			getBundleDataError(errorInfo);
                        			closeFilterSplash();
                        			formStateView.setMessage({summary: localizer.getString("hpsum.baseline.custom.retrieveCompMsgError"), status: 'error', changing: false});
                    			}
                			};
                
                
					
                var item = 	{
                				location_id: locid,
				        		baseline_id: baselineid
				        	};
				
				formStateView.setMessage({summary: localizer.getString("hpsum.baseline.custom.retrieveCompMsg"), status: 'unknown', changing: true});
                        
            	//add component rows into table based on the filters
            	BaselinePresenter.getBundleIndexData(item, handlers);
            	
            }
            
			function populateCategoryChecked(arraychecked, type)
			{
				for (var index=0; index < arraychecked.length; index++)
				{
					var category_checked;
					var category_element = HPSUM_CATEGORY + type + '-' + index;
					var value = $(category_element)[0].checked ? true : false;
					if(value == true)
					{
						category_checked = type + ' - ' + arraychecked[index];
							category_checked_final.push(category_checked);
					}
				}
			}
            function getBundleDataSuccess(data, tableid, filters, osdata, baselineid, selectedBlCount, locid) {
				category_checked_final = [];
            	var hardware_checked_new = new Array();
				var hardware_checked_new_dl = new Array();
				var hardware_checked_new_ml = new Array();
				var hardware_checked_new_bl = new Array();
				var hardware_checked_new_sl = new Array();
				var hardware_checked_new_xl = new Array();
				var hardware_checked_new_ws = new Array();
				var hardware_checked_new_apollo = new Array();
				var hardware_checked_new_microserver = new Array();
				var hardware_checked_new_otherseries = new Array();
				var hardware_checked_new_synergy = new Array();
				var components_matched_category = new Array();
				var comps_matched_nonserver = new Array();
				var checked_os_windows = 1;
				var checked_os_linux = 1;
				var checked_os_sles =1;
				var checked_os_vmware = 1;
				var operating_system_checked_new = new Array();
            	var oTable = $(tableid).dataTable();
            	
            	if(!oTable)
            		return;
            	//update total component count 
            	totalCompCount = totalCompCount + data.hapi.output_data.baselines.baseline[0].components.component_available.length;
				var totalComps = data.hapi.output_data.baselines.baseline[0].components.component_available;
				
				if(data.hapi.output_data.baselines.baseline[0].components.hasOwnProperty("component_sigfile_missing"))
				{
					totalCompCount = totalCompCount + data.hapi.output_data.baselines.baseline[0].components.component_sigfile_missing.length;
					totalComps = totalComps.concat(data.hapi.output_data.baselines.baseline[0].components.component_sigfile_missing);
				}        	
				if(data.hapi.output_data.baselines.baseline[0].components.hasOwnProperty("component_signature_invalid"))
				{
					$(INVALIDSIG_WARNING).show();
				}
            	var comps_matched_common = $.grep(totalComps, function(comp, index) {
						                            return (
						                            	(filters.software === true && (comp.product_typeInString === 'Driver' || comp.product_typeInString === 'Software')) ||
						                            	(filters.firmware === true && comp.product_typeInString === 'Firmware')
						                            	);
				});

				var comps_matched_software = $.grep(totalComps, function(comp, index) {
						                            return (
						                            	(filters.software === true && (comp.product_typeInString === 'Software')) 
						                            	);
				});
				if(filters.software === true)
						{
							comps_matched_common= comps_matched_common.concat(comps_matched_software);
							comps_matched_common= uniqueComponents(comps_matched_common);

						}
				
				if(filters.critical || filters.recommended || filters.optional) {
					comps_matched_common = $.grep(comps_matched_common, function(comp, index) {
                                                    if ('criticality' in comp) 
                                                    {
                                                            if (comp.criticality === '' || comp.criticality === 'Unknown') 
                                                            { 
                                                                    return true;
                                                            } else {
                                                               return ( (filters.critical === true && comp.criticality === 'Critical') ||
                                                                     (filters.recommended === true && comp.criticality === 'Recommended') ||
                                                                     (filters.optional === true && comp.criticality === 'Optional'))
                                                            }
                                                    } else {
                                                        // no criticality property in comp
                                                        return true;
                                                    }
                                                
					                           });
				}
				
				if(filters.arch_x86 || filters.arch_x64) {
					comps_matched_common = $.grep(comps_matched_common, function(comp, index) {
                                                        for(var j = 0 ; j < comp.oses.length ; j++)
                                                        {
                                                              if( (filters.arch_x86 === true && (comp.oses[j].platform.match(/x86$/i) || comp.oses[j].platform.match(/nt$/i) || comp.oses[j].platform.match(/noarch$/i))) ||
                                                                (filters.arch_x64 === true && (comp.oses[j].platform.match(/x86_64$/i) || comp.oses[j].platform.match(/vmware_esx_server$/i) || comp.oses[j].platform.match(/ia64$/i) || comp.oses[j].platform.match(/x86-64$/i) || comp.oses[j].platform.match(/nt64$/i) || comp.oses[j].platform.match(/amd64$/i) || comp.oses[j].platform.match(/noarch$/i))) )
                                                                { return true; }
                                                        }

                                                        return false;

							                            
					});
				}
				
				
				
				//filter components based on OS filter 
			     for (var m=0;m<operating_system_final.length;m++)
				    {
					 
					 var value = $('#hpsum-os-type-'+m)[0].checked ? true : false;
					 if(value == true)
					 {
					 //var operating_system_checked = $('#hpsum-os-type-'+m)[0].dataset.model ;
					 var operating_system_checked = $('#hpsum-os-type-'+m).data("model");
					 if(operating_system_checked)
					 {
					 	operating_system_checked_new.push(operating_system_checked);
					 }					 
					 }
					}
					
				 var operating_system_info = {
            		 hapi: {
            			components: {
							component: new Array()
						}
            		}            		
            	};

				operating_system_info.hapi.components.component = operating_system_info.hapi.components.component.concat(comps_matched_common);
					
					for(var p=0;p<operating_system_checked_new.length;p++)
					{
					for(var r=0;r<operating_system_info.hapi.components.component.length;r++)
					{
						var operating_system = "";
						for(var q=0;q<operating_system_info.hapi.components.component[r].oses.length;q++)
						{
							var current_os = operating_system_info.hapi.components.component[r].oses[q].operating_system_name;
							if(current_os.match(/Linux \(x86_64\)/) || current_os.match(/Linux \(x86\)/) || current_os.match(/Linux \(noarch\)/))
							{
								current_os = "Linux nodist";
							}
							if (current_os.match(/Microsoft Windows Server 2008 R2/i))
			                {
			                 operating_system = "Windows 2008 R2";
			                }
							else if (current_os.match(/Microsoft Windows Server 2008/i))
							{
							operating_system = "Windows 2008";
							}
							else if (current_os.match(/Red Hat Enterprise Linux 8/i) || (operating_system_checked_new[p].match(/RHEL 8/) && current_os.match(/Linux nodist/)))
						    {
							operating_system = "RHEL 8";
						    }
							else if (current_os.match(/Red Hat Enterprise Linux 7/i) || (operating_system_checked_new[p].match(/RHEL 7/) && current_os.match(/Linux nodist/)))
						    {
							operating_system = "RHEL 7";
						    }
							else if (current_os.match(/Red Hat Enterprise Linux 6/i) || (operating_system_checked_new[p].match(/RHEL 6/) && current_os.match(/Linux nodist/)))
							{
							 operating_system = "RHEL 6";
							}
							else if (current_os.match(/Red Hat Enterprise Linux 5/i) || (operating_system_checked_new[p].match(/RHEL 5/) && current_os.match(/Linux nodist/)))
							{
							operating_system = "RHEL 5";
							}
							else if (current_os.match(/VMware ESXi 5.0/i))
							{
							operating_system = "VMware ESXi 5.0";
							}
							else if (current_os.match(/VMware vSphere 5.1/i))
							{
							operating_system = "VMware vSphere 5.1";
							}
							else if (current_os.match(/VMware vSphere 5.5/i))
							{
							operating_system = "VMware vSphere 5.5";
							}
							else if (current_os.match(/VMware vSphere 6.0/i))
							{
							operating_system = "VMware vSphere 6.0";
							}
							else if (current_os.match(/VMware vSphere 6.5/i))
							{
								operating_system = "VMware vSphere 6.5";
							}
							else if (current_os.match(/VMware vSphere 6.7/i))
							{
								operating_system = "VMware vSphere 6.7";
							}
							else if (current_os.match(/VMware ESXi 7.0/i))
							{
								operating_system = "VMware vSphere 7.0";
							}
							else if (current_os.match(/SUSE LINUX Enterprise Server 11/i) || (operating_system_checked_new[p].match(/SLES 11/) && current_os.match(/Linux nodist/)))
							{
							 operating_system = "SLES 11";
							}
							else if (current_os.match(/SUSE Linux Enterprise Server 12/i) || (operating_system_checked_new[p].match(/SLES 12/) && current_os.match(/Linux nodist/)))
							{
							operating_system= "SLES 12";
							}
							else if (current_os.match(/SUSE Linux Enterprise Server 15/i) || (operating_system_checked_new[p].match(/SLES 15/) && current_os.match(/Linux nodist/)))
							{
							operating_system= SLES_15;
							}
							else if (current_os.match(/Microsoft Windows Server 2012 R2/i))
			                {
			                operating_system = "Windows 2012 R2";
			                }
							else if (current_os.match(/Microsoft Windows Server 2012/i))
			                {
			                operating_system = "Windows 2012";
			                }
                            else if (current_os.match(/Microsoft Windows Server 2016/i))
							{
							operating_system = "Windows 2016";
							}
                            else if (current_os.match(/Microsoft Windows Server 2019/i))
							{
							operating_system = "Windows 2019";
							}							
							else {
								operating_system = "Unsupported OS";
							}
							if (operating_system_checked_new[p].slice(0,7) != 'Windows')
							{
							checked_os_windows = 0;
							}
							if (operating_system_checked_new[p].slice(0,4) != 'RHEL')
							{
							checked_os_linux = 0;
							}
							if (operating_system_checked_new[p].slice(0,4) != 'SLES')
							{
							checked_os_sles = 0;
							}
							if(operating_system_checked_new[p].slice(0,6) != 'VMware')
							{
							checked_os_vmware = 0; 	
							}
							if (operating_system_checked_new[p] == operating_system)
							{
								
								var components_file = operating_system_info.hapi.components.component[r].component_file_name;
								components_operating_system.push(components_file);
							}
						}
					}
					}
				
				
					
					if(components_operating_system.length > 0)
					{
					comps_matched_common = $.grep(comps_matched_common, function(comp, index) {
										
									if ($.grep(components_operating_system, function(comp2, index2) {
			                            return (comp2 === comp.component_file_name);
			                        }).length > 0) {
			                            return true;
			                        }
			                        
			                        return false;					
					});
					}
					if(filters.device_oa || filters.device_vc || filters.device_sasswitches || filters.device_enclosure)
					{
						 comps_matched_nonserver = $.grep(comps_matched_common, function(comp, index) {

							                            return (
																(filters.device_oa === true && comp.product_subtypeInString === 'OA') ||
																(filters.device_vc === true && comp.product_subtypeInString === 'VC') ||
																(filters.device_sasswitches === true && comp.product_subtypeInString === 'Solex') ||
																(filters.device_enclosure === true && (comp.product_subtypeInString == 'Enclosure'))
							                            		);
					});
					var comps_matched_synergy = $.grep(comps_matched_common, function(comp, index) {
							                            return ((filters.device_enclosure === true && (comp.product_subtypeInString == 'Enclosure')));
					});
					}
					populateCategoryChecked(bios_cat_array, HPE_BIOS);
					populateCategoryChecked(firmware_cat_array, HPE_FIRMWARE);
					populateCategoryChecked(software_cat_array, HPE_SOFTWARE);
					populateCategoryChecked(driver_cat_array, HPE_DRIVER);
					if(category_checked_final.length > 0)
					{
						//filter out the components based on user selection
						components_matched_category = $.grep(comps_matched_common, function(comp, index) {
						
									if ($.grep(category_checked_final,function(comp2, index2) {
			                            return (comp2 === comp.category);
			                        }).length > 0) {
			                            return true;
			                        }
			                        
			                        return false;					
							});
					}
					// Filter out the OA + VC + SAS (Enclosure) components in the array
					// This is done only if the user has selected any of OA + VC or SAS checkbox
					var enclosure_components = $.grep(components_matched_category, function(comp, index) {
							return (((filters.device_oa === true && comp.product_subtypeInString === 'OA') ||
										( filters.device_vc === true && comp.product_subtypeInString === 'VC') ||
										( filters.device_sasswitches === true && comp.product_subtypeInString === 'Solex') ||
										( filters.device_enclosure === true && comp.product_subtypeInString == 'Enclosure')));
						});		
						
					//Remove the OA + VC + SAS components from this as these components are not really applicable on any server.
					var components_matched_category = $.grep(components_matched_category, function(comp, index) {
							return (!((comp.product_subtypeInString === 'OA') ||
										(comp.product_subtypeInString === 'VC') ||
										(comp.product_subtypeInString === 'Solex') ||
										(comp.product_subtypeInString == 'Enclosure')));
							});
							// In case the user has selected the OA VC, or SAS filters, append these back conditionally to the array.
					if(enclosure_components.length > 0)
					{
						components_matched_category = components_matched_category.concat(enclosure_components);
					}					
					if(components_matched_category.length > 0)
					{
						if (comps_matched_nonserver.length > 0)
						{
							comps_matched_nonserver = comps_matched_nonserver.concat(components_matched_category);
						}
						else
						{
							comps_matched_nonserver = components_matched_category;
						}

					}
						
					//filter components based on Hardware filter 
					if (disable_hardwareFilter_flag == false)
					{
					for (var m=0;m<dl_array.length;m++)
					{
						var value = $('#hpsum-hardware-type-dl-'+m)[0].checked ? true : false;
						if(value == true)
						{
							var hardware_checked_dl;
								if ( $('#hpsum-hardware-type-dl-'+m)[0].dataset !== undefined ) 
									hardware_checked_dl = $('#hpsum-hardware-type-dl-'+m)[0].dataset.model;
								else
									hardware_checked_dl = $('#hpsum-hardware-type-dl-'+m)[0].getAttribute('data-model'); 

							hardware_checked_new_dl.push(hardware_checked_dl);
						}
						
					}
					for (var m=0;m<ml_array.length;m++)
					{
						var value = $('#hpsum-hardware-type-ml-'+m)[0].checked ? true : false;
						if(value == true)
						{
							var hardware_checked_ml;
								if( $('#hpsum-hardware-type-ml-'+m)[0].dataset !== undefined )
									hardware_checked_ml = $('#hpsum-hardware-type-ml-'+m)[0].dataset.model;
								else
									hardware_checked_ml = $('#hpsum-hardware-type-ml-'+m)[0].getAttribute('data-model'); 

			                hardware_checked_new_ml.push(hardware_checked_ml);
						}
					}
					
					for (var m=0;m<bl_array.length;m++)
					{
						var value = $('#hpsum-hardware-type-bl-'+m)[0].checked ? true : false;
						if(value == true)
						{
							var hardware_checked_bl;
								if ( $('#hpsum-hardware-type-bl-'+m)[0].dataset !== undefined )
									hardware_checked_bl = $('#hpsum-hardware-type-bl-'+m)[0].dataset.model;
								else
									hardware_checked_bl = $('#hpsum-hardware-type-bl-'+m)[0].getAttribute('data-model');

							hardware_checked_new_bl.push(hardware_checked_bl);
						}
					}
					for (var m=0;m<sl_array.length;m++)
					{
						var value = $('#hpsum-hardware-type-sl-'+m)[0].checked ? true : false;
						if(value == true)
						{
							var hardware_checked_sl;
								if( $('#hpsum-hardware-type-sl-'+m)[0].dataset !== undefined )
									hardware_checked_sl = $('#hpsum-hardware-type-sl-'+m)[0].dataset.model;
								else
									hardware_checked_sl = $('#hpsum-hardware-type-sl-'+m)[0].getAttribute('data-model');
								
				        	hardware_checked_new_sl.push(hardware_checked_sl);
						}
					}
					for (var m=0;m<xl_array.length;m++)
					{
						var value = $('#hpsum-hardware-type-xl-'+m)[0].checked ? true : false;
						if(value == true)
						{
							var hardware_checked_xl;
								if( $('#hpsum-hardware-type-xl-'+m)[0].dataset !== undefined )
									hardware_checked_xl = $('#hpsum-hardware-type-xl-'+m)[0].dataset.model;
								else
									hardware_checked_xl = $('#hpsum-hardware-type-xl-'+m)[0].getAttribute('data-model');
								
				        	hardware_checked_new_xl.push(hardware_checked_xl);
						}
					}
					for (var m=0;m<ws_array.length;m++)
					{
						var value = $('#hpsum-hardware-type-ws-'+m)[0].checked ? true : false;
						if(value == true)
						{
							var hardware_checked_ws;
								if( $('#hpsum-hardware-type-ws-'+m)[0].dataset !== undefined )
									hardware_checked_ws = $('#hpsum-hardware-type-ws-'+m)[0].dataset.model;
								else
									hardware_checked_ws = $('#hpsum-hardware-type-ws-'+m)[0].getAttribute('data-model');
								
				        	hardware_checked_new_ws.push(hardware_checked_ws);
						}
					}

					for (var m=0;m<otherseries_array.length;m++)
					{
						var value = $('#hpsum-hardware-type-otherseries-'+m)[0].checked ? true : false;
						if(value == true)
						{
							var hardware_checked_otherseries;
								if( $('#hpsum-hardware-type-otherseries-'+m)[0].dataset !== undefined )
									hardware_checked_otherseries = $('#hpsum-hardware-type-otherseries-'+m)[0].dataset.model;
								else
									hardware_checked_otherseries = $('#hpsum-hardware-type-otherseries-'+m)[0].getAttribute('data-model');
								
				        	hardware_checked_new_otherseries.push(hardware_checked_otherseries);
						}
					}
					for (var idx=0;idx<synergy_array.length;idx++)
					{
						var value = $('#hpsum-hardware-type-synergy-'+idx)[0].checked ? true : false;
						if(value == true)
						{
							var hardware_checked_synergy;
								if( $('#hpsum-hardware-type-synergy-'+idx)[0].dataset !== undefined )
									hardware_checked_synergy = $('#hpsum-hardware-type-synergy-'+idx)[0].dataset.model;
								else
									hardware_checked_synergy = $('#hpsum-hardware-type-synergy-'+idx)[0].getAttribute('data-model');
								
				        	hardware_checked_new_synergy.push(hardware_checked_synergy);
						}
					}
					if($(SYNERGY_CHKBOX)[0].checked == true) {
						hardware_checked_final = hardware_checked_new_dl.concat(hardware_checked_new_bl,hardware_checked_new_ml,hardware_checked_new_sl,hardware_checked_new_xl,hardware_checked_new_ws,hardware_checked_new_apollo,hardware_checked_new_microserver,hardware_checked_new_otherseries,hardware_checked_new_synergy);
					}
					else {
						hardware_checked_final = hardware_checked_new_dl.concat(hardware_checked_new_bl,hardware_checked_new_ml,hardware_checked_new_sl,hardware_checked_new_xl,hardware_checked_new_ws,hardware_checked_new_apollo,hardware_checked_new_microserver,hardware_checked_new_otherseries);
					}
					for(var i=0;i<hardware_info.length;i++)
					{
						if(hardware_info[i].data.BaselineServerData != undefined) {

						if(hardware_checked_final.length > 0)
						{
							for(var j=0; j< hardware_info[i].data.BaselineServerData.platform_independent_comp_list.length;j++)
							{
								components_hardware_checked.push(hardware_info[i].data.BaselineServerData.platform_independent_comp_list[j]);
							}
						}
					
					
						for (var l=0;l<hardware_info[i].data.BaselineServerData.servers_component_info.length;l++)
						{
							for (var r=0;r<hardware_checked_final.length;r++)
							{  
								// In case of Server names with HPE, there will no space, hence the check for HPE does not check for a 
								// space in between. 
							    if((hardware_info[i].data.BaselineServerData.servers_component_info[l].system_name == HP_PROLIANT + hardware_checked_final[r] +" Server") || 
									(hardware_info[i].data.BaselineServerData.servers_component_info[l].system_name == HPE_PROLIANT + hardware_checked_final[r] +" Server") ||
									(hardware_info[i].data.BaselineServerData.servers_component_info[l].system_name == HPE_SYNERGY + hardware_checked_final[r] +" Compute Module")||
									(hardware_info[i].data.BaselineServerData.servers_component_info[l].system_name == HPE_APOLLO + hardware_checked_final[r] +" Server")||
									(hardware_info[i].data.BaselineServerData.servers_component_info[l].system_name == HP_PROLIANT + hardware_checked_final[r]) ||
									(hardware_info[i].data.BaselineServerData.servers_component_info[l].system_name ==HPE_PROLIANT + hardware_checked_final[r]))
								{
								for(var j=0; j< hardware_info[i].data.BaselineServerData.servers_component_info[l].comp_list.length;j++)
								{
									components_file = hardware_info[i].data.BaselineServerData.servers_component_info[l].comp_list[j];
									components_hardware_checked.push(components_file);
								}
						        
								}
							}
						}
						}
					}
					}

					//fix QXCR1001417082 : when selected one or more "Enclosure and individual device type" with
					//one or more "Server model", filtering should happen as on "comps_matched_nonserver" as in "if"case.
					// When NO  "Enclosure and individual device type" options selected and only "Server model" selection is there
					// filtering should happen on "comps_matched_common".
					
					if(components_hardware_checked.length > 0)
					{
						var comps_matched_server = [];
						if (!(filters.device_oa || filters.device_vc || filters.device_sasswitches || category_checked_final.length > 0 ) || comps_matched_nonserver.length > 0)
						{
							comps_matched_server = $.grep(comps_matched_common, function(comp, index) {
										
									if ($.grep(components_hardware_checked,function(comp2, index2) {
			                            return (comp2 === comp.component_file_name);
			                        }).length > 0) {
			                            return true;
			                        }
			                        
			                        return false;					
							});

							// Filter out the OA + VC + SAS (Enclosure) components in the array
							// This is done only if the user has selected any of OA + VC or SAS checkbox
							var enclosure_components = $.grep(comps_matched_server, function(comp, index) {
								return (((filters.device_oa === true && comp.product_subtypeInString === 'OA') ||
											( filters.device_vc === true && comp.product_subtypeInString === 'VC') ||
											( filters.device_sasswitches === true && comp.product_subtypeInString === 'Solex')));
								});
								
							//Remove the OA + VC + SAS components from this as these components are not really applicable on any server.
							var comps_matched_server = $.grep(comps_matched_server, function(comp, index) {
								return (!((comp.product_subtypeInString === 'OA') ||
											(comp.product_subtypeInString === 'VC') ||
											(comp.product_subtypeInString === 'Solex')));
							});
							// In case the user has selected the OA VC, or SAS filters, append these back conditionally to the array.
							if(enclosure_components.length > 0)
							{
								comps_matched_server = comps_matched_server.concat(enclosure_components);
							}
						}
						
						if (typeof comps_matched_nonserver != 'undefined' && comps_matched_nonserver.length > 0)
						{
							if((typeof comps_matched_synergy != 'undefined') || (filters.device_oa || filters.device_vc || filters.device_sasswitches || category_checked_final.length > 0 )) 
							{
								comps_matched_server= commonComponents(comps_matched_server,comps_matched_nonserver);
								comps_matched_server = uniqueComponents(comps_matched_server);
							}
						}
					}
					
					var comps_matched;
					if (components_hardware_checked.length > 0)
					{
						comps_matched = comps_matched_server;
					}
					else if (components_hardware_checked.length ==0)
					{
					    if (filters.device_oa || filters.device_vc || filters.device_sasswitches || filters.device_enclosure || category_checked_final.length > 0){
					        comps_matched = comps_matched_nonserver;
					    }
					    else if (!(filters.device_oa  || filters.device_vc || filters.device_sasswitches || filters.device_enclosure || category_checked_final.length > 0)){
					        comps_matched = comps_matched_common;
					    }
						
					}
					if($(SYNERGY_CHKBOX)[0].checked == true) {
							if (typeof comps_matched_synergy != 'undefined') {
									comps_matched = comps_matched.concat(comps_matched_synergy);
									comps_matched = uniqueComponents(comps_matched);
							}
					}

				if(comps_matched.length > 0)
            	{
                    //If no components have already been added, we add all components from 
                    //current baseline to the filtered components list
                    if($.isEmptyObject(filtered_comp_list)) {
                        for( var i=0; i<comps_matched.length; i++) {
                            var comp = comps_matched[i];
                            var comp_refine = comp.component_file_name.replace(/\./g,'_');
							//if component isfwkg & SUM version is less than MIN_SUM_VER_FWPKG
							 if((comp.component_file_name.indexOf(".fwpkg")!=-1) && (gblHPESUMVersion =="" ||  gblHPESUMVersion < MIN_SUM_VER_FWPKG))
							  {
							   //assign the select to disable incase of fwpkg
							   //toggle should still display disable
							   //remove selected class from fwpkg row
								 comp.select = '<input id="toggle-' + comp_refine + baselineid + '"  style="display:none" type="checkbox" disabled="disabled"/>';
								 $('#toggle-' + comp_refine +baselineid ).hpToggle({
												  unchecked : localizer.getString("hpsum.common.disabled"),
												  checked : localizer.getString("hpsum.common.disabled")
												  }); 
									 var selectid = comp.select.split('"'); 
								    selectid ='#'+ selectid[1];
									$($(selectid)).parent().parent().removeClass('hp-selected');
								 
							  }
							  else
							  {
								comp.select = '<input id="toggle-' + comp_refine + baselineid + '" style="display:none" type="checkbox" checked/>';
							  }
                            
                            comp.baselineid = baselineid;
                            comp.locationid = locid;
                            filtered_comp_list.push(comp.component_file_name); // Fix for QXCR1001387787
                        }
                    }
                    else
                    {
                        //Components already present in the filtered components list from other baseline.
                        //Remove any duplicate components and add the rest to the filtered components list
                        for( var i=comps_matched.length-1; i>=0; i--) 
                        {
                            var comp = comps_matched[i];
                            var comp_refine = comp.component_file_name.replace(/\./g,'_');
							//if component isfwkg & SUM version is less than MIN_SUM_VER_FWPKG
							if( (comp.component_file_name.indexOf(".fwpkg")!=-1) && (gblHPESUMVersion =="" ||  gblHPESUMVersion < MIN_SUM_VER_FWPKG))
							{
								
									//assign the select to disable incase of fwpkg
								   //toggle should still display disable
								   //remove selected class from fwpkg row
									comp.select = '<input id="toggle-' + comp_refine + baselineid + '"  style="display:none" type="checkbox" disabled="disabled"/>';
									$('#toggle-' + comp_refine + baselineid ).hpToggle({
									unchecked : localizer.getString("hpsum.common.disabled"),
									checked : localizer.getString("hpsum.common.disabled")
									}); 
									var selectid = comp.select.split('"'); 
								    selectid ='#'+ selectid[1];
									$($(selectid)).parent().parent().removeClass('hp-selected');							   
								
							}
							else
							{
								comp.select = '<input id="toggle-' + comp_refine + baselineid+ '" style="display:none" type="checkbox" checked/>';
							}
                            
                            comp.baselineid = baselineid;
                            comp.locationid = locid;
			    // Fix for QXCR1001387787
                            // The component is not found in the filtered list add to list
                            if ($.inArray(comp.component_file_name, filtered_comp_list) < 0)                            
                                filtered_comp_list.push(comp.component_file_name);
                            else
                                comps_matched.splice(i,1);
                        }
                    }

					if(operating_system_checked_new.length > 0)
					{
						if (checked_os_windows == 1)
						{
						    var comps_matched_temp = new Array();
						    for (var w=0; w<comps_matched.length;w++)
						    {
						        if(comps_matched[w].component_file_name.slice(-3) != 'rpm' && comps_matched[w].component_file_name.slice(-5) != 'scexe' )
						        {
						            comps_matched_temp.push(comps_matched[w]);							
						        }							
						    }
							
						    comps_matched = comps_matched_temp;
						}

						if (checked_os_linux == 1 || checked_os_sles == 1)
						{
						    var comps_matched_temp = new Array();
						    for (var w=0; w<comps_matched.length;w++)
						    {
						        if(comps_matched[w].component_file_name.slice(-4) != '.exe')
						        {
						            comps_matched_temp.push(comps_matched[w]);
						        }							
						    }
							
						    comps_matched = comps_matched_temp;
						}
						//Fix for QXCR1001538138: [ABS]CBL-Filtering vmware OS will filter rpm components
						if(checked_os_vmware == 1)
						{
						    var comps_matched_temp = new Array();
						    for (var indx=0; indx<comps_matched.length;indx++)
						    {
						        if(comps_matched[indx].component_file_name.slice(-4) != '.rpm')
						        {
						            comps_matched_temp.push(comps_matched[indx]);
						        }							
						    }
							
						    comps_matched = comps_matched_temp;
						}
					}
                    
                    oTable.fnAddData(comps_matched);
					$('.tooltip').hpTooltip();

					$(tableid + ' tbody tr').addClass('hp-selected');
            		NO_COMP_SELECTED = false;
            		enableActionButtons();
            			
            	}
				else
				{
					//Fix for QXCR1001498640: 	CBL - Create CBL ISO option enabled even after zero component filtered
					disableActionButtons();
				}

            	baslinesAdded++;
            	
            	//update filtered component count 
            	filterCompCount = filterCompCount + comps_matched.length;
            	
				//Bind click only after all the sekected baselines are added
				if(selectedBlCount==baslinesAdded){
                    comp_selector_list = $('input[type="checkbox"]', tableid);
                
                //get selected components count
                var currselectedRows = $(tableid + ' tbody tr.hp-selected');
				//check if table has empty component rows based on 'dataTables_empty' class
				if($(tableid + ' tbody tr').length > 0 && $(tableid + ' tbody tr td:first-child').hasClass('dataTables_empty')) {
					selectedCompCount = 0;
				}
				else {
					selectedCompCount = currselectedRows.length;
				}
                                
                //update component count message label and show it on the page after processing all the baselines
				var compCountMsg = localizer.getString('hpsum.baseline.custom.customCompCountMsg' , [totalCompCount,filterCompCount,selectedCompCount]); 
                $(COMPONENTS_COUNT_LABEL).html(compCountMsg).show();
                    
				$(tableid + " tbody tr").click( function( e ) {
            		var srcElem;
					//Check if firefox or (chrome and IE)
					if (e.srcElement) {
						srcElem = e.srcElement;
						//Chrome and IE
						} else {
						srcElem = e.target;
						//Firefox
						}
					var data = oTable.fnGetData(this);
					var clickedCellIndex = srcElem.cellIndex;
					if (clickedCellIndex === undefined) {
						var selectid = data.select.split('"');
						selectid ='#'+ selectid[1];//+'-hpToggle';
						if(srcElem.innerHTML.match(/Selected/i)){
							$(selectid).removeAttr('checked');
							$(selectid).trigger('change');
						} else if(srcElem.innerHTML.match(/Select/i)){
							$(selectid).prop('checked', true);
							$(selectid).trigger('change');
						}						
					}
					
					//toggle row selection	
					//if component isfwkg & SUM version is less than MIN_SUM_VER_FWPKG
					if((data.component_file_name.indexOf(".fwpkg")!=-1) && (gblHPESUMVersion =="" ||  gblHPESUMVersion < MIN_SUM_VER_FWPKG))
						{	
							//disable the fwpkg components
								$(selectid).removeAttr('checked');
							    $(selectid).removeClass('hp-selected');	
						
							
						}
						else
						{							
							$(this).toggleClass('hp-selected');	
						}
					
					
					
					//Select toggle button changes 
					$('#chkbox-hw-selectall')[0].checked =false; 
					$('#chkbox-hw-deselectall')[0].checked =false; 
					var selectid = data.select.split('"');
					selectid='#'+selectid[1];//+'-hpToggle';
					if ($(this).hasClass('hp-selected')) {
						$(selectid).prop('checked', true);
					} else {
						$(selectid).removeAttr('checked');
					}
					$(selectid).trigger('change');

					var selectedRows = $(tableid).dataTable().fnGetNodes();
 					    var count = 0;
 					    for (var tmp = 0; tmp < selectedRows.length; tmp++) 
 					    {
 					       	if (selectedRows[tmp].className.indexOf('hp-selected') != -1)
 					    	count++;
 					    } 
					  	
					  	//update component count message label for every change in component selection
					  	var compCountMsgtemp = localizer.getString('hpsum.baseline.custom.customCompCountMsg' , [totalCompCount,filterCompCount, count]); 
                		$(COMPONENTS_COUNT_LABEL).html(compCountMsgtemp);
                		
						if(count > 0)
						{
							NO_COMP_SELECTED = false;
							enableActionButtons();							
						}
						else
						{
							NO_COMP_SELECTED = true;	
							disableActionButtons();							
						}				
											
										
				});
                    //Update the component selection toggles in batches to prevent the  UI from
                    //freezing when processing a large number of components simultaneoulsy
                    if(comp_selector_list.length == 0)
                    {
                        closeFilterSplash();
                        formStateView.setMessage({summary: localizer.getString("hpsum.baseline.custom.retrieveCompMsgDone"), status: 'ok', changing: false});
                    }
                    else {
                        updatingCompTable = false;
                        compDoneCount = 0;
                        compTimer = setInterval(function(){updateCompTableToggles()}, 1000);
                    }
            	}
				//ToolTip for Components reboot value
					var reb_value;
					if(components_matched_category.length > 0){
						for( var comp = 0; comp < filterCompCount; comp++) {
							var compid = components_matched_category[comp].component_id;
							compid = compid.replace(/(:|\.)/g,'');
							if(components_matched_category[comp].reboot_details.length == 0)
							{
								reb_value = components_matched_category[comp].reboot_required;
							}
							else{
								for(var reb = 0; reb < components_matched_category[comp].reboot_details.length; reb++)
								{
									reb_value = components_matched_category[comp].reboot_details[reb].value;
								}
							}
							reboottooltip(compid,reb_value);
						  }
					}
					else{
						for( var comp = 0; comp < totalComps.length; comp++) {
							var compid = totalComps[comp].component_id;
								compid = compid.replace(/(:|\.)/g,'');
							if(totalComps[comp].reboot_details.length == 0)
							{	
								reb_value = totalComps[comp].reboot_required;
							}
							else{
								for(var reb = 0; reb < totalComps[comp].reboot_details.length; reb++)
								{
									reb_value = totalComps[comp].reboot_details[reb].value;
								}
							}
							reboottooltip(compid,reb_value);
						}
					}
			}
            
			  //This function applies tooltip for component.
			function reboottooltip(compid,rebval)
			{
				switch(rebval){
					case REBOOT_REQ_DETAILS_REQUIRED:
						$('#hpsum-'+compid).attr('tooltip',localizer.getString('hpsum.common.reboot_details.text.Required')).hpTooltip();break;
					case REBOOT_REQ_DETAILS_OPTIONAL:
						$('#hpsum-'+compid).attr('tooltip',localizer.getString('hpsum.common.reboot_details.text.Optional')).hpTooltip();break;
					case REBOOT_REQ_DETAILS_ENVIRONMENTDEPENDENT:
						$('#hpsum-'+compid).attr('tooltip',localizer.getString("hpsum.common.reboot_details.text.EnvironmentDependent")).hpTooltip();break;
					case REBOOT_REQ_DETAILS_YES:
						$('#hpsum-'+compid).attr('tooltip',localizer.getString("hpsum.common.reboot_required.text.yes")).hpTooltip();break;
					case true:
						$('#hpsum-'+compid).attr('tooltip',localizer.getString('hpsum.common.reboot_required.text.yes')).hpTooltip();break;
					default:
						$('#hpsum-'+compid).attr('tooltip',localizer.getString("hpsum.common.reboot_details.text.No")).hpTooltip();break;
				 }
			}
            // This function searches through an array of objects, and removing any duplicate component
            function uniqueComponents(array) {
                return $.grep(array, function (component, index) {
                    return $.inArray(component, array) === index;
                });
            }

            // This function finds the common objects between array1 and array2 and stores the result in array1
            function commonComponents(array1, array2) {
				array1 = $(array2).not($(array2).not(array1));
				return array1;

            }

			
            function updateCompTableToggles() {
                
                if(updatingCompTable)
                    return;
				
				//when baseline selected are > 1; previous deselection of fwpkg row is overrriden with getBundleDataSuccess
				//iterate through the rows to deselct fwpkg component
				var completeData=$(COMPONENTS_TABLE).dataTable().fnGetData(); 
				var count=0;
				for(var comp=0; comp <completeData.length;comp++)
				 {
					 //if component isfwkg & SUM version is less than MIN_SUM_VER_FWPKG
					 if((completeData[comp].component_file_name.indexOf(".fwpkg")!=-1) && (gblHPESUMVersion =="" ||  gblHPESUMVersion < MIN_SUM_VER_FWPKG))
					 {
						 
						 //get the fwpkg row & deselect it
						  var selectid = completeData[comp].select.split('"'); 
							  selectid ='#'+ selectid[1];
							  $($(selectid)).parent().parent().removeClass('hp-selected');
							  count++;
					 }
				}

                //if BL has fwpkg  components & SUM version is less than MIN_SUM_VER_FWPKG;show the warning
				if (count > 0) {
				    $(FWPKG_SUM_LOW_VERSION).show();
				}
				
				//Display the component count message
				var selCompCount = 0;
            	selCompCount = $(COMPONENTS_TABLE + ' tbody tr.hp-selected').length;
				var compCountMsgtemp = localizer.getString('hpsum.baseline.custom.customCompCountMsg' , [totalCompCount,filterCompCount, selCompCount]); 
                $(COMPONENTS_COUNT_LABEL).html(compCountMsgtemp);
                
                updatingCompTable = true;
                var toDoCounter = compDoneCount + 100;
                for(var i = compDoneCount; i < toDoCounter; i++) {
					
					if( (gblHPESUMVersion=="" || gblHPESUMVersion < MIN_SUM_VER_FWPKG)&& (comp_selector_list[i].id.indexOf("fwpkg")!=-1))
					{
						 $(comp_selector_list[i]).hpToggle({
					             //after toggle mark fwpkg as disabled in selected or non selected case
                                 unchecked : localizer.getString("hpsum.common.disabled"),
                                 checked : localizer.getString("hpsum.common.disabled")
						 });
						
					}
					else
					{
                    $(comp_selector_list[i]).hpToggle({
					
                        unchecked : localizer.getString("hpsum.oneTouchUpdate.select"),
                        checked : localizer.getString("hpsum.oneTouchUpdate.selected")
                    });
					}
                    compDoneCount++;
                    if(compDoneCount == comp_selector_list.length) {
                        clearInterval(compTimer);
                        closeFilterSplash();
                        formStateView.setMessage({summary: localizer.getString("hpsum.baseline.custom.retrieveCompMsgDone"), status: 'ok', changing: false});
                        break;
                    }
                }
                updatingCompTable = false;
                return;
            }
            
            function showFilterSplash(){
                
                 $('#hpsum-filter-dialog').dialog({
                    modal : true,
                    position : "center",
                    draggable : false,
                    resizable : false,
                    show : 'fade',
                    dialogClass : 'hp-splash-dialog',
                    width : 400
                });
                
                $('#hpsum-filter-spinner').show();   
            }
            
            function closeFilterSplash()
            {
                $('#hpsum-filter-spinner').hide();
                $('#hpsum-filter-dialog').dialog().dialog('destroy');
            }
            
            function getBundleDataError(error) {
                closeFilterSplash();
            }
            
            //Initialize install review table to add all the components
            function initBaselineTable(tableid) {
            	
            	var data = [{
							select:'',
            				component_file_name: 'cp0000.exe',
            				package_name: 'HP Package',
            				component_version: '2012.10.10',
							sigfile_location: '',
							baselineid: '',
                			Configured: 'Yes'}];
				    
				var oTab = $(tableid).dataTable({
					oLanguage: {
					    sEmptyTable: localizer.getString('hpsum.baseline.custom.noMatchingComponents'),
					    sSearch: localizer.getString('hpsum.common.search')
							   },
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : true,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    aoColumns : [
						{mDataProp: 'select'},
						{mDataProp: 'component_file_name'},
				        {mDataProp: 'package_name'},
				        {mDataProp: 'component_version'},
						{mDataProp: 'sigfile_location',
						fnRender: function (oObj) {
						if(oObj.aData.sigfile_location == "SIGFILE_MISSING")
						{
							return '<div align="center"><div class = "hp-status-value hp-status-warning tooltip" tooltip="Component signature file is missing"></div></div>';
						}
						else
						{
							return '<div align="center"><div class = "hp-status-value hp-status-ok tooltip" tooltip="Component signature file is present"></div></div>';
						}
						}
						},
						{mDataProp: 'reboot_details', sDefaultContent: "",
						fnRender: function (oObj) {
							var compId = oObj.aData.component_id;
							compId = compId.replace(/(:|\.)/g,'');
							if(oObj.aData.reboot_details.length == ""){
								if(oObj.aData.reboot_required == REBOOT_DEFAULT_YES){
									return '<div id="hpsum-'+ compId + '" align="center" class="">' + localizer.getString("hpsum.common.reboot_details.value.required") +'</div>';
								}
							else if(oObj.aData.reboot_required == REBOOT_DEFAULT_NO){
								return '<div id="hpsum-'+ compId + '" align="center" class="">' + localizer.getString("hpsum.common.reboot_required.value.no") +'</div>';
								}
							}
							else
							{
								for(var reb = 0; reb < oObj.aData.reboot_details.length; reb++)
								{
									var reb_value = oObj.aData.reboot_details[reb].value;
									switch (reb_value) {
										case REBOOT_REQ_DETAILS_REQUIRED:
											return  '<div id="hpsum-'+ compId + '" align="center" class=""><div>'+ localizer.getString("hpsum.common.reboot_details.value.required") +'</div></div>'; break;
										case REBOOT_REQ_DETAILS_OPTIONAL:
											return '<div id="hpsum-'+ compId + '" align="center" class="">' + localizer.getString("hpsum.common.reboot_details.value.optional") +'</div>'; break;
										case REBOOT_REQ_DETAILS_ENVIRONMENTDEPENDENT:
											return '<div id="hpsum-'+ compId + '" align="center" class="">' + localizer.getString("hpsum.common.reboot_details.value.environmentdependent") +'</div>'; break;
										case REBOOT_REQ_DETAILS_YES:
											return '<div id="hpsum-'+ compId + '" align="center" class="">' + localizer.getString("hpsum.common.reboot_details.value.required") +'</div>'; break;
										default:
											return '<div id="hpsum-'+ compId + '" align="center" class="">' + localizer.getString("hpsum.common.reboot_details.value.no") +'</div>'; break;
									}
								}
							}
						}},
				        {mDataProp: 'baselineid', "bVisible": false}],
				    aaSorting: [],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        
				        return nRow;
				    }
				    });
			 
				$(tableid + ' tbody tr').first().addClass('hp-selected');
			}
			
			//Initialize Baseline sources table to list all the available baselines
            function initSourcesTable() {
            	
            	var data = [{
							select: 'Select',
            				name: 'HP Proliant SPP',
            				version: '2013.04.23',
            				location: 'C:/SPP',
            				baselineid: 'bp0001',
            				uri: 'baseline/location..../bp00001',
            				osdata: 'obj'
            				}];
				    
				var oTab = $(SOURCES_TABLE).dataTable({
					oLanguage: {
					    sEmptyTable: localizer.getString('hpsum.baseline.custom.noBaselinesAvailable'),
					    sSearch: localizer.getString('hpsum.common.search')
							   },
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : false,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    aoColumns : [
						{mDataProp: 'select'},
				    	{mDataProp: 'name'},
				    	{mDataProp: 'version'},
				        {mDataProp: 'location'},
				        {mDataProp: 'baselineid', "bVisible": false},
				        {mDataProp: 'uri', "bVisible": false},
				        {mDataProp: 'osdata', "bVisible": false}
				        ],
				    aaSorting: [],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        //$(nRow).attr('id', aData.component_file_name);
				        return nRow;
				    }
				    });
			 
				$(SOURCES_TABLE + ' tbody tr').first().addClass('hp-selected');
				
				oTableBaselines = $(SOURCES_TABLE).dataTable();
			}
            
            function enableActionButtons()
			{
				if(addInProgress)
					return;
				
				components_hardware_checked = [];
				components_operating_system = []; 

				var descr = $(DESCR).val(); 
				if (descr.length <= 0 || $(DATE_VERSION).val().length <= 0 || NO_COMP_SELECTED)
				{
					$(CREATE).attr("disabled", true);
					$(SAVEAS).attr("disabled", true);
					return false;
				}
				
				var hpsumSourceType = $(HPSUM_SOURCE_LOCATION_OPTION).val();
				var instHPSUMLocBrowse = $(HPSUM_LOC_BROWSE).data('plugin_hpsumBrowse');	
				var instTargetLocBrowse = $(TARGET_LOC_BROWSE).data('plugin_hpsumBrowse');
				
				if(instTargetLocBrowse && instTargetLocBrowse.getLocation().length <=0 || (hpsumSourceType != 'DNI' && instHPSUMLocBrowse && instHPSUMLocBrowse.getLocation().length <= 0)) 
				{
					$(CREATE).attr("disabled", true);
					$(SAVEAS).attr("disabled", true);
					return false;
				}
				
				if(!berror)
				{
					cleanErrorMessage();
				}
				
				if($('#chkbox-bootableiso')[0].checked)
				{
					var instIsoLocBrowse = $(ISO_LOC_BROWSE).data('plugin_hpsumBrowse');
					if(instIsoLocBrowse && instIsoLocBrowse.getLocation().length <=0) 
					{
						$(CREATE).attr("disabled", true);
						$(SAVEAS).attr("disabled", true);
						return false;
					}
					
					if(isxorriso_present == false && $(NONUEFI_CHECKBOX)[0].checked == false)
					{
						$(CREATE).attr("disabled", true);
						return false;
				}
				}
				
				$(SAVEAS).attr("disabled", $('#chkbox-bootableiso')[0].checked);
				$(CREATE).attr("disabled", false);
			}
			
			function disableActionButtons()
			{
				$(CREATE).attr("disabled", true);
          		$(SAVEAS).attr("disabled", true);
				
			}

			function disableAll()
			{
				//$("#hpsum-custom-baselines-add-form :input").prop("disabled", true);
				$(ADDBASELINE).attr("disabled",true);
				$(SELECT_COMPTYPE).attr("disabled",true);
				$(SOURCES_TABLE).removeClass('hp-selectable');
				$(COMPONENTS_TABLE).removeClass('hp-selectable');
			}
			
			function enableAll()
			{
				//$("#hpsum-custom-baselines-add-form :input").prop("disabled", false);
				$(FORM).attr("disabled",false);
				$(CUSTOM_PANEL).attr("disabled",false);
				$(ADDBASELINE).attr("disabled",false);
				$(SELECT_COMPTYPE).attr("disabled",false);
				$(SOURCES_TABLE).addClass('hp-selectable');
				$(COMPONENTS_TABLE).addClass('hp-selectable');
				// Fix for QXCR1001410418, set HP SUM path browse button enable/disable for selected HP SUM source location type
				var hpsumSourceType = $(HPSUM_SOURCE_LOCATION_OPTION).val();
				$(HPSUM_LOC_BROWSE).children().prop("disabled", (hpsumSourceType == 'CD' ? false : true));
				$(CANCEL).attr("disabled", false);
				formStateView.setautotrack(false);
				$(OAEFM_CHKBOX).attr("disabled", true);
			}

			function cleanErrorMessage()
			{
				
				$('#hpsum-cbl-descr-error').empty();
				$('#hpsum-cbl-version-error').empty();
				$('#hpsum-cbl-targetloc-error').empty();
				$('#hpsum-cbl-apply-filter-error').empty();
				berror = false;
			}
			function onCSMValidationSuccess(data) {            	
            	closeSaveWait();
            	var msg;
            	
            	if(data.hapi.hcode === 0) {
            		msg = 'ok';            		
            	} else {
            		msg = 'error';            		
            	}
                
                $('#hpsum-vbl-summary').show();
                $('#hpsum-vbl-components').show();
                $(TOTAL_SUMMARY).html(data.hapi.total_no_of_component + localizer.getString('hpsum.baseline.validate.totalSummary'));
                $(MISSING_SUMMARY).html(data.hapi.total_no_of_missing_component + localizer.getString('hpsum.baseline.validate.missingSummary'));
                $(MATRIX_LABEL).html(localizer.getString('hpsum.baseline.validate.csmPath'));
                initComponentsTable();
                populateComponentsTable(data);
               	formStateView.setMessage({
                    summary: data.hapi.hmessage,
                    status: msg,
                    details: ""});
            	if(data.hapi.hcode === 0)
            	{
            		NO_COMP_SELECTED = false;
            		enableActionButtons();            		
            	}
            	else
            		disableActionButtons();
            }
            
            function onCSMValidationError(data) {            	
            	closeSaveWait();
            }
			

            //Initialize install components table to add all the missing components
            function initComponentsTable() {
                
                  nodeTable = $(COMPONENTS_CSM_TABLE).dataTable({
                        oLanguage: {
                            sEmptyTable: localizer.getString('hpsum.node.noItemsFound'),
                            sSearch: localizer.getString('hpsum.common.search')
                               },
                    sScrollY: "400px",
                    bScrollCollapse: true,
                    bPaginate : false,
                    bProcessing : true,
                    bFilter : true,
                    bSort : true,
                    bAutoWidth : true,
                    bInfo : false,
                    bRetrieve : true,
                     bDestroy : true,
                        aoColumns : [     
                            {mDataProp: 'component_id'},                       
                            {mDataProp: 'package_name'},
                            {mDataProp: 'component_version'},
                            {mDataProp: 'found'}],
                    aaSorting: [],
                    });
                nodeTable.fnClearTable();
            }

            function populateComponentsTable(data){

                nodeTable = $(COMPONENTS_CSM_TABLE).dataTable();
                nodeTable.fnClearTable();
                nodeTable.fnAddData(data.hapi.missing_comp_list.component);
                nodeTable.fnAddData(data.hapi.available_components.component);                   
            }
			function setLocationType(){
				
				var instCSMFilterLocBrowse = $(CSM_LOC_BROWSE).data('plugin_hpsumBrowse');
				$('#hpsum-FTP-CSM-msg').hide();					
	             if($(LOCATION_TYPE).val() == 'local'){
	             	var instCSMFilterLocBrowse = $(CSM_LOC_BROWSE).data('plugin_hpsumBrowse');
	                $('#hpsum-vbl-summary').hide();
	                $('#hpsum-vbl-components').hide();
	                $('#hpsum-validate-csm-local').hide();
	                $('#hpsum-validate-csm-version').hide();
	                $('#hpsum-validate-csm-ftp').hide();
	                $('#hpsum-matrix-from-ftp').show();
	                $(PROXY_OPTIONS).hide();
	                $(RETRIEVE_MATRIX_BUTTON).show();
	                if(instCSMFilterLocBrowse) {
	                	instCSMFilterLocBrowse.setPanelLabel(localizer.getString('hpsum.baseline.validate.csmPath'));
	                	instCSMFilterLocBrowse.setPanelText("");
	                }
	                if(instCSMFilterLocBrowse) {	
                    	instCSMFilterLocBrowse.setBrowseOptions({bshowXml: true, bshowFile: false, bShowHPSUMFiles: false, bShowEmptyFolder: false, bCreateDirectory: false});
                    }
	                $(RETRIEVE_MATRIX_BUTTON).css( "display", "none" );
	                $(RETRIEVE_MATRIX_BUTTON).off('click',retrieveReciepeFile);
	                formStateView.reset();
	            }
         		else if($(LOCATION_TYPE).val() == 'FTP'){
                    $('#hpsum-validate-csm-local').hide();
                    $('#hpsum-validate-csm-version').hide();
                    $('#hpsum-validate-csm-ftp').hide();
                    $('#hpsum-vbl-summary').hide();
                    $('#hpsum-vbl-components').hide();
                    $('#hpsum-FTP-CSM-msg').show();
                	$(RETRIEVE_MATRIX_BUTTON).hide();
                    $(".hpsum-proxy").attr("disabled", true);
                    $('#hpsum-matrix-from-ftp').hide();
                    
                    
                    	
                    
                    	
		 			formStateView.reset();
                }             
            }
            function onProxyOptionsChange(msg) 
            {
                var value = $(PROXY_OPTIONS).val();
                formStateView.reset();
                if(value == "No" || msg == "No"){
                    $('#hpsum-vbl-proxy-usehp-item').hide();
                    $('#hpsum-vbl-proxy-usescript-item').hide();
                    proxyOptionValue = "No";
                }
                else if(value == "Server"){
		    $('#hpsum-vbl-proxy-url').val("");
                    $('#hpsum-vbl-proxy-port').val("");
                    $('#hpsum-vbl-proxy-username').val("");
                    $('#hpsum-vbl-proxy-password').val("");                   
                    $('#hpsum-vbl-proxy-usehp-item').show();
                    $('#hpsum-vbl-proxy-usescript-item').hide();
                    $('#hpsum-vbl-proxy-url').attr("disabled",false);
                    $('#hpsum-vbl-proxy-port').attr("disabled",false);
                    $('#hpsum-vbl-proxy-username').attr("disabled",false);
                    $('#hpsum-vbl-proxy-password').attr("disabled",false);
                    proxyOptionValue = "Server";
                }
                else if (value == "Script"){
                    $('#hpsum-vbl-proxy-script').val("");
                    $('#hpsum-vbl-proxyscript-username').val("");
                    $('#hpsum-vbl-proxyscript-password').val("");                  
                    $('#hpsum-vbl-proxy-usehp-item').hide();
                    $('#hpsum-vbl-proxy-usescript-item').show();
                    $('#hpsum-vbl-proxy-script').attr("disabled",false);
                    $('#hpsum-vbl-proxyscript-username').attr("disabled",false);
                    $('#hpsum-vbl-proxyscript-password').attr("disabled",false);
                    proxyOptionValue = "Script";
                }
            }
              function retrieveReciepeFile() {
              	
              	var instCSMFilterLocBrowse = $(CSM_LOC_BROWSE).data('plugin_hpsumBrowse');
              	
                var input = {
                    hapi: {
                        working_location :instCSMFilterLocBrowse.getLocation(),
                        proxy_settings: getProxyJsonObject()
                    }
                };
                
                presenter.getPFWReciepefile(input, {
                    success:function(data){
                        closeSaveWait();
                        $(".hpsum-proxy").attr("disabled", true);
                        $('#hpsum-proxy-options').selectBox('disable');

                        var msg;
                        
                        if(data.hapi.hcode === 0) {
                            msg = 'ok';
                            var xmlFile = instCSMFilterLocBrowse.getLocation() + "/MatrixConfig.xml";
                            saveLocalMatrixFile(xmlFile);
                            checkBaselineSelected();
                            $(RETRIEVE_MATRIX_BUTTON).attr("disabled", true);                            
                        }
                        else{
                            msg = 'error';
                        }
                             
                        formStateView.setMessage({
                            summary: data.hapi.hmessage,
                            status: msg,
                            details: ""});
                    },
                    error:function(message) {
                        closeSaveWait();
                    }
                });

                showSaveWait(localizer.getString('hpsum.baseline.validate.retrieveInProgress'));
            }
            function setRetrieveButtonState(){
                if($(LOCATION_TYPE).val() == 'FTP'){
                       var instCSMFilterLocBrowse = $(CSM_LOC_BROWSE).data('plugin_hpsumBrowse');
                       if(instCSMFilterLocBrowse && instCSMFilterLocBrowse.getLocation() == '')
                            $(RETRIEVE_MATRIX_BUTTON).attr("disabled", true);
                        else
                            $(RETRIEVE_MATRIX_BUTTON).attr("disabled", false);
                      }
            }
             function getProxyJsonObject(){
                var proxy_settings;
                if((proxyOptionValue == "No") || (proxyOptionValue == undefined))
                    proxy_settings ='';
                else if(proxyOptionValue == "Server"){
                    proxy_settings = {
                        proxy_username: $('#hpsum-vbl-proxy-username').val(),
                        proxy_password: $('#hpsum-vbl-proxy-password').val(),
                        proxy_ftp_port: $('#hpsum-vbl-proxy-port').val(),
                        proxy_url: $('#hpsum-vbl-proxy-url').val(),
                        use_proxy_script:false
                    };
                }
                else if(proxyOptionValue == "Script"){
                    proxy_settings = {
                        proxy_username: $('#hpsum-vbl-proxyscript-username').val(),
                        proxy_password: $('#hpsum-vbl-proxyscript-password').val(),
                        use_proxy_script: true,
                        proxy_script: $('#hpsum-vbl-proxy-script').val()
                    };
                }
                return proxy_settings;
            }
			            function showSaveWait(msg) {					
					
					if (!waitDialog) {
						waitDialog = $(SPLASH_DIALOG);
						waitDialog.dialog({
							modal : true,
							dialogClass : 'hp-simple-dialog',
							position : "center",
							draggable : false,
							resizable : false,
							closeOnEscape: false,
							width : 260,
							height : 180
						});
					}						                   

					$('#hpsum-bs-validate-wait-message', waitDialog).html(msg);
					$(SPLASH_SPINNER).show();
					msg='';
					waitDialog.dialog('open');
				}

				function closeSaveWait() {
					$(SPLASH_SPINNER).hide();
					if (waitDialog) {
						waitDialog.dialog('close');
					}
				}
            
            /**
             * * Saves the given local matrix xml file and wait for the engine to response
             * * Till engine response page will be blocked. 
             */
            function saveLocalMatrixFile(matrixXmlFile) {
            	var msg = localizer.getString('hpsum.baseline.validate.saveInProgress');
            	showSaveWait(msg);
            	            	
            	var input = {
            		hapi: {
            			uri : matrixXmlFile            			
            		}            		
            	};
            	
            	presenter.saveReciepeFile(input, 
            		{
                        success : onItemSaveSuccess,
                        error : onItemSaveError
                    });            	
            }
            
            
            function onItemSaveSuccess(data) {
            	
            	closeSaveWait();
            	var msg;
            	
            	if(data.hapi.hcode === 0) {
					msg = 'ok';            		
            		$('#hpsum-validate-csm-local').show();
                    $('#hpsum-validate-csm-version').show();
            		var versions = data.hapi.available_versions.matrix_version;
            		var length = versions.length;
					var maxwidth = 0;
					var versiondata ="";
					var canvas = document.createElement('canvas');
					var ctx = canvas.getContext("2d");
					ctx.font = "13px Arial bold";  
            		for(var i = 0; i < length; ++i) {
            			var ver = versions[i].version;
            			var baseline = versions[i].associated_bundle_name;
            			versiondata += '<option value="' + baseline + '_' + i + '">' + ver + '</option>';
						var width = ctx.measureText(ver).width;	
						if(maxwidth < width)
							maxwidth = width;
            		}
					var selectdata = '<select id=hpsum-csm-version class= hp-select' + ' style="width:' + maxwidth + 'px;">';
					selectdata += versiondata;
            		selectdata += '</select>';
            		$('#hpsum-csm-selectbox').html(selectdata);
			$(CSM_VERSION).selectBox({autoWidth: false});
            		var selectvalue = $('#hpsum-csm-version').val();
						selectvalue = selectvalue.substr(0,selectvalue.lastIndexOf('_'));
            		$('#hpsum-starting-bl-used-value').text(selectvalue);	
            		$('#hpsum-csm-version').change(function(){
            			var selectvalue = $('#hpsum-csm-version').val();
							selectvalue = selectvalue.substr(0,selectvalue.lastIndexOf('_'));
            			$('#hpsum-starting-bl-used-value').text(selectvalue);
						if(nodeTable != null)
                            nodeTable.fnClearTable();
                        formStateView.reset();
            		});
            	} else {
            		msg = 'error';
            		$('#hpsum-validate-csm-local').hide();
                    $('#hpsum-validate-csm-version').hide();
            	}
                     
               	formStateView.setMessage({
                    summary: data.hapi.hmessage,
                    status: msg,
                    details: ""});
            	
            }
            
            function onItemSaveError(data) {
            	closeSaveWait();
            }

            
            /**
             * @private
             * Call presenter's addItem() to add a new baseline item into Indexservice
             */
            function onCSMCreate(bsaveas) {
				//Validate the input before proceeding with adding new custom baseline
				var berror = false;
				var errorDetails = '';
				var descr = $(DESCR).val(); 
				if (descr.length <= 0 )
				{
					$('#hpsum-cbl-descr-error').html(localizer.getString("hpsum.baseline.custom.descriptionRequired"));
					berror = true;
					errorDetails = '<p>' + localizer.getString("hpsum.baseline.custom.descriptionRequired") + '</p>';
				}
				
				if (descr.length > MAX_DESCR_LENGTH) { 
		 			$('#hpsum-cbl-descr-error').html(localizer.getString("hpsum.baseline.custom.maxlen") + MAX_DESCR_LENGTH);
		 			berror = true;
					errorDetails = '<p>' + localizer.getString("hpsum.baseline.custom.maxlen") + MAX_DESCR_LENGTH + '</p>';
				}
				
				if($(VERSION2).val().length <= 0)
				{
					$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.versionRequired"));
					berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.versionRequired") + '</p>';
				}
				
				if($(VERSION2).val().length > MAX_VER_LENGTH)
				{
					$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.maxlen") + MAX_VER_LENGTH);
					berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.maxlen") + MAX_VER_LENGTH + '</p>';
				}
				
				var instTargetLocBrowse = $(TARGET_LOC_BROWSE).data('plugin_hpsumBrowse');
				if(instTargetLocBrowse && instTargetLocBrowse.getLocation().length <= 0)
				{
					$('#hpsum-cbl-targetloc-error').html(localizer.getString("hpsum.baseline.custom.targetlocRequired"));
					berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.targetlocRequired") + '</p>';
				}
				
				var descrcheck = /^[\w\-\s]+$/;   
					
			    if ( !descrcheck.test(descr) )
			    {       				
			    	$('#hpsum-cbl-descr-error').html(localizer.getString("hpsum.baseline.custom.descriptionValidationMsg"));
		 			berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.descriptionError") + localizer.getString("hpsum.baseline.custom.descriptionValidationMsg") + '</p>';
		 		}
				
				//var versioncheck = /^[\d]+$/;   
					
			   // if ( !versioncheck.test($(VERSION2).val()) )
			    if ($(VERSION2).val() == '')
			    {       				
			    	$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.versionIdentifierError"));
		 			berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.versionError") + localizer.getString("hpsum.baseline.custom.versionIdentifierError") + '</p>';
		 		}
				
				var instIsoLocBrowse = $(ISO_LOC_BROWSE).data('plugin_hpsumBrowse');
				if($(BOOTABLEISO_CHKBOX)[0].checked && instIsoLocBrowse && instIsoLocBrowse.getLocation().length <=0) 
				{
					$('#hpsum-cbl-isoloc-error').html(localizer.getString("hpsum.baseline.custom.isolocRequired"));
					berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.isolocRequired") + '</p>';
				}
				
				var hpsumPath = '';
				var hpsumSourceType = 'do_not_include';
				
				var instHPSUMLocBrowse = $(HPSUM_LOC_BROWSE).data('plugin_hpsumBrowse');
				
				// Check HP SUM source selection type and location
				if ($(HPSUM_SOURCE_LOCATION_OPTION).val() != 'DNI' && instHPSUMLocBrowse)
				{
					hpsumPath = instHPSUMLocBrowse.getLocation();
					if (hpsumPath.length <=0)
					{
						$('#hpsum-cbl-isoloc-error').html(localizer.getString("hpsum.baseline.custom.hpsumlocationRequired"));
						berror = true;
						errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.hpsumlocationRequired") + '</p>';	
					}
				}
				
				if ($(HPSUM_SOURCE_LOCATION_OPTION).val() == 'ISD')
					hpsumSourceType = 'iso_location';
				else if ($(HPSUM_SOURCE_LOCATION_OPTION).val() == 'CWD')
					hpsumSourceType  = 'current_location';
				else if ($(HPSUM_SOURCE_LOCATION_OPTION).val() == 'CD')
					hpsumSourceType = 'custom_location';
				
				if(berror)
				{
					formStateView.setMessage({
                                summary: localizer.getString("hpsum.baseline.custom.validationErrorMsg"),
                                status: 'error',
                                details: errorDetails});
                                
					return false;
				}
					
				var verstr = $(DATE_VERSION).val();
				verstr = verstr.replace(/\-/g, '.');
				verstr = verstr + '.' + $(VERSION2).val();
				
				var bundlename = $(BASELINE_NAME_LABEL).html();
				
				var isolocation = '';
				if(instIsoLocBrowse) 
					isolocation = instIsoLocBrowse.getLocation(); 
				var targetlocation = '';
				if(instTargetLocBrowse) 
					targetlocation = instTargetLocBrowse.getLocation(); 
				
				var bcreateiso = false, bbootableiso = false;
				if($(CREATEISO_CHKBOX)[0].checked)
					bcreateiso = true;
					
				if($('#chkbox-bootableiso')[0].checked)
					bbootableiso = true;
				
					
				
				var serverlist = [];
				/*if($('#chkbox-server-dl380')[0].checked) {
					serverlist.push('Window2003')
				}*/
				
				var selBaselines = [],selectedRows;
            	if(oTableBaselines)
            	{					
					selectedRows = $(SOURCES_TABLE + ' tbody tr.hp-selected');
			 	} 
			 	for(var tmp=0; tmp < selectedRows.length; tmp++){
	 				var nodeData = oTableBaselines.fnGetData(selectedRows[tmp].rowIndex-1);
	 				var list = nodeData.uri.split("/");
					var baselineid = list[7];
					var locationid = list[5];
					var components = []; 
					var datarows = $(COMPONENTS_CSM_TABLE + ' tbody tr');
					for (var index = 0; index < datarows.length ; index++)
					{
						if(baselineid === nodeTable.fnGetData(index).bundle_id)
							components.push(nodeTable.fnGetData(index).component_id);
					}
					var baselineinfo = {
					          baseline_name : baselineid,
					          location_id : locationid,
					          component: components
					       };
					selBaselines.push(baselineinfo);
				}
				
				/*for(var i=0; i < selectedTablesID.length; i++)
				{
					var oTable = $(selectedTablesID[i].table_id).dataTable();
					if(oTable == undefined)
						continue;
					
					var selectedRows = $(selectedTablesID[i].table_id + ' tbody tr');
					
					var comps = oTable.fnGetData();
					var components = [];
					
					for(var tmp=0; tmp < selectedRows.length; tmp++){
		 				var compData = oTable.fnGetData(selectedRows[tmp].rowIndex-1);
		 				var bselected = false, bforce = false;
		 				
		 				if(selectedRows[tmp].className.indexOf('hp-selected') != -1)
		 					bselected = true;
		 				else
		 					bselected = false;
		 					
		 				if(bselected && (compData.baselineid === selectedTablesID[i].baseline))
		 					components.push(compData.component_file_name);
		 			}
					
					var baselineinfo = {
					          baseline_name : selectedTablesID[i].baseline,
					          component: components
					       };
					
					selBaselines.push(baselineinfo);	
				}*/
				
				if(bsaveas) {
					bcreateiso = false;
					bbootableiso = false;
				    CreateCustomBaselinehandlers.success = function(data) {
                    			createCustomBaselineOnSaveSuccess(data);
                    };
				} else {
					CreateCustomBaselinehandlers.success = function(data) {
                    			createCustomBaselineOnCreateSuccess(data);
                    };
				}			
				var item = {
					  hapi: {
					    bundle_name: bundlename,
					    bundle_header: descr,
					    target_location: targetlocation,
					    iso_location: isolocation,
					    create_ISO: bcreateiso,
					    bootable_ISO: bbootableiso,
					    hpsum_source_path : hpsumPath,
					    hpsum_source_type : hpsumSourceType,
					    version: verstr,
					    baseline_list: {
					      baseline: selBaselines
					    }
					  }
					}; 
				
				if(! addInProgress) {
                    addInProgress = true;
                    $("#hpsum-custom-baselines-add-form :input").prop("disabled", true);
                    
                    formStateView.setMessage({summary: localizer.getString("hpsum.baseline.custom.createCBLMsg"),
                        status: 'unknown', changing: true});
                    
                    presenter.createCustomBaseline(item, CreateCustomBaselinehandlers);                    
                }
				
				return false;
            }
			/**
             * * Reset all the fields such as descr, versions, target location etc
            */
			function reset(bResetFormState)
          	{
				csmfilterselected = false;
          		NO_COMP_SELECTED = true;
          		addInProgress = false;
          		filtered_comp_list = []; // Fix for QXCR1001387787
          		$(CREATE).attr("disabled", true);
          		$(SAVEAS).attr("disabled", true);
          		$(CANCEL).attr("disabled", false);
          		//empty all text boxes and checkboxes
          		$(':text').val('');
				$('#hpsum-custom-baselines-targetloc-hpsumBrowse-input-text').removeClass('hp-tooltipped').removeAttr('tooltip data-tooltip');
          		$(':checkbox').attr('checked', false);
          		$(DESCR).val('');
          		$(BASELINE_NAME_LABEL).html('');
				$(VERSION2).val("00");
				$(SELECT_COMPTYPE).selectBox('value',"both/i");
          		formStateView.setautotrack(true);
          		OnComponentTypeSelectionChange();
          		//This will create a custom baseline name with current values
            	var  name, curDateVersion, monthValue;
				curDateVersion = new Date();
				
				monthValue = curDateVersion.getMonth() + 1;
				name = 'bp' + '-' + curDateVersion.getFullYear() + '-' + monthValue + '-' + curDateVersion.getDate();
				
				$(BASELINE_NAME_LABEL).html(name);
	          	
	          	//This will initialize date picker with current date version
				$(DATE_VERSION).datepicker('setDate', new Date());

				$(CREATEISO_CHKBOX).attr('checked',true); 
				$('#chkbox-bootableiso').attr('checked',false);
				
				//clear tables
				$('#all-cbl-baselines').empty();
				
				$(COMPONENTS_COUNT_LABEL).html('').hide();
							
				cleanErrorMessage();
				$(CUSTOM_INPUT_BROWSE_TEXT).attr('style', 'width:450px;');
				if(bResetFormState) {
					formStateView.reset();
					populateBaselines();
				}
				$('#hpsum-FTP-CSM-msg').hide();
				$('#hpsum-validate-csm-ftp').hide();
                $('#hpsum-validate-csm-local').hide();
                $('#hpsum-vbl-proxy-usehp-item').hide();
                $('#hpsum-vbl-proxy-usescript-item').hide();
                $('#hpsum-vbl-components').hide();
                $('#hpsum-matrix-from-ftp').hide();
				$('#hpsum-custom-baseline-non-matrix-filters').show();
				$('#hpsum-custom-baseline-oaefm-option').show();
				$('#hpsum-validate-csm-location-type').hide();
            	var instCSMFilterLocBrowse = $(CSM_LOC_BROWSE).data('plugin_hpsumBrowse');
                if(instCSMFilterLocBrowse)
                	instCSMFilterLocBrowse.setPanelText('');
            	onBootableIsoClick();
          	}
          	
          	/**
             * * Initialize event functions for fields such as descr, target location, version etc
            */
          	function initialize() {
	          		
          		$(DATE_VERSION).change(function(ev) {
          			var  name;
					name = 'bp' + '-' + $(DATE_VERSION).val() + '-' + $(VERSION2).val();
	          	 	
	          		$(BASELINE_NAME_LABEL).html(name);
	          	});
	          			
          		$(VERSION2).blur(function(){
					var  name;
					name = 'bp' + '-' + $(DATE_VERSION).val() + '-' + $(VERSION2).val();
	          	 	
	          		$(BASELINE_NAME_LABEL).html(name);
	          		
	          		enableActionButtons();
          		});
          	
          		$(DESCR).bind('keypress', function (event) {
          			
          			var theEvent = event || window.event;
					var key = theEvent.keyCode || theEvent.which;
					
					var keychar = String.fromCharCode(key);
					
					var keycheck = /^[\w\-\s]+$/;   
					
					//key 46, 37 and 39 removed from the below condition as key code for keypress event are different than keydown event
					//We are handling these code in keydown event method
					/* code		keypress	keydown
						46		.		    Delete
						37		%		    Left arrow
						39		'		    Right arrow */
					//Ashwini:5/5/14 Added key==46 to if statement as for Firefox, keypress is getting hit for del(46) also.	
					if (!(key == 8  ||  key == 27 || key==46)) // backspace escape
					{
					    if ( !keycheck.test(keychar) )
					    {       
					    	$('#hpsum-cbl-descr-error').html(localizer.getString("hpsum.baseline.custom.descriptionValidationMsg"));
					        theEvent.returnValue = false;//for IE
							
							if (theEvent.preventDefault) 
								theEvent.preventDefault();//Firefox
						}
						else
							return true;
					}
					
					return theEvent.returnValue;
  				});
          		   
          				
          		$(DESCR).blur(function(){
          			if($(DESCR).val().length <= MAX_DESCR_LENGTH)
          			{
          				$('#hpsum-cbl-descr-error').empty();
          				
          				var  name;
						name = 'bp' + '-' + $(DATE_VERSION).val() + '-' + $(VERSION2).val();
						$(BASELINE_NAME_LABEL).html(name);
          			}
          			enableActionButtons();
          		});
          		
          		
          		

					$(VERSION).keydown(function(e) {
						var key = e.which || e.keyCode;
						
						if (!e.shiftKey) { 
						if (!e.shiftKey && !e.altKey && !e.ctrlKey &&
						// comma, period and minus, . on keypad
						key == 190 || key == 188 || key == 109 || key == 110 ||
						// Backspace and Tab and Enter
						key == 8 || key == 9 || key == 13 ||
						// Home and End
						key == 35 || key == 36 ||
						// left and right arrows
						key == 37 || key == 39 ||
						// Del and Ins
						key == 46 || key == 45) {

							return true;
						}

						if (($(VERSION).val().length) < 4) {

							if (
							// numbers
							key >= 48 && key <= 57 ||
							// Numeric keypad
							key >= 96 && key <= 105) {

								return true;
							}

						} else {
							$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.maxlen") + 4);
						}
						}
						e.preventDefault();
					});

					$(VERSION1).keydown(function(e) {
						var key = e.which || e.keyCode;
						if (!e.shiftKey) { 
						if (!e.shiftKey && !e.altKey && !e.ctrlKey &&
						// comma, period and minus, . on keypad
						key == 190 || key == 188 || key == 109 || key == 110 ||
						// Backspace and Tab and Enter
						key == 8 || key == 9 || key == 13 ||
						// Home and End
						key == 35 || key == 36 ||
						// left and right arrows
						key == 37 || key == 39 ||
						// Del and Ins
						key == 46 || key == 45) {

							return true;
						}

						if (($(VERSION1).val().length) < 2) {
							if (
							// numbers
							key >= 48 && key <= 57 ||
							// Numeric keypad
							key >= 96 && key <= 105) {

								return true;
							}

						} else {
							$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.maxlen") + 2);
						}
						}
						e.preventDefault();
					}); 

				
				$(VERSION2).bind('keypress', function (event) {
					
					var theEvent = event || window.event;
					var key = theEvent.keyCode || theEvent.which;
					
					var keychar = String.fromCharCode(key);
					
					var keycheck = /^[a-zA-Z0-9]+$/;
					
					if (!(key == 8  ||  key == 27  || key == 46  || key == 37 || key == 39 || key == 9)) // backspace delete  escape arrows
					{
					    if ( !keycheck.test(keychar) )
					    {       
					        theEvent.returnValue = false;//for IE
							
							if (theEvent.preventDefault) 
								theEvent.preventDefault();//Firefox
						}
						else
							return true;
					}
					
					return theEvent.returnValue;
				});
				
				$(VERSION2).keydown(function(e){
					var key = e.which || e.keyCode;
					
					if (!e.shiftKey && !e.altKey && !e.ctrlKey &&
                     // comma, period and minus, . on keypad
                        key == 190 || key == 188 || key == 109 || key == 110 ||
                     // Backspace and Tab and Enter
                        key == 8 || key == 9 || key == 13 ||
                     // Home and End
                        key == 35 || key == 36 ||
                     // left and right arrows
                        key == 37 || key == 39 ||
                     // Del and Ins
                        key == 46 || key == 45)
                    {
                    	if($(VERSION2).val().length <= MAX_VER_LENGTH)
                    		$('#hpsum-cbl-version-error').empty();
                    	
                        return true;
                    }
					
					
					if ($(VERSION2).val().length < 2) {
						return true;
					} else {
						$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.maxlen") + 2);
					}

                    	
                    /*if (
                     // numbers   
                        key >= 48 && key <= 57 ||
                     // Numeric keypad
                        key >= 96 && key <= 105 )
                    {
                    	if($(VERSION2).val().length < 2)
                    	{
                    		return true;
                    	}
                    	else
                    	{
                    		$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.maxlen") + 2);
                    	}
                    }*/

                    e.preventDefault();
				});
				
				
				$(DESCR).keydown(function(event) {
					
					var currentLen = $(DESCR).val().length;
			        
					if (currentLen > MAX_DESCR_LENGTH) { 
			 			// Trim the field current length over the maxlength.
						$(DESCR).val($(DESCR).val().slice(0, MAX_DESCR_LENGTH));
						$('#hpsum-cbl-descr-error').html(localizer.getString("hpsum.baseline.custom.maxlen") + MAX_DESCR_LENGTH);
			 			event.preventDefault();
			 			return false;
					}
					else
					{
						return true;
					}
			  	});	
          		
          	}
          	
            function onBootableIsoClick()
            {
            	if($(BOOTABLEISO_CHKBOX)[0].checked)
            	{
                    $('#hpsum-bootableiso-opt').show();
                    if(isxorriso_present == false) {
                    	$('.hpsum-nonUEFI').show();
                    	$(NONUEFI_CHECKBOX).attr('checked', false);
            		}

            		$(OAEFM_CHKBOX).attr("disabled", false);
            		removeToolTipAttrAndClass('#oaefm-config');
            	}
            	else
            	{
                    $('#hpsum-bootableiso-opt').hide();
                    $('.hpsum-nonUEFI').hide();

                    if($(OAEFM_CHKBOX)[0].checked) {
                    	$(OAEFM_CHKBOX).attr("checked", false);
                    	$(OAEFM_CHKBOX).trigger('click');
                    	$(OAEFM_CHKBOX).attr("checked", false);	
                    	$(OAEFM_CHKBOX).attr("disabled", true);
                	}

                	$('#hpsum-custom-baseline-matrix-filter-option').show();
            	}	
            	onHPSUMSourceSelection();
            	enableActionButtons();
				
            	// Set focus to ISO Extracted location text box when bootable checkbox is selected
				//fix for QXCR1001412737: no check was added as per the comment above. because of this, set focus was clearing formstateview content. 
				if($(BOOTABLEISO_CHKBOX)[0].checked){
					var instIsoLocBrowse = $(ISO_LOC_BROWSE).data('plugin_hpsumBrowse');
					if(instIsoLocBrowse){
					   instIsoLocBrowse.setFocus();
					}
				}
            }
          	
            function onNonUEFIchkboxClick()
            {
            	enableActionButtons();
            }
          	
			// On selection of Bootable ISO or non-bootable, list HP SUM source selection options and set default accordingly
            function onHPSUMSourceSelection()
            {
				$(HPSUM_SOURCE_LOCATION_TYPE).empty();				
				var selectOption = '';
				if($(BOOTABLEISO_CHKBOX)[0].checked){
					selectOption = '<select id="custom-baseline-hpsum-source-location" class="hp-select"><option value="ISD">' + localizer.getString("hpsum.baseline.custom.extractedISODirectory") + '</option>';
					selectOption += '<option value="CWD" selected="selected">' + localizer.getString("hpsum.baseline.custom.currentWorkingDirectory") + '</option>';
					selectOption += '<option value="CD">' + localizer.getString("hpsum.baseline.custom.customDirectory") + '</option></select>';
				}
				else{
					selectOption = '<select id="custom-baseline-hpsum-source-location" class="hp-select"><option selected="selected" value="CWD">' + localizer.getString("hpsum.baseline.custom.currentWorkingDirectory") + '</option>';
					selectOption += '<option value="CD">' + localizer.getString("hpsum.baseline.custom.customDirectory") + '</option>';
					selectOption += '<option value="DNI">' + localizer.getString("hpsum.baseline.custom.doNotInclude") + '</option></select>';
				}
				
				$(HPSUM_SOURCE_LOCATION_TYPE).append(selectOption);
				$(HPSUM_SOURCE_LOCATION_OPTION).selectBox({autoWidth: false});
				$(HPSUM_SOURCE_LOCATION_OPTION).change(setHPSUMLocationType);
				$(HPSUM_SOURCE_LOCATION_TYPE).attr('tooltip', localizer.getString('hpsum.baseline.custom.hpsumSourceTooltip')).hpTooltip();
                setHPSUMLocationType();
          	}
			
			// On ISO location path change event handler
			function isoLocationChange()
			{
				var instIsoLocBrowse = $(ISO_LOC_BROWSE).data('plugin_hpsumBrowse');
				var instHPSUMLocBrowse = $(HPSUM_LOC_BROWSE).data('plugin_hpsumBrowse');
				
				$('#hpsum-cbl-hpsum_version-error').html('');
				var hpsumlocationType = $(HPSUM_SOURCE_LOCATION_OPTION).val();
				if (hpsumlocationType == 'ISD' && instHPSUMLocBrowse && instIsoLocBrowse && instIsoLocBrowse.getLocation().length <= 0){
					instHPSUMLocBrowse.setPanelText('');
					updateSelectedHPSUMVersion(localizer.getString('hpsum.baseline.custom.hpsumVersionSelected'));
				}
				else if (hpsumlocationType == 'ISD' && instHPSUMLocBrowse && instIsoLocBrowse && instIsoLocBrowse.getLocation().length > 0){
					instHPSUMLocBrowse.setPanelText(instIsoLocBrowse.getLocation());
				}
			}
			
            // On HP SUM source selection change event handler
            function setHPSUMLocationType()
            {
                // Clear error message if any exists
                $('#hpsum-cbl-hpsum_version-error').html('');
                var hpsumSourceType = $(HPSUM_SOURCE_LOCATION_OPTION).val();
                $(HPSUM_LOC_BROWSE + '-option').css('display', (hpsumSourceType == 'DNI' ? 'none' : 'block'));
                $(HPSUM_LOC_BROWSE).children().prop("disabled", (hpsumSourceType == 'CD' ? false : true));
				
                // Default HP SUM version selected is known
                var hpsumversion = updateSelectedHPSUMVersion(localizer.getString('hpsum.baseline.custom.hpsumVersionSelected') + localizer.getString('hpsum.baseline.custom.unknown'));

                var isoLocation = '';
                var instIsoLocBrowse = $(ISO_LOC_BROWSE).data('plugin_hpsumBrowse');
				if(instIsoLocBrowse){
				   isoLocation = instIsoLocBrowse.getLocation();
				}
				
				var instHPSUMLocBrowse = $(HPSUM_LOC_BROWSE).data('plugin_hpsumBrowse');
				
				if (hpsumSourceType == 'CWD'){
					if(instHPSUMLocBrowse){
						if ( navigator.appVersion.indexOf("Win") != -1 )
						{
							var repSlash1 = hpsum_current_directory.split('/').join('\\');
							hpsum_current_directory = repSlash1;			
						}
						instHPSUMLocBrowse.setPanelText(hpsum_current_directory);
						instHPSUMLocBrowse.setInputAttr('background-color', "#F7F4F7");
					}
				       //Get sum version and assign to global var before displaying on UI
					gblHPESUMVersion=getSUMVersion(hpsum_version);
					
					hpsumversion = localizer.getString('hpsum.baseline.custom.hpsumVersionSelected') + hpsum_version;
				}
				else if (hpsumSourceType == 'ISD'){
					if(instHPSUMLocBrowse){
						instHPSUMLocBrowse.setPanelText(isoLocation);
						instHPSUMLocBrowse.setInputAttr('background-color', "#F7F4F7");
					}
					if (isoLocation.length > 0){
						getSourceHPSUMVersion('iso_location', isoLocation);
					}
				}
				else if (hpsumSourceType == 'CD'){
					// Assign default current working directory of HP SUM location when HP SUM source location is empty
					if (instHPSUMLocBrowse){
						instHPSUMLocBrowse.setInputAttr('background-color', "#FFFFFF");
						// Set focus to HP SUM path text box when Custom directory option is selected
						instHPSUMLocBrowse.setFocus();
						// HP SUM path is empty then set default current working directory
						 if (instHPSUMLocBrowse.getLocation().length == 0){
							instHPSUMLocBrowse.setPanelText(hpsum_current_directory);
						}
						
						if (instHPSUMLocBrowse.getLocation().length > 0){
							getSourceHPSUMVersion('custom_location', instHPSUMLocBrowse.getLocation());
						}
					}					
				}
				
				updateSelectedHPSUMVersion(hpsumversion);
				enableActionButtons();;
            }
			
			// This function updates the selected HPSUM version
			function updateSelectedHPSUMVersion(version)
			{
				var instHPSUMLocBrowse = $(HPSUM_LOC_BROWSE).data('plugin_hpsumBrowse');
				if (instHPSUMLocBrowse){
					var child = instHPSUMLocBrowse.getChild(HPSUM_VERSION_SELECTED);
					if (child){
						$(child).html(version);
					}
				}
			}
			
			// This function will be called on focus and focusout events
			function onFocusChange()
			{
				updateHPSUMSourcePathError('');
				var instISOLocBrowse = $(ISO_LOC_BROWSE).data('plugin_hpsumBrowse');
				var instHPSUMLocBrowse = $(HPSUM_LOC_BROWSE).data('plugin_hpsumBrowse');
				if ($(HPSUM_SOURCE_LOCATION_OPTION).val() == 'ISD' && instISOLocBrowse){
					instHPSUMLocBrowse.setPanelText(instISOLocBrowse.getLocation());
					getSourceHPSUMVersion('iso_location', instISOLocBrowse.getLocation());
				}
				else if ($(HPSUM_SOURCE_LOCATION_OPTION).val() == 'CD' && instHPSUMLocBrowse){
					getSourceHPSUMVersion('custom_location', instHPSUMLocBrowse.getLocation());
				}
			}
			// Fix for QXCR1001406883
			// This function will be called on focusout event
			function onHPSUMFocusOutChange()
			{
				var instHPSUMLocBrowse = $(HPSUM_LOC_BROWSE).data('plugin_hpsumBrowse');
				// If HP SUM source path is empty show the error message else get HP SUM version from specified path
				if ($(HPSUM_SOURCE_LOCATION_OPTION).val() == 'CD' && instHPSUMLocBrowse && instHPSUMLocBrowse.getLocation().length == 0){
					setTimeout(function(){updateHPSUMSourcePathError(localizer.getString("hpsum.baseline.custom.hpsumlocationRequired"));}, 1000);
					updateSelectedHPSUMVersion(localizer.getString('hpsum.baseline.custom.hpsumVersionSelected') + localizer.getString('hpsum.baseline.custom.unknown'));
					return;
				}
				onFocusChange();
			}
						
			// On HP SUM path browse button clicked and on focusin event
			function onHPSUMPathBrowseButtonClick() {				
				isHPSUMBrowseButtonClicked = true;
				updateHPSUMSourcePathError('');
			}
			
			// On HP SUM path browse button Done or Cancel event
			function onHPSUMPathBrowseButtonDone() {				
				isHPSUMBrowseButtonClicked = false;
				$('#hpsum-cbl-hpsum_version-error').show();
			}
			
			// On HP SUM source path error handler
			function updateHPSUMSourcePathError(error) {
				$('#hpsum-cbl-hpsum_version-error').html('');
				if (isHPSUMBrowseButtonClicked){
					$('#hpsum-cbl-hpsum_version-error').hide();
				}
				else{
					$('#hpsum-cbl-hpsum_version-error').html(error);
				}
					
				if (error.length > 0 && !isHPSUMBrowseButtonClicked){
				    formStateView.setMessage({summary: error, status: 'error', changing: false});
				}
				else{
				    formStateView.setMessage({summary: '', changing: false});
				}
			}
			
			// This function validates the HP SUM source specified path and gets HP SUM version
			function getSourceHPSUMVersion(hpsumsourcetype, path)
			{
				// If path is empty clear error message and update HPSUM version empty
				if (path.length <= 0){
					$('#hpsum-cbl-hpsum_version-error').html('');
					updateSelectedHPSUMVersion(localizer.getString('hpsum.baseline.custom.hpsumVersionSelected') + localizer.getString('hpsum.baseline.custom.unknown'));
					return;
				}
					
				var handlers =	{
                    			success : function(data) {
                        			getHPSUMSourcePathSuccess(data, path);                        			
                    		 	},
                    			error : function(errorInfo) {
                        			updateHPSUMSourcePathError(errorInfo);
                    			}
                			};
				var object = {"hapi": { "hpsum_source_path" : path, "hpsum_source_type" : hpsumsourcetype} };
				BaselinePresenter.getSourceHPSUMVersion(object, handlers);
			}
			
			// On HP SUM source path success handler
			function getHPSUMSourcePathSuccess(data, path) {
				
				$('#hpsum-cbl-hpsum_version-error').html('');
				if (0 != data.hapi.hcode) {
					if (!isHPSUMBrowseButtonClicked){
						$('#hpsum-cbl-hpsum_version-error').html(data.hapi.hmessage);
						formStateView.setMessage({summary: data.hapi.hmessage, status: 'error', changing: false});
						updateSelectedHPSUMVersion(localizer.getString('hpsum.baseline.custom.hpsumVersionSelected') + localizer.getString('hpsum.baseline.custom.unknown'));
					}
				}
				else{
					
					var version = data.hapi.hpsum_version.length > 0 ? data.hapi.hpsum_version : localizer.getString('hpsum.baseline.custom.unknown')
					updateSelectedHPSUMVersion(localizer.getString('hpsum.baseline.custom.hpsumVersionSelected') + version);
					//Get sum version and assign to global var
					gblHPESUMVersion=getSUMVersion(version);
					
				}
			}
			
          	function onMatchMatrixVersionClick()
          	{
          		if($(MATCHMATRIXVERSION_CHKBOX)[0].checked)
          		{
            		csmfilterselected = true;
            		$('#hpsum-custom-baseline-non-matrix-filters').hide();
            		$('#hpsum-custom-baseline-oaefm-option').hide();
            		$(ADDBASELINE).attr("disabled", true);
            		onCSMFilterInit();
          		}
            	else
            	{
            		//$('#hpsum-custom-baseline-matrix-filters').hide();
            		$('#hpsum-FTP-CSM-msg').hide();
            		$('#hpsum-validate-csm-location-type').hide();
            		$('#hpsum-validate-csm-ftp').hide();
                	$('#hpsum-validate-csm-local').hide();
                	$('#hpsum-vbl-proxy-usehp-item').hide();
              	  	$('#hpsum-vbl-proxy-usescript-item').hide();
               	 	$('#hpsum-vbl-components').hide();
               		$('#hpsum-matrix-from-ftp').hide();
            		$('#hpsum-custom-baseline-non-matrix-filters').show();
            		$('#hpsum-custom-baseline-oaefm-option').show();
            		checkBaselineSelected();
            		csmfilterselected = false;
            	}
          	}

          	function onOaEfmClick()
          	{
          		if($(OAEFM_CHKBOX)[0].checked)
          		{
          			// selection default filters for OA compatible ISO
     				selectOaEfmIsoCompatOptions();
          		}
            	else
            	{
            		// de-select default filters
  					resetOaEfmCompatOPtions();
            	}
          	}

          	function selectOaEfmIsoCompatOptions() {

          		// remove the hover over help
          		removeToolTipAttrAndClass('#oaefm-config');
          		

          		// Hide the Matrix Filter option, as user is allowed to select only
          		// one of the special configurations
          		$('#hpsum-custom-baseline-matrix-filter-option').hide();

          		// following code selects the default advanced filters for OA EFM compatible ISO

          		// select firmware type components only.     		
           		$(SELECT_COMPTYPE).selectBox('value', "firmware");
           		$("#select-comptype").trigger('change');
            		
            	// There is a bug in jQuery 1.8 because of which the checkbox gets checked after the handler finishes.
            	// To handle this, set checked true, trigger click, and set true again.
            	$(COMPONENT_CATEGORY_FIRMWARE).attr("checked", true);
            	$(COMPONENT_CATEGORY_FIRMWARE).trigger('click');
            	$(COMPONENT_CATEGORY_FIRMWARE).attr("checked", true);
            	$(COMPONENT_CATEGORY_FIRMWARE).attr("disabled", true);

				// force the Lights-out Management
				for (var idx = 0; idx < firmware_cat_array.length; idx++)
				{
					var fwItem = $(CATEGORY_FIRMWARE+'-'+idx).data("model");
					if (fwItem === "Lights-Out Management")
					{
						$(CATEGORY_FIRMWARE+'-'+idx).attr("disabled", true);
						break;
					}
				}

				// force SLES 11 and SLES12 OS filetrs
			    for (var m=0;m<operating_system_final.length;m++)
				{
					 
					var operating_system_checked = $('#hpsum-os-type-'+m).data("model");
				 	if (operating_system_checked === "SLES 12" || operating_system_checked === "SLES 11") 
				 	{
				 		$('#hpsum-os-type-'+m).attr("checked", true);
				 		$('#hpsum-os-type-'+m).attr("disabled", true);
				 	}
					 	
				}

				// force BIOS component filter
				$(COMPONENT_CATEGORY_BIOS).attr("checked", true);
				$(COMPONENT_CATEGORY_BIOS).trigger('click');
				$(COMPONENT_CATEGORY_BIOS).attr("checked", true);
				
				// force the OA component
				$('#chkbox-dev-C7000-enclosure').attr("checked", true);
				$('#chkbox-dev-C7000-enclosure').trigger('click');
            	$('#chkbox-dev-C7000-enclosure').attr("checked", true);
            	$('#chkbox-dev-C7000-enclosure').attr("disabled", true);
            	$('#chkbox-dev-oa').attr("disabled", true);

            	// select all the blade type
            	$('#hpsum-select-all-bl').attr("checked", true);
            	$('#hpsum-select-all-bl').trigger('click');
            	$('#hpsum-select-all-bl').attr("checked", true);

            	// force x64 architecture
            	$('#chkbox-arch-x64').attr("checked", true);
				$('#chkbox-arch-x64').attr("disabled", true);
          	}

          	function resetOaEfmCompatOPtions()
          	{
          		// add hover over help
          		if($(OAEFM_CHKBOX)[0].disabled === true) {
          			AddToolTipAttrAndClass('#oaefm-config', 'hpsum.baseline.custom.oaefmConfigHelp');
          		}

          		// show matrix filter option
          		$('#hpsum-custom-baseline-matrix-filter-option').show();

          		// reset the component filter selection back to default, 'both'
            	$(SELECT_COMPTYPE).selectBox('value', "both");
            	$("#select-comptype").trigger('change');
            	
            	// enable Lights-Out Management
				for (var idx = 0; idx < firmware_cat_array.length; idx++)
				{
					var fwItem = $(CATEGORY_FIRMWARE+'-'+idx).data("model");
					if (fwItem === "Lights-Out Management")
					{
						$(CATEGORY_FIRMWARE+'-'+idx).attr("disabled", false);
						break;
					}
				}

            	// uncheck firmware options
            	$(COMPONENT_CATEGORY_FIRMWARE).attr("disabled", false);
            	$(COMPONENT_CATEGORY_FIRMWARE).attr("checked", false);
            	$(COMPONENT_CATEGORY_FIRMWARE).trigger('click');
            	$(COMPONENT_CATEGORY_FIRMWARE).attr("checked", false);
            	
                // unckeck and enabled OS filters
			    for (var m=0;m<operating_system_final.length;m++)
				{
					$('#hpsum-os-type-'+m).attr("checked", false);
					$('#hpsum-os-type-'+m).attr("disabled", false);	 	
				}

				// uncheck and enable BIOS filters
				$(COMPONENT_CATEGORY_BIOS).attr("checked", false);
				$(COMPONENT_CATEGORY_BIOS).trigger('click');
				$(COMPONENT_CATEGORY_BIOS).attr("checked", false);
				
				// uncheck synergy
				$(SYNERGY_CHKBOX).attr("checked", false);

				// uncheck and enable C7000 enclosure filters
				$('#chkbox-dev-C7000-enclosure').attr("disabled", false);
            	$('#chkbox-dev-oa').attr("disabled", false);
				$('#chkbox-dev-C7000-enclosure').attr("checked", false);
				$('#chkbox-dev-C7000-enclosure').trigger('click');
            	$('#chkbox-dev-C7000-enclosure').attr("checked", false);

            	// deselect all server models
            	// de-select all BL filter
            	$('#hpsum-deselect-all-bl').attr("checked", true);
            	$('#hpsum-deselect-all-bl').trigger('click');
            	$('#hpsum-deselect-all-bl').attr("checked", true);

            	// de-select all DL models
            	$('#hpsum-deselect-all-dl').attr("checked", true);
            	$('#hpsum-deselect-all-dl').trigger('click');
            	$('#hpsum-deselect-all-dl').attr("checked", true);

            	// de-select all ML models
            	$('#hpsum-deselect-all-ml').attr("checked", true);
            	$('#hpsum-deselect-all-ml').trigger('click');
            	$('#hpsum-deselect-all-ml').attr("checked", true);

            	// // de-select all SL models
            	$('#hpsum-deselect-all-sl').attr("checked", true);
            	$('#hpsum-deselect-all-sl').trigger('click');
            	$('#hpsum-deselect-all-sl').attr("checked", true);

            	// de-select all WS models
            	$('#hpsum-deselect-all-ws').attr("checked", true);
            	$('#hpsum-deselect-all-ws').trigger('click');
            	$('#hpsum-deselect-all-ws').attr("checked", true);

            	// de-select all Apollo models
            	$('#hpsum-deselect-all-apollo').attr("checked", true);
            	$('#hpsum-deselect-all-apollo').trigger('click');
            	$('#hpsum-deselect-all-apollo').attr("checked", true);

            	// de-select all otherseries models
            	$('#hpsum-deselect-all-otherseries').attr("checked", true);
            	$('#hpsum-deselect-all-otherseries').trigger('click');
            	$('#hpsum-deselect-all-otherseries').attr("checked", true);

            	// de-select all synergy models
            	$('#hpsum-deselect-all-synergy').attr("checked", true);
            	$('#hpsum-deselect-all-synergy').trigger('click');
            	$('#hpsum-deselect-all-synergy').attr("checked", true);

            	// de-select all microserver models
            	$('#hpsum-deselect-all-microserver').attr("checked", true);
            	$('#hpsum-deselect-all-microserver').trigger('click');
            	$('#hpsum-deselect-all-microserver').attr("checked", true);

            	// de-select all XL series models
            	$('#hpsum-deselect-all-microserver').attr("checked", true);
            	$('#hpsum-deselect-all-microserver').trigger('click');
            	$('#hpsum-deselect-all-microserver').attr("checked", true);


            	 // de-selct Architecture
				$('#chkbox-arch-x64').attr("checked", false);
				$('#chkbox-arch-x64').attr("disabled", false);
				$('#chkbox-arch-x86').attr("checked", false);
          	}

          	   /**
             * @public
             * Initialization funtion for the object
             * All the controls actions are initialized in this function.
             */
            function onCSMFilterInit() {
                
                $(LOCATION_TYPE).selectBox({autoWidth: false});
                $(PROXY_OPTIONS).selectBox({autoWidth: false});
                $(CSM_VERSION).selectBox({autoWidth: false});
                $(LOCATION_TYPE).change(setLocationType);
				$(LOCATION_TYPE).selectBox('value',"local");
                $(PROXY_OPTIONS).change(onProxyOptionsChange);              

              
		
               var options;
               if($(LOCATION_TYPE).val() == 'local') {
               		options = 	{
									command : 'init',
									panelLabel: "hpsum.baseline.validate.csmPath",
						            panelHelp: "",
						            panelBrowseText: "hpsum.common.browse",
						            bshowXml: true,
						            onSelectNode: onSelectNode,
						            onBrowseDone: onBrowseDone,
						            onHandleInvalidPath: onHandleInvalidPath
						        };
				}
				else
				{
					options = 	{
									command : 'init',
									panelLabel: "hpsum.baseline.add.enterWorkingDirectory",
						            panelHelp: "",
						            panelBrowseText: "hpsum.common.browse",
						            bshowXml: false,
						            bShowEmptyFolder: true,
						            bCreateDirectory: true,
						            onSelectNode: onSelectNode,
						            onBrowseDone: onBrowseDone,
						            onHandleInvalidPath: onHandleInvalidPath
						        };
				}
				
				$(CSM_LOC_BROWSE).hpsumBrowse(options);             
          
				$('#hpsum-validate-csm-location-type').show();
                $('#hpsum-validate-csm-ftp').hide();
                $('#hpsum-validate-csm-local').hide();
                $('#hpsum-vbl-proxy-usehp-item').hide();
                $('#hpsum-vbl-proxy-usescript-item').hide();
                $('#hpsum-vbl-components').hide();
                $('#hpsum-matrix-from-ftp').hide();
                var instCSMFilterLocBrowse = $(CSM_LOC_BROWSE).data('plugin_hpsumBrowse');
                instCSMFilterLocBrowse.setPanelText('');
                
                $('#hpsum-matrix-from-ftp').show();
                $(RETRIEVE_MATRIX_BUTTON).hide();
                formStateView.reset();
                
            }
            
            function onSelectNode(nodeval, nodetype) {
            	var instCSMFilterLocBrowse = $(CSM_LOC_BROWSE).data('plugin_hpsumBrowse');
            	var str = instCSMFilterLocBrowse.getLocation(); 
                var xmlname = nodeval;
                
                var loc_type = $(LOCATION_TYPE).val();
                if (loc_type != 'FTP'){
                    if (xmlname.match(".xml$") && !(str.match(".xml$"))) {
            			var xmlFileSelected=str + "/" + xmlname;                    			
            			instCSMFilterLocBrowse.setPanelText(xmlFileSelected);
            			instCSMFilterLocBrowse.triggerInputEvent('change');
            			instCSMFilterLocBrowse.removeDialogAttr('ok', "disabled");
					}
					else
					{
						instCSMFilterLocBrowse.setDialogAttr('ok', "disabled", true);
					}
                }                    
                else
                {
                    instCSMFilterLocBrowse.removeDialogAttr('ok', "disabled");
                }
                
                formStateView.reset();
           	}
           	
           	function onBrowseDone(){
           		var instCSMFilterLocBrowse = $(CSM_LOC_BROWSE).data('plugin_hpsumBrowse');
           		if($(LOCATION_TYPE).val() == 'local') {
                    var path = instCSMFilterLocBrowse.getLocation();
                    path = path.replace("_C_", ":");
               		if ( navigator.appVersion.indexOf("Win") != -1 )
					{
						var repSlash1 = path.split('/').join('\\');
						path = repSlash1;		
					}                            
					instCSMFilterLocBrowse.setPanelText(path);
					instCSMFilterLocBrowse.triggerInputEvent('change');
					checkBaselineSelected();
                    var xmlFile = instCSMFilterLocBrowse.getLocation();
               		saveLocalMatrixFile(xmlFile);
               		$(RETRIEVE_MATRIX_BUTTON).hide();
               	} else {
               		var path = instCSMFilterLocBrowse.getLocation();
               		path = path.replace("_C_", ":");
               		if ( navigator.appVersion.indexOf("Win") != -1 )
					{
						var repSlash1 = path.split('/').join('\\');
						path = repSlash1;		
					}
					instCSMFilterLocBrowse.setPanelText(path);
					instCSMFilterLocBrowse.triggerInputEvent('change');
                }
           	}
           	
             function onHandleInvalidPath(hapi) {
             	var instCSMFilterLocBrowse = $(CSM_LOC_BROWSE).data('plugin_hpsumBrowse');
                if (hapi.hcode == 5) {
                    $(BROWSE_MATRIX_LOCATION_ERROR).text(localizer.getString('hpsum.baseline.add.inValidLocation'));
                    if(instCSMFilterLocBrowse) {
                    	instCSMFilterLocBrowse.addInputClass("hp-error");
                    	instCSMFilterLocBrowse.setInputEvent('onkeyup', onPathEdit);
                    }
                    $(BROWSE_MATRIX_LOCATION_ERROR).show();
                    instCSMFilterLocBrowse.triggerDialogEvent('clickcancel');
                    $(ADDBASELINE).attr("disabled", true);   
                } else {
                    $(BROWSE_MATRIX_LOCATION_ERROR).hide();
                    if(instCSMFilterLocBrowse) {
                    	instCSMFilterLocBrowse.removeInputClass("hp-error");
                    	instCSMFilterLocBrowse.setInputEvent('offkeyup', onPathEdit);
                    }
                }
            }
            
            function onPathEdit() {
                $(BROWSE_MATRIX_LOCATION_ERROR).hide();
                var instCSMFilterLocBrowse = $(CSM_LOC_BROWSE).data('plugin_hpsumBrowse');
                if(instCSMFilterLocBrowse) {
                	instCSMFilterLocBrowse.removeInputClass("hp-error");
                	instCSMFilterLocBrowse.setInputEvent('offkeyup', onPathEdit);
                }
            }
            function validateAgainstCSM(){
            	var msg = localizer.getString('hpsum.baseline.validate.validationInProgress');
            	showSaveWait(msg);
            	var URI;
            	
            	URI = "/Session/" + session.getToken()  + "/Baseline/validatereciepefile";
            	var selectedIndex = $('#hpsum-csm-version')[0].selectedIndex;
            	var selectedVersion = $('#hpsum-csm-version')[0][selectedIndex].text;   
            	var baselines = [], selectedRows;
            	if(oTableBaselines)
            	{
					//baselines = oTableBaselines.fnGetData();
					
					selectedRows = $(SOURCES_TABLE + ' tbody tr.hp-selected');
			 	} 
			 	for(var tmp=0; tmp < selectedRows.length; tmp++){
	 				var nodeData = oTableBaselines.fnGetData(selectedRows[tmp].rowIndex-1);
	 				var list = nodeData.uri.split("/");
					var locid = list[5];
					var baselineid = list[7]; 
					var baseid = locid + "/" +baselineid;
					baselines.push(baseid)  ;
					}       	
            	var input = {
            		hapi: {
            			csm_version : selectedVersion,
            			baseline : baselines
            		}            		
            	};
				formStateView.reset();
            	presenter.validateReciepeFile(URI, input, {
                        success : onCSMValidationSuccess,
                        error : onCSMValidationError
                    });

            }
            
            function selectAll(dataList, increment) {
            	var toDoCounter = compDoneCount + increment;
            	for (var tmp = compDoneCount; tmp < toDoCounter; tmp++)
            	{
            		var selectid = '#' + dataList[tmp].select.split('"')[1];
					//if component isfwkg & SUM version is less than MIN_SUM_VER_FWPKG
            	   if((dataList[tmp].component_file_name.indexOf(".fwpkg")!=-1) && (gblHPESUMVersion =="" ||  gblHPESUMVersion < MIN_SUM_VER_FWPKG))
				    {
					  //De-Select fwpkg row
						$(selectid).removeAttr('checked');
						$(selectid).trigger('change');
						$($(selectid)).parent().parent().removeClass('hp-selected');							   
								
				    }
			 	    else
				    {					
						$(selectid).prop('checked', true);
						$(selectid).trigger('change');
				    }
				
            		compDoneCount++;
            		if(compDoneCount == dataList.length) {
            			NO_COMP_SELECTED = false;
            			closeSaveWait();
            			enableActionButtons();
            			break;
            		}
            	}
                //moved the message in selectALL as the correct count can be retrieved after de-selecting fwpkg components			
            	var selCompCount = 0;
            	selCompCount = $(COMPONENTS_TABLE + ' tbody tr.hp-selected').length;
            	var compCountMsgtemp = localizer.getString('hpsum.baseline.custom.customCompCountMsg', [totalCompCount, filterCompCount, selCompCount]);
            	$(COMPONENTS_COUNT_LABEL).html(compCountMsgtemp);
            	if(compDoneCount < dataList.length)
            	{
            		//We need to increase the time from 100 to 1000ms once we remove wait dialog in 7.4
            		setTimeout(function(){selectAll(dataList,100);}, 100);
            	}
            }
            
            function deSelectAll(dataList, increment) {
            	var toDoCounter = compDoneCount + increment;
            	for (var tmp = compDoneCount; tmp < toDoCounter && tmp < dataList.length; tmp++)
            	{
            		var selectid = '#' + dataList[tmp].select.split('"')[1];
            		$(selectid).removeAttr('checked');
            		$(selectid).trigger('change');
            		compDoneCount++;
            		if(compDoneCount == dataList.length) {
            			NO_COMP_SELECTED = true;
            			closeSaveWait();
            			disableActionButtons();
            			break;
            		}
            	}
            	if(compDoneCount < dataList.length)
            	{
            		//We need to increase the time from 100 to 1000ms once we remove wait dialog in 7.4
            		setTimeout(function(){deSelectAll(dataList,100);}, 100);
            	}
            }
    
            
            function enableApplyFilters() {
            	
            	if(totalOSRequest == completedOSRequest && restOsInfoCount == 0 && restHwInfoCount == 0)
            	{
            		$(ADDBASELINE).attr('disabled', false);
            		$(APPLYFILTERS_MSG).hide();
				}
            	else
            	{
            		$(ADDBASELINE).attr('disabled', true);
            		$(APPLYFILTERS_MSG).show();
				}
            }
            
 			function updateUserInterfaceForOEM()
			{
				var sessionDataHandlers = {
					success : function(data) {
						// if hcode is 0 then session is alive and set session cookies
						if(data.hapi.hcode == 0) {
							var mfg = data.hapi.manufacturer;
							if (mfg != "HP" && mfg != "HPE") {
								// Remove the CloudSystem Matrix from the filter option
								$('#hpsum-custom-baseline-matrix-filter-option').remove();
							}
						}
						else
						{
							// if session is expired or any other error, then goto login page
							session.eraseAll();
							document.location.href = "/#/login";
						}
					},
					error : function(jqXHR) {
						// getsessiondata failed, so goto login page
						session.eraseAll();
						document.location.href = "/#/login";
					}
				};

				//get session data and set user and login details for the session
				session.getSessionData(sessionDataHandlers);
			}
  /**
*get version of SUM
 */
  function getSUMVersion( version)
	 {
		var newVersionStr="";
		 
		if(version!="" && version!='unknown' && version!=undefined )
		{
			var ver=version.split(".");
			for(var i=0;i<ver.length;i++)
			{
				newVersionStr=newVersionStr + ver[i];
			}
		}
		
       return	newVersionStr;	
					
	}
			 
		 
          	/**
             * @public
             */
            this.resume = function () {
			    totalOSRequest = 0;
		        completedOSRequest = 0;
				errorOSRequest = 0;
			   	selectedTablesID = [];
            	$(COLLAPSE_ADVFILTERS).hpCollapsible('collapse');
				$('#hpsum-custom-baseline-collapsible-ostype').hpCollapsible('collapse');
				$('#hpsum-custom-baseline-collapsible-hardwaretype').hpCollapsible('collapse');
				$(COLLAPSE_DEVTYPE).hpCollapsible('collapse');
				$(COLLAPSE_CATEGORY).hpCollapsible('collapse');
				$(COLLAPSE_ARCH).hpCollapsible('collapse');
				$(INVALIDSIG_WARNING).hide();
				$(FWPKG_SUM_LOW_VERSION).hide();
				
            	$(BASELINE_NAME_LABEL).empty();
				hardware_info = [];
				operating_system_array = [];
				category_info = [];
				NO_COMP_SELECTED = true;
				$("#hpsum-custom-baselines-add-form :input").prop("disabled", false);
				$('#hpsum-bootableiso-opt').hide();
				$('#hpsum-validate-csm-location-type').hide();
            		$('#hpsum-validate-csm-ftp').hide();
                	$('#hpsum-validate-csm-local').hide();
                	$('#hpsum-vbl-proxy-usehp-item').hide();
              	  	$('#hpsum-vbl-proxy-usescript-item').hide();
               	 	$('#hpsum-vbl-components').hide();
               		$('#hpsum-matrix-from-ftp').hide();
				$('#hpsum-custom-baseline-non-matrix-filters').show();
				$('#hpsum-custom-baseline-oaefm-option').show();
				$('.hpsum-nonUEFI').hide();
				$(NONUEFI_CHECKBOX).attr('checked', false);
				isxorriso_present = true;
				restOsInfoCount = 0;
				restHwInfoCount = 0;
				$(APPLYFILTERS_MSG).hide();
				enableAll();
				$(UI_DATEPICKER_DIV).css("display", "none" );
            	reset(true);
            };
            
            this.pause = function () {
            };
            
            /**
             * @public
             * Initialization funtion for the object
             * All the controls actions are initialized in this function.
             */
            this.init = function() {
				updateUserInterfaceForOEM();
				$('#createiso-chkbox-item').hide(); 
				$(INVALIDSIG_WARNING).hide();
				$(FWPKG_SUM_LOW_VERSION).hide();
				
				//Let's add date picker to allow user to pick a date
				$(DATE_VERSION).datepicker({dateFormat: 'yy-mm-dd'});
				       	
            	initialize();
            	
            	selectedTablesID = [];
                $('#hpsum-cbl-title').text(localizer.getString("hpsum.baseline.custom.createBaseline"));
	        	$(COMPONENT_TYPE).attr('tooltip', localizer.getString('hpsum.baseline.custom.comptypehelp')).hpTooltip();
                $('#hpsum-custom-baseline-collapsible-devtype').attr('tooltip', localizer.getString('hpsum.baseline.custom.deviceTypehelp')).hpTooltip();
                $('#specific-comp-category').attr('tooltip', localizer.getString('hpsum.baseline.custom.categoryTypehelp')).hpTooltip();
				$('#hpsum-custom-baseline-collapsible-hardwaretype').attr('tooltip', localizer.getString('hpsum.baseline.custom.hardwareTypehelp')).hpTooltip();
				AddToolTipAttrAndClass('#oaefm-config', 'hpsum.baseline.custom.oaefmConfigHelp');
                formStateView.init({form: FORM, routePattern: ROUTE_PREFIX + '.*', autoTrack: true});
                
                
                $(SAVEAS).live('click', function(ev) {
                	disableActionButtons();
                	disableAll();
					// fix for QXCR1001428383 - disable close button when CBL creation is in progress. 
					$(CANCEL).attr("disabled", true);
                	if(csmfilterselected)
                		onCSMCreate(true);
                	else
                	    onCreate(true);
                    ev.preventDefault();
                });
				
				
                $(SYNERGY_CHKBOX).live('click', function(ev){
					if($(SYNERGY_CHKBOX)[0].checked == true) {
						$(COLLAPSE_HWTYPE_SYNERGY).show();
					}
					else	
					{
						$(COLLAPSE_HWTYPE_SYNERGY).hide();
					}
				});
				
				$('#chkbox-dev-C7000-enclosure').live('click', function(ev){
					if( $('#chkbox-dev-C7000-enclosure')[0].checked == true) {
						$('#chkbox-dev-oa')[0].checked = true;
						$('#chkbox-dev-vc')[0].checked = true;
						$('#chkbox-dev-sasswitches')[0].checked = true;
					}
					else {
						$('#chkbox-dev-oa')[0].checked = false;
						$('#chkbox-dev-vc')[0].checked = false;
						
						$('#chkbox-dev-sasswitches')[0].checked = false;
				
					}
				});

                $(CREATE).live('click', function(ev) {
                	disableActionButtons();
                	disableAll();
					// fix for QXCR1001428383 - disable close button when CBL creation is in progress. 
					$(CANCEL).attr("disabled", true);
                    if(csmfilterselected)
					{
                		onCSMCreate(false); //Changed the passed parameter to true to enable the saving of the baseline
					}
                	else
					{
                	    onCreate(false); //Changed the passed parameter to true to enable the saving of the baseline
					}
                    ev.preventDefault();
                });
                
                $(RESET).live('click', function(ev) {
					$(RESET).attr("disabled", true);
                    reset(true);
                    ev.preventDefault();
					$(INVALIDSIG_WARNING).hide();
					$(FWPKG_SUM_LOW_VERSION).hide();
                });
                  
                $(CANCEL).live('click', function(ev) {
                    $('#hpsum-hardware-info').html(' ');
					$('#hpsum-operating-system-info').html(' ');
					formStateView.setautotrack(true);
					router.go('/baseline/show');
					//$('#hpsum-all-hardware').html(' ');
                    ev.preventDefault();
                });
               	$(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });
                $(COMPONENT_CATEGORY_BIOS).live('click',function(ev){
					if($(COMPONENT_CATEGORY_BIOS)[0].checked == true)
					{
					   for (var idx = 0; idx < bios_cat_array.length; idx++)
					   {
							$(CATEGORY_BIOS+'-'+idx)[0].checked = true;
					   }
					}
					else
					{
					   for (var idx = 0; idx < bios_cat_array.length; idx++)
					   {
							$(CATEGORY_BIOS+'-'+idx)[0].checked = false;
					   }
					}
				});
				$(COMPONENT_CATEGORY_FIRMWARE).live('click',function(ev){
					if($(COMPONENT_CATEGORY_FIRMWARE)[0].checked == true)
					{
					   for (var idx = 0; idx < firmware_cat_array.length; idx++)
					   {
							$(CATEGORY_FIRMWARE+'-'+idx)[0].checked = true;
					   }
					}
					else
					{
					   for (var idx = 0; idx < firmware_cat_array.length; idx++)
					   {
							$(CATEGORY_FIRMWARE+'-'+idx)[0].checked = false;
					   }
					}
				});
                $(COMPONENT_CATEGORY_SOFTWARE).live('click',function(ev){
					if($(COMPONENT_CATEGORY_SOFTWARE)[0].checked == true)
					{
						for (var idx = 0; idx < software_cat_array.length; idx++)
						{
							$(CATEGORY_SOFTWARE+'-'+idx)[0].checked = true;
						}
					}
					else
					{
						   for (var idx = 0; idx < software_cat_array.length; idx++)
						   {
								$(CATEGORY_SOFTWARE+'-'+idx)[0].checked = false;
						   }
					}
				});
				
				$(COMPONENT_CATEGORY_DRIVER).live('click',function(ev){
					if($(COMPONENT_CATEGORY_DRIVER)[0].checked == true)
					{
					   for (var idx = 0; idx < driver_cat_array.length; idx++)
					   {
							$(CATEGORY_DRIVER+'-'+idx)[0].checked = true;
					   }
					}
					else
					{
						   for (var idx = 0; idx < driver_cat_array.length; idx++)
						   {
								$(CATEGORY_DRIVER+'-'+idx)[0].checked = false;
						   }
					}
				});
				
				$('#select-comptype').change(OnComponentTypeSelectionChange);
				$('#hpsum-select-all-dl').live('click', function(ev){
			    if ($('#hpsum-select-all-dl')[0].checked == true)
			    {
			       for (var idx = 0; idx < dl_array.length; idx++)
			       {
			         $('#hpsum-hardware-type-dl-'+idx)[0].checked = true;
			       }
				   $('#hpsum-select-all-dl')[0].disabled = true;
				   $('#hpsum-deselect-all-dl')[0].checked = false;
				   $('#hpsum-deselect-all-dl')[0].disabled = false;  
			    }
				});
				$('.hpsum-dl-hardware').live('click', function(ev){
				for (var idx = 0; idx < dl_array.length; idx++)
				{
				if ($('#hpsum-hardware-type-dl-'+idx)[0].checked == false)
				{
				$('#hpsum-select-all-dl')[0].disabled = false;
				$('#hpsum-select-all-dl')[0].checked = false;
				}
				if ($('#hpsum-hardware-type-dl-'+idx)[0].checked == true)
				{
				$('#hpsum-deselect-all-dl')[0].disabled = false;
				$('#hpsum-select-all-dl')[0].disabled = false;
				$('#hpsum-deselect-all-dl')[0].checked = false;
				}
				}
				});
				
				$('#hpsum-deselect-all-dl').live('click', function(ev){
			    if ($('#hpsum-deselect-all-dl')[0].checked == true)
			    {
			       for (var idx = 0; idx < dl_array.length; idx++)
			       {
			         $('#hpsum-hardware-type-dl-'+idx)[0].checked = false;
			       }
				   $('#hpsum-select-all-dl')[0].disabled = false;
				   $('#hpsum-select-all-dl')[0].checked = false;
				   $('#hpsum-deselect-all-dl')[0].disabled = true;
			    }
				});
				$('#hpsum-select-all-ml').live('click', function(ev){
			    if ($('#hpsum-select-all-ml')[0].checked == true)
			    {
			       for (var idx = 0; idx < ml_array.length; idx++)
			       {
			         $('#hpsum-hardware-type-ml-'+idx)[0].checked = true;
			       }
				   $('#hpsum-select-all-ml')[0].disabled = true;
				   $('#hpsum-deselect-all-ml')[0].checked = false;
				   $('#hpsum-deselect-all-ml')[0].disabled = false; 			 
			    }
				});
				$('.hpsum-ml-hardware').live('click', function(ev){
				for (var idx = 0; idx < ml_array.length; idx++)
				{
				if ($('#hpsum-hardware-type-ml-'+idx)[0].checked == false)
				{
				$('#hpsum-select-all-ml')[0].disabled = false;
				$('#hpsum-select-all-ml')[0].checked = false;
				}
				if ($('#hpsum-hardware-type-ml-'+idx)[0].checked == true)
				{
				$('#hpsum-deselect-all-ml')[0].disabled = false;
				$('#hpsum-select-all-ml')[0].disabled = false;
				$('#hpsum-deselect-all-ml')[0].checked = false;
				}
				}
				});
				
				$('#hpsum-deselect-all-ml').live('click', function(ev){
			    if ($('#hpsum-deselect-all-ml')[0].checked == true)
			    {
			       for (var idx = 0; idx < ml_array.length; idx++)
			       {
			         $('#hpsum-hardware-type-ml-'+idx)[0].checked = false;
			       }
				   $('#hpsum-select-all-ml')[0].disabled = false;
				   $('#hpsum-select-all-ml')[0].checked = false;
				   $('#hpsum-deselect-all-ml')[0].disabled = true;
			    }
				});
				$('#hpsum-select-all-bl').live('click', function(ev){
			    if ($('#hpsum-select-all-bl')[0].checked == true)
			    {
			       for (var idx = 0; idx < bl_array.length; idx++)
			       {
			         $('#hpsum-hardware-type-bl-'+idx)[0].checked = true;
			       }
				   $('#hpsum-select-all-bl')[0].disabled = true;
				   $('#hpsum-deselect-all-bl')[0].checked = false;
				   $('#hpsum-deselect-all-bl')[0].disabled = false;
			    }
				});
				$('.hpsum-bl-hardware').live('click', function(ev){
				for (var idx = 0; idx < bl_array.length; idx++)
				{
				if ($('#hpsum-hardware-type-bl-'+idx)[0].checked == false)
				{
				$('#hpsum-select-all-bl')[0].disabled = false;
				$('#hpsum-select-all-bl')[0].checked = false;
				}
				if ($('#hpsum-hardware-type-bl-'+idx)[0].checked == true)
				{
				$('#hpsum-deselect-all-bl')[0].disabled = false;
				$('#hpsum-select-all-bl')[0].disabled = false;
				$('#hpsum-deselect-all-bl')[0].checked = false;
				}
				}
				});
				
				$('#hpsum-deselect-all-bl').live('click', function(ev){
			    if ($('#hpsum-deselect-all-bl')[0].checked == true)
			    {
			       for (var idx = 0; idx < bl_array.length; idx++)
			       {
			         $('#hpsum-hardware-type-bl-'+idx)[0].checked = false;
			       }
				   $('#hpsum-select-all-bl')[0].disabled = false;
				   $('#hpsum-select-all-bl')[0].checked = false;
				   $('#hpsum-deselect-all-bl')[0].disabled = true;
			    }
				});
				$('#hpsum-select-all-sl').live('click', function(ev){
			    if ($('#hpsum-select-all-sl')[0].checked == true)
			    {
			       for (var idx = 0; idx < sl_array.length; idx++)
			       {
			         $('#hpsum-hardware-type-sl-'+idx)[0].checked = true;
			       }
				   $('#hpsum-select-all-sl')[0].disabled = true;
				   $('#hpsum-deselect-all-sl')[0].checked = false;
				   $('#hpsum-deselect-all-sl')[0].disabled = false;
			    }
				});
				
				$('#hpsum-select-all-xl').live('click', function(ev){
			    if ($('#hpsum-select-all-xl')[0].checked == true)
			    {
			       for (var idx = 0; idx < xl_array.length; idx++)
			       {
			         $('#hpsum-hardware-type-xl-'+idx)[0].checked = true;
			       }
				   $('#hpsum-select-all-xl')[0].disabled = true;
				   $('#hpsum-deselect-all-xl')[0].checked = false;
				   $('#hpsum-deselect-all-xl')[0].disabled = false; 
				 
			    }
				});
				$('#hpsum-select-all-ws').live('click', function(ev){
			    if ($('#hpsum-select-all-ws')[0].checked == true)
			    {
			       for (var idx = 0; idx < ws_array.length; idx++)
			       {
			         $('#hpsum-hardware-type-ws-'+idx)[0].checked = true;
			       }
				   $('#hpsum-select-all-ws')[0].disabled = true;
				   $('#hpsum-deselect-all-ws')[0].checked = false;
				   $('#hpsum-deselect-all-ws')[0].disabled = false; 
				 
			    }
				});

				$('#hpsum-select-all-otherseries').live('click', function(ev){
			    if ($('#hpsum-select-all-otherseries')[0].checked == true)
			    {
			       for (var idx = 0; idx < otherseries_array.length; idx++)
			       {
			         $('#hpsum-hardware-type-otherseries-'+idx)[0].checked = true;
			       }
				   $('#hpsum-select-all-otherseries')[0].disabled = true;
				   $('#hpsum-deselect-all-otherseries')[0].checked = false;
				   $('#hpsum-deselect-all-otherseries')[0].disabled = false; 
				 
			    }
				});
				$('#hpsum-select-all-synergy').live('click', function(ev){
			    if ($('#hpsum-select-all-synergy')[0].checked == true)
			    {
			       for (var idx = 0; idx < synergy_array.length; idx++)
			       {
			         $('#hpsum-hardware-type-synergy-'+idx)[0].checked = true;
			       }
				   $('#hpsum-select-all-synergy')[0].disabled = true;
				   $('#hpsum-deselect-all-synergy')[0].checked = false;
				   $('#hpsum-deselect-all-synergy')[0].disabled = false; 
				 
			    }
				});
				$('.hpsum-sl-hardware').live('click', function(ev){
				for (var idx = 0; idx < sl_array.length; idx++)
				{
				if ($('#hpsum-hardware-type-sl-'+idx)[0].checked == false)
				{
				$('#hpsum-select-all-sl')[0].disabled = false;
				$('#hpsum-select-all-sl')[0].checked = false;
				}
				if ($('#hpsum-hardware-type-sl-'+idx)[0].checked == true)
				{
				$('#hpsum-deselect-all-sl')[0].disabled = false;
				$('#hpsum-select-all-sl')[0].disabled = false;
				$('#hpsum-deselect-all-sl')[0].checked = false;
				}
				}
				});
				
				$('#hpsum-deselect-all-sl').live('click', function(ev){
			    if ($('#hpsum-deselect-all-sl')[0].checked == true)
			    {
			       for (var idx = 0; idx < sl_array.length; idx++)
			       {
			         $('#hpsum-hardware-type-sl-'+idx)[0].checked = false;
			       }
				   $('#hpsum-select-all-sl')[0].disabled = false;
				   $('#hpsum-select-all-sl')[0].checked = false;
				   $('#hpsum-deselect-all-sl')[0].disabled = true;
			    }
				});
				
				$('.hpsum-xl-hardware').live('click', function(ev){
				for (var idx = 0; idx < xl_array.length; idx++)
				{
				if ($('#hpsum-hardware-type-xl-'+idx)[0].checked == false)
				{
				$('#hpsum-select-all-xl')[0].disabled = false;
				$('#hpsum-select-all-xl')[0].checked = false;
				}
				if ($('#hpsum-hardware-type-xl-'+idx)[0].checked == true)
				{
				$('#hpsum-deselect-all-xl')[0].disabled = false;
				$('#hpsum-select-all-xl')[0].disabled = false;
				$('#hpsum-deselect-all-xl')[0].checked = false;
				}
				}
				});
				$('#hpsum-deselect-all-xl').live('click', function(ev){
			    if ($('#hpsum-deselect-all-xl')[0].checked == true)
			    {
			       for (var idx = 0; idx < xl_array.length; idx++)
			       {
			         $('#hpsum-hardware-type-xl-'+idx)[0].checked = false;
			       }
				   $('#hpsum-select-all-xl')[0].disabled = false;
				   $('#hpsum-select-all-xl')[0].checked = false;
				   $('#hpsum-deselect-all-xl')[0].disabled = true;
			    }
				});
				$('.hpsum-ws-hardware').live('click', function(ev){
				for (var idx = 0; idx < ws_array.length; idx++)
				{
				if ($('#hpsum-hardware-type-ws-'+idx)[0].checked == false)
				{
				$('#hpsum-select-all-ws')[0].disabled = false;
				$('#hpsum-select-all-ws')[0].checked = false;
				}
				if ($('#hpsum-hardware-type-ws-'+idx)[0].checked == true)
				{
				$('#hpsum-deselect-all-ws')[0].disabled = false;
				$('#hpsum-select-all-ws')[0].disabled = false;
				$('#hpsum-deselect-all-ws')[0].checked = false;
				}
				}
				});
				$('#hpsum-deselect-all-ws').live('click', function(ev){
			    if ($('#hpsum-deselect-all-ws')[0].checked == true)
			    {
			       for (var idx = 0; idx < ws_array.length; idx++)
			       {
			         $('#hpsum-hardware-type-ws-'+idx)[0].checked = false;
			       }
				   $('#hpsum-select-all-ws')[0].disabled = false;
				   $('#hpsum-select-all-ws')[0].checked = false;
				   $('#hpsum-deselect-all-ws')[0].disabled = true;
			    }
				});
				
				$('.hpsum-otherseries-hardware').live('click', function(ev){
				for (var idx = 0; idx < otherseries_array.length; idx++)
				{
				if ($('#hpsum-hardware-type-otherseries-'+idx)[0].checked == false)
				{
				$('#hpsum-select-all-otherseries')[0].disabled = false;
				$('#hpsum-select-all-otherseries')[0].checked = false;
				}
				if ($('#hpsum-hardware-type-otherseries-'+idx)[0].checked == true)
				{
				$('#hpsum-deselect-all-otherseries')[0].disabled = false;
				$('#hpsum-select-all-otherseries')[0].disabled = false;
				$('#hpsum-deselect-all-otherseries')[0].checked = false;
				}
				}
				});
				$('#hpsum-deselect-all-otherseries').live('click', function(ev){
			    if ($('#hpsum-deselect-all-otherseries')[0].checked == true)
			    {
			       for (var idx = 0; idx < otherseries_array.length; idx++)
			       {
			         $('#hpsum-hardware-type-otherseries-'+idx)[0].checked = false;
			       }
				   $('#hpsum-select-all-otherseries')[0].disabled = false;
				   $('#hpsum-select-all-otherseries')[0].checked = false;
				   $('#hpsum-deselect-all-otherseries')[0].disabled = true;
			    }
				});


								
				$('.hpsum-synergy-hardware').live('click', function(ev){
				for (var idx = 0; idx < synergy_array.length; idx++)
				{
					if ($('#hpsum-hardware-type-synergy-'+idx)[0].checked == false)
					{
						$('#hpsum-select-all-synergy')[0].disabled = false;
						$('#hpsum-select-all-synergy')[0].checked = false;
					}
					if ($('#hpsum-hardware-type-synergy-'+idx)[0].checked == true)
					{
						$('#hpsum-deselect-all-synergy')[0].disabled = false;
						$('#hpsum-select-all-synergy')[0].disabled = false;
						$('#hpsum-deselect-all-synergy')[0].checked = false;
					}
				}
				});
				
				$('#hpsum-deselect-all-synergy').live('click', function(ev){
			    if ($('#hpsum-deselect-all-synergy')[0].checked == true)
			    {
			       for (var idx = 0; idx < synergy_array.length; idx++)
			       {
			         $('#hpsum-hardware-type-synergy-'+idx)[0].checked = false;
			       }
				   $('#hpsum-select-all-synergy')[0].disabled = false;
				   $('#hpsum-select-all-synergy')[0].checked = false;
				   $('#hpsum-deselect-all-synergy')[0].disabled = true;
			    }
				});
				
				$('#chkbox-hw-selectall').live('click', function(ev){
				if ($('#chkbox-hw-selectall')[0].checked == true)
				{
					
					var msg = localizer.getString('hpsum.baseline.custom.selectingAll');
					showSaveWait(msg);
					$('#chkbox-hw-deselectall')[0].checked = false;
					$(COMPONENTS_TABLE + ' tbody tr').addClass('hp-selected');
					var dataList = $(COMPONENTS_TABLE).dataTable().fnGetData();
					
					 compDoneCount = 0;
                                        //Moved the message to selectALL function
					setTimeout(function(){selectAll(dataList,10);}, 10);
				}
				});		 
  				$('#chkbox-hw-deselectall').live('click', function(ev){
				if ($('#chkbox-hw-deselectall')[0].checked == true) 
				{
					var msg = localizer.getString('hpsum.baseline.custom.deselectingAll');
					showSaveWait(msg);
					$('#chkbox-hw-selectall')[0].checked =false;
					$(COMPONENTS_TABLE + ' tbody tr').removeClass('hp-selected');
					var dataList = $(COMPONENTS_TABLE).dataTable().fnGetData();
					compDoneCount = 0;
					var selCompCount = 0;
					selCompCount = $(COMPONENTS_TABLE + ' tbody tr.hp-selected').length;
					var compCountMsgtemp = localizer.getString('hpsum.baseline.custom.customCompCountMsg' , [totalCompCount,filterCompCount,selCompCount]); 
                	$(COMPONENTS_COUNT_LABEL).html(compCountMsgtemp);
					setTimeout(function(){deSelectAll(dataList,10);}, 10);
				}
  				});	    

				$(COLLAPSE).hpCollapsible();
				$(COLLAPSE_SYSTEM).hpCollapsible();
				$(COLLAPSE_STORAGE).hpCollapsible();
				$(COLLAPSE_NIC).hpCollapsible();
				$(COLLAPSE_FCHBA).hpCollapsible();
				$(COLLAPSE_ADVFILTERS).hpCollapsible();
				$(COLLAPSE_ARCH).hpCollapsible();
				$(COLLAPSE_OSTYPE).hpCollapsible();
				$(COLLAPSE_DEVTYPE).hpCollapsible();
				$(COLLAPSE_HWTYPE).hpCollapsible();
				$(COLLAPSE_HWTYPE_DL).hpCollapsible();
				$(COLLAPSE_HWTYPE_ML).hpCollapsible();
				$(COLLAPSE_HWTYPE_BL).hpCollapsible();
				$(COLLAPSE_HWTYPE_SL).hpCollapsible();
				$(COLLAPSE_HWTYPE_XL).hpCollapsible();
				$(COLLAPSE_HWTYPE_WS).hpCollapsible();
				$(COLLAPSE_HWTYPE_APOLLO).hpCollapsible();
				$(COLLAPSE_HWTYPE_MICROSERVER).hpCollapsible();
				$(COLLAPSE_HWTYPE_OTHERSERIES).hpCollapsible();
				$(COLLAPSE_HWTYPE_SYNERGY).hpCollapsible();
				$(COLLAPSE_CATEGORY).hpCollapsible();
				//$(COLLAPSE_SERVER).hpCollapsible();

				$(ADDBASELINE).on('click', onAddBaseline);
				
				$(SELECT_COMPTYPE).selectBox({autoWidth: false});
				
				$(BOOTABLEISO_CHKBOX).on('click', onBootableIsoClick);
				$(MATCHMATRIXVERSION_CHKBOX).on('click',onMatchMatrixVersionClick);
				$(OAEFM_CHKBOX).on('click', onOaEfmClick);
				
				$('.hpsum-nonUEFI').hide();
				$(NONUEFI_CHECKBOX).on('click', onNonUEFIchkboxClick);
				
				initSourcesTable();
				
				confirmDialogContents = $(CONFIRM_DIALOG).detach().show();
				
				$(COMPONENTS_COUNT_LABEL).html('').hide();
                
                 
	            var options = 	{
									command : 'init',
									panelLabel: "hpsum.baseline.custom.targetlocation",
						            panelHelp: "hpsum.baseline.custom.outputDirWarning",
						            bShowEmptyFolder: true,
						            bCreateDirectory: true,
						            panelBrowseText: "hpsum.common.browse",
						            enableActionButtons: enableActionButtons,
								};
				$(TARGET_LOC_BROWSE).hpsumBrowse(options);
	            
	           var options = 	{
									command : 'init',
									panelLabel: "hpsum.baseline.custom.isolocation",
									panelLabelStyle: "padding-right: 14px;",
						            panelHelp: "hpsum.baseline.custom.isolochelp",
						            panelBrowseText: "hpsum.common.browse",
						            enableActionButtons: enableActionButtons
						        };
				$(ISO_LOC_BROWSE).hpsumBrowse(options);
				
				// HP SUM source path browser
				var options = 	{
									command : 'init',
									panelLabel: "hpsum.baseline.custom.hpsumSourcePath",
						            panelHelp: "hpsum.baseline.custom.hpsumSourcePathHelp",
									bShowHPSUMFiles: true,
						            panelBrowseText: "hpsum.common.browse",
						            enableActionButtons: enableActionButtons,
						            onBrowseButtonClick: onHPSUMPathBrowseButtonClick,
						            onBrowseDone: onHPSUMPathBrowseButtonDone,
						            onBrowseCancel: onHPSUMPathBrowseButtonDone
						        };
								
				$(HPSUM_LOC_BROWSE).hpsumBrowse(options);
				$(CUSTOM_INPUT_SOURCE_TEXT).attr('style', 'width:450px;');
				$(HPSUM_LOC_BROWSE).append("<br><label id='" + HPSUM_VERSION_SELECTED + "'>" + localizer.getString("hpsum.baseline.custom.hpsumVersionSelected") + "</label>");
				
				// ISO path browse selection events
				var instIsoLocBrowse = $(ISO_LOC_BROWSE).data('plugin_hpsumBrowse');
				if(instIsoLocBrowse){
				   instIsoLocBrowse.setInputEvent('onkeyup', isoLocationChange);
				   instIsoLocBrowse.setInputEvent('onfocusout', onFocusChange);
				   instIsoLocBrowse.setInputEvent('onfocus', onFocusChange);
				}
				
				// HP SUM source path browse selection events
				var instHPSUMLocBrowse = $(HPSUM_LOC_BROWSE).data('plugin_hpsumBrowse');
				if(instHPSUMLocBrowse){
					instHPSUMLocBrowse.setInputEvent('onfocusout', onHPSUMFocusOutChange);
					instHPSUMLocBrowse.setInputEvent('onfocus', onFocusChange);
				}				
				
				router.watch('baseline custom section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
				
				$("input").bind("keypress", function(event) {
                    var keycode = (event.keyCode ? event.keyCode : (event.which ? event.which : event.charCode));
                    if (keycode == 13) { // keycode for enter key
						var isDisabled = $(CREATE).attr('disabled');
						if(isDisabled === undefined)
						{
							$(CREATE).trigger('click');
						}
                        event.preventDefault();
                      }
                });				
                this.resume();
            };
        }

        return BaselineCustomView;
    }());
    
    return new BaselineCustomView();
});
