// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type (BaselineRetryView)
 * This is a view class for Baseline Add menu option.
 */
define(['hpsum/presenter/baseline/BaselinePresenter',
    'hp/core/Notifications',
    'hp/view/DialogView',
    'hp/model/Session',
    'hp/core/Localizer',
    'hp/core/Router',
    'text!hpPages/core/header_help.html',
	'hpsum/view/baseline/BaselineShowView',
	'hp/core/UrlFragment',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'lib/jquery-ui-timepicker-addon',
    'lib/jquery.dateFormat',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpToggle',
    'lib/jquery.cookie',
	'hpsum/view/baseline/jquery.hpsumAddBaselineICMToken',
    'lib/jquery.jstree'],
function(presenter, notifications, DialogView, session, localizer, router, headerHelpHtml,baselineShowView,urlFragment) { "use strict";

    var BaselineRetryView = (function() {
      
        var HP_PASSPORT_ICM='#hpsum-baseline-ICM',
			HP_PASSPORT_TOKEN='#hpsum-baseline-ICM_hp-passport-token-input',
			HP_RETRY_DOWNLOAD='#hpsum-baseline-ICM',
			MISSINGCOMPONENTS='#hpsum-baseline-ICM_hpsum-node-retry-baselines',
			MISSINGCOMPONENT_TABLE='#hpsum-baseline-ICM_hpsum-missingcomponents-table',
			SELECT = '#hpsum-baseline-ICM_select-all-components',
            DESELECT = '#hpsum-baseline-ICM_deselect-all-components',
			RETRY_BUTTON = '#hpsum-baselines-retry';
			
			
        /**
         * Constructor
         */
        function BaselineRetryView() {
          
            var addInProgress = false;
            var browseDialogContents;
            var infoDialog;
            var proxyOptionValue;
            var locationType = 'local';
            var addWaitDialog;
			var prevURL;
	    var iserror = false;
	    var FOLDER_NOT_EMPTY_ERROR = 3017;
		

            /**
             * @public
             * Initialization function for the object
             * All the controls actions are initialized in this function.
             */
			 	
			function onSelectAll() {					
					$(SELECT).attr('disabled', true);
					$(DESELECT).attr('disabled', false);
					var deselectedRows = $(MISSINGCOMPONENT_TABLE + ' tbody tr:not(.hp-selected)');
  			    	for (var tmp = 0; tmp < deselectedRows.length; tmp++)  
  					    { 
  					    	var data = $(MISSINGCOMPONENT_TABLE).dataTable().fnGetData(deselectedRows[tmp].rowIndex-1); 
 					    	var selectid = data.select.split('"'); 
 							selectid ='#'+ selectid[1]; 
 							$(selectid).prop('checked', true); 
 					    	$(selectid).trigger('change'); 
 					    }  
					$(MISSINGCOMPONENT_TABLE + ' tbody tr').addClass('hp-selected');
					$(RETRY_BUTTON).attr('disabled',false);
					
				}
				
			function onDeselectAll() {					
					$(DESELECT).attr('disabled', true);			
					$(SELECT).attr('disabled', false);
					var selectedRows = $(MISSINGCOMPONENT_TABLE + ' tbody tr.hp-selected');
  			    	for (var tmp = 0; tmp < selectedRows.length; tmp++)  
  					    { 
  					    	var data = $(MISSINGCOMPONENT_TABLE).dataTable().fnGetData(selectedRows[tmp].rowIndex-1); 
 					    	var selectid = data.select.split('"'); 
 							selectid ='#'+ selectid[1]; 
 							$(selectid).removeAttr('checked'); 
 					    	$(selectid).trigger('change'); 
 					    }  
					$(MISSINGCOMPONENT_TABLE + ' tbody tr').removeClass('hp-selected');
					$(RETRY_BUTTON).attr('disabled',true);
				}
			function retryPFW()
			{
				var url=router.location();
				var list=url.split("/");
				if(url == "/baseline/retry")
				{
					url = prevURL;
					list=url.split("/");
				}
				else
					prevURL = url;
				var baseline=list[8]+"/"+list[10];
				var options = {
									command : 'getSelectedComponents',
									args : baseline
								};
				$(HP_RETRY_DOWNLOAD).hpsumAddBaselineICMToken(options);
				
			}
            this.init = function() {
				var data=baselineShowView.getCompData();
				if(data.length==0)
				{
					router.go('/baseline/show/');
				}
				this.resume();
            };
			
			this.resume=function() {
				var data=baselineShowView.getCompData();
				if(data.length ==0)
				{
					$(RETRY_BUTTON).attr('disabled',true);
					$(MISSINGCOMPONENT_TABLE).attr('disabled',true);
				}
				else
				{
					$(RETRY_BUTTON).attr('disabled',false);
					$(MISSINGCOMPONENT_TABLE).attr('disabled',false);
				}
				$(HP_RETRY_DOWNLOAD).hpsumAddBaselineICMToken('init');
				var options = {
										command : 'addICMToken',
										args : data
									};
				$(HP_RETRY_DOWNLOAD).hpsumAddBaselineICMToken(options);
				var options = {
										command : 'addMissingDataTable',
										args : data
									};
				$(HP_RETRY_DOWNLOAD).hpsumAddBaselineICMToken(options);
				$(RETRY_BUTTON).unbind('click', retryPFW).bind('click', retryPFW);
				$(SELECT).live('click', function(ev) {
						onSelectAll.call(this);
						ev.preventDefault();
					});
				$(DESELECT).live('click', function(ev) {
						onDeselectAll.call(this);
						ev.preventDefault();
					});
            };
        }

        return BaselineRetryView;
    }());
    
    return new BaselineRetryView();
});
