// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['hpsum/presenter/enclosure/EnclosurePresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'jquery'],
function(presenter, router, urlFragment) { "use strict";

    var EnclosureFlyView = (function() {
      
        var NAME = '#tour-enclosure-fly-name';
      
        /**
         * Constructor
         */
        function EnclosureFlyView() {
          
            function onItemChange(item) {
                if (item) {
                    $(NAME).text(item.name);
                } else {
                    $(NAME).text('');
                }
            }
          
            /**
             * @public
             */
            this.resume = function () {
                presenter.on("itemChange", onItemChange);
            };
            
            this.pause = function () {
                presenter.off("itemChange", onItemChange);
            };
            
            this.init = function() {
                $('.hp-cancel').click(function () {
                    router.go(urlFragment.replaceView(router.location(), 'show'));
                });
                this.resume();
            };
        }

        return new EnclosureFlyView();
    }());
    
    return EnclosureFlyView;
});
