// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['hpsum/presenter/enclosure/EnclosurePresenter',
    'hp/core/Router',
    'jquery',
    'hp/lib/jquery.hpStackedPanels'],
function(presenter, router) { "use strict";

    var EnclosureShowMoreView = (function() {
      
        var PANELS = '#tour-enclosure-more-panels';
        var PANEL_SELECTOR = '#tour-enclosure-panel-selector';
        var LIST = '#tour-slots';
        var ITEM_TEMPLATE = '#tour-slot-template';
        var TABLE = '.tour-slot-ports';
        var ROW_TEMPLATE = '#tour-slot-port-template';
        var ROUTE_PATHS = '(general|bandwidth|usage)';
        var ROUTE_PREFIX = '/enclosure/show/' + ROUTE_PATHS;
      
        /**
         * Constructor
         */
        function EnclosureShowMoreView() {
          
            var slots = ['Embedded', 'Slot 1', 'Slot 2', 'Slot 3', 'Slot 4'];
          
            function changeLocation(location) {
                $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
            }
            
            /**
             * @public
             */
            this.init = function() {
              
                // Bandwidth
                var slotIndex, li, rowIndex, tr;
                for (slotIndex = 0; slotIndex < slots.length; slotIndex += 1) {
                    li = $(ITEM_TEMPLATE).clone().show();
                    $('h2', li).html(slots[slotIndex]);
                    $('h3', li).html('Long Model Description');
                    
                    for (rowIndex = 0; rowIndex < 4; rowIndex += 1) {
                        tr = $(ROW_TEMPLATE).clone().show();
                        $('.tour-slot-port-name', tr).html('Port ' + (rowIndex + 1));
                        $(TABLE, li).append(tr);
                    }
                    
                    $(LIST).append(li);
                }
                
                $(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });
                
                router.watch('enclosure more section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
            };
        }

        return new EnclosureShowMoreView();
    }());
    
    return EnclosureShowMoreView;
});
