// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['hp/core/Router', 'jquery'],
function(router) { "use strict";

    var GraphicsView = (function() {
      
        var PAGE = '#tour-graphics-page',
            MASTER_ROWS = PAGE + ' .hp-master-table tbody tr',
            SELECTED = 'hp-selected';
      
        /**
         * Constructor
         */
        function GraphicsView() {
          
            this.changeLocation = function (location) {
                $(MASTER_ROWS).removeClass(SELECTED);
                $(MASTER_ROWS + '[data-href="#' + location + '"]').addClass(SELECTED);
                document.title =
                    $(MASTER_ROWS + '[data-href="#' + location + '"] td').html();
            }
          
            /**
             * @public
             */
            this.init = function() {
                $(MASTER_ROWS).click(function () {
                    router.go($(this).data('href').substr(1));
                });
            };
        }

        return new GraphicsView();
    }());
    
    return GraphicsView;
});
