// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type (GroupDeployView)
 * This is a view class for Group Deploy View.
 */
define(['hpsum/presenter/group/GroupPresenter',
    'hpsum/presenter/node/NodePresenter',
	'hp/core/Router',
	'hp/core/UrlFragment',
    'hp/core/Notifications',
	'hp/core/HelpMenu',
	'hp/view/DialogView',
	'hp/core/Localizer',
	'hp/view/FormStateView',
	'hp/model/Session',
	'hp/services/REST',
    'jquery',
    'hpsum/view/node/jquery.hpsumInstallables',	
    'hpsum/view/node/jquery.hpsumWarnings',	
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'lib/jquery.dataTables.rowReordering',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpToggle',	
	'hp/lib/jquery.hpSearchCombo',
	'hpsum/view/node/jquery.hpsumSchedule',
    'hpsum/view/node/jquery.hpsumInstallSetComponents'
	],

function(presenter, nodePresenter, router, urlFragment, notifications, helpMenu, DialogView, localizer, FormStateView, session,rest) {"use strict";

	var GroupDeployView = ( function() {

		//Consts can go here
	    var DEPLOY = '#hpsum-group-deploy-ok',
			CANCEL = '#hpsum-group-deploy-close',
			DEPLOY_CONTENTS = '#hpsum-group-deploy',
			GROUP_NODE_DEPLOY_CONTENT = '#hpsum-group-node-deploy-data',
			PANEL_SELECTOR = '#hpsum-deploy-panel-selector',
			FIRST_ANCHOR = PANEL_SELECTOR + ' a[href]:first',
			FORM = '#hpsum-group-deploy-add-form',
			PANELS = '#hpsum-group-deploy-panels',
			NAME = '#hpsum-group-deploy-name',
			REBOOTOPTION = '#hpsum-reboot-option',
			INSTALLATIONOPTION = '#hpsum-installation-option',
			DELAYMINUTES = '#hpsum-group-delay-seconds',
			DELAYSECERR = '#hpsum-group-delay-seconds-err-msg',
			DELAYMSG = '#hpsum-group-reboot-message',
			ROUTE_PREFIX = '/group/deploy',
			COMPVERBOSE_OPTION = '#hpsum-comp-verbose-checkbox',
            COMPVERBOSE_OPTION_LABEL = '#hpsum-comp-verbose-descr',
			CLEANUP_ONEXIT_OPTIONS = '#hpsum-group-cleanuponexitCheckbox',
			CLEANUP_ONEXIT_OPTIONS_LABEL = '#hpsum-group-cleanuponexit-descr',
			CLEANUPALL_ONEXIT_OPTIONS = '#hpsum-group-cleanupallonexitCheckbox',
			CLEANUPALL_ONEXIT_OPTIONS_LABEL = '#hpsum-group-cleanupallonexit-descr',
			NONECHECKBOX = '.nonecheckbox',
			USESNMPCHECKBOX = '.useSNMPcheckbox',
			USEAGENTLESSCHECKBOX = '.useAgentlesscheckbox',
			USEWEBEMCHECKBOX = '.useWEBEMcheckbox',
			SPLASH_DIALOG = '#hpsum-group-analysis-dialog',
			SPLASH_SPINNER = '#hpsum-group-analysis-spinner',
			THROBBER = '#hpsum-group-deploy-throbber',
			CURRENT_DATETIME = '#hpsum-group-current-datetime',
			INSTALL_ERROR = '#force-options-tbody-err',
			REBOOT_DISABLE = '.hpsum-otu-group-deploy-disable',
			REBOOT_DELAY_SEC = '60',
			NODE_DIALOG = '#hpsum-group-node-dialog',
			STAGE_DIALOG = '#hpsum-group-node-stage-dialog',
			NODE_COMP = '#hpsum-node-components',
			STAGE_COMP = '#hpsum-node-stage-components',
			NODE_ANALYSIS = "#hpsum-node-deploy-analysis",
			SCHEDULE_OPTIONS = '#hpsum-show-schedule',
			FAILED_DEP_CHECKBOX = '#hpsum-staged_failedDepCheckbox',
            FAILED_DEP_PANEL = '#hpsum-staged-deploy-failedDep',
			BASELINE_NAME = '#hpsum-baseline-name',
            ADDITIONAL_PCKG_NAME = '#hpsum-additonalPackage-name',
			GROUP_WARNING_MSG = '#hpsum-group-warning-messages',
			NODE_DEPLOY_COUNT_HEADER = '#hpsum-node-deploy-count-header',
            NODE_DEPLOY_COUNT = '#hpsum-node-deploy-count',
			NODE_UPDATE_WARNING = '#hpsum-node-update-warning',
            NODE_DETAILS_TABLE = '#hpsum-group-node-details-table',
			BASELINE_PANEL = '#hpsum-group-baseline-panel',
			FAILEDMSG = '#hpsum-group-inventory-failed-details',
			FAILEDPANEL = '#hpsum-group-inventory-failed',
			BASELINES = '#hpsum-group-baselines-search',
			HOTFIX = '#hpsum-group-addpackage-search',
			BASELINE_INPUT = '#hpsum-group-baselines-search-input',
			HOTFIX_INPUT = '#hpsum-group-addpackage-search-input',
			BASELINE_INPUT_ERR = '#hpsum-group-baselines-search-input-err',
			HOTFIX_INPUT_ERR = '#hpsum-group-addpackage-search-input-err',
			GROUP_NAME = '#hpsum-group-name',
			GROUP_NODE_COUNT = '#hpsum-node-numbers',
			BASELINE_DETAILS_HEADING = '#hpsum-baseline-details-heading',
			BASELINE_NAME_HEADING = '#hpsum-baseline-name_heading',
			TAB_INSTALLATION_OPTION_CONTAINER = '#li-show-installation-details',
			TAB_INSTALLATION_OPTIONS = '#show-installation-details',
			INSTALLATION_OPTIONS = '#hpsum-show-installation',
            TAB_SCHEDULE_OPTION_CONTAINER = '#li-show-schedule-details',
			TAB_SCHEDULE_OPTIONS = '#show-schedule-details',
            TAB_REBOOT_OPTION_CONTAINER = '#li-show-reboot-details',
			TAB_REBOOT_OPTION = '#show-reboot-details',
            REBOOT_OPTIONS = '#hpsum-show-reboot',
            TAB_ILO_MANAGEMENT_OPTION_CONTAINER = "#li-show-ilo-management-details",
            TAB_ILO_MANAGEMENT_OPTION = "#show-ilo-management-details",
            ILO_MANAGEMENT_OPTION = "#hpsum-show-ilo-management",
            ILO_SAVE_INSTALL_SET_NAME = '#hpsum-save-install-set-text',
            ILO_SAVE_INSTALL_SET_DESCR = '#hpsum-save-install-set-descr-text',
            ILO_SAVED_INSTALL_SET_CHECKBOX = '#hpsum-save-install-sets-checkbox',
			GROUP_DEPLOY_OPERATION_TABS_CONTENTS = '#group-deploy-operation-tabs-contents',
			GROUP_DEPLOY_OPERATION_TABS = '#group-deploy-operation-tabs',
			INSTALLATION_OPTION_IGNORE_WARNING_PANNEL = '#hpsum-node-ignore-warning',
			INSTALLATION_OPTION_IGNORE_WARNING_CHECKBOX = '#hpsum-node-ignore-warning-checkbox',
			GROUP_NODE_DEPLOY_TABLE_PANNEL = '#hpsum-group-nodes-deploy',
	        INSATLLSET_NAME_REQUIRED = '#hpsum-save-install-set-text-required',
	        INSTALLSET_DESC_REQUIRED = '#hpsum-save-install-set-descr-required',
	        MISSING_COMPSIG_WARNING = '#selection_warning_panel',
			DOWNGRADE_REWRITE_TEXT='#hpsum-downgrade-rewrite-text',
			MAX_LENGTH = 63;
			   

			var tempAbortInProgress = false;
			var scheduleDetails = {
				isScheduled : false,
				tempAbort : false,
				stageMode : "",
				schduledDateTime : "",
				};
			var scheduleDetailsIsSet = false;
			var groupScheduledFlag = false;
			var ILO_MGMT_OPTIONS_INSTALLSET_PLUGIN_PANEL = "#hpsum-installsets-plugin-panel";
			var isStageSelected = false;
			/**
			 * Constructor
			 */
			function GroupDeployView() {
			    var formStateView = new FormStateView();
			    var groupItem = null,
					setAttributesOnGroup = false,
					analysisWaitDialog = null,

					ForceOptions = {
					    hapi: {
					        installation_option: {
					            downgrade: false,
					            rewrite: false,
					            force: false,
					            firmware: false,
					            software: false
					        },
					    }
					},

					defaultOptiondetails = {
					    hapi: {
					        reboot_options: {
					            action: 'Never',
					            delay: REBOOT_DELAY_SEC,
					            message: localizer.getString('hpsum.node.rebootMessage')
					        }
					    }
					},

                    iloManagementOptions = {
                        hapi: {
                            ilo_management_options: {
                                save_install_set: 'false'
                            },
                        }
                    },

					ignoreWarningOption = {
                        hapi: {
                                ignore_warnings: 'true'
						}
                    },
                     baselineOptions = {
                         hapi: {
                             baselines: {
                                 baseline: 'NULL',
                                 remove_existing_baselines: false
                             },
                         }
                     },
					optiondetails = defaultOptiondetails,
					initialGetattr = null,
					NodeDialogContents = null,
					StageDialogContents = null,
					groupNodeDetails = [],
					warningmsg = '',
					failedDependencyCount = 0,
					SelectedComponents = 0,
					selectedCompCount = 0,
					failedDependencyFlag = false,
					applyOptions = false,
					nodeIdList = [],
					getUpdatelistnodeCount = 0,
					group_id = "",
					cancelDeploy = false,
					progressTimer,
					NodeDialog = null,
					isWarningsChecked = false,
                    isWarningPresent = false,
					baselines = '',
				    hotfixes = '',
				    assocBaseline = '',
				    newBaseline = null,
				    newHotFix = null,
				    assocHotFix = '',
					installSets = [],
					installSetObjList = [],
					isTaskQueuePresent = false,
                    isTaskQueueSelected = false,
                    isInstallSetSelected = false,
					setOkIfBaseline = false,
                    setOkIfHotfix = false,
					isDirectDeployPage = true,
                    rebootSelectionChanged = false,
					tmpScheduleTime = "",
                    nodeSelectedForDeploy = 0,
					inventoryInProgress = false,
                    isBaselinePresent = false,
                    skipdependency = 'OMITHOST',
                    isGroupHasAnyGen10orAboveNode = false,
                    isGroupHasAllGen10orAboveServer = false,
                    isGroupHasLocalHost = false,
                    DirectDeployWarningFlag = false,
                    isFailedDependencyChecked = false,
                    invalidComponentSelected = false,
                    isGroupHasAnyiLO5orAbove = false,
                    installsetflag = false,
                    skipMissingCompSig = false,
					is_saveInstallSet_Checked = false,
					validName = false, 
					validDesc = false;
                   
			    var ignore_warnings_chkbox_needed = false;
			    function handleTabClickAction(tab) {
			        var overTabsId = GROUP_DEPLOY_OPERATION_TABS_CONTENTS;
			        for (var eleCount = 0; eleCount < $(overTabsId)[0].children.length; eleCount++) {
			            $('#' + $(overTabsId)[0].children[eleCount].id).hide(); //hide all the contents
			        }
			        for (var optCount = 0; optCount < $('#group-deploy-operation-tabs')[0].children.length; optCount++) {
			            //unset all the tabs to default.
			           	var child = $('#group-deploy-operation-tabs')[0].children[optCount].children[0];
						$(child).addClass('company-a');
			           	$(child).removeClass('company-background');
			        }

			        $('#li-' + tab.getAttribute("data-panel-id")).show();//show the tab's content.
			        tab.style.color = "#000";// set the tab selection.
			        $(tab).addClass('company-background');
			    }

			    function onItemChange(item) {
			        groupItem = item.hapi;
			        if (router.location().match(/stage/i)) {
			            isStageSelected = true;
			        }
			        else {
			            isStageSelected = false;
			        }
			        if (groupItem) {
			            $(SCHEDULE_OPTIONS).hpsumSchedule('setMasterNodeTimer', groupItem.group_local_date_time);
			            cancelDeploy = false;
			            if(group_id != groupItem.group_id){
			                group_id = groupItem.group_id;
			                $(NAME).text(groupItem.group_name);
			                //Get the group attributes and display on UI
	
			                loadAttributes();
			                if(groupItem.group_state.match(/UAN|SCHEDULED|IDLE|STAGE_ONLY_DONE/i) && groupItem.group_phase.match(/UserActionNeeded|NoComponents|Scheduled|STAGEDONE/i)){
			                    populateDeployData();
			                }
			                else{
			                    cancelDeploy = true;
			                }
			                //temp abort if scheduled. 
			                if(groupItem.group_state.match(/SCHEDULED/i))
			                {
			                    cancelDeploy = false;
			                    tempAbortSchedule(groupItem);
			                }
			            }
			            if (groupItem.group_baselines.length > 0) {
			                for (var i = 0; i < groupItem.group_baselines.length; i++) {
			                    if (groupItem.group_baselines[i].match('/')) {
			                        var baseline = presenter.getBaselineDetailsforId(groupItem.group_baselines[i]);
			                        if (baseline) {
			                            if (baseline.name.match(/^Additional Package/i)) {
			                                $(HOTFIX).hpSearchCombo('set', { id: baseline.id, name: baseline.name });
			                            } else {
			                                $(BASELINES).hpSearchCombo('set', { id: baseline.id, name: baseline.name });
			                            }
			                        }
			                    }
			                    else {
			                        if (installSetObjList.length > 0) {

			                            for (var count = 0; count < installSetObjList.length ; count++) {
			                                if (!installSetObjList[count].id.match(groupItem.group_baselines[i])) {
			                                    var installSetObj = {
			                                        name: groupItem.group_baselines[i],
			                                        id: groupItem.group_baselines[i]
			                                    }
			                                }
			                            }
			                        }
			                        else {
			                            var installSetObj = {
			                                name: groupItem.group_baselines[i],
			                                id: groupItem.group_baselines[i]
			                            }
			                            installSetObjList.push(installSetObj);
			                        }
			                        $(BASELINES).hpSearchCombo('set', { id: groupItem.group_baselines[i], name: groupItem.group_baselines[i] });
			                    }
						        
			                }
			            }

			            showGroupBaseline(groupItem.group_baselines);
			            $(GROUP_NAME).text(groupItem.group_name);
			            $(GROUP_NODE_COUNT).text(groupItem.group_nodes.group_node.length);
		
			            if ((groupItem.group_state.match(/UAN|STAGE_ONLY_DONE/i) && (groupItem.group_phase.match(/UserActionNeeded|NoComponents|Scheduled|STAGEDONE/i)))) {
			                isDirectDeployPage = false;
			            }
			            else if(groupItem.group_state.match(/idle/i)){
			                isDirectDeployPage = true;
			            }
			         
			            $(SCHEDULE_OPTIONS).hpsumSchedule('setMasterNodeTimer', groupItem.group_local_date_time);
			            if (groupItem.group_schedule_date_time != false || tmpScheduleTime != "") {
			                if (groupItem.group_schedule_date_time != "") {
			                    $(SCHEDULE_OPTIONS).hpsumSchedule('setTimeinSchedulePlugin', groupItem.group_local_date_time, groupItem.group_schedule_date_time);
			                }
			                else {
			                    $(SCHEDULE_OPTIONS).hpsumSchedule('setTimeinSchedulePlugin', groupItem.group_local_date_time, tmpScheduleTime);
			                }
			                $(SCHEDULE_OPTIONS).hpsumSchedule('selectScheduled');
			            } else {

			                $(SCHEDULE_OPTIONS).hpsumSchedule('setTimeinSchedulePlugin', groupItem.group_local_date_time, groupItem.group_schedule_date_time);
			                $(SCHEDULE_OPTIONS).hpsumSchedule('runNow');
			            }

			        }
			        else {
			            cancelDeploy = true;
			        }
					
			        if($(SPLASH_SPINNER).is(":visible"))
			            $(SPLASH_SPINNER).dialog('destroy');
			        if(cancelDeploy){
			            $(CANCEL).trigger('click');
			        }

			        if (canEnableDeploy()) {
			            enableDeployBtn(true);
			        }
			        else {
			            enableDeployBtn(false);
			        }
			        if (groupItem.is_Gen10_or_above == true) { // group has all gen 10 servers and/or ilo5 nodes
			            isGroupHasAllGen10orAboveServer = true;
			          }

			        //Dnt show iLO_Mangament_options if group is not gen 10 or above.
			       if (isGroupHasAllGen10orAboveServer == false) {
			           $(TAB_ILO_MANAGEMENT_OPTION_CONTAINER).hide();
			           $(ILO_MANAGEMENT_OPTION).hide();
			           $('#hpsum-group-inventory-no-baseline-warning').text(localizer.getString('hpsum.group.selectBaselineWarning', new Array("")));

			       }
			       else {
			           $(TAB_ILO_MANAGEMENT_OPTION_CONTAINER).show();
			           $(ILO_MANAGEMENT_OPTION).show();
			           populateInstallsetInfo(groupItem.group_baselines);
			           $('#hpsum-group-inventory-no-baseline-warning').text(localizer.getString('hpsum.group.selectBaselineWarning', new Array(", a saved iLO Install Set or update using already queued components in the iLO Installation Queue")));
			           
			       }


			        $('#hpsum-group-nodes-deploy').css('padding-bottom', '0px');

			        if (isGroupHasAllGen10orAboveServer == true) {
			            presenter.getInstallSetAndTaskQueue({
			               
			                success: function (installSetList, taskQueueFlag) {

			                    installSets = installSetList
			                    isTaskQueuePresent = taskQueueFlag;
			                },
			                error: function (errorMessage) {
			                    notifications.show(errorMessage, 'error');
			                }
			            });
			        }
			        $('#node-baseline').hpsumInstallSetComponents('destroy');

			        //hide schdule tab.
			        $(TAB_SCHEDULE_OPTION_CONTAINER).hide();
			        $(TAB_SCHEDULE_OPTIONS).hide();
			        $(SCHEDULE_OPTIONS).hide();
			    }
			    function renderDeployPageOptions()
			    {
	                // Review and deploy page
			        if (isDirectDeployPage == false) {
			            $(BASELINE_PANEL).hide();
			            $(NODE_DEPLOY_COUNT_HEADER).show();
			            $(NODE_DEPLOY_COUNT).show();
			            $(CLEANUP_ONEXIT_OPTIONS).show();
			            $(CLEANUP_ONEXIT_OPTIONS_LABEL).show();
                       
			            //Clean up all should not come if group has only localhost node
			            if (groupItem.group_nodes.group_node) {
			                if (isGroupHasLocalHost == true && (groupItem.group_nodes.group_node.length == 1)) {
			                    $(CLEANUPALL_ONEXIT_OPTIONS).hide();
			                    $(CLEANUPALL_ONEXIT_OPTIONS_LABEL).hide();
			                }
			                else {
			                    $(CLEANUPALL_ONEXIT_OPTIONS).show();
			                    $(CLEANUPALL_ONEXIT_OPTIONS_LABEL).show();
			                }
			            }
			        
			        }
			        else {
			            // Direct deploy page
			            $(BASELINE_PANEL).hide();
			            //make task queue item as selected. 
			            if (isTaskQueuePresent) {
			                isTaskQueueSelected == true;
			                $(BASELINE_DETAILS_HEADING).text(localizer.getString('hpsum.common.iLOUdateListDetails'));
			                $(BASELINE_NAME_HEADING).hide();
			                $('#hpsum-additonalPackage-name_heading').hide();
			                $(ADDITIONAL_PCKG_NAME).hide();
			                $(BASELINE_NAME).text(localizer.getString('hpsum.common.pendingTaskQueue'));
			                showTabsForInstallSet();
                            //default tab
			                $(TAB_INSTALLATION_OPTIONS).trigger('click');
			            }
			            $(NODE_DEPLOY_COUNT_HEADER).hide();
			            $(NODE_DEPLOY_COUNT).hide();
			            $(CLEANUP_ONEXIT_OPTIONS).hide();
			            $(CLEANUP_ONEXIT_OPTIONS_LABEL).hide();
			            $(CLEANUPALL_ONEXIT_OPTIONS).hide();
			            $(CLEANUPALL_ONEXIT_OPTIONS_LABEL).hide();
                      }
			    }

			    function showGroupBaseline(baselines)
			    {
			        $(ADDITIONAL_PCKG_NAME).show();
			        $('#hpsum-additonalPackage-name_heading').show();
			        var baseline;
			        if (baselines.length > 0) {
			            if ((baselines[0] == "") && (baselines[1] == ""))
			            {
			                $(BASELINE_NAME).text(localizer.getString('hpsum.group.noBaseline'));
			                $(ADDITIONAL_PCKG_NAME).text(localizer.getString('hpsum.group.noAdtPackage'));
			            }
			            else if((baselines.length == 2) && (((baselines[0] != "") && (baselines[0] != "null")) && ((baselines[1] != "") && (baselines[1] != "null"))))
			            {
			                var baseline1 = presenter.getBaselineDetailsforId(baselines[0]);
			                var baseline2 = presenter.getBaselineDetailsforId(baselines[1]);
			                if (baseline1) {
			                    $(BASELINE_NAME).text(baseline1.name);
			                }
			                if (baseline2)
			                {
			                    $(ADDITIONAL_PCKG_NAME).text(baseline2.name);
			                }

			             }
			            else if ((baselines[0] != ""))
			            {
			                var baseline1 = presenter.getBaselineDetailsforId(baselines[0]);
			                if (baseline1) {
			                    if (baseline1.name.match(/^Additional Package/i)) {
			                        $(BASELINE_NAME).text(localizer.getString('hpsum.group.noBaseline'));
			                        $(ADDITIONAL_PCKG_NAME).text(baseline1.name);
			                    }
			                    else {
			                        $(BASELINE_NAME).text(baseline1.name);
			                        $(ADDITIONAL_PCKG_NAME).text(localizer.getString('hpsum.group.noAdtPackage'));
			                     
			                    }
			                }
			                else if (!baselines[0].match('/')) {
			                    $(BASELINE_NAME).text(baselines[0]); //install set
			                    $(ADDITIONAL_PCKG_NAME).hide();
			                    $('#hpsum-additonalPackage-name_heading').hide();
			                }
			            }
			            else if (baselines[1] != "")
			            {
			                var baseline1 = presenter.getBaselineDetailsforId(baselines[1]);
			                if (baseline1) {
			                    if (baseline1.name.match(/^Additional Package/i)) {
			                        $(BASELINE_NAME).text(localizer.getString('hpsum.group.noBaseline'));
			                        $(ADDITIONAL_PCKG_NAME).text(baseline1.name);
			                    }
                                else {
			                        $(BASELINE_NAME).text(baseline1.name);
			                        $(ADDITIONAL_PCKG_NAME).text(localizer.getString('hpsum.group.noAdtPackage'));
			                    }
			                }
			            }
                    }
			    }

			    function tempAbortSchedule(groupItem)
			    {
			        //show splash screen	
			        $(SPLASH_SPINNER).dialog({
			            modal : true,
			            position : "center",
			            draggable : false,
			            resizable : false,
			            show : 'fade',
			            dialogClass : 'hp-splash-dialog',
			            width : 400
			        });
			        $('#hpsum-splash-spinner').html(localizer.getString("hpsum.node.temporaryAbort"));
			        $(SPLASH_SPINNER).show();
			        $(SPLASH_SPINNER).focus();
					
			        if(groupItem.group_state == "SCHEDULED")
			        {
			            scheduleDetailsIsSet = true;
			            scheduleDetails.tempAbort = true;
			            if (! tempAbortInProgress) {
			                tempAbortInProgress = true;
			                var object = { hapi : { clearScheduleDateTime : false} };
			                presenter.abortItem(groupItem, object,{
			                    success : function(data) {
			                        var progressTimer = setInterval(function () {
			                            var group_uri = "/Session/" + session.getToken() + '/node/group/' + groupItem.group_id;
			                            rest.getURI(group_uri + "/getstatus", {
			                                success : function(data) {
			                                    if(data.hapi.group_state === "UAN")
			                                    {
			                                        tempAbortInProgress = false;
			                                        groupItem.group_state = data.hapi.group_state;
			                                        groupScheduledFlag = groupItem.group_scheduled;
			                                        groupScheduledFlag = false;
			                                        clearInterval(progressTimer);
			                                        rest.getURI(group_uri + "/getdata",{
			                                            success : function(data) {
			                                                groupItem.group_scheduled = data.hapi.group_scheduled;
			                                            },
			                                            error : function(errorInfo) {
															
			                                            }													
			                                        });
			                                        if($(SPLASH_SPINNER).is(":visible"))
			                                            $(SPLASH_SPINNER).dialog('destroy');
			                                    }
			                                },
			                                error : function(errorInfo) {
			                                    tempAbortInProgress = false;
			                                    scheduleDetails.tempAbort = false;
			                                }
			                            });
			                        }, 5000);	
										
			                    },
			                    error : function(message) {
			                        tempAbortInProgress = false;
			                        scheduleDetails.tempAbort = false;
			                    }
			                });
			            }
			        }
			    }
				
			    function loadAttributes()
			    {
			        presenter.getAttributes(groupItem, {
			            success : function(data) {
			                if(data.hapi.hcode == 0)
			                    showoptions(data);
			            },
			            error : function(data) {
			            }
			        });
			    }
				
			    //Read the Option details like reboot options, verbose logging before deployment
			    function loadOptionDetails() {
			        var atleastOneOptionSelected = false;
			        optiondetails.hapi.reboot_options.action = $(REBOOTOPTION).val();
					
			        if (($(DELAYMINUTES).val() != '') && ($(DELAYMINUTES).val().match(/^[0-9]+$/) !== null)) {
			            optiondetails.hapi.reboot_options.delay = $(DELAYMINUTES).val() * 60;
			        }
					
			        if ($(DELAYMSG).val() != '') {
			            optiondetails.hapi.reboot_options.message = $(DELAYMSG).val();
			        }

			        if($(COMPVERBOSE_OPTION).is(':checked'))
			        {
			            optiondetails.hapi.verbose = true;
			            setAttributesOnGroup = true;
			        }
	
			        if(initialGetattr.hapi.reboot_options.action != optiondetails.hapi.reboot_options.action ||
						initialGetattr.hapi.reboot_options.delay != optiondetails.hapi.reboot_options.delay ||
						initialGetattr.hapi.reboot_options.message != optiondetails.hapi.reboot_options.message) {
			            atleastOneOptionSelected = true;
			        }
					
			        if (!atleastOneOptionSelected) {
			            optiondetails.hapi.reboot_options = {};
			        } else {
			            setAttributesOnGroup = true;
			        }
			       
			        if (isWarningsChecked && isDirectDeployPage)
			        {
			            optiondetails.hapi.ignore_warnings = true;
			            setAttributesOnGroup = true;
			        }
			   
			        if ($(ILO_SAVED_INSTALL_SET_CHECKBOX).is(':checked'))
			        {
			            iloManagementOptions.hapi.ilo_management_options = {};
			            iloManagementOptions.hapi.ilo_management_options.save_install_set = true;
			            iloManagementOptions.hapi.ilo_management_options.install_set_name = trimString($(ILO_SAVE_INSTALL_SET_NAME));
			            iloManagementOptions.hapi.ilo_management_options.install_set_description = trimString($(ILO_SAVE_INSTALL_SET_DESCR));
			            

			            optiondetails.hapi.ilo_management_options = iloManagementOptions.hapi.ilo_management_options;
			            setAttributesOnGroup = true;
			        }

			        if (isTaskQueueSelected == true) {
			            baselineOptions.hapi.baselines = {};
			            baselineOptions.hapi.baselines.baseline = "iLO_queued_updates";
			            baselineOptions.hapi.baselines.remove_existing_baselines = true;

			            optiondetails.hapi.baselines = baselineOptions.hapi.baselines;
			            setAttributesOnGroup = true;
			        }

			        atleastOneOptionSelected = false;
			    }
				
			    //Frame the setattributes for installation options based on type selected
			    function getInstallationOptions()
			    {
			        var type = $(INSTALLATIONOPTION).val();
			        ForceOptions.hapi.installation_option = {};
								 
			        ForceOptions.hapi.failed_dependency_handling = skipdependency;
			        ForceOptions.hapi.skip_missing_compsig = skipMissingCompSig;

			        ForceOptions.hapi.installation_option.downgrade = false;
			        ForceOptions.hapi.installation_option.rewrite   = false;
			        ForceOptions.hapi.installation_option.software = false;
			        ForceOptions.hapi.installation_option.firmware = false;
			        ForceOptions.hapi.installation_option.forcesoftware = false;
			        ForceOptions.hapi.installation_option.forcefirmware = false;
					
			        if ( type == "upgradeBoth"){
			            ForceOptions.hapi.installation_option.firmware = true;
			            ForceOptions.hapi.installation_option.software = true;
			        }
			        else if ( type == "upgradeFirmware"){
			            ForceOptions.hapi.installation_option.firmware = true;
			        }
			        else if ( type == "upgradeSoftware"){
			            ForceOptions.hapi.installation_option.software = true;
			        }					
			        else if ( type == "downgradeFirmware"){
			            ForceOptions.hapi.installation_option.downgrade = true;
			            ForceOptions.hapi.installation_option.firmware = true;
			            ForceOptions.hapi.installation_option.forcefirmware = true;
			        }
			        else if ( type == "downgradeSoftware"){
			            ForceOptions.hapi.installation_option.downgrade = true;
			            ForceOptions.hapi.installation_option.software = true;
			            ForceOptions.hapi.installation_option.forcesoftware = true;
			        }
			        else if ( type == "downgradeBoth"){
			            ForceOptions.hapi.installation_option.downgrade = true;
			            ForceOptions.hapi.installation_option.firmware = true;
			            ForceOptions.hapi.installation_option.forcefirmware = true;
			            ForceOptions.hapi.installation_option.software = true;
			            ForceOptions.hapi.installation_option.forcesoftware = true;
			        }
			        else if ( type == "rewriteFirmware"){
			            ForceOptions.hapi.installation_option.rewrite = true;
			            ForceOptions.hapi.installation_option.firmware = true;
			            ForceOptions.hapi.installation_option.forcefirmware = true;
			        }
			        else if ( type == "rewriteSoftware"){
			            ForceOptions.hapi.installation_option.rewrite = true;
			            ForceOptions.hapi.installation_option.software = true;
			            ForceOptions.hapi.installation_option.forcesoftware = true;
			        }
			        else if ( type == "rewriteBoth"){
			            ForceOptions.hapi.installation_option.rewrite = true;
			            ForceOptions.hapi.installation_option.firmware = true;
			            ForceOptions.hapi.installation_option.forcefirmware = true;
			            ForceOptions.hapi.installation_option.software = true;
			            ForceOptions.hapi.installation_option.forcesoftware = true;
			        }
			        else if ( type == "firmware"){
			            ForceOptions.hapi.installation_option.downgrade = true;
			            ForceOptions.hapi.installation_option.rewrite = true;
			            ForceOptions.hapi.installation_option.firmware = true;
			            ForceOptions.hapi.installation_option.forcefirmware = true;
			        }
			        else if ( type == "software"){
			            ForceOptions.hapi.installation_option.downgrade = true;
			            ForceOptions.hapi.installation_option.rewrite = true;
			            ForceOptions.hapi.installation_option.software = true;
			            ForceOptions.hapi.installation_option.forcesoftware = true;
			        }
			        else if ( type == "both"){
			            ForceOptions.hapi.installation_option.downgrade = true;
			            ForceOptions.hapi.installation_option.rewrite = true;
			            ForceOptions.hapi.installation_option.firmware = true;
			            ForceOptions.hapi.installation_option.forcefirmware = true;
			            ForceOptions.hapi.installation_option.software = true;
			            ForceOptions.hapi.installation_option.forcesoftware = true;
			        }

			        if(initialGetattr.hapi.installation_option.downgrade != ForceOptions.hapi.installation_option.downgrade ||
						initialGetattr.hapi.installation_option.rewrite != ForceOptions.hapi.installation_option.rewrite ||
						initialGetattr.hapi.installation_option.software != ForceOptions.hapi.installation_option.software ||
						initialGetattr.hapi.installation_option.firmware != ForceOptions.hapi.installation_option.firmware ||
                        initialGetattr.hapi.failed_dependency_handling != ForceOptions.hapi.failed_dependency_handling ||
                        initialGetattr.hapi.skip_missing_compsig != ForceOptions.hapi.skip_missing_compsig) {
			            applyOptions = true;
			        }
			    }
				
			    //Read the installation options and send setattributes to engine
			    function applyInstallationOptions(messageId)
			    {
			        //Load the installation options
			        getInstallationOptions();

			        if (isDirectDeployPage == false) {
			                if (applyOptions) {
			                    showAnalysisWaitDialog(messageId);
			                    formStateView.setMessage({
			                        summary: localizer.getString("hpsum.node.installationOptions.applyingOptions"),
			                        status: 'ok',
			                        changing: true,
			                    });

			                //For Review & deploy send setattribute immediately
			                presenter.setAttributes(groupItem, ForceOptions, {
			                    success: function (data) {
			                        getGroupStatus();
			                    },
			                    error: onSetattributeError
			                });
			            }
			        }
			        else {
			            formStateView.setMessage({
			                summary: localizer.getString("hpsum.node.installationOptions.optionsSuccess"),
			                status: 'ok',
			                changing: false,
			            });
			    }
			    }

			    //Get the group status and populate the node group data
			    function getGroupStatus()
			    {
			        var timer = setTimeout(function() {
			            presenter.getGroupStatus({group_id: groupItem.group_id}, {
			                success : function(data) {
			                    if (data.hapi.hcode == 0) {
			                        if (data.hapi.group_status.match(/Ready to start deploy/)) {
			                            clearTimeout(timer);	
			                            timer = '';
			                            //Get the Latest Node data on the UI
			                            populateDeployData();
			                          							
			                            if(applyOptions)
			                            {
			                                closeAnalysisWaitDialog();
			                                formStateView.setMessage({
			                                    summary: localizer.getString("hpsum.node.installationOptions.optionsSuccess"),
			                                    status: 'ok',
			                                    changing: false,
			                                });
			                                applyOptions = false;
			                                loadAttributes();
			                            }
			                        }
			                        else
			                        {
			                            getGroupStatus();
			                        }
			                    }
			                },
			                error : function(data) {
			                    clearTimeout(timer);
			                    timer = '';
			                    closeAnalysisWaitDialog();
			                }
			            });
			        }, 10000); 
			    }
				
			    function showoptions(data)
			    {
			        initialGetattr = null;
			        if(data && data.hasOwnProperty("hapi"))
			        {
			            initialGetattr = data;
			            if (data.hapi.hasOwnProperty("ignore_warnings") && data.hapi.ignore_warnings) {
			                isWarningsChecked = true;
			                isWarningPresent = true;
			               // $(INSTALLATION_OPTION_IGNORE_WARNING_CHECKBOX).attr('checked', true);
			            }

			            if(data.hapi.hasOwnProperty("verbose") && data.hapi.verbose){
			                $(COMPVERBOSE_OPTION).attr('checked', true);
			            }
						
			            if(data.hapi.hasOwnProperty("cleanup_onexit") && data.hapi.cleanup_onexit){
			                $(CLEANUP_ONEXIT_OPTIONS).attr('checked', true);
			            }
			            else {
			                $(CLEANUP_ONEXIT_OPTIONS).attr('checked', false);
			            }

			            if(data.hapi.hasOwnProperty("cleanupall_onexit") && data.hapi.cleanupall_onexit){
			                $(CLEANUPALL_ONEXIT_OPTIONS).attr('checked', true);
			            }
			            else {
			                $(CLEANUPALL_ONEXIT_OPTIONS).attr('checked', false);
			            }
						
			            if(data.hapi.hasOwnProperty("reboot_options") && data.hapi.reboot_options)
			            {
			                var rebootOptchanged = false;
			                if (initialGetattr.hapi.reboot_options.action != $(REBOOTOPTION).val() ||
						        initialGetattr.hapi.reboot_options.delay != $(DELAYMINUTES).val() ||
						        initialGetattr.hapi.reboot_options.message != $(DELAYMSG).val()) {
			                    rebootOptchanged = true;
			                }
			                $('#hpsum-reboot-option option').filter(function() {
			                    if(rebootOptchanged && new RegExp(this.value, 'ig').test( data.hapi.reboot_options.action))
			                        $(this).attr('selected', true);
			                });

			                if (!rebootOptchanged) { // update these value if user has not changed values. 
			                    if (-1 < data.hapi.reboot_options.delay) {
			                        $(DELAYMINUTES).val(data.hapi.reboot_options.delay / 60);
			                    }
			                    else {
			                        $(DELAYMINUTES).val(REBOOT_DELAY_SEC / 60);
			                    }

			                    $(DELAYMSG).attr('value', data.hapi.reboot_options.message);
			                    $(REBOOTOPTION).selectBox('reset');
			                }
			            }
					
			            if(data.hapi.hasOwnProperty("installation_option") && data.hapi.installation_option)
			            {
			                var rewriteOption = data.hapi.installation_option.rewrite;
			                var downgradeOption = data.hapi.installation_option.downgrade;
			                var firmwareOption = data.hapi.installation_option.firmware;
			                var softwareOption = data.hapi.installation_option.software;
							
			                if ( !rewriteOption  && !downgradeOption )
			                {
			                    if(firmwareOption && softwareOption){
			                        $(INSTALLATIONOPTION).val('upgradeBoth');
			                    }
			                    else if(firmwareOption){
			                        $(INSTALLATIONOPTION).val('upgradeFirmware');
			                    }
			                    else if(softwareOption){
			                        $(INSTALLATIONOPTION).val('upgradeSoftware');
			                    }
			                }
			                else if ( rewriteOption  && downgradeOption )
			                {
			                    if(firmwareOption && softwareOption)
			                        $(INSTALLATIONOPTION).val('both');
			                    else if(firmwareOption)
			                        $(INSTALLATIONOPTION).val('firmware');
			                    else if(softwareOption)
			                        $(INSTALLATIONOPTION).val('software');
			                }
			                else if ( rewriteOption )
			                {
			                    if(firmwareOption && softwareOption)
			                        $(INSTALLATIONOPTION).val('rewriteBoth');
			                    else if(firmwareOption)
			                        $(INSTALLATIONOPTION).val('rewriteFirmware');
			                    else if(softwareOption)
			                        $(INSTALLATIONOPTION).val('rewriteSoftware');
			                }
			                else if ( downgradeOption )
			                {
			                    if(firmwareOption && softwareOption)
			                        $(INSTALLATIONOPTION).val('downgradeBoth');
			                    else if(firmwareOption)
			                        $(INSTALLATIONOPTION).val('downgradeFirmware');
			                    else if(softwareOption)
			                        $(INSTALLATIONOPTION).val('downgradeSoftware');
			                }
											
			                $(INSTALLATIONOPTION).selectBox('reset');
			            }						

			            if(data.hapi.hasOwnProperty("ilo_management_options") && data.hapi.ilo_management_options.hasOwnProperty("save_install_set")) {
			                    $(ILO_SAVED_INSTALL_SET_CHECKBOX).attr('checked', data.hapi.ilo_management_options.save_install_set);
			                    is_saveInstallSet_Checked = data.hapi.ilo_management_options.save_install_set;
								if(is_saveInstallSet_Checked)
								{
									$(ILO_SAVE_INSTALL_SET_NAME).attr('disabled', false);
									$(ILO_SAVE_INSTALL_SET_DESCR).attr('disabled', false);
									validateInstallSetNameandDesc();
								}
								else{
									validName = false;
									validDesc = false;
									$(ILO_SAVE_INSTALL_SET_NAME).attr('disabled', true);
									$(ILO_SAVE_INSTALL_SET_DESCR).attr('disabled', true);
									$(INSATLLSET_NAME_REQUIRED).hide();
									$(INSTALLSET_DESC_REQUIRED).hide();
								}
			            }

			    
			            $(FAILED_DEP_CHECKBOX).attr('checked', false); //default

			            if ((data.hapi.hasOwnProperty("failed_dependency_handling") && (data.hapi.failed_dependency_handling == 'OMITCOMPONENT')) || (data.hapi.hasOwnProperty("skip_missing_compsig") && data.hapi.skip_missing_compsig == true)) {
			                    $(FAILED_DEP_CHECKBOX).attr("disabled", false);
			                    $(FAILED_DEP_CHECKBOX).attr('checked', true);
			                    isFailedDependencyChecked = true;
			            }
			        }
			    }

			    function errormsg()
			    {
			        $(INSTALL_ERROR).hide();
			    }

			    //replace(/(^\s*)|(\s*$)/gi, ""). // removes leading and trailing spaces
			    //replace(/[ ]{2,}/gi, " "). // replaces multiple spaces with one space 
			    //replace(/\n +/, "\n"); // Removes spaces after newlines
			    function trimString(el) {
			        el[0].value = el[0].value.replace(/(^\s*)|(\s*$)/gi, "").replace(/[ ]{2,}/gi, " ").replace(/\n +/, "\n"); // Removes spaces after newlines
			        return el[0].value;
			    }
			    function onDeploy() {
			        var schduledDateTime = $(SCHEDULE_OPTIONS).hpsumSchedule('getScheduleDateTime', true);
			        tmpScheduleTime = schduledDateTime;
			        if(schduledDateTime != "")  
			        {
			            if (!$(SCHEDULE_OPTIONS).hpsumSchedule('validateUserEnteredTime'))
			            {
			                return;
			            }
			        }
			        //validate save installset name and desciption.
			        if (isGroupHasAnyGen10orAboveNode == true && installsetflag == false && isTaskQueueSelected == false) {
					if ($(ILO_SAVED_INSTALL_SET_CHECKBOX).is(':checked')) {
							validateInstallSetNameandDesc();
						}
					}

			        if (validateRebootDelay()) {
			            //Disable the deploy button 
			            enableDeployBtn(false);
						
			            loadOptionDetails();
			            //Deploy for direct deploy
			            if (isDirectDeployPage){
			                doDirectDeploy();
			            }else{
			                doReviewDeploy();
			            }
			        }
			    }

			    function doDirectDeploy()
			    {
			        //Check the Installation ,reboot options and verbose log and then send setattributes
			        getInstallationOptions();
			        if (setAttributesOnGroup || applyOptions || isTaskQueueSelected == true)
				    {
				        if (applyOptions) {
				            optiondetails.hapi.installation_option = ForceOptions.hapi.installation_option;
				            applyOptions = false;
				        }
				       
				        presenter.setAttributes(groupItem, optiondetails, {
				            success: onSetattributeSuccess
,
				            error: onSetattributeError
				        });
				    }
				    else{
				        // do inventory as user assigned baseline now
				        doInventory();
				    }
				}

				function doReviewDeploy()
			    {
				    //for review and deploy
				    if (setAttributesOnGroup && !groupItem.group_state.match(/STAGE/i)) {
				        presenter.setAttributes(groupItem, optiondetails, {
				            success: onSetattributeSuccess,
				            error: onSetattributeError
				        });
				    }
				    else {
				        //Continue with deploy
				        onDeployContinue();
				    }
				}

				function onSetattributeSuccess(item) {
				    setAttributesOnGroup = false;
				    if (isDirectDeployPage == true) {
                        //For direct deploy do inventory now,but pending task queue dnt send inventory command
				        doInventory();
				    }else {
				        //Continue with deploy
				        onDeployContinue();
				    }
				}

				function onSetattributeError(errorMessage) {
					setAttributesOnGroup = false;
					closeAnalysisWaitDialog();
					notifications.show(errorMessage, 'error');
					enableDeployBtn(false);
					$(CANCEL).trigger('click');
				}
			
				
				/**
				 * @private
				 * Continue the deploy procedure from the Analysis onwards 
				 */
				function onDeployContinue() {
				    $(THROBBER).show();
				    if (isDirectDeployPage == false || isTaskQueueSelected == true) {
				        if ($(SCHEDULE_OPTIONS).hpsumSchedule('getScheduleDateTime') != "") {
				            groupItem.set_group_schedule_date_time = $(SCHEDULE_OPTIONS).hpsumSchedule('getScheduleDateTime');
				        }
				    }
				    if (isDirectDeployPage == false) {
				        if ($(CLEANUP_ONEXIT_OPTIONS).is(':checked')) {
				            groupItem.cleanup_onexit = true;
				        }

				        if ($(CLEANUPALL_ONEXIT_OPTIONS).is(':checked')) {
				            groupItem.cleanupall_onexit = true;
				        }
				    }

				    if ($(DEPLOY).attr("value") == "Stage") {
				        groupItem.stage_only = true;
				    }
				    else if ($(DEPLOY).attr("value") == "Deploy") {
				        groupItem.stage_only = false;
				    }
				
					presenter.deploy(groupItem, {
						success : onDeploySuccess,
						error : onDeployError
					});
				}

				function onDeploySuccess(item) {
					$(THROBBER).hide();
					notifications.show(groupItem.group_name + ' Group ' + localizer.getString("hpsum.group.deployStarted"), 'ok');
						
					$('.hpsumInstallables').hpsumInstallables('destroy');
					presenter.off("itemChange", onItemChange);
					router.go(urlFragment.replaceView(router.location(), 'show'));
				}

				function onDeployError(errorMessage) {
					$(THROBBER).hide();
					notifications.show(errorMessage, 'error');
					$(FAILEDPANEL).show();
					$(FAILEDMSG).text(errorMessage);
					$(CANCEL).trigger('click');
				}

				function enableDeployBtn(able) {
						if(router.location().match(/stage/i))
						{
							$(DEPLOY).val(localizer.getString('hpsum.group.stage'));
							$(DEPLOY).attr('tooltip', localizer.getString('hpsum.easymode.stageInfo')).hpTooltip();
							$('#hp-details-header-group-title').text(localizer.getString('hpsum.group.stageGroup'));
						    $(ILO_SAVED_INSTALL_SET_CHECKBOX)[0].checked = true;
						    $(ILO_SAVED_INSTALL_SET_CHECKBOX).attr('disabled', true);
						    $(ILO_SAVE_INSTALL_SET_NAME).attr('disabled', false);
						    $(ILO_SAVE_INSTALL_SET_DESCR).attr('disabled', false);
						    $('#hpsum-save-install-sets-descr').text(localizer.getString("hpsum.node.saveInstallSets") + " (required for Stage)");
							$('#hpsum-node-deploy-count-header').text(localizer.getString('hpsum.node.nodeStageCount'));
						}
						else
						{
							$(DEPLOY).val(localizer.getString('hpsum.node.deploy'));
							$('#hp-details-header-group-title').text(localizer.getString('hpsum.group.deployGroup'));
						}
					if (able) {
				        formStateView.reset();
						$(DEPLOY).removeAttr("disabled");
					} else {
						$(DEPLOY).attr('disabled', 'disabled');
					}
				}

				function changeLocation(location) {
					if (location.length > ROUTE_PREFIX.length) {
						$(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
					} else {
						$(PANELS).hpStackedPanels('setFirstPanel');
					}
				}

				function populateOptions() 
				{
					optiondetails = defaultOptiondetails;
					$(NONECHECKBOX).attr('checked', false);
					$(USESNMPCHECKBOX).attr('checked', false);
					$(USEAGENTLESSCHECKBOX).attr('checked', false);
					$(USEWEBEMCHECKBOX).attr('checked', false);
					$(INSTALLATIONOPTION).val('upgradeBoth');
					$(INSTALLATIONOPTION).selectBox('reset');
					$(REBOOTOPTION).selectBox('value', 'Never');
					$(INSTALL_ERROR).hide();
					$(DELAYMINUTES).val(REBOOT_DELAY_SEC);
					$('textarea' + DELAYMSG).attr('value', localizer.getString('hpsum.node.rebootMessage'));
				}
			
				function initGrpNodesTblForDirectDeploy(grouptableid) 
				{
				    
				        var oTab = $(grouptableid).dataTable({
				            oLanguage: {
				                sEmptyTable: localizer.getString('hpsum.group.noNodes'),
				                sSearch: localizer.getString('hpsum.common.search')
				            },
				            bPaginate: false,
				            bProcessing: true,
				            bFilter: true,
				            bSort: true,
				            bAutoWidth: false,
				            bInfo: false,
				            bRetrieve: true,
				            bDestroy: true,
				            bServerSide: false,
				            aoColumns: [
                                { mDataProp: 'node_ip' },
                                {
                                    mDataProp: 'status',
                                    fnRender: function (oObj) {
                                        if (oObj.aData.failedDepFlag) {
                                                return '<div class="hp-status"><div class="hp-status-value tooltip hp-status-error" tooltip="Dependency Errors"><span class="hp-value">error</span></div></div>';
                                            }
                                            else if (oObj.aData.selectedCompCount > 0) {
                                                return '<div class="hp-status"><div class="hp-status-value tooltip hp-status-warning" tooltip="Node Update required"><span class="hp-value">warning</span></div></div>';
                                            }
                                            else if (oObj.aData.totalCompCount == 0) {
                                                return '<div class="hp-status"><div class="hp-status-value tooltip hp-status-ok" tooltip="No Applicable components"><span class="hp-value">ok</span></div></div>';
                                            }
                                            else if (oObj.aData.selectedCompCount == 0) {
                                                return '<div class="hp-status"><div class="hp-status-value tooltip hp-status-ok" tooltip="No Updates applicable"><span class="hp-value">ok</span></div></div>';
                                            }
                                           // return '<div class="hp-status"><div class="hp-status-value tooltip hp-status-warning" tooltip="Node Update required"><span class="hp-value">warning</span></div></div>';

                                        
                                    }, sWidth: 5
                                },
                                {
                                    mDataProp: 'node_warning', 
                                    fnCreatedCell: function (nTd, sData, oData, iRow, iCol) {
                                        $(nTd).css('color', 'red')
                                    }
                                                       
                                },
                                { mDataProp: 'link', "bVisible": false, sWidth: 5 },
                                { mDataProp: 'node_status', "bVisible": false, sWidth: 5 },
                                { mDataProp: 'node_id', "bVisible": false, sWidth: 5 },
                                { mDataProp: 'state', "bVisible": false, sWidth: 5 },
                                { mDataProp: 'type', "bVisible": false, sWidth: 5 },
                                { mDataProp: 'selectedCompCount', "bVisible": false, sWidth: 5 },
                                { mDataProp: 'totalCompCount', "bVisible": false, sWidth: 5 },
                                { mDataProp: 'failedDepFlag', "bVisible": false, sWidth: 5 },
                                 { mDataProp: 'sigFilePresent', "bVisible": false, sWidth: 5 },


				            ],
				            aaSorting: [[0, "asc"]],
				            fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
				                return nRow;
				            }
				        });
				   
				}

				function initGrpNodesTblForReviewDeploy(grouptableid,groupBaselines)
				{
				   
				    var groupBaselinesStr = groupBaselines.join();
				    if (groupBaselinesStr.match('/')) {
				        $('#hpsum-click-applicable-comp').text(localizer.getString('hpsum.group.deployMsg', new Array("Applicable")));
				    }
				    else {
				        $('#hpsum-click-applicable-comp').text(localizer.getString('hpsum.group.deployMsg', new Array("Install set")));
				    }
				    var oTab = $(grouptableid).dataTable({
				        oLanguage: {
				            sEmptyTable: localizer.getString('hpsum.group.noNodes'),
				            sSearch: localizer.getString('hpsum.common.search')
				        },
				        bPaginate: false,
				        bProcessing: true,
				        bFilter: true,
				        bSort: true,
				        bAutoWidth: false,
				        bInfo: false,
				        bRetrieve: true,
				        bDestroy: true,
				        bServerSide: false,
				        aoColumns: [
                            { mDataProp: 'node_ip' },
                            {
                                mDataProp: 'status',
                                fnRender: function (oObj) {
                                    if (oObj.aData.failedDepFlag) {
                                        return '<div class="hp-status"><div class="hp-status-value tooltip hp-status-error" tooltip="Dependency Errors"><span class="hp-value">error</span></div></div>';
                                    }
                                    else if (oObj.aData.sigFilePresent.match(/No/i)) {
                                        return '<div class="hp-status"><div class="hp-status-value tooltip hp-status-error" tooltip="Missing Component Signature file"><span class="hp-value">error</span></div></div>';
                                    }
                                    else if (oObj.aData.selectedCompCount > 0) {
                                        return '<div class="hp-status"><div class="hp-status-value tooltip hp-status-warning" tooltip="Node Update required"><span class="hp-value">warning</span></div></div>';
                                    }
                                    else if (oObj.aData.totalCompCount == 0) {
                                        return '<div class="hp-status"><div class="hp-status-value tooltip hp-status-ok" tooltip="No Applicable components"><span class="hp-value">ok</span></div></div>';
                                    }
                                    else if (oObj.aData.selectedCompCount == 0) {
                                        return '<div class="hp-status"><div class="hp-status-value tooltip hp-status-ok" tooltip="No Updates applicable"><span class="hp-value">ok</span></div></div>';
                                    }

                                }, sWidth: 5
                            },
                            {
                                mDataProp: 'link',
                                fnRender: function (oObj) {
                                    if (oObj.aData.state == "UAN" || oObj.aData.state == "IDLE" || oObj.aData.state == "STAGE_ONLY_DONE") {
                                        if (groupBaselinesStr.match('/')) {
                                            return '<a id = "componentLink" href="javascript:void(0);" class="company-a">' + localizer.getString('hpsum.node.applicableComponents') + '</a>';
                                        }
                                        else {
                                            return '<a id = "componentLink" href="javascript:void(0);" class="company-a">' + localizer.getString('hpsum.common.installSetComponents') + '</a>';
                                        }
                                    }
                                    else if (oObj.aData.state == "REMOTE_STAGING_UAN" ||
                                        oObj.aData.state == "SCHEDULED") {
                                        return '<a id = "componentLink" href="javascript:void(0);" class="company-a">' + localizer.getString('hpsum.node.stageDetails') + '</a>';
                                    }

                                }
                            },
                            { mDataProp: 'node_status' },
                            {
                                mDataProp: 'node_warning',
                                fnCreatedCell: function (nTd, sData, oData, iRow, iCol) {
                                    $(nTd).css('color', 'red')
                                }
                            },
                            { mDataProp: 'node_id', "bVisible": false, sWidth: 5 },
                            { mDataProp: 'state', "bVisible": false, sWidth: 5 },
                            { mDataProp: 'type', "bVisible": false, sWidth: 5 },
                            { mDataProp: 'selectedCompCount', "bVisible": false, sWidth: 5 },
                            { mDataProp: 'totalCompCount', "bVisible": false, sWidth: 5 },
                            { mDataProp: 'failedDepFlag', "bVisible": false, sWidth: 5 }, 
				            { mDataProp: 'sigFilePresent', "bVisible": false, sWidth: 5 },

				        ],
				        aaSorting: [[0, "asc"]],
				        fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
				            return nRow;
				        }
				    });
				}
				//Get the Node details and show in tabular format
				function populateDeployData() {
				    isWarningPresent = false;
				    DirectDeployWarningFlag = false;
				    var iLOType = 0,
				       windowsNodePresent = false;
				    isGroupHasAnyGen10orAboveNode = false;
				    isGroupHasAnyiLO5orAbove = false;
					presenter.getUpdateList(groupItem, {
						success : function(data) {
						    groupNodeDetails = [];
							if (data.hasOwnProperty('hapi') && data.hapi.output_data.hasOwnProperty('nodes')) {
								var nodeData = data.hapi.output_data.nodes.node;
								for (var idx = 0; idx < nodeData.length; idx++){
									if(nodeData[idx].node_state == "UAN" || nodeData[idx].node_state == "REMOTE_STAGING_UAN" || 
										nodeData[idx].node_state == "SCHEDULED" || nodeData[idx].node_state == "STAGE_ONLY_DONE"|| nodeData[idx].node_state == "IDLE") {
										groupNodeDetails.push(nodeData[idx]);
									}
								
									if (nodeData[idx].warnings.length > 0) {
									    isWarningPresent = true;
									    //check if there are any server messages
									    
									    for (var len = 0; len < nodeData[idx].warnings.length; len++) {
									        if (nodeData[idx].warnings[len].type.match(/server/i)) {
									            ignore_warnings_chkbox_needed = true;
									            break;
									        }
									    }
									}
									if( nodeData[idx].type.match(/ilo/i))
									{
									    iLOType = nodeData[idx].type.substring(3);
									}
                                   
									if (nodeData[idx].type.match(/WINDOWS/i)) {
									    windowsNodePresent = true;
									}
									if(iLOType >= 5)
									{
									    isGroupHasAnyiLO5orAbove = true;
									}
								
									if (nodeData[idx].server_generation >= 10 || iLOType >= 5)
									{
									    isGroupHasAnyGen10orAboveNode = true;
									    if (isInstallSetSelected == false) {
									        $(TAB_ILO_MANAGEMENT_OPTION_CONTAINER).show();
									      $(ILO_MANAGEMENT_OPTION).show();
									        populateInstallsetInfo(groupItem.group_baselines);
									}
									    else {
									        $(TAB_ILO_MANAGEMENT_OPTION_CONTAINER).hide();
									        $(ILO_MANAGEMENT_OPTION).hide();
									    }
                                       
									  
									}
									if (nodeData[idx].node_id.match(/N1localhost/i))
									{
									    isGroupHasLocalHost = true;
                                    }
								}
								if (windowsNodePresent == true) {
								    $(COMPVERBOSE_OPTION).show();
								    $(COMPVERBOSE_OPTION_LABEL).show();
								}
								else {
								    $(COMPVERBOSE_OPTION).hide();
								    $(COMPVERBOSE_OPTION_LABEL).hide();
								}

								$(NODE_DEPLOY_COUNT).text(nodeSelectedForDeploy);
						
								if (isDirectDeployPage == false && isWarningPresent == true) {
								    showNodeWarnings();
								    $(INSTALLATION_OPTION_IGNORE_WARNING_PANNEL).hide();
								}
								else if (isDirectDeployPage == true && (isWarningPresent == true && isWarningsChecked == false)) {
								    $(GROUP_WARNING_MSG).hide();
								    $(INSTALLATION_OPTION_IGNORE_WARNING_PANNEL).show();
								}
								else {
								    $(GROUP_WARNING_MSG).hide();
								    $(INSTALLATION_OPTION_IGNORE_WARNING_PANNEL).hide();
								}
                               
								populateGroupNodeData(groupItem);
								renderDeployPageOptions();
							}

							if (canEnableDeploy())
							    enableDeployBtn(true);
							else
							    enableDeployBtn(false);
						},
						error : function(data) {
						}
					});
				}
			
				//Display the node data in tabular format
				function populateGroupNodeData(data) {
				    var htmlWarnings = '';
				    failedDependencyFlag = false;
				    selectedCompCount = 0;
				    invalidComponentSelected = false;
				    for (var idx = 0; idx < groupNodeDetails.length; idx++) {
				        htmlWarnings += '<div><label><b>' + groupNodeDetails[idx].ip + '</b></label><div id="hpsum-group-warnings-' + groupNodeDetails[idx].node_id + '"></div></div><br />';
				        $('#hpsum-group-node-cname-' + groupNodeDetails[idx].node_id).html(groupNodeDetails[idx].ip);
				    }
				    $(GROUP_NODE_DEPLOY_CONTENT, DEPLOY_CONTENTS).empty();
				   // $('.my-collapsible', DEPLOY_CONTENTS).hpCollapsible();
				 
				    var grouptableid = '#hpsum-group-deploy-table';
				    var groupNodeTable;
				    if (isDirectDeployPage == true) {
				        $("#hpsum-click-applicable-comp").hide();
				        $(GROUP_NODE_DEPLOY_CONTENT).append('<table class="hp-selectable" id="hpsum-group-deploy-table"><thead><tr><td><b>'
											+ localizer.getString('hpsum.node.ip') + '</b></td><td><b>'
											+ localizer.getString("hpsum.oneTouchUpdate.statusStr") + '</b></td><td><b>'
											+ localizer.getString('hpsum.common.warnings') + '</b></td><td></td><td></td></tr></thead></table>');
				        //Initialize the Node Group Data table
				        initGrpNodesTblForDirectDeploy(grouptableid,data.group_baselines);
				    }
				    else {
				        $("#hpsum-click-applicable-comp").show();

				        $(GROUP_NODE_DEPLOY_CONTENT).append('<table class="hp-selectable" id="hpsum-group-deploy-table"><thead><tr><td><b>'
                                          + localizer.getString('hpsum.node.ip') + '</b></td><td><b>'
                                          + localizer.getString("hpsum.oneTouchUpdate.statusStr") + '</b></td><td><b>'
                                          + localizer.getString('hpsum.node.componentDetails') + '</b></td><td><b>'
                                          + localizer.getString('hpsum.common.statusStr') + '</b></td><td><b>'
                                          + localizer.getString('hpsum.common.warnings') + '</b></td><td></td><td></td></tr></thead></table>');
				        //Initialize the Node Group Data table
				        initGrpNodesTblForReviewDeploy(grouptableid,data.group_baselines);
				    }
							  
				    groupNodeTable = $(grouptableid).dataTable();
					
				    //Clear the Group table;
				    if(groupNodeTable){
				        groupNodeTable.fnClearTable();
				    }

				    //Add the nodes to the Group table
				    nodeSelectedForDeploy = 0;
				    for(var idx = 0; idx < groupNodeDetails.length; idx++){
				        if(groupNodeDetails[idx].has_failed_dependency > 0){
				            failedDependencyFlag = true;
				            formStateView.setMessage({
				                summary: localizer.getString("hpsum.node.compFailedDep"),
				                status: 'warning',
				                changing: false,
				            });
				        }
				        if (groupNodeDetails[idx].sig_file_present.match(/No/i)) {
				            invalidComponentSelected = true;
				        }

				        selectedCompCount = groupNodeDetails[idx].selected_comp_count;
				        if (selectedCompCount>0)
				        {
                            nodeSelectedForDeploy++;
				        }
				       var nodeGroupItem;
				        var nodeStatusMsg = "";
						
				      //  nodeStatusMsg = "Some of the components have missing component signature file";
				        if(groupNodeDetails[idx].node_state === "UAN")
				        {
				            nodeStatusMsg = groupNodeDetails[idx].node_status;
				        }
				        else
				        {
				            nodeStatusMsg =  localizer.getString("hpsum.group.nodeStatusMsg");				
				        }

				        var nodeWarnings = "";
				        for (var warningCount = 0; groupNodeDetails[idx].warnings.length > warningCount; warningCount++)
				        {
				            nodeWarnings = nodeWarnings.concat(groupNodeDetails[idx].warnings[warningCount].message, '<br/>');
				        }
						if (router.location().match(/stage/i))
						{
							if(nodeStatusMsg.match(/deploy/i))
							{
								nodeStatusMsg=nodeStatusMsg.replace('deploy','stage');
							}
						}
				        nodeGroupItem = [{
				            'node_ip': groupNodeDetails[idx].ip,
				            'status': "",
				            'link': "",
				            'node_status': nodeStatusMsg,
				            'node_id': groupNodeDetails[idx].node_id,
				            'state': groupNodeDetails[idx].node_state,
				            'type': groupNodeDetails[idx].type,
				            'selectedCompCount': groupNodeDetails[idx].selected_comp_count,
				            'totalCompCount': groupNodeDetails[idx].total_comp_count,
				            'failedDepFlag': groupNodeDetails[idx].has_failed_dependency,
				            'node_warning': nodeWarnings,
				            'sigFilePresent': groupNodeDetails[idx].sig_file_present,
							'os_installed': groupNodeDetails[idx].os_installed
				        }];

				        groupNodeTable.fnAddData(nodeGroupItem);
				    }
				  
				    $(NODE_DEPLOY_COUNT).text(nodeSelectedForDeploy);

				    $('.tooltip').hpTooltip();

                    //Review and deploy
				    if (isDirectDeployPage == false) {
				        if (failedDependencyFlag || selectedCompCount == 0 || invalidComponentSelected == true) {
				            enableDeployBtn(false);
				        }
				        else if (selectedCompCount > 0) {
				            enableDeployBtn(true);
				        }

				        //If failed dependencies or compsig file is missing and install set is not selected then failed dependency checkbox will be enabled in Review and dpeloy page.
				        if ((invalidComponentSelected || failedDependencyFlag == true) && isInstallSetSelected == false) {
				            $(FAILED_DEP_CHECKBOX).attr("disabled", false);
				        }
				        else if(isFailedDependencyChecked == false){
				            //default will not show failed depandency checkbox
				            $(FAILED_DEP_CHECKBOX).attr('checked', false); //default
				            $(FAILED_DEP_CHECKBOX).attr("disabled", true);
				        }


				        //Click event for the Applicable components
				        $(grouptableid + " tbody tr").click(function (e) {
				            var srcElem;
				            var tableData = $(grouptableid).dataTable().fnGetData(this);

				            if (tableData != null) {
				                //Check if firefox or (chrome and IE)
				                if (e.srcElement)
				                    srcElem = e.srcElement;//Chrome and IE
				                else {
				                    srcElem = e.target;//Firefox
				                }

				                if (srcElem.tagName == 'A') {
				                    showNodeCompDialog(tableData, data.group_baselines);
				                }
				            }
				        });
				    }
				    else {
				        //default will show failed depandency checkbox
				        $(FAILED_DEP_CHECKBOX).attr("disabled", false);
				    }
				  }
				
				//Show the dialog with the component information for that node
				function showNodeCompDialog(data,groupBaselines) 
				{
				    var groupBaselinesStr = groupBaselines.join();
					var node_uri = "/Session/" + session.getToken() + "/node/" + data.node_id;
					InitNodeDialog(data);
					$(NODE_ANALYSIS).attr("disabled", true);
					if(data.state == "UAN")
					{
					       $(NODE_COMP).empty();
                           $(NODE_COMP).append("<div id='node-baseline' style='margin:10px;' ></div>");

					        if (groupBaselinesStr.match('/')) { //its SPP baseline
					            var nodeGrpItem = {
					                'node_id': data.node_id,
					                'type': data.type,
									'os_installed': data.os_installed
					            };

					            var options = {
					                command: 'init',
					                nodeItem: nodeGrpItem,
					                onSelectionChanged: onNodeSelectionChanged,
					                onPopulateInstallSet: onNodePopulateInstallSet

					            };
					            $('#hpsum-node-deploy-analysis').show();
					            //Call plugin to show the component list ();
					            $('#node-baseline').hpsumInstallables(options);
					        }
					        else { //its an install set
					            $('#hpsum-show-components').text(localizer.getString('hpsum.common.installSetTitle'));

					            //Call plugin to show Install set items();
					            renderInstallSetDetails(data, groupBaselines);
					        }
					}
					else if(data.state == "REMOTE_STAGING_UAN" ||
								data.state == "SCHEDULED")
					{
                        nodePresenter.getUpdateList(data.node_id, {                        
							success: function(data) {								
								if(data.hapi.hasOwnProperty("component_info"))
								{
                                    var criticalUpdates = parseInt( data.hapi.component_info.Critical);
				   					var recomenedUpdates = parseInt( data.hapi.component_info.Recommended);
				   					var optUpdates = parseInt( data.hapi.component_info.Optional);
				   					var nonCateUpdates = parseInt( data.hapi.component_info.Unknown);;
				   					var totalApplicableComponents= criticalUpdates + recomenedUpdates +
				   											optUpdates + nonCateUpdates;	

								}

                                $('#node-ip-adress' ,$(STAGE_COMP)).text(data.hapi.name);
								$('#total-stage-components' ,$(STAGE_COMP)).text(totalApplicableComponents.toString());
								$('#stage-critical-updates',$(STAGE_COMP)).text(criticalUpdates.toString());
								$('#stage-Recommended-updates',$(STAGE_COMP)).text(recomenedUpdates.toString());
								$('#stage-Optional-updates',$(STAGE_COMP)).text(optUpdates.toString());
								$('#stage-Non-Categorized-updates',$(STAGE_COMP)).text(nonCateUpdates.toString());
								
							},
							error: function(data) {								
							}
						});
					}
					
				}
			   
		    //Callback function for the selection changed event
				function onNodeSelectionChanged(id, value, componentList) {
				    //invalidComponentSelected = false;
				var selectedCompsCount = componentList.component.length;
				var failedDepCount = componentList.failed_dependency;
				
				//Disable Save button when node has failed dependencies or no components selected
				if(selectedCompsCount < 1 || !value){
					$(NODE_ANALYSIS).attr("disabled", true);
				}
				else{
					$(NODE_ANALYSIS).attr("disabled", false);
				}
			}
			
		    //Show the dialog with install set components information for that node
				function renderInstallSetDetails(groupItem, groupBaselines)
				{
				    if (groupItem) {
				        var selectedInstallSet_Id = -1;
				        var nodeInfoList = [];
				        for (var bCount = 0; bCount < installSets.length; bCount++) {

				            if (installSets[bCount].iloinstallset_name.match(groupBaselines)) {
				                nodeInfoList = installSets[bCount].node_info;
				                for (var count = 0; count < nodeInfoList.length; count++) {
				                    if (nodeInfoList[count].node_id.match(groupItem.node_id)) {
				                        selectedInstallSet_Id = nodeInfoList[count].iloinstallset_id;
				                    }
				                }
				            }
				        }

				        var item = {
				            node_id: groupItem.node_id,
				            installset_id: selectedInstallSet_Id
				        };

				        nodePresenter.getInstallSetDetails(item, {
				            success: function (data) {
				                // $(ILO_INSTALLSET_COMP_CONTAINER).show();

				                // populate components table.
				                var options = {
				                    command: 'init',
				                    data: data
				                };
				                $('#hpsum-node-deploy-analysis').hide();
				                $('#node-baseline').hpsumInstallSetComponents(options);
				            }
				        });
				    }
			}

			    //Callback function for deploy function from plugin
			function onNodePopulateInstallSet(node_id) {

			}

			function InitNodeDialog(data)
			{
			    if(!NodeDialog) {
			        var closefunc = function (elem) {
			            $(MISSING_COMPSIG_WARNING).hide();
						$('.hpsumInstallables').hpsumInstallables('destroy');
                        NodeDialog = null;
                     };
			     	NodeDialog = new DialogView();
			     	if(data.state == "UAN")
			     	{
			     	    if (data.sigFilePresent.match(/No/i) || (data.failedDepFlag == true))
						{
							//show warning pannel if compsig missing file is missing
							var selectionWarning = {
								warnings: []
							}

							var warningItem = {
							    message: localizer.getString('hpsum.group.missingCompSigAndFailedDepWarning')
							}
							selectionWarning.warnings.push(warningItem);
							$(MISSING_COMPSIG_WARNING, NodeDialogContents).hpsumWarnings(selectionWarning, false);
						}
                    	NodeDialog.init({contents: NodeDialogContents,
                        	position : "center",
                        	ok : function(){ closefunc() },
                        	cancel: function(){  closefunc() }
                    	}); 
						
                    	if (data.sigFilePresent.match(/No/i) || (data.failedDepFlag == true)) {
                    	    $(MISSING_COMPSIG_WARNING).show();
                    	}
						
                    	//Register the click event for the SAVE button 
	                    $(NODE_ANALYSIS, NodeDialogContents).off('click').on('click', function(ev) {
	                        btnNodeSaveClicked.call(this,data.node_id,data.type);
	                    });
                    }
                    else if(data.state == "REMOTE_STAGING_UAN" ||
										data.state == "SCHEDULED")
                    {
                        NodeDialog.init({contents: StageDialogContents,
                        	position : "center",
                        	ok : function(){ closefunc() },
                        	cancel: function(){ closefunc() }
                    	}); 
                    }
                    
                }
			}
			
			function btnNodeSaveClicked(nodeid,type) 
			{
				//Show the spinning wheel for the anlaysis 
				showAnalysisWaitDialog();

				//Get the component list for the selected node
				var inst = $('#node-baseline').data('plugin_hpsumInstallables');
				var componentsList = inst.getComponents();
				
				var nodeItem = {
					'node_id':nodeid
				};
				
				nodePresenter.analysis(nodeItem, componentsList, {
					node_id: nodeItem.node_id,
					success : function(data) {
						analyzeSuccess(data, this.node_id);
					},
					error : function(errorInfo) {
						analyzeError(errorInfo);
					}
				});
					
				//start the timer to check the node status
				progressTimer = setInterval(function () {
					var nodeItem = {
						'node_id':nodeid
					};
					nodePresenter.getNodeStatus(nodeItem, {
						nodeItem: nodeItem,
						success : function(data) {
							nodeStatusSuccess(data, nodeItem);
						},
						error : function(errorInfo) {
							
						}
					});
				}, 3000);
			}
			
			function nodeStatusSuccess(data, nodeItem)
			{
			
				if(data.hapi.node_status.node_state === "ANALYSIS")
				{
					
				}
				else if (data.hapi.node_status.node_state === "UAN" || data.hapi.node_status.node_state === "IDLE")
				{
					//Re populate all the nodes information to get the latest data
					populateDeployData();
					clearInterval(progressTimer);
					closeAnalysisWaitDialog();
	
					//disable Save button
					$(NODE_ANALYSIS).attr("disabled", true);
					//Close the Node Component dialog
					NodeDialog.cancel();

				}
				else if(data.hapi.node_status.node_state === "ERROR")
				{
					clearInterval(progressTimer);
					closeAnalysisWaitDialog();
				}
			}
			
			function analyzeSuccess(data, nodeid) {
			
			}
			
			function analyzeError(error) {
				closeAnalysisWaitDialog();
			}
			
			function showAnalysisWaitDialog(messageId) {
					analysisWaitDialog = $(SPLASH_DIALOG);
					analysisWaitDialog.dialog({
						modal : true,
						dialogClass : 'hp-simple-dialog',
						position : "center",
						draggable : false,
						closeOnEscape: false,
						resizable : false,
						width : 280,
						height : 180
					});
					if (messageId == 1) {
					    $('#hpsum-group-analysis-txt').html(localizer.getString("hpsum.group.applyingInstallationOptions"));
					}
					else
					    $('#hpsum-group-analysis-txt').html(localizer.getString("hpsum.group.applyingSelectionChanges"));
				$(SPLASH_SPINNER).show();
				analysisWaitDialog.dialog('open');
			}

			function closeAnalysisWaitDialog() {
				$(SPLASH_SPINNER).hide();
			    if (analysisWaitDialog)
			    {
				analysisWaitDialog.dialog('destroy');
			}		
			}		
			
			function validateRebootDelay() {
			 
			    var rebootopt = $(REBOOTOPTION).val();
				var delayMinutes = $(DELAYMINUTES).val();
				var valid = true;
				
				if (rebootopt != "Never") {
					if((isNaN(delayMinutes) && !isFinite(delayMinutes)) || 
					  (delayMinutes < 1 || delayMinutes > 60)) {
						$(DELAYMINUTES).addClass("hp-error");
						$(DELAYSECERR).text(localizer.getString("hpsum.node.rebootDelaySecondsErrMsg"));
						$(DELAYSECERR).show();
						valid = false;
					}
					else {
						$(DELAYMINUTES).val(parseInt(delayMinutes));
						$(DELAYMINUTES).removeClass("hp-error");
						$(DELAYSECERR).hide();
					}
				}
				return valid;
			}
			function canEnableDeploy()
			{
			    var retCode = true;
			    if ((isWarningPresent == false || isWarningsChecked == true || DirectDeployWarningFlag == true) && (isDirectDeployPage == true) && (setOkIfBaseline || setOkIfHotfix)) {
			        if (invalidComponentSelected == true  || validName == true || validDesc == true) {
			            retCode =  false;
			        }
                   
			    } else if ((isWarningPresent == false || isWarningsChecked == true) && (!failedDependencyFlag || isFailedDependencyChecked) && isDirectDeployPage == false)
			    {
			        if (invalidComponentSelected == true || validName == true || validDesc == true) {
			            retCode = false;
			        }
			    } 
				else 
			    {
			        retCode = false;
			    }
			    showDeployDisableMessage();
			    return retCode;
			}

			function showDeployDisableMessage()
			{
			    if ((isWarningPresent == true && isWarningsChecked == false) || DirectDeployWarningFlag == true) {
			        formStateView.setMessage({
			            summary: localizer.getString('hpsum.advanceMode.DeployDisabledDueToWarning'),
			            status: 'warning',
			            changing: false,
			        });
			    }
			    else if ((!setOkIfBaseline && !setOkIfHotfix) && isDirectDeployPage == true) {
			        formStateView.setMessage({
			            summary: localizer.getString('hpsum.node.noBaselineAvailable'),
			            status: 'warning',
			            changing: false,
			        });
			    }
			   else if (invalidComponentSelected) {
			       var message = '';
			       if (isStageSelected) {
			           message = localizer.getString('hpsum.group.groupStageDisabledDueToMissingSigFile');
			       }
			       else {
			           message = localizer.getString('hpsum.group.groupDeployDisabledDueToMissingSigFile');
			       }
			        formStateView.setMessage({
			            summary: message,
			            status: 'warning',
			            changing: false,
			        });
			    }
			   else if ((failedDependencyFlag && isFailedDependencyChecked == false) && isDirectDeployPage == false) {
			       var message = '';
			       if (isStageSelected) {
			           message = localizer.getString('hpsum.group.stageDisabledDueToDependencyFailureGrp');
			       }
			       else {
			           message = localizer.getString('hpsum.group.DeployDisabledDueToDependencyFailureGrp');
			       }
			        formStateView.setMessage({
			            summary: message,
			            status: 'warning',
			            changing: false,
			        });
			    }
				else if(validName == true || validDesc == true)
				{
					 var message = '';
					 if (isStageSelected) {
			           message = localizer.getString('hpsum.group.deployDisabledDueToNameDesc');
					}
			       else {
			           message = localizer.getString('hpsum.group.deployDisabledDueToNameDesc');
			       }
			        formStateView.setMessage({
			            summary: message,
			            status: 'warning',
			            changing: false,
			        });
				}
			    else {
			        formStateView.reset();
			    }

			}

			function showNodeWarnings() {
			    var groupWarning = {
			        warnings: []
			    }
			  
			    $(GROUP_WARNING_MSG).show();
			    
			    var warningItem = {
			        message: localizer.getString('hpsum.group.groupWarningMsg')
			    }
			    groupWarning.warnings.push(warningItem);
			    $(GROUP_WARNING_MSG).hpsumWarnings(groupWarning, ignore_warnings_chkbox_needed);
			    if (!ignore_warnings_chkbox_needed) {
			        isWarningsChecked = true; //making checkbox as checked as this checkbox is not needed, so that deploy button is enabled. 
			    }

			    if (isWarningPresent && isWarningsChecked)
			    {
			        $('.ignorewarnings').attr('checked', true);
			    }

			    $('.ignorewarnings').on('change', function () {
			        if ($(this).is(':checked')) {
			            isWarningsChecked = true;
			            if (canEnableDeploy())
			                enableDeployBtn(true);

			        } else {
			            isWarningsChecked = false;
			            if (!canEnableDeploy())
			                enableDeployBtn(false);
			        }

					 //Only for Review and deploy send attribute immediately
				       ignoreWarningOption.hapi.ignore_warnings = {};
						ignoreWarningOption.hapi.ignore_warnings = isWarningsChecked;
				       
				        showAnalysisWaitDialog();

				        presenter.setAttributes(groupItem, ignoreWarningOption, {
				            success: function (data) {
				                applyOptions = true;
				                getGroupStatus();
				            },
				            error: function (data) {
				                notifications.show(errorMessage, 'error');
				                enableDeployBtn(false);
				                $(CANCEL).trigger('click');
				            }

			    });
			    });
			}

			function getInstallSetDetailforId(installSetId) {
			    if (installSetId == '')
			        return null;
			    for (var idx = 0; idx < installSetObjList.length; idx++) {
			       
			        if (installSetObjList[idx].id.match(installSetId))
			            return installSetObjList[idx];
			    }
			    return null;
			}

			function showTabsForInstallSet()
			{
			    $(TAB_INSTALLATION_OPTION_CONTAINER).show();
			    $(INSTALLATION_OPTIONS).show();
			    $('#hpsum-force-options-collapsible').hide();
			    $(TAB_ILO_MANAGEMENT_OPTION_CONTAINER).hide();
			    $(ILO_MANAGEMENT_OPTION).hide();
			    $(TAB_INSTALLATION_OPTIONS).trigger('click');
			}

			function showTabsForBaseline() {
			    $(TAB_INSTALLATION_OPTION_CONTAINER).show();
			    $(INSTALLATION_OPTIONS).show();
			    $('#hpsum-force-options-collapsible').show();

			    if (isGroupHasAllGen10orAboveServer == true || isGroupHasAnyGen10orAboveNode == true) {
			        $(TAB_ILO_MANAGEMENT_OPTION_CONTAINER).show();
			        $(ILO_MANAGEMENT_OPTION).show();			        			        
			    }
			    $(TAB_INSTALLATION_OPTIONS).trigger('click');
			    if (isStageSelected) {
			        $(REBOOT_OPTIONS).css("display", "none");
			        $(TAB_REBOOT_OPTION).closest("li").hide();
			    }
			    else {
			        $(REBOOT_OPTIONS).css("display", "block");
			        $(TAB_REBOOT_OPTION).closest("li").show();
			    }
			}

			function reset() {
				populateOptions();
				group_id = "";
				nodeIdList = [];
				cancelDeploy = false;
				getUpdatelistnodeCount = 0;
				isWarningsChecked = false;
				$(DELAYMINUTES).attr("disabled", true);
				$(DELAYMSG).attr("disabled", true);
				$(COMPVERBOSE_OPTION).attr('checked', false);
				$(CLEANUP_ONEXIT_OPTIONS).attr('checked', false);
				$(CLEANUPALL_ONEXIT_OPTIONS).attr('checked', false);
				$(DELAYMINUTES).removeClass("hp-error");
				$(DELAYSECERR).hide();
				formStateView.reset();
			
				$(INSTALLATION_OPTIONS).css("display", "block");

				$(TAB_INSTALLATION_OPTIONS).closest("li").show();
				$(REBOOT_OPTIONS).css("display", "block");
				$(TAB_REBOOT_OPTION).closest("li").show();
			    //reset all values which were changed.
				rebootSelectionChanged = false;
				isGroupHasAnyGen10orAboveNode = false;
				isGroupHasAllGen10orAboveServer = false;
				isGroupHasLocalHost = false;

				$('#node-baseline').hpsumInstallSetComponents('destroy');
			}

			function onInventoryError(errorMessage) {
			    $('#hpsum-group-nodes-deploy').css('padding-bottom', '0px');
			    $(DEPLOY).attr('disabled', false);
			    $(THROBBER).hide();
			    $(FAILEDPANEL).show();
			    $(FAILEDMSG).text(errorMessage);
			    inventoryInProgress = false;
			 }

			function onInventorySuccess(item) {
			    $(DEPLOY).attr('disabled', false);
			    notifications.show(groupItem.group_name + ' Group ' + localizer.getString("hpsum.group.deployStarted"), 'ok');
			    $(THROBBER).hide();
			    inventoryInProgress = false;
			    formStateView.reset();
			    $(CANCEL).trigger('click');
			  }

			function performInventory() {
                groupItem.baselines = getSelectedBaselines();
			    groupItem.set_group_schedule_date_time = $(SCHEDULE_OPTIONS).hpsumSchedule('getScheduleDateTime');
			    groupItem.operation_mode = 2;
			    inventoryInProgress = true;
			    presenter.startInventory(groupItem, {
			        success: onInventorySuccess,
			        error: onInventoryError
			    });
			}

			function doInventory() {
			    var fail = false;
			    var finalBaseline;
			    var finalHotFix;
			    var baselineJson = [];

			    if (!inventoryInProgress)
			    {
			        var errorfound = false,
			         baselinedetails = false,
			         installSetdetails = false;
                
			        if ($(BASELINES).val() != '') {
			            baselinedetails = presenter.getBaselineDetailsforId($(BASELINES).val());
			            installSetdetails = getInstallSetDetailforId($(BASELINES).val());
			        }
			        else {
			            if ($(HOTFIX).val() != '') {
			                baselinedetails = presenter.getBaselineDetailsforId($(HOTFIX).val());
			                finalHotFix = baselinedetails.id;
			            }
			        }

			        if (!baselinedetails && !installSetdetails) {
			            errorfound = true;
			            $(BASELINE_INPUT_ERR).text(localizer.getString('hpsum.node.invalidBaseline'));
			            $(BASELINE_INPUT).addClass("hp-error");
			            $(BASELINE_INPUT_ERR).show();
			        }

			        var schduledDateTime = $(SCHEDULE_OPTIONS).hpsumSchedule('getScheduleDateTime');
			        if (schduledDateTime != "") {
			            if (!$(SCHEDULE_OPTIONS).hpsumSchedule('validateUserEnteredTime')) {
			                return;
			            }
			        }

			        if (errorfound == true) {
			            inventoryInProgress = false;
			            return;
			        }

			        enableDeployBtn(false);
			        $(THROBBER).show();
			        
                    //If pending task queue selected then dnt do inventory
			        if(isTaskQueueSelected == true)
			        {
			            onDeployContinue();
			        }
			        else
			        {
			            performInventory();
			        }
			    }
			}

			function getSelectedBaselines() {
			    var fail = false;
			    var finalBaseline;
			    var finalHotFix;
			    var baselineJson = [];
			    
			    if ((newBaseline == null) && (newHotFix == null))
			        fail = true;
			    else if (newHotFix == null) {
			        baselineJson.push(newBaseline.id);
			    }
			    else if (newBaseline == null) {
			        baselineJson.push(newHotFix.id);
			    }
			    else {
			        baselineJson.push(newBaseline.id);
			        baselineJson.push(newHotFix.id);
			    }

			    if (fail == false)
			    {
			        for (var idx = 0; idx < baselineJson.length; idx++) {
			            if (baselineJson[idx] == null) {
			                baselineJson.splice(idx, 1);
			            }
			        }
			    }
			    return baselineJson;
			}

			function populateInstallsetInfo(baselineList) {
			    var installsetName = "";
			    var installsetDesc = "";
			    if (baselineList.length > 0) {
			        for (var i = 0; i < baselineList.length; i++) {
			            var baseline = presenter.getBaselineDetailsforId(baselineList[i]);
			            if (baseline) {
			                //isBaselineSelected = true;
			                if (baseline.name.match(/^Additional Package/i)) {
			                    installsetName = "ADD_PKG";
			                    installsetDesc = "Hot Fixes for ProLiant";
			                } else {
			                    installsetName = "SPP_" + baseline.version;
			                    installsetDesc = baseline.baseline_name;
			                    break;
			                }
			            }
			        }
			    }
			    $(ILO_SAVE_INSTALL_SET_NAME).val(installsetName);
			    $(ILO_SAVE_INSTALL_SET_DESCR).val(installsetDesc);
				if ($(ILO_SAVED_INSTALL_SET_CHECKBOX).is(':checked')) {
					validateInstallSetNameandDesc();
				}
			}
			
			
			
			function updateUserInterfaceForOEM()
			{
				var sessionDataHandlers = {
					success : function(data) {
						// if hcode is 0 then session is alive and set session cookies
						if(data.hapi.hcode == 0) {
							var mfg = data.hapi.manufacturer;
							if (mfg != "HP" && mfg != "HPE") {
								$("#ilorep-gen10-only").remove();
							}
						}
						else
						{
							// if session is expired or any other error, then goto login page
							session.eraseAll();
							document.location.href = "/#/login";
						}
					},
					error : function(jqXHR) {
						// getsessiondata failed, so goto login page
						session.eraseAll();
						document.location.href = "/#/login";
					}
				};

				//get session data and set user and login details for the session
				session.getSessionData(sessionDataHandlers);
			}
			
			function changetoStagePage ()
			{
				$(TAB_INSTALLATION_OPTIONS).text(localizer.getString("hpsum.easymode.StagingOptions"));
				$(DOWNGRADE_REWRITE_TEXT).html(localizer.getString("hpsum.easymode.StagingOptionsMessage"));
				$(CLEANUP_ONEXIT_OPTIONS_LABEL).text(localizer.getString("hpsum.easymode.cleanuponexitstage"));
				$(CLEANUPALL_ONEXIT_OPTIONS_LABEL).text(localizer.getString("hpsum.easymode.cleanupallonexitstage"));
			}
			/**
			 * @public
			 * Initialize Group Deploy View
			 */
			this.init = function () {
				updateUserInterfaceForOEM();
				$(DEPLOY).live('click', function(ev) {
					onDeploy.call(this);
					ev.preventDefault();
				});
				
				enableDeployBtn(false);
				$(CANCEL).live('click', function() {
					//send previous request if the node is scheduled
					if(groupItem.group_schedule_date_time != "" && (groupItem.group_scheduled == "false" || groupScheduledFlag == false))
					{
						groupItem.set_group_schedule_date_time = groupItem.group_schedule_date_time;
						presenter.deploy(groupItem, {
							success : function(data) {
								tempAbortInProgress = false;
							},
							error : onDeployError
						});
					}
					else
					{					
						$('.hpsumInstallables').hpsumInstallables('destroy');
						presenter.off("itemChange", onItemChange);
						router.go(urlFragment.replaceView(router.location(), 'show'));
					}
				});


			  $(BASELINE_NAME_HEADING).show();
			  	presenter.getAllBaselines({
				    success: getBaselinesSuccess,
				    error: getBaselinesError
				});
			  	$(BASELINES).hpSearchCombo({
				    getResults: getBaseline
				});
				$(HOTFIX).hpSearchCombo({
				    getResults: getHotfixes
				});

				var currentBaseline = [];
				currentBaseline.push("");
				currentBaseline.push("");


				$(BASELINES).change(function (ev, value) {
				    isInstallSetSelected = false;
				    installsetflag = false;
				    $(BASELINE_INPUT_ERR).hide();
				    $(BASELINE_INPUT).removeClass('hp-error');
				    $(HOTFIX_INPUT_ERR).hide();
				    $(HOTFIX_INPUT).removeClass('hp-error');
				   
				    currentBaseline[0] = ($(BASELINES).val());
				    currentBaseline[1] = ($(HOTFIX).val());

				    isTaskQueueSelected = false;
				    var item = presenter.getBaselineDetailsforId(value);
				    var installSetDetails = getInstallSetDetailforId(value);
				    if (item)
				    {
				        currentBaseline[0] = item.id;
				        newBaseline = item;
				        showTabsForBaseline();
				        setOkIfBaseline = true;

				    } else if (installSetDetails)
				    {
				        var pendingTaskQueue = localizer.getString('hpsum.common.pendingTaskQueue');
				        if(installSetDetails.id.match(localizer.getString('hpsum.common.pendingTaskQueue')))
				        {
				            isTaskQueueSelected = true;
				            $(BASELINE_DETAILS_HEADING).text(localizer.getString('hpsum.common.iLOUdateListDetails'));
				            $(BASELINE_NAME_HEADING).hide();
				        }
				        else {
				            $(BASELINE_NAME_HEADING).text(localizer.getString('hpsum.common.iLOInstallSet'));
				            $(BASELINE_NAME_HEADING).show();
				            $(BASELINE_DETAILS_HEADING).text(localizer.getString('hpsum.common.iLOInstallSetDetails'));
				            installsetflag = true;
				        }
				        isInstallSetSelected = true;
				        currentBaseline[0] = installSetDetails.name;
				        newBaseline = installSetDetails;
				        showTabsForInstallSet();
				        setOkIfBaseline = true;
				    }
				    else
				    {
				        currentBaseline[0] = "";
				        showTabsForBaseline();
				        $(BASELINE_NAME_HEADING).text(localizer.getString('hpsum.baseline.show.baselineDetails'));
				        $(BASELINE_NAME_HEADING).show();
				        newBaseline = null;
				    }
                    if (!item && installSetDetails) {
				        $(HOTFIX).hpSearchCombo('disable');
				        $(HOTFIX).hpSearchCombo('set', {
				            id: '',
				            name: ''
				        });
				    }
				    else {
				        $(HOTFIX).hpSearchCombo('enable');
				    }

				    $(FAILEDPANEL).hide();

				    if (value == "") {
				        currentBaseline[0] = "";
				        $(BASELINE_DETAILS_HEADING).text(localizer.getString('hpsum.baseline.show.baselineDetails'));
				        $(BASELINE_NAME_HEADING).text(localizer.getString('hpsum.baseline.show.baselineAssigned'));
				        $(BASELINE_NAME_HEADING).show();
				        showTabsForBaseline();
				        setOkIfBaseline = false;
				    }

				    showGroupBaseline(currentBaseline);
				    if (canEnableDeploy()) {
				        enableDeployBtn(true);
				    } else {
				        enableDeployBtn(false);
				    }
				   
				});
				$(HOTFIX).change(function (ev, value) {

				    currentBaseline[0] = ($(BASELINES).val());
				    currentBaseline[1] = ($(HOTFIX).val());

                    $(BASELINE_INPUT_ERR).hide();
				    $(BASELINE_INPUT).removeClass('hp-error');
				    $(HOTFIX_INPUT_ERR).hide();
				    $(HOTFIX_INPUT).removeClass('hp-error');
				    var item = presenter.getBaselineDetailsforId(value);
				    setOkIfHotfix = false;
				    if (item) {
				        newHotFix = item;
				        currentBaseline[1] = item.id;
				      
				        setOkIfHotfix = true;
				    } else {
				        newHotFix = null;
				        setOkIfHotfix = false;
				        currentBaseline[1] = "";
				    }

				    $(FAILEDPANEL).hide();

				    if (value == "") {
				        showTabsForBaseline();
				        setOkIfHotfix = false;
				        currentBaseline[1] = "";
				    }

				    if (canEnableDeploy()) {
				        enableDeployBtn(true);
				    } else {
				        enableDeployBtn(false);
				    }

				    showGroupBaseline(currentBaseline);
				 });

				$(BASELINE_INPUT).unbind('keyup').bind('keyup', function () {
				    $(BASELINE_INPUT_ERR).hide();
				    $(BASELINE_INPUT).removeClass('hp-error');
				});

				$(HOTFIX_INPUT).unbind('keyup').bind('keyup', function () {
				    $(HOTFIX_INPUT_ERR).hide();
				    $(HOTFIX_INPUT).removeClass('hp-error');
				});
	
	
				//By Default reboot-options value is Never so disable the Reboot delay and Reboot message.
				$(REBOOT_DISABLE).find('input,textarea,select,button').prop("disabled", true);
				$(REBOOTOPTION).selectBox({ autoWidth: false });
				//$(ANALYSIS).attr('tooltip', localizer.getString('hpsum.common.deployPreviewToolTip')).hpTooltip();
				$(REBOOTOPTION).change(function() {
					var type = $('#hpsum-reboot-option option:selected').val();
					if (type == "Never") {
					$(REBOOT_DISABLE).find('input,textarea,select,button').prop("disabled", true);
					$(DELAYMINUTES).val('');
					$(DELAYMINUTES).removeClass("hp-error");
					$(DELAYSECERR).hide();
					}
					else
					{
					$(REBOOT_DISABLE).find('input,textarea,select,button').prop("disabled", false);
					}
				});
				$(REBOOTOPTION).selectBox({autoWidth: false});
				$(DELAYMINUTES).unbind('keyup').bind('keyup',function(){
					$(DELAYSECERR).hide();
					$(DELAYMINUTES).removeClass('hp-error');
					validateRebootDelay();
				}); 
				
				$(DELAYMINUTES).bind('change', function(){
					$(DELAYSECERR).hide();
					$(DELAYMINUTES).removeClass('hp-error');
				}); 
				
				$(PANELS).hpStackedPanels({
					panelSelector : PANEL_SELECTOR
				});

				$(ILO_SAVE_INSTALL_SET_NAME).bind('keyup', function () {
					validateInstallSetNameandDesc();
				});

				$(ILO_SAVE_INSTALL_SET_DESCR).bind('keyup', function () {
				    validateInstallSetNameandDesc();
				});

				$('#hpsum-downgrade-rewrite-text').html(localizer.getString("hpsum.node.installationOptions.message"));
				$('#hpsum-downgrade-rewrite-text').removeClass('hp-collapsed');
				$(INSTALL_ERROR).hide();
		        $(INSTALLATIONOPTION).change(function () {
				        applyInstallationOptions(1);
				    });
				$("#hpsum-reboot-options-collapsible").css("margin-top","-20px");
				$(INSTALLATIONOPTION).selectBox({autoWidth: false});
				$(INSTALLATIONOPTION).val('None');
				$(INSTALLATIONOPTION).selectBox('reset');
				$('#hp-force-downgrade-rewrite').hide();
				
				$(SCHEDULE_OPTIONS).hpsumSchedule({
				    enableButton: function () {
				      if(!failedDependencyFlag && selectedCompCount > 0)
						{
							$(DEPLOY).removeAttr("disabled");
						}
                        
                    },
				    disableButton: function () {
                        $(DEPLOY).attr("disabled", "disabled");
                    }
				});
	
				$(FAILED_DEP_CHECKBOX).click(function () {
				    var flag = $(FAILED_DEP_CHECKBOX).is(':checked');
				    if (flag) {
				        isFailedDependencyChecked = true;
				        skipdependency = 'OMITCOMPONENT';
				        skipMissingCompSig = true;
				    }
				    else {
				        isFailedDependencyChecked = false;
				        skipdependency = 'OMITHOST';
				        skipMissingCompSig = false;
				    }

				    applyInstallationOptions();

				    if (canEnableDeploy())
				        enableDeployBtn(true);
				    else
				        enableDeployBtn(false);

				});

				$(INSTALLATION_OPTION_IGNORE_WARNING_CHECKBOX).click(function () {

				    if ($(INSTALLATION_OPTION_IGNORE_WARNING_CHECKBOX).is(':checked')) {
				        isWarningsChecked = true;
				    }
				    else {
				        isWarningsChecked = false;
				    }
				    if (canEnableDeploy())
				        enableDeployBtn(true);
				    else
				        enableDeployBtn(false);
				});

			    //handle tabs actions.
				$(TAB_INSTALLATION_OPTIONS).click(function () {
				    handleTabClickAction(this);
				    return false;
				});
				$(TAB_SCHEDULE_OPTIONS).click(function () {
				    handleTabClickAction(this);
				    return false;
				});
				$(TAB_REBOOT_OPTION).click(function () {
				    handleTabClickAction(this);
				    return false;
				});
				$(TAB_ILO_MANAGEMENT_OPTION).click(function () {
				    handleTabClickAction(this);
				    return false;
				});

			    //default first tab will be selected. 
				$(TAB_INSTALLATION_OPTIONS).trigger('click');
			    //end of handling tabs actions.
				$(ILO_SAVED_INSTALL_SET_CHECKBOX).click(function () {
	
				    if ($(ILO_SAVED_INSTALL_SET_CHECKBOX).is(':checked')) {
				        $(ILO_SAVE_INSTALL_SET_NAME).attr('disabled', false);
				        $(ILO_SAVE_INSTALL_SET_DESCR).attr('disabled', false);
				        is_saveInstallSet_Checked = true;
						validateInstallSetNameandDesc();
				    }
				    else {
						validName = false;
						validDesc = false;
				        $(ILO_SAVE_INSTALL_SET_NAME).attr('disabled', true);
				        $(ILO_SAVE_INSTALL_SET_DESCR).attr('disabled', true);
				        $(INSATLLSET_NAME_REQUIRED).hide();
				        $(INSTALLSET_DESC_REQUIRED).hide();
						is_saveInstallSet_Checked = false;

				    }
					if(canEnableDeploy()){
						enableDeployBtn(true);
					}
					else {
						enableDeployBtn(false);
					}

                    //Only for Review and deploy send attribute immediately
				    if (isDirectDeployPage == false) {
				        iloManagementOptions.hapi.ilo_management_options = {};
				        iloManagementOptions.hapi.ilo_management_options.save_install_set = is_saveInstallSet_Checked;

				        showAnalysisWaitDialog();

				        presenter.setAttributes(groupItem, iloManagementOptions, {
				            success: function (data) {
				                applyOptions = true;
				                getGroupStatus();
				            },
				            error: function (data) {
				                notifications.show(errorMessage, 'error');
				                enableDeployBtn(false);
				                $(CANCEL).trigger('click');
				            }

				        });
				    }

				});

			    router.watch('Group Deploy section', ROUTE_PREFIX + '.*', {
					parent : ROUTE_PREFIX,
					change : changeLocation
				});
				
				formStateView.init({form: FORM,
					routePattern: ROUTE_PREFIX + '.*',
					autoTrack: false
				});
				
				this.resume();
			};
			function validateInstallSetNameandDesc() 
			{
				// Validate the Install Set Name - Should not be empty, should not be above 63 chars of length
				// Should not contain any special characters. 

				validName = handleErrors(ILO_SAVE_INSTALL_SET_NAME, INSATLLSET_NAME_REQUIRED);
				validDesc = handleErrors(ILO_SAVE_INSTALL_SET_DESCR, INSTALLSET_DESC_REQUIRED);

				if (canEnableDeploy())
					enableDeployBtn(true);
				else
					enableDeployBtn(false);

			}
			function handleErrors(NameorDesc, itemToDisplay)
			{
				var stringToCheck  = $(NameorDesc).val();
				var errorFound = false;
				if (stringToCheck == "") 
				{
					$(itemToDisplay).text(localizer.getString("hpsum.node.required"));
					errorFound = true;
				}
				else if(!(stringToCheck.match(new RegExp(/^[A-Za-z0-9.\-_ ]*$/i))))
				{
					$(itemToDisplay).text(localizer.getString("hpsum.node.validNameDesc"));
					errorFound = true;
				}
				else if(stringToCheck.length > MAX_LENGTH)
				{
					$(itemToDisplay).text(localizer.getString("hpsum.node.maxlen", [MAX_LENGTH]));
					errorFound = true;
				}
				//Display the error if any
				if(errorFound == true)
				{
					$(itemToDisplay).show();
					$(NameorDesc).addClass('hp-error');
				}
				else
				{
					$(itemToDisplay).hide();
					$(NameorDesc).removeClass('hp-error');
				}
					
				return (errorFound);
			}
				/**
				 * @public
				 * Resume Group Deploy View
				 */
			this.resume = function () {
				
				if (router.location().match(/stage/i))
				{
					changetoStagePage();
				}
                	$(THROBBER).hide();
					presenter.on("itemChange", onItemChange);
					$(PANELS).hpStackedPanels('resume');
					reset();
    			    NodeDialogContents = $(NODE_DIALOG).detach().show();
					StageDialogContents = $(STAGE_DIALOG).detach().show();
					$(NODE_COMP).empty();
					NodeDialog = null;
					scheduleDetails.isScheduled = false;						
					scheduleDetails.tempAbort = false;
					scheduleDetails.schduledDateTime = "";
					$(BASELINE_INPUT).removeClass("hp-error");
					$(HOTFIX_INPUT).removeClass("hp-error");
					$(BASELINE_INPUT_ERR).hide();
					$(HOTFIX_INPUT_ERR).hide();
					$(HOTFIX_INPUT).hpSearchCombo('enable');
					tmpScheduleTime = "";
					assocBaseline = null;
					assocHotFix = null;
					$(ILO_SAVE_INSTALL_SET_NAME).attr('value', "");   //.value = "";
					$(ILO_SAVE_INSTALL_SET_DESCR).attr('value', "");
					$(ILO_SAVE_INSTALL_SET_NAME).attr('disabled', true);
					$(ILO_SAVE_INSTALL_SET_DESCR).attr('disabled', true);
					$(INSATLLSET_NAME_REQUIRED).hide();
					$(INSTALLSET_DESC_REQUIRED).hide();
					$(ILO_SAVE_INSTALL_SET_NAME).removeClass('hp-error');
					$(ILO_SAVE_INSTALL_SET_DESCR).removeClass('hp-error');
					$(BASELINES).hpSearchCombo('set', {
					    id: '',
					    name: ''
					});
					$(HOTFIX).hpSearchCombo('set', {
					    id: '',
					    name: ''
					});
					presenter.on('itemChange', onItemChange);
					presenter.getAllBaselines({
					    success: getBaselinesSuccess,
					    error: getBaselinesError
					});
					$(FAILEDPANEL).hide();

			    //default first tab will be selected. 
					$(TAB_INSTALLATION_OPTIONS).trigger('click');
				//	$(ILO_SAVED_INSTALL_SET_CHECKBOX).attr('checked', false);
					//$(INSTALLATION_OPTION_IGNORE_WARNING_CHECKBOX).attr('checked', false);
					ignore_warnings_chkbox_needed = false;
					applyOptions = false;
					isFailedDependencyChecked = false;
				};

				/**
				 * @public
				 * Pause Group Deploy View
				 */
				this.pause = function() {
					presenter.off("itemChange", onItemChange);
					$(PANELS).hpStackedPanels('pause');
					$(FAILED_DEP_CHECKBOX).removeAttr("checked");
					tmpScheduleTime = "";
				};

				function getBaseline(string, handlers, count, start) {
				    installSetObjList = [];
				    if (isGroupHasAllGen10orAboveServer == true) {
				        for (var i = 0 ; installSets.length > i; i++) {
				            var installSetObj = {
				                name: installSets[i].iloinstallset_name,
				                id: installSets[i].iloinstallset_name
				            }
				            installSetObjList.push(installSetObj);
				        }

				        if (isTaskQueuePresent == true) {
				            var installSetObj = {
				                name: localizer.getString('hpsum.common.pendingTaskQueue'),
				                id: localizer.getString('hpsum.common.pendingTaskQueue')
				            }
				            installSetObjList.push(installSetObj);
				        }
				    }

				    var results = baselines.concat(installSetObjList);
				    if (string && string.length > 0) {
				        results = $.grep(results, function (option, index) {
				            return (option.name.match(new RegExp(string.replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1"), 'i')));
				        });
				    }
				    handlers.success({
				        count: results.length,
				        members: results,
				        start: 0,
				        total: results.length
				    });
				}

				function getHotfixes(string, handlers, count, start) {
				    var results = hotfixes;
				    if (string && string.length > 0) {
				        results = $.grep(hotfixes, function (option, index) {
				            return (option.name.match(new RegExp(string.replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1"), 'i')));
				        });
				    }
				    handlers.success({
				        count: results.length,
				        members: results,
				        start: 0,
				        total: results.length
				    });
				}

				function getBaselinesSuccess(searchResults) {
				 
				    baselines = $.grep(searchResults, function (option, index) {
				        return !(option.name.match(new RegExp('^Additional', 'i')));
				    });
				    hotfixes = $.grep(searchResults, function (option, index) {
				        return (option.name.match(new RegExp('^Additional', 'i')));
				    });

				}

				function getBaselinesError(msg) {

				}
				$(SCHEDULE_OPTIONS).hpsumSchedule({
					enableButton: function(){
						$(DEPLOY).removeAttr("disabled");
						
					},
					disableButton: function(){
						$(DEPLOY).attr("disabled", "disabled");
					}
				});
			}

		return GroupDeployView;
	}());

	return new GroupDeployView();
});
