// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['hpsum/presenter/group/GroupPresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/Notifications',
    'hp/view/FormStateView',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'hp/lib/jquery.hpSearchCombo',
    'lib/jquery.selectBox'],

function(presenter,router, urlFragment, notifications, FormStateView, localizer) {"use strict";

	var GroupInventoryView = ( function() {

			//Consts can go here
			var OK = '#hpsum-group-inventory-ok',
			    CANCEL = '#hpsum-group-inventory-close',
			    PANEL_SELECTOR = '#hpsum-group-inventory-panel-selector',
			    PANELS = '#hpsum-group-inventory-panels',
			    FORM = '#hpsum-group-inventory-form',
			    FAILEDMSG = '#hpsum-group-inventory-failed-details',
			    FAILEDPANEL = '#hpsum-group-inventory-failed',
			    BASELINES = '#hpsum-group-baselines-search',
			    ASSOCBASELINE = '#hpsum-group-baseline',
			    HOTFIX = '#hpsum-group-addpackage-search',
			    ASSOCHOTFIX = '#hpsum-group-addpackage',
			    NAME = '#hpsum-group-inventory-name',
			    ROUTE_PREFIX = '/group/inventory',
			    REMOVEBASELINE = '#hpsum-group-baseline-remove',
        		REMOVEHOTFIX = '#hpsum-group-addpackage-remove',
        		THROBBER = '#hpsum-group-inventory-throbber',
        		BASELINE_WARNING = '#hpsum-group-inventory-baseline-warning',
        		NOBASELINE_WARNING = '#hpsum-group-inventory-no-baseline-warning',
        		NOBASELINE_NODES_TABLE = '#hpsum-group-inventory-view-nodes',
        		NOBASELINE_DETAILS = '#hpsum-group-inventory-nobaseline-nodes',
				SCHEDULEINFO = '#hpsum-group-schedule-info',
				BASELINE_INPUT = '#hpsum-group-baselines-search-input',
				HOTFIX_INPUT = '#hpsum-group-addpackage-search-input',
				BASELINE_INPUT_ERR = '#hpsum-group-baselines-search-input-err',
				HOTFIX_INPUT_ERR = '#hpsum-group-addpackage-search-input-err',
				SKIP_STAGED_NODE_CHECKBOX = '#hpsum-nodegroup-skip-nodes',
				INVENTORY_NODES_TABLE = '#hpsum-group-inventory-nodes-table-div';
			var MENU = '.hp-search-combo-menu';
		var HEADER = '.hp-header';
		var FOOTER = MENU + ' .hp-footer';

			/**
			 * Constructor
			 */
			function GroupInventoryView() {
				var formStateView = new FormStateView();
				var inventoryInProgress = false,
				    groupItem = null,
				    baselines = '',
				    hotfixes = '',
				    assocBaseline = '',
				    newBaseline = null,
				    newHotFix = null,
				    assocHotFix = '',
				    searchResults = [],
					allNodesDetials = [],
					installSets = [],
					installSetObjList = [],
					date_time_new = '',
					time_value = '',
					date_value = '',
				    setOk = false,
                    isGroupHasAllGen10orAboveServer = false,
					hotfixRevalProgress =false,
					baselineRevalProgress =false,
					intialBaseline =[];

				function onItemChange(item) {
					item = item.hapi;

					if (item) {
						$(NAME).text(item.group_name);
						$(ASSOCBASELINE).text('');
						$(ASSOCHOTFIX).text('');
						$(REMOVEBASELINE).hide();
                    	$(REMOVEHOTFIX).hide();
						groupItem = item;
						newBaseline = null;
						newHotFix = null;
						formStateView.reset();
						
						presenter.getNodesData(groupItem, {
							success : function(data) {
								allNodesDetials = [];
								if (data.hasOwnProperty('hapi')) {
									allNodesDetials = data.hapi.output_data.nodes.node;
									//showScheduleWarning();
								}
								//populateInventoryNodeTable();
							},
							error : function(data) {
							}
						});

						if (groupItem.is_Gen10_or_above == true) {
						    isGroupHasAllGen10orAboveServer = true;
						}

					} else {
						$(CANCEL).trigger('click');
					}
					formStateView.reset();

					if (isGroupHasAllGen10orAboveServer == true) {

					    presenter.getInstallSetAndTaskQueue({
					        success: function (installSetList, taskQueueFlag) {
					            installSets = installSetList;
					            installSetObjList = [];
					            for (var i = 0 ; installSets.length > i; i++) {
					                
					                //check if installset is recovert set. if yes, it should be recovery set for all.
					                var isRecSet = false;
					                var notRecSet = false;
					                for (var recIndex = 0; installSets[i].node_info.length > recIndex ; recIndex++)
					                {
					                    if(installSets[i].node_info[recIndex].isRecoverySet == true)
					                    {
					                        isRecSet = true;
					                    }
					                    else {
					                        notRecSet = true;
					                    }
					                }
					                if (((!(isRecSet != undefined && notRecSet != undefined)) && (isRecSet == notRecSet))//add only if both IS are recovery set.
                                        || (isRecSet != undefined || notRecSet != undefined)) //means one of them found.. so, add. 
					                {
					                    var installSetObj = {
					                        name: installSets[i].iloinstallset_name,
					                        id: installSets[i].iloinstallset_name,
					                        isRecSet: installSets[i].node_info[0].isRecoverySet
					                    }
					                    installSetObjList.push(installSetObj);
					                }
					            }
					        },
					        error: function (errorMessage) {
					            notifications.show(errorMessage, 'error');
					        }
					    });
					}

					if (item.group_baselines) {	
						intialBaseline = item.group_baselines;
						populateBaselineDetails(intialBaseline);
					}
				}
					function populateBaselineDetails(baselineList)
					{					
					    for (var i = 0; i < baselineList.length; i++) {
					        var baseline = presenter.getBaselineDetailsforId(baselineList[i]);
					        if (baseline) {
					            if (baseline.name.match(/^Additional Package/i)) {
					                $(ASSOCHOTFIX).text(baseline.name);
					                $(REMOVEHOTFIX).show();
					                $(HOTFIX).hpSearchCombo('set', { id: baseline.id, name: baseline.name });
					                $(NOBASELINE_WARNING).hide();
					                assocHotFix = baseline;
									if(baseline.baseline_status == "Revalidation in progress.")
									{
										formStateView.setMessage({
										summary: localizer.getString('hpsum.node.groupinvDisableRevalBaseline'),
										status: 'warning',
										changing: false,
										});
									hotfixRevalProgress = true;
									}
					            } else {
					                $(ASSOCBASELINE).text(baseline.name);
					                $(REMOVEBASELINE).show();
					                $(BASELINES).hpSearchCombo('set', { id: baseline.id, name: baseline.name });
					                $(NOBASELINE_WARNING).hide();
					                assocBaseline = baseline;
									if(baseline.baseline_status == "Revalidation in progress.")
									{
										formStateView.setMessage({
										summary: localizer.getString('hpsum.node.groupinvDisableRevalBaseline'),
										status: 'warning',
										changing: false,
										});
									baselineRevalProgress = true;
									}
					            }
					        }
					        else {
					            //installset
					            var installSetDetails = getInstallSetDetailforId(baselineList[i]);
					            if (installSetDetails) {
					                $(ASSOCBASELINE).text(installSetDetails.name);
					                $(REMOVEBASELINE).show();
					                $(BASELINES).hpSearchCombo('set', { id: installSetDetails.id, name: installSetDetails.name });
					                $(NOBASELINE_WARNING).hide();
					                assocBaseline = installSetDetails;
					            }
					        }
					    }
						if(baselineRevalProgress == false && hotfixRevalProgress == false)
						{
							$(OK).attr("disabled", false);
						}
					}
				
				function convertDateTime(date_time)
				{
					date_value = '';
					time_value = '';
					date_time_new = '';
					if(date_time !== "")
					{
						var date_time_split = date_time.split(' ');
						var time_hrs_mins = date_time_split[1].split(':');
						var time_hrs = time_hrs_mins[0];
						date_value = date_time_split[0];
						time_value = '';
						date_time_new = '';
						if((date_time_split[2] == 'PM') && (parseInt(time_hrs) < 12))
						{
							time_hrs = parseInt(time_hrs) + 12;
						}
						else if(date_time_split[2] == 'AM')
						{
							if (parseInt(time_hrs) < 10 && parseInt(time_hrs) < 12)
							{
								time_hrs = '0' + parseInt(time_hrs);
							}
							else if (parseInt(time_hrs) == 12)
							{
								time_hrs = parseInt(time_hrs) - 12;
								time_hrs = '0' + parseInt(time_hrs);
							}
						}
						time_value = time_hrs + ':' + time_hrs_mins[1];
						date_time_new = date_value + ' ' + time_value;
					}
				}
				
			/*	function showScheduleWarning()
				{
					var nodeScheduled=false;
					$('#hpsum-group-schedule-info').hide();
					var tableContents = "<table><thead><tr><th>Node IP</th><th>Schedule DateTime</th></tr></thead>";
						
					for(var idx = 0; idx <allNodesDetials.length; idx++)
					{
						if(allNodesDetials[idx].node_state.match(/scheduled/i))
						{
							nodeScheduled = true;
							convertDateTime(allNodesDetials[idx].schedule_date_time);
							tableContents += "<tr><td>" + allNodesDetials[idx].name + "</td><td>" + date_time_new + "</td></tr>";
						}
					}
					tableContents += "</table>";
					if(nodeScheduled)
					{
						$('#hpsum-group-schedule-info').show();
						$('#hpsum-group-schedule-nodes').html(tableContents);
					}

				}*/

				function onInventoryError(errorMessage) {
					$(OK).attr('disabled', false);
					$(THROBBER).hide();
					$(FAILEDPANEL).show();
					$(FAILEDMSG).text(errorMessage);
					inventoryInProgress = false;
				}

				function onInventorySuccess(item) {
					$(OK).attr('disabled', false);
					$(THROBBER).hide();
					inventoryInProgress = false;
					formStateView.reset();
					$(CANCEL).trigger('click');
				}
				
				function performInventory() {
					inventoryInProgress = true;
				/*	if($(SKIP_STAGED_NODE_CHECKBOX).is(':checked') ){
						groupItem.skip_nodes = 1;	
					}
					else
					{
						groupItem.skip_nodes = 0;	
					}*/
					groupItem.skip_nodes = 0;	
					presenter.startInventory(groupItem, {
						success : onInventorySuccess,
						error : onInventoryError
					});
				}
				
				function onInventory() {
					var fail = false;
					var finalBaseline;
					var finalHotFix;
					var baselineJson = [];
					if (!inventoryInProgress) {
						var errorfound = false;
						if($(BASELINES).val() != ''){
							var baselinedetails = presenter.getBaselineDetailsforId($(BASELINES).val());
							var installSetDetails = getInstallSetDetailforId($(BASELINES).val());
							if(!baselinedetails && !installSetDetails){
								errorfound = true;
								$(BASELINE_INPUT_ERR).text(localizer.getString('hpsum.node.invalidBaseline'));	
								$(BASELINE_INPUT).addClass("hp-error");
								$(BASELINE_INPUT_ERR).show();
							}
						}
						if($(HOTFIX).val() != ''){
							var baselinedetails = presenter.getBaselineDetailsforId($(HOTFIX).val());
							if(!baselinedetails){
								errorfound = true;
								$(HOTFIX_INPUT_ERR).text(localizer.getString('hpsum.node.invalidAdtPackage'));	
								$(HOTFIX_INPUT).addClass("hp-error");
								$(HOTFIX_INPUT_ERR).show();
							}
						}	
						
						if (errorfound == true){
							inventoryInProgress = false;
							return;
						}
						$(OK).attr('disabled', true);
						$(THROBBER).show();
						if ((newBaseline == null) && (assocBaseline == null))
							finalBaseline = null;
						else if (newBaseline == null)
							finalBaseline = assocBaseline;
						else
							finalBaseline = newBaseline;
						if ((newHotFix == null) && (assocHotFix == null))
							finalHotFix = null;
						else if (newHotFix == null)
							finalHotFix = assocHotFix;
						else
							finalHotFix = newHotFix;

						if ((finalHotFix == null) && (finalBaseline == null))
							fail = true;
						else if (finalHotFix == null)
							baselineJson.push(finalBaseline.id);
						else if (finalBaseline == null)
							baselineJson.push(finalHotFix.id);
						else {
							baselineJson.push(finalBaseline.id);
							baselineJson.push(finalHotFix.id);
						}
						if (fail == true) {
							//$(FAILEDPANEL).show();
							//$(FAILEDMSG).text(localizer.getString('hpsum.group.errorPleaseSelectBaseline'));
						} else {
							if (baselineJson[0] == null) {
								baselineJson.splice(0, 1);
							}
							groupItem.baselines = baselineJson;
						}
							
						if (baselineJson.length == 0) {
						    onInventoryError(localizer.getString('hpsum.group.noBaselineNodes'));
                            /*
							var NoBaselinesNodes = [],
							    CanPerformInventory = true;

							$(NOBASELINE_NODES_TABLE).dataTable().fnClearTable();
									
							for (var idx = 0; idx < allNodesDetials.length; idx++) {
								if (allNodesDetials[idx].baselines.length == 0) {
									CanPerformInventory = false;
									$(NOBASELINE_DETAILS).show();
									
									var nodeData = allNodesDetials[idx],
										status = 'unknown',
										change = false,
										nodeStatus = nodeData.node_status,
										rebootRequired = "",
										nodeBaseline = localizer.getString('hpsum.group.noBaseline'),
										adtPackage = localizer.getString('hpsum.group.noAdtPackage'),
										name = "";

									if (nodeData.node_state.match(/inventory|analysis|install$/i) || nodeData.node_phase.match(/initialize/i)) {
										status = 'unknown';
										change = true;
									} else if (nodeData.node_state.match(/error/i) || nodeData.node_phase.match(/initialize|InActive/i)) {
										status = 'error';
									} else if (nodeData.node_state.match(/uan/i)) {
										if (nodeData.node_status.match(/No applicable/i)) {
											status = 'ok';
										} else {
											status = 'warning';
										}
									} else if (nodeData.node_state.match(/installdone/i)) {
										if (nodeData.return_code == -2 || nodeData.return_code == -3) {
											status = 'error';
											nodeStatus = localizer.getString('hpsum.node.installDoneWithErrors');
										} else {
											status = 'ok';
										}

										if (nodeData.return_code == 1) {
											rebootRequired = localizer.getString('hpsum.node.rebootRequired');
										}

									} else if (nodeData.node_state.match(/idle/i)) {
										if (nodeData.node_phase.match(/unknown/i)) {
											status = 'error';
										} else {
											status = 'warning';
										}
									}

									if (nodeData.baselines) {
										for (var i = 0; i < nodeData.baselines.length; i++) {
											var baseline = presenter.getBaselineDetailsforId(nodeData.baselines[i]);
											if (baseline) {
											    if (baseline.name.match(/^Additional Package/i)) {
											        adtPackage = baseline.name;
											    } else {
											        nodeBaseline = baseline.name;
											    }
											}
											else {
											    //installset
											    var installSetDetails = getInstallSetDetailforId(nodeData.baselines[i]);
											    if (installSetDetails) {
											        nodeBaseline = installSetDetails.name;
											    }
											}
										}
									}
									
									name = '<a href="#/node' + '/show/r' + nodeData.node_uri + '/getdata">' + nodeData.name + '</a>';
									
									$(NOBASELINE_NODES_TABLE).dataTable().fnAddData({
										status : status,
										change : change,										
										name : name
									});
								}
							}

							if (!CanPerformInventory) {
								onInventoryError(localizer.getString('hpsum.group.noBaselineNodes'));	
							}
							else {
								performInventory();
							}
                            */
						} else {
							performInventory();
						}
					}
				}

				function changeLocation(location) {
					if (location.length > ROUTE_PREFIX.length) {
						$(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
					} else {
						$(PANELS).hpStackedPanels('setFirstPanel');
					}
				}

				this.resume = function () {
				    $(THROBBER).hide();
					$(NOBASELINE_WARNING).show();
					$(BASELINE_WARNING).hide();
					$(NOBASELINE_NODES_TABLE).dataTable().fnClearTable();
					$(NOBASELINE_DETAILS).hide();
					$(BASELINE_INPUT).removeClass("hp-error");
					$(OK).removeAttr("disabled");
					$(HOTFIX_INPUT).removeClass("hp-error");
					$(HOTFIX_INPUT).hpSearchCombo('enable');
					$(BASELINE_INPUT_ERR).hide();
					$(HOTFIX_INPUT_ERR).hide();
					assocBaseline = null;
					assocHotFix = null;
					hotfixRevalProgress=false;
					baselineRevalProgress=false;
					$(BASELINES).hpSearchCombo('set', {
						id : '',
						name : ''
					});
					$(HOTFIX).hpSearchCombo('set', {
						id : '',
						name : ''
					});
					presenter.on('itemChange', onItemChange);
					presenter.getAllBaselines({
						success : getBaselinesSuccess,
						error : getBaselinesError
					});

					$(PANELS).hpStackedPanels('resume');
					$(FAILEDPANEL).hide();
					formStateView.reset();
					$('#hpsum-group-schedule-info').hide();
				//	$(SKIP_STAGED_NODE_CHECKBOX).attr('checked', false);
				//	populateInventoryNodeTable();
				};

				this.pause = function() {
					presenter.off('itemChange', onItemChange);
					$(PANELS).hpStackedPanels('pause');
				};

				function baselinesAvailable(data) {
				}

				function getBaseline(string, handlers, count, start) {
				  var results = baselines.concat(installSetObjList);
					
					handlers.success({
						count : results.length,
						members : results, 
						start: 0, 
						total: results.length
					});
					if(results.length >= 1)
					{
						$(HEADER).hide();
						$(FOOTER).hide();
					}
					else
					{
						$(BASELINE_INPUT).attr("disabled", true);
						$('#hpsum-group-baselines-search-item').find('.hp-search-combo-menu').hide();
						$(HEADER).hide();
					}
				}

				function getHotfixes(string, handlers, count, start) {
					var results = hotfixes;
					handlers.success({
						count : results.length,
						members : results, 
						start: 0, 
						total: results.length
					});
					if(results.length >= 1)
					{
						
						$(HEADER).hide();
						$(FOOTER).hide();
					}
					else
					{
						$(HOTFIX_INPUT).attr("disabled", true);
						$('#hpsum-group-addpackage-search-item').find('.hp-search-combo-menu').hide();
						$(HEADER).hide();
					}
				}

				function getBaselinesSuccess(searchResults) {
					baselines = $.grep(searchResults, function(option, index) {
						return !(option.name.match(new RegExp('^Additional', 'i')));
					});
					hotfixes = $.grep(searchResults, function(option, index) {
						return (option.name.match(new RegExp('^Additional', 'i')));
					});
					populateBaselineDetails(intialBaseline);

				}

				function getBaselinesError(msg) {

				}
				
				function getInstallSetDetailforId(installSetId)
				{
					if (installSetId == '')
						return null;
					for ( var idx = 0; idx < installSetObjList.length; idx++) {
						if (installSetObjList[idx].id.match(installSetId))
							return installSetObjList[idx];
					}
					return null;
				}

				/* // populate the table containing nodes which will be inventoried 
				function populateInventoryNodeTable()
				{
					
					var nodeScheduled=false;
					$(INVENTORY_NODES_TABLE).html("");
					$(INVENTORY_NODES_TABLE).show();
					var tableContents = "<table><thead><tr><th>Node IP</th><th>Node Status</th></tr></thead>";
					var flag = $(SKIP_STAGED_NODE_CHECKBOX).is(':checked');
					var stgNodeCount = 0;
					var bAnyNodeShown = false;
					
					for(var idx = 0; idx <allNodesDetials.length; idx++)
					{
						if(allNodesDetials[idx].type.match(/Windows|Linux/i))
						{
							if(flag)
							{
								// if check box is checked, don't show UAN state nodes 
								if(allNodesDetials[idx].node_state != "REMOTE_STAGING_UAN")
								{
									tableContents += "<tr><td>" + allNodesDetials[idx].name + "</td><td>" + allNodesDetials[idx].node_status + "</td></tr>";
									bAnyNodeShown = true;
								}
								else
								{
									stgNodeCount ++;
								}
							}
							else
							{
								// if check box is not checked show all Win/Lin nodes irrespective of their states 
								tableContents += "<tr><td>" + allNodesDetials[idx].name + "</td><td>" + allNodesDetials[idx].node_status + "</td></tr>";
								bAnyNodeShown = true;
								if(allNodesDetials[idx].node_state == "REMOTE_STAGING_UAN")
								{
									stgNodeCount ++;
								}
							}
						}
						else
						{
							//if check box is not checked show all other nodes irrespective of their states 
							tableContents += "<tr><td>" + allNodesDetials[idx].name + "</td><td>" + allNodesDetials[idx].node_status + "</td></tr>";
							bAnyNodeShown = true;
						}
					}
					// if any node in the group is staged, enable the checkbox
					// if there are any nodes in the group but none of them are staged, disable the checkbox
					if (stgNodeCount > 0 && stgNodeCount <= allNodesDetials.length)
					{
						$(SKIP_STAGED_NODE_CHECKBOX).attr('disabled', false); // enable the checkbox
					}
					else
					{
						$(SKIP_STAGED_NODE_CHECKBOX).attr('disabled', true);
					}
					
					// Disable Inventory button if all nodes get excluded
					if (true == bAnyNodeShown)
					{
						$(OK).attr('disabled', false); // enable inventory button						
					}
					else
					{
						$(OK).attr('disabled', true);
					}
					
					$(INVENTORY_NODES_TABLE).html(tableContents); //load the table to the div
				} 
				*/
			

				/**
				 * @public
				 */
				this.init = function() {

					$(CANCEL).click(function() {
						router.go(urlFragment.replaceView(router.location(), 'show'));
					});
					$(FAILEDPANEL).hide();
					$(PANELS).hpStackedPanels({
						panelSelector : PANEL_SELECTOR
					});

					formStateView.init({
						form : FORM,
						routePattern : ROUTE_PREFIX + '.*',
						autoTrack : true
					});

					presenter.getAllBaselines({
						success : getBaselinesSuccess,
						error : getBaselinesError
					});

					$(BASELINES).hpSearchCombo({
						getResults : getBaseline
					});
					$(HOTFIX).hpSearchCombo({
						getResults : getHotfixes
					});
					
					$(BASELINES).change(function(ev, value) {
						var item = presenter.getBaselineDetailsforId(value);
						var installSetDetails = getInstallSetDetailforId(value);
						if (item) {
							$(ASSOCBASELINE).text(item.name);
							$(REMOVEBASELINE).show();
							newBaseline = item;
							formStateView.reset();
							if(item.baseline_status == "Revalidation in progress.")
							{
								$(OK).attr("disabled", "disabled");
								formStateView.setMessage({
									summary: localizer.getString('hpsum.node.groupinvDisableRevalBaseline'),
									status: 'warning',
									changing: false,
								});
								baselineRevalProgress = true;
							}
							else
							{
								baselineRevalProgress = false;
								if(hotfixRevalProgress == false)
								{
									$(OK).attr("disabled", false);
									formStateView.reset();
								}
							}
						} else if(installSetDetails)
						{
							$(ASSOCBASELINE).text(installSetDetails.name);
							$(REMOVEBASELINE).show();
							newBaseline = installSetDetails;
						    //check if selected installset is a recovery set, if yes, disable deploy button.
							if (installSetDetails.isRecSet) {
							    //localizer.getString('hpsum.advanceMode.deployDisabledDueRecoverySet')
							    $(OK).attr("disabled", "disabled");
							    formStateView.setMessage({
							        summary: localizer.getString('hpsum.node.invDisabledDueRecoverySet'),
							        status: 'warning',
							        changing: false,
							    });
							}
							else {
							    $(OK).attr("disabled", false);
							    formStateView.reset();
							}
						}
						else{
							if(assocBaseline != null){
								$(ASSOCBASELINE).text(assocBaseline.name);
								$(REMOVEBASELINE).show(); 
							}
							newBaseline = null;
						}

						if (!item && installSetDetails)
						{
						    $(HOTFIX).hpSearchCombo('disable');
						    $(HOTFIX).hpSearchCombo('set', {
						        id: '',
						        name: ''
						    });
						}
						else{
							$(HOTFIX).hpSearchCombo('enable');
						}
						
						$(FAILEDPANEL).hide();
						
						if (value != "") {
							$(NOBASELINE_WARNING).hide();
						}
						
						if (value == "" && $(HOTFIX).val() == "") {
							$(BASELINE_WARNING).hide();
							$(NOBASELINE_WARNING).show();
						} else {
						    if (installSetObjList.length > 0) {
						        $('#hpsum-group-inventory-baseline-warning-label').text(localizer.getString('hpsum.group.baselineWarning', new Array("or a saved iLO Install Set")));
						    }
						    else {
						        $('#hpsum-group-inventory-baseline-warning-label').text(localizer.getString('hpsum.group.baselineWarning', new Array("")));
						    }
							$(BASELINE_WARNING).show();
						}
						
						/*if (value != "") {
							$(NOBASELINE_WARNING).hide();
						} else {
							$(NOBASELINE_WARNING).show();
						}*/
						
						if (value == "") {
							$(ASSOCBASELINE).text('');
							$(REMOVEBASELINE).hide();
							assocBaseline = null;
						}
						if(!setOk){
							$(BASELINE_INPUT_ERR).hide();
							$(BASELINE_INPUT).removeClass('hp-error');
						}
						setOk = false;
					});
					$(HOTFIX).change(function(ev, value) {
						var item = presenter.getBaselineDetailsforId(value);
						if (item) {
							$(ASSOCHOTFIX).text(item.name);
							$(REMOVEHOTFIX).show();
							newHotFix = item;
							if(item.baseline_status == "Revalidation in progress.")
							{
								$(OK).attr("disabled", "disabled");
								formStateView.setMessage({
									summary: localizer.getString('hpsum.node.groupinvDisableRevalBaseline'),
									status: 'warning',
									changing: false,
								});
								hotfixRevalProgress = true;
							}
							else	
							{
								hotfixRevalProgress =false;
								if(baselineRevalProgress == false)
								{
									$(OK).attr("disabled", false);
									formStateView.reset();
								}
							}
						} else {
							if (assocHotFix != null) {
								$(ASSOCHOTFIX).text(assocHotFix.name);
								$(REMOVEHOTFIX).show();
							}
							newHotFix = null;
						}

						$(FAILEDPANEL).hide();
						
						if (value != "") {
							$(NOBASELINE_WARNING).hide();
						}
						
						if (value == "" && $(BASELINES).val() == "") {
							$(BASELINE_WARNING).hide();
							$(NOBASELINE_WARNING).show();
						} else {
						    if (installSetObjList.length > 0) {
						        $('#hpsum-group-inventory-baseline-warning-label').text(localizer.getString('hpsum.group.baselineWarning', new Array("or a saved iLO Install Set")));
						    }
						    else {
						        $('#hpsum-group-inventory-baseline-warning-label').text(localizer.getString('hpsum.group.baselineWarning', new Array("")));
						    }
							$(BASELINE_WARNING).show();	
						}
						
						/*if (value != "") {
							$(NOBASELINE_WARNING).hide();
						} else {
							$(NOBASELINE_WARNING).show();
						}*/
						
						if (value == "") {
							$(ASSOCHOTFIX).text('');
							$(REMOVEHOTFIX).hide();
							assocHotFix = null;
						}
						if(!setOk){
							$(HOTFIX_INPUT_ERR).hide();
							$(HOTFIX_INPUT).removeClass('hp-error');
						}
						setOk = false;
					});
					
					$(BASELINE_INPUT).unbind('keyup').bind('keyup',function(){
						$(BASELINE_INPUT_ERR).hide();
						$(BASELINE_INPUT).removeClass('hp-error');
					});
								
					$(HOTFIX_INPUT).unbind('keyup').bind('keyup',function(){
						$(HOTFIX_INPUT_ERR).hide();
						$(HOTFIX_INPUT).removeClass('hp-error');
					});

					$(OK).on('click', function(ev) {
						setOk = true;
						onInventory();
						ev.preventDefault();
					});

					$(REMOVEBASELINE).on('click', function(ev) {
						assocBaseline = null;
						$(BASELINES).hpSearchCombo('set', {
							id : '',
							name : ''
						});
						$(ASSOCBASELINE).text('');
						$(REMOVEBASELINE).hide();
					});
					
					$(REMOVEHOTFIX).on('click', function(ev) {
						assocHotFix = null;
						$(HOTFIX).hpSearchCombo('set', {
							id : '',
							name : ''
						});
						$(ASSOCHOTFIX).text('');
						$(REMOVEHOTFIX).hide();
					}); 

					/*$(SKIP_STAGED_NODE_CHECKBOX).click( function(){
						populateInventoryNodeTable();
					});*/

					router.watch('group inventory section', ROUTE_PREFIX + '.*', {
						parent : ROUTE_PREFIX,
						change : changeLocation
					});

					$(NOBASELINE_NODES_TABLE).dataTable({
						oLanguage : {
						    sEmptyTable: localizer.getString("hpsum.group.noMoreNodesAvailable"),
						    sSearch: localizer.getString('hpsum.common.search')
						},
						bPaginate : false,
						sScrollY: "450px",
						bFilter : false,
						bInfo : false,
						bAutoWidth : false,
						bRetrieve : true,
						aoColumns : [
						{mDataProp: 'status',
							fnRender: function (oObj) {
								var statusCode;
								if (oObj.aData.change == true )
									statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-changing"></div></div>';
								else if(oObj.aData.status == "ok")
                                    statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>';
                                else if(oObj.aData.status == "error")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>';
                                else if(oObj.aData.status == "warning")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-warning"><span class="hp-value">warning</span></div></div>';
                                else if(oObj.aData.status == "unknown")
                                	statusCode =  '<div class="hp-status"><div class="hp-status-value hp-status-unknown"><span class="hp-value">unknown</span></div></div>';
                                return statusCode;
							},
							sWidth: '10px', sClass: "hp-icon"
						},{
							mDataProp : 'name'
						}/*,{
							mDataProp : 'type'
						}, {
							mDataProp : 'node_status'
						},{
							mDataProp : 'baseline'
						}, {
							mDataProp : 'adtPackage'
						}*/],
						aaSorting : [[1, "asc"]],
						bScrollCollapse : true
					});
					
					this.resume();
				};
			}

			return new GroupInventoryView();
		}());

	return GroupInventoryView;
});

