// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type (GroupView)
 * This is a view class for Groups
 * Provides functions for showing master pane and its action.
 */
define(['hpsum/model/group/GroupResource',
	'hp/view/MasterPaneView',
	'hpsum/presenter/group/GroupPresenter',
	'hp/core/Localizer',
    'jquery',
	'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpUtilizationMeter',
    'hp/lib/jquery.hpSafeClone'],
function(resource, MasterPaneView, presenter, localizer) {"use strict";

	var GroupView = ( function() {

			var TYPE = 'group',
			    PAGE = '#hpsum-groups-page';

			/**
			 * @constructor
			 * @type {GroupView}
			 */
			function GroupView() {

				var masterPaneView = new MasterPaneView();
				var template = null;
				var types = [], types_existing = [];

				function renderer(indexResult) {
					var item = template.hpSafeClone();
					$('.hp-status', item).hpStatus(indexResult.status, indexResult.changing);
					$('.hp-master-item-name', item).html(indexResult.name);
					$('.hpsum-group-description', item).html(localizer.getString('hpsum.group.description') + ': ' + indexResult.description);
					$('.hpsum-group-status', item).html(localizer.getString('hpsum.group.status') + ': ' + indexResult.group_status);
					return item;
				}

				function getItemUrl(oObj) {
					//Note: commented the following line to avoid opening the selected group in new tab/window when user hols ctrl key
					//return '<a href="#/' + TYPE + '/show/r' + oObj.aData.uri + '">' + oObj.aData.name + '</a>';
					return oObj.aData.name;
				}

				/**
				 * @public
				 */
				this.init = function() {
					presenter.init();

					template = $('#hpsum-group-item-template').detach().show().attr('id', '');

					masterPaneView.init({
						routePrefix : '/' + TYPE,
						resource : presenter.resource(),
						page : $(PAGE),
						multiSelect : false,
						addLink : presenter.getAddLink("addGroup"),//Human Factor changes req:HF02
						dataTableOptions : {
							aoColumns : [{
								fnRender : function(oObj) {
									return '<div>' + oObj.aData.status + (oObj.aData.changing ? ' *' : '') + '</div>';
								},
								mDataProp : 'status'
							}, {
								fnRender : getItemUrl,
								mDataProp : 'name'
							}],
							aaSorting : [[1, "asc"]],
							fnRowCallback : function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
								$('td:eq(0) > div', nRow).hpStatus();
								return nRow;
							}
						},
						gridItemRenderer : renderer
					});

				};

				/**
				 * @public
				 * Pause groups view
				 */
				this.pause = function() {
					masterPaneView.pause();
				};

				/**
				 * @public
				 * Resume groups view
				 */
				this.resume = function() {
					masterPaneView.resume();
				};
			}

			return new GroupView();
		}());

	return GroupView;
	});

