// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['hpsum/presenter/host/HostPresenter',
    'hp/view/FormStateView',
    'hp/core/Notifications',
    'jquery'],
function(presenter, FormStateView, notifications) { "use strict";

    var HostAddView = (function() {
      
        var FORM = '#tour-host-add-form';
        var ADD = '#tour-host-add';
        var ADD_AGAIN = '#tour-host-add-again';
        var CANCEL = '#tour-host-add-cancel';
        var NAME = '#tour-host-name';
            
        /**
         * Constructor
         */
        function HostAddView() {
          
            var formStateView = new FormStateView();
            var addInProgress = false;
            var addAgain = false;
          
            function reset() {
                $(NAME).val("");
                $(NAME).focus();
                addInProgress = false;
            }
            
            function onItemAddSuccess(item) {
                notifications.add({
                    summary: localizer.getString('hpsum.common.added'),
                    sourceName: item.name,
                    sourceUri: item.uri,
                    status: 'ok'
                });
                reset();
                addInProgress = false;
            }

            /**
             * @private
             */
            function onItemAddError(errorMessage) {
                notifications.add({summary: errorMessage, status: 'error'});
                addInProgress = false;
            }

            /**
             * @private
             */
            function onAddItem() {
                if(! addInProgress) {
                    addInProgress = true;
                    presenter.addItem({name: $(NAME).val(),
                        category: 'host',
                        uri: '/host/item-' + (new Date()).getTime(),
                        status: 'ok'}, {
                        success : onItemAddSuccess,
                        error : onItemAddError
                    });
                    
                    if (! addAgain) {
                        $(CANCEL).trigger('click');
                    }
                }

                return false;
            }
          
            /**
             * @public
             */
            this.resume = function () {
            };
            
            this.pause = function () {
            };
            
            this.init = function() {
              
                formStateView.init({form: FORM, autoTrack: true});
                
                $(ADD).on('click', function(ev) {
                    addAgain = false;
                    onAddItem.call(this);
                    ev.preventDefault();
                });
                $(ADD_AGAIN).on('click', function(ev) {
                    addAgain = true;
                    onAddItem.call(this);
                    ev.preventDefault();
                });
                
                this.resume();
            };
        }

        return new HostAddView();
    }());
    
    return HostAddView;
});
