/* (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
*/
define(['hp/view/DetailsShowView',
    'hpsum/presenter/ilofederation/iloFederationPresenter',
    'hp/view/DialogView',
    'hp/core/UrlFragment',
    'hp/core/LinkTargetBuilder',
    'hp/view/NotificationsView',
    'hp/core/Localizer',
    'hp/core/HashManager',
    'hp/core/Notifications',
	'text!hpsumpages/group/dialog.html',
	'text!hpsumpages/node/delete_confirm.html',
	'text!hpsumpages/node/abort_confirm.html',
    'jquery',
    'hp/lib/date',
    'hp/lib/jquery.hpDropMenu',
    'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpCollapsible'],
function(DetailsShowView, presenter, DialogView, urlFragment,
    linkTargetBuilder, NotificationsView, localizer, hashManager, notifications,dialogHtml, deleteConfirmHtml, abortConfirmHtml) { "use strict";

	var iloFederationShowView = ( function() {

			//Consts can go here
			var VIEW = '#hpsum-ilofederation-show',
			    SELECTOR = '#hpsum-ilofederation-panel-selector',
			    HEADER = '#hpsum-ilofederation-show .hp-details-header',
			    TITLE = '#hpsum-ilofederation-details-title',
			    STATUS = '#hpsum-ilofederation-details-status',
			    ACTIONS = '#hpsum-ilofederation-actions',
			    ADD_ACTION = '#hpsum-ilofederation-action-add',
			    EDIT_ACTION = '#hpsum-ilofederation-action-edit',
			    INVENTORY_ACTION = '#hpsum-scalableupdate-action-inventory',
			    DEPLOY_ACTION = '#hpsum-ilofederation-action-deploy',
			    ONLINE_DEPLOY_ACTION = '#hpsum-ilofederation-action-onlinedeploy',
			    OFFLINE_DEPLOY_ACTION= '#hpsum-ilofederation-action-offlinedeploy',
			    ABORT_ACTION = '#hpsum-ilofederation-action-abort',
			    ABORT_TITLE = '#hpsum-nodes-abort-title',
       	   		ABORT_ERROR = '#hpsum-abort-err',
			    DELETE_ACTION = '#hpsum-ilofederation-action-delete',
			    DELETE_TITLE = '#hpsum-nodes-delete-title',
			    REPORTS_ACTION = '#hpsum-ilofederation-action-reports';

			/**
			 * Constructor
			 */
			function iloFederationShowView() {

				var detailsShowView = new DetailsShowView(),
				    notificationsView = new NotificationsView(),
				    thisgroup = null,
				    item = null,
				    notificationsCleared = false;
				    
				var date_time_new = '',
					time_value = '',
					date_value = '';
				
				var SUCCESS = 0;
				
				function clearNotifications() {
					if (!notificationsCleared) {
						notificationsCleared = true;
						notificationsView.clear();
					}
				}

				function onItemChange(groupItem) {
					clearNotifications();
					item = groupItem.hapi;
					
					$(DELETE_ACTION).css("color", "#00B388");
					$(REPORTS_ACTION).css("color", "");
					$(OFFLINE_DEPLOY_ACTION).css("color", "");
					$(ONLINE_DEPLOY_ACTION).css("color", "");
					$(ABORT_ACTION).css("color", "");
					$(EDIT_ACTION).css("color", "");
					$(INVENTORY_ACTION).css("color", "");
					
					if (item) {
						thisgroup = item;
						$(HEADER).removeClass('hp-show-changing');
						$(ACTIONS).removeClass('hp-disabled');
						$(TITLE).removeClass('hp-unavailable');
						$(TITLE).text(item.sug_name);
						$(DELETE_ACTION).removeClass('hp-disabled');
					 					   
					   if (item.sug_state.match(/Error/i)) {
							$(STATUS).hpStatus('error', false).removeClass('hp-unavailable');

							notificationsView.add({
								status : 'error',
								details : '',
								summary : item.sug_status,
							});

							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(OFFLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ONLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}
						
						else if (item.sug_state.match(/InActive/i)) {
							$(STATUS).hpStatus('running', true).removeClass('hp-unavailable');
							$(HEADER).addClass('hp-show-changing');

							notificationsView.add({
								status : 'running',
								summary : localizer.getString('hpsum.ilofederation.groupInActiveSummary'),
								details : '', 
							});

							$(ACTIONS).addClass('hp-disabled');

							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(OFFLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ONLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
							
							//This will restore an In-Active group
							//presenter.restore(thisgroup);
						}
						else if(item.sug_state.match(/Not_on_network/i))
						{
							$(STATUS).hpStatus('error', false).removeClass('hp-unavailable');
							var notif = {
								status : 'error',
								summary : localizer.getString('hpsum.ilofederation.notOnNetwork'),
								details : ''
							};
							notificationsView.add(notif);

                            //User can only delete in this state
							//$(EDIT_ACTION).addClass('hp-disabled');
							/* Allow User to Perform edit and Imventory */
							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							//$(INVENTORY_ACTION).addClass('hp-disabled');
							$(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(OFFLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ONLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}
					  	else if (item.sug_state.match(/Initialize/i)) {
							$(STATUS).hpStatus('running', true).removeClass('hp-unavailable');

							notificationsView.add({								
								status : 'running',
								changing : true,
								summary : localizer.getString('hpsum.group.groupScoutingSummary') 
							});
							
							if(item.group_state.match(/IDLE/i))
								showGroupProgress(thisgroup);

							$(EDIT_ACTION).addClass('hp-disabled');
							$(INVENTORY_ACTION).removeClass('hp-disabled');
							$(OFFLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ONLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}
						else if (item.sug_state.match(/IDLE/i) /*&& item.sug_status.match(/UserActionNeeded/i)*/) {
							$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
							var notif = {
								status : 'warning',
								summary : localizer.getString('hpsum.group.readyForInventory') + '. ' + localizer.getString('hpsum.group.inventoryDetails'),
								details : '<a href="#/ilofederation/inventory">' + localizer.getString('hpsum.group.startInventory') + '</a>'
							};
							notificationsView.add(notif);

							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(OFFLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ONLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}

						else if (item.sug_state.match(/INVENTORY/i) || item.sug_state.match(/ADDING_INTERFACE_ILO/i)) {
							$(STATUS).hpStatus('running', true).removeClass('hp-unavailable');
							var notif = {
								status : 'running',
								summary : localizer.getString('hpsum.group.inventoryProgress'),
								changing : true
							};
							notificationsView.add(notif);
							showGroupProgress(thisgroup);
							 $(DELETE_ACTION).addClass('hp-disabled');
							$(EDIT_ACTION).addClass('hp-disabled');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(OFFLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ONLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}
						
						else if(item.sug_state.match(/SCHEDULED/i)){
							$(STATUS).hpStatus('warning',false).removeClass('hp-unavailable');
							var summary = localizer.getString('hpsum.group.scheduleMessage');
							var details = "";
							
							if(item.group_schedule_date_time !== ''){
							if(item.group_schedule_match)
								{
									summary = localizer.getString('hpsum.group.scheduleUnMatchedMessage');
								}
								convertDateTime(item.group_schedule_date_time);
								//summary += " at " + date_time_new;
								details = '<span style="padding:10px;"><a id = "hpsum-group-scheduledelete">' + localizer.getString('hpsum.node.cancelSchedule') + '</a></span>' + 
								  '<span style="padding:10px;"><a id = "hpsum-group-schedule-run">' + localizer.getString('hpsum.node.runNow') + '</a></span>';
						
							}
							var notif = {
								status : 'warning',
								summary : summary,
								details : details,
								changing : false
							};
							
							notificationsView.add(notif);
							
							$('#hpsum-group-schedule-run').unbind('click').bind('click', onRunNow);
							$('#hpsum-group-scheduledelete').unbind('click').bind('click', onDeleteSchedule);
							
							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(OFFLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ONLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}

						else if (item.sug_state.match(/UAN/i)) {
							$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
							var linkToRoute = '<a href="#/ilofederation/onlinedeploy">';
							//check if there are any baseline assigned., if not route it specify baseline page. 
							if(item.baselines.length == 0)
							{
								linkToRoute = '<a href="#/ilofederation/specifybaselineonline">';
							}
							var notif = {
								status : 'warning',
								summary : localizer.getString('hpsum.group.readyForDeploy'),
								details : linkToRoute + localizer.getString('hpsum.group.startDeploy') + '</a>',
								changing : false
							};
							notificationsView.add(notif);
							
							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(OFFLINE_DEPLOY_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(ONLINE_DEPLOY_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).removeClass('hp-disabled').attr('style', '').attr('style', 'color:#00B388;');
						}
						
						else if (item.sug_status.match(/No applicable component found/i)) {
							$(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');
							var notif = {
								status : 'ok',
								summary : localizer.getString('hpsum.group.noApplicableComp'),
								details : '<a href="#/ilofederation/inventory">' + localizer.getString('hpsum.group.startInventoryAgain') + '</a>', 
								changing : false
							};
							notificationsView.add(notif);
							
							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(OFFLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ONLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).removeClass('hp-disabled').attr('style', '').attr('style', 'color:#00B388;');
						}
						
						else if (item.sug_state.match(/ANALYSIS/i)) {
							$(STATUS).hpStatus('running', true).removeClass('hp-unavailable');
							var notif = {
								status : 'running',
								summary : localizer.getString('hpsum.group.analysisProgress'),
								changing : true
							};
							notificationsView.add(notif);
							showGroupProgress(thisgroup);
							$(EDIT_ACTION).addClass('hp-disabled');
							$(DELETE_ACTION).addClass('hp-disabled');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(OFFLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ONLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}
						
						else if (item.sug_state.match(/INSTALLDONE/i)) {
							if(item.return_code < SUCCESS) {							
								$(STATUS).hpStatus('error', false).removeClass('hp-unavailable');
								var notif = {
									status : 'error',
									summary : localizer.getString('hpsum.node.installDoneWithErrors'),
									details : localizer.getString('hpsum.node.installDoneSeeErrors'),
									changing : false
								}; 
							} else {
								$(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');
								var notif = {
									status : 'ok',
									summary : localizer.getString('hpsum.group.deployDone'),
									details : localizer.getString('hpsum.node.installDoneSee'),
									changing : false
								}; 
							}
							notificationsView.add(notif);

							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(INVENTORY_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(OFFLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ONLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).removeClass('hp-disabled').attr('style', '').attr('style', 'color:#00B388;');
						}
						
						else if (item.sug_state.match(/INSTALL$/i)) {
							$(STATUS).hpStatus('running', true).removeClass('hp-unavailable');
							var notif = {
								status : 'running',
								summary : item.sug_status,
								changing : true
							};
							notificationsView.add(notif);
							showGroupProgress(thisgroup);
							 $(DELETE_ACTION).addClass('hp-disabled');
							$(EDIT_ACTION).addClass('hp-disabled');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(OFFLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ONLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}

						else if (item.sug_state.match(/INSTALLHOLD/i)) {
							$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');

							notificationsView.add({
								status : 'warning',
								summary : localizer.getString('hpsum.group.deployHoldSummary'),
								changing : false
							});
							notificationsView.add(notif);
							
							$(EDIT_ACTION).removeClass('hp-disabled').attr('style', 'color:#00B388;');
							$(INVENTORY_ACTION).addClass('hp-disabled');
							$(OFFLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ONLINE_DEPLOY_ACTION).addClass('hp-disabled');
							$(ABORT_ACTION).addClass('hp-disabled');
							$(REPORTS_ACTION).addClass('hp-disabled');
						}
						
						$(".hp-disabled").css("color", "grey");
						
					} else {
						$(TITLE).text('');
						$(STATUS).hpStatus('unknown');
						$(STATUS + ' span').text('');
					}
				}
				
				function showGroupProgress(groupItem) {
					var timer = setInterval(function() {
						presenter.getSUGStatus(item, {
							success : function(data) {
								if (data.hapi.hcode == 0) {
									var notif = {
					        				  	status: 'info',
					                            summary: data.hapi.sug_status,
					                            // timestamp: (new Date().toISOString()),
					                            changing: true,
					                            details: ''// Add in translation
					        			};
					        			
									if (data.hapi.sug_state.match(/Not_on_network|uan|error|idle|installdone|installhold|scheduled/i)) {
										notificationsView.remove(notif);
										presenter.refreshIndexResults();
										clearInterval(timer);
									}
									else
									{
										//update notification
										notificationsView.add(notif);
									}
								} else {
									clearInterval(timer);
								}
							},
							error : function(data) {
								clearInterval(timer);
							}
						});
					}, 3000);
				}

				function onItemError(errorMessage) {
				}

				function onSelectionChange(selection) {
					notificationsCleared = false;
					clearNotifications();
					urlFragment.replaceHrefUris(HEADER, selection.uris, selection.multiSelectId);
					if ($(HEADER).hasClass('hp-show-init')) {
						$(HEADER).removeClass('hp-show-init');
					} else {
						$(HEADER).addClass('hp-show-changing');
						$(ACTIONS).addClass('hp-disabled');
					}
				}
				
				function onItemDeleteSuccess(data) {
					
            	}
            	
            	function onItemDeleteError(errorMessage) {
            		notifications.show(errorMessage, 'error');
            	}
	
				function showDeleteInfoDialog() {
										
					var contents = $(deleteConfirmHtml);
					$('#hpsum-delete-node',contents).html(localizer.getString('hpsum.ilofederation.deleteConfirm'));
					$('#hpsum-node-delete-ok',contents).html(localizer.getString('hpsum.baseline.show.yesDelete'));
					$('#hpsum-node-delete-cancel',contents).show();

					localizer.localizeDom(contents);
				
					var dialogView = new DialogView();
                    dialogView.init({contents: contents,
                        ok: function () {
                                presenter.deleteItem(thisgroup, {
									success : function(data) {
										onItemDeleteSuccess(data);
									},
									error : function(message) {
										onItemDeleteError(message);
									}
								});
                        },
                        cancel: function () {
                        }
                    });
                
                	$(DELETE_TITLE, contents).text(
									localizer.getString('hpsum.common.deleteArg',
									[thisgroup.sug_name]));
				}

				function onDeleteItem() {
					showDeleteInfoDialog();
				}

				function onItemAbortedSuccess(data) {
					notifications.show(localizer.getString('hpsum.ilofederation.abortedGroup') + ' ' + thisgroup.sug_name, 'ok');
				}

				function onItemAbortedError(errorMessage) {
					notifications.show(errorMessage, 'error');
				}

				function showAbortInfoDialog() {
										
					var contents = $(abortConfirmHtml);
                   	localizer.localizeDom(contents);
                        
                    $(ABORT_ERROR, contents).hide();
                    var dialogView = new DialogView();
                    dialogView.init({contents: contents,
                        ok: function () {
                            presenter.abortAction(thisgroup, {
								success : function(data) {
									onItemAbortedSuccess(data);
								},
								error : function(message) {
									onItemAbortedError(message);
								}
							});
                        },
                        cancel: function () {
                        }
                    });
                    $(ABORT_TITLE, contents).text(localizer.getString('hpsum.node.abortFor', [thisgroup.sug_name]));
				}

				function onAbortItem() {
					showAbortInfoDialog();
				}
				
				function onRunNow(ev) {
					var schedule_information;
					var scheduled;
					var	action = 'deploynow';
							 
					presenter.ScheduleNodes(thisgroup,action,scheduled,schedule_information, {
						success : function(data) {
							onRunNowSuccess(data); 
						},
						error : function(errorInfo) {
							onRunNowError(errorInfo);
						}
					});	
				}
				
				function onRunNowSuccess()
				{
					showGroupProgress(thisgroup);
				}
				function onRunNowError()
				{
				
				}
				function onDeleteSchedule(ev) {
					var contents = $(dialogHtml);
					$('#hpsum-groups-warning-title',contents).html('Delete');
					$('#hpsum-groups-message',contents).html(localizer.getString('hpsum.group.deleteschedule'));
					$('#hpsum-groups-schedule-info',contents).hide();
					$('#hpsum-groups-schedule-options',contents).hide();
					$('#hpsum-groups-confirm',contents).hide();
					$('#hpsum-node-delete-cancel',contents).show();
					
					localizer.localizeDom(contents);
					new DialogView({contents: contents,
						ok: function () {
							btnScheduleDelete();
						},
						cancel: function () {
							hashManager.replaceHash('/ilofederation/show/overview');
						}
					});
				}
				
				function btnScheduleDelete()
				{
					var scheduled;
					var schedule_information;
					var action = 'delete';
						 
					presenter.ScheduleNodes(thisgroup,action,scheduled,schedule_information, {
						success : function(data) {
							onDeleteScheduleSuccess(data); 
						},
						error : function(errorInfo) {
							onDeleteScheduleError(errorInfo);
						}
					});	
				}
				
				function onDeleteScheduleSuccess()
				{
					var	message = "Schedule for " + thisgroup.sug_name + " group deleted successfully";
					notifications.show(message, 'ok');  

					showGroupProgress(thisgroup);
				}
				function onDeleteScheduleError()
				{
				
				}
				
				function convertDateTime(date_time)
				{
					if(date_time !== "")
					{
						var date_time_split = date_time.split(' ');
						var time_hrs_mins = date_time_split[1].split(':');
						var time_hrs = time_hrs_mins[0];
						date_value = date_time_split[0];
						time_value = '';
						date_time_new = '';
						if((date_time_split[2] == 'PM') && (parseInt(time_hrs) < 12))
						{
							time_hrs = parseInt(time_hrs) + 12;
						}
						else if(date_time_split[2] == 'AM')
						{
							if (parseInt(time_hrs) < 10 && parseInt(time_hrs) < 12)
							{
								time_hrs = '0' + parseInt(time_hrs);
							}
							else if (parseInt(time_hrs) == 12)
							{
								time_hrs = parseInt(time_hrs) - 12;
								time_hrs = '0' + parseInt(time_hrs);
							}
						}
						time_value = time_hrs + ':' + time_hrs_mins[1];
						date_time_new = date_value + ' ' + time_value;
					}
				}

				/**
				 * @public
				 * Initialize Group Show View
				 */
				this.init = function() {
					detailsShowView.init($(SELECTOR));
					notificationsView.init($(VIEW));
					$(ACTIONS).hpDropMenu();
					$(ABORT_ACTION).bind('click', function(ev) {
						if($(ABORT_ACTION).hasClass("hp-disabled")) 
						{
							ev.preventDefault();
							return;
						}
						else
						{
							onAbortItem.call(this);
							ev.preventDefault(); 
						}
					});
					$(DELETE_ACTION).bind('click', function(ev) {
						if($(DELETE_ACTION).hasClass("hp-disabled")) 
						{
							ev.preventDefault();
							return;
						}
						else
						{
							onDeleteItem.call(this);
							ev.preventDefault(); 
						}
					}); 

					

					this.resume();
				};

				/**
				 * @public
				 * Resume Group Show View
				 */
				this.resume = function() {
					notificationsCleared = false;
					presenter.on("selectionChange", onSelectionChange);
					presenter.on("itemChange", onItemChange);
					presenter.on("itemError", onItemError);
					if (notificationsView.resume) {
						notificationsView.resume();
					}

				};

				/**
				 * @public
				 * Pause Group Show View
				 */
				this.pause = function() {
					presenter.off("selectionChange", onSelectionChange);
					presenter.off("itemChange", onItemChange);
					presenter.off("itemError", onItemError);
					$('#hpsum-group-schedule-run').unbind('click').bind('click', onRunNow);
					$('#hpsum-group-scheduledelete').unbind('click').bind('click', onDeleteSchedule);
					if (notificationsView.pause) {
						notificationsView.pause();
					}
				};
			}

			return new iloFederationShowView();
		}());

	return iloFederationShowView;

});
