// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type (ActivatePendingView)
 * This is a view class for Integrity iLO activte pending firmware options.
 */
define(['hpsum/presenter/node/NodePresenter',
	'hp/core/Notifications',
	'hp/core/Localizer',
    'jquery'],
function(presenter, notifications, localizer) { "use strict";

    var ActivatePendingView = (function() { 
    	
    	var OKBUTTON = '#integrityilo-activatepending-ok',
    		CANCELBUTTON = '#integrityilo-activatepending-cancel',
    		ACTIVATECHKBOX = '#activate-pending-chkbox',
    		CANCELCHKBOX = '#cancel-pending-chkbox',
    		NOTIFICATION = '#activatepending-notification';   

        /**
         * Constructor
         */
        function ActivatePendingView() {
        	
        	var nodeItem = null;
        	
        	var activateoption = { 
				hapi: {
					action:''
            	}
           };
           
			function onItemChange(item) {
				nodeItem = item.hapi;
			}
			
			function onActivateSuccess() {
				$(CANCELBUTTON).trigger('click');
			}
			
			function onActivateError(errorMessage) {
				notifications.show(errorMessage, 'error');
				$(OKBUTTON).attr('disabled','disabled');
				$(CANCELBUTTON).trigger('click');
			}

			this.resume = function () {
				presenter.on("itemChange", onItemChange);
            };
            
            this.pause = function() {
            	presenter.off("itemChange", onItemChange);
            };
          
            /**
             * @public
             * Initialization funtion for the object
             * All the controls actions are initialized in this function.
             */
            this.init = function() {
            	
            	$(ACTIVATECHKBOX).on('click', function(){
            		activateoption.hapi.action = 'activate';
            		$(CANCELCHKBOX).removeAttr('checked');
            		if($(ACTIVATECHKBOX).is(':checked')) {
            			$(NOTIFICATION).text(localizer.getString('hpsum.integrityilo.activatependingWarning'));
            		} else {
            			$(NOTIFICATION).text(localizer.getString('hpsum.integrityilo.pendingwarning'));
            		}
            	});
            	
            	$(CANCELCHKBOX).on('click', function(){
            		activateoption.hapi.action = 'cancel';
            		$(ACTIVATECHKBOX).removeAttr('checked');
            		if($(CANCELCHKBOX).is(':checked')) {
            			$(NOTIFICATION).text(localizer.getString('hpsum.integrityilo.cancelpendingWarning'));
            		} else {
            			$(NOTIFICATION).text(localizer.getString('hpsum.integrityilo.pendingwarning'));
            		}
            	});
                			
                $(OKBUTTON).on('click', function(){
                	presenter.activate(nodeItem, activateoption, {
                        success : onActivateSuccess,
                        error : onActivateError
                    });
                });
                
                this.resume();
                					
            };
        }

        return ActivatePendingView;
    }());
    
    return new ActivatePendingView();
});