//OM
//Srikanth Bemineni
define([ 'hpsum/presenter/node/NodePresenter',
         'hp/services/REST',
         'hp/core/Localizer',
         'hp/model/Session',
         'hp/core/Router',
         'hp/core/UrlFragment',
         'jquery',
         'hpsum/view/node/jquery.hpsumInstallResults',
         'hp/lib/jquery.hpGridPanels'
        ],
        function( presenter, rest , localizer , session , router , urlfragmentor ){ "use strict";

        //IIFE
        var NodeDeployResults = (function() {

            var CLOSE = '#hpsum-node-install-results-close';
            var INSTALL_RESULTS = '#hpsum-node-install-results';
            var PANELS = '#hpsum-node-install-results-panel';
            var LOG_DETAILS = '#log-details';
            var NODE_TITLE = '#hpsum-node-details-title';
            var COMPONENT_ID = '#hpsum-component-id';
            var LIVE_LOG_TIMER = 15000;
            var timer = null;
            var LIVE_LOG_PANEL = '#hpsum-node-live-log-results-panel';

            function NodeDeployResults()
            {

                var node_id;
                function onItemChange(data)
                {
                    var item = data.hapi; 

                    //Getting multiple change request.                    
                    if(node_id === item.node_id)
                        return;
                    if (item.node_state.match(/Install|INSTALLFROMILOTASKQUEUE|INSTALLFROMRECOVERYSET$/i)) {
                       timer = setTimeout(getUpdateList,LIVE_LOG_TIMER);
                       $(LIVE_LOG_PANEL).show();
                    }else{
                        $('#hpsum-component-installation-notes').text('');
                        $(LIVE_LOG_PANEL).hide();
                    }
					
                    node_id = item.node_id;

                    $(INSTALL_RESULTS).hpsumInstallResults("setNodeId",item.node_id);
    		        $(INSTALL_RESULTS).hpsumInstallResults("clearSearch");
                    $(INSTALL_RESULTS).hpsumInstallResults("populateTable");
                    $(NODE_TITLE).text(item.name);

                }

                function showLoginTextArea(data)
                {
					if(data.hapi.hcode==0){
					var component = data.hapi.components.component[0];
					if(component.hasOwnProperty('component_log') && component.component_log.length > 0) {
                        var component_log_filterHttp = (component.component_log).replace(/^.*http:.*$/mg,"");
						$(LOG_DETAILS).val(component_log_filterHttp);
									
                    } else {
                        $(LOG_DETAILS).val(localizer.getString("hpsum.node.noInstallationLogs"));
                    }
					$(COMPONENT_ID).text(component.component_id.toUpperCase());
                    }
					else
						$(LOG_DETAILS).val(localizer.getString("hpsum.node.errorInstallationLogs"));
                    
                }

                function showLogError(data)
                {
                    //For now dumping the http error log
                        $(LOG_DETAILS).val('ERROR: Unable to retrieve installation logs at this time.');
                    
                }

                this.pause = function(){
                    //For now nothing to pause
                    presenter.off('itemChange', onItemChange);                    
                    node_id = "";
                    $(LOG_DETAILS).val("");
                    $(COMPONENT_ID).text('')
                    clearTimeout(timer);
                    timer = null;
                };

                this.resume = function(){
                    //For now nothing to resume
                    $(INSTALL_RESULTS).hpsumInstallResults("init");
                    $(INSTALL_RESULTS).hpsumInstallResults('viewLogHandler', { success:function(data){ 
                                                                                        showLoginTextArea(data); 
                                                                                    },
                                                                                error:function(data){ 
                                                                                        showLogError(data); 
                                                                                    } 
                                                                             } );
                    presenter.on('itemChange', onItemChange);                    
                    $(PANELS).hpGridPanels('reset');                    
                };

                function getUpdateList(){
                    $(INSTALL_RESULTS).hpsumInstallResults("clearSearch");
                    $(INSTALL_RESULTS).hpsumInstallResults("populateTable");
                    $(PANELS).hpGridPanels();
                    if(timer){
                       timer = setTimeout(getUpdateList,LIVE_LOG_TIMER);
                    }else{
                       clearTimeout(timer);
                       timer = null;
                    }
                }
               
                function stopTimer(){                                      
                    clearTimeout(timer);
                    timer = null;
                }

                this.init = function(){

                    
                    $(CLOSE).click(function () {
                        router.go(urlfragmentor.replaceView(router.location(), 'show'));
                        clearTimeout(timer);
                        timer = null;
                    });
                    
                    $(INSTALL_RESULTS).hpsumInstallResults();
                    $(INSTALL_RESULTS).hpsumInstallResults('stopLogTimer',stopTimer);
                    $(INSTALL_RESULTS).hpsumInstallResults('viewLogHandler', { success:function(data){ 
                                                                                        showLoginTextArea(data); 
                                                                                    },
                                                                                error:function(data){ 
                                                                                        showLogError(data); 
                                                                                    } 
                                                                             } );
                    $(PANELS).hpGridPanels();
                    presenter.on('itemChange', onItemChange);

                    //We will get the current selected item from the presenter.


                };
            }

            return new NodeDeployResults();
        })();

        return NodeDeployResults;
});