// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type (NodeDeployView)
 * This is a view class for Custom Baseline Add menu option.
 */
define(['hpsum/presenter/node/NodePresenter',
	'hp/core/Router',
	'hp/core/UrlFragment',
    'hp/core/Notifications',
	'hp/core/HelpMenu',
	'hp/view/DialogView',
	 'hp/services/REST',
	'hp/core/Localizer',
	 'hp/model/Session',
	'text!hpPages/core/header_help.html',
	'hp/view/FormStateView',
    'jquery',
    'hp/lib/jquery.hpDonut',
    'hpsum/view/node/jquery.hpsumInstallables',	
    'hpsum/view/node/jquery.hpsumWarnings',	
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'lib/jquery.dataTables.rowReordering',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpToggle',	
	'lib/jquery-ui-timepicker-addon',
	'hp/lib/jquery.hpSearchCombo',
	'hpsum/view/node/jquery.hpsumSchedule',
    'hpsum/view/node/jquery.hpsumAddiLOTaskDetails',
    'hpsum/view/node/jquery.hpsumInstallSetComponents',
    'hpsum/view/node/jquery.hpsumInstallSets'],

function(presenter, router,urlFragment, notifications,helpMenu, DialogView, rest,localizer,session,headerHelpHtml, FormStateView) { "use strict";

    var NodeDeployView = (function() {
      
        var DEPLOY = '#hpsum-node-deploy-ok',
            ASSOC_ANALYSIS = '#hpsum-assoc-node-deploy-analysis',
            CANCEL = '#hpsum-nodes-deploy-close',
            PANEL_SELECTOR = '#hpsum-deploy-panel-selector',
            PANELS = '#hpsum-node-deploy-panels',
            DESCR = '#hpsum-node-deploy-descr',
            REBOOTOPTION = '#hpsum-reboot-option',
            COMPVERBOSEOPTION = '#hpsum-comp-verbose-checkbox',
            DELAYMINUTES = '#hpsum-node-delay-seconds',
            DELAYSECERR = '#hpsum-node-delay-seconds-err-msg',
            DELAYMSG = '#hpsum-node-reboot-message',
            TYPE = '#hpsum-node-deploy-type',
            //GROUP = '#hpsum-node-deploy-group',			
            ROUTE_PREFIX = '/node/deploy',
            NONECHECKBOX = '.nonecheckbox',
            USESNMPCHECKBOX = '.useSNMPcheckbox',
            USEAGENTLESSCHECKBOX = '.useAgentlesscheckbox',
            USEWEBEMCHECKBOX = '.useWEBEMcheckbox',
            INSTALLATIONOPTION = '#hpsum-installation-option',
            DEPLOYENCCHKBOXCOMP = '.enclosurechkbox',
            ACTIVATE_SELECTION = '#hpsum-activate-selection',
            NO_REBOOT_REQ = '#hpsum-no-reboot-required',
            FORM = '#hpsum-node-deploy-add-form',
            ASSOC_NODES = '#all-assocnodes',
            ASSOC_NODE_DIALOG = '#hpsum-assoc-node-dialog',
            ASSOC_NODE_COMP = '#hpsum-assoc-node-components',
            ASSOC_OPTIONS = '#assoc-options',
            ASSOC_NODE_ANALYSIS = "#hpsum-assoc-node-deploy-analysis",
            SPLASH_DIALOG = '#hpsum-splash-dialog',
            VC_ENCRYPTION_SETTINGS = '#hpsum-node-deploy-vc-encryption-collapsible',
            SPLASH_SPINNER = '#hpsum-splash-spinner',
            SCHEDULETOGGLE = '#hpsum-node-schedule-enable',
            SCHEDULE_DATE = '#hpsum-node-schedule-date',
            SCHEDULE_TIME = '#hpsum-node-schedule-time',
            SCHEDULE_TIME_LABEL = '#hpsum-node-schedule-time-label',
            SCHEDULE_ERROR = '#hpsum-node-schedule-error',
            CURRENT_DATETIME = '#hpsum-node-current-datetime',
            TIME_ZONE = '#hpsum-node-timezone',
            INSTALL_ERROR = '#force-options-tbody-err',
            DATETIMESECTION = '#hpsum-node-schedule-datetimepick',
            REBOOT_DISABLE = '.hpsum-otu-node-deploy-disable',
            TAB_INSTALLATION_OPTION_CONTAINER = '#li-show-installation-details',
            TAB_INSTALLATION_OPTIONS = '#show-installation-details',
            INSTALLATION_OPTIONS = '#hpsum-show-installation',
            INSTALLATION_FORCE_OPTIONS = '#hpsum-force-options-collapsible',
            TAB_SCHEDULE_OPTION_CONTAINER = '#li-show-schedule-details',
            TAB_SCHEDULE_OPTIONS = '#show-schedule-details',
            SCHEDULE_OPTIONS = '#hpsum-show-schedule',
            TAB_REBOOT_OPTION_CONTAINER = '#li-show-reboot-details',
            TAB_REBOOT_OPTION = '#show-reboot-details',
            REBOOT_OPTIONS = '#hpsum-show-reboot',
            TAB_ILO_MANAGEMENT_OPTION_CONTAINER = "#li-show-ilo-management-details",
            TAB_ILO_MANAGEMENT_OPTION = "#show-ilo-management-details",
            ILO_MANAGEMENT_OPTION = "#hpsum-show-ilo-management",
            ILO_MANAGEMENT_DRIVE_OPTION = '#hpsum-show-ilo-management-drive-options',
            TAB_VC_INSTALLATION_OPTION_CONTAINER = '#li-show-vc-encryption-Options-details',
            TAB_VC_INSTALLATION_OPTIONS = '#show-vc-encryption-Options-details', 
            VC_INSTALLATION_OPTIONS = '#hpsum-show-vc-encryption-Options',
            TAB_VC_ACTIVATION_OPTIONS_CONTAINER = '#li-show-vcactivation-installation-options-details',
            TAB_VC_ACTIVATION_OPTIONS = '#show-vcactivation-installation-options-details', 
            VC_ACTIVATION_OPTIONS = '#hpsum-show-vcactivation-installation-options',
			TAB_SDFLEX_INSTALLATION_OPTIONS_CONTAINER = '#li-show-sdflex-installation-options-details',
            TAB_SDFLEX_INSTALLATION_OPTIONS = '#show-sdflex-installation-options-details', 
			SDFLEX_INSTALLATION_OPTIONS = '#hpsum-show-sdflex-installation-options',
			SDFLEX_INSTALLATION_OPTION_EXCLUDENPAR = '#hpsum-sdflex-excludenparfw-checkbox',
			TAB_SDFLEX_REBOOT_OPTIONS_CONTAINER = '#li-show-sdflex-reboot-options-details',
            TAB_SDFLEX_REBOOT_OPTIONS = '#show-sdflex-reboot-options-details', 
			SDFLEX_REBOOT_OPTIONS = '#hpsum-show-sdflex-reboot-options',
			SDFLEX_REBOOT_OPTION = '#hpsum-sdflex-reboot-option',
			SDFLEX_NO_REBOOT_REQUIRED = '#hpsum-sdflex-no-reboot-required',

            TAB_INTEGRITY_REBOOT_TO_ACTVATE_CONTAINER = '#li-show-integrity-reboot-to-activate',
            TAB_INTEGRITY_REBOOT_TO_ACTVATE = '#show-integrity-reboot-to-activate',
            INTEGRITY_REBOOT_TO_ACTVATE = '#hpsum-integrity-reboot-to-activate',
            BASELINE_ASSOCIATED_NODE_TAB_CONTAINER = '#expert-mode-baseline-assocnodes',
            TAB_SHOW_BASELINE_DETAILS = '#show-baseline-details',
            TAB_ASSOCIATED_NODE_DETAILS = '#show-associated-node-details',
            DEPLOY_NODE_PLUGIN = '#hpsumDeployNode-plugin-container',
            ADV_MODE_DETAILS_TABS = '#adv-mode-details-tabs',
            ADV_MODE_INST_OPTIONS = '#Install-options-expert-mode',
            REBOOT_DELAY_SEC = '60',
            VC_ENCRYPTION_KEY = '#hpsum-node-vc-encryption-key',
            HPSUM_ENET_ORDER = '#hpsum-Enet-order',
            HPSUM_ENET_DELAY = '#hpsum-Enet-delay',
            HPSUM_FC_ORDER = '#hpsum-fc-order',
            HPSUM_FC_DELAY = '#hpsum-FC-delay',
            SCHEDULE_NODE_DEPLOY = '#hpsum-deploy-schedule-options',
            SPLASH_DIALOG_TEMP_ABORT = '#hpsum-splash-dialog-tempabort',
            SPLASH_SPINNER_TEMP_ABORT = '#hpsum-splash-spinne-tempabort',
            COMPONENT_VERBOSE_DESCR = '#hpsum-comp-verbose-descr',
            BASELINE_OVERVIEW_SIZE_AP = '#hpsum-baseline-overview-version-size_ap',
            BASELINE_OVERVIEW_SIZE_BL = '#hpsum-baseline-overview-version-size_bl',
            ILO_INSTALLSET_COMP_CONTAINER = '#li-ilo-saved-installset-components',
            ILO_TASKQUEUE_COMP_CONTAINER = '#li-ilo-taskqueue-components',
            ILO_INSTALLSET_COMPONENTS = '#ilo-saved-installset-components',
            ILO_TASKQUEUE_COMPONENTS = '#ilo-taskqueue-components',
            ILO_INSTALLSET_COMP_TITLE  = '#ilo-saved-installset-components-title', 
            ILO_TASKQUEUE_COMP_TITLE = '#ilo-taskqueue-components-title',
            FIPS_MODE_ON = "Node already at baseline version. FIPS mode is ON. Downgrade/Re-write of OA firmware is not allowed",
			DOWNGRADE_REWRITE_TEXT='#hpsum-downgrade-rewrite-text',
			CLEANUP_ONEXIT_OPTIONS_LABEL='#hpsum-node-cleanuponexit-descr',
			DELETE_INSTALLSET_OPTION_DESCR='#hpsum-choose-delete-install-sets-option-descr',
			MAX_LENGTH = 63;
        var tempAbortInProgress = false;
        var isBaselineSelected = false, isRegularBlSelectedForDeploy = false;
        var scheduleDetails = {
            isScheduled: false,
            tempAbort: false,
            stageMode: "",
            schduledDateTime: "",
            baselines: ""
        };
        var scheduleDetailsIsSet = false;
        var bHasUserPressedDeploy = false;
        var gradient = 0;
        var ILO_MGMT_OPTIONS_INSTALLSET_PLUGIN_PANEL = "#hpsum-installsets-plugin-panel",
            BASELINE_DETAILS_CONTAINER = '#hpsum-node-deploy-baseline-details',
        CRITICALITY_DETAILS_CONTAINER = '#hpsum-node-deploy-criticality-widget',
        eachBaselineDetailsContainer = '#baseline-details-container',
        estimatedTimeTitle = '#estimatedDeployTime',
        compCriticalityDetails = {},
        compDepTimeDetails = {},
        BLCompReqDiskSpace = {},
        APCompReqDiskSpace = {},
        baselineInfo = [],
        deploymentTime = 0,
        requiredDiskSpace = 0,
        selectedComponents = [],
        donutCriticalUpdates = 0,
        donutRecoUpdates = 0,
        donutOptUpdates = 0,
        donutNonCateUpdates = 0,
        optApplicable = 0,
    recoApplicable = 0,
    critApplicable = 0,
    critInstallNeeded = 0,
    recoInstallNeeded = 0,
    optInstallNeeded = 0,
    unknownApplicable = 0,
    unknownInstallNeeded = 0,
        totalApplicableComponents = 0;
        var nodeItem = "";
        var nodeName = "";
        var nodeType = "";
        var isConfigPasswordRequired = false;
        var isFIPSEnabled = false;
        var failedDepCount = 0;
        //direct deploy related code.
        var baselines = '',
       hotfixes = '',
       assocBaseline = null,
       newBaseline = null,
       newHotFix = null,
       assocHotFix = null,
           inventoryInProgress = false;
        var searchResults = [];
        var REMOVE_GRP_CHECKBOX = '#hpsum-remove-group-checkbox',
        REMOVE_GRP_CHECKBOX_LABEL = '#hpsum-remove-group-checkbox-descr',
        REMOVE_NODE_FROM_GROUP = "#hpsum-remove-group-descr",
        REMOVE_GRP_CONTAINER = '#hpsum-remove-grp-div';
        var allInstallSets = [], currentGroup = '';
        var allPendingTaskQueueItems = [];
        var hasPendingTaskQueueItems = false;
        var DIRECT_DEPLOY_BASELINE_SELECTOR = '#hpsum-node-baseline-selection-details',
            FAILEDPANEL = '#hpsum-node-inventory-failed',
            BASELINES = '#hpsum-node-baselines-search',
            HOTFIX = '#hpsum-node-addpackage-search',
            BASELINE_INPUT = '#hpsum-node-baselines-search-input',
            HOTFIX_INPUT = '#hpsum-node-addpackage-search-input',
            BASELINE_INPUT_ERR = '#hpsum-node-baselines-search-input-err',
            HOTFIX_INPUT_ERR = '#hpsum-node-addpackage-search-input-err',
            SAVE_INSTALL_SET_CHECBOX = '#hpsum-save-install-sets-checkbox',
			SAVE_INSTALL_SET_ROLLBACK='#hpsum-save-install-set-iLO-rollback',
			SAVE_INSTALL_SET_DESC='#hpsum-save-install-sets-descr',
			iLO_AVAILABLE_SPACE='#hpsum-available-ilo-space-descr',
			LI_SAVE_INSTALSSET_DETAILS='#li-save-installset-details-inputs',
			UPDATE_RECOVERY_SET_DETAILS = '#hpsum-update-recovery-set-details',
			UPDATE_RECOVERY_SET_CHECKBOX = '#hpsum-update-recovery-set-checkbox',
			UPDATE_RECOVERY_SET_DESCR = '#hpsum-update-recovery-set-descr',
			UPDATE_RECOVERY_ILO_CRDENTIALS_DETAILS = '#hpsum-ilo-credentials-for-recovery-details',
			UPDATE_RECOVERY_ILO_USERNAME = '#hpsum-recovery-ilo-username',
			UPDATE_RECOVERY_ILO_USERNAME_ERR = '#hpsum-recovery-ilo-username-err',
			UPDATE_RECOVERY_ILO_PASSWORD = '#hpsum-recovery-ilo-password',
			UPDATE_RECOVERY_ILO_PASSWORD_ERR = '#hpsum-recovery-ilo-password-err';
        var INSTALLSET_SUM_COMPS = "#hpsum-installset-sumcomps";
        var INSTALLSET_UEFI_COMPS = "#hpsum-installset-ueficomps";
        var INSTALLSET_ILO_COMPS = "#hpsum-installset-ilocomps";
        var INSTALLSET_COMP_TOTAL = "#hpsum-installset-ComponentsTotal";
        var INSTALLSET_SIZE = "#hpsum-installset-size";
        var INSTALLSET_NAME = "#hpsum-installset-name";
        var skipdependency = 'OMITHOST';
        var SKIP_DEPENDENCY_CONTAINER = '#li-hpsum-staged-deploy-failedDep';
        var SKIP_DEPENDENCY_CHECKBOX = '#hpsum-staged_failedDepCheckbox';
        var IGNORE_WARNING_CHECKBOX_PANEL = '#li-hpsum-direct-deploy-ignoreWarnings';
        var IGNORE_WARNING_CHECKBOX = '#hpsum-deploy-ignoreWarnings-checkbox';
        var CLEANUP_ONEXIT = '#hpsum-node-cleanuponexitCheckbox';
        var CLEANUP_ALLONEXIT = '#hpsum-node-cleanupallonexitCheckbox';
        var INSATLLSET_NAME_REQUIRED = '#hpsum-save-install-set-text-required';
        var INSTALLSET_DESC_REQUIRED = '#hpsum-save-install-set-descr-required';
        var INSTALL_SET_NAME_TEXT = '#hpsum-save-install-set-text';
        var INSTALL_SET_DESC_TEXT = '#hpsum-save-install-set-descr-text';
		var CLEANUP_CONTAINER = '#li-hpsum-node-cleanuponexit';
		var CLEANUP_ALL_CONTAINER = '#li-hpsum-node-cleanupallonexit';
		var COMMON_REBOOT_OPTIONS = '#hpsum-common-reboot-options';
		var ILO_MANAGEMENT_OPTIONS = '#li-hpsum-show-ilo-management';
		var ILO_MIN_MAJOR_VER_FOR_UPDATE_REC_SET = 1, //Mininum iLO firmware version for update recovery set 1.30
			ILO_MIN_MINOR_VER_FOR_UPDATE_REC_SET = 30;
		
        
        var nondisruptive = false,
            cleanuponexit = false,
            cleanupallonexit = false,
            iloManagementOptionNeeded = false,
            isPartOfGroup = false,
         initialBaselines = [];
        var isStageSelected = false;
        				
        /**
         * Constructor
         */
        function NodeDeployView() {
            var formStateView = new FormStateView();
            var nodeItem=null;
            var scheduled_getdata_date_time;
            var scheduled_getdata;
            var schedaction;
            var schedule_time;
            var failedDependencyCount = 0;
            var deploy_flag = false;
            var assoc_deploy_flag = false;
            var assoc_dialog_openedonce = false;
            var applyOptions = false;
            var selectedComponentsCount = 0;
			var compNeedPrereqInstall=false;
			var skip_prereqs=false;
            var isSelectionChanged = false;
            var analysisDone = false;
            var tmpScheduleTime = "";
            //var shouldResetToggle = false;
            var timezone;
            var mode = 'expert';
            var resetaction = "";
            var isUefiUpdatableComp = false;
            var isTaskQueueSelected = false;
            var isInstallsetSelected = false;
            var invalidComponentsSelected = false;
            var optiondetails = { 
                hapi: {
                    reboot_options: {
                        action:'Never',
                        delay : REBOOT_DELAY_SEC / 60,
                        message :localizer.getString('hpsum.node.rebootMessage')												
                    },
                    activate_sfw: false,					
                    deploy_enclosure: false,
                    associated_nodes: {
                        associated_node: []
                    },
                    
                    ilo_management_options : {
                        save_install_set: false,
                        clear_ilo_update_list: false,
                        manually_manage_iLO_repository: false,
                        installset_ids_for_delete: []
                    }
                }
            };

            var baselineDetails = {
                hapi: {
                    baselines: {
                        baseline: [],
                        remove_existing_baselines: false
                    },
                }
            };
            
            var ForceOptions = { 
                hapi: {		
                    failed_dependency_handling: 'OMITHOST',
                    installation_option:{
                        firmware :true,
                        software :true,
                        downgrade: false,
                        rewrite:false,
                        force:false,
                        forcefirmware:false,
                        forcesoftware:false,
                        nondisruptive:false              
                    }
                }
            };            

            var dateTime;
            var displayBaselineError = false;
            var initialGetattr = null;
            var initialRebootOptionsLoaded = true;
            var assocNodeDialogContents = null,
            assocNodeDialog = null;
            var skipInstallOptions = false;
            var selectedAssociatedNodes = [];
            var reRenderAssociatedNodesOnce = true;
            var reRenderBaselineDetails = false;
            var minEncryptionKeyLength = 7;
            var associatedNodesData = null;
            var assoc_table;
            var tableid;
            var warningMessage = '';
            var shouldDisableDeploy = false;
            var warningMsg = '';
            var rebootSelectionChanged = false;
            var isWarningsset = false;
            var isIgnoreWarningsNeeded = false;
            var switchToAdvanceMode = false;
            var rebootDelayChanged = false;
            var ignore_warnings_chkbox_needed = false;
            var setOk = false;
            function OnResize() {
                var BaseLineSearchWidth = ($(window).width() / 3);
                $(BASELINES).hpSearchCombo({ getResults: getBaseline, width: BaseLineSearchWidth });
                $(HOTFIX).hpSearchCombo({ getResults: getHotfixes, width: BaseLineSearchWidth });
            }

            function getInstallSetForId(itemId) {
                for (var idx = 0; idx < allInstallSets.length ; idx++) {
                    if (itemId == allInstallSets[idx].id) {
                        return allInstallSets[idx];
                    }
                }
                return null;
            }
            function updateEditableFields(nodeItem, checked) {
                //clear the baseline selection. 
                if (checked) //disable
                {
                    if (nodeItem != null && nodeItem.node_state.match(/idle/i)) {
                        $(BASELINES).hpSearchCombo('disable');
                        $(HOTFIX).hpSearchCombo('disable');
                        populateBaselineDetails(initialBaselines);
                    }
                    $(DEPLOY).attr("disabled", true);
                    //disable installation option, schedule option, reboot and iloManagement options contents
                    $(SKIP_DEPENDENCY_CHECKBOX).attr('disabled', true);
                    $(COMPVERBOSEOPTION).attr('disabled', true);
                    $(IGNORE_WARNING_CHECKBOX).attr('disabled', true);
                    $(CLEANUP_ONEXIT).attr('disabled', true);
                    $(CLEANUP_ALLONEXIT).attr('disabled', true);
                    $(INSTALLATIONOPTION).selectBox('disable');
                    $('input[name=hpsum-stage-edit-active]').attr('disabled', true);
                    $(REBOOTOPTION).selectBox('disable');
                    $(SAVE_INSTALL_SET_CHECBOX).attr('disabled', true);
					$(UPDATE_RECOVERY_SET_CHECKBOX).attr('disabled', true);
					$(VC_ENCRYPTION_KEY).attr('disabled', true);
					$(HPSUM_ENET_ORDER).selectBox('disable');
					$(HPSUM_FC_ORDER).selectBox('disable');
					$(HPSUM_ENET_DELAY).attr('disabled', true);
					$(HPSUM_FC_DELAY).attr('disabled', true);
					$(SDFLEX_REBOOT_OPTION).selectBox('disable');
					$(SDFLEX_INSTALLATION_OPTION_EXCLUDENPAR).attr('disabled', true);
					$(SDFLEX_NO_REBOOT_REQUIRED).hide();

					$('input[name=hpsum-schedule-options]').attr('disabled', true);
                    $('input[name=hpsum-delete-install-sets-options]').attr('disabled', true);
                    var msg = localizer.getString("hpsum.easymode.partOfGroupMsg");
                    if (isPartOfGroup && nodeItem.node_state.match(/UAN/i)) {
                        msg = localizer.getString("hpsum.easymode.partOfGroupMsgDeploy");
                    }
                    formStateView.setMessage({
                        summary: msg,
                        status: 'warning',
                        changing: false,
                    });
					
                    shouldDisableDeploy = true;
                    warningMessage = msg;
					applyColor(true);
                }
                else //enable
                {
                    if (nodeItem != null && nodeItem.node_state.match(/idle/i)) {
                        $(BASELINES).hpSearchCombo('enable');
                        $(HOTFIX).hpSearchCombo('enable');
                    }
                    // $(DEPLOY).attr("disabled", false);
                    $(SKIP_DEPENDENCY_CHECKBOX).attr('disabled', false);
                    $(COMPVERBOSEOPTION).attr('disabled', false);
                    $(IGNORE_WARNING_CHECKBOX).attr('disabled', false);
                    $(CLEANUP_ONEXIT).attr('disabled', false);
                    $(CLEANUP_ALLONEXIT).attr('disabled', false);
                    $(INSTALLATIONOPTION).selectBox('enable');
                    $('input[name=hpsum-stage-edit-active]').attr('disabled', false);
                    $(REBOOTOPTION).selectBox('enable');
                    if (!router.location().match(/stage/i))
                    {
                        $(SAVE_INSTALL_SET_CHECBOX).attr('disabled', false);						
                    }
                   
					
					$(VC_ENCRYPTION_KEY).attr('disabled', false);
					$(HPSUM_ENET_ORDER).selectBox('enable');
					$(HPSUM_FC_ORDER).selectBox('enable');
					$(HPSUM_ENET_DELAY).attr('disabled', false);
					$(HPSUM_FC_DELAY).attr('disabled', false);
					
					$(SDFLEX_REBOOT_OPTION).selectBox('enable');
					$(SDFLEX_INSTALLATION_OPTION_EXCLUDENPAR).attr('disabled', false);
					$('input[name=hpsum-schedule-options]').attr('disabled', false);
                    $('input[name=hpsum-delete-install-sets-options]').attr('disabled', false);
                    formStateView.reset();
					applyColor(false);
                }
            }
            function applyColor(option)
			{
				if(option == true)
				{
					$(SKIP_DEPENDENCY_CONTAINER).addClass('sum-disable-color-grey');
					$(DELAYMSG).addClass('sum-disable-color-grey');
					$(COMMON_REBOOT_OPTIONS).addClass('sum-disable-color-grey');
					$(ILO_MANAGEMENT_OPTIONS).addClass('sum-disable-color-grey');
					$(CLEANUP_CONTAINER).addClass('sum-disable-color-grey');	
					$(CLEANUP_ALL_CONTAINER).addClass('sum-disable-color-grey');
					$(COMPONENT_VERBOSE_DESCR).addClass('sum-disable-color-grey');
					$(INSTALLATION_FORCE_OPTIONS).addClass('sum-disable-color-grey');
					$(VC_ACTIVATION_OPTIONS).addClass('sum-disable-color-grey');
					$(VC_INSTALLATION_OPTIONS).addClass('sum-disable-color-grey');
					
				}
				else
				{
					$(SKIP_DEPENDENCY_CONTAINER).removeClass('sum-disable-color-grey');
					$(DELAYMSG).removeClass('sum-disable-color-grey');
					$(COMMON_REBOOT_OPTIONS).removeClass('sum-disable-color-grey');
					$(ILO_MANAGEMENT_OPTIONS).removeClass('sum-disable-color-grey');
					$(CLEANUP_CONTAINER).removeClass('sum-disable-color-grey');	
					$(CLEANUP_ALL_CONTAINER).removeClass('sum-disable-color-grey');
					$(COMPONENT_VERBOSE_DESCR).removeClass('sum-disable-color-grey');
					$(INSTALLATION_FORCE_OPTIONS).removeClass('sum-disable-color-grey');
					$(VC_ACTIVATION_OPTIONS).removeClass('sum-disable-color-grey');
					$(VC_INSTALLATION_OPTIONS).removeClass('sum-disable-color-grey');
				}
			}
            function handleTabClickAction(tab)
            {                
			
                var overTabsId = "#node-deploy-operation-tabs-contents";
                //overTabsId
                $(overTabsId).css('padding-top', '0px');
                for (var eleCount = 0; eleCount < $(overTabsId)[0].children.length; eleCount++) {
                    $('#' + $(overTabsId)[0].children[eleCount].id).hide(); //hide all the contents
                }
                $('#li-hpsum-deploy-page-tabs').css('padding-bottom', '1px');
                for (var optCount = 0; optCount < $('#node-deploy-operation-tabs')[0].children.length; optCount++) {
                    //unset all the tabs to default.
                    var child = $('#node-deploy-operation-tabs')[0].children[optCount].children[0];
					$(child).addClass('company-a');
                    $(child).removeClass('company-background');
                }

                $('#li-' + tab.getAttribute("data-panel-id")).show();//show the tab's content.
                tab.style.color = "#000";// set the tab selection.
                $(tab).addClass('company-background');
               
            }

            function populateInstallsetInfo(baselineList)
            {
                var installsetName = "";
                var installsetDesc = "";

                if (baselineList.length > 0) {
                    for (var i = 0; i < baselineList.length; i++) {
                        var baseline = presenter.getBaselineDetailsforId(baselineList[i]);
                        if (baseline) {
                            isBaselineSelected = true;
                            if (baseline.name.match(/^Additional Package/i)) {
                                installsetName = "ADD_PKG";
                                installsetDesc = "Hot Fixes for ProLiant";
                            } else {
                                installsetName = "SPP_" + baseline.version;
                                installsetDesc = baseline.baseline_name;
                                break;
                            }
                        }
                    }
                }
                $(INSTALL_SET_NAME_TEXT).val(installsetName);
                $(INSTALL_SET_DESC_TEXT).val(installsetDesc);
            }
			
			function showHideiLOOptionFullRecoverySet(val)
				{
					
					if(val==true)
					{
						//show  all ilo repository options
						$(SAVE_INSTALL_SET_CHECBOX).show();
						$(SAVE_INSTALL_SET_ROLLBACK).show();
						$(SAVE_INSTALL_SET_DESC).show();
						$(LI_SAVE_INSTALSSET_DETAILS).show();
						$(ILO_MANAGEMENT_DRIVE_OPTION).show();
						
						 
					}
					else
					{
						//show ilo repository options with only	UPDATE_RECOVERY_SET_CHECKBOX				
						$(SAVE_INSTALL_SET_CHECBOX).hide();
						$(SAVE_INSTALL_SET_ROLLBACK).hide();
						$(SAVE_INSTALL_SET_DESC).hide();
						$(ILO_MANAGEMENT_DRIVE_OPTION).hide();
						$(LI_SAVE_INSTALSSET_DETAILS).hide();
						
						
													
					}
									 
												
					
					
				}

            function onItemChange(item)
            {
                nodeItem = item.hapi; 
                if (router.location().match(/stage/i))
                {
                    isStageSelected = true;
                }
                else
                {
                    isStageSelected = false;
                }
                if(item.node_phase.match(/deploying/i)) {
                    $(CANCEL).trigger('click');
                }
            		
                if(item.node_state.match(/install/i)) {
                    $(CANCEL).trigger('click');
                }

                $(ILO_MGMT_OPTIONS_INSTALLSET_PLUGIN_PANEL).hpsumInstallSets('destroy');
                $(ILO_INSTALLSET_COMPONENTS).hpsumInstallSetComponents('destroy');
                  
                //loop thruogh all messages and check if ignore warnings checkbox is required or not.
                //checkbox is required only for server messages. otherwise no.

                for (var len = 0; len < nodeItem.warnings.length; len++) {
                    if (nodeItem.warnings[len].type.match(/server/i)) {
                        ignore_warnings_chkbox_needed = true;
                        break;
                    }
                }
			    
                if (nodeItem) {
					skip_prereqs=nodeItem.skip_prereqs;
                    if ((nodeItem.server_generation >= 10 || nodeItem.type.match(/ilo5/i)))
                    {
                        iloManagementOptionNeeded = true;
                        //read all install sets and add it to the baseline search box.
                        presenter.getInstallSets(nodeItem, {
                            success: function (data) {
                                if (data.hapi.hasOwnProperty('installsets') && data.hapi.installsets.installset.length > 0) {
                                    allInstallSets = [];
                                    for (var iset = 0; iset < data.hapi.installsets.installset.length ; iset++) {
                                        var obj = {
                                            id: data.hapi.installsets.installset[iset].id,
                                            name: data.hapi.installsets.installset[iset].name + ' - ' + data.hapi.installsets.installset[iset].date
                                        };
                                        allInstallSets.push(obj);
                                    }
                                }
                                populateInstallsetInfo(nodeItem.baselines);
                                isWarningsset = true;
                                shouldDisableDeploy = false;
                            }
                        });

                        //check for hasPendingTaskQueueItems
                        presenter.getTaskQuequeList(nodeItem, {
                            success: function (data) {
                                hasPendingTaskQueueItems = false;
                                if (data.hapi.hasOwnProperty('ilotasks') && data.hapi.ilotasks.ilotask.length > 0) {
                                    allPendingTaskQueueItems = data.hapi.ilotasks;
                                    hasPendingTaskQueueItems = true;
                                    
                                    //create a warning message and add it to warning panel. 
                                    var warningMessage = "";
                                    if (!isStageSelected) {
                                        if (nodeItem.node_state.match(/UAN|STAGE_ONLY_DONE/i)) {
                                            if (allPendingTaskQueueItems.ilotask[0].state.match(/Exception/i) || allPendingTaskQueueItems.ilotask[0].state.match(/Expired/i)) {
                                                warningMessage = localizer.getString('hpsum.common.pendingTQWarningForDeployWithexState');
                                            }
                                            else {
												if(allPendingTaskQueueItems.ilotask[0].state.match(/Pending/i)){
													warningMessage = localizer.getString('hpsum.common.pendingTQWarningForDeployWithPendingState');
													if(allPendingTaskQueueItems.ilotask[0].scheduledatetime != "")
													{
														warningMessage = localizer.getString('hpsum.common.pendingTQWarningForDeployWithScheduledState');
													}
												}
                                                
                                            }
                                        }
                                    }
                                    if (warningMessage != "") {
                                        var warningMsgItem = {
                                            type: "ilo",
                                            message: warningMessage

                                        }
                                        var ddWarnings = [];
                                        //loop through all messages and check if ignore warnings checkbox is required or not.
                                        //checkbox is required only for server messages. otherwise no.                                    
                                        for (var len = 0; len < nodeItem.warnings.length; len++) {
                                            if (!nodeItem.warnings[len].message.match(localizer.getString('hpsum.common.iLOTaskQueuePendingWarning')) && 
												!nodeItem.warnings[len].message.match(localizer.getString('hpsum.common.iloTaskqueueTopItemWarning')) && 
												!nodeItem.warnings[len].message.match(localizer.getString('hpsum.common.iLOTaskQueueScheduledWarning'))) {
                                                ddWarnings.push(nodeItem.warnings[len]);
                                            }
                                        }
                                        ddWarnings.push(warningMsgItem);
                                        var warningItem = {
                                            warnings: ddWarnings
                                        }
                                        $('#hpsum-warning-messages').show();
                                        $('#hpsum-warning-messages').hpsumWarnings(warningItem, ignore_warnings_chkbox_needed);
                                    }
                                    if (!nodeItem.group && !hasPendingTaskQueueItems) {
                                        formStateView.reset();
                                    }
                                }
                                if (hasPendingTaskQueueItems) {
									
                                    isWarningsset = true;
                                    shouldDisableDeploy = false;
                                    
                                    //for now we'll be showing pending task items directly if the node has any items.
                                    if (nodeItem.node_state.match(/idle/i)) {
                                        $(DIRECT_DEPLOY_BASELINE_SELECTOR).hide();
                                        $(IGNORE_WARNING_CHECKBOX_PANEL).hide();
                                        $(SKIP_DEPENDENCY_CONTAINER).hide();
                                        var installItem = {
                                            "id": "ilo_queued_updates",
                                            "name": localizer.getString('hpsum.common.pendingTaskQueue')
                                        }
                                        renderInstallsetDetails(installItem);
                                        nodeItem.baselines = installItem;
                                        $(BASELINES).hpSearchCombo('set', { id: 'ilo_queued_updates', name: localizer.getString('hpsum.common.pendingTaskQueue') });
                                        isTaskQueueSelected = true;
                                        var warnMsg = "";
                                        if (nodeItem.group && nodeItem.node_state.match(/idle/i)) {
                                            $(DEPLOY).attr("disabled_org", 1); //this is required to make ignore warnings work for idle state when node is part of any group.
                                            warnMsg = localizer.getString("hpsum.easymode.partOfGroupMsg");
                                            isWarningsset =false;
                                            shouldDisableDeploy = true;
                                            var itemVal = {
                                                disableDeploy: shouldDisableDeploy,
                                                formStateViewMessage: warnMsg
                                            };
                                            shouldEnableDeployment(itemVal);
                                        }
                                        else
                                        {
                                            $(DEPLOY).attr("disabled_org", 0); //this is required to make ignore warnings work for idle state.
                                        }
                                       
                                        //handle tabs..
                                        if(nodeItem.type.match(/windows|linux|ilo5/i))
                                        {
                                            $(TAB_INSTALLATION_OPTION_CONTAINER).show();
                                            $(INSTALLATION_OPTIONS).show();                                           
                                            $(TAB_ILO_MANAGEMENT_OPTION_CONTAINER).hide();
                                            $(ILO_MANAGEMENT_OPTION).hide();
                                            $(TAB_REBOOT_OPTION_CONTAINER).show();
                                            $(REBOOT_OPTIONS).show();
                                            $(TAB_INSTALLATION_OPTIONS).trigger('click');
                                        }
                                    }
                                    else if (!nodeItem.node_state.match(/UAN/i) && !nodeItem.node_state.match(/STAGE_ONLY_DONE/i))
                                    {
                                        $(DIRECT_DEPLOY_BASELINE_SELECTOR).show();
                                        $(IGNORE_WARNING_CHECKBOX_PANEL).show();
                                        $(SKIP_DEPENDENCY_CONTAINER).show();
                                    }
                                }
                            }
                        });

                        if (nodeItem.iLO_drive_available) {
                            var ilo_free_space = (nodeItem.iLO_drive_available / 1024);
                            if (ilo_free_space > 1024) {
                                ilo_free_space = ilo_free_space / 1024;
                                if (ilo_free_space > 1024) {
                                    ilo_free_space = ilo_free_space / 1024;
                                    ilo_free_space = ilo_free_space.toFixed(2);
                                    ilo_free_space = ilo_free_space + 'GB';
                                }
                                else {
                                    ilo_free_space = ilo_free_space.toFixed(2);
                                    ilo_free_space = ilo_free_space + 'MB';
                                }
                            }
                            else {
                                ilo_free_space = ilo_free_space.toFixed(2);
                                ilo_free_space = ilo_free_space + 'KB';
                            }
                            $('#hpsum-available-ilo-space-descr').text(ilo_free_space);
                        }
                        else {
                            $('#hpsum-available-ilo-space-descr').text(localizer.getString('hpsum.common.na'));
                        }
                        if (nodeItem.node_state.match(/STAGE_ONLY_DONE/i))
                        {
							//Incase if iLO management required dont hide iLO management option							
							if(!iloManagementOptionNeeded)
							{
								$(TAB_ILO_MANAGEMENT_OPTION).hide();
							}
                           $(TAB_SHOW_BASELINE_DETAILS).hide();
                           $(TAB_ASSOCIATED_NODE_DETAILS).hide();
                        }
                    }

                    if (nodeItem.group) {
                        isPartOfGroup = true;
                    }
                    if ((item.node_state.match(/UAN/i) || item.node_state.match(/REMOTE_STAGING_UAN/i)) && isPartOfGroup) { //this means it is part a group and we cannot trigger deploy.
                        $(DEPLOY).attr('disabled', 'disabled');
                        var msg = localizer.getString("hpsum.easymode.partOfGroupMsg");
                        if (isPartOfGroup && item.node_state.match(/UAN/i)) {
                            msg = localizer.getString("hpsum.easymode.partOfGroupMsgDeploy");
                        }

                        formStateView.setMessage({
                            summary: msg,
                            status: 'warning',
                            changing: false,
                        });
                        shouldDisableDeploy = true;
                        warningMessage = msg;
                    }
                    //general actions.
                    $(DESCR).text(nodeItem.name);
                    $(TYPE).text(nodeItem.type);
                    if ((nodeItem.node_state == "REMOTE_STAGING_UAN") && nodeItem.schedule_date_time != ""
                                && nodeItem.scheduled === "false" && tempAbortInProgress == true) {
                        tempAbortInProgress = false;
                        //strop splash screen
                        $(SPLASH_SPINNER_TEMP_ABORT).dialog('destroy');

                    }
                    else if ((nodeItem.node_state == "UAN") && nodeItem.schedule_date_time != ""
                                && nodeItem.scheduled === "false" && tempAbortInProgress == true) {
                        tempAbortInProgress = false;
                        //stop splash screen
                        $(SPLASH_SPINNER_TEMP_ABORT).dialog('destroy');
                        //trigger to advance mode
                        switchToAdvanceMode = true;
                    }
                    else {
                        if (nodeItem.node_state == "SCHEDULED" && tempAbortInProgress == true) {
                            return;
                        }

                    }

                    //warnings panel.
                    if (nodeItem.hasOwnProperty('warnings') && nodeItem.warnings.length > 0) {
                        isWarningsset = false;
                        if (!ignore_warnings_chkbox_needed)
                        {
                            isWarningsset = true; //making checkbox as checked as this checkbox is not needed, so that deploy button is enabled.
                        }
                        $('#hpsum-warning-messages').show();
                        $('#hpsum-warning-messages').hpsumWarnings(nodeItem, ignore_warnings_chkbox_needed);
                        $(IGNORE_WARNING_CHECKBOX_PANEL).hide();
                    }
                    else {
                        isWarningsset = true;
                        $('#hpsum-warning-messages').hide();
                        if (nodeItem.node_state.match(/idle/i)) {
                            $(IGNORE_WARNING_CHECKBOX_PANEL).show();
                        }
                    }

                    //hanlde direct deploy baseline selection action for direct deploy.                   
                    $('#li-hpsum-deploy-page-tabs').css('padding-bottom', '1px');

                    if (nodeItem.node_state.match(/idle/i))
                    {                                              
                        $(DIRECT_DEPLOY_BASELINE_SELECTOR).show();
                        $(BASELINE_ASSOCIATED_NODE_TAB_CONTAINER).hide();
                        $('#li-expert-mode-baseline-assocnodes').hide();
                        
                        $('#node-name-value').text(nodeItem.name);
                        $('#node-type-value').text(displayILO(nodeItem.type));
                        if (nodeItem.baselines) {
                            $(ILO_INSTALLSET_COMP_CONTAINER).hide();
                            $('#hpsum-ilo-installset-overview-title').hide();
                            $('#hpsum-ilo-updatequeue-overview-title').hide();
                            initialBaselines = nodeItem.baselines;
                            populateBaselineDetails(nodeItem.baselines);
                        }
                        else
                        {
                            renderDirectDeployBaselineDetails(null);
                        }

                        if (isPartOfGroup) {
                            //show the remove node from group option
                            currentGroup = nodeItem.group;
                            $(REMOVE_NODE_FROM_GROUP).show();
                            var group_uri = '#/group/show/overview/r/session/' + nodeItem.node_session + '/node/group/' + nodeItem.group + '/getdata';
                            var uri = '<a href="' + group_uri + '" class="company-a">' + nodeItem.group_name + '</a>';
                            $(REMOVE_NODE_FROM_GROUP).html(localizer.getString('hpsum.node.removeNodeFromGrp', [uri]));
                            $(REMOVE_GRP_CONTAINER).show();

                            var checkboxLabel = localizer.getString('hpsum.node.removeGrpDesc', [uri]);
                            $(REMOVE_GRP_CHECKBOX_LABEL).html(checkboxLabel);
                            $(DEPLOY).attr("disabled", true);
                            //disable the baseline editable items.
                            $(BASELINE_INPUT_ERR).hide();
                            $(BASELINE_INPUT).removeClass('hp-error');
                            updateEditableFields(nodeItem, true);
                        }
                        else {
                            $(REMOVE_NODE_FROM_GROUP).hide();
                            $(REMOVE_GRP_CONTAINER).hide();
                            $(BASELINE_INPUT_ERR).hide();
                            $(BASELINE_INPUT).removeClass('hp-error');
                            updateEditableFields(nodeItem, false);
                        }
                    }
                    else {
                        $(DIRECT_DEPLOY_BASELINE_SELECTOR).hide();
                    }
                    //Tabs panel.
					$('#vmware-rewrite-warning').hide();
                    $('#oa-fips-force-warning').hide();
                    $('#assoc-oa-fips-force-warning').hide();
                    $(TAB_INSTALLATION_OPTION_CONTAINER).hide();
                    $(INSTALLATION_OPTIONS).hide();
                    $(TAB_SCHEDULE_OPTION_CONTAINER).hide();
                    $(SCHEDULE_OPTIONS).hide();
                    $(TAB_ILO_MANAGEMENT_OPTION_CONTAINER).hide();
                    $(ILO_MANAGEMENT_OPTION).hide();
                    $(TAB_REBOOT_OPTION_CONTAINER).hide();
                    $(REBOOT_OPTIONS).hide();
                    $(TAB_VC_INSTALLATION_OPTION_CONTAINER).hide();
                    $(VC_INSTALLATION_OPTIONS).hide();
                    $(TAB_VC_ACTIVATION_OPTIONS_CONTAINER).hide();
                    $(VC_ACTIVATION_OPTIONS).hide();
                    $(TAB_INTEGRITY_REBOOT_TO_ACTVATE_CONTAINER).hide();
					$(INTEGRITY_REBOOT_TO_ACTVATE).hide();
					$(TAB_SDFLEX_INSTALLATION_OPTIONS_CONTAINER).hide();
					$(SDFLEX_INSTALLATION_OPTIONS).hide();
					$(TAB_SDFLEX_REBOOT_OPTIONS_CONTAINER).hide();
					$(SDFLEX_REBOOT_OPTIONS).hide();

                    $(TAB_INSTALLATION_OPTIONS).trigger('click');
                    $('#li-hpsum-deploy-page-tabs').css('padding-bottom', '1px');

                    if (nodeItem.node_state == "REMOTE_STAGING_UAN") {
                        $(DEPLOY).val(localizer.getString('hpsum.easymode.DeployStaged'));
                        $('#hp-details-header-title').text(localizer.getString('hpsum.easymode.DeployStaged'));
                    }
                    else if (item.node_state.match("SCHEDULED")) {
                        /*for temporary abort of scheduled stage nodes*/
                        bHasUserPressedDeploy = false;
                        tempAbortForScheduledNodes(nodeItem);
                        return;
                    }
                    else {
						if(router.location().match(/stage/i))
						{
						    $(DEPLOY).val(localizer.getString('hpsum.server.stage'));
						    $(DEPLOY).attr('tooltip', localizer.getString('hpsum.easymode.stageInfo')).hpTooltip();
							$('#hp-details-header-title').text(localizer.getString('hpsum.server.stage'));
							$(SAVE_INSTALL_SET_CHECBOX)[0].checked = true;
							$(SAVE_INSTALL_SET_CHECBOX).attr('disabled', true);
							$(INSTALL_SET_NAME_TEXT).attr('disabled', false);
							$(INSTALL_SET_DESC_TEXT).attr('disabled', false);
							$('#hpsum-save-install-sets-descr').text(localizer.getString("hpsum.node.saveInstallSets") + " (required for Stage)");
							
							//No Update Recovery Set for Staging
							$(UPDATE_RECOVERY_SET_DETAILS).hide();
						}
						else
						{
							$(DEPLOY).val(localizer.getString('hpsum.node.deploy'));
							$('#hp-details-header-title').text(localizer.getString('hpsum.node.deploy'));
							if (nodeItem.server_generation >= 10 || nodeItem.type.match(/ilo5/i))
							{
							    $(DEPLOY).attr('tooltip', localizer.getString('hpsum.easymode.deployInfo')).hpTooltip();
								
								if(nodeItem.type.match(/ilo5/i))
								{
									$(SCHEDULE_OPTIONS).show();
								}
							}				
						}

                        $('#schedule').hpsumSchedule('setMasterNodeTimer', nodeItem.local_date_time);
						$('#schedule').hpsumSchedule('runNow');
                    }

                    if (nodeItem.type.match(/Windows|Linux|ilo/i)) {
                        //Call plugin to show the component list ();
                        var options = {
                            command: 'init',
                            nodeItem: item.hapi,
                            isDeleteExistingItem: true
                        };
                        
                        if (iloManagementOptionNeeded)
                        {
                            $(ILO_MGMT_OPTIONS_INSTALLSET_PLUGIN_PANEL).hpsumInstallSets(options);
                            $(TAB_ILO_MANAGEMENT_OPTION_CONTAINER).show();
                            $(ILO_MANAGEMENT_OPTION).show();
                            $(TAB_REBOOT_OPTION_CONTAINER).show();
                            $(REBOOT_OPTIONS).show();                                                      
                        }
                    }
                    if (nodeItem.type.match(/hpux|vmware|Windows|Linux/i)) {
                        //$('#hpsum-osmanagement-options-collapsible').css("display","block");
                       // $(TAB_SCHEDULE_OPTION_CONTAINER).show();
                        $(TAB_INSTALLATION_OPTION_CONTAINER).show();
                        $(INSTALLATION_OPTIONS).show();
                        $(INSTALLATION_FORCE_OPTIONS).show();
                        $(TAB_REBOOT_OPTION_CONTAINER).show();
                        $(REBOOT_OPTIONS).show();
                        if (nodeItem.type.match(/vmware/i)) {
                            $('#vmware-rewrite-warning').show();
                        }
                    }
                    else if (nodeItem.type.match(/virtual_connect|ipdu|OA|ilo|switch|SAS_SWITCH|moonshot|integrityilo|sdflex/i)) {
                        $(INSTALLATION_OPTIONS).hide();
                        if (!nodeItem.type.match(/ilo5/i)) {
                            $(REBOOT_OPTIONS).hide();
                        }
                        if (nodeItem.type.match(/virtual_connect/i)) {
                            $(TAB_VC_ACTIVATION_OPTIONS_CONTAINER).show();
                            $(VC_ACTIVATION_OPTIONS).show();
                            $(TAB_VC_ACTIVATION_OPTIONS).show();
                            $(TAB_VC_ACTIVATION_OPTIONS).trigger('click');
                            if (nodeItem.is_config_password_required) {
                                $(TAB_VC_INSTALLATION_OPTION_CONTAINER).show();
                                $(VC_INSTALLATION_OPTIONS).show();
                                $(TAB_VC_INSTALLATION_OPTIONS).show();
                                $(TAB_VC_INSTALLATION_OPTIONS).trigger('click');
                            }
                        }
                        else if (nodeItem.type.match(/integrityilo/i)) {
                            $(TAB_INTEGRITY_REBOOT_TO_ACTVATE_CONTAINER).show();
                            $(TAB_INTEGRITY_REBOOT_TO_ACTVATE).show();
                            $(INTEGRITY_REBOOT_TO_ACTVATE).show();
                            //$(TAB_INTEGRITY_REBOOT_TO_ACTVATE).trigger('click');

                            if (nodeItem.hasOwnProperty('activate_sfw')) {
                                if (!nodeItem.is_powered_on) {
                                    $(ACTIVATE_SELECTION).closest("li").hide();
                                    $(NO_REBOOT_REQ).show();
                                }
                                else {
                                    $(ACTIVATE_SELECTION).closest("li").show();
                                    $(NO_REBOOT_REQ).hide();
                                }
                                if (nodeItem.activate_sfw) {
                                    $(ACTIVATE_SELECTION).selectBox('value', 'YES');
                                } else {
                                    $(ACTIVATE_SELECTION).selectBox('value', 'NO');
                                }
                            }
                        }
                        else if (nodeItem.type.match(/oa/i) && nodeItem.fips_enabled) {
                            $('#oa-fips-force-warning').show();
						}
						else if (nodeItem.type.match(/sdflex/i)){
							$(TAB_SDFLEX_INSTALLATION_OPTIONS_CONTAINER).show();
							$(TAB_SDFLEX_INSTALLATION_OPTIONS).show();
							$(SDFLEX_INSTALLATION_OPTIONS).show();
							$(TAB_SDFLEX_INSTALLATION_OPTIONS).trigger('click');

							$(TAB_SDFLEX_REBOOT_OPTIONS_CONTAINER).show(); 
							$(TAB_SDFLEX_REBOOT_OPTIONS).show();
							$(SDFLEX_REBOOT_OPTIONS).show();

							if (nodeItem.partitions_powered_off) {
								$(SDFLEX_REBOOT_OPTION).closest("li").hide();
								$(SDFLEX_NO_REBOOT_REQUIRED).show();
							}
							else {
								$(SDFLEX_REBOOT_OPTION).closest("li").show();
								$(SDFLEX_NO_REBOOT_REQUIRED).hide();	
							}
						}
                        else {
                            //$("#hpsum-deploy-installation-panel-selector").hide();
                        }


                       //// $(tab_schedule_option_container).show(); //show schedule tab for all nodes.
                       // if (!nodeItem.type.match(/virtual_connect/i)) {
                       //     $(TAB_VC_INSTALLATION_OPTIONS).trigger('click');
                       // }
                        $('#li-hpsum-deploy-page-tabs').css('padding-bottom', '1px');                        
                    }

                    cleanuponexit = false,
                    cleanupallonexit = false,
                    //other general action.
                    skipInstallOptions = false;
                    loadAttributes();

                    //Load the Schedule Information from getdata
                    //loadScheduleoptions(nodeItem);
                    //If the user has deleted the baseline then we cannot proceed to deploy
                    //so we display a message that there is no available baseline and exit
                                        

                    $('.ignorewarnings').on('change', function () {
                        var message = '';
						if(skip_prereqs && compNeedPrereqInstall)
						{
							shouldDisableDeploy=true;
							 if (isStageSelected) {
								message = localizer.getString('hpsum.advanceMode.StageDisabledAsNoPrereqInstallPermission');
							}
							else {
								message = localizer.getString('hpsum.advanceMode.DeployDisabledAsNoPrereqInstallPermission');
							}
						}
						else{
							if (this != undefined && !$(this).is(':checked')) {
								isWarningsset = false;
								if (isStageSelected) {
									message = localizer.getString('hpsum.advanceMode.StageDisabledDueToWarning');
								}
								else {
									message = localizer.getString('hpsum.advanceMode.DeployDisabledDueToWarning');
								}
							}
                        else {
								isWarningsset = true;
								if (shouldDisableDeploy) {
									message = warningMessage;
								}
								else {
									formStateView.reset();
									$(DEPLOY).removeAttr('disabled');
								}
							}
						}
                        if (message != '') {
                            $(DEPLOY).attr('disabled', 'disabled');
                            formStateView.setMessage({
                                summary: message,
                                status: 'warning',
                                changing: false,
                            });
                        }
                        else
                        {
                            formStateView.reset();
                        }

                    });
                    showInstallationOptions(nodeItem, true);

                    if (nodeItem.node_state == 'REMOTE_STAGING_UAN' ) {
                        showAssociatedNodes(nodeItem);
                        presenter.getbaseline(nodeItem, {
                            success: function (data) {
                                renderBaselineData(nodeItem);
                            },
                            error: function (data) {
                                renderNodeDeployWidget("", nodeItem);
                            }
                        });
                    }
                    else if (nodeItem.node_state == 'UAN' || nodeItem.node_state == 'STAGE_ONLY_DONE') {
                        showAssociatedNodes(nodeItem);
                        $(ILO_INSTALLSET_COMP_CONTAINER).hide();
                        $(BASELINE_ASSOCIATED_NODE_TAB_CONTAINER).hide();
                        $('#li-expert-mode-baseline-assocnodes').hide();
                        $(ILO_TASKQUEUE_COMP_CONTAINER).hide();
                        if (nodeItem.baselines) {
                            reRenderAssociatedNodesOnce = false;
                            reRenderBaselineDetails = false;
                            for (var i = 0; i < nodeItem.baselines.length; i++) {
                                var baseline = presenter.getBaselineDetailsforId(nodeItem.baselines[i]);
                                if (baseline && nodeItem.baselines[0].indexOf('/') > -1 && nodeItem.node_state.match(/UAN/i)) {
                                    $(BASELINE_ASSOCIATED_NODE_TAB_CONTAINER).show();
                                    $('#li-expert-mode-baseline-assocnodes').show();

                                    $(TAB_SHOW_BASELINE_DETAILS).trigger('click');
                                    isRegularBlSelectedForDeploy = true;
                                    break;
                                }
                            }
                        }


                        if (isRegularBlSelectedForDeploy) {
                            var options = {
                                command: 'init',
                                nodeItem: nodeItem,
                                onSelectionChanged: onSelectionChanged,
                                onPopulateInstallSet: onPopulateInstallSet,
                                onUpdatedList: renderNodeDeployWidget,
                                getNoChangeFlag: getNoChangeFlag,
                                onShowWarning: showWarning
                            };

							if(iloManagementOptionNeeded)
							{
								//Regular basline/Additional package selected for deployment
								showHideiLOOptionFullRecoverySet(true);
							}
                            //Call plugin to show the component list ();
                            $('#all-baselines').hpsumInstallables(options);
                            var selectedComps = $('#all-baselines').hpsumInstallables('getSelectedComponents');
                        }
                        else {
							//saved installset is selected as baseline
                            //render only basic data 
                            renderNodeDeployWidget(nodeItem.baselines);
                            if (nodeItem.node_state != 'IDLE')
							{	
						
								if(nodeItem.type.match(/ilo/i)) {
									$(TAB_ILO_MANAGEMENT_OPTION_CONTAINER).hide();
                                    $(ILO_MANAGEMENT_OPTION).hide();
								    
									if(iloManagementOptionNeeded)
									{										
										$(TAB_ILO_MANAGEMENT_OPTION_CONTAINER).show();
								        $(ILO_MANAGEMENT_OPTION).show();
                                        showHideiLOOptionFullRecoverySet(false);										
																			
									}
									$(TAB_REBOOT_OPTION_CONTAINER).show();
									$(REBOOT_OPTIONS).show();
									$(TAB_INSTALLATION_OPTION_CONTAINER).show();
									$(INSTALLATION_OPTIONS).show();
									$(INSTALLATION_FORCE_OPTIONS).hide();
									$(TAB_INSTALLATION_OPTIONS).trigger('click');
									$(INSTALLATION_OPTIONS).show();
									$(SKIP_DEPENDENCY_CONTAINER).hide();
								}
								else if(nodeItem.type.match(/windows|linux/i))
								{
								    $(INSTALLATION_FORCE_OPTIONS).hide();
								    $(TAB_ILO_MANAGEMENT_OPTION_CONTAINER).hide();
								    $(ILO_MANAGEMENT_OPTION).hide();
								   if(iloManagementOptionNeeded)
									{		
										$(SCHEDULE_OPTIONS).show();
										$(TAB_ILO_MANAGEMENT_OPTION_CONTAINER).show();
								        $(ILO_MANAGEMENT_OPTION).show();
                                        showHideiLOOptionFullRecoverySet(false);										
									
										
									}

								}
							}
                        }
                    }

                    if (nodeItem.node_state === 'IDLE') {
                        if (item.hapi.baselines.length == 0) {
                            if (isPartOfGroup) {
                                warningMessage = localizer.getString('hpsum.easymode.partOfGroupMsgDeploy');

                            }
                            else {
                                warningMessage = localizer.getString("hpsum.node.noBaselineAvailable");
                            }
                            $(DEPLOY).attr('disabled', true);
                            shouldDisableDeploy = true;                            
                        }
                        else {
                            if (isPartOfGroup) {
                                $(DEPLOY).attr("disabled", true);
                                shouldDisableDeploy = true;
                                warningMessage = localizer.getString('hpsum.easymode.partOfGroupMsgDeploy');
                            }
                            else {
                                $(DEPLOY).attr("disabled", false);
                                warningMessage = '';
                            }

                        }
                    }
                    else if (nodeItem.node_state === 'UAN') {
                        //The problem is that getdata is called multiple times and there is a chance of changing Deploy button attributes in the following
                        //code. So adding conditions to check if the deploy button is enabled or not, based on this change the attribute
                        if ($(DEPLOY).attr("disabled") == "disabled")
                            $(DEPLOY).attr("disabled", true);
                        else
                            $(DEPLOY).attr("disabled", false);

                        //for UAN state if node is part of any group, disable all editable fields. 

                        if (isPartOfGroup) {
                            //disable the baseline editable items.
                            updateEditableFields(nodeItem, true);
                        }
                        else {
                            updateEditableFields(nodeItem, false);
                        }

                    }
                    else if (nodeItem.node_state == "REMOTE_STAGING_UAN") {
                        $(DEPLOY).attr("disabled", false);
                    }
                    else if (nodeItem.node_state === 'INSTALLDONE') {
                        $(DEPLOY).attr("disabled", true);
                    }
                    else {
                        $(DEPLOY).attr("disabled", true);
                    }

                    if (!isWarningsset) {
                        $(DEPLOY).attr("disabled", true);
                    }
                    //handle cleanupallonexist checkbox visibility. 
                    $('#li-hpsum-node-cleanupallonexit').hide();
                    $('#li-hpsum-node-cleanuponexit').hide();
                    if (nodeItem.node_state.match(/UAN|IDLE/i)) {
                        $('#li-hpsum-node-cleanuponexit').show();
                        if (nodeItem.type.match(/windows|linux/i) && !nodeItem.node_id.match(/N1localhost/i)) {
                            $('#li-hpsum-node-cleanupallonexit').show();
                        }
                    }
                    if (!nodeItem.type.match(/windows/i) || !isRegularBlSelectedForDeploy) {
                        $(COMPONENT_VERBOSE_DESCR).hide();
                        $(COMPVERBOSEOPTION).hide();
                    }
                    else {
                        $(COMPONENT_VERBOSE_DESCR).show();
                        $(COMPVERBOSEOPTION).show();
                    }

                    //change for installation option for ilo5.
                    if (nodeItem.node_state.match(/IDLE|UAN/i) && nodeItem.type.match(/ilo5/i)) {
                        $(TAB_INSTALLATION_OPTION_CONTAINER).show();
                        $(INSTALLATION_OPTIONS).show();
                        if (isRegularBlSelectedForDeploy) {
                            $(INSTALLATION_FORCE_OPTIONS).show();
                        }
                        $(TAB_INSTALLATION_OPTIONS).trigger('click');
                        $(INSTALLATION_OPTIONS).show();
                    }

                    //hide reboot option for stage action..
                    if (isStageSelected) {
                        $(TAB_REBOOT_OPTION_CONTAINER).hide();
                        $(REBOOT_OPTIONS).hide();
                        if (nodeItem.type.match(/ilo5/i)) {
                            $(TAB_ASSOCIATED_NODE_DETAILS).hide();
                        }
                        else
                        {
                            $(TAB_ASSOCIATED_NODE_DETAILS).show();
                        }
                    }
                    else {
                        if (nodeItem.type.match(/ilo5/i)) {
                            $(TAB_REBOOT_OPTION_CONTAINER).show();
                            $(REBOOT_OPTIONS).show();
                        }
                        $(TAB_ASSOCIATED_NODE_DETAILS).show();
                    }

                    //disable failed dependency checkbox if no failed dep components.  
                    if (nodeItem.node_state.match(/IDLE|UAN/i) && !isRegularBlSelectedForDeploy) {
                        $(SKIP_DEPENDENCY_CONTAINER).hide();  //hide skip dependency when its recovery set selected. 
                    }
                    else
                    {
                        $(SKIP_DEPENDENCY_CONTAINER).show();
                    }
                    if (failedDepCount > 0 && !isPartOfGroup) {
                        $(SKIP_DEPENDENCY_CHECKBOX).attr('disabled', false);
                    }
                    else {
                        if (nodeItem.node_state.match(/UAN/i)) {
                            $(SKIP_DEPENDENCY_CHECKBOX).attr('disabled', true);
                        }
                        else if(!isPartOfGroup){
                            $(SKIP_DEPENDENCY_CHECKBOX).attr('disabled', false);
                        }
                    }
					
					if (!isStageSelected && nodeItem.server_generation >= 10 || nodeItem.type.match(/ilo5/i))
					{
						if (nodeItem.type.match(/ilo5/i) && isRegularBlSelectedForDeploy)
						{
							$(SAVE_INSTALL_SET_CHECBOX)[0].checked = true;
                            if(!isPartOfGroup){
						        $(INSTALL_SET_NAME_TEXT).attr('disabled', false);
    						    $(INSTALL_SET_DESC_TEXT).attr('disabled', false);
						}
						}
						
						//Do validation to enable/disable 'UpdateRecoverySet' and display a appropriate hover over message when disabled.
						validateToUpdateRecoverySet(nodeItem);
					}
                }
                else {
                    notifications.show(localizer.getString('hpsum.node.pleaseSelectCorrectNode'), 'error');
                    $(DESCR).text("");
                    $(TYPE).text("");
                    $(DEPLOY).attr("disabled", true);
                    $(CANCEL).trigger('click');
                }
                checkForIgnoreWarning();
                $('#li-hpsum-deploy-page-tabs').css('padding-bottom', '1px');
              
            }//onItemChange
			
			
			function validateToUpdateRecoverySet(nodeItem) {
							$(UPDATE_RECOVERY_SET_DESCR).text(localizer.getString('hpsum.node.updateRecoverySet'));
							$(UPDATE_RECOVERY_SET_CHECKBOX).attr('disabled', true);
							$(UPDATE_RECOVERY_SET_DESCR).addClass('sum-disable-color-grey');							
							$(UPDATE_RECOVERY_ILO_CRDENTIALS_DETAILS).hide();
							$(UPDATE_RECOVERY_SET_CHECKBOX)[0].checked = false;
							
							//If "Save Install Set" option is not selected then just disable UpdateRecoverySet option and return.
							//No need to check for other conditions
							if(!$(SAVE_INSTALL_SET_CHECBOX).is(':checked') && !isInstallsetSelected )
							{								
								$(UPDATE_RECOVERY_SET_DESCR).attr('tooltip', localizer.getString('hpsum.node.updateRecDisableSaveInstallSetNotSelected')).hpTooltip();
								return;
							}
														
							var ilo_firm_ver = "";
							var ilo_credentials_available = false;
							
							if (nodeItem.type.match(/ilo5/i))
							{
								ilo_firm_ver = nodeItem.active_version.split(".");
								ilo_credentials_available = true;
							}
							else
							{
								ilo_firm_ver = nodeItem.node_ilo_firmware_version.split(".");
								ilo_credentials_available = nodeItem.ilo_credentials_available;
							}							
							
							var ilo_major_ver = parseInt(ilo_firm_ver[0]);
							var ilo_minor_ver = parseInt(ilo_firm_ver[1]);
							$(SCHEDULE_OPTIONS).attr('tooltip', '').hpTooltip();
							
							if(ilo_major_ver < ILO_MIN_MAJOR_VER_FOR_UPDATE_REC_SET || (ilo_major_ver == ILO_MIN_MAJOR_VER_FOR_UPDATE_REC_SET && ilo_minor_ver < ILO_MIN_MINOR_VER_FOR_UPDATE_REC_SET))
							{						
								//Disable "UpdateRecoverySet". Minimum iLO firmware version required is 1.30.
							    $(UPDATE_RECOVERY_SET_DESCR).attr('tooltip', localizer.getString('hpsum.node.updateRecSetDisableiLOVerErr')).hpTooltip();
							    $(SCHEDULE_OPTIONS).attr('tooltip', localizer.getString('hpsum.node.scheduleDisableiLOVerErr')).hpTooltip();
							    $('input[name=hpsum-schedule-options]').attr('disabled', true);
							}
							else if (ilo_credentials_available && !nodeItem.authorized_to_update_recovery_set)
							{
								//Disable "UpdateRecoverySet". Not authorized to update recovery set.
								$(UPDATE_RECOVERY_SET_DESCR).attr('tooltip', localizer.getString('hpsum.node.updateRecSetDisableAuthenticationErr')).hpTooltip();
							}
							else if (!nodeItem.node_recovery_set_present)
							{
								//Disable "UpdateRecoverySet". Currently not recovery set present.
								$(UPDATE_RECOVERY_SET_DESCR).attr('tooltip', localizer.getString('hpsum.node.updateRecSetDisableNoRecoverySetPresent')).hpTooltip();
							}
							else if (!nodeItem.recovery_component_present)
							{
								//Disable "UpdateRecoverySet". No component to update recovery set is present in current install set.
								//iLO, CPLD, BIOS, IE and ME components can update recovery set if processor type is Intel.
								//iLO, CPLD and BIOS components can update recovery set if processor type is AMD.
								$(UPDATE_RECOVERY_SET_DESCR).attr('tooltip', localizer.getString('hpsum.node.updateRecSetDisableNoRecoveryComponentPresent')).hpTooltip();
							}							
							else
							{
								//all good. Enable "UpdateRecoverySet" option.								
								$(UPDATE_RECOVERY_SET_CHECKBOX).attr('disabled', false);
								$(UPDATE_RECOVERY_SET_DESCR).removeClass('sum-disable-color-grey');
								$(UPDATE_RECOVERY_SET_DESCR).attr('tooltip', '').hpTooltip(); //required to remove the previous hover over message
							}
			} //validateToUpdateRecoverySet
			
            function checkForIgnoreWarning() {
                var message = '';
                shouldDisableDeploy = false;
                if (this != undefined && !$(this).is(':checked')) {
                    if (isStageSelected) {
                        message = localizer.getString('hpsum.advanceMode.StageDisabledDueToWarning');
                    }
                    else {
                        message = localizer.getString('hpsum.advanceMode.DeployDisabledDueToWarning');
                    }
					 }
					 else
					 {
						 if(shouldDisableDeploy)
						 {
							 message = warningMessage;
						 }
						 else
						 {
							formStateView.reset();
							$(DEPLOY).removeAttr('disabled');
						 }
					}

                	if (nodeItem.hasOwnProperty('warnings') && nodeItem.warnings.length > 0) {
                	    if (isPartOfGroup) {
                	        message = localizer.getString('hpsum.easymode.partOfGroupMsgDeploy');
                	    }
                	    else {
                	        if (isStageSelected) {
                	            message = localizer.getString('hpsum.advanceMode.StageDisabledDueToWarning');
                	        }
                	        else {
                	            message = localizer.getString('hpsum.advanceMode.DeployDisabledDueToWarning');
                	        }
                	    }
					}
					 if(message != '' && !nodeItem.node_state.match(/ilde/i)) 
					 {
					     for (var len = 0; len < nodeItem.warnings.length; len++) {
					         if (nodeItem.warnings[len].type.match(/server/i)) {
					             ignore_warnings_chkbox_needed = true;
					             break;
					         }
					     }
					     if (ignore_warnings_chkbox_needed) {
					         $(DEPLOY).attr('disabled', 'disabled');
					         formStateView.setMessage({
					             summary: message,
					             status: 'warning',
					             changing: false,
					         });
					         shouldDisableDeploy = true;
					     }
					 }
				}

			function resetTempData(){				
				scheduleDetails.tempAbort = false;
				tmpScheduleTime = "";
			}
			
			function tempAbortForScheduledNodes(item){
				$(SPLASH_SPINNER_TEMP_ABORT).dialog({
                    modal : true,
                    position : "center",
                    draggable : false,
                    resizable : false,
                    show : 'fade',
                    dialogClass : 'hp-splash-dialog',
                    width : 400
                });
				$(SPLASH_SPINNER_TEMP_ABORT).show();

				if(item.scheduled == "true")
				{
					scheduleDetailsIsSet = true;
					scheduleDetails.isScheduled = true;						
					scheduleDetails.tempAbort = true;
					if(scheduleDetails.schduledDateTime == "")
					{
						scheduleDetails.schduledDateTime = item.schedule_date_time;
					}
					scheduleDetails.baselines = item.baselines;
					scheduleDetails.stageMode = item.operation_mode;
				}
				if (! tempAbortInProgress) {
					   tempAbortInProgress = true;
					   var object = { hapi : { clearScheduleDateTime : false} };
					   presenter.abortAction(object,{
											success : function(){
												tempAbortInProgress = true;
												var progressTimer = setInterval(function () {
														var node_uri = "/Session/" + session.getToken() + "/node/" + item.node_id;
														rest.getURI(node_uri + "/getstatus", {
														success : function(data) {
															if(data.hapi.node_status.node_state === "UAN" || data.hapi.node_status.node_state === "REMOTE_STAGING_UAN")
															{													
																clearInterval(progressTimer);
																var newNodeData;
																	rest.getURI(node_uri + "/getdata",{
																		success : function(data) {
																			var NewNodeItem={hapi:data.hapi, node_state:data.hapi.node_state, node_phase:data.hapi.node_phase,
																				node_status:data.hapi.node_status, assoc_node_id:data.hapi.assoc_node_id};
																			onItemChange(NewNodeItem);
																			return;
																		},
																		error : function(errorInfo){
																			return;
																		}															
																	});
																
																
															}
														},
														error : function(errorInfo) {
															clearInterval(progressTimer);
															$(SPLASH_SPINNER_TEMP_ABORT).dialog('destroy');								
														}
													});
												}, 5000);												 
											},
											error : function(msg){
												$(SPLASH_SPINNER_TEMP_ABORT).dialog('destroy');	
											}
										});		   
				}
			
			
			}

			function renderNodeDeployWidget(item)
			{
			    //Calculate the Baseline details and render appropriately.
			    var nodeDeployWidget = {
			        command : 'renderBaselineData',			       
			            baselines : item,
			            nodes : [
                                    {
                                        nodeItem:nodeItem
                                    }
			            ]
			        
			    };
			    renderBaselineData(nodeDeployWidget);
			}
			//function to validate encryption key.
			function isEncryptionKeyValid()
			{
				var valid = true;
				//VC Encryption settings
				if(nodeItem.type.match(/virtual_connect/i) && nodeItem.is_config_password_required)
				{
					//enable deploy if valid encryption key entered
					if($('#hpsum-node-vc-encryption-key').val().length <= minEncryptionKeyLength)
					{
						valid = false;
					}
				}
				return valid;
			}
			
			function onSelectionChanged(id, value, componentList) {
			    if (!nodeItem.node_state.match(/idle/i)) {
			        invalidComponentsSelected = false;
			        var disableDeploy = false;
			        var advModeWarning = '';
			        if (value == true) {
			            isSelectionChanged = true;
			        }
			        selectedComponentsCount = componentList.component.length;
			        failedDependencyCount = componentList.failed_dependency;
					compNeedPrereqInstall=componentList.need_prereqinstall;
			        var isCompSigfileAvailable = componentList.is_sigfile_available;
					if (iloManagementOptionNeeded && $(SAVE_INSTALL_SET_CHECBOX).is(':checked')) {
							if(validateInstallSetNameandDesc())
							{
								if(isStageSelected)
								{
									advModeWarning = localizer.getString("hpsum.advanceMode.stageDisabledDueToNameDesc");
								}
								else
								{
									advModeWarning = localizer.getString("hpsum.advanceMode.deployDisabledDueToNameDesc");
								}
								disableDeploy = true;
							}
					}
					
					if (iloManagementOptionNeeded && $(UPDATE_RECOVERY_SET_CHECKBOX).is(':checked')) {
						if (nodeItem.server_generation >= 10 && !nodeItem.ilo_credentials_available)
						{
							if ($(UPDATE_RECOVERY_ILO_USERNAME).val() == "" || $(UPDATE_RECOVERY_ILO_PASSWORD).val() == "")
							{
								disableDeploy = true;								
								advModeWarning = localizer.getString("hpsum.advanceMode.deployDisabledDueToiLOCredentialsReqd");
							}
						}						
					}
					
			        if (failedDependencyCount > 0) {
			            //if selection is changed enable the deploy button irrespective of failed dependency
			            if (isSelectionChanged == true) {
			                // If there is only one failed dependency component and  is selected then disable the deploy button 
			                // If there are more components selected and if there is one of failed dependency component then enable the deploy button irrespective of failed dependency
			                disableDeploy = (selectedComponentsCount <= 1);
			                if (warningMsg === "" && disableDeploy) {
			                    advModeWarning = localizer.getString('hpsum.advanceMode.DeployDisabledDueToDependencyFailure') + warningMsg;
			                }
			                else {
			                    advModeWarning = '' + warningMsg;
			                }
			            }
			            else {
			                disableDeploy = true;

			                if (isStageSelected) {
			                    advModeWarning = localizer.getString('hpsum.advanceMode.StageDisabledDueToDependencyFailure') + warningMsg;
			                }
			                else {
			                    advModeWarning = localizer.getString('hpsum.advanceMode.DeployDisabledDueToDependencyFailure') + warningMsg;
			                }
			            }
			        }
			        if (!isEncryptionKeyValid()) {
			            disableDeploy = true;
			            advModeWarning = localizer.getString('hpsum.advanceMode.InvalidEncryptionKey') + warningMsg;
			        }
			        if (componentList.component.length < 1 && selectedAssociatedNodes.length < 1) {
			            disableDeploy = true;
			            if (isStageSelected) {
			                advModeWarning = localizer.getString('hpsum.advanceMode.StageDisabledDueTonoComponentsSelected');
			            }
			            else {
			                advModeWarning = localizer.getString('hpsum.advanceMode.noComponentsSelectedFromAdvMode');
			            }
			            // if its moonshot node type, just display warning_message. don't append it to existing message.
			            if (nodeItem.type.match(/moonshot/i) && warningMsg != '') {
			                advModeWarning = warningMsg;
			            }
			            else {
			                advModeWarning = advModeWarning + warningMsg;
			            }
			        }

			        //check for compsig file if its gen10 server.
			        if (iloManagementOptionNeeded)
			        {
			            if (isCompSigfileAvailable === false)
			            {
			                invalidComponentsSelected = true;
			            }
			            if (!isCompSigfileAvailable && componentList.is_typec_comp_selected)
			            {
			                invalidComponentsSelected = true;
			            }
			            if (((($(SAVE_INSTALL_SET_CHECBOX).is(':checked') || nodeItem.type.match(/ilo5/i)) && !isCompSigfileAvailable )|| (!isCompSigfileAvailable && componentList.is_typec_comp_selected)))
			            {   
			                disableDeploy = true;
			                if (isStageSelected) {
			                    advModeWarning = localizer.getString('hpsum.advanceMode.StageDisabledDueToMissingSigFile') + warningMsg;
			                }
			                else {
			                    advModeWarning = localizer.getString('hpsum.advanceMode.deployDisabledDueToMissingSigFile') + warningMsg;
			                }
			            }			           
			        }
					if (skip_prereqs && compNeedPrereqInstall)
					{
						 disableDeploy = true;
						 if (isStageSelected) {
					        advModeWarning = localizer.getString('hpsum.advanceMode.StageDisabledAsNoPrereqInstallPermission');
					    }
					    else {
					        advModeWarning = localizer.getString('hpsum.advanceMode.DeployDisabledAsNoPrereqInstallPermission');
					    }
					}
					
			        if (advModeWarning === "" && warningMsg !== "") {
			            advModeWarning = warningMsg;
			        }			      

			        if (isPartOfGroup) {
			            disableDeploy = true;
			            advModeWarning = localizer.getString("hpsum.easymode.partOfGroupMsgDeploy"); //if node is part of group, message should be part of group. not the other messages. 
			        }
					
			        var item = {
			            disableDeploy: disableDeploy,
			            formStateViewMessage: advModeWarning
			        };			        
			        shouldEnableDeployment(item);
			        // Block deploy button if there is any unchecked ignore warnings checkbox
			        // save disabled status to enable recovery it if ignore warnings changed
                    			      
			        shouldDisableDeploy = disableDeploy;
			        $(DEPLOY).attr("disabled_org", $(DEPLOY)[0] && disableDeploy ? 1 : 0);

			        var selChangeOption = {
			            command: 'onSelectionChange',
			            selectedComponents: componentList
			        };
			        onSelectionChange(selChangeOption);
			        renderCriticalityDetails();			       
			    }
			}

			function updateTabsForBaselineSelected(isRegBaselineSelected)
			{
			    $(TAB_INSTALLATION_OPTION_CONTAINER).show();
			    $(INSTALLATION_OPTIONS).show();
			    $(INSTALLATION_FORCE_OPTIONS).show();
			    if (isRegBaselineSelected)
			    {  
			        if (iloManagementOptionNeeded)
			        {
			            $(TAB_ILO_MANAGEMENT_OPTION_CONTAINER).show();
			            $(ILO_MANAGEMENT_OPTION).show();
			        }
			        $(TAB_INSTALLATION_OPTIONS).trigger('click');
			    }
			    else
			    {  
			        $(TAB_ILO_MANAGEMENT_OPTION_CONTAINER).hide();
			        $(ILO_MANAGEMENT_OPTION).hide();
			        //$(TAB_SCHEDULE_OPTIONS).trigger('click');
			    }
			}
			
            function showInstallationOptions(data, isInitialRebootOptionsLoaded){
            	//send getattributes for this node
                var rewriteOption = "";
				var downgradeOption = "";
				var firmwareOption = "";
				var softwareOption = "";
				var forceFirmware = "";
				var forceSoftware = "";
            	if(data && data.hasOwnProperty("hapi"))
            	{
					if(data.hapi.hasOwnProperty("reboot_options") && data.hapi.reboot_options)
					{
						$('#hpsum-reboot-option option').filter(function() {
						// showInstallationOptions is called everytime for getattributes command and overwrides the user changes 
						// isInitialRebootOptionsLoaded is true means already reboot options are loaded for first get attribute command
						// Do not change the user selection and lets keep the user changes 
			             if(isInitialRebootOptionsLoaded && new RegExp(this.value, 'ig').test( data.hapi.reboot_options.action))
		    		            $(this).attr('selected', true);
		                  });
						}
					if( (isBaselineSelected || isRegularBlSelectedForDeploy) && data.hapi.hasOwnProperty("installation_option") && data.hapi.installation_option){
                        rewriteOption = data.hapi.installation_option.rewrite;
						downgradeOption = data.hapi.installation_option.downgrade;
						firmwareOption = data.hapi.installation_option.firmware;
						softwareOption = data.hapi.installation_option.software;
						forceFirmware = data.hapi.installation_option.forcefirmware;
						forceSoftware = data.hapi.installation_option.forcesoftware;
						if (data.hapi.installation_option.ignore_warnings) {
						    if (isWarningsset) {
						        $('.ignorewarnings').attr('checked', true);
						    }
						    else if (nodeItem.node_state.match(/idle/i) && isWarningsset) {
						        $(IGNORE_WARNING_CHECKBOX).prop('checked', true);
						}
					}
						if ( !rewriteOption  && !downgradeOption )
						{
							$(INSTALLATIONOPTION).val('upgradeBoth');
							if(firmwareOption && softwareOption){
								$(INSTALLATIONOPTION).val('upgradeBoth');
							}
							else if(firmwareOption){
								$(INSTALLATIONOPTION).val('upgradeFirmware');
							}
							else if(softwareOption){
								$(INSTALLATIONOPTION).val('upgradeSoftware');
							}
						}
						else if ( rewriteOption  && downgradeOption )
						{
							if(firmwareOption && softwareOption)
								$(INSTALLATIONOPTION).val('both');
							else if(firmwareOption)
								$(INSTALLATIONOPTION).val('firmware');
							else if(softwareOption)
								$(INSTALLATIONOPTION).val('software');
						}
						else if ( rewriteOption )
						{
							if(firmwareOption && softwareOption)
								$(INSTALLATIONOPTION).val('rewriteBoth');
							else if(firmwareOption)
								$(INSTALLATIONOPTION).val('rewriteFirmware');
							else if(softwareOption)
								$(INSTALLATIONOPTION).val('rewriteSoftware');
						}
						else if ( downgradeOption )
						{
							if(firmwareOption && softwareOption)
								$(INSTALLATIONOPTION).val('downgradeBoth');
							else if(firmwareOption)
								$(INSTALLATIONOPTION).val('downgradeFirmware');
							else if(softwareOption)
								$(INSTALLATIONOPTION).val('downgradeSoftware');

						}
										
						$(INSTALLATIONOPTION).selectBox('reset');										
					}
					if(data.hapi.hasOwnProperty("vc_activation_options") && data.hapi.vc_activation_options){
						$('#hpsum-Enet-order option').filter(function() {
			             if(new RegExp(this.value, 'ig').test( data.hapi.vc_activation_options.eth_activation_order))
		    		            $(this).attr('selected', true);
		                  });
		                 $('#hpsum-fc-order option').filter(function() {
			             if(new RegExp(this.value, 'ig').test( data.hapi.vc_activation_options.fc_activation_order))
		    		            $(this).attr('selected', true);
		                  });
						$('#hpsum-Enet-delay').val(data.hapi.vc_activation_options.eth_activation_delay);
						$('#hpsum-FC-delay').val(data.hapi.vc_activation_options.fc_activation_delay);
					}

					var skipCompsWithDepFailure = '';
					var nondisruptive = false;
					var rebootDelay = REBOOT_DELAY_SEC / 60;
                    var rebootAction = 'Never';
                    var rebootDescr = "";
					if (data.hasOwnProperty("hapi")) {
						if (data.hapi.hasOwnProperty("failed_dependency_handling")) {
							skipCompsWithDepFailure = data.hapi.failed_dependency_handling;
						}
						if (data.hapi.hasOwnProperty("installation_option")) {
							nondisruptive = data.hapi.installation_option.nondisruptive;
						}
						
						// isInitialRebootOptionsLoaded is true means already reboot options are loaded for first get attribute command
						// Do not reset the user changes and lets keep the user changes 
						if (isInitialRebootOptionsLoaded){
							if (data.hapi.hasOwnProperty("reboot_options") && data.hapi.reboot_options.delay != -1) {
								rebootDelay = data.hapi.reboot_options.delay;
								rebootAction = data.hapi.reboot_options.action;
								rebootDescr = data.hapi.reboot_options.message;
							}						
							//initialize reboot options, cleanup on exit and other options. 
							$(REBOOTOPTION).selectBox('value', rebootAction);
							if (!rebootAction.match(/never/i))
							{
								$(DELAYMINUTES).prop("disabled", false);
							}
							else
							{
								$(DELAYMINUTES).prop("disabled", true);
							}
							var rebootMsg = 'Rebooting at user request in order to activate deployed firmware or software';
							if (data.hapi.reboot_options.message.match(rebootMsg))
							{
								$(DELAYMSG).attr('value', localizer.getString('hpsum.node.rebootMessage'));
							}
							if (-1 < data.hapi.reboot_options.delay) {
								$(DELAYMINUTES).val(data.hapi.reboot_options.delay / 60);
							}
							else {
								$(DELAYMINUTES).val(REBOOT_DELAY_SEC / 60);
							}
						}
					    //initialize cleanup_onexit and cleanupall_onexit.                         
						$(CLEANUP_ALLONEXIT).prop('checked', cleanupallonexit);
						$(CLEANUP_ONEXIT).prop('checked', cleanuponexit);
            	    }
				}
            }
			
			function getNoChangeFlag()
			{
                var itemSelectionChanged = false;
				if(rebootSelectionChanged || isSelectionChanged)
				{
					itemSelectionChanged = true;
				}
                else if (isIgnoreWarningOrVerboseOptChanged()) 
				{
					itemSelectionChanged = true;
				}
				else if( ($(VC_ENCRYPTION_KEY).val().length > 0) || ($(HPSUM_ENET_ORDER).val() != 'oddeven') || ($(HPSUM_ENET_DELAY).val() != "0") || ($(HPSUM_FC_ORDER).val() != 'serial') || ($(HPSUM_FC_DELAY).val() != "0"))// add check for vc details modification. 
				{
					itemSelectionChanged = true;
				}
				
                return itemSelectionChanged;
			}
			
			function errormsg()
			{
				$(INSTALL_ERROR).hide();
			}

			function showAnalysisSplash(flag)
			{
				$(SPLASH_DIALOG).dialog({
			        modal : true,
			        position : "center",
			        draggable : false,
			        resizable : false,
			        show : 'fade',
					closeOnEscape: false,
			        dialogClass : 'hp-splash-dialog',
			        width : 400
			    });
				if(flag)
					$('#hpsum-splash-message').html(localizer.getString("hpsum.group.applyingInstallationOptions"));
				else
					$('#hpsum-splash-message').html(localizer.getString("hpsum.group.applyingSelectionChanges"));

				if(resetaction == 'cancel' || resetaction == 'changemode') {
					$('#hpsum-splash-message').html("Resetting All User Selections");
				}
			    $(SPLASH_SPINNER).show();	
			}
			
			function closeAnalysisSplash(){
				$(SPLASH_SPINNER).hide();
				try {
					$(SPLASH_DIALOG).dialog('destroy');
				} catch(e) {}
			}
			
			//Apply Installation Options
			function applyInstallationOptions()
			{
				applyOptions = true;
				deploy_flag = false;
				if(!nodeItem.type.match(/integrityilo|virtual_connect|ipdu|OA|sd2oa|ilo|switch|SAS_SWITCH/i) || nodeItem.type.match(/ilo5/i)) {
				    getInstallationOptions(nodeItem);
				}
				ForceOptions.hapi.failed_dependency_handling = skipdependency;

				if(initialGetattr.hapi.installation_option.downgrade != ForceOptions.hapi.installation_option.downgrade ||
					initialGetattr.hapi.installation_option.rewrite != ForceOptions.hapi.installation_option.rewrite ||
					initialGetattr.hapi.installation_option.software != ForceOptions.hapi.installation_option.software ||
					initialGetattr.hapi.installation_option.firmware != ForceOptions.hapi.installation_option.firmware ||
					initialGetattr.hapi.installation_option.nondisruptive != ForceOptions.hapi.installation_option.nondisruptive ||
					initialGetattr.hapi.failed_dependency_handling != ForceOptions.hapi.failed_dependency_handling) {

					presenter.setattribute(nodeItem,ForceOptions, {
						success : function(data) {
							if(resetaction == 'cancel' || resetaction == 'changemode') {
								var progressTimer = setInterval(function () {
								var node_uri = "/Session/" + session.getToken() + "/node/" + nodeItem.node_id;
								rest.getURI(node_uri + "/getstatus", {
								success : function(data) {

									if(data.hapi.node_status.node_state === "UAN" || data.hapi.node_status.node_state == "REMOTE_STAGING_UAN")
									{
										handleResetAction();
										nodeItem.node_state = data.hapi.node_status.node_state;
										clearInterval(progressTimer);
									}
								},
								error : function(errorInfo) {	
								}
							});
							}, 3000);
							}
						},
						error : onsetattributeerror
					});
				    var msg = localizer.getString("hpsum.node.installationOptions.applyingOptions");
				    if (initialGetattr.hapi.failed_dependency_handling != ForceOptions.hapi.failed_dependency_handling) {
				        msg = localizer.getString("hpsum.easymode.SkippingDependencies");
				        formStateView.setMessage({
				            summary: msg,
				            status: 'ok',
				            changing: true,
				        });
				        showAnalysisSplash();
				    }
				    else {
				        formStateView.setMessage({
				            summary: msg,
				            status: 'ok',
				            changing: true,
				        });
				        showAnalysisSplash(true);
				    }
					getNodeStatus();
				}
			}
			
			function handleResetAction() {
				if( resetaction == 'cancel')
				{
					router.go(urlFragment.replaceView(router.location(), 'show'));
				}
										
				resetaction = '';
			}
			
			function isIloManagementeOptionsChanged()
			{
			    var valueChanged = false;
				if(initialGetattr.hapi.hasOwnProperty('ilo_management_options'))
				{
					if((initialGetattr.hapi.ilo_management_options.clear_ilo_update_list != optiondetails.hapi.ilo_management_options.clear_ilo_update_list) ||
						(initialGetattr.hapi.ilo_management_options.manually_manage_iLO_repository != optiondetails.hapi.ilo_management_options.manually_manage_iLO_repository) ||
						(initialGetattr.hapi.ilo_management_options.save_install_set != optiondetails.hapi.ilo_management_options.save_install_set) ||
						(initialGetattr.hapi.ilo_management_options.install_set_name != optiondetails.hapi.ilo_management_options.install_set_name) ||
						(initialGetattr.hapi.ilo_management_options.install_set_description != optiondetails.hapi.ilo_management_options.install_set_description) ||
						(optiondetails.hapi.ilo_management_options.hasOwnProperty('installset_ids_for_delete') && optiondetails.hapi.ilo_management_options.installset_ids_for_delete.length > 0))
					{
						valueChanged = true;
					}
				}
			    return valueChanged;
			}

			function isIgnoreWarningOrVerboseOptChanged()
			{
				var valueChanged = false;
				if(((optiondetails.hapi.hasOwnProperty('ignore_warnings')) && (initialGetattr.hapi.ignore_warnings != optiondetails.hapi.ignore_warnings)) || 
				(nodeItem.type.match(/OA|VIRTUAL_CONNECT|ilo|switch|SAS_SWITCH/i) && selectedAssociatedNodes.length > 0) || 
					($(COMPVERBOSEOPTION).is(':checked')))
					{
						valueChanged = true;
					}
					return valueChanged;
			}

			function isSetAttributesNeeded()
			{   
				var setAttributesNeeded = false;
				if((initialGetattr.hapi.reboot_options.action != optiondetails.hapi.reboot_options.action) ||
					(initialGetattr.hapi.reboot_options.delay != optiondetails.hapi.reboot_options.delay) ||
					(initialGetattr.hapi.ignore_warnings != optiondetails.hapi.ignore_warnings) ||
                    (nodeItem.type.match(/OA|VIRTUAL_CONNECT|ilo|switch|SAS_SWITCH/i) && selectedAssociatedNodes.length > 0) ||	
					nodeItem.type.match(/virtual_connect|integrityilo/i) || 
					($(COMPVERBOSEOPTION).is(':checked')) || isIloManagementeOptionsChanged())
					{
						setAttributesNeeded = true;
					}

				if (isTaskQueueSelected)
				{
				    var baselineJson = [];
				    baselineJson.push(newBaseline.id);
				    baselineDetails.hapi.baselines = {};
				    baselineDetails.hapi.baselines.baseline = baselineJson;
				    baselineDetails.hapi.baselines.remove_existing_baselines = true;				    
				    optiondetails.hapi.baselines = baselineDetails.hapi.baselines;
				    setAttributesNeeded = true;
				}
				return setAttributesNeeded;
			}
			function analysis() {
			    
				//populate the option details into the optiondetails object from UI
				setoptiondetails(nodeItem);
				//this function will verfiy if any of reboot options / ignore warnings / COMPVERBOSEOPTION is changed for which we need to set attributes
				var setAttributesNeeded = isSetAttributesNeeded();
				//Get the schedule information for the node
				//setscheduleoptions(nodeItem);
                if(setAttributesNeeded || isSelectionChanged )
                    showAnalysisSplash();
				//send the setattribute command to engine
				if(setAttributesNeeded) {
						presenter.setattribute(nodeItem,optiondetails, {
							success : function(data) {
								if((isSelectionChanged && selectedComponentsCount > 0))
								{
									doAnalysis();
								}
								else
								{
									closeAnalysisSplash();
									onDeployContinue();
								}
							},
							error : onsetattributeerror
						});
				} else {
					doAnalysis();
				}
			}
			
			function doAnalysis()
			{
				if(isSelectionChanged){
					var inst = $('#all-baselines').data('plugin_hpsumInstallables');
					var componentsList = inst.getComponents();
					presenter.analysis(nodeItem, componentsList, {
						node_id: nodeItem.node_id,
						success : function(data) {
							analyzeSuccess(data, this.node_id);
							isSelectionChanged = false;
							analysisDone = true;
							getNodeStatus();
						},
						error : function(errorInfo) {
							analyzeError(errorInfo);
                            isSelectionChanged = false;
						}
					});
				} 
				else
				{
					onDeployContinue();
				}
			}
			
			function getNodeStatus()
			{
				var progressTimer = setInterval(function () {
					var node_uri = "/Session/" + session.getToken() + "/node/" + nodeItem.node_id;
					rest.getURI(node_uri + "/getstatus", {
						success : function(data) {
							if(data.hapi.node_status.node_state === "ANALYSIS")
							{
							}
							else if(data.hapi.node_status.node_state === "UAN" || data.hapi.node_status.node_state == "REMOTE_STAGING_UAN" )
							{
								nodeItem.node_state = data.hapi.node_status.node_state;
								clearInterval(progressTimer);
								closeAnalysisSplash(); 
								if(data.hapi.node_status.node_state === "UAN"){
									$('#all-baselines').hpsumInstallables('recalculate');
									reRenderBaselineDetails = true;
								}
								if(applyOptions)
								{
									skipInstallOptions = false;
									formStateView.setMessage({
										summary: localizer.getString("hpsum.node.installationOptions.optionsSuccess"),
										status: 'ok',
										changing: false,
									});
									applyOptions = false;
									loadAttributes();
								}
							  }
							else if(data.hapi.node_status.node_state === "ERROR")
							{
								clearInterval(progressTimer);
								closeAnalysisSplash();
							}
						},
						error : function(errorInfo) {
										
						}
					});
		        }, 3000);
			}
		    
			function analyzeSuccess(data, nodeid) {
			
			}
			
			function analyzeError(error) {
				$(SPLASH_SPINNER).hide();
				$(SPLASH_DIALOG).dialog('destroy');
			}
			
			function onPopulateInstallSet(node_id)
			{
                var install = $('#all-baselines').data('plugin_hpsumInstallables');
				failedDependencyCount = install.failedDependencyCount();
				
                if(deploy_flag)
				{
					//adding [|| mode == 'easy'] to fix QXCR1001419413. Deploy command to engine was not going from easy mode as  fields failedDependencyCount and selectedComponentsCount will not get updated to correct values after setAttributes from easy mode.
					if((mode == 'expert' && failedDependencyCount <= 0 && selectedComponentsCount > 0))
					{
						var resetplugindefaults = {
						command : 'resetplugindefaults',
							args : {
							}
						};
						//$("#hpsumDeployNode-plugin-container").hpsumDeployNode(resetplugindefaults);
						$(DEPLOY).attr("disabled", true);
						onDeployContinue();
					}
					deploy_flag = false;
				}
			}
			
			function validateTime() {
			    var time_val = $(SCHEDULE_TIME).val();
			    var time_parse = time_val.split(':');
			    var time_pattern = /^([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]$/;
			    $(DEPLOY).attr("disabled_org", 0);
			    if (!time_val.match(time_pattern)) {
			        $(SCHEDULE_TIME_LABEL).addClass("hp-error");
			        $(SCHEDULE_TIME_LABEL).show();
			        $(ANALYSIS).attr("disabled", true);
			        $(DEPLOY).attr("disabled", true);
			        $(DEPLOY).attr("disabled_org", 1);
			    }
			    else {
			        var time_hrs = time_parse[0];
			        var time_mins = time_parse[1];
			        if (time_hrs >= 12) {
			            if (time_hrs == 12)
			                schedule_time = time_hrs + ':' + time_mins + ' ' + 'PM';
			            else {
			                var time_hrs_old = time_hrs - 12;
			                if ((time_hrs_old) <= 9)
			                    schedule_time = '0' + time_hrs_old + ':' + time_mins + ' ' + 'PM';
			                else
			                    schedule_time = time_hrs_old + ':' + time_mins + ' ' + 'PM';
			            }
			        }
			        else if (time_hrs == 0) {
			            schedule_time = (parseInt(time_hrs) + 12) + ':' + time_mins + ' ' + 'AM';
			        }
			        else if (time_hrs < 12) {
			            schedule_time = time_hrs + ':' + time_mins + ' ' + 'AM';
			        }
			        $(ANALYSIS).removeAttr('disabled');
			        if (!isWarningsset) {
			            $(DEPLOY).attr('disabled', 'disabled');
			        }
			    }
			}



                        function validateRebootDelay() {
                            var rebootopt = $('#hpsum-reboot-option option:selected').val();
                            var delayMinutes = $(DELAYMINUTES).val();
                            var valid = true;
                            var disableDeploy = false;
                            if (rebootopt != "Never") {
                                if((isNaN(delayMinutes) && !isFinite(delayMinutes)) ||
                                  (delayMinutes < 1 || delayMinutes > 60)) {
                                    $(DEPLOY).attr("disabled", true);
                                    $(DELAYMINUTES).addClass("hp-error");
                                    $(DELAYSECERR).text(localizer.getString("hpsum.node.rebootDelaySecondsErrMsg"));
                                $(DELAYSECERR).show();
                                    valid = false;
                    }
                    else {
						$(DELAYMINUTES).val(parseInt(delayMinutes));
						$(DELAYMINUTES).removeClass("hp-error");
                                $(DELAYSECERR).hide();
                                if(selectedComponentsCount > 0 && failedDependencyCount == 0)
                                    {
                                    disableDeploy = false;
                                }
						else
						{
						    if(!nodeItem.node_state.match(/idle/i)) { // if its direct deploy page, components selected will not be considered. 
                                        disableDeploy = true;
						    }
						    }
						var item = {
						        disableDeploy: disableDeploy
						        };
                                            shouldEnableDeployment(item);
                        }
                            }
                            shouldDisableDeploy = disableDeploy;
                            $(DEPLOY).attr("disabled_org", $(DEPLOY)[0] && disableDeploy ? 1 : 0);
				return valid;
            }
			
			function validateScheduleDetails()
			{
				var shouldDisableDeploy = true;
				var warnMsg = localizer.getString("hpsum.advanceMode.deployDisabledDueToScheduleDateTime");	
				var isScheduled = $('#schedule').hpsumSchedule('isScheduleSelected');
				var scheduleFromDateTime, scheduleToDateTime;
				if( nodeItem.node_state === 'UAN' && isScheduled)
				{
					scheduleFromDateTime = $('#schedule').hpsumSchedule('getScheduleDateTime', true);
					scheduleToDateTime = $('#schedule').hpsumSchedule('getScheduleDateTime', false);

					if ($('#schedule').hpsumSchedule('validateUserEnteredTime')) {
						shouldDisableDeploy = false;
						warnMsg = "";
					}
					else
					{
					    shouldDisableDeploy = true;
					}
				}
				else
				{
					shouldDisableDeploy = false;
					warnMsg = "";
				}
				var itemVal = {
					disableDeploy: shouldDisableDeploy,
					formStateViewMessage: warnMsg
				}
				shouldEnableDeployment(itemVal);
			    // Block deploy button if there is any unchecked ignore warnings checkbox
				$(DEPLOY).attr("disabled_org", $(DEPLOY)[0] && shouldDisableDeploy ? 1 : 0);
				return shouldDisableDeploy;
			}
			function validateInstallSetNameandDesc() 
			{
				// Validate the Install Set Name and Description- Should not be empty, should not be above 63 chars of length
				// Should not contain any special characters. 
				var validName = false, validDesc = false;
				var warnMsg = "";
				var disableDeploy = false;
				validName = handleErrors(INSTALL_SET_NAME_TEXT, INSATLLSET_NAME_REQUIRED);
				validDesc = handleErrors(INSTALL_SET_DESC_TEXT, INSTALLSET_DESC_REQUIRED);

				if(validName || validDesc)
				{
				    disableDeploy = true;
				    warnMsg = localizer.getString("hpsum.advanceMode.deployDisabledDueToNameDesc");
				}
				else
				{
					// If there are no components selected disable when there is changes in installset name and desciption
					shouldDisableDeploy = (selectedComponentsCount > 0 ? false : true);
					warnMsg = "";
				}
				var itemVal = {
				    disableDeploy: disableDeploy,
					formStateViewMessage: warnMsg
				}				
				if (disableDeploy) {
				    shouldEnableDeployment(itemVal);
				    // Block deploy button if there is any unchecked ignore warnings checkbox
				    $(DEPLOY).attr("disabled_org", $(DEPLOY)[0] && disableDeploy ? 1 : 0);
				}
				else {
				    updateDeployButtonState();
				}
				return disableDeploy;
			}
			function handleErrors(NameorDesc, itemToDisplay)
			{
			    var stringToCheck  = $(NameorDesc).val();
				var errorFound = false;
				if (stringToCheck.trim() == "") 
				{
					$(itemToDisplay).text(localizer.getString("hpsum.node.required"));
					errorFound = true;
				}
				else if(!(stringToCheck.match(new RegExp(/^[A-Za-z0-9.\-_() ]*$/i))))
				{
					$(itemToDisplay).text(localizer.getString("hpsum.node.validNameDesc"));
					errorFound = true;
				}
				else if(stringToCheck.length > MAX_LENGTH)
				{
					$(itemToDisplay).text(localizer.getString("hpsum.node.maxlen", [MAX_LENGTH]));
					errorFound = true;
				}
				//Display the error if any
				if(errorFound == true && ($(SAVE_INSTALL_SET_CHECBOX).is(':checked')))
				{
					$(itemToDisplay).show();
					$(NameorDesc).addClass('hp-error');
					
				}
				else
				{
					$(itemToDisplay).hide();
					$(NameorDesc).removeClass('hp-error');
				}
				return (errorFound && !isInstallsetSelected && !isTaskQueueSelected);
			}
			function setscheduleoptions(nodeItem) {
			
				var scheduled = "no";
				var date = "";
				var time = "";
				
				if($(SCHEDULETOGGLE).attr('checked') === "checked")
					scheduled = 'yes';
				else
					scheduled = 'no';
				
				if(scheduled_getdata_date_time == ""){
					scheduled_getdata_date_time = " ";
					schedaction = 'create';
					}
				else
					schedaction = 'update';
				
				if(scheduled === "yes"){
					date = $(SCHEDULE_DATE).val();
					validateTime();
					time = schedule_time;
				}
				
				var schedule_information = {date:date, time:time};
				var schedule_date_time = date + ' ' + time;
				if(scheduled !== scheduled_getdata || scheduled_getdata_date_time !== schedule_date_time)
					presenter.ScheduleNodes(nodeItem.node_id,schedaction,scheduled,schedule_information, {
						success : function(data) {
							onScheduleNodesSuccess(data); 
						},
						error : function(errorInfo) {
								onScheduleNodesError(errorInfo);
							}
					});
			}
			
			function loadScheduleoptions(nodeItem){
				var scheduled_date_time_split;
				var scheduled_time;
				var scheduled_date;
				var scheduled_time_hrs_mins;
				var scheduled_time_hrs;
				var scheduled_time_mins;
				scheduled_getdata_date_time = nodeItem.schedule_date_time;
				scheduled_getdata = nodeItem.scheduled;
				if(scheduled_getdata === "false")
				{
					scheduled_getdata = "no";
					$(DEPLOY).val(localizer.getString('hpsum.node.deploy'));
					if($(SCHEDULETOGGLE).attr('checked') === "checked"){
						$(SCHEDULETOGGLE).click();	
						$(SCHEDULETOGGLE).removeAttr("checked");
					}
				}
				else if(scheduled_getdata === "true")
				{
					scheduled_getdata = "yes";
					$(DEPLOY).val(localizer.getString('hpsum.node.scheduledeploy'));
					if($(SCHEDULETOGGLE).attr('checked') === undefined){
						$(SCHEDULETOGGLE).click();	
						$(SCHEDULETOGGLE).attr("checked","checked");
					}
				}
				if(scheduled_getdata_date_time === "")
				{
					$(SCHEDULE_DATE).val('');
					$(SCHEDULE_TIME).val('');
				}	
				else
				{	
					scheduled_date_time_split = scheduled_getdata_date_time.split(' ');
					scheduled_date = scheduled_date_time_split[0];
					scheduled_time = scheduled_date_time_split[1];
					scheduled_time_hrs_mins = scheduled_time.split(':');
					scheduled_time_hrs = scheduled_time_hrs_mins[0];
					scheduled_time_mins = scheduled_time_hrs_mins[1];
					
					var scheduled_time_hrs_new;
					var scheduled_time_new;						
					
					if (scheduled_date_time_split[2] == 'PM')
					{
						if (scheduled_time_hrs < 12)
						{
							scheduled_time_hrs_new = parseInt(scheduled_time_hrs) + 12;	
							scheduled_time_new = scheduled_time_hrs_new + ':' + scheduled_time_mins;
						}
						else if ( scheduled_time_hrs == 12)
						{
							scheduled_time_hrs_new = parseInt(scheduled_time_hrs) + 0;	
							scheduled_time_new = scheduled_time_hrs_new + ':' + scheduled_time_mins;
						}
					}
					else if ( scheduled_date_time_split[2] == 'AM')
					{
						if ( scheduled_time_hrs == 12)
						{
							scheduled_time_hrs_new = parseInt(scheduled_time_hrs) - 12;
							scheduled_time_new = '0' + scheduled_time_hrs_new + ':' + scheduled_time_mins;
						}
						else if ( scheduled_time_hrs < 12)
						{
							if ( scheduled_time_hrs < 10 )
							{
								scheduled_time_hrs_new = parseInt(scheduled_time_hrs) + 0;
								scheduled_time_new = '0' + scheduled_time_hrs_new + ':' + scheduled_time_mins;
							}
							else
							{
								scheduled_time_hrs_new = parseInt(scheduled_time_hrs) + 0;
								scheduled_time_new = scheduled_time_hrs_new + ':' + scheduled_time_mins;
							}
						}
					}

					$(SCHEDULE_DATE).val(scheduled_date);
					$(SCHEDULE_TIME).val(scheduled_time_new);
				}
			}
			
			function onScheduleNodesError(errorMessage)
			{
				notifications.show(errorMessage, 'error');                          
				$(ANALYSIS).attr("disabled", false);
				$(DEPLOY).attr("disabled", false);	
				$(CANCEL).trigger('click');	
			}

			function onScheduleNodesSuccess(data)
		    {
				var message;	
				$(DEPLOY).val(localizer.getString('hpsum.node.scheduledeploy'));
				if(schedaction === "create")
					message = "Schedule for " + nodeItem.name + " created successfully";
				if(schedaction === "update")
					message = "Schedule for " + nodeItem.name + " updated successfully";  
				notifications.show(message, 'ok');  
			}	
			
			function toggleSchedule(cb)
            {
            	if(cb.target.checked)
            		$(DATETIMESECTION).show();
            	else
            		$(DATETIMESECTION).hide();
				$(ANALYSIS).removeAttr('disabled');
                $(DEPLOY).attr('disabled','disabled');
            }

			function setoptiondetails(nodeItem)
			{
			    if((nodeItem.hasOwnProperty('activate_sfw')) || (nodeItem.type.match(/windows|linux|ilo5|vmware|hpux/i))){
			        optiondetails.hapi.reboot_options = {};
			        optiondetails.hapi.reboot_options.action = $(REBOOTOPTION).val();
			        optiondetails.hapi.reboot_options.delay = $(DELAYMINUTES).val() * 60;
			        optiondetails.hapi.reboot_options.message = $(DELAYMSG).val();
				}
				
				if($(COMPVERBOSEOPTION).is(':checked'))
				{
					optiondetails.hapi.verbose = true;
				}
				
				optiondetails.hapi.ignore_warnings = false;
				if ($(".ignorewarnings")[0]) {
					optiondetails.hapi.ignore_warnings = $(".ignorewarnings").is(':checked');
				}
				else if (nodeItem.node_state.match(/idle/i) && isWarningsset) {
				    optiondetails.hapi.ignore_warnings = $(IGNORE_WARNING_CHECKBOX).is(':checked');
				}

				if (!ignore_warnings_chkbox_needed) //this check is needed when there are no server messages at all. 
				{
				    optiondetails.hapi.ignore_warnings = true;
				}
				if(nodeItem.type.match(/virtual_connect/i)) {
					optiondetails.hapi.vc_activation_options ={};			
            		optiondetails.hapi.vc_activation_options.eth_activation_order = $('#hpsum-Enet-order').val();
					optiondetails.hapi.vc_activation_options.fc_activation_order = $('#hpsum-fc-order').val();     
					optiondetails.hapi.vc_activation_options.eth_activation_delay = $('#hpsum-Enet-delay').val();
					optiondetails.hapi.vc_activation_options.fc_activation_delay= $('#hpsum-FC-delay').val();	
					
					optiondetails.hapi.vc_encryption_settings = {};
					optiondetails.hapi.vc_encryption_settings.vc_encryption_key = $('#hpsum-node-vc-encryption-key').val();
					
				}
				if (nodeItem.type.match(/integrityilo/i)) {
				    var tmp = $(ACTIVATE_SELECTION).val();
				    if (tmp == 'NO') {
				        optiondetails.hapi.activate_sfw = false;
				    } else {
				        optiondetails.hapi.activate_sfw = true;
				    }
				}
			
				if (nodeItem.type.match(/sdflex/i)) {
					optiondetails.hapi.sdflex_installation_options = {};
					optiondetails.hapi.sdflex_installation_options.exclude_npar_fw = $(SDFLEX_INSTALLATION_OPTION_EXCLUDENPAR).is(':checked');
					
					optiondetails.hapi.activate_sfw = false;
					if ($(SDFLEX_REBOOT_OPTION).val() == 'YES')
				    {
				        optiondetails.hapi.activate_sfw = true;
				    }
				}

				if($(DEPLOYENCCHKBOXCOMP).is(':checked'))
				{
					optiondetails.hapi.deploy_enclosure = true;
				}
				
				if(nodeItem.type.match(/OA|VIRTUAL_CONNECT|ilo|switch|SAS_SWITCH/i)){
					var tableid = '#hpsum-assoc-nodes-' + nodeItem.node_id + '-table';
					var currTable = $(tableid).dataTable();
					
					var selectedRows = $(tableid + ' tbody tr');
					
					for(var tmp=0; tmp < selectedRows.length; tmp++){
						var compData = currTable.fnGetData(selectedRows[tmp].rowIndex-1);
						
						if(compData) {
							var bselected = false, bforce = false;
							if(selectedRows[tmp].className.indexOf('hp-selected') != -1)
								bselected = true;
							else
								bselected = false;
						
							var item = {
								node_id : compData.node_id,
								selected : bselected
							};
						
							optiondetails.hapi.associated_nodes.associated_node.push(item);
						} 
					}
				}
				if (nodeItem.type.match(/windows|ilo|linux/i) && iloManagementOptionNeeded) {
				    getIloManagementOptions(nodeItem);
				}
			}

			function getIloManagementOptions(nodeItem)
			{
			    optiondetails.hapi.ilo_management_options = {};
			    optiondetails.hapi.ilo_management_options.save_install_set = false;
			    optiondetails.hapi.ilo_management_options.clear_ilo_update_list = false;
			    optiondetails.hapi.ilo_management_options.manually_manage_iLO_repository = false;
			    if ($(SAVE_INSTALL_SET_CHECBOX).is(':checked'))
			    {
			        optiondetails.hapi.ilo_management_options.save_install_set = true;
			        optiondetails.hapi.ilo_management_options.install_set_name = trimString($(INSTALL_SET_NAME_TEXT));
			        optiondetails.hapi.ilo_management_options.install_set_description = trimString($(INSTALL_SET_DESC_TEXT));
					
					if ($(UPDATE_RECOVERY_SET_CHECKBOX).is(':checked'))
					{
						optiondetails.hapi.ilo_management_options.update_existing_recoveryset = true;
						if (nodeItem.server_generation >= 10 && $(UPDATE_RECOVERY_ILO_USERNAME).val() != "" && $(UPDATE_RECOVERY_ILO_PASSWORD).val() != "")
						{
							optiondetails.hapi.ilo_management_options.ilo_username = $(UPDATE_RECOVERY_ILO_USERNAME).val();
							optiondetails.hapi.ilo_management_options.ilo_password = $(UPDATE_RECOVERY_ILO_PASSWORD).val();
						}
					}
			    }
				else {
					if(($(UPDATE_RECOVERY_SET_CHECKBOX).is(':checked')))
					{
						//if update recoveryset checkbox is cheked append ilo management option corresponding to it
						optiondetails.hapi.ilo_management_options.update_existing_recoveryset = true;
						if (nodeItem.server_generation >= 10 && $(UPDATE_RECOVERY_ILO_USERNAME).val() != "" && $(UPDATE_RECOVERY_ILO_PASSWORD).val() != "")
						{
							optiondetails.hapi.ilo_management_options.ilo_username = $(UPDATE_RECOVERY_ILO_USERNAME).val();
							optiondetails.hapi.ilo_management_options.ilo_password = $(UPDATE_RECOVERY_ILO_PASSWORD).val();
						}
					}
					else if(!$(UPDATE_RECOVERY_SET_CHECKBOX).is(':checked'))
					{
						//if update recoveryset checkbox is not checked send update_recovery_set=false in ilo management option
					      optiondetails.hapi.ilo_management_options.update_existing_recoveryset = false;
					}
			    }
				if($('#schedule').hpsumSchedule("isScheduleSelected"))
				{
					var scheduleFromDateTime = $('#schedule').hpsumSchedule('getScheduleDateTime', true);
					var scheduleToDateTime = $('#schedule').hpsumSchedule('getScheduleDateTime', false);
					optiondetails.hapi.ilo_management_options.schedule_deploy_from = scheduleFromDateTime.replace(/-/g,'');
					optiondetails.hapi.ilo_management_options.schedule_deploy_to = scheduleToDateTime.replace(/-/g,'');
			    }
			    
			    if($('input[name=hpsum-delete-install-sets-options]:checked').val() == "one")
			    {
			        optiondetails.hapi.ilo_management_options.clear_ilo_update_list = true;
				}
				else
				{
			        optiondetails.hapi.ilo_management_options.manually_manage_iLO_repository = true;
			        //installset_ids_for_delete
			        var installsetIdsListForDelete = [];
			        for (var idx = 0; idx < allInstallSets.length ; idx++) {
			            var inputId = '#delete_installset-' + allInstallSets[idx].id;
			            if ($(inputId).is(':checked')) {
			                installsetIdsListForDelete.push(allInstallSets[idx].id);			                
			            }
			        }
			        optiondetails.hapi.ilo_management_options.installset_ids_for_delete = installsetIdsListForDelete;
			    }
            }

			function  getInstallationOptions(nodeItem){
					ForceOptions.hapi.installation_option ={};
                    var type = $(INSTALLATIONOPTION).val();
					// In case the user clicks Cancel or Changes the mode, we need to 
					// reset the values to the defaults.
					if(resetaction == 'cancel' || resetaction == 'changemode') {
						ForceOptions.hapi.installation_option.downgrade = false;
						ForceOptions.hapi.installation_option.rewrite   = false;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcesoftware = false;
						ForceOptions.hapi.installation_option.forcefirmware = false;
						return;
					}
					ForceOptions.hapi.installation_option.downgrade = false;
					ForceOptions.hapi.installation_option.rewrite   = false;
					ForceOptions.hapi.installation_option.software = false;
					ForceOptions.hapi.installation_option.firmware = false;
					ForceOptions.hapi.installation_option.forcesoftware = false;
					ForceOptions.hapi.installation_option.forcefirmware = false;
					
					if ( type == "upgradeBoth"){
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.software = true;
					}
					else if ( type == "upgradeFirmware"){
						ForceOptions.hapi.installation_option.firmware = true;
					}
					else if ( type == "upgradeSoftware"){
						ForceOptions.hapi.installation_option.software = true;
					}
					else if ( type == "downgradeFirmware"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
					}
					else if ( type == "downgradeSoftware"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
					else if ( type == "downgradeBoth"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
					else if ( type == "rewriteFirmware"){
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
					}
					else if ( type == "rewriteSoftware"){
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
					else if ( type == "rewriteBoth"){
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
					else if ( type == "firmware"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
					}
					else if ( type == "software"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
					else if ( type == "both"){
						ForceOptions.hapi.installation_option.downgrade = true;
						ForceOptions.hapi.installation_option.rewrite = true;
						ForceOptions.hapi.installation_option.firmware = true;
						ForceOptions.hapi.installation_option.forcefirmware = true;
						ForceOptions.hapi.installation_option.software = true;
						ForceOptions.hapi.installation_option.forcesoftware = true;
					}
			}

			function onsetattributeSuccess(item) {       
				skipInstallOptions = false;
				loadAttributes();
               //do nothing
            }
			
			function onsetattributeerror(errorMessage) {               
				
               onAnalysisError(errorMessage);
            }

            function onAnalysisError(errorMessage) {
                notifications.show(errorMessage, 'error');                          
				$(DEPLOY).attr("disabled", false);	
				$(CANCEL).trigger('click');	

            }			

            function onInventory() {
                var fail = false;
                var finalBaseline;
                var finalHotFix;
                var baselineJson = [];
                var selectedbaselineValue = "spp";
                if (!inventoryInProgress) {

                    var errorFound = false;
                    var baselinedetails = "";
                    if ($(BASELINES).val() != '') {
                        var baselinedetails = presenter.getBaselineDetailsforId($(BASELINES).val());
                        if (!baselinedetails) {
                            selectedbaselineValue = "installset";
                            //check if its an installset.
                            baselinedetails = getInstallSetForId($(BASELINES).val());
                            if (!baselinedetails) {
                                if ($(BASELINES).val().match(/ilo_queued_updates/i)) {
                                    isTaskQueueSelected = true;
                                    selectedbaselineValue = "taskqueue";
                                }
                                else {
                                    selectedbaselineValue = "";
                                    errorFound = true;
                                    $(BASELINE_INPUT_ERR).text(localizer.getString('hpsum.node.invalidBaseline'));
                                    $(BASELINE_INPUT).addClass("hp-error");
                                    $(BASELINE_INPUT_ERR).show();
                                }
                            }
                        }
                    }

                    if ($(HOTFIX).val() != '') {
                        var baselinedetails = presenter.getBaselineDetailsforId($(HOTFIX).val());
                        if (!baselinedetails) {
                            errorFound = true;
                            $(HOTFIX_INPUT_ERR).text(localizer.getString('hpsum.node.invalidAdtPackage'));
                            $(HOTFIX_INPUT).addClass("hp-error");
                            $(HOTFIX_INPUT_ERR).show();
                        }
                    }

                    if (errorFound == true) {
                        inventoryInProgress = false;
                        return;
                    }

                    if ((newBaseline == null) && (assocBaseline == null))
                        finalBaseline = null;
                    else if (newBaseline == null)
                        finalBaseline = assocBaseline;
                    else
                        finalBaseline = newBaseline;
                    if ((newHotFix == null) && (assocHotFix == null))
                        finalHotFix = null;
                    else if (newHotFix == null)
                        finalHotFix = assocHotFix;
                    else
                        finalHotFix = newHotFix;

                    if ((finalHotFix == null) && (finalBaseline == null)) {
                        $(BASELINE_INPUT_ERR).text(localizer.getString('hpsum.node.invalidBaseline'));
                        $(BASELINE_INPUT).addClass("hp-error");
                        $(BASELINE_INPUT_ERR).show();
                        fail = true;
                    }                    
                    else if (finalHotFix == null)
                        baselineJson.push(finalBaseline.id);
                    else if (finalBaseline == null)
                        baselineJson.push(finalHotFix.id);
                    else {
                        if (finalBaseline)
                            baselineJson.push(finalBaseline.id);
                        if (finalHotFix)
                            baselineJson.push(finalHotFix.id);
                    }
                    if (fail == false) {
                        $(BASELINE_INPUT_ERR).hide();
                        $(BASELINE_INPUT).removeClass('hp-error');
                        $(HOTFIX_INPUT_ERR).hide();
                        $(HOTFIX_INPUT).removeClass('hp-error');
                    
                        nodeItem.baselines = baselineJson;
                        nodeItem.operation_mode = 2; //direct deploy.
                        nodeItem.set_schedule_date_time = schduledDateTime;
                        nodeItem.remove_existing_baselines = true;
                        nodeItem.remove_from_group = ($(REMOVE_GRP_CHECKBOX).is(':checked')) ? true : false;
                        nodeItem.install_set_name = trimString($(INSTALL_SET_NAME_TEXT));
                        nodeItem.install_set_description = trimString($(INSTALL_SET_DESC_TEXT));
                        nodeItem.cleanup_onexit = cleanuponexit;
                        nodeItem.cleanupall_onexit = cleanupallonexit;
                        inventoryInProgress = true;
                        if (selectedbaselineValue.match(/spp/i)) {
                            applyInstallationOptions();
                        }
                        if (selectedbaselineValue.match(/taskqueue/i) || selectedbaselineValue.match(/spp/i)) {
                            var setAttributesNeeded = isSetAttributesNeeded();
                            if (setAttributesNeeded)
                                showAnalysisSplash();
                            //send the setattribute command to engine
                            if (setAttributesNeeded) {
                                presenter.setattribute(nodeItem, optiondetails, {
                                    success: function (data) {
                                        if ((isSelectionChanged && selectedComponentsCount > 0)) {
                                            doAnalysis();
                                        }
                                        else {
                                            closeAnalysisSplash();
                                        }
                                    },
                                    error: onsetattributeerror
                                });
                            }
                        }

                        if (selectedbaselineValue.match(/installset/i) || selectedbaselineValue.match(/spp/i)) {
                            presenter.startInventory(nodeItem, {
                                success: function (data) {
                                    var item = nodeItem;
                                    onInventorySuccess(data, item);
                                },
                                error: onInventoryError
                            });
                        }
                        else if(selectedbaselineValue.match(/taskqueue/i))
                        {
                            presenter.deploy(nodeItem, {
                                success: function (data) {
                                    var item = nodeItem;
                                    onDeploySuccess(data, item);
                                },
                                error: onDeployError
                            });
                        }
                    }
                }
            }

            function onInventoryError(errorMessage) {
                $(FAILEDPANEL).show();
                $(FAILEDMSG).text(errorMessage);
                $(DEPLOY).attr("disabled", "disabled");
                inventoryInProgress = false;
            }

            function onInventorySuccess(data, item) {
                if (item.hasOwnProperty("set_schedule_date_time") && item.set_schedule_date_time != "") {
                    var notif = {
                        summary: localizer.getString('hpsum.node.nodeStageScheduled') + item.set_schedule_date_time,
                        uri: item.uri,
                        status: 'ok',
                        sourceName: item.ip,
                        sourceUri: item.uri
                    };
                    notifications.add(notif, true);
                }

                inventoryInProgress = false;
                router.go(urlFragment.replaceView(router.location(), 'show'));
            }

            //replace(/(^\s*)|(\s*$)/gi, ""). // removes leading and trailing spaces
            //replace(/[ ]{2,}/gi, " "). // replaces multiple spaces with one space 
            //replace(/\n +/, "\n"); // Removes spaces after newlines
            function trimString(el) {
                el[0].value = el[0].value.replace(/(^\s*)|(\s*$)/gi, "").replace(/[ ]{2,}/gi, " ").replace(/\n +/, "\n"); // Removes spaces after newlines
                return el[0].value;
            }

            /**
             * @private
             * Call presenter's deploy() to deploy  a selected component/baseline to the node 
             */
            function onDeploy() {
				if (iloManagementOptionNeeded)
				{
					var isSaveInstallset = $(SAVE_INSTALL_SET_CHECBOX).is(':checked');
					if(isSaveInstallset)
					{
						//validate save installset name and desciption.
						validateInstallSetNameandDesc();
					}
					if((nodeItem.server_generation >= 10) || nodeItem.type.match(/ilo5/i))
					{
						if(validateScheduleDetails())
							return;
					}
				}
                if (nodeItem.node_state.match(/STAGE_ONLY_DONE/i))
				{
				
					if(iloManagementOptionNeeded)
					{
						//set attribute is required when staged installset is choosen as BL for recoveryset feature
							getIloManagementOptions(nodeItem);
							presenter.setattribute(nodeItem,optiondetails, {
							success : function(data) {
								onDeployContinue();
								
							},
							error : onsetattributeerror
						});
					}
					else
					{
					
						onDeployContinue();
					}
				}
				else
				{
				//var schduledDateTime = $('#schedule').hpsumSchedule('getScheduleDateTime', true);
                //Schedule time is getting overwrite/reset incase multiple requests required to sent to engine.
				//Store schedule time into the temp variable which will be
					//useful in case multiple request trigger during deploy(setattributes, analysis, deploy).
					//UI should send schedule time in deploy payload.
					//tmpScheduleTime = schduledDateTime;

					skipInstallOptions = true;

					if (nodeItem.node_state.match(/idle/i) && isUefiUpdatableComp) 
					{
						presenter.rebootNode(nodeItem.node_id, {
							success: onItemRebootSuccess,
							error: onItemRebootError
						});
					}
					else 
					{
						if (!validateRebootDelay())
							return;

						deploy_flag = true;
						formStateView.reset();
						loadAttributes();
					}	
				}
                
            }

            function onItemRebootSuccess(item_name) {
                $(CANCEL).trigger('click');
            }

            function onItemRebootError(errorMessage) {
                notifications.show(errorMessage, 'error');
                router.go(urlFragment.replaceView(router.location(), 'show'));
            }
            
			/**
             * @private
             * Continue the deploy procedure from the Analysis onwards 
             */
			function onDeployContinue() 
            {
			    
				if(nodeItem  && (nodeItem.node_state === 'UAN' || nodeItem.node_state == 'REMOTE_STAGING_UAN' || nodeItem.node_state == 'STAGE_ONLY_DONE')) 
				{
					if(nodeItem.node_state == 'REMOTE_STAGING_UAN')
                    {
                    	//obtaining scheduled date time from deploy plugin.						
						var stageDeployScheduleDateTime = {
							command : 'getEasyModeScheduleDateTimeFromSchedulePlugin',
							args:{
									dateTime : dateTime
								}
							};
							//$(DEPLOY_NODE_PLUGIN).hpsumDeployNode(stageDeployScheduleDateTime);
							if(stageDeployScheduleDateTime.args.dateTime != "")
							{
								var validateDateTime = {
									command : 'validateScheduleDateTimeFromSchedulePlugin',
									args :{
										localDateTime : nodeItem.local_date_time,
										scheduleDateTime : stageDeployScheduleDateTime.args.dateTime,
										isValid : false
									}
								};
								//$(DEPLOY_NODE_PLUGIN).hpsumDeployNode(validateDateTime);
								var isValid = validateDateTime.args.isValid;
								
								if(!isValid)
								{
									/* if error happens, and user clicks on cancel, old schedule has to work. Cause he has not meant to abort the old schedule.*/
									bHasUserPressedDeploy = false; 
									nodeItem.set_schedule_date_time = "";
									return;
								}
								else
								{
									bHasUserPressedDeploy = true;
									nodeItem.set_schedule_date_time = stageDeployScheduleDateTime.args.dateTime;
								}
							}
                    }
                    //these are aplicable for both UAN and remote_UAN states.
                                    
                    nodeItem.cleanup_onexit = cleanuponexit;
                    nodeItem.cleanupall_onexit = cleanupallonexit;
					if ($(DEPLOY).attr("value") == "Stage")
					{
						nodeItem.stage_only = true;
					}
					else if ($(DEPLOY).attr("value") == "Deploy")
					{
						nodeItem.stage_only = false;
					}
	                 presenter.deploy(nodeItem, {
                            success: function (data) {
                                var item = nodeItem;
                                onDeploySuccess(data, item);
                            },
                            error: onDeployError
                        });
                    
					$(CANCEL).trigger('click');
				}
			    //for direct deploy send  setattributes and inventory with operation mode 2.
				else if (nodeItem && nodeItem.node_state.match(/idle/i))
				{
				    if (isTaskQueueSelected)
				    {	
				        presenter.deploy(nodeItem, {
				            success: function (data) {
				                var item = nodeItem;
				                onDeploySuccess(data, item);
				            },
				            error: onDeployError
				        });

				        $(CANCEL).trigger('click');
				    }
				    else {
				        onInventory();
				    }
				}
			}
			
			 /**
             * @private
             */
            function onDeploySuccess(data,item) {  
            	if(item.schedule_date_time != "")
                {
                        
                        var notif = {
                            summary : localizer.getString('hpsum.node.nodeDeployScheduled') + item.set_schedule_date_time,
                            uri : item.uri,
                            status : 'ok',
                            sourceName : item.ip,
                            sourceUri : item.uri
                        };
                        notifications.add(notif, true);
                }
				deploy_flag = false;
				router.go(urlFragment.replaceView(router.location(), 'show'));
            }

            /**
             * @private
             */
            function onDeployError(errorMessage) {
                notifications.show(errorMessage, 'error'); 
                deploy_flag = false;
                router.go(urlFragment.replaceView(router.location(), 'show'));
            }
			
			function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }					
			function handleSelectToggleRowselection(row){
			        var selectElem = row.innerHTML.split('"');
					var selectId = '#' + selectElem[3];
					if(selectId.indexOf('hpToggle')>=0)
						selectId = '#' + selectElem[3].slice(0, -9);
						else
						selectId = '#' + selectElem[5].slice(0, -9);
						 if(row.outerHTML.match(/hp-selected/i)){	 
								 $(selectId).prop('checked', true);
								 $(selectId).trigger('change');
								 if($.inArray(selectId,selectedAssociatedNodes) == -1)
								 {
									selectedAssociatedNodes.push(selectId);
								 }
							 } else {
								 $(selectId).prop('checked', false);
								 $(selectId).trigger('change');
								 var index = $.inArray(selectId,selectedAssociatedNodes);
								 if(index != -1)
								 {
									 selectedAssociatedNodes.splice(index,1);
								 }
								 
							 }
							 if(row.outerHTML.match(/hp-disabled/i)){
								 
								 $(selectId).prop('checked', false);
								 $(selectId).trigger('change'); 
			                      }
								  updateDeployButtonState();
						}
			//Initialize Associated Nodes table to show the list of associated nodes
            function initAssocTable(tableid) {
		    
				var oTab = $(tableid).dataTable({
					oLanguage: {
					    sEmptyTable: localizer.getString('hpsum.node.noAssociatedNodes'),
					    sSearch: localizer.getString('hpsum.common.search')
							   },
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : true,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
					bServerSide:false,
				    //aaData: data,
					aoColumns : [
						{mDataProp: 'node_selection'},
						{mDataProp: 'node_ip'},
						{mDataProp: 'node_type'},
				        {mDataProp: 'link' ,
						fnRender: function (oObj) {
							if(oObj.aData.node_id){
								if(!(oObj.aData.nodeitem_type.match(/SAS_SWITCH/i) || oObj.aData.nodeitem_type.match(/VIRTUAL_CONNECT/i)))
								{
									if(oObj.aData.state.match(/UAN/i))
									{
										return '<a id = "componentLink" href="javascript:void(0);" class="company-a">' + localizer.getString('hpsum.node.applicableComponents') + '</a>';
									}
									else if ((oObj.aData.state.match(/install$/i)) || (oObj.aData.state.match(/InstallDone$/i)) || (oObj.aData.state.match(/installhold$/i)))
									{
										return "";
									}
									else
									{
										return localizer.getString('hpsum.node.nodeNotReady');
									}
								}
								else
								{
									return "";
								}
							}
							else
							{
								return localizer.getString('hpsum.node.waitingForComp');
							}
						}},
						{mDataProp: 'status',
						fnRender: function (oObj) {
							if(oObj.aData.state.match(/UAN/i))
									return  oObj.aData.associated_node_status;
								else
									return oObj.aData.status;
						}},
				      		{mDataProp: 'node_id', "bVisible": false, sWidth: 5},
						{mDataProp: 'state', "bVisible": false, sWidth: 5},
						{mDataProp: 'compsig_missing',sDefaultContent:false, "bVisible": false, sWidth: 5}
					],
				    aaSorting: [[ 0, "asc" ]],				    
					fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        //$(nRow).attr('id', aData.component_id);
				        return nRow;
				    }
				    });//.rowReordering().addClass('hp-reorderable');			
			}

			function showAssociatedNodes(nodeItem) {
				$(ASSOC_OPTIONS).hide();
						   
				$(ASSOC_NODES).empty();
						  				   
				$(ASSOC_NODES).append('<table class="hp-selectable" id="hpsum-assoc-nodes-' + nodeItem.node_id + '-table"><thead><tr><td><b>' 
										+ localizer.getString('hpsum.node.selectnodes')+ '</b></td><td><b>' 
										+ localizer.getString('hpsum.node.ip') + '</b></td><td><b>' + localizer.getString('hpsum.node.type') + '</b></td><td><b>' 
										+ localizer.getString('hpsum.node.componentDetails') + '</b></td><td><b>' + localizer.getString('hpsum.common.statusStr') + '</b></td><td></td><td></td></tr></thead></table>');
						   
				tableid = '#hpsum-assoc-nodes-' + nodeItem.node_id + '-table';
				initAssocTable(tableid);
				

				assoc_table = $(tableid).dataTable();
				$('#hpsum-associated-nodes-text').html(localizer.getString("hpsum.node.nodesBelowList" , [nodeItem.name]));
				$('#hpsum-associated-nodes-text').removeClass('hp-collapsed');
				//$('#hpsum-assoc-nodes-' + nodeItem.node_id + '-table_filter').hpSearchCombo("disable");
				assoc_table.fnClearTable();	
				
				if ( nodeItem.auto_add_assoc_nodes == true )
				{
					var node_uri = "/Session/" + session.getToken() + "/node/" + nodeItem.node_id;
					rest.getURI(node_uri +"/getAssociatedNodesCompData",
							{
								nodeid : nodeItem.node_id,
								success : function(data) {
									associatedNodesData = data;
									renderAssociatedNodes(data);
				},
								error : function(errorInfo){ }
							});
				}
			}
			
			function getCompsigMissingStatus()
			{
				var compsig_missing_deploy=false;
				var table_id = '#hpsum-assoc-nodes-' + nodeItem.node_id + '-table';
				var assoc_table = $(table_id).dataTable();
				var selectedRows = $(table_id +' tbody tr.hp-selected');
				if(selectedRows.length>0)
				{
					for(var tmp=0; tmp < selectedRows.length; tmp++){
						var nodeData = assoc_table.fnGetData(selectedRows[tmp].rowIndex-1);
						if(nodeData.compsig_missing && nodeData.type_string.match(/iLO5/i))
						{
							compsig_missing_deploy = true;
							break;
						}
					}
				}
				return compsig_missing_deploy;
			}
			function renderAssociatedNodes(data)
			{
				assoc_table.fnClearTable();
				var associated_ips=[];
				var nodeAssoData = data.hapi.associated_nodes;
							if ( nodeAssoData.node.length == undefined && nodeAssoData.node.node_id )
								nodeAssoData.node = new Array(nodeAssoData.node);
							if ( nodeAssoData.node.length == undefined && nodeAssoData.node.node_id==undefined)
							return;
							if(nodeAssoData.node.length==0)
								return;
					
					for(var i=0; i<nodeAssoData.node.length; i++){
					//If the node is part of associated_ips, it is already added to the table,hence continuing with next node.
						if ( jQuery.inArray(nodeAssoData.node[i].ip_or_dns,associated_ips) == 0)
							continue;
						if(nodeAssoData.node[i].node_id && nodeAssoData.node[i].associated_node_status ){
							var compsig_status;
							if(nodeAssoData.node[i].hasOwnProperty('is_missing_compsig'))
							{
								compsig_status = nodeAssoData.node[i].is_missing_compsig;
							}
							else
							{
								compsig_status=false;
							}
								
							var node_data = [{
							'node_selection': '<input id="toggle-' + nodeAssoData.node[i].node_id+ '" class="hp-toggle" type="checkbox"/>',
								'node_type': nodeAssoData.node[i].type +' '+ nodeAssoData.node[i].productName,
								
								'node_ip': nodeAssoData.node[i].ip_or_dns,
								'link': "",
								'status': nodeAssoData.node[i].node_status,
								'node_id': nodeAssoData.node[i].node_id,
								'state': nodeAssoData.node[i].node_state,
								'type_string': nodeAssoData.node[i].type,
								'nodeitem_type' : nodeAssoData.node[i].type,
								'associated_node_status': nodeAssoData.node[i].associated_node_status,
								'compsig_missing':compsig_status
								
							}];
							var noApplicableComponents = nodeAssoData.node[i].associated_node_status.match(/No Applicable Components./i)? true : false ;
							
							if(nodeItem.type.match(/OA/i))
							{
								if ( nodeAssoData.node[i].device == 'Interconnect' || nodeAssoData.node[i].device == 'Associate')
								{
									if(nodeAssoData.node[i].type.match(/VCDEV/i)) 
									{
										if(nodeAssoData.node[i].isConjoined != "0")
										{	
											
											
											if ( jQuery.inArray(nodeAssoData.node[i].ip_or_dns,associated_ips) == -1){
										assoc_table.fnAddData(node_data);
										associated_ips.push(nodeAssoData.node[i].ip_or_dns);
										if(nodeAssoData.node[i].node_state == "UAN" && !noApplicableComponents)
						    {
							        $('#toggle-' + nodeAssoData.node[i].node_id).hpToggle({
									unchecked : localizer.getString("hpsum.oneTouchUpdate.select"),
									checked : localizer.getString("hpsum.oneTouchUpdate.selected")
								    });      
							}
							else
							{
                                    $('#toggle-' + nodeAssoData.node[i].node_id).hpToggle({
									unchecked : localizer.getString("hpsum.common.disabled"),
									checked : localizer.getString("hpsum.common.disabled")
									});
							}
										}
										}		
									}
									else
									{
									
									if ( jQuery.inArray(nodeAssoData.node[i].ip_or_dns,associated_ips) == -1){
										assoc_table.fnAddData(node_data);associated_ips.push(nodeAssoData.node[i].ip_or_dns);
										if(nodeAssoData.node[i].node_state == "UAN" && !noApplicableComponents)
						    {
							        $('#toggle-' + nodeAssoData.node[i].node_id).hpToggle({
									unchecked : localizer.getString("hpsum.oneTouchUpdate.select"),
									checked : localizer.getString("hpsum.oneTouchUpdate.selected")
								    });      
							}
							else
							{
                                    $('#toggle-' + nodeAssoData.node[i].node_id).hpToggle({
									unchecked : localizer.getString("hpsum.common.disabled"),
									checked : localizer.getString("hpsum.common.disabled")
									});
							}
										}
										}
								}
							}
							else
							{
			
								if ( jQuery.inArray(nodeAssoData.node[i].ip_or_dns,associated_ips) == -1){
								assoc_table.fnAddData(node_data);associated_ips.push(nodeAssoData.node[i].ip_or_dns);
								if(nodeAssoData.node[i].type.match(/Onboard Administrator|OA/i))
								{
									if(nodeAssoData.node[i].node_status == FIPS_MODE_ON)
									{
										$('#toggle-' + nodeAssoData.node[i].node_id).hpToggle({
											unchecked : localizer.getString("hpsum.common.disabled"),
									checked : localizer.getString("hpsum.common.disabled")
									});
									$('#toggle-' + nodeAssoData.node[i].node_id).addClass('hp-disabled');	
									$('#assoc-oa-fips-force-warning').show();
									}
									else
									{
									$('#toggle-' + nodeAssoData.node[i].node_id).hpToggle({
									unchecked : localizer.getString("hpsum.oneTouchUpdate.select"),
									checked : localizer.getString("hpsum.oneTouchUpdate.selected")
								    }); 
									}
								}
								
								else
								{
								if(nodeAssoData.node[i].node_state == "UAN" && !noApplicableComponents)
						    {
							        $('#toggle-' + nodeAssoData.node[i].node_id).hpToggle({
									unchecked : localizer.getString("hpsum.oneTouchUpdate.select"),
									checked : localizer.getString("hpsum.oneTouchUpdate.selected")
								    });      
							}
							else
							{
                                    $('#toggle-' + nodeAssoData.node[i].node_id).hpToggle({
									unchecked : localizer.getString("hpsum.common.disabled"),
									checked : localizer.getString("hpsum.common.disabled")
									});
							}
								}
								}
							}
							
							if(nodeAssoData.node[i].node_state.match(/UAN/i) && !noApplicableComponents){
								if(nodeAssoData.node[i].selected)
									$(tableid + ' tbody tr').last().addClass('hp-selected');
								else
									$(tableid + ' tbody tr').last().removeClass('hp-selected');
							}
							else
								$(tableid + ' tbody tr').last().addClass('hp-disabled');
							//if((nodeItem.type.match(/SAS_SWITCH/i)) || (nodeItem.type.match(/VIRTUAL_CONNECT/i)))
								//$(tableid + ' tbody tr').last().addClass('hp-disabled');
						
						if($.inArray('#toggle-' + nodeAssoData.node[i].node_id,selectedAssociatedNodes) != -1)
						{
							$('#toggle-' + nodeAssoData.node[i].node_id).prop('checked', true);
							$('#toggle-' + nodeAssoData.node[i].node_id).trigger('change');
							$(tableid + ' tbody tr').last().addClass('hp-selected');
						}
						}
					}
							  							  
					
					$(tableid + " tbody tr").click( function( e ) {
					var srcElem, browsertype = 0;
					var data = $(tableid).dataTable().fnGetData( this );
					
                    if(data != null)
					{
					//if(data.nodeitem_type.match(/SAS_SWITCH/i) || data.nodeitem_type.match(/VIRTUAL_CONNECT/i))
					//{
						//return;
					//}
					
					//Check if firefox or (chrome and IE)
					if(e.srcElement)
						srcElem = e.srcElement;//Chrome and IE
					else
					{
						srcElem = e.target;//Firefox
						browsertype = 1;
					}
					
						if ( srcElem.tagName == 'A' ){
							var node_uri = "/Session/" + session.getToken() + "/node/" + data.node_id;
								rest.getURI(node_uri + "/getdata", {
									success : function(data)
									{
									    data = data.hapi;
									    //checkbox is required only for server messages.
                                        var ignore_warnings_chkbox_needed_for_acc = false;
									    for (var len = 0; len < data.warnings.length; len++) {
									        if (data.warnings[len].type.match(/server/i)) {
									            ignore_warnings_chkbox_needed_for_acc = true;
									            break;
									        }
									    }
									    $('#hpsum-warning-messages-assoc').hpsumWarnings(data, ignore_warnings_chkbox_needed_for_acc);
										$('.ignorewarnings').on('change', function () {
										    var message = '';
										    if (this != undefined && !$(this).is(':checked')) {
										        if (isStageSelected) {
										            message = localizer.getString('hpsum.advanceMode.StageDisabledDueToWarning');
										        }
										        else {
										            message = localizer.getString('hpsum.advanceMode.DeployDisabledDueToWarning');
										        }
										}
										if(message != '') 
										{
										$(ASSOC_NODE_ANALYSIS).attr('disabled','disabled');
											formStateView.setMessage({
											summary: message,
											status: 'warning',											
											changing: false,
											});
										}
										});
									}
								});
							
							populateComponents(data.node_id,data.type_string);
						}
						else{
							//row is disabled, so only force option can be applied
							//no row selection/deselection supported
							if ( $(this).hasClass('hp-disabled') )
							{
                                handleSelectToggleRowselection(this);							
								return;
                            }								
							$(this).toggleClass('hp-selected');
							handleSelectToggleRowselection(this);
						}
                    }
				});
			}

			function showAssocDialog(nodeid,type){
			     
			     if(!assocNodeDialog) {
			     	var closefunc =  function(elem) {
                        	$(ASSOC_ANALYSIS, assocNodeDialogContents).off('click');
                            assocNodeDialog = null;
                            assoc_dialog_openedonce = false;
                     };
                    assocNodeDialog = new DialogView();
                    assocNodeDialog.init({contents: assocNodeDialogContents,
                        position : "center",
                        ok : function(){ closefunc() },
                        cancel: function(){ closefunc() }
                    }); 
                    
                    $(ASSOC_ANALYSIS, assocNodeDialogContents).on('click', function(ev) {
                        btnAssocAnalyzeClicked.call(this,nodeid,type);
                    });
                }
			}
									
			

			function onAssocSelectionChanged(id, value, componentList)
			{
				if(value == true){
					$(ASSOC_NODE_ANALYSIS).attr("disabled", false);
				}
				else
				{
					$(ASSOC_NODE_ANALYSIS).attr("disabled", true);
					
				}
			}

		    function onAssocPopulateInstallSet(node_id)
			{	
				var install = $('#all-associated-baselines').data('plugin_hpsumInstallables');
				var failedDependencyCount = install.failedDependencyCount();
				if(failedDependencyCount <= 0 && assoc_dialog_openedonce == true)
				{
					return;
				}
				if(assoc_dialog_openedonce == false) 
					assoc_dialog_openedonce = true;
			}


			function populateComponents(node_id,type) {
				var node_uri = "/Session/" + session.getToken() + "/node/" + node_id;
				showAssocDialog(node_id,type);
				$(ASSOC_ANALYSIS).attr("disabled", true);
				$(ASSOC_NODE_COMP).empty();

				$(ASSOC_NODE_COMP).append("<div id='all-associated-baselines' style='margin:10px;' ></div>");

				var asscnodeItem = {
								'node_id':node_id,
								 'type': type
								};

				var options = {
						command:'init',
						nodeItem:asscnodeItem,
						onSelectionChanged:onAssocSelectionChanged,
						onPopulateInstallSet:onAssocPopulateInstallSet
						
					};
					
				//Call plugin to show the component list ();
				$('#all-associated-baselines').hpsumInstallables(options);
					if(type!="VCDEV")
				{
					$('#hpsum-vc-encryption-label').hide();
				}else {
					$('#hpsum-vc-encryption-label').show();
				}						
		
				if (type.match(/Onboard Administrator|OA/i))
				{
					$('#hpsum-assoc-node-oafips-force-label').show();
				} else {
					$('#hpsum-assoc-node-oafips-force-label').hide();
				}
			}
           
			function btnAssocAnalyzeClicked(nodeid,type) {
			
				showAnalysisSplash();

				var inst = $('#all-associated-baselines').data('plugin_hpsumInstallables');
				var componentsList = inst.getComponents();

				
				var uri = '/Session/'+session.getToken()+'/node/'+nodeid +'/analysis';			 
				rest.postObject(uri, componentsList,"",{
						node_id: nodeItem.node_id,
						success : function(data) {
							analyzeSuccess(data, this.node_id);
						},
						error : function(errorInfo) {
							analyzeError(errorInfo);
						}
				});
					
		        var progressTimer = setInterval(function () {
					var node_uri = "/Session/" + session.getToken() + "/node/" + nodeid;
					rest.getURI(node_uri + "/getstatus", {
										
						success : function(data) {
							
							if(data.hapi.node_status.node_state === "ANALYSIS")
							{
								
							}
							else if(data.hapi.node_status.node_state === "UAN")
							{
								clearInterval(progressTimer);
				
								//show install review for all the nodes
								populateComponents(data.hapi.node_status.node_id,type);
				
								//disable analyze button
								$(ASSOC_ANALYSIS).attr("disabled", true);
								var node_uri = "/Session/" + session.getToken() + "/node/" + nodeItem.node_id;
								rest.getURI(node_uri +"/getAssociatedNodesCompData",
								{
									nodeid : nodeItem.node_id,
									success : function(data) {
										renderAssociatedNodes(data);
										updateDeployButtonState();
										closeAnalysisSplash();
										if(failedDependencyCount <= 0 && assoc_dialog_openedonce == true)
										{
											assocNodeDialog.cancel();
										}
									},
									error : function(errorInfo){ }
								});
							
							}
							else if(data.hapi.node_status.node_state === "ERROR")
							{
								clearInterval(progressTimer);
								closeAnalysisSplash();
							}
						},
						error : function(errorInfo) {
							
						}
					});
				}, 3000);
			}

			function showWarning(warning_message) {
				if(warningMsg !== warning_message) {
					warningMsg = warningMsg + warning_message;
				}
			}
			
			/**
             * @private
             */

            function reset() {
                $(DESCR).text(localizer.getString('hpsum.common.loading'));
                $(TYPE).text("");
                $(NONECHECKBOX).attr('checked', false);
                $(USESNMPCHECKBOX).attr('checked', false);
                $(USEAGENTLESSCHECKBOX).attr('checked', false);
                $(USEWEBEMCHECKBOX).attr('checked', false);
                $(COMPVERBOSEOPTION).attr('checked', false);
                $(REBOOTOPTION).selectBox('value', 'Never');
                $(DELAYMINUTES).prop("disabled", true);
				$(DELAYMSG).prop("disabled", true);
				$(REBOOTOPTION).live('change',function(e){
				if($(REBOOTOPTION).val().toLowerCase() == "never"){
					$(DELAYMINUTES).prop("disabled", true);
					$(DELAYMSG).prop("disabled", true);
                    rebootSelectionChanged = false;
					}
					else{
					$(DELAYMINUTES).prop("disabled", false);
					$(DELAYMSG).prop("disabled", false);
					$(DELAYMINUTES).val(REBOOT_DELAY_SEC/60);
                    rebootSelectionChanged = true;
					}
				});
				$(DELAYSECERR).hide();
				$(DELAYMINUTES).removeClass('hp-error');
                $(SCHEDULE_DATE).val("");
				$(SCHEDULE_TIME).val("");
				$(DELAYMINUTES).val(REBOOT_DELAY_SEC /60);
                $(DELAYMSG).attr('value',localizer.getString('hpsum.node.rebootMessage'));
				$(INSTALLATION_OPTIONS).css("display","block");
				$(SDFLEX_INSTALLATION_OPTIONS).css("display", "block");
				$(SDFLEX_INSTALLATION_OPTION_EXCLUDENPAR).attr('checked', false);				
				$(SDFLEX_REBOOT_OPTION).selectBox('value', 'NO');
				
				$(TAB_INSTALLATION_OPTIONS).closest("li").show();
                $(REBOOT_OPTIONS).css("display", "block");
				$(TAB_REBOOT_OPTION).closest("li").show();
				$(TAB_VC_ACTIVATION_OPTIONS).css("display", "none");
				$(TAB_VC_INSTALLATION_OPTIONS).css("display", "none");
                $('#hpsum-node-vc-encryption-key').val(''); 
				//reset all values which were changed.
				rebootSelectionChanged = false;
				isSelectionChanged = false;
				isBaselineSelected = false;
				isRegularBlSelectedForDeploy = false;
				$('#all-baselines').hpsumInstallables('destroy');
				$(ILO_MGMT_OPTIONS_INSTALLSET_PLUGIN_PANEL).hpsumInstallSets('destroy');
				$(ILO_INSTALLSET_COMPONENTS).hpsumInstallSetComponents('destroy');
				$('#hpsum-warning-messages').hide();
				ignore_warnings_chkbox_needed = false;
				shouldDisableDeploy = false;
				formStateView.reset();
 }
                        
            function loadAttributes() {
                initialGetattr = null;
                var handler = {
                    success: function (data) {
                        initialGetattr = data;
                        if (!skipInstallOptions) {
                            showInstallationOptions(data, initialRebootOptionsLoaded);
							if (initialRebootOptionsLoaded){
								initialRebootOptionsLoaded = false;							
							}
                        }
                        else {
                            analysis();
                        }

                    },
                    error: function (errorInfo) {
                    }
                };

                presenter.otheroption(nodeItem, handler);
			}
			
			 function handleBaselineTab(tab)
			 {
                 for(var eleCount = 0; eleCount < $('#adv-mode-details')[0].children.length; eleCount++)
                 {
                     $('#'+$('#adv-mode-details')[0].children[eleCount].id).hide();
                 }
                 for(var optCount = 0; optCount < $(ADV_MODE_DETAILS_TABS)[0].children.length; optCount++)
                 {
                  var child = $(ADV_MODE_DETAILS_TABS)[0].children[optCount].children[0];
					$(child).addClass('company-a');
					$(child).removeClass('company-background');
                    $(ADV_MODE_DETAILS_TABS)[0].children[optCount].children[0].style.backgroundColor = "#fff";
					
                 }
                 $('#'+tab.getAttribute("data-panel-id")).show();
                 tab.style.color= "#000";
                 $(tab).addClass('company-background');
			 }

			 function handleInstallOptionsTab(tab)
			 {
				for(var eleCount = 0; eleCount < $(ADV_MODE_INST_OPTIONS)[0].children.length; eleCount++)
				 {
					 $('#'+$(ADV_MODE_INST_OPTIONS)[0].children[eleCount].id).hide();
				 }
				  for(var optCount = 0; optCount < $('#deploy-installation-tabs')[0].children.length; optCount++)
				  {
					  var child = $('#deploy-installation-tabs')[0].children[optCount].children[0];
					  $(child).addClass('company-a');
					  $(child).removeClass('company-background');
					  $('#deploy-installation-tabs')[0].children[optCount].children[0].style.backgroundColor = "#fff";
				  }
			 
				 $('#'+tab.getAttribute("data-panel-id")).show();
				tab.style.color= "#000";
				$(tab).addClass('company-background');
			 }
			
            //function to enable or disable the stage button
			 function shouldEnableStage(item)
			 {

			 }
			 
			 //generic callback to enable or disable the deploy button.used from plugin.
			 function shouldEnableDeployment(item) {
                                  
			     //this check is of more safe check if node is part of a node group.
			     if (isPartOfGroup)
			     {
			         item.formStateViewMessage = localizer.getString("hpsum.easymode.partOfGroupMsg");
			         item.disableDeploy = true;
			     }
			     		     
			     warningMessage = item.formStateViewMessage;

			     if (!item.disableDeploy && (warningMessage == undefined || warningMessage == '')) {
			         //Added check to check if there are any server warnings are there. if this flag is true, then only checkbox will be there. otherwise, no checkbox will be there. 
			         if (ignore_warnings_chkbox_needed && $(".ignorewarnings")[0] && !$(".ignorewarnings").is(':checked')) {
			             $(DEPLOY).attr('disabled', 'disabled');
			             var message = '';
			             if (isStageSelected) {
			                 message = localizer.getString('hpsum.advanceMode.StageDisabledDueToWarning');
			             }
			             else {
			                 message = localizer.getString('hpsum.advanceMode.DeployDisabledDueToWarning');
			             }
			             formStateView.setMessage({
			                 summary: message,
			                 status: 'warning',
			                 changing: false,
			             });
			         }
			         else {
			             $(DEPLOY).removeAttr('disabled');
			             if (warningMessage == undefined || warningMessage == '') {
			                 formStateView.reset();
			             }
			             else {
			                 formStateView.setMessage({
			                     summary: warningMessage,
			                     status: 'warning'
			                 });
			             }
			         }
			     }
			     else { //disable the deploy and print proper message. 
			         $(DEPLOY).attr('disabled', 'disabled');
			         if (warningMessage == undefined || warningMessage == '') {
			             formStateView.reset();
			             //Added check to check if there are any server warnings are there. if this flag is true, then only checkbox will be there. otherwise, no checkbox will be there. 
			             if (ignore_warnings_chkbox_needed && $(".ignorewarnings")[0] && !$(".ignorewarnings").is(':checked')) {
			                 var message = '';
			                 if (isStageSelected) {
			                     message = localizer.getString('hpsum.advanceMode.StageDisabledDueToWarning');
			                 }
			                 else {
			                     message = localizer.getString('hpsum.advanceMode.DeployDisabledDueToWarning');
			                 }
			                 formStateView.setMessage({
			                     summary: message,
			                     status: 'warning',
			                     changing: false,
			                 });
			             }
			         }
			         else {
			             formStateView.setMessage({
			                 summary: warningMessage,
			                 status: 'warning'
			             });
			         }
			     }
			     if(warningMessage != '')
			     {
			         var FORMSTATEVIEWMSG = '#hp-form-message-id';
			         $(FORMSTATEVIEWMSG)[0].style.visibility = 'visible';
			     }
			 }
			 
			 //call back from plugin
			 function repopulateInstallSet()
			 {
				$('#all-baselines').hpsumInstallables('populateInstallSet');
			 }
			
			  //call back from plugin
			 function resetAssociatedNodes()
			 {
				selectedAssociatedNodes = [];
			 }
			
			function getTargetId(event)
			{
				var browserType = '';
					var targetId = '';
				if((navigator.userAgent).indexOf("Firefox") != -1)
					{	if(event.hasOwnProperty('originalEvent'))
						{
							targetId = event.originalEvent.target.id;
						}
					}
					else if((navigator.userAgent).indexOf("Trident") != -1 || (navigator.userAgent).indexOf("MSIE") != -1 || (navigator.userAgent).indexOf("Edge") != -1)
					{
						if(event.hasOwnProperty('originalEvent'))
						{
							targetId = event.srcElement.id;
						}
					}
					else if((navigator.userAgent).indexOf("Chrome") != -1)
					{
						if(event.hasOwnProperty('originalEvent'))
						{
							targetId = event.originalEvent.toElement.id;
						}
					}
					return targetId;
			}
			
			/*
			* This function will validate all possible conditions and based on that disable/enable deploy button
			*/
			function updateDeployButtonState()
			{
			    	var message = '';
					var disableDeploy = false;		
				    
					if(failedDependencyCount > 0)
					{
					    disableDeploy = true;
					    if (isStageSelected) {
					        message = localizer.getString('hpsum.advanceMode.StageDisabledDueToDependencyFailure');
					    }
					    else {
					        message = localizer.getString('hpsum.advanceMode.DeployDisabledDueToDependencyFailure');
					    }
					}
					if(!isEncryptionKeyValid())
					{
						disableDeploy = true;
						message = localizer.getString('hpsum.advanceMode.InvalidEncryptionKey');
					}
					if(selectedComponentsCount < 1 && selectedAssociatedNodes.length < 1)
					{ 		   
					    disableDeploy = true;
					    if (isStageSelected) {
					        message = localizer.getString('hpsum.advanceMode.StageDisabledDueTonoComponentsSelected');
					    }
					    else {
					        message = localizer.getString('hpsum.advanceMode.noComponentsSelectedFromAdvMode');
					    }
					}
					var compsig_missing_deploy = getCompsigMissingStatus();
					if(compsig_missing_deploy)
					{
						disableDeploy = true;
						message = localizer.getString('hpsum.advanceMode.deployDisabledDueToMissingSigFileInAssocNode');
					}
					if(skip_prereqs && compNeedPrereqInstall)
					{
						disableDeploy = true;
						 if (isStageSelected) {
					        message = localizer.getString('hpsum.advanceMode.StageDisabledAsNoPrereqInstallPermission');
					    }
					    else {
					        message = localizer.getString('hpsum.advanceMode.DeployDisabledAsNoPrereqInstallPermission');
					    }
					}
			        //add check for save installset details.
					if ($(SAVE_INSTALL_SET_CHECBOX).is(':checked')) {
					    if (($(INSTALL_SET_NAME_TEXT) != undefined && trimString($(INSTALL_SET_NAME_TEXT)) === '') || ($(INSTALL_SET_DESC_TEXT) != undefined && trimString($(INSTALL_SET_DESC_TEXT)) === '')) {
					        disableDeploy = true;
					        message = localizer.getString("hpsum.advanceMode.deployDisabledDueToNameDesc");
					    }
					}
					if ($(UPDATE_RECOVERY_SET_CHECKBOX).is(':checked')) {
					    if (($(UPDATE_RECOVERY_ILO_USERNAME) != undefined && trimString($(UPDATE_RECOVERY_ILO_USERNAME)) === '') || ($(UPDATE_RECOVERY_ILO_PASSWORD) != undefined && trimString($(UPDATE_RECOVERY_ILO_PASSWORD)) === '')) {
					        disableDeploy = true;
					        message = localizer.getString("hpsum.advanceMode.deployDisabledDueToiLOCredentialsReqd");
					    }
					}
					var item = {
						 disableDeploy : disableDeploy,
						 formStateViewMessage : message
						 };
					shouldEnableDeployment(item);
					$(DEPLOY).attr("disabled_org", $(DEPLOY)[0] && disableDeploy ? 1 : 0);
			}

			function getBaselinesSuccess(searchResults) {
			    baselines = $.grep(searchResults, function (option, index) {
			        return !(option.name.match(new RegExp('^Additional', 'i')));
			    });
			    hotfixes = $.grep(searchResults, function (option, index) {
			        return (option.name.match(new RegExp('^Additional', 'i')));
			    });

			}

			function getBaselinesError(msg) {

			}

			function getBaseline(string, handlers, count, start) {
			    var results = baselines;

			    //This code is added for future refernce. Handlling of unrefernced Component is required for Direct deploy and need to be tested when direct deploy will be enabled.
			    /*  
			        if (allInstallSets.length > 0) {
			           unrefCompIndex =  allInstallSets.indexOf(/Unreferenced_Components/i);
			           if (unrefCompIndex == -1)
			           {
                           //No Unreferenced Components
			               results = results.concat(allInstallSets);
			           }
			           else
			           {
			               //Remove Unreferenced Components and show baselines
			               var installSetWithoutUnrefComp = allInstallSets.splice(unrefCompIndex, 1);
			               results = results.concat(installSetWithoutUnrefComp);
			           }
                     }*/
			    
			    //include installsets and update task queue. 
			    if (allInstallSets.length > 0) {
			        results = results.concat(allInstallSets);
			    }

			    if (hasPendingTaskQueueItems) {
			        var taskQItem = {
			            "id": "ilo_queued_updates",
			            "name": localizer.getString('hpsum.common.pendingTaskQueue')
			        }
			        results = results.concat(taskQItem);
			    }

			    if (string && string.length > 0) {
			        results =
                       $.grep(baselines, function (option, index) {
                           return (option.name.match(
                                    new RegExp(string.replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1"), 'i')));
			        });
			    }
			    handlers.success({ count: results.length, members: results, start: 0, total: results.length });
			}

			function getHotfixes(string, handlers, count, start) {
			    var results = hotfixes;
			    if (nodeItem.node_state.match(/idle/i)) {
			        if (string && string.length > 0) {
			            results =
                           $.grep(hotfixes, function (option, index) {
                               return (option.name.match(
                                        new RegExp(string.replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1"), 'i')));
                           });
			        }
			        handlers.success({ count: results.length, members: results, start: 0, total: results.length });
			    }
			}

			function showAndHideDonutDetails(showFlag)
			{
			    if (showFlag) {
			        $('#hpsum-donut-components-details').show();
			        $(BASELINE_DETAILS_CONTAINER).height('220px');
			        $(CRITICALITY_DETAILS_CONTAINER).height('220px');
			    }
			    else
			    {
			        $('#hpsum-donut-components-details').hide();
			        $(BASELINE_DETAILS_CONTAINER).height('100px');
			        $(CRITICALITY_DETAILS_CONTAINER).height('100px');
			    }

			}

			function renderCriticalityDetails(item)
			{
			    var nodeState = "" ;
			    if(item && item.hasOwnProperty("nodes")) {
			        nodeState = item.nodes[0].nodeItem.node_state;
			        nodeType = item.nodes[0].nodeItem.type;
			        nodeName = item.nodes[0].nodeItem.name;
                  
			    }
			    $('#node-name-value').text(nodeName);
			    $('#node-type-value').text(displayILO(nodeType));
			    if (!isRegularBlSelectedForDeploy) {
			        showAndHideDonutDetails(false);
			    }
			    else
			    {
			        showAndHideDonutDetails(true);
			        var titlemsg = '';
			        if (nodeState == 'REMOTE_STAGING_UAN' || router.location().match(/stage/i ))
			            titlemsg = localizer.getString('hpsum.easymode.componentsSelectedForStaging');
			        else {
			            titlemsg = localizer.getString('hpsum.easymode.componentsSelectedForUpdate');
			        }
			        var totalcomponents = donutCriticalUpdates + donutRecoUpdates + donutOptUpdates + donutNonCateUpdates;

			        $('#node-total-components-details').text(totalcomponents + " " + titlemsg);
                  
			        $('#node-critical-updates-value').text(localizer.getString('hpsum.easymode.CriticalUpdates') + ' (' + donutCriticalUpdates + ')');
			        $('#node-recommended-updates-value').text(localizer.getString('hpsum.easymode.RecommendedUpdates') + ' (' + donutRecoUpdates + ')');
			        $('#node-optional-updates-value').text(localizer.getString('hpsum.easymode.OptionalUpdates') + ' (' + donutOptUpdates + ')');
			        $('#node-noncategorized-updates-value').text(localizer.getString('hpsum.easymode.NonCategorized') + ' (' + donutNonCateUpdates + ')');

			        var left = 60;

			        if (donutCriticalUpdates == 0 && donutRecoUpdates == 0 && donutOptUpdates == 0 && donutNonCateUpdates == 0) {
			            $.hpDonut($('#node-deploy-donut'), [
                                   { label: { value: 0, text: localizer.getString('hpsum.easymode.noUpdatesRequired') }, data: 100, color: "grey" }
			            ]);
			        }

			        else {
			            $.hpDonut($('#node-deploy-donut'), [
                        { label: { value: donutCriticalUpdates, text: "" }, data: (donutCriticalUpdates / totalApplicableComponents) * 100, color: "red" },
                        { label: { value: donutRecoUpdates, text: "" }, data: (donutRecoUpdates / totalApplicableComponents) * 100, color: "orange" },
                        { label: { value: donutOptUpdates, text: "" }, data: (donutOptUpdates / totalApplicableComponents) * 100, color: "green" },
                        { label: { value: donutNonCateUpdates, text: "" }, data: (donutNonCateUpdates / totalApplicableComponents) * 100, color: "skyblue" }
			            ]);
			        }
			        if (nodeState == 'REMOTE_STAGING_UAN') {
			            $('#details').attr('tooltip', localizer.getString('hpsum.easymode.notApplicableForStaging')).hpTooltip();
			            $('#node-deploy-donut').attr('tooltip', localizer.getString('hpsum.easymode.StagingDonutHelp')).hpTooltip();
			            $('#hpsum-node-deploy-stage-schdule').show();
			        }
			        else {
			            $('#details').attr('tooltip', localizer.getString('hpsum.easymode.ComplianceHelp')).hpTooltip();
			            $('#node-deploy-donut').attr('tooltip', localizer.getString('hpsum.easymode.DonutHelp')).hpTooltip();
			            $('#hpsum-node-deploy-stage-schdule').hide();
			        }
			    }
			}
                /*
                function to update deployment time on selection change of components.
                */
			function updateDeploymentTime()
			{
			    deploymentTime = 0;
			    for (var selComps = 0; selComps < selectedComponents.length; selComps++)
			    {
			        deploymentTime = deploymentTime + compDepTimeDetails[selectedComponents[selComps]];
			    }
			    renderDeploymentTime(deploymentTime);
			}
			
                /*
                function to update required disk space on selection change of components.
                */
			function updateRequiredDiskSpace()
			{
			    var BLRequiredDiskSpaceKb = 0;
			    var APRequiredDiskSpaceKb = 0;
			    var BLSelectedCompsCount = 0;
			    var APSelectedCompsCount = 0;
			    //default render zero values.
			    renderRequiredDiskSpace(BLSelectedCompsCount, BLRequiredDiskSpaceKb, BASELINE_OVERVIEW_SIZE_BL);
			    for (var selComps = 0; selComps < selectedComponents.length; selComps++)
			    {
			        if(BLCompReqDiskSpace.hasOwnProperty(selectedComponents[selComps]))
			        {
			            BLRequiredDiskSpaceKb = BLRequiredDiskSpaceKb + parseFloat(BLCompReqDiskSpace[selectedComponents[selComps]]);
			            BLSelectedCompsCount++;
			        }
			        else if(APCompReqDiskSpace.hasOwnProperty(selectedComponents[selComps]))
			        {
			            APRequiredDiskSpaceKb = APRequiredDiskSpaceKb + parseFloat(APCompReqDiskSpace[selectedComponents[selComps]]);
			            APSelectedCompsCount++;
			        }
			    }
			   
			    for (var baselineCount = 0; baselineCount < baselineInfo.length; baselineCount++) {
					
			        if (baselineInfo[baselineCount].name == "Additional Package") {
			            renderRequiredDiskSpace(APSelectedCompsCount, APRequiredDiskSpaceKb, BASELINE_OVERVIEW_SIZE_AP);
			        }
			        else{
			            renderRequiredDiskSpace(BLSelectedCompsCount, BLRequiredDiskSpaceKb, BASELINE_OVERVIEW_SIZE_BL);
			        }
			    }			
			}

            /*function to render the installset details*/
			function renderInstallsetDetails(installsetItem)
			{
			    if (installsetItem) {
			        $(IGNORE_WARNING_CHECKBOX_PANEL).hide(); //always hide ignore warning checkbox for instalsets and update task queue. 
			        $('#li-hpsum-deploy-page-tabs').css('padding-bottom', '1px');
			        $(BASELINE_DETAILS_CONTAINER).height('250px');
			        $(CRITICALITY_DETAILS_CONTAINER).height('250px');
			        $('#baseline-contents-list').hide();
			        $('#ilo-installset-contents-lists').show();
			        $('#hpsum-ilo-installset-overview-title').hide();
			        $('#hpsum-ilo-updatequeue-overview-title').hide();
			        $(ILO_TASKQUEUE_COMP_CONTAINER).hide();			        
			        $(ILO_INSTALLSET_COMP_CONTAINER).hide();
			        var sumComponentsCount = 0;
			        var uefiComponentsCount = 0;
			        var iLOComponentsCount = 0;
			        var installset_size = 0;
			        var totalComponents = 0;
			        if (installsetItem.id.match(/ilo_queued_updates/i)) //its pending update queue list.
			        {
			            isTaskQueueSelected = true;
			            $('#hpsum-ilo-updatequeue-overview-title').show();
			            $('#hpsum-ilo-installset-overview-title').hide();
			            $('#hpsum-installset-name-label').hide();
			            $(INSTALLSET_NAME).text('');
			            if (allPendingTaskQueueItems.ilotask.length > 0) {
			                totalComponents = allPendingTaskQueueItems.ilotask.length;
			                //if the first component of iLO task queue is any UEFI component, change deploy button to reboot button. 
			                var updatedByListOfFirstComp = allPendingTaskQueueItems.ilotask[0].updatedby;
			                if (updatedByListOfFirstComp.length > 0)
			                {
			                    if (updatedByListOfFirstComp[0].match(/uefi/i))
			                    {
			                        $(DEPLOY).val(localizer.getString('hpsum.RebootConfirm.title'));
			                        isUefiUpdatableComp = true;
			                    }
			                    else {
			                        isUefiUpdatableComp = false;
			                    }
			                }
			                var uefiCompFoundInMiddle = false;
			                var otherCompsFoundAfterUefi = false;
			                for (var eachcomp = 0; eachcomp < allPendingTaskQueueItems.ilotask.length; eachcomp++) {
			                    var iloTaskQueueItem = allPendingTaskQueueItems.ilotask[eachcomp];
			                    installset_size = installset_size + iloTaskQueueItem.size;
			                    var updatedByList = iloTaskQueueItem.updatedby;
			                    if (updatedByList.length > 0) {
			                        if (updatedByList[0].match(/uefi/i)) {
			                            if (eachcomp < allPendingTaskQueueItems.ilotask.length) { uefiCompFoundInMiddle = true; }
			                            uefiComponentsCount++;
			                        } else if (updatedByList[0].match(/SUM\/iSUT/i) || updatedByList[0].match(/runtimeagent/i)) {
			                            if (uefiCompFoundInMiddle) { otherCompsFoundAfterUefi = true; }
			                            sumComponentsCount++;
			                        } else if (updatedByList[0].match(/ilo/i)) {
			                            if (uefiCompFoundInMiddle) { otherCompsFoundAfterUefi = true; }
			                            iLOComponentsCount++;
			                        }
			                    }
			                }
			            }

			            if (installset_size > 1024) {
			                installset_size = installset_size / 1024;
			                installset_size = installset_size.toFixed(2);
			                installset_size = installset_size + ' MB';
			            }
			            else {
			                installset_size = installset_size.toFixed(2);
			                installset_size = installset_size + ' KB';
			            }

			            var totalCompSizehtml = totalComponents;
			            $(INSTALLSET_SIZE).html(' : ' + installset_size);
			            $(INSTALLSET_COMP_TOTAL).html(" : " + totalCompSizehtml);
			            $(INSTALLSET_SUM_COMPS).html(" : " + sumComponentsCount);
			            var uefiCompNo = (uefiComponentsCount > 0) ? " (Needs Reboot)" : "";
			            $(INSTALLSET_UEFI_COMPS).html(" : " + uefiComponentsCount + uefiCompNo);
			            var iloCompNo = (iLOComponentsCount > 0) ? " (Needs Reboot)" : "";
			            $(INSTALLSET_ILO_COMPS).html(" : " + iLOComponentsCount + iloCompNo);

			            $(ILO_TASKQUEUE_COMP_CONTAINER).show();
			            $(ILO_TASKQUEUE_COMP_TITLE).show();
			            $(ILO_TASKQUEUE_COMP_TITLE).html(localizer.getString('hpsum.common.updateTaskQueueTitle'));

			            $(ILO_TASKQUEUE_COMPONENTS).hpsumAddiLOTaskDetails('init');
			            var ilotaskdata = {};
			            ilotaskdata.hapi = {};
			            ilotaskdata.hapi.ilotasks = allPendingTaskQueueItems;
			            // populate components table.
			            var options = {
			                command: 'populateComponentsTable',
			                nodeid: nodeItem.node_id,
			                step: 0,
			                data: ilotaskdata
			            };			            
			            $(ILO_TASKQUEUE_COMPONENTS).hpsumAddiLOTaskDetails(options);
			            //set the selected baseline in baseline combo
			            $(BASELINES).hpSearchCombo('set', { id: installsetItem.id, name: installsetItem.name });
			            //check if there are any type A,B or D components after type C components. if yes, add the below message to warnings list.
			            if (otherCompsFoundAfterUefi) {
			                isWarningsset = true;
			                var warningMsgItem = {
			                    type: "ilo",
			                    message: localizer.getString('hpsum.common.postDeployexecutablesExist')

			                }
			                var alreadyAdded = false;
			                for (var len = 0; len < nodeItem.warnings.length; len++) {
			                    if (nodeItem.warnings[len].message.match(warningMsgItem.message)) {
			                        alreadyAdded = true;
			                        break;
			                    }
			                }
			                if(!alreadyAdded){
			                    nodeItem.warnings.push(warningMsgItem);
			                }
			                $('#hpsum-warning-messages').show();
			                $('#hpsum-warning-messages').hpsumWarnings(nodeItem, ignore_warnings_chkbox_needed);
			            }
			        }
			        else //its an installset. 
			        {
			            $('#hpsum-ilo-installset-overview-title').show();
			            $('#hpsum-ilo-updatequeue-overview-title').hide();
			            $('#hpsum-installset-name-label').show();
			            $(ILO_TASKQUEUE_COMP_TITLE).hide();
			            var item = {
			                node_id: nodeItem.node_id,
			                installset_id: installsetItem.id
			            };
			            isInstallsetSelected = true;
				    //call validate recoveryset after getting the installset
				    validateToUpdateRecoverySet(nodeItem);
					
			            presenter.getInstallSetDetails(item, {
			                success: function (data) {
			                    $(ILO_INSTALLSET_COMP_CONTAINER).show();

			                    // populate components table.
			                    var options = {
			                        command: 'init',
			                        data: data
			                    };
			                    $(ILO_INSTALLSET_COMPONENTS).hpsumInstallSetComponents(options);

			                    var installset = data.hapi.installset;
			                    installset_size = (installset.size / 1024);
			                    if (installset_size > 1024) {
			                        installset_size = installset_size / 1024;
			                        installset_size = installset_size.toFixed(2);
			                        installset_size = installset_size + ' MB';
			                    }
			                    else {
			                        installset_size = installset_size.toFixed(2);
			                        installset_size = installset_size + ' KB';
			                    }
			                    var uefiCompFoundInMiddle = false;
			                    var otherCompsFoundAfterUefi = false;
			                    for (var eachcomp = 0; eachcomp < installset.components.component.length; eachcomp++) {
			                        totalComponents = installset.components.component.length;
			                        var updatedByList = installset.components.component[eachcomp].updatedby;
			                        if (updatedByList[0].match(/UEFI/i)) {
			                            if (eachcomp < installset.components.component.length) { uefiCompFoundInMiddle = true; }
			                            uefiComponentsCount++;
			                        } else if (updatedByList[0].match(/SUM\/iSUT/i)) {
			                            if (uefiCompFoundInMiddle) { otherCompsFoundAfterUefi = true; }
			                            sumComponentsCount++;
			                        } else if (updatedByList[0].match(/ilo/i)) {
			                            if (uefiCompFoundInMiddle) { otherCompsFoundAfterUefi = true; }
			                            iLOComponentsCount++;
			                        }
			                    }

			                    var totalCompSizehtml = totalComponents;
			                    $(INSTALLSET_NAME).html(' : ' + installset.name);
			                    $(INSTALLSET_SIZE).html(' : ' + installset_size);			                   
			                    $(INSTALLSET_COMP_TOTAL).html(" : " + totalCompSizehtml);
			                    $(INSTALLSET_SUM_COMPS).html(" : " + sumComponentsCount);			                   
			                    var uefiCompNo = (uefiComponentsCount > 0) ? " (Needs Reboot)" : "";
			                    $(INSTALLSET_UEFI_COMPS).html(" : " + uefiComponentsCount + uefiCompNo);
			                    var iloCompNo = (iLOComponentsCount > 0) ? " (Needs Reboot)" : "";
			                    $(INSTALLSET_ILO_COMPS).html(" : " + iLOComponentsCount + iloCompNo);
                                 //set the selected baseline in baseline combo
			                    $(BASELINES).hpSearchCombo('set', { id: installset.id, name: installset.name });
			                    //check if there are any type A,B or D components after type C components. if yes, add the below message to warnings list.
			                    if(otherCompsFoundAfterUefi)
			                    {

			                        isWarningsset = true;
			                        var warningMsgItem = {
			                            type: "ilo",
			                            message: localizer.getString('hpsum.common.postDeployexecutablesExist')

			                        }
			                        var alreadyAdded = false;
			                        for (var len = 0; len < nodeItem.warnings.length; len++) {
			                            if (nodeItem.warnings[len].message.match(warningMsgItem.message)) {
			                                alreadyAdded = true;
			                                break;
			                            }
			                        }
			                        if(!alreadyAdded){
			                            nodeItem.warnings.push(warningMsgItem);
			                        }
			                        $('#hpsum-warning-messages').show();
			                        $('#hpsum-warning-messages').hpsumWarnings(nodeItem, ignore_warnings_chkbox_needed);
			                    }
			                }
			            });
			        }
			    }
			}
			
                /*
                function to convert the deployment time to the expected format and set the value on UI.
                */
			function renderDeploymentTime(deploymentTime)
			{
			    $('#estimated_time').show();
			    if (nodeItem.node_state == 'REMOTE_STAGING_UAN' || nodeItem.node_state == 'IDLE') {
			        $('#estimated_time').html(' n/a');
			        //$('#hpsum-baseline-overview').hide();
			    }
			    else {
			        var date = new Date(null);
			        date.setHours(0);
			        date.setMinutes(0);
			        date.setSeconds(deploymentTime); // specify value for SECONDS here
			        var timeToString = date.toTimeString().substr(0, 8);
			        var splitTime = timeToString.split(':');
			        var count = 0;
			        var timeUnit = [localizer.getString('hpsum.easymode.hours') ,localizer.getString('hpsum.easymode.minutes') ,localizer.getString('hpsum.easymode.seconds')];
			        var time = "";
			        for(var splitCount = 0;splitCount < splitTime.length; splitCount++)
			        {
			            if(splitTime[splitCount] != '00')
			            {
			                time = time + splitTime[splitCount]+ " " + timeUnit[splitCount] + " ";
			                if(count ==1)
			                    break;
			                count++;
			            }							
			        }
			        if(time == "")
			        {
			            time = "0 Minute";
			        }
			        $('#estimated_time').html(time);
			    }
			    if(isStageSelected)
			    {
			        $('#estimated_time').hide();
			    }
			}
			
			
			function renderRequiredDiskSpace(selectedCompsCount, requiredDiskSpace, elemId)
			{			
			    var size = "",bldetails = "";
			    var sizeType = ["KB" ,"MB" , "GB"];
			    var decimalIndex = -1,index = 0;
								
			    while(requiredDiskSpace > 1024)
			    {
			        requiredDiskSpace = requiredDiskSpace/1024;
			        index ++;
			    }
			    size =  requiredDiskSpace.toString();
			    decimalIndex = size.indexOf('.');
			    if(decimalIndex > 0){
			        size = size.substr(0, decimalIndex+3);
			    }
			    size =  size + " " + sizeType[index];
			    bldetails = localizer.getString('hpsum.easymode.selectedComponents') + selectedCompsCount + ', ' + localizer.getString('hpsum.easymode.size') + size;
			    $(elemId).html(bldetails);					
			}

			function onSelectionChange(item)
			{
			    selectedComponents = item.selectedComponents.component;
			    donutCriticalUpdates = 0;
			    donutRecoUpdates = 0;
			    donutOptUpdates = 0;
			    donutNonCateUpdates = 0;
			    var criticality = '';
			    
			    if (selectedComponents.length > 0) {
			        for (var selComps = 0; selComps < selectedComponents.length; selComps++) {
			            criticality = compCriticalityDetails[selectedComponents[selComps]];

			            if (compCriticalityDetails[selectedComponents[selComps]] == "Optional") {
			                donutOptUpdates = donutOptUpdates + 1;
			            }
			            else if (compCriticalityDetails[selectedComponents[selComps]] == "Recommended") {
			                donutRecoUpdates = donutRecoUpdates + 1;
			            }
			            else if (compCriticalityDetails[selectedComponents[selComps]] == "Critical") {
			                donutCriticalUpdates = donutCriticalUpdates + 1;
			            }
			            else {
			                donutNonCateUpdates = donutNonCateUpdates + 1;
			            }
			        }
			        if (item.selectedComponents.hasOwnProperty("failed_dependency")) {
			            failedDepCount = item.selectedComponents.failed_dependency;
			        }
			    }
			    updateDeploymentTime();
			    updateRequiredDiskSpace();
			    if(failedDepCount > 0 && !isPartOfGroup)
			    {
			        $(SKIP_DEPENDENCY_CHECKBOX).attr('disabled', false);
			    }			   
			}

			function populateBaselineDetails(baselineList)
			{
			    if (baselineList.length > 0) {
			        for (var i = 0; i < baselineList.length; i++) {
			            var baseline = presenter.getBaselineDetailsforId(baselineList[i]);
			            if (baseline) {
			                isBaselineSelected = true;
			                if (baseline.name.match(/^Additional Package/i)) {
			                    $(HOTFIX).hpSearchCombo('set', { id: baseline.id, name: baseline.name });

			                } else {
			                    $(BASELINES).hpSearchCombo('set', { id: baseline.id, name: baseline.name });
			                }
			                renderDirectDeployBaselineDetails(baseline);
			            }
			            else {
			                if (iloManagementOptionNeeded && baselineList.length > 0 && baselineList[0].indexOf('/') == -1)
			                {
			                    var installItem = {
			                        "id": baselineList[0],
			                        "name": baselineList[0]
			                    };                                          
			                    renderInstallsetDetails(installItem);
			                }
			            }
			        }
			    }
			    else {
			        renderDirectDeployBaselineDetails(null);
			    }
			}

			function renderDirectDeployBaselineDetails(item) {
			    showAndHideDonutDetails(false);

			    $('#baseline-contents-list').show();
			    $('#ilo-installset-contents-lists').hide();
			    $('#li-ilo-saved-installset-components').hide();
			    $('#li-ilo-taskqueue-components').hide();
			    $(estimatedTimeTitle).hide();
			    $('#estimated_time').hide();
			    var html = '', ddBbaselineCount = 0, nobaselines = true;
			    var ddBaselineDetails = [];
			    if (item) {
			        var html = '';

			        //take bth spp and additional package and create the baselines. 
			        if ($(BASELINES).val() != '') {
			            var baselinedetails = presenter.getBaselineDetailsforId($(BASELINES).val());
			            if (baselinedetails) {
			                ddBaselineDetails[ddBbaselineCount] = baselinedetails;
			                ddBbaselineCount++;
			            }
			        }
			        if ($(HOTFIX).val() != '') {
			            var addBaselinedetails = presenter.getBaselineDetailsforId($(HOTFIX).val());
			            if (addBaselinedetails) {
			                ddBaselineDetails[ddBbaselineCount] = addBaselinedetails;
			                ddBbaselineCount++;
			            }
			        }

			        if (ddBaselineDetails.length > 0)
			        {
			            nobaselines = false;
			            if (ddBbaselineCount > 1) {
			                $(BASELINE_DETAILS_CONTAINER).height('150px');
			                $(CRITICALITY_DETAILS_CONTAINER).height('150px');
			            }
			            else {
			                $(BASELINE_DETAILS_CONTAINER).height('100px');
			                $(CRITICALITY_DETAILS_CONTAINER).height('100px');
			            }
			            for (var baselineCount = 0; baselineCount < ddBaselineDetails.length; baselineCount++) {
			                var requiredDiskSpace = ddBaselineDetails[baselineCount].size;
			                var size = "", bldetails = "";
			                var sizeType = ["KB", "MB", "GB"];
			                var decimalIndex = -1, index = 0;

			                while (requiredDiskSpace > 1024) {
			                    requiredDiskSpace = requiredDiskSpace / 1024;
			                    index++;
			                }
			                size = requiredDiskSpace.toString();
			                decimalIndex = size.indexOf('.');
			                if (decimalIndex > 0) {
			                    size = size.substr(0, decimalIndex + 3);
			                }
			                size = size + " " + sizeType[index - 1];
			                html = html +
                            '<li style="padding-top:10px;padding-left:5px;">' +
                                '<label for="hpsum-baseline-overview-name" style="width:250px;text-align:left;padding-left:5px;font-weight:bold;" >' + ddBaselineDetails[baselineCount].name + '</label>' +
                                '</li>' +
                            '<li style="padding-top:10px;padding-left:5px;">' +
                                '<label for="hpsum-baseline-total-size" style="text-align:left;padding-left:5px;">' + localizer.getString('hpsum.easymode.totalSize') + size + '</label>';

			            }

			            html = html + '</li>'
			            $(eachBaselineDetailsContainer).html(html);			            
			        }			       
			    }
			    if (nobaselines)
			    {
			        html = '<li style="padding-top:10px;padding-left:5px;">' +
                    '<label for="hpsum-baseline-overview-name" style="width:250px;text-align:left;padding-left:5px;font-weight:bold;" >' +
                    localizer.getString('hpsum.node.noBaselineSelected') + '</label>' + '</li>';
			        $(eachBaselineDetailsContainer).html(html);			        
			    }
			}
			function renderBaselineDetails()
			{
			    //$(BASELINE_DETAILS_CONTAINER).height('100px');
			   // $(CRITICALITY_DETAILS_CONTAINER).height('100px');
			    $('#baseline-contents-list').show();
			    $('#ilo-installset-contents-lists').hide();
			    var html = '';
			    if (baselineInfo.length > 0) {
			        for (var baselineCount = 0; baselineCount < baselineInfo.length; baselineCount++) {
			            html = html +
                        '<li style="padding-top:10px;padding-left:5px;">' +
                            '<label for="hpsum-baseline-overview-name" style="width:250px;text-align:left;padding-left:5px;font-weight:bold;" >' + baselineInfo[baselineCount].name + '</label>' +
                            '</li>' +
                        '<li style="padding-top:10px;padding-left:5px;">' +
                            '<label for="hpsum-baseline-total-size" style="text-align:left;padding-left:5px;">' + localizer.getString('hpsum.easymode.totalSize') + baselineInfo[baselineCount].size + '</label>' +
                            '</li>' +
                        '<li style="padding-top:10px;padding-left:5px;">';

			            if (baselineInfo[baselineCount].name == "Additional Package") {
			                html = html + '<label id="hpsum-baseline-overview-version-size_ap"';
			            }
			            else {
			                html = html + '<label id="hpsum-baseline-overview-version-size_bl"';
			            }
			            html = html + 'style="text-align:left;padding-left:5px;"' +
                                                        'rel="localize[hpsum-baseline-overview-version-size]"></label></li>';

			        }

			        html = html + '</li>'
			        $(eachBaselineDetailsContainer).html(html);
			        if (isStageSelected) {
			            $(estimatedTimeTitle).hide();
			            $('#estimated_time').hide();
			        }
			        else
			        {
			            $(estimatedTimeTitle).show();
			            $('#estimated_time').show();
			            renderDeploymentTime(deploymentTime);
			        }
			    }
			    else
			    {
			        html = '<li style="padding-top:10px;padding-left:5px;">' +
                        '<label for="hpsum-baseline-overview-name" style="width:250px;text-align:left;padding-left:5px;font-weight:bold;" >' + 
                        localizer.getString('hpsum.node.noBaselineSelected') + '</label>' + '</li>';
			        $(eachBaselineDetailsContainer).html(html);
			        $(estimatedTimeTitle).hide();
			    }
			    
			}

			function calculateBaselineDetails(item)
			{
			    var baselines = item.baselines.baseline;
			    optApplicable = 0;
			    recoApplicable = 0;
			    critApplicable = 0;
			    unknownApplicable = 0;
			    critInstallNeeded = 0;
			    recoInstallNeeded = 0;
			    optInstallNeeded = 0;
			    unknownInstallNeeded = 0;
			    donutCriticalUpdates = 0;
			    donutRecoUpdates = 0;
			    donutOptUpdates = 0;
			    donutNonCateUpdates = 0;
			    deploymentTime = 0;
			    totalApplicableComponents = 0;
			    failedDepCount = 0;
			    compCriticalityDetails = {};
			    nodeItem = item.nodes[0].nodeItem;
			    nodeName = item.nodes[0].nodeItem.name;
			    nodeType = item.nodes[0].nodeItem.type;
			    isConfigPasswordRequired = item.nodes[0].nodeItem.is_config_password_required;
			    isFIPSEnabled = nodeItem.fips_enabled;
			    selectedComponents = [];
			    baselineInfo = [];
			    BLCompReqDiskSpace = {};
			    APCompReqDiskSpace = {};
			    if (baselines) {
			        for (var baselineCount = 0; baselineCount < baselines.length; baselineCount++) {
			            var baseline = baselines[baselineCount];
			            baselineInfo[baselineCount] = {
			                'name': baseline.baseline_name,
			                'version': baseline.baseline_version,
			                'size': baseline.baseline_size
			            };
			            if (baseline.hasOwnProperty('components') == true) {
			                var components = baseline.components.component;
			                totalApplicableComponents = totalApplicableComponents + components.length;
			                for (var componentCount = 0; componentCount < components.length; componentCount++) {
			                    if (components[componentCount].selected == true && components[componentCount].has_failed_dependencies == true) {
			                        failedDepCount = failedDepCount + 1;
			                    }
			                    compDepTimeDetails[components[componentCount].file_name] = components[componentCount].deployment_time;
			                    if (components[componentCount].required_disk_space_kb != "") {
			                        if (baseline.baseline_id.indexOf("BP_ABL") == -1) {
			                            BLCompReqDiskSpace[components[componentCount].file_name] = components[componentCount].required_disk_space_kb;
			                        }
			                        else {
			                            APCompReqDiskSpace[components[componentCount].file_name] = components[componentCount].required_disk_space_kb;
			                        }
			                    }
			                    var criticality = components[componentCount].criticality;
			                    compCriticalityDetails[components[componentCount].file_name] = criticality;
			                    if (criticality == "Optional") {
			                        optApplicable = optApplicable + 1;
			                        if (components[componentCount].outside_of_compliance_level == true) {
			                            optInstallNeeded = optInstallNeeded + 1;
			                        }
			                        if (components[componentCount].selected == true) {
			                            donutOptUpdates = donutOptUpdates + 1;
			                            selectedComponents.push(components[componentCount].file_name);
			                        }
			                    }
			                    else if (criticality == "Recommended") {
			                        recoApplicable = recoApplicable + 1;
			                        if (components[componentCount].outside_of_compliance_level == true) {
			                            recoInstallNeeded = recoInstallNeeded + 1;
			                        }
			                        if (components[componentCount].selected == true) {
			                            donutRecoUpdates = donutRecoUpdates + 1;
			                            selectedComponents.push(components[componentCount].file_name);
			                        }
			                    }
			                    else if (criticality == "Critical") {
			                        critApplicable = critApplicable + 1;
			                        if (components[componentCount].outside_of_compliance_level == true) {
			                            critInstallNeeded = critInstallNeeded + 1;
			                        }
			                        if (components[componentCount].selected == true) {
			                            donutCriticalUpdates = donutCriticalUpdates + 1;
			                            selectedComponents.push(components[componentCount].file_name);
			                        }
			                    }
			                    else {
			                        unknownApplicable = unknownApplicable + 1;
			                        if (components[componentCount].outside_of_compliance_level == true) {
			                            unknownInstallNeeded = unknownInstallNeeded + 1;
			                        }
			                        if (components[componentCount].selected == true) {
			                            donutNonCateUpdates = donutNonCateUpdates + 1;
			                            selectedComponents.push(components[componentCount].file_name);
			                        }
			                    }

			                    if (components[componentCount].selected == true) {
			                        deploymentTime = deploymentTime + components[componentCount].deployment_time;
			                    }
			                }
			            }
			        }
			        gradient = 0;
			        var critValue = 0;
			        var recoValue = 0;
			        if (critApplicable != 0) {
			            critValue = (critInstallNeeded / critApplicable) * 33;
			        }
			        if (recoApplicable != 0) {
			            recoValue = ((recoInstallNeeded + unknownInstallNeeded) / (recoApplicable + unknownApplicable)) * 33;
			        }
			        if (optApplicable != 0) {
			            var optValue = (optInstallNeeded / optApplicable) * 33;
			        }
			        if (critValue > 1) {
			            gradient = critValue + 66;
			        }
			        else if (recoValue > 1) {
			            gradient = recoValue + 33;
			        }
			        else {
			            gradient = optValue;
			        }
			        //multiplying gradient by 2 as horizontal compliance bar width= 200px
			        gradient = gradient * 2;
			    }
			}

			function renderBaselineData(item)
			{
			    //formStateView.setMessage({
			    //    summary: localizer.getString('hpsum.easymode.dataPopulationInProgress'),
			    //    changing: true,
			    //    status: 'warning'
			    //});
			    var nodeData = nodeItem;			    
			    if (nodeData.node_state == 'UAN' ) {
			        calculateBaselineDetails(item);
			    }
			    else if (nodeData.node_state == 'REMOTE_STAGING_UAN') {
			        //nodeItem = item.nodes[0].nodeItem;
			        var baselines = item.baselines;

			        for (var baselineCount = 0; baselineCount < baselines.length; baselineCount++) {
			            var baseline = baselines[baselineCount];
			            baselineInfo[baselineCount] = {
			                'name': baseline.baseline_name,
			                'version': baseline.baseline_version,
			                'size': baseline.baseline_size
			            };
			        }
			        var comp_info = item.baselines.component_info;
			        donutCriticalUpdates = parseInt(comp_info.Critical);
			        donutRecoUpdates = parseInt(comp_info.Recommended);
			        donutOptUpdates = parseInt(comp_info.Optional);
			        donutNonCateUpdates = parseInt(comp_info.Unknown);;
			        totalApplicableComponents = donutCriticalUpdates + donutRecoUpdates +
											donutOptUpdates + donutNonCateUpdates;
			    }
			    renderCriticalityDetails(item);
			    if (isRegularBlSelectedForDeploy) {
			        renderBaselineDetails();
			    
			    }
			    else {
			        if (iloManagementOptionNeeded)
			        {
			            var installsetItem = {
			                "id": item.baselines[0],
			                "name": item.baselines[0]
			            }
			            renderInstallsetDetails(installsetItem);
			        }
			    }
			    //formStateView.reset();
			}
			
			function changetoStagePage ()
			{
				$(TAB_INSTALLATION_OPTIONS).text(localizer.getString("hpsum.easymode.StagingOptions"));
				$(DOWNGRADE_REWRITE_TEXT).html(localizer.getString("hpsum.easymode.StagingOptionsMessage"));
				$(CLEANUP_ONEXIT_OPTIONS_LABEL).text(localizer.getString("hpsum.easymode.cleanuponexitstage"));
				$(DELETE_INSTALLSET_OPTION_DESCR).html(localizer.getString("hpsum.easymode.chooseExistingInstallsetForDeleteStaging"));
			}

            /**
             * @public
             */
			this.resume = function () {
				
				if (router.location().match(/stage/i))
				{
					changetoStagePage();
				}
				tempAbortInProgress = false;
				formStateView.init({form: FORM,
                    routePattern: ROUTE_PREFIX + '.*',
                    autoTrack: false
				});
				               
				$("#schedule").hpsumSchedule({				    
				    enableButton: function () {
				        var disableDeploy = false;
						if (isWarningsset) {
						    disableDeploy = false;
                        }
						else
						{
						    disableDeploy = true;
						}
						if (disableDeploy) {
						    var item = {
						        disableDeploy: disableDeploy
						    };
						    shouldEnableDeployment(item);
						}
						else {
						    if (isInstallsetSelected != true) { /* When insallset as a basline is selected, we don't need to call this function */
						        updateDeployButtonState();
						    }
						}
                    },
                    disableButton: function () {
                        $(DEPLOY).attr("disabled", "disabled");
                    }
                });
            	reset();
				reRenderAssociatedNodesOnce = true;
				reRenderBaselineDetails = true;
				invalidComponentsSelected = false;
				formStateView.reset();
				warningMessage = '';
				presenter.on("itemChange", onItemChange);
				$(PANELS).hpStackedPanels('resume');
				$(SCHEDULE_TIME_LABEL).removeClass("hp-error");
				$(SCHEDULE_TIME_LABEL).hide();
				inventoryInProgress = false;
				$(HOTFIX).hpSearchCombo('set', { id: '', name: '' });
				baselines = hotfixes = localizer.getString('hpsum.common.loading');
				presenter.getAllBaselines({
				    success: getBaselinesSuccess,
				    error: getBaselinesError
				});
				iloManagementOptionNeeded = false;
				$(REMOVE_GRP_CHECKBOX).prop("checked", false);
			    $(SKIP_DEPENDENCY_CHECKBOX).prop('checked', false);
			    $(SAVE_INSTALL_SET_CHECBOX).prop('checked', false);
			    $(IGNORE_WARNING_CHECKBOX).prop('checked', false);
			    $(IGNORE_WARNING_CHECKBOX_PANEL).hide();
			    $(INSTALL_SET_NAME_TEXT).attr('value', "");   //.value = "";
				$(INSTALL_SET_DESC_TEXT).attr('value', "");
				$(INSTALL_SET_NAME_TEXT).attr('disabled', true);
				$(INSTALL_SET_DESC_TEXT).attr('disabled', true);
				$('#hpsum-delete-install-sets-option').attr('checked', "checked");
				$(CLEANUP_ALLONEXIT).prop('checked', cleanupallonexit);
				$(CLEANUP_ONEXIT).prop('checked', cleanuponexit);
				$('#li-hpsum-select-install-sets-for-delete').hide();
				updateEditableFields(nodeItem, false);
				$(BASELINES).hpSearchCombo('set', { id: '', name: '' });
				$(BASELINE_INPUT).removeClass("hp-error");
				$(HOTFIX_INPUT).removeClass("hp-error");
				$(BASELINE_INPUT_ERR).hide();
				$(HOTFIX_INPUT_ERR).hide();
				//hide warning panel. Will be shown along with hpsumDeployNode plugin. fix for fix QXCR1001424953
				$('#hpsum-warning-messages').hide();
				warningMsg = "";
				isWarningsset = false;
				tmpScheduleTime = "";
				isPartOfGroup = false;
				$('#li-hpsum-deploy-page-tabs').css('padding-bottom', '1px');
				hasPendingTaskQueueItems = false;
				$(DEPLOY).attr('disabled', 'disabled');
				$(DEPLOY).attr("disabled_org", 0); //this is required to make ignore warnings work for idle state. 
				allInstallSets = [];
				shouldDisableDeploy = false;
				isUefiUpdatableComp = false;
				isTaskQueueSelected = false;
				isInstallsetSelected = false;
				$(INSATLLSET_NAME_REQUIRED).hide();
				$(INSTALLSET_DESC_REQUIRED).hide();
				$(INSTALL_SET_NAME_TEXT).removeClass('hp-error');
				$(INSTALL_SET_DESC_TEXT).removeClass('hp-error');
            };
            

            this.pause = function () {
				//Hiding deploy plugin data and warning panel as we will show them only when complete data is ready, so that we avoid showing old data from previously opened node deploy page. There two containers will be shown (.show()) in 'renderNodeDeployWidget'. This is done to fix QXCR1001424953
				$(DEPLOY_NODE_PLUGIN).hide();
				$('#hpsum-warning-messages').hide();
				//clear the formStateView warning if any so that when we switch to another node, old unwanted warning is not shown
				formStateView.reset();
                var resetToggle = {
						command : 'resetToggle'
				}
				//$(DEPLOY_NODE_PLUGIN).hpsumDeployNode(resetToggle);
				selectedAssociatedNodes = [];
				presenter.off("itemChange", onItemChange);
				$('.hpsumInstallables').hpsumInstallables('destroy');
				$(ILO_MGMT_OPTIONS_INSTALLSET_PLUGIN_PANEL).hpsumInstallSets('destroy');
				$(ILO_INSTALLSET_COMPONENTS).hpsumInstallSetComponents('destroy');
				$('#schedule').hpsumSchedule('destroy');
                $(PANELS).hpStackedPanels('pause');                
                tmpScheduleTime = "";
                $(BASELINES).hpSearchCombo('set', { id: '', name: '' });
                $(HOTFIX).hpSearchCombo('set', { id: '', name: '' });
                $('#li-hpsum-deploy-page-tabs').css('padding-bottom', '1px');

            };
            
            /**
             * @public
             * Initialization funtion for the object
             * All the controls actions are initialized in this function.
             */
            this.init = function() {
				tempAbortInProgress = false;
			// put help in header
                if ($('.hp-details-header-controls', $(FORM).parent()).length === 0) {
                    var headerHelp = $(headerHelpHtml);
                    localizer.localizeDom(headerHelp);
                    $('.hp-details-header', $(FORM).parent()).append(headerHelp);
                }
                $(INSTALLATION_FORCE_OPTIONS).attr('tooltip', localizer.getString('hpsum.node.installationOptions.help')).hpTooltip();
                $('#hpsum-node-deploy-vc-encryption-collapsible div.hp-form-content').attr('tooltip', localizer.getString('hpsum.node.vcFIPSEncryptionKeyHelp')).hpTooltip();
                
                $(DEPLOY).live('click', function (ev) {

				//if ($(DEPLOY).value == "Deploy" || $(DEPLOY).value == "Stage")
				//{
                   	onDeploy.call(this);
				//} 				
				ev.preventDefault();
                });
				
                //By Default reboot-options value is Never so disable the Reboot delay and Reboot message.
				$(REBOOT_DISABLE).find('input,textarea,select,button').prop("disabled", true);
				$('input[name=hpsum-delete-install-sets-options]:radio').change(function () {
				    var selectedvalue = $(this).val();
				    $('#li-hpsum-select-install-sets-for-delete').hide();
				    if (selectedvalue == "two") {
				        $('#li-hpsum-select-install-sets-for-delete').show();
				    }				   
				});

				$(REBOOTOPTION).selectBox({ autoWidth: false });
				$('#hpsum-Enet-order').selectBox({ autoWidth: false });
				$('#hpsum-fc-order').selectBox({ autoWidth: false });
				$(SDFLEX_REBOOT_OPTION).selectBox({ autoWidth: false});

				$(REBOOTOPTION).change(function () {
					var type = $('#hpsum-reboot-option option:selected').val();
					if (type == "Never") {
						$(REBOOT_DISABLE).find('input,textarea,select,button').prop("disabled", true);
						$(DELAYMINUTES).val('');
						$(DELAYMINUTES).removeClass("hp-error");
						$(DELAYSECERR).hide();
                        rebootSelectionChanged = false;
					}
					else
					{
						$(REBOOT_DISABLE).find('input,textarea,select,button').prop("disabled", false);
                        rebootSelectionChanged = true;
					}
				});
				$('#hpsum-downgrade-rewrite-text').html(localizer.getString("hpsum.node.installationOptions.message"));
				$('#hpsum-downgrade-rewrite-text').removeClass('hp-collapsed');
				//$(ANALYSIS).attr('tooltip', localizer.getString('hpsum.common.deployPreviewToolTip')).hpTooltip();
				$(INSTALL_ERROR).hide();
				$(INSTALLATIONOPTION).val('upgradeBoth');
				$("#hpsum-installation-option").change(function () {
				    if(nodeItem.node_state.match(/UAN/i)){
				        applyInstallationOptions.call();
				    }
				});
				
				$(UPDATE_RECOVERY_SET_CHECKBOX).click(function() {
					if($(UPDATE_RECOVERY_SET_CHECKBOX).is(':checked')) {						
						if (nodeItem.server_generation >= 10 && !nodeItem.ilo_credentials_available)
						{
							$(UPDATE_RECOVERY_ILO_CRDENTIALS_DETAILS).show();
							$(UPDATE_RECOVERY_ILO_USERNAME).val("");
							$(UPDATE_RECOVERY_ILO_USERNAME).removeClass('hp-error');
							$(UPDATE_RECOVERY_ILO_USERNAME_ERR).hide();
							$(UPDATE_RECOVERY_ILO_PASSWORD).val("");
							$(UPDATE_RECOVERY_ILO_PASSWORD).removeClass('hp-error');
							$(UPDATE_RECOVERY_ILO_PASSWORD_ERR).hide();							
							
							//disable deploy button because user has to enter iLO credentials
							var item = {
								disableDeploy: true,
								formStateViewMessage: localizer.getString('hpsum.advanceMode.deployDisabledDueToiLOCredentialsReqd')
							};
							shouldEnableDeployment(item);
						}
					}
					else
					{
					    $(UPDATE_RECOVERY_ILO_CRDENTIALS_DETAILS).hide();
					    updateDeployButtonState();
					}					
				});

				$(SAVE_INSTALL_SET_CHECBOX).click(function () {
				    var disableDeploy = false;
				    var formStateViewMessage = "";
				    $(DEPLOY).attr("disabled_org", 0); //this is required to make ignore warnings checkbox to work fine.
				    if (!$(SAVE_INSTALL_SET_CHECBOX).is(':checked')) {
				        //$(SAVE_INSTALLSET_NAME_TEXT).attr('value', "");   //.value = "";
				        //$(SAVE_INSTALLSET_DESC_TEXT).attr('value', "");
				        $(INSTALL_SET_NAME_TEXT).attr('disabled', true);
				        $(INSTALL_SET_DESC_TEXT).attr('disabled', true);
				        $(INSATLLSET_NAME_REQUIRED).hide();
				        $(INSTALLSET_DESC_REQUIRED).hide();
						
						if(nodeItem.type.match(/ilo5/i))
						{
							$(SCHEDULE_OPTIONS).show();
						}
						else
						{
							$('#schedule').hpsumSchedule('runNow');
							$(SCHEDULE_OPTIONS).hide();
						}
						
						//validate and enable option for updating recovery set
						validateToUpdateRecoverySet(nodeItem);
						
				        if (nodeItem.type.match(/ilo5/i) && invalidComponentsSelected) {
				            disableDeploy = true;
				            $(DEPLOY).attr("disabled_org", 1); //this is required to make ignore warnings checkbox to work fine

				            if (isStageSelected) {
				                formStateViewMessage = localizer.getString('hpsum.advanceMode.StageDisabledDueToMissingSigFile');
				            }
				            else {
				                formStateViewMessage = localizer.getString('hpsum.advanceMode.deployDisabledDueToMissingSigFile');
				            }
				        }
				        else {
				            $(DEPLOY).attr("disabled_org", 0);
				        }
				    }
				    else {
				        $(INSTALL_SET_NAME_TEXT).attr('disabled', false);
				        $(INSTALL_SET_DESC_TEXT).attr('disabled', false);
						$(SCHEDULE_OPTIONS).show();
						
						//disable option for updating recovery set
						validateToUpdateRecoverySet(nodeItem);
						
				        if (invalidComponentsSelected) {
				            disableDeploy = true;
				            $(DEPLOY).attr("disabled_org", 1); //this is required to make ignore warnings checkbox to work fine
				            if (isStageSelected) {
				                formStateViewMessage = localizer.getString('hpsum.advanceMode.StageDisabledDueToMissingSigFile');
				            }
				            else {
				                formStateViewMessage = localizer.getString('hpsum.advanceMode.deployDisabledDueToMissingSigFile');
				            }
				        }
				        else {
				            $(DEPLOY).attr("disabled_org", 0);
				        }
						if(validateInstallSetNameandDesc())
						{
							formStateViewMessage = localizer.getString("hpsum.advanceMode.deployDisabledDueToNameDesc");
							disableDeploy = true;
						}
						
				    }
				    if (disableDeploy) {
				        var item = {
				            disableDeploy: disableDeploy,
				            formStateViewMessage: formStateViewMessage
				        };
				        shouldEnableDeployment(item);
				    }
				    else
				    {
				        updateDeployButtonState();
				    }
				});

				$(SKIP_DEPENDENCY_CHECKBOX).click(function () {
				    var flag = $(SKIP_DEPENDENCY_CHECKBOX).is(':checked');
				    if (flag) {
				        skipdependency = 'OMITCOMPONENT';
				    }
				    else {
				        skipdependency = 'OMITHOST';
				    }
				    if (nodeItem.node_state.match(/UAN/i)) {
				        applyInstallationOptions.call();
				    }
				});

				$(CLEANUP_ONEXIT).click(function () {
				    var flag = $(CLEANUP_ONEXIT).is(':checked');
				    if (flag) {
				        cleanuponexit = true;
				    }
				    else {
				        cleanuponexit = false;
				    }
				});

				$(CLEANUP_ALLONEXIT).click(function () {

				    var flag = $(CLEANUP_ALLONEXIT).is(':checked');
				    if (flag) {
				        cleanupallonexit = true;
				    }
				    else {
				        cleanupallonexit = false;
				    }
				});
				//$("#hpsum-assocnodes-collapsible").css("margin-top","-20px");
				$(INSTALLATIONOPTION).selectBox({autoWidth: false});	
			
				$(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });	
				
				$(DELAYMINUTES).unbind('keyup').bind('keyup', function(){
					$(DELAYSECERR).hide();
					$(DELAYMINUTES).removeClass('hp-error');
					validateRebootDelay();
				}); 
				
				$(DELAYMINUTES).bind('change', function(){
					$(DELAYSECERR).hide();
					$(DELAYMINUTES).removeClass('hp-error');
				});
				
				$(UPDATE_RECOVERY_ILO_USERNAME).bind('keyup', function() {
					var needToDisableDeploy = false;
					var deployDisableMsg = "";
					if ($(UPDATE_RECOVERY_ILO_USERNAME).val().trim() == "")
					{
						needToDisableDeploy = true;
						$(UPDATE_RECOVERY_ILO_USERNAME).addClass('hp-error');
						$(UPDATE_RECOVERY_ILO_USERNAME_ERR).show();						
					}
					else{
						$(UPDATE_RECOVERY_ILO_USERNAME).removeClass('hp-error');
						$(UPDATE_RECOVERY_ILO_USERNAME_ERR).hide();
						if ($(UPDATE_RECOVERY_ILO_PASSWORD).val().trim() == "")
						{
							needToDisableDeploy = true;							
						}					
					}
					
					if(needToDisableDeploy)
					{
						deployDisableMsg = localizer.getString("hpsum.advanceMode.deployDisabledDueToiLOCredentialsReqd");
					}
					//disable deploy button because user has to enter iLO credentials
					var item = {
						disableDeploy: needToDisableDeploy,
						formStateViewMessage: deployDisableMsg
					};
					if (needToDisableDeploy) {
					    shouldEnableDeployment(item);
					    $(DEPLOY).attr("disabled_org", $(DEPLOY)[0] && needToDisableDeploy ? 1 : 0);
					}
					else {
					    updateDeployButtonState();
					}
				});
				
				$(UPDATE_RECOVERY_ILO_PASSWORD).bind('keyup', function() {
					var needToDisableDeploy = false;
					var deployDisableMsg = "";
					if ($(UPDATE_RECOVERY_ILO_PASSWORD).val().trim() == "")
					{
						needToDisableDeploy = true;
						$(UPDATE_RECOVERY_ILO_PASSWORD).addClass('hp-error');
						$(UPDATE_RECOVERY_ILO_PASSWORD_ERR).show();						
					}
					else{
						$(UPDATE_RECOVERY_ILO_PASSWORD).removeClass('hp-error');
						$(UPDATE_RECOVERY_ILO_PASSWORD_ERR).hide();
						if ($(UPDATE_RECOVERY_ILO_USERNAME).val().trim() == "")
						{
							needToDisableDeploy = true;							
						}
					}
					
					if(needToDisableDeploy)
					{
						deployDisableMsg = localizer.getString("hpsum.advanceMode.deployDisabledDueToiLOCredentialsReqd");
					}
					//disable deploy button because user has to enter iLO credentials
					var item = {
						disableDeploy: needToDisableDeploy,
						formStateViewMessage: deployDisableMsg
					};
					if (needToDisableDeploy) {
					    shouldEnableDeployment(item);
					    $(DEPLOY).attr("disabled_org", $(DEPLOY)[0] && needToDisableDeploy ? 1 : 0);
					}
					else {
					    updateDeployButtonState();
					}
				});				
				
				$(INSTALL_SET_NAME_TEXT).on('keyup change', function () {
					validateInstallSetNameandDesc();
				});
				
				$(INSTALL_SET_DESC_TEXT).on('keyup change', function () {
					validateInstallSetNameandDesc();
				});
                assocNodeDialogContents = $(ASSOC_NODE_DIALOG).detach().show();
                $(REBOOTOPTION).selectBox({autoWidth: false});
                $(ACTIVATE_SELECTION).selectBox({autoWidth: false});
				$(ASSOC_NODE_COMP).empty();
				$("#assoc-footer").hide();
				$(".hp-collapsible").hpCollapsible();
				$(DATETIMESECTION).hide(); 
				$(SCHEDULETOGGLE).hpToggle({checked: 'On', unchecked: 'Off'});
    			$(SCHEDULETOGGLE).bind('change',toggleSchedule);
				$(SCHEDULE_DATE).datepicker({ dateFormat: 'yy-mm-dd'});
				$(SCHEDULE_TIME).bind('change', validateTime);
				$(SCHEDULE_TIME).bind('keyup', function () {
					$(SCHEDULE_TIME_LABEL).removeClass("hp-error");
					$(SCHEDULE_TIME_LABEL).hide();
				});
				$(SCHEDULE_TIME_LABEL).removeClass("hp-error");
				$(SCHEDULE_TIME_LABEL).hide();
				$(SCHEDULE_DATE).bind('change', function(){
					$(ANALYSIS).removeAttr('disabled');
					$(DEPLOY).attr('disabled','disabled');
				});
				$("#hpsum-schedule-collapsible").removeClass('hp-collapsed');
				$("#hpsum-baseline-collapsible").removeClass('hp-collapsed');
				$(DEPLOY).attr("disabled", true);
				
				//keypress is for handling enter key and  keyup is for handling backspace and delete keys 
				//which is in turn used to get the no of characters in encryption key
				$('#hpsum-node-vc-encryption-key').on('keypress keyup', function(event) {
					var keyCode = (event.keyCode ? event.keyCode : event.which);
					if (keyCode == 13) {	// keyCode == 13 is the 'Enter' key
						// Do not allow default action as it causes a refresh
						event.preventDefault();
						return;
					}
				    $(DEPLOY).attr("disabled", true);
					updateDeployButtonState();
			     });	
				 reRenderAssociatedNodesOnce = true;
				 reRenderBaselineDetails = true;
				
				$(TAB_SHOW_BASELINE_DETAILS).click(function () {
					handleBaselineTab(this);
					 if(reRenderBaselineDetails)
					 {
						 repopulateInstallSet();
						 reRenderBaselineDetails = false;
					 }
					//returning false to prevent default click behaviour(navigating to /node/deploy). Fix for QXCR1001419242
					return false;
					});
					
				$(TAB_ASSOCIATED_NODE_DETAILS).click(function () {
					handleBaselineTab(this);
					if(reRenderAssociatedNodesOnce)
					{
						if(nodeItem.auto_add_assoc_nodes == true)
						{
							renderAssociatedNodes(associatedNodesData);
						}
						reRenderAssociatedNodesOnce = false;
					}
					//returning false to prevent default click behaviour(navigating to /node/deploy). Fix for QXCR1001419242
					return false;
					});
					
                //handle tabs actions of Tabs panel.

				$(TAB_INSTALLATION_OPTIONS).click(function () {
				    handleTabClickAction(this);
				    return false;
				});
				$(TAB_SCHEDULE_OPTIONS).click(function () {
				    handleTabClickAction(this);
				    return false;
				});
				$(TAB_REBOOT_OPTION).click(function () {
                    handleTabClickAction(this);
				    return false;
				});
				$(TAB_ILO_MANAGEMENT_OPTION).click(function () {
				    handleTabClickAction(this);
				    return false;
				});
				$(TAB_VC_INSTALLATION_OPTIONS).click(function () {
				    handleTabClickAction(this);
				    return false;
				});
				$(TAB_VC_ACTIVATION_OPTIONS).click(function () {
				    handleTabClickAction(this);
				    return false;
				});
				$(TAB_SDFLEX_INSTALLATION_OPTIONS).click(function () {
					handleTabClickAction(this);
				});
				$(TAB_SDFLEX_REBOOT_OPTIONS).click(function () {
					handleTabClickAction(this);
				});

                //default first tab will be selected.
				
				$(TAB_INSTALLATION_OPTIONS).trigger('click');
				
                //end of handling tabs actions.
                				
                $(TAB_INTEGRITY_REBOOT_TO_ACTVATE).click(function () {
					handleInstallOptionsTab(this);
					//returning false to prevent default click behaviour(navigating to /node/deploy). Fix for QXCR1001419242
					return false;
					});
				
                function wasItTempAbort()
                {
                	/* if scheduled = false -> temporary abort happened earlier but schedule time is present conside as temporary abort */
                	if(nodeItem.scheduled == "false" && nodeItem.schedule_date_time != "")
                	{
                		return true;
                	}
                	else
                	{
                		return false;
                	}
                }
					
				$(CANCEL).on('click',function(event){
				    /* if user has pressed deploy rescheduling to temporary aborted schedule */
				    	var shouldDeploy = wasItTempAbort();
						var isDeploycalled = false;
						if(bHasUserPressedDeploy == false && shouldDeploy == true)
						{
							isDeploycalled = true;
							nodeItem.set_schedule_date_time = nodeItem.schedule_date_time;
							deploy_flag = true;
							presenter.deploy(nodeItem, {
							
							success : function(data){
										var item = nodeItem;
										onDeploySuccess(data,item);
										scheduleDetails.isScheduled = false;
										scheduleDetails.tempAbort = false;
								},
							error : onDeployError
							});

							router.go(urlFragment.replaceView(router.location(), 'show'));
						}
						else
						{
							deploy_flag = false; /* if user might have encountered invalid datetime error, it would have bcome true, so need to reset. Otherwise openig the review deploy page will lead to installation immediately*/
							    router.go(urlFragment.replaceView(router.location(), 'show'));
							}
				});
                
				$(window).on('resize', OnResize);
                //set width for baseline and additional package search box.
				OnResize();
				
				
                //direct deploy related

				$(REMOVE_GRP_CHECKBOX).prop("checked", false);
				$(REMOVE_GRP_CHECKBOX).change(function () {
				    if ($(REMOVE_GRP_CHECKBOX).is(':checked')) {
				        isPartOfGroup = false;
				        updateEditableFields(nodeItem, false);
				    }
				    else {
				        isPartOfGroup = true;
				        updateEditableFields(nodeItem, true);
				    }
				});

				$(BASELINES).change(function (ev, value) {
				    if (nodeItem && nodeItem.node_state.match(/IDLE/i)) {
				        renderDirectDeployBaselineDetails(null);
				        $(ILO_INSTALLSET_COMP_CONTAINER).hide();
				        $(BASELINE_ASSOCIATED_NODE_TAB_CONTAINER).hide();
				        $('#li-expert-mode-baseline-assocnodes').hide();
				        $(ILO_TASKQUEUE_COMP_CONTAINER).hide();
                        $(DEPLOY).attr('disabled', 'disabled');
				        var item = presenter.getBaselineDetailsforId(value);
				        if (item) {
				            newBaseline = item;
				            renderDirectDeployBaselineDetails(item);
				            updateTabsForBaselineSelected(true);
				            $(SKIP_DEPENDENCY_CHECKBOX).attr('disabled', false);
				        }
				        else {
				            $(HOTFIX).hpSearchCombo('set', { id: '', name: '' });
				            $(SKIP_DEPENDENCY_CHECKBOX).attr('disabled', true);
				            //check if its installset.
				            item = getInstallSetForId(value);
				            if (item) {
				                renderInstallsetDetails(item);
				                newBaseline = item; 
				                
				                //disable additional package
				                $(HOTFIX).hpSearchCombo('disable');
				                updateTabsForBaselineSelected(false);
				                if (isWarningsset && !nodeItem.group) {
				                    $(DEPLOY).removeAttr("disabled");
				                }
				            }
				            else {
				                var baselineString = localizer.getString('hpsum.common.pendingTaskQueue');
				                if (value.match(/ilo_queued_updates/i)) {
				                    item = {
				                        "id": "ilo_queued_updates",
				                        "name": baselineString
				                    }
				                    renderInstallsetDetails(item);
				                    newBaseline = item;
				                    //disable additiona package
				                    $(HOTFIX).hpSearchCombo('disable');
				                    updateTabsForBaselineSelected(false);
				                    if (isWarningsset && !nodeItem.group) {
				                        $(DEPLOY).removeAttr("disabled");
				                    }
				                }
				                else {
				                    newBaseline = null;
				                    $(HOTFIX).hpSearchCombo('enable');
				                }
				            }
				        }

				        if (!setOk) {
				            $(BASELINE_INPUT_ERR).hide();
				            $(BASELINE_INPUT).removeClass('hp-error');
				        }
				        setOk = false;
				        //$(DEPLOY).removeAttr("disabled");
				        $(FAILEDPANEL).hide();
				    }
				});
				$(HOTFIX).change(function (ev, value) {
				    renderDirectDeployBaselineDetails(null);
				    if (nodeItem && nodeItem.node_state.match(/IDLE/i)) {
				        var item = presenter.getBaselineDetailsforId(value);
				        if (item) {
				            newHotFix = item;
				            renderDirectDeployBaselineDetails(item);
				            updateTabsForBaselineSelected(true);
				        }
				        else {
				            newHotFix = null;
				        }
				        //nodeItem.baselines = value;
				        if (!setOk) {
				            $(HOTFIX_INPUT_ERR).hide();
				            $(HOTFIX_INPUT).removeClass('hp-error');
				        }
				        setOk = false;
				        $(DEPLOY).removeAttr("disabled");
				        $(FAILEDPANEL).hide();
				    }

				});

				$(BASELINE_INPUT).unbind('keyup').bind('keyup', function () {
				    $(BASELINE_INPUT_ERR).hide();
				    $(BASELINE_INPUT).removeClass('hp-error');
				});

				$(HOTFIX_INPUT).unbind('keyup').bind('keyup', function () {
				    $(HOTFIX_INPUT_ERR).hide();
				    $(HOTFIX_INPUT).removeClass('hp-error');
				});

                //end direct deploy related
                
				router.watch('Node Deploy section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
				$('#li-hpsum-deploy-page-tabs').css('padding-bottom', '1px');
                this.resume();
            };
		}
        return NodeDeployView;
    }());
    
    return new NodeDeployView();
});
