// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {NodeShowOverviewView}
 * Provides functions to show overview/details pane for a node item
 */

define(['hpsum/presenter/node/NodePresenter',
    'hp/core/UrlFragment',
    'hp/core/Router',
    'text!hpPages/core/no_details.html',
    'hp/view/DetailsShowView',
    'hp/view/DialogView',
    'hp/view/NotificationsView',
    'hp/core/Localizer',
    'text!hpsumpages/node/abort_confirm.html',
    'jquery',
    'hp/lib/jquery.hpGridPanels',
    'hp/lib/jquery.hpEllipsis',
    'lib/jquery.ThreeDots',
    'hp/lib/jquery.hpDropMenu',
    'lib/jquery.columnizer',
    'hp/lib/jquery.hpStatus',
    'lib/jquery.dateFormat',
    'hp/lib/date'],
function(presenter, urlFragment,router, noneHtml,DetailsShowView,DialogView, NotificationsView,localizer, abortConfirmHtml){
	"use strict";
	
	var NodeShowDeployView = (function() {
		
		var ROOT = '#hpsum-node-show-deploy',
			SPINNER = '#hpsum-node-deploy-spinner',
	  		PANELS = '.hp-grid-panels',
	  		TITLE = '#hpsum-nodes-details-title',
	  		STATUS = '#hpsum-nodes-details-status',
	  		CURRENT_STATUS = '#hpsum-node-install-current-status',
	  		DETAILS = '#hpsum-node-install-details',
	  		TEXT ='#hpsum-node-deploy-progress-text',
	  		TYPE ='#hpsum-node-type',
            DESCRIPTION = '#hpsum-node-description',
            ACTIONS = '.hp-details-actions',
            ABORT_ACTION ='#hpsum-nodes-abort-action',
            SELECTOR = '#hpsum-nodes-panel-selector';
        
        var VIEW ='#hpsum-nodes-deploy',
            ABORT_TITLE = '#hpsum-nodes-abort-title';
        function NodeShowDeployView(){
        	
        	var noItem;
        	var abortInProgress = false;
        	var detailsShowView = new DetailsShowView();
        	var notificationsView = new NotificationsView();
        	
        	function onSelectionChange(selection) {
        		urlFragment.replaceHrefUris(ROOT, selection.uris);
        	}
        	
        	function onItemChange(item){
        		item = item.hapi;
        		noItem.remove();
        		if(item.node_state.match(/install$/i)){
        			$(SPINNER).show();
        			$(TITLE).removeClass('hp-unavailable');
        			$(TITLE).text(item.name);
        			$(TEXT).text(localizer.getString('hpsum.node.installing') + ' ' + item.type + ' ' + item.name);
        			$(CURRENT_STATUS).text(item.node_status);
        			$('.hp-grid-panels').css({"display":""});
        			$('.hp-grid-panels').hpGridPanels('reset');
        			$(STATUS).hpStatus(item.node_status, item.changing).
                        removeClass('hp-unavailable');
                                        var tablecontents = "";
    				tablecontents = "<table>";
                    for (var key in item) {
  						if (item.hasOwnProperty(key)) {
  							tablecontents += "<tr>";
      						tablecontents += "<td>" + key + "</td>";
      						tablecontents += "<td>" + JSON.stringify(item[key]) + "</td>";
      						tablecontents += "</tr>";
  							}
					}
					tablecontents += "</table>";
					$(DETAILS).html(tablecontents);
        		}
        		else
        			router.go(urlFragment.replaceView(router.location(), 'show'));
        	}
        	
        	function onItemError(error){
        		$(ROOT).append(noItem);
        	}
        	
        	function onAbort(ev){
        		if (! abortInProgress) {
                   abortInProgress = true;
                    
                   var contents = $(abortConfirmHtml);
                   localizer.localizeDom(contents);
                    $(ABORT_TITLE, contents).text(localizer.getString('hpsum.node.abortInstallFor', new Array(presenter.selectionLabel())));
                    var dialogView = new DialogView();
                    dialogView.init({contents: contents,
                        ok: function () {
                                presenter.abortAction({
                                    success : function(){
                                    	abortInProgress = false;
                                    	notificationsView.add({summary: localizer.getString('hpsum.node.abortInProgress')}, true);
                                    },
                                    error : function(msg){
                                    	abortInProgress = false;
                                    	notificationsView.add({summary: msg}, true);
                                    }
                                });
                        },
                        cancel: function () {
                            abortInProgress = false;
                        }
                    });
                }
                
                ev.preventDefault();
        	}
        	
        	
        	
        	/* 
        	 *  Public Functions
        	 */
        	
        	this.init = function() {
        		noItem = $(noneHtml);
        		detailsShowView.init($(SELECTOR));
        		$(PANELS).hpGridPanels();
        		$(ACTIONS).hpDropMenu();
                $('#hpsum-activity-actions').hide();
                notificationsView.init({context: $(VIEW),
                    allLocation: '#/node/show/activity',
                    resource: presenter.resource()});
        		$(DESCRIPTION).ThreeDots({max_rows: 3, alt_text_t:true});
        		this.resume();
        	};
        	
        	this.resume = function() {
        		$(PANELS).hpGridPanels('reset');
        		$(ABORT_ACTION).bind('click', onAbort);
        		presenter.on("selectionChange", onSelectionChange);
                presenter.on("itemError", onItemError);
                presenter.on("itemChange", onItemChange);
        		
        	};
        	
        	this.pause = function() {
				presenter.off("selectionChange", onSelectionChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
        	};
        	
        	
        	
        	
        }
		
		return new NodeShowDeployView();
	}());
	
	return NodeShowDeployView;
});
