// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {NodeShowOverviewView}
 * Provides functions to show overview/details pane for a node item
 */

define(['hpsum/presenter/node/NodePresenter',
    'hp/core/UrlFragment',
    'hp/core/Router',
    'text!hpPages/core/no_details.html',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpGridPanels',
    'hp/lib/jquery.hpEllipsis',
    'lib/jquery.ThreeDots',
    'lib/jquery.columnizer',
    'lib/jquery.dateFormat',
    'hp/lib/date'],
function(presenter, urlFragment,router, noneHtml, localizer){
	"use strict";
	
	var NodeShowOverviewView = (function() {
		
		var ROOT = '#hpsum-node-show-overview',
			SPINNER = '#hpsum-node-add-spinner',
	  		PANELS = '.hp-grid-panels',
	  		TYPE ='#hpsum-node-type',
	  		SERIAL ='#hpsum-node-serial',
			GROUP = '#hpsum-server-group',
            DESCRIPTION = '#hpsum-node-description',
			EDIT_GENERAL = '#hpsum-node-general-edit';
        
        function NodeShowOverviewView(){
        	
        	var noItem;
        	
        	function onSelectionChange(selection) {
        		urlFragment.replaceHrefUris(ROOT, selection.uris);
        	}
        	
        	function onItemChange(item){
        		noItem.remove();
        		item = item.hapi;
        		if(item.type){
        			item.type = item.type.toLowerCase();
        			if(!router.location().match(item.type))
        				router.go((urlFragment.replaceView(router.location(), 'show/' + item.type + '/overview')));
        			}
					
				$(EDIT_GENERAL).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
				if(item.node_state.match(/inventory/i) || item.node_state.match(/installhold/i) || item.node_state.match(/pendingfwupdate/i) ||
                   item.node_state.match(/activatependingfwupdate/i) || item.node_state.match(/scheduled/i) || item.node_state.match(/Install$/i) || 
				   item.node_state.match(/activate_pending/i)){
					$(EDIT_GENERAL).removeClass('company-a').addClass('hp-disabled');
					$('.hp-disabled').css("color", "grey").bind('click.disable-link', function(e) {
						e.preventDefault();
						return false;
					});	
				}
				
        		if(item.node_state.match(/idle/i) && item.node_phase.match(/Initialize/i)){
        			$('.hp-grid-panels').css({"display":"none"});
        			 $(SPINNER).show();
        		}
        		else {
        			$(SPINNER).hide();
        			$('.hp-grid-panels').css({"display":""});
        			$('.hp-grid-panels').hpGridPanels('reset');
        			$(TYPE).text(item.model);
        			$(DESCRIPTION).text(item.description);
        			$(SERIAL).text(item.serialnumber);
        			
        		}
        		$(GROUP).text('');
        		if (item.hasOwnProperty('group_name')) {
        		    if (item.group_name.length == 0) {
        		        $(GROUP).text('none');
        		    }
        		    else {
        		        var group_uri = '#/group/show/overview/r/session/' + item.node_session + '/node/group/' + item.group + '/getdata';
        		        var uri = '<a href="' + group_uri + '" class="company-a">' + item.group_name + '</a>';
        		        $(GROUP).html(uri);
        		    }
        		}
        		else {
        		    $(GROUP).text('none');
        		}
                $(PANELS).hpGridPanels('reset');
                $(ROOT).removeClass('hp-show-changing');
                $('.hp-dynamic', ROOT).removeClass('hp-unavailable');
            }
        	
        	function onItemError(error){
        		$(ROOT).append(noItem);
        	}
        	
        	
        	/* 
        	 *  Public Functions
        	 */
        	
        	this.init = function() {
        		noItem = $(noneHtml);
        		$(PANELS).hpGridPanels();
        		$(DESCRIPTION).ThreeDots({max_rows: 3, alt_text_t:true});
        		this.resume();
        	};
        	
        	this.resume = function() {
        		$(PANELS).hpGridPanels('reset');
        		presenter.on("selectionChange", onSelectionChange);
                presenter.on("itemError", onItemError);
                presenter.on("itemChange", onItemChange);
             
        		
        	};
        	
        	this.pause = function() {
				presenter.off("selectionChange", onSelectionChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
               
        	};
        	
        	
        	
        	
        }
		
		return new NodeShowOverviewView();
	}());
	
	return NodeShowOverviewView;
});
