/* (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
*/
define(['hp/view/DetailsShowView',
    'hpsum/presenter/node/NodePresenter',
    'hp/core/Router',
    'hp/view/DialogView',
    'hp/core/UrlFragment',
    'hp/core/LinkTargetBuilder',
    'hp/view/NotificationsView',
    'hp/core/Localizer',
    'text!hpsumpages/node/abort_confirm.html',
    'text!hpsumpages/node/delete_confirm.html',
    'text!hpsumpages/node/failed_components.html',
    'text!hpsumpages/one-touch-update/reboot_confirm.html',
    'hpsum/presenter/baseline/BaselinePresenter',
	'hp/core/Notifications',
	'hp/model/Session',
    'jquery',
    'hpsum/view/node/jquery.hpsumWarnings',
    'hpsum/view/node/jquery.hpsumInstallSets',
    'hpsum/view/node/jquery.overviewContentsAsTabs',
    'hp/lib/date',
    'hp/lib/jquery.hpDropMenu',
    'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpCollapsible'],
function(DetailsShowView, presenter,router, DialogView, urlFragment,
    linkTargetBuilder, NotificationsView, localizer,abortConfirmHtml, deleteConfirmHtml,failedComponentsHtml,rebootConfirmHtml,BaselinePresenter,notifications, session) { "use strict";

    var NodeShowView = (function() {
        
        var VIEW = '#hpsum-nodes-show';
        var HEADER = '#hpsum-nodes-show .hp-details-header';
        var TITLE = '#hpsum-nodes-details-title';
        var STATUS = '#hpsum-nodes-details-status';
        var ACTIONS = '.hp-details-actions';
        var DELETE_ACTION = '#hpsum-node-action-delete',
        	ABORT_ACTION ='#hpsum-node-action-abort',
        	INVENTORY_ACTION = '#hpsum-node-action-inventory',
			INVENTORY_DETAIL_LINK = '#hpsum-node-detail-inventory',
        	DEPLOY_ACTION = '#hpsum-node-action-deploy',
            STAGE_ACTION = '#hpsum-node-action-stage',
            ONLINE_DEPLOY ='#hpsum-node-action-onlinedeploy',
            OFFLINE_DEPLOY ='#hpsum-node-action-offlinedeploy',
        	REPORTS_ACTION = '#hpsum-node-action-reports',
        	SCHEDULE_ACTION ='#hpsum-node-action-schedule',			
			DELETE_SCHEDULE = '#hpsum-delete-schedule-info',
			EDIT_ACTION = '#hpsum-node-action-edit',
			DIRECT_DEPLOY ='#hpsum-node-action-directDeploy',
			REBOOT_ACTION = '#hpsum-node-action-reboot',
            SPLASH_SPINNER = '#hpsum-node-show-splash-spinner',
            SPLASH_DIALOG = '#hpsum-node-show-splash-dialog',
            REBOOT_ACTION_CONTAINER = '#reboot-action-item';
        var DELETE_TITLE = '#hpsum-nodes-delete-title';
		
        var NOTIFY_STATUSES = {ok: 'ok', error:'error', warning:'warning', unknown:'info', scheduled: 'scheduled'};
        
        var ABORT_TITLE = '#hpsum-nodes-abort-title',
       	   ABORT_ERROR = '#hpsum-abort-err';

        var F_VMWARE_DISC_GENERAL = 5052, /*! Discovery general failure */ 
            F_VMWARE_DISC_SYS_HW_ERROR = 5186, /*!  Discovery data creation error during System Hardware data collection*/
            F_VMWARE_DISC_PCI_ERROR = 5187, /*!  Discovery data creation error during PCI data collection*/
            F_VMWARE_DISC_NIC_ERROR = 5188, /*!  Discovery data creation error during NIC data collection*/
            F_VMWARE_DISC_FCHBA_ERROR = 5189, /*!  Discovery data creation error during FCHBA data collection*/
            F_VMWARE_DISC_OS_ERROR = 5190, /*!  Discovery data creation error during OS data collection*/
            F_VMWARE_DISC_SMARTARRAY_ERROR = 5191, /*!  Discovery data creation error during SA data collection*/
            F_VMWARE_DISC_ILO_ERROR = 5192, /*!  Discovery data creation error during iLO data collection*/
            F_VMWARE_SEFL_DISC_DNL_ERROR = 5003, /*!  Self-discovery download failure*/
			F_VMWARE_PROVIDERS = 5012, 			/*!VMWare providers are not installed*/
			F_VMWARE_COMP_EXEC = 5016, /*! Failed to start/execute a component. */
			F_VC_DOMAIN_NOT_CONFIGURED = 5108,	/*! VC domain is not configured properly.*/
            F_CHIF_NEEDED = 44,			/* CHIF is needed on the server and user has not opted to install it.*/
	        F_CHIF_INSTALL = 45,			/* CHIF is needed on the server, user has opted to install it but installation failed.*/
	        F_CHIF_SIGNATURE_VERIFICATION_FAILED = 46, /* Signature verification failed for CHIF driver component */
			F_CAC_MODE_ENABLED		= 48,				/*CAC is enabled on the iLO*/
			F_HIGHSECURITY_MODE     = 49,				/*iLO is configured in one of the high security modes*/	
            F_CHIF_REBOOT_NEEDED = 51,
            F_CHIF_COMMUNICATE_AFTER_CHIF_INSTALL = 52,
			F_INVALID_ILO_CREDENTIALS = 53,				/*User provided incorrect iLO Credentials*/
			F_BIOS_PASSWORD_ENABLED = 54,				/*BIOS password is enabled. iLO credentials are required to proceed further*/
			
			F_UNSUPPORTED_WINDOWS_VERSION = 7015; /* Unspupported windows version*/
			

		
	var RETURN_CODE_GENERAL_FAILURE = -1,
            RETURN_CODE_COULD_NOT_RUN = -2,
	    RETURN_CODE_ERROR_RETURN = -3,
		RETURN_CODE_NO_COMPONENTS_DEPLOYED = 3;
		
		
	var NODE_INSTALLABLE_STATUS_NO_APP_COMP = 1,
		NODE_INSTALLABLE_STATUS_ATBASELINE = 2;
	var NODE_INSTALLABLE_STATUS_ABOVEBASELINE = 3;
		
			
        var FAILED_COMPONENTS_TABLE = '#hpsum-failed-comps-table';
        var isSplashActive = false;
		var isIntegrityNode = false;
		var isUnsupportedWindowsOs = false;
		var isMoonshotNode = false;

        /**
         * Constructor
         */
        function NodeShowView() {
          
            var notificationsView = new NotificationsView();
            var deleteInProgress = false;
            var abortInProgress = false;
	        var rebootInProgress = false;
            var thisNode = null,
            	timerMap={};
            var notificationsCleared = false;
            var nodeItem = null;
			
            function clearNotifications() {
                if (! notificationsCleared) {
                    notificationsCleared = true;
                    notificationsView.clear();
                }
            }
                      
            function convertTypeStringForTitle(val) {
				if(val.match(/ilo/i)){ 
					var iloName = displayILO(val);
					return iloName;
				}
				else if (val.match(/hpux/i)) {
                    return "HP-UX";	
                }
                return val.toUpperCase();
            }
            
			function onInventoryError(errorMessage) {                
                
            }

            function onInventorySuccess(item) {
                
            }
			
	    function onInventory(){	   
            $(INVENTORY_DETAIL_LINK).die("click", onInventory);				            									
	    	var resource = router.location().split('/');
	    	resource = resource[1];
	    	router.go("/" + resource + '/inventory');
				   
	    }
			
            function onItemChange(item) {
                clearNotifications();
                item = item.hapi;
                nodeItem = item;
				var status,summary,details;
                // 1) All nodes having the same pattern (15.154.116.1, 15.154.116.14) will get selected
                // filtering only specific node to be selected
                // 2) OA Node page from the  right side page it will give the list of the node selected. 
                // But the left side menu is not pointing towards the selected node
                // 3) Nodes screen hung on selecting IPv6 node 
                $("#hpsum-nodes-master-table tr").filter(function() {
                    var found = false;
                    $(this).children().each(function() {
                        if ($(this).text() == item.ip){
                    	    found = true
                    	    }
                	});
                	return found;
                }).addClass("hp-selected");				
				
                var resource = router.location().split('/');
                	resource = resource[1];
                var base ='#/'+resource ;
                if (item) {
                	notificationsView.clear();
                	thisNode = item;
                    $(HEADER).removeClass('hp-show-changing');
                    $('.deploy-domain').remove();
		            var deploy_url = base + '/deploy';
                    $(DEPLOY_ACTION).attr('href',deploy_url).text(localizer.getString('hpsum.node.reviewDeploy'));
                    if(!item.node_phase.match(/Initialize/i))
                    	$(ACTIONS).removeClass('hp-disabled');
                    $(TITLE).removeClass('hp-unavailable');
                    $(TITLE).text(convertTypeStringForTitle(item.type) +': ' +item.name);
                    $(STATUS).hpStatus('unknown', true).
                        removeClass('hp-unavailable');
					//hide reboot action for ilo node as its not applicable for iLO node.
					//also hide reboot action for sdflex node as its not applicable for sdflex node.  
                    if (item.type.match(/ilo|sdflex/i))
                    {
                        $(REBOOT_ACTION_CONTAINER).hide();
                    }
                    else
                    {
                        $(REBOOT_ACTION_CONTAINER).show();
                    }
					if(item.node_phase.match(/Initialize/i))
					{
						summary = item.node_status;
                	    details = item.node_status;
                	    $(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');

                	    notificationsView.add({
                	        status: NOTIFY_STATUSES[status],
                	        summary: summary,
                	        details: details
                	    });
						showNodeProgress(item);
					}

                    if(item.node_phase.match(/InActive/i)) {
                		presenter.restore(thisNode.node_id);	
                	}
					
                    if (item.node_state.match(/installdone/i)) {
         				//$(HEADER).addClass('hp-show-changing');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type) +': ' +item.name);
                    	
                    	if((item.return_code == RETURN_CODE_GENERAL_FAILURE) || (item.return_code == RETURN_CODE_COULD_NOT_RUN) || (item.return_code == RETURN_CODE_ERROR_RETURN)) {
                    	    $(STATUS).hpStatus('error').removeClass('hp-unavailable');
                            status = 'error';
                            summary = localizer.getString('hpsum.node.installDoneWithErrors'); 
                            details = localizer.getString('hpsum.node.installDoneSeeErrors'); 
							if(item.type.match(/ilo5/i))
							{
								details = item.node_status;
							}
                    	} 
						else if((item.return_code == RETURN_CODE_NO_COMPONENTS_DEPLOYED) && item.node_status == 'No component(s) deployed.')
						{
							$(STATUS).hpStatus('ok').removeClass('hp-unavailable');
    						status = 'ok';
                        	summary = localizer.getString('hpsum.node.noComponentsInstalled');
                        	details =localizer.getString('hpsum.node.noComponentsInstalledDes');
						}
						else {
                        	$(STATUS).hpStatus('ok').removeClass('hp-unavailable');
    						status = 'ok';
                        	summary = localizer.getString('hpsum.node.installDone');
                        	details =    localizer.getString('hpsum.node.installDoneSee');
                            if(item.type.match(/HPUX|ilo5|sdflex/i) || (item.server_generation >= 10 && item.type.match(/windows|linux/i))){
                                details = item.node_status.replace(/\n/g, "<br/>");
                            }
                        }
						if(item.return_code == 1 && item.reboot_initiated == false)
						{
							if(!item.type.match(/ilo|sdflex/i))
							{
								details +=    '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a id="hpsum-node-reboot">' + localizer.getString('hpsum.node.rebootRequired') + '</a>';
							}
						}
                    	 notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
						
						$('#hpsum-node-reboot').die('click').live('click', onReboot);
                      	
                	}
                	
                	if (item.node_state.match(/installhold/i)) {
         				//$(HEADER).addClass('hp-show-changing');
					 $(DELETE_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
					 $(REPORTS_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');	
					 $(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type) +': ' +item.name);
						$(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
						$(DEPLOY_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
						$(EDIT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                    	$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');

						summary = localizer.getString('hpsum.group.deployHoldSummary');
						details =   item.node_status;
						$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');

						notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
                       // showInstallProgress(item);
                      	
                	}
					
					if (item.node_state.match(/STAGE_ONLY_DONE/i)) {
         				//$(HEADER).addClass('hp-show-changing');
					    $(DELETE_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
					 $(REPORTS_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');	
					 $(INVENTORY_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');                  
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type) +': ' +item.name);
                    	$(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                    	$(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    	$(DEPLOY_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                    	$(EDIT_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                    	$(ABORT_ACTION).addClass('hp-disabled').removeClass('company-a');
                    	$(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a');
						$(STATUS).hpStatus('ok').removeClass('hp-unavailable');

						summary = localizer.getString('hpsum.easymode.DeployStaged');
						details =   item.node_status;
						status = 'ok';

						notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
					}

					if (item.node_state == "STAGE_ONLY") {
					    $(EDIT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
					    $(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a');
					    $(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');
					    $(DEPLOY_ACTION).addClass('hp-disabled').removeClass('company-a');
					    $('.hpsum-deploy').addClass('hp-disabled').removeClass('company-a');
					    $(REPORTS_ACTION).addClass('hp-disabled').removeClass('company-a');
					    $(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a');
					   $(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a');
					    $(DELETE_ACTION).addClass('hp-disabled').removeClass('company-a');
					    summary = item.node_status;
					    details = localizer.getString('hpsum.easymode.stageInProgress');
					    status = 'ok';

					    notificationsView.add({
					        status: NOTIFY_STATUSES[status],
					        summary: summary,
					        details: details
					    });
					    showNodeProgress(item);
					}
					
                	if (item.node_state.match(/ILO_TASK_INPROGRESS/i)) {                	   
                	    summary = item.node_status;
                	    details = item.node_status;
                	    $(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');

                	    notificationsView.add({
                	        status: NOTIFY_STATUSES[status],
                	        summary: summary,
                	        details: details
                	    });
                	     showNodeProgress(item);

                	}
					if (item.node_state.match(/pendingfwupdate/i)) {
					    $(DELETE_ACTION).removeClass('hp-disabled').addClass('company-a').addClass('hp-primary');
					    $(REPORTS_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
					    $(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type) +': ' +item.name);
						$(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
						$(DEPLOY_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
						$(EDIT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                    	$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');

						summary = localizer.getString('hpsum.node.pendingfwUpdate'); // Add in translation
						details =   item.node_status;
						$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');

						notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
                	}

					if (item.node_state.match(/activatependingfwupdate/i)) {
					 $(DELETE_ACTION).removeClass('hp-disabled').addClass('company-a').addClass('hp-primary');
					 $(REPORTS_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
					 $(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type) +': ' +item.name);
						$(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
						$(DEPLOY_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
						$(EDIT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                    	$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');

						summary = localizer.getString('hpsum.node.activatingPendingfwUpdate'); // Add in translation
						details =   item.node_status;
						$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');

						notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
                	}


					if (item.node_state.match(/^scheduled$|^remote_staging_scheduled$/i)) {
         				$(HEADER).removeClass('hp-show-changing');
                        $(STATUS).hpStatus('scheduled', false).removeClass('hp-unavailable');
						$(DELETE_ACTION).removeClass('hp-disabled').addClass('company-a').addClass('hp-primary');
						$(REPORTS_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
						$(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
						$(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(item.type.toUpperCase() +': ' +item.name);
                        if(item.node_state.match(/^remote_staging_scheduled$/i)){
                            summary = localizer.getString('hpsum.node.scheduledStaging'); // Add in translation
                        } else {
                            summary = localizer.getString('hpsum.node.scheduledDeploy'); // Add in translation
                        }
                        details =   item.node_status;
                        status = 'scheduled';
                        notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        }, true);
                	}
					
                	if (item.node_state.match(/install$|INSTALLFROMILOTASKQUEUE|INSTALLFROMRECOVERYSET/i)) {
         				//$(HEADER).addClass('hp-show-changing');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type) +': ' +item.name);
                    	$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');
                    	
						status = 'unknown';
						if(item.type.match(/moonshot/i )) {
						    summary = localizer.getString('hpsum.node.installProgressMoonshot');
						} else
                    	   summary = localizer.getString('hpsum.node.installProgress'); // Add in translation
                    	details = item.node_status;
                    	 notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            changing:true,
                            details: details
                        });
                      	showNodeProgress(item);
                	}
         			
         			if (item.node_state.match(/inventory$|analysis$/i)) {
         				//$(HEADER).addClass('hp-show-changing');
         				$(ACTIONS).removeClass('hp-disabled');
         				$(TITLE).removeClass('hp-unavailable');
                    	$(TITLE).text(convertTypeStringForTitle(item.type) +': ' +item.name);
                    	$(STATUS).hpStatus('unknown', true).removeClass('hp-unavailable');
                    	        			
        				var notif = {
        				  	status: 'info',
                            summary: localizer.getString('hpsum.node.inventoryInProgress'), // Add in translation
                           	changing: true
                            
        				};
        				notificationsView.add(notif);
                    	showNodeProgress(item);
                	}


                    if (item.node_state.match(/error/i)) {
                    	$(HEADER).removeClass('hp-show-changing');
                    	$(STATUS).hpStatus('error', false).
                        	removeClass('hp-unavailable');
                    	
                    	status = 'error';
                    	summary = item.node_status;
				        if(!(item.type.match(/VMWARE/i)))
                        {						              
							if(item.hasOwnProperty('port_blocked') && item.port_blocked) 
							{
									//If the remote or local node is server (windows or linux), and inventory/deploy failed with error due to 
									//firewall blocked, provide an option to user either to open the ports manually or let SUM do this for user.
									
									//provide option to user
									details = '<p>' + localizer.getString('hpsum.node.openFirewallMsg') + '</p>' +
												'<a id="hpsum-node-show-openfirewall">' + localizer.getString('hpsum.node.openFirewall') + '</a>';
							}
							else if(item.node_status.match(/Inventory Error/i) || item.node_status.match(localizer.getString('hpsum.baseline.show.inventoryError')))
                        	{
                        		var details = '<p>' + localizer.getString('hpsum.common.reenterCredentials')  + '</p>' + 
                        			'<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.edit') + '</a>';
                        	} 
							else if (item.type.match(/SWITCH/i) && item.node_status.match(/Inventory Failed/i)) {
								var details = '<p>' + localizer.getString('hpsum.switchUI.FTPUpdatesFailure')  + '</p>';
							}
							else if (item.type.match(/virtual_connect/i) && item.node_status.match(/Inventory Failed/i)){
								if(item.internal_error_code == F_VC_DOMAIN_NOT_CONFIGURED)
									var details = '<p>' + localizer.getString('hpsum.node.vcDomainNotConfigured')  + '.</p>';
							}
							else if (item.node_status.match(/configuration warnings/i)) {
                                details = localizer.getString('hpsum.common.rerunInventory', new Array('<a id="hpsum-node-detail-inventory">' + localizer.getString('hpsum.common.doInventory') + '</a>'));
								$(INVENTORY_DETAIL_LINK).die("click", onInventory).live("click", onInventory);
                            } else {
    	                    	if(item.node_status.match(/Need Associated Node Details/i)){
    	                    		if(item.type.match(/virtual_connect|sas_switch/i )) {
    	                    			details = '<p>' + item.name + ' ' + localizer.getString('hpsum.node.needAssociatedOADetails') + '.</p>' + 
    	                    				'<a href="'+ base+'/associated" class="company-a">' + localizer.getString('hpsum.node.enterAssociatedOADetails') + '</a>';
    	                    		}
    	                    		else if(item.type.match(/ipdu/i))
    	                    			details = '<p>' + item.name + ' ' + localizer.getString('hpsum.node.needAssociatediPDUDetails') + '</p>' + 
    	                    			'<a href="'+ base+'/associated" class="company-a">' + localizer.getString('hpsum.node.enterPartnerIpduDetails') + '</a>';
    	                    	} else if (item.node_status.match(/standby oa/i)) {
    	                    	    details = '';
    	                    	}
								else if ((item.type.match(/ILO/i) && item.node_status.match(/deploy error/i)))
								{
									var oa_ip_ind = item.node_status.indexOf("[");
									if (oa_ip_ind != -1)
									{
										var oa_ip_end_ind = item.node_status.indexOf("]", oa_ip_ind);
										if (oa_ip_end_ind != -1)
										{
											var oa_node_ip = item.node_status.substring(oa_ip_ind + 1, oa_ip_end_ind);
											if (item.assoc_node_id != undefined && item.assoc_node_id != '')
											{
												var assoc_node_url = '#/node/show/r/session/' + session.getToken() +'/node/'+ item.assoc_node_id+'/getData';
												details='<a href= "' + assoc_node_url + '" class="company-a">' +oa_node_ip+'</a>';
											}
											else
												details=oa_node_ip;
												
											var summaryStr =  item.node_status.substring(0, oa_ip_ind);
											summaryStr += item.node_status.substring(oa_ip_end_ind + 1);
											summary = summaryStr;
										}
									}
								}
								else
								{
                                    //if last character is not ".", append ".".
								    if (item.node_status.charAt(item.node_status.length -1) != '.')
									{
										details = '<p>' + item.name + ': ' + item.node_status + '.</p>';
									}
									else
									{
										details = '<p>' + item.name + ': ' + item.node_status + '</p>';
									}
                                    /* If details message contains a URL then convert the URL a hyperlink */
                                    var urlStartIndex;
                                    urlStartIndex = details.indexOf("http://");
                                    if (urlStartIndex == -1)
                                    {
                                        urlStartIndex = details.indexOf("https://");
                                    }
                                    if (urlStartIndex != -1)
                                    {
                                        var urlEndIndex = details.indexOf(" ", urlStartIndex);
                                        if (urlEndIndex != -1)
                                        {
                                            var url = details.substring(urlStartIndex, urlEndIndex);
                                            var hyperlink = "'<a href=\"" + url + "\">" + url + "</a>'";
                                            details = details.substring(0, urlStartIndex) + hyperlink + details.substring(urlEndIndex);
                                        }
                                    }
    							}
                        	}
                        }
                        else
                        {
                            if(item.internal_error_code == F_VMWARE_DISC_FCHBA_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_FCHBA_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_NIC_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_NIC_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_ILO_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_ILO_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_OS_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_OS_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_SYS_HW_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_SYSHW_DISC_ERR__MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_SMARTARRAY_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_SA_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            } 
                            else if(item.internal_error_code == F_VMWARE_DISC_PCI_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_PCI_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            } 
                            else if(item.internal_error_code == F_VMWARE_SEFL_DISC_DNL_ERROR)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_SELF_DISC_DNL_ERROR_MSG')  + " " + '<a id="hpsum-failed-components-link">' + localizer.getString('hpsum.common.failedComponents') + '</a>' +'</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
							else if(item.internal_error_code == F_VMWARE_COMP_EXEC)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_SELF_DISC_CIM_ERROR_MSG');
                            }
                            else if(item.internal_error_code == F_VMWARE_DISC_GENERAL)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_GENERAL_DISC_ERR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                    localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
                            }
							else if(item.internal_error_code == F_VMWARE_PROVIDERS)
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.F_VMWARE_PROVIDERS_ERROR_MSG')  + '</p>' + '<p>' + localizer.getString('hpsum.common.F_VMWARE_MSG') + '</p>' +
                                localizer.getString('hpsum.common.F_VMWARE_SECOND_MSG', ['<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.retry') + '</a>']);
							}
							else if(item.node_status.match(/Inventory Error/i))
                            {
                                var details = '<p>' + localizer.getString('hpsum.common.reenterCredentials')  + '</p>' + 
                                    '<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.edit') + '</a>';
                            }
                            
                        }
                    	 notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });

                         $('#hpsum-failed-components-link').live('click', onFailedComponents);
                         
                    }
                    
                    if(item.node_state.match(/pending_fw_update/i)) {
                    	$(HEADER).removeClass('hp-show-changing');
                    	
                    	status = 'warning';
                    	summary = localizer.getString('hpsum.integrityilo.haspendingupdate');
                    	details = '<p>' + localizer.getString('hpsum.integrityilo.hasprevious', [item.name]) + '</p>' + 
                    			'<a href="'+ base+'/integrityilo/activatepending" class="company-a">' + localizer.getString('hpsum.integrityilo.activateorcancel') + '</a>';
                    	$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
                    	var url = base+'/integrityilo/activatepending';
                    	$(DEPLOY_ACTION).attr('href',url).text(localizer.getString('hpsum.integrityilo.activatepending'));
                    	
                        notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });               	
                    }
                	

					if (item.node_state.match(/activate_pending/i)) {
						$(HEADER).addClass('hp-show-changing');
						$(ACTIONS).removeClass('hp-disabled');
						$(TITLE).removeClass('hp-unavailable');
						$(TITLE).text(convertTypeStringForTitle(item.type) + ': ' + item.name);
						$(STATUS).hpStatus('ok', true).removeClass('hp-unavailable');
						var deploy_url = base+'/deploy';
						$(DEPLOY_ACTION).attr('href',deploy_url).text(localizer.getString('hpsum.node.reviewDeploy'));

						var notif = {
							status : 'info',
							summary : item.node_status,
							changing : true

						};
						notificationsView.add(notif);
						showNodeProgress(item);
					}
					
					if (item.node_state.match(/idle/i) && item.node_phase.match(/Warning/i)) {
                    	$(HEADER).removeClass('hp-show-changing');
                    	$(STATUS).hpStatus('warning', false).
                        	removeClass('hp-unavailable');
                    	
                    	status = 'warning';
                    	summary = item.node_status;                       
						if(item.hasOwnProperty('port_blocked') && item.port_blocked) {
	                    		//If the remote or local node is server (windows or linux), and inventory failed with error due to 
	                    		//firewall blocked, provide an option to user either to open the ports manually or let SUM do this for user.
	                    		
	                    		//provide option to user
	                    		details = '<p>' + localizer.getString('hpsum.node.openFirewallMsg') + '</p>' +
	                    					'<a id="hpsum-node-show-openfirewall">' + localizer.getString('hpsum.node.openFirewall') + '</a>';
    	                    				
    	                }					    
						
						notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
					}
					
					if (item.node_state.match(/idle/i) && item.node_phase.match(/unknown|error/i)) {
						$(HEADER).removeClass('hp-show-changing');
                    	$(STATUS).hpStatus('error', false).
                        	removeClass('hp-unavailable');
                        	
                    	status = 'error';
                    	summary = item.node_status;
                    	
                    	if(item.node_status.match(/The specified iLo federation group was not found in the network/i)) {
                    		details = '<p>' + localizer.getString('hpsum.common.unknownNodeFederationGrpError')  + '</p>'; 
						}
						//Added for QXCR1001367572 : Change error msg for OneView managed VC when info is not returned for VC.
						else if(item.node_status.match("A device at URL:") && item.node_status.match("managing this Virtual Connect Module. This cannot be updated directly using SUM"))
						{
							details = '<p>' + item.name + ': ' + item.node_status + '.</p>';
						}
						else if(item.node_status.match("The primary IP of the Virtual Connect Module is at URL:") && item.node_status.match("This cannot be updated directly using secondary IP"))
						{
							details = '<p>' + item.name + ': ' + item.node_status + '.</p>';
						}
						else if (  item.type.match(/vmware/i) )
						{
							if(item.node_status.match(/Gen10/i))
							{
								summary = localizer.getString('hpsum.common.F_VMWARE_POSTGEN9_SERVER_FOUND_MSG');
								details = '<p>' + item.node_status  + '</p>';
							}
                            else if (item.node_status_hcode == 5200 || item.node_status.match(/6.7/i))
                            {
                                summary = localizer.getString('hpsum.common.F_VMWARE_ESXI_6_7_UNSUPPORTED_MSG');
                                details = '<p>' + item.node_status  + '</p>';
                            }
                            else if (item.node_status_hcode == 5204) {
                                summary = localizer.getString('hpsum.common.F_VMWARE_ESXI_7_0_UNSUPPORTED_MSG');
                                details = '<p>' + item.node_status + '</p>';
                            }
							else
							{
								summary = localizer.getString('hpsum.common.vmwareLoginError');
								details = '<p>' + localizer.getString('hpsum.common.vmwareLockDownMode') + '</p>' + 
										'<a href="'+ base+'/edit" class="company-a">' + localizer.getString('hpsum.common.edit') + '</a>';
							}
						}
						else if(item.type.match(/hpux|sd2|integrityilo3/i))
						{
							isIntegrityNode = true;
							var integrityNodetype = convertTypeStringForTitle(item.type);
							status = 'error';
							summary = localizer.getString('hpsum.node.addIntegrityNodeError',[integrityNodetype]);
							details = '<p>' + localizer.getString('hpsum.node.integrityNodeErrDetails',[integrityNodetype,integrityNodetype])  + '</p>';
							
						}
						else if(item.type.match(/moonshot/i))
						{
							isMoonshotNode = true;
							var moonshotNodetype = convertTypeStringForTitle(item.type);
							status = 'error';
							summary = localizer.getString('hpsum.node.moonshotNodeError',[moonshotNodetype]);
							details = '<p>' + localizer.getString('hpsum.node.moonshotNodeErrDetails',[moonshotNodetype,moonshotNodetype])  + '</p>';	
						}
						else if(item.node_status_hcode == F_CAC_MODE_ENABLED)
						{
							summary = localizer.getString('hpsum.node.iloCacModeError',[item.name]);
							details = '<p>' + '<a href="/doc/help/en/index.htm#v22484395.htm" class="company-a">' + localizer.getString('hpsum.node.helpDoc') + '</a>' + '</p>';
						}
						else if(item.node_status_hcode == F_HIGHSECURITY_MODE)					{
							summary = localizer.getString('hpsum.node.iloHighSecurityModeError',[item.name]);
							details = '<p>' + '<a href="'+ base+'/iloCredentials">' + localizer.getString('hpsum.node.enteriLOCredentials') + '</a>' + '</p>';
						}
						else if(item.node_status_hcode == F_BIOS_PASSWORD_ENABLED)					{
							summary = localizer.getString('hpsum.node.biosPasswordEnabledError',[item.name]);
							details = '<p>' + '<a href="'+ base+'/iloCredentials">' + localizer.getString('hpsum.node.enteriLOCredentials') + '</a>' + '</p>';
						}
						else if(item.node_status_hcode == F_INVALID_ILO_CREDENTIALS)						
						{
							summary = localizer.getString('hpsum.node.iLOInvalidCredentials',[item.name]);
							details = '</p>' + '<a href="'+ base+'/iloCredentials">' + localizer.getString('hpsum.node.enteriLOCredentials') + '</a>' + '</p>';
						}
						else if (item.node_status_hcode == F_UNSUPPORTED_WINDOWS_VERSION)
						{
							isUnsupportedWindowsOs = true;
							details = '<p>' + item.node_status  + '</p>';
						}
						else
						{
						    /*
                            this piece of line will will show "Unable to identify node as supported node type. Please ensure that node is 
                            supported, reachable on the network and credentials are correct."
                            but this gets displayed in all the cases. The messages which comes from engine are clear enough, and no need 
                            of this particular message to be appended everytime with the message comming from engine.
                            Will delete this comment and commented code post review. Keeping it till and for review.
                            details = '<p>' + localizer.getString('hpsum.common.unknownNodeError')  + '</p>' + */
						    if ((item) && ((item.node_status_hcode == F_CHIF_NEEDED) || (item.node_status_hcode == F_CHIF_INSTALL) || (item.node_status_hcode == F_CHIF_SIGNATURE_VERIFICATION_FAILED)
                                                || (item.node_status_hcode == F_CHIF_COMMUNICATE_AFTER_CHIF_INSTALL) || (item.node_status_hcode == F_CHIF_REBOOT_NEEDED))) {
						        if (item.node_status_hcode == F_CHIF_NEEDED) {
						            /* This will happen in case of Servers >= Gen10 and when CHIF not present. No need to retry. Message should contain edit page. */
									if (item.type.match(/linux/i))
									{
										summary += '\nEnsure proper iLO Channel Interface Driver is installed on the node.';
										details = '';
									}
									else
									{
										summary += '\nPlease check the option, "Install iLO Channel Interface Driver" from "Edit Node" page';
										details = '<a href="' + base + '/edit" class="company-a">' + localizer.getString('hpsum.common.edit') + '</a>';
									}
						        }
						        else if (item.node_status_hcode != F_CHIF_REBOOT_NEEDED) { // Show Retry link except Reboot needed case
						            details = '<a id="hpsum-node-show-chif-retry">' + "Retry" + '</a>'
                                        + "            " + '<a href="' + base + '/edit" class="company-a" style="margin-left:10%">' + localizer.getString('hpsum.common.edit') + '</a>';
						        }
						    }
						    else {
						        details = '<a href="' + base + '/edit" class="company-a">' + localizer.getString('hpsum.common.edit') + '</a>';
						    }


						}
						if(item.node_phase.match(/error/i) && !isIntegrityNode && !isUnsupportedWindowsOs && !isMoonshotNode) {
                            details = '<p>' + localizer.getString('hpsum.common.reenterCredentials')  + '</p>' + 
									'<a href="'+ base+'/edit" class="company-a">' + localizer.getString('hpsum.common.edit') + '</a>';
                        }
						if (summary.indexOf("management software. URL:") != -1)
						{
							var httpsIndex = summary.indexOf("https://");
							if(httpsIndex!=-1)
							{
								var httpURL = summary.substring(httpsIndex);
								var urlIndex = summary.indexOf("URL:");
								if( urlIndex != -1)
								{
									var baseMessage = summary.substring(0, urlIndex);
									details = '<p>Management Software is accessible at: ' + '<a target=_blank href="'+httpURL+'">' + httpURL + '</a>'+ '</p>' + '<a href="'+ base+'/edit">' + localizer.getString('hpsum.common.edit') + '</a>';
									summary = baseMessage;
								}
							}
						}
						
						notificationsView.add({
							status: NOTIFY_STATUSES[status],
							summary: summary, 
							details: details
						});
						
					}


					showActionMenu(item.node_state, item.node_phase, item.type, item);

					if (item.type.match(/vmware/i) && item.node_status.match(/Gen10/i))
					{
					    $(EDIT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a').css("color", "grey");
					}
                    
                    if (item.node_phase.match(/useractionneeded/i)) {
                    	$(HEADER).removeClass('hp-show-changing');
                    	
                    	if(item.node_state.match(/idle/i)){
                    		status = 'warning';
                    		summary = localizer.getString('hpsum.common.doActionInventory');
                    	 	details = '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a id="hpsum-node-detail-inventory">' + localizer.getString('hpsum.common.doInventory') + '</a>';
                    	 	$(INVENTORY_DETAIL_LINK).die("click", onInventory).live("click", onInventory);
							$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');										            
                    	}
                    	if(item.node_state.match(/uan/i)){
                    		summary = details = '';							
							if(item.installable_state == NODE_INSTALLABLE_STATUS_NO_APP_COMP) {
                                status = 'ok';
                                if(item.node_status.match(/firewall/i)){
                                    summary = localizer.getString('hpsum.node.noApplicableComponentsFound');
                                    details = localizer.getString('hpsum.node.noApplicableComponentsFound') + '. ' + localizer.getString('hpsum.node.firewallBlocking');
                                } else {
                                    summary = localizer.getString('hpsum.node.nodeUpToDate') + '. ' + localizer.getString('hpsum.node.noApplicableComponentsFound');
                                    details = localizer.getString('hpsum.node.noApplicableComponentsFound');
                                }
                                 $(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');
                    		}
                    		else if (item.node_status.match(/inventory/i) && !item.type.match(/moonshot/i)) {
                    		     status = 'warning';
                                summary = localizer.getString('hpsum.common.doActionInventory');
                                details = '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a id="hpsum-node-detail-inventory">' + localizer.getString('hpsum.common.doInventory') + '</a>';
								$(INVENTORY_DETAIL_LINK).die("click", onInventory).live("click", onInventory);
                                $(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
                                $(DEPLOY_ACTION).addClass('hp-disabled').removeClass('company-a').css("color", "grey").bind('click.disable-link', function(e) {
                                    e.preventDefault();
                                    return false;
                                });
                    		}
                    		else if(item.hasOwnProperty('port_blocked') && item.port_blocked) {
	                    		//If the remote or local node is server (windows or linux), and inventory failed with error due to 
	                    		//firewall blocked, provide an option to user either to open the ports manually or let SUM do this for user.
	                    		
	                    		status = 'warning';
	                    		summary = localizer.getString('hpsum.node.openFirewallMsg');
	                    		//provide option to user
	                    		details = '<a id="hpsum-node-show-openfirewall">' + localizer.getString('hpsum.node.openFirewallDeploy') + '</a>';
											
								$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
    	                    }
                    		else {
                    				status = 'warning';
                    				summary =  localizer.getString('hpsum.node.readyForDeploy'); // Add in translation
									var sched_flag = item.scheduled;
									var iso_time = item.schedule_date_time;
									var sched_local = iso_time.toString();
									var checkInstallableCode = false;
                            		if(item.type.match(/sdx/i)) {
                                		//SDX has its own deploy options screen
                                		if(item.analysis_errors) {
                                			status = 'error';
                                			summary = localizer.getString('hpsum.node.sd2HasErrors'); // Add in translation
                                		} else if (item.analysis_warnings){
                                			status = 'warning';
                    						summary = localizer.getString('hpsum.node.sd2HasWarnings'); // Add in translation
                                		} else {
											checkInstallableCode = true;
										}
                                		details =    '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a href="'+ base+'/sdx/deploy" class="company-a">' + localizer.getString('hpsum.node.reviewAndDeploy') + '</a>';
                                		var url = base + '/sdx/deploy';
                               	 		$(DEPLOY_ACTION).attr('href',url);
                            		} else if(item.type.match(/moonshot/i)) {
                              		      if(item.invalid_switch_credentials == true) {
                              		        summary = localizer.getString('hpsum.moonshot.invalidSwitchCredentials');
                              		        details = '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a href="'+ base+'/edit" class="company-a">' + localizer.getString('hpsum.moonshot.edit') + '</a>';
                                        } else if (item.switch_vsp_connect_error == true) {
                                            summary = localizer.getString('hpsum.moonshot.failedtoValidateSwitchCredentials');
                                            details = '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a id="hpsum-node-detail-inventory">' + localizer.getString('hpsum.common.doInventory') + '</a>';
											$(INVENTORY_DETAIL_LINK).die("click", onInventory).live("click", onInventory);
                                        } else if (item.node_status.match(/Ready to start inventory/i)) {
			                    		    status = 'warning';
			                                summary = localizer.getString('hpsum.common.doActionInventory');
			                                details = '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a id="hpsum-node-detail-inventory">' + localizer.getString('hpsum.common.doInventory') + '</a>';
											$(INVENTORY_DETAIL_LINK).die("click", onInventory).live("click", onInventory);
			                                $(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
			                                $(DEPLOY_ACTION).addClass('hp-disabled').removeClass('company-a').css("color", "grey").bind('click.disable-link', function(e) {
			                                    e.preventDefault();
			                                    return false;
			                                });
			                    		} else {
											checkInstallableCode = true;
                                            summary =  localizer.getString('hpsum.node.readyForDeploy');
                              		            details = '<p>' + item.name + ': ' + localizer.getString('hpsum.node.readyForDeploy') + '.</p>' + '<a href="'+ base+'/deploy">' + localizer.getString('hpsum.node.reviewAndDeploy') + '</a>';
                              		      }
                                        
                                        //Prevent deploy in case of any error
                                        if(item.invalid_switch_credentials == true || item.switch_vsp_connect_error == true) {
                                            $(DEPLOY_ACTION).addClass('hp-disabled').removeClass('company-a').css("color", "grey").bind('click.disable-link', function(e) {
                                                e.preventDefault();
                                                return false;
                                            });
                              		  }
        
                                    }
                            		else {
									  checkInstallableCode = true;
									  if(item.node_phase.match(/UserActionNeeded/i) && item.node_state.match(/remote_staging_uan/i) )
                                      {
                                            details =    '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a href="'+ base+'/deploy" class="company-a">' + localizer.getString('hpsum.easymode.DeployStaged') + '</a>';
                                      }
									  else {
											details =    '<p>' + item.name + ': ' + item.node_status + '.</p>' + '<a href="'+ base+'/deploy" class="company-a">' + localizer.getString('hpsum.node.reviewAndDeploy') + '</a>';
									  }
                              		  if(item.hasOwnProperty('is_ilo_domain')) {
                              		  	details += '<p><a href="'+ base+'/integrityilo/deploydomain" class="company-a">' + localizer.getString('hpsum.integrityilo.doDeployDomain') + '</a></p>';
                              		  	if(!$('.deploy-domain').length) {
                              		  		$(DEPLOY_ACTION).closest("ol").after('<ol class=\"deploy-domain\"><li><a href="'+ base+'/integrityilo/deploydomain\">'+ localizer.getString('hpsum.integrityilo.deployDomain') +'</a></li></ol>');	
                              		  	}
                              		  }
                            		}                           		
									
									$(STATUS).hpStatus('warning', false).removeClass('hp-unavailable');
									if(checkInstallableCode = true) {										
										if (item.installable_state == NODE_INSTALLABLE_STATUS_ATBASELINE){
											status ='ok';
											summary = localizer.getString('hpsum.node.nodeUptoDate');
											$(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');											
										}
										if(item.installable_state == NODE_INSTALLABLE_STATUS_ABOVEBASELINE){
											status ='ok';
											summary = localizer.getString('hpsum.node.nodeAboveBaseline');
											$(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');											
										}
									}										
                    	 	}
                    	}
                        notificationsView.add({
                            status: NOTIFY_STATUSES[status],
                            summary: summary,
                            details: details
                        });
                       
                       }
					   
				} else {
                    $(TITLE).text('');
                    $(STATUS).hpStatus('unknown');
                    $(STATUS + ' span').text('');
                }
                if(isSplashActive)
                {
                    closeAnalysisSplash();
                }
            }
            
            function onCHIFError() {

            }

            function onCHIFSuccess() {

            }

            function onCHIFRetry(ev) {
                
                var options = {
                    hapi: {
                        type: nodeItem.type,
                        skip_prereqs: false
                    }
                };

                /* now send the set-attributes command, so that rescout will happen for item.type node type only. */
                presenter.setattribute(thisNode, options, {
                    success: onCHIFError,
                    error:onCHIFSuccess
                });
            }


            function onOpenFirewall(ev) {
            	
            	if($('#hpsum-node-show-openfirewall').hasClass("hp-disabled")) {
                    ev.preventDefault();
                    return;
                }
				
				var options =  {
                        hapi: {
                        open_firewall : "true"
                        }
                    };

				presenter.setattribute(thisNode, options, {															
					success : onOpenFirewallSuccess,
					error : onOpenFirewallError									
					});
					
				ev.preventDefault();
            }
            
            function onOpenFirewallSuccess()
			{
				var	message = localizer.getString('hpsum.node.openFirewallSuccessNotifMsg') + nodeItem.name;
				notifications.show(message, 'ok');
				
				var status = 'ok';
                var summary = localizer.getString('hpsum.node.openFirewallSuccessNotifMsg') + nodeItem.name;
                 
				
				if(nodeItem.hasOwnProperty('firewall_node_state') && 
				( nodeItem.firewall_node_state.match(/inventory/i) || nodeItem.firewall_node_state.match(/install/i)) ) {
                    thisNode.operation_mode = 0; /* set mode of operation to inventory */
					presenter.startInventory(thisNode, {															
						success : onStartInventorySuccess,
						error : onStartInventoryError									
						}); 
				}
				
				$(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');
                
                notificationsView.add({
                status: NOTIFY_STATUSES[status],
                summary: summary,
                details: ''});
			}
			
			function onOpenFirewallError()
			{
				var	message = localizer.getString('hpsum.node.openFirewallErrorNotifMsg') + nodeItem.name;
				notifications.show(message, 'error');
			}
			
			function onStartInventorySuccess()
			{
				var	message = localizer.getString('hpsum.node.openFirewallInventoryStartNotifMsg') + nodeItem.name;
				notifications.show(message, 'ok');
				
				var status = 'ok';
                var summary = localizer.getString('hpsum.node.openFirewallInventoryStartNotifMsg') + nodeItem.name;
                
                $(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');
                
                notificationsView.add({
                status: NOTIFY_STATUSES[status],
                summary: summary,
                details: ''});
			}
			
			function onStartInventoryError()
			{
				var	message = localizer.getString('hpsum.node.openFirewallInventoryErrorNotifMsg') + nodeItem.name;
				notifications.show(message, 'error');
			}
			
			function onStartDeploySuccess()
			{
				var	message = localizer.getString('hpsum.node.openFirewallDeployStartNotifMsg') + nodeItem.name;
				notifications.show(message, 'ok');
				
				var status = 'ok';
                var summary = localizer.getString('hpsum.node.openFirewallDeployStartNotifMsg') + nodeItem.name;
                
                $(STATUS).hpStatus('ok', false).removeClass('hp-unavailable');
                
                notificationsView.add({
                status: NOTIFY_STATUSES[status],
                summary: summary,
                details: ''});
			}
			
			function onStartDeployError()
			{
				var	message = localizer.getString('hpsum.node.openFirewallDeployErrorNotifMsg') + nodeItem.name;
				notifications.show(message, 'error');
			}
            
			function onRunNow(ev) {
				var schedule_information;
				var scheduled;
				var node_id = nodeItem.node_id;
				var	action = 'deploynow';
						 
					presenter.ScheduleNodes(node_id,action,scheduled,schedule_information, {
						success : function(data) {
							onRunNowSuccess(data); 
						},
						error : function(errorInfo) {
							onRunNowError(errorInfo);
						}
					});	
			}
			
			function onRunNowSuccess()
			{
				showNodeProgress(nodeItem);
			}
			function onRunNowError()
			{
			
			}
			function onDeleteSchedule(ev) {
				var contents = $(deleteConfirmHtml);
				$('#hpsum-delete-node',contents).html(localizer.getString('hpsum.node.deleteschedule')); // Add in translation
				$('#hpsum-node-delete-cancel',contents).show();
				
				localizer.localizeDom(contents);
				var dialogView = new DialogView();
                dialogView.init({contents: contents,
					ok: function () {
						btnScheduleDelete();
					},
					cancel: function () {
						router.go('/node/show');
					}
				});
			}
			
			function btnScheduleDelete()
			{
				var scheduled;
				var schedule_information;
				var node_id = nodeItem.node_id;
				var action = 'delete';
					 
				presenter.ScheduleNodes(node_id,action,scheduled,schedule_information, {
					success : function(data) {
						onDeleteScheduleSuccess(data); 
					},
					error : function(errorInfo) {
						onDeleteScheduleError(errorInfo);
					}
				});	
			}
			
			function onDeleteScheduleSuccess()
			{
				var	message = "Schedule for " + nodeItem.name + " deleted successfully";
				notifications.show(message, 'ok');  

				showNodeProgress(nodeItem);
			}
			function onDeleteScheduleError()
			{
			
			}
            
	    
            function onConfirmWarning() {
					var summary = localizer.getString('hpsum.common.applyUserSelection');

					notificationsView.add({
							status: 'warning',
                            summary: summary,
							changing: true
                    });
                var options =  {
                    hapi: {
                        ignore_warnings : "true"
                    }
                };
                presenter.setattribute(nodeItem, options, {
                    success: function() {
                      notificationsView.add({details: localizer.getString('hpsum.common.confirmSelected')}, true);
                    },
                    error: function() {}
                });
            }
			        	
            function onCancelWarning() {
                var options =  {
                    hapi: {
                        ignore_warnings : "false"
                    }
                };
                presenter.setattribute(nodeItem, options, {
                    success: function() {
                        notificationsView.add({ details: localizer.getString('hpsum.common.button.cancelSelected') }, true);
                    },
                    error: function() {}
                });
            }
			
            function onItemUpdateSuccess()
            {
				presenter.refreshIndexResults();
            }

            function onItemUpdateError()
            {
                
            }

            function showActionMenu(state, phase, type, item) {
                $(EDIT_ACTION).removeClass('hp-disabled').addClass('company-a');               
                $(ONLINE_DEPLOY).parent().parent().hide();
                $(OFFLINE_DEPLOY).parent().parent().hide();
                $(DEPLOY_ACTION).parent().parent().show();
                $(DEPLOY_ACTION).attr("href", "#/node/deploy");
                $(EDIT_ACTION).removeClass('hp-disabled').attr('style', '');

                if (state.match(/Idle/i)) {
                    $(EDIT_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                    if (phase.match(/UnKnown/i)) {
                            $('.hpsum-deploy').removeClass('hp-disabled').addClass('company-a');
                        $(ABORT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                        $(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a');
                        $(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a'); /* disable Satge/Deploy in scout failed case */
						$(DEPLOY_ACTION).addClass('hp-disabled').removeClass('company-a');
                        $('.hpsum-deploy').addClass('hp-disabled').removeClass('company-a');
                        $(REPORTS_ACTION).addClass('hp-disabled').removeClass('company-a');
                        $(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a');
                        $(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a');
				$(DELETE_ACTION).removeClass('hp-disabled').addClass('company-a');

                    }
					else if((isIntegrityNode || isUnsupportedWindowsOs || isMoonshotNode) && phase.match(/error/i))
					{
						$(EDIT_ACTION).addClass('hp-disabled').removeClass('company-a');
						$(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a');
						$(ABORT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
						$(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');
						$(DEPLOY_ACTION).addClass('hp-disabled').removeClass('company-a');
                        $('.hpsum-deploy').addClass('hp-disabled').removeClass('company-a');
                        $(REPORTS_ACTION).addClass('hp-disabled').removeClass('company-a');
                        $(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a');
                        $(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a');
						$(DELETE_ACTION).removeClass('hp-disabled').addClass('company-a');
					}
					else {

                        if (phase.match(/initialize/i)) {
                            $(DELETE_ACTION).addClass('hp-disabled').removeClass('company-a');
                            $(DELETE_ACTION).css("color", "grey").bind('click.disable-link', function(e) {});
                        } else {
								$(DELETE_ACTION).removeClass('hp-disabled').addClass('company-a');
                        }
                        notificationsView.add({ summary: item.node_status }, true);/* Its needed to display on going sub-tasks during discovery */
                        $(ABORT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                            $(INVENTORY_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                        $('.hpsum-deploy').addClass('hp-disabled').removeClass('company-a');
                        //add ilo5 here for final checkin.
                        if (type.match(/windows|linux|ilo/i) && !item.node_id.match(/N1localhost/i)) {
                            $(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');
                          
                        } else {
                            $(DEPLOY_ACTION).addClass('hp-disabled').removeClass('company-a');
                            $(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');
                        }
                        $(REPORTS_ACTION).addClass('hp-disabled').removeClass('company-a');
                        $(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a');
                        $(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a');
					    //QXCR1001531761 : Disable Direct deploy
                        //enable deploy link for gen10 servers and iLO5 only when pending queued items are there.
                        /*if (phase.match(/UserActionNeeded/i)) {
                            if (type.match(/ilo5/i) || (item.server_generation >= 10 && type.match(/windows|linux/i))) {
                                //check if node has and pending queued items.. then only enable deploy link..
                                presenter.getIloTasksPresenter(item.node_id, {
                                    success: function (data) {
                                        if (data && data.hapi && data.hapi.ilotasks != undefined && data.hapi.ilotasks.ilotask != undefined) {
                                            if (data.hapi.ilotasks.ilotask[0].state.match(/Pending/i)) {
                                              //  $(DEPLOY_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                                            }
                                        }
                                    }, error: function () {

                                    }
                                });
                            }
                        }
                        */
                    }
                } else if (state.match(/inventory$/i)) {

                    $(DELETE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $('.hpsum-deploy').addClass('hp-disabled').removeClass('company-a');
                    $(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(REPORTS_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(EDIT_ACTION).addClass('hp-disabled').removeClass('company-a');

                } else if (item.node_state == "STAGE_ONLY") {
                    $(EDIT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                    $(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(DEPLOY_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $('.hpsum-deploy').addClass('hp-disabled').removeClass('company-a');
                    $(REPORTS_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(DELETE_ACTION).addClass('hp-disabled').removeClass('company-a');
                }
                else if (state.match(/UAN/i) || state.match(/remote_staging_uan/i)) {
                        $(DELETE_ACTION).removeClass('hp-disabled').addClass('company-a');
                    $(ABORT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                        $(INVENTORY_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                    /* after inventory/staging, user may go for normal inventory or stage, so wee need to enable stage/deploy again for remote win/lin case.*/
                    if (type.match(/windows|linux|ilo/i)) {
                        if (item.server_generation >= 10 || item.type.match(/ilo5/i)) {
                            $(STAGE_ACTION).removeClass('hp-disabled').attr('style', 'color:#007dba;').unbind('click.disable-link');
                            $(STAGE_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
							var regexp = /^[I]/;
							if(item.baselines[0].match(regexp))
							{
								$(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');
							}
                        }
                        else {
                            $(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');
                        }

						$(DEPLOY_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');

                        if (state.match(/remote_staging_uan/i)) {
                            /* If staged inventory: disable report*/
                            $(REPORTS_ACTION).addClass('hp-disabled').removeClass('company-a');
                        } else {
                            $(REPORTS_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                        }
                    } else {
                            $('.hpsum-deploy').removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                        //$(DEPLOY_ACTION).addClass('hp-disabled').removeClass('company-a');	// Stage/Deploy for localhost should be disabled
                        $(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');
                        $(REPORTS_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                    }

                        $(SCHEDULE_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                        $(EDIT_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                    $(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a');

                } else if (state.match(/InstallDone/i)) {
                        $(DELETE_ACTION).removeClass('hp-disabled').addClass('company-a');
						$(ABORT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                        $(INVENTORY_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
						$('.hpsum-deploy').addClass('hp-disabled').removeClass('company-a');
                        $(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(REPORTS_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                    $(EDIT_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                    $(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a');

                    //Modify condition here to disable reboot link after install is done
                    //if the reboot action is not supported for the node type
                    if (type.match(/ilo|switch|ipdu|virtual_connect|oa|sas_switch|sdx|sd2oa|integrityilo|moonshot/i))
                        $(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a');
                    else
                            $(REBOOT_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');

                } else if (state.match(/Install$/i)) {

                    $(DELETE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    if (type.match(/switch|ipdu|virtual_connect|oa|sas_switch|sdx|sd2oa|ilo|integrityilo/i)) {
                        $(ABORT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                    } 

					
                    $(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a');
                    /* dissable Stage/Deploy during install */
                    $(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $('.hpsum-deploy').addClass('hp-disabled').removeClass('company-a');
                    $(REPORTS_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(EDIT_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a');

                } else if (state.match(/INSTALLFROMILOTASKQUEUE|INSTALLFROMRECOVERYSET/i)) {
					$(DELETE_ACTION).addClass('hp-disabled').removeClass('company-a');

					$(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a');
                    /* dissable Stage/Deploy during install */
                    $(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $('.hpsum-deploy').addClass('hp-disabled').removeClass('company-a');
                    $(REPORTS_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(EDIT_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a');

				} else if (state.match(/abort/i)) {
					$(DELETE_ACTION).addClass('hp-disabled').removeClass('company-a');
					$(ABORT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
					$(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a');
                    /* dissable Stage/Deploy during install */
                    $(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $('.hpsum-deploy').addClass('hp-disabled').removeClass('company-a');
                    $(REPORTS_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(EDIT_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(STATUS).hpStatus('ok').removeClass('hp-unavailable');

                    summary = item.node_status;
                    details = item.node_status;
                    status = 'ok';

                    notificationsView.add({
                        status: NOTIFY_STATUSES[status],
                        summary: summary,
                        details: details
                    });

				} else if (state.match(/activate_pending/i)) {

                    $(DELETE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $('.hpsum-deploy').addClass('hp-disabled').removeClass('company-a');
                    $(REPORTS_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(EDIT_ACTION).addClass('hp-disabled').removeClass('company-a');

                } else if (state.match(/pending_fw_update/i)) {

                    $(DELETE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(ABORT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                    $(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a');

                        $('.hpsum-deploy').removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                        $(EDIT_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                    $(REPORTS_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a');
                    $(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a');

                } else if (state.match(/error/i)) {
                    $(DELETE_ACTION).removeClass('hp-disabled').addClass('company-a');
                    $(ABORT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                    $(INVENTORY_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
					$('.hpsum-deploy').addClass('hp-disabled').removeClass('company-a');
                    /* Enable stage/deploy incase of node is in error state, to allow redo the same action */
                    if (type.match(/windows|linux|ilo5/i) && !item.node_id.match(/N1localhost/i)) {
                        //$(STAGE_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                        //QXCR1001531761 : Disbale direct deploy
                        //$(DEPLOY_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
						$(DEPLOY_ACTION).attr("href", "#/node/directdeploy");
                    } else {
                        // $(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');
						$(DEPLOY_ACTION).addClass('hp-disabled').removeClass('company-a');
                    }
                    $(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');

                    $(REPORTS_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                    $(SCHEDULE_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                    $(REBOOT_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                    $(EDIT_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                }
                else if (state.match(/^scheduled/i)) {
                     $(DELETE_ACTION).removeClass('hp-disabled').unbind('click.disable-link');
					 $(DELETE_ACTION).addClass('company-a').addClass('hp-primary');


                     $(REPORTS_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');
                     $(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a');
                     $(ACTIONS).removeClass('hp-disabled');
                     $(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a');
                     $(STAGE_ACTION).addClass('hp-disabled').removeClass('company-a');
					 $(DEPLOY_ACTION).removeClass('hp-disabled').addClass('company-a').unbind('click.disable-link');

                    if (!state.match(/scheduled/i))
                        $(DEPLOY_ACTION).addClass('hp-disabled').removeClass('company-a');

                     $(EDIT_ACTION).addClass('hp-disabled').removeClass('company-a');
                }
                else if (state.match(/ILO_TASK_INPROGRESS/i)) {
                    $(ACTIONS).removeClass('hp-disabled');
                    $(DELETE_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                    $(REPORTS_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                    $(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                    $(TITLE).removeClass('hp-unavailable');
                    $(TITLE).text(convertTypeStringForTitle(item.type) + ': ' + item.name);
                    $(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                    $(DEPLOY_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                    $(EDIT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                    $(ABORT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                    $(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                }
				if(state.match(/remote_staging_scheduled/i))
				{
					 $(ACTIONS).removeClass('hp-disabled');
					 $(EDIT_ACTION).addClass('hp-disabled').removeClass('company-a');
					 $(INVENTORY_ACTION).addClass('hp-disabled').removeClass('company-a');
					 $(DEPLOY_ACTION).addClass('hp-disabled').removeClass('company-a');
					 //stage
					 $(STAGE_ACTION).removeClass('hp-disabled').unbind('click.disable-link');
					 $(STAGE_ACTION).addClass('company-a').addClass('hp-primary');
					 $(REPORTS_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
					 $(REBOOT_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
					 $(SCHEDULE_ACTION).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');                                         
				}

                if (!phase.match(/Initialize/i)) {
                    $(".hp-disabled").css("color", "grey").bind('click.disable-link', function(e) {
                        e.preventDefault();
                        return false;
                    });
                }
            }
                
            function showNodeProgress(item){
            		if(timerMap[item.node_id])
            			return;
        		   	timerMap[item.node_id] = setInterval(function () {
            		presenter.getNodeStatus(item, {
                				success : function(data) {
                    				onNodeStatusSuccess(data);
                    		 	},
                    			error : function(errorInfo) {
                        			onNodeStatusError(errorInfo);
                    			}
                			});
                			
                }, 3000);
        	}
        	
        	function onNodeStatusSuccess(data){
        		if(thisNode.node_id == data.hapi.node_status.node_id) 
                {
                    var detailsContent = '';
                   if(data.hapi.node_status.node_state.match(/inventory$/i)){
                        detailsContent = localizer.getString('hpsum.node.inventoryInProgress');
                   }
                   if (data.hapi.node_status.node_state.match(/ILO_TASK_INPROGRESS/i)) {
                       detailsContent = data.hapi.node_status.node_status;
                   }
				   if(data.hapi.node_status.node_phase.match(/Initialize/i)){
					   detailsContent = data.hapi.node_status.node_status;
				   }
                   if (data.hapi.node_status.node_state.match(/STAGE_ONLY/i)) {
                       detailsContent = localizer.getString('hpsum.easymode.stageInProgress');
                   }
						
                    var notif = {
        				  	status: 'info',
                            summary: data.hapi.node_status.node_status,
                            // timestamp: (new Date().toISOString()),
                            changing: true,
                            details: detailsContent // Add in translation
        			};
        			 
        			 
                    if (data.hapi.node_status.node_state.match(/idle|uan|error|pending_fw_update|idle|installdone|STAGE_ONLY_DONE|installhold|scheduled|pendingfwupdate|activatependingfwupdate/i) &&
					   !data.hapi.node_status.node_phase.match(/Initialize/i)){
        				notificationsView.remove(notif);
        				presenter.refreshIndexResults();
        				clearInterval(timerMap[data.hapi.node_status.node_id]);
        				delete timerMap[data.hapi.node_status.node_id];
        			}
                    else {
                        notificationsView.add(notif);			
                    }
        		}
        		else
        		{
        				clearInterval(timerMap[data.hapi.node_status.node_id]);
        				delete timerMap[data.hapi.node_status.node_id];
        		}
        	}
        	
        	function onNodeStatusError(error){
        		
        		/*if(data.hapi.node_status.node_state.match(/uan|error|pending_fw_update|idle/i)){
        				//clearInterval(inventoryTimer);
        				presenter.refreshIndexResults();
        		}*/
        	}

            function onItemError(errorMessage) {
            }
            
            function onSelectionChange(selection) {
                notificationsCleared = false;
                clearNotifications();
                urlFragment.replaceHrefUris(HEADER,
                    selection.uris, selection.multiSelectId);
                if ($(HEADER).hasClass('hp-show-init')) {
                    $(HEADER).removeClass('hp-show-init');
                } else {
                    $(HEADER).addClass('hp-show-changing');
                    $(ACTIONS).addClass('hp-disabled').removeClass('company-a').removeClass('company-a');
                }
            }
            
            function onAggregateChange(aggregate) {
                $(TITLE).removeClass('hp-unavailable').text(localizer.getString('hpsum.node.nodeCount',[ aggregate.count ]));
                $(STATUS).hide();
                notificationsCleared = false;
                clearNotifications();
            }
            
            function onItemDeleteSuccess(item_name) {
                notificationsView.add({summary: localizer.getString('hpsum.switchUI.deleted')}, true); // Add in translation
                deleteInProgress = false;
            }
			
			function onItemRebootSuccess(item_name) {
                notificationsView.add({summary: localizer.getString('hpsum.node.nodeRebooted')}, true); // Add in translation
                rebootInProgress = false;
            }
			
			function onItemRebootError(errorMessage) {
                notificationsView.add({summary:errorMessage}, true);
                rebootInProgress = false;
            }

            /**
             * @private
             */
            function onItemDeleteError(errorMessage) {
                notificationsView.add({summary:errorMessage}, true);
                deleteInProgress = false;
            }


            function showAnalysisSplash(flag)
            {
                $(SPLASH_DIALOG).dialog({
                    modal : true,
                    position : "center",
                    draggable : false,
                    resizable : false,
                    show : 'fade',
                    closeOnEscape: false,
                    dialogClass : 'hp-splash-dialog',
                    width : 400
                });
                if(flag)
                    $('#hpsum-node-show-splash-message').html(localizer.getString('hpsum.node.abortInProgress'));
                else
                    $('#hpsum-node-show-splash-message').html(localizer.getString('hpsum.node.abortInProgress'));
                $(SPLASH_SPINNER).show();   
                isSplashActive = true;
            }

            function closeAnalysisSplash()
	    {
                if(! nodeItem.node_state.match(/^scheduled$|^remote_staging_scheduled$/i))
                {
                    $(SPLASH_SPINNER).hide();
                    try {
                        $(SPLASH_DIALOG).dialog('destroy');
                    } catch(e) {}    
                    isSplashActive = false;
                }


                
            }
            
            
            function onAbort(ev){
                
                if($(ABORT_ACTION).hasClass("hp-disabled")) {
                    ev.preventDefault();
                    return;
                }
                
        		if (! abortInProgress) {
                   abortInProgress = true;
                    
                   var contents = $(abortConfirmHtml);
                   localizer.localizeDom(contents);
                    $(ABORT_TITLE, contents).text(localizer.getString('hpsum.node.abortFor', [presenter.selectionLabel()]));
                        
                    $(ABORT_ERROR, contents).hide();
                    var dialogView = new DialogView();
                    dialogView.init({contents: contents,
                        ok: function () {
                            if(nodeItem.node_state.match(/^scheduled$|^remote_staging_scheduled$/i))
							{
								showAnalysisSplash(true);
							}
						var object = { hapi : { clearScheduleDateTime : true} };
                                presenter.abortAction(object,{									
                                    success : function(){
                                    	abortInProgress = false;
                                        closeAnalysisSplash();
                                    },
                                    error : function(msg){
                                    	notificationsView.add({summary:msg}, true);
                                    	abortInProgress = false;
                                    }
                                });
                        },
                        cancel: function () {
                            abortInProgress = false;
                        }
                    });
                }
                
                ev.preventDefault();
        	}

            /**
             * @private
             */
            function onDeleteItem(ev) {
                
                if($(DELETE_ACTION).hasClass("hp-disabled")) {
                    ev.preventDefault();
                    return;
                }
                
				if ( presenter.selectionLabel() === 'localhost')
				{
					var contents = $(deleteConfirmHtml);
					$('#hpsum-delete-node',contents).html(localizer.getString('hpsum.node.cannotDelete'));
					$('#hpsum-node-delete-cancel',contents).hide();
					$('#hpsum-node-delete-ok',contents).html(localizer.getString('hpsum.common.button.ok'));

					var dialogView = new DialogView();
                    dialogView.init({contents: contents,
						ok: function ()
						{}
					 });
				}
				else {
					if (! deleteInProgress) {
						deleteInProgress = true;
					
						var contents = $(deleteConfirmHtml);
						$('#hpsum-delete-node',contents).html(localizer.getString('hpsum.common.continueWithDeleting')+' '+presenter.selectionLabel()+'?');
						$('#hpsum-node-delete-ok',contents).html(localizer.getString('hpsum.baseline.show.yesDelete'));
						$('#hpsum-node-delete-cancel',contents).show();

						localizer.localizeDom(contents);
						if(nodeItem.scheduled === 'true')
						{
							var table;
							//var data;
							var schedule_date_time_new = '';
							if(nodeItem.schedule_date_time)
							{
								var schedule_date_time_old = nodeItem.schedule_date_time.split(' ');
								var schedule_time_format = schedule_date_time_old[2];
								var schedule_time = schedule_date_time_old[1];
								var schedule_time_hrs_mins = schedule_time.split(':');
								var schedule_time_hrs = schedule_time_hrs_mins[0];
								if (schedule_time_format == undefined)
								{
									schedule_date_time_new = schedule_date_time_old;
								}
								else
								{
									if(schedule_time_format == 'PM')
									{
										if (schedule_time_hrs < 12)
										{
										schedule_time_hrs = parseInt(schedule_time_hrs) + 12;
										schedule_date_time_new = schedule_date_time_old[0] + ' ' + schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
										}
										if (schedule_time_hrs == 12)
										{
										schedule_time_hrs = parseInt(schedule_time_hrs) + 0;
										schedule_date_time_new = schedule_date_time_old[0] + ' ' + schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
										}
									}
									if(schedule_time_format == 'AM')
									{
										if (schedule_time_hrs < 12)
										{
										schedule_time_hrs = parseInt(schedule_time_hrs) + 0;
										schedule_date_time_new = schedule_date_time_old[0] + ' ' + '0' +schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
										}
										if (schedule_time_hrs == 12)
										{
										schedule_time_hrs = parseInt(schedule_time_hrs) - 12;
										schedule_date_time_new = schedule_date_time_old[0] + ' ' + '0'+ schedule_time_hrs + ':' + schedule_time_hrs_mins[1];
										}
									}
								}									
								if(nodeItem.scheduled === "true")
								{
									 $('#hpsum-delete-node',contents).hide();
									
									table = "<p>This node is scheduled for deployment at" + ' ' + schedule_date_time_new  + '.' + ' ' +"Do you still want to continue with delete? </p>";
									//table +="<table><thead><tr><th>Node Name</th><th>Schedule DateTime</th></tr> ";
									//table += "<tr><td>" + nodeItem.name + "</td>";
									//table += "<td>" + nodeItem.schedule_date_time + "</td></tr>";
									//sched_flag = "yes";
									
								}
								//table += "</table>";
							}
							$(DELETE_SCHEDULE,contents).html(table);
							$(DELETE_TITLE, contents).text(
									localizer.getString('hpsum.common.deleteArg',
									[presenter.selectionLabel()]));
					}
					else
					{
						$(DELETE_TITLE, contents).text(
							localizer.getString('core.deleteConfirm.title',
								[presenter.selectionLabel()]));
					}
                    var dialogView = new DialogView();
                    dialogView.init({contents: contents,
                        ok: function () {
                                presenter.deleteItem({
                                    success : onItemDeleteSuccess,
                                    error : onItemDeleteError
                                });
                        },
                        cancel: function () {
                            deleteInProgress = false;
                        }
                    });
                }
                }
                ev.preventDefault();
            }
            
            function updateActionLinks(){
            	  	var resource = router.location().split('/');
                	resource = resource[1];
    				
    				 $('a[data-change]').each(function(index) {
                		var currentLink = $(this).attr('href');
                		if(currentLink  == undefined)
                			return;
                		var current = currentLink.split('/');
                		current[1] = resource;
                		currentLink =current.join('/');
                		$(this).attr('href',currentLink);
  					});
            }
			
			function onReboot(ev){
			    
               if($(REBOOT_ACTION).hasClass("hp-disabled")) {
                    ev.preventDefault();
                    return;
                }

			var contents = $(rebootConfirmHtml);
                localizer.localizeDom(contents);
                $('#hpsum-otu-reboot-title', contents).text(
                    localizer.getString('hpsum.RebootConfirm.title'));
				var dialogView = new DialogView();
                dialogView.init({contents: contents,
                	ok: function () {
						if (!rebootInProgress) 
						{
							rebootInProgress = true;
							
							presenter.rebootNode(thisNode.node_id, {															
								success : onItemRebootSuccess,
								error : onItemRebootError									
								});		
						}
                    },
                    cancel: function () {
						rebootInProgress = false;
                        return;
                    }
                });				
				ev.preventDefault();
			}

            function onFailedComponents(ev) {
                var contents = $(failedComponentsHtml);
                localizer.localizeDom(contents);
                var failedDialog = new DialogView();
                failedDialog.init({contents: contents,
                    cancel: function () {
                        router.go('/node/show');
                    }
                }); 
                populateFailedComponentTable();             
            }
            

            function initComponentTable(tableid) {
                var oTab = $(tableid).dataTable({
                    oLanguage: {
                        sEmptyTable: localizer.getString("hpsum.node.noApplicableComponentsFound"),
                        sSearch: localizer.getString('hpsum.common.search')
                                        },
                    bPaginate : false,
                    bProcessing : true,
                    bFilter : true,
                    bSort : true,
                    bAutoWidth : false,
                    bInfo : false,
                    bRetrieve : true,
                    bDestroy : true,
                    //aaData: data,
                    aoColumns : [
                        {mDataProp: 'Component_ID'},
                        {mDataProp: 'Component_Name'},
                      ],
                    aaSorting: [],
                    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                        return nRow;
                    }
                });
            }

            //Populate failed components table
            function populateFailedComponentTable(){
                    initComponentTable(FAILED_COMPONENTS_TABLE);
                    var oTable = $(FAILED_COMPONENTS_TABLE).dataTable();
                    //oTable.fnClearTable();
                    for(var i=0; i<nodeItem.failed_component_id.length; i++)
                    {
                    var compItem = [{
                            'Component_ID': nodeItem.failed_component_id[i],
                            'Component_Name': nodeItem.failed_component_name[i]
                        }];
                    oTable.fnAddData(compItem);
                    }
                }

            this.resume = function () {
                notificationsCleared = false;
                $('#hp-page-notifications').remove();
                notificationsView.init({context: $(VIEW),
                    allLocation: '#/node/show/activity',
                    resource: presenter.resource()});
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("aggregateChange", onAggregateChange);
                presenter.on("itemChange", onItemChange);
                presenter.on("itemError", onItemError);
                updateActionLinks();
                                
                $(DELETE_ACTION).bind('click', onDeleteItem);
                $(ABORT_ACTION).bind('click', onAbort);
                $(REBOOT_ACTION).bind('click', onReboot);
				$(INVENTORY_ACTION).bind('click',onInventory);
                $(document).on('click', '#hpsum-node-show-openfirewall', onOpenFirewall);
                $(document).on('click', '#hpsum-warning-confirm', onConfirmWarning);
                $(document).on('click', '#hpsum-warning-cancel', onCancelWarning);		
                $(document).on('click', '#hpsum-node-show-chif-retry', onCHIFRetry);

                if (notificationsView.resume) {
                    notificationsView.resume();
                }
            };
            
            this.pause = function () {
                presenter.off("selectionChange", onSelectionChange);
                presenter.off("aggregateChange", onAggregateChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
                $(DELETE_ACTION).unbind('click', onDeleteItem);
                $(ABORT_ACTION).unbind('click', onAbort);
                $(REBOOT_ACTION).unbind('click', onReboot);
				$(INVENTORY_ACTION).unbind('click',onInventory);
                $('#hpsum-node-reboot').unbind('click', onReboot);
                $('#hpsum-node-schedule-run').unbind('click').bind('click', onRunNow);
                $('#hpsum-node-scheduledelete').unbind('click').bind('click', onDeleteSchedule);
                $('#hpsum-failed-components-link').unbind('click', onFailedComponents);
                $(document).off('click', '#hpsum-node-show-openfirewall');
                $(document).off('click', '#hpsum-warning-confirm');
                $(document).off('click', '#hpsum-warning-cancel');
                $(document).off('click', '#hpsum-node-show-chif-retry');


                for (var key in timerMap) {
                    clearInterval(timerMap[key]);
                    delete timerMap[key];
                }
                if (notificationsView.pause) {
                    notificationsView.pause();
                }
            };
          
            /**
             * @public
             */
            this.init = function() {
                
                $(ACTIONS).hpDropMenu();
                $('#hpsum-activity-actions').hide();
                this.resume();
            };
            
        }

        return new NodeShowView();
    }());
    
    return NodeShowView;
});
