// iLONodeDetails
// This is a view class prompting user for iLO Administrator credentials
define(['hpsum/presenter/node/NodePresenter',
	'hp/core/Router',
	'hp/core/UrlFragment',
	'hp/core/Localizer',
    'jquery'],
function(presenter, router, urlFragment, localizer) { "use strict";

    var NodeiLOCredentials = (function() { 
    	
    	var OKBUTTON = '#hpsum-node-ilo-ok',
    		CANCELBUTTON = '#hpsum-node-ilo-cancel',
    		USERNAME = '#hpsum-node-ilo-username',
       		PASSWORD = '#hpsum-node-ilo-password';

        /**
         * Constructor
         */
        function NodeiLOCredentials() {
        	
        	var nodeItem = null;
        	var submitInProgress = false;

           
			function onItemChange(item) {
				nodeItem = item.hapi;
				
			}
            
            function validate(){
            	var success = true;
            	if($(USERNAME).val() == ''){
					$(OKBUTTON).attr("disabled", true);
            		success= false;
            	}
            	if($(PASSWORD).val() == ''){
            		$(OKBUTTON).attr("disabled", true);
            		success= false;
            	}
				if( $(USERNAME).val() != '' && $(PASSWORD).val() != '' )
				{
					$(OKBUTTON).attr("disabled", false);
					success = true;
				}
            	return success;
            }
            
			
			function onSubmitSuccess() {
				$(CANCELBUTTON).trigger('click');
			}
			
			function onSubmitError(errorMessage) {
				$(OKBUTTON).attr('disabled','disabled');
				$(CANCELBUTTON).trigger('click');
			}
			
			function onSubmitDetails()
			{
				if(!submitInProgress) {
					if(validate()){
						var iloCredentilas = {
							hapi:{
								ilo_username : $(USERNAME).val(),
								ilo_password : $(PASSWORD).val()		
							}
						  
						};
						
						submitInProgress = true;
						presenter.setattribute(nodeItem, iloCredentilas,
								{
									success: onSubmitSuccess(),
									error : onSubmitError()
								});
						
					}
				}
			}
		
			
			function reset() {
  				$(OKBUTTON).attr("disabled", true);
				$(USERNAME).val("");
				$(PASSWORD).val("");
				submitInProgress = false;
			}
			
			this.resume = function () {
				presenter.on("itemChange", onItemChange);
				reset();
            };
            
            this.pause = function() {
				
            	presenter.off("itemChange", onItemChange);
            	$(USERNAME).text('');
            	$(PASSWORD).text('');
				$(OKBUTTON).attr("disabled", true);
            };
          
            /**
             * @public
             * Initialization funtion for the object
             * All the controls actions are initialized in this function.
             */
            this.init = function() {
            	$(OKBUTTON).attr("disabled", true);
				$(USERNAME).keyup(validate);
				$(PASSWORD).keyup(validate);
				               			
                $(OKBUTTON).on('click', function(){
					onSubmitDetails.call(this);
                  
                });
                
				$(CANCELBUTTON).click(function () {
					var loc = router.location();
                    router.go(urlFragment.replaceView(router.location(), 'show'));
                });
                this.resume();
                					
            };
        }

        return NodeiLOCredentials;
   }());
    
    return new NodeiLOCredentials();
});