define(['hp/core/EventDispatcher',
                                'hp/core/Localizer',
                                'jquery',
                                'hp/lib/jquery.hpStatus',
                                'lib/jquery.dataTables',
                                'hp/lib/jquery.hpCollapsible',
                                'hp/lib/jquery.hpToggle'],
function (EventDispatcher, Localizer) {
    "use strict";
    (function ($) {
        // Create the defaults once
        var pluginName = "hpsumAddiLOTaskDetails",
defaults = {
    nodeItem: null
};


        var SUM_ILO_UPDATE_LIST_TABLE = '#hpsum-iloupdatelist-table-div';
        var iloTasklistArr = '';
        var iloTasklistlength = 0;
        var myobect;
        var STEP_INVENTORY = 0, STEP_REVIEW = 1, STEP_DEPLOY = 2;
        var otu_step = STEP_INVENTORY;

        var plugin;
        var l_data = null;
        var l_el = null;
        var l_nodeItem = null;
        var sortDirection = 'desc', sortColumn = 0;
	var tempID="iLOtaskQ";
	 var currentTableId = '#hpsum-comps-' + tempID + '-table';
		        
        // The actual plugin constructor
        function Plugin(element, options) {
            this.element = element;

            // jQuery has an extend method which merges the contents of two or
            // more objects, storing the result in the first object. The first object
            // is generally empty as we don't want to alter the default options for
            // future instances of the plugin
            this.options = $.extend({}, defaults, options);
            this._defaults = defaults;
            this._name = pluginName;

            this.init();
        }

        Plugin.prototype =
		{
		    init: function () {
				 
				plugin = this;
		        $(this.element).addClass('hpsumAddiLOTaskDetails');
		        if (this.options.command == 'init') {
		            //var plugin = this;
		            this.initialize(this.element, this.options);
		            


		        }
		        else {
		           
		            this.populateComponentsTable(this.element, this.options);
		        }
		    },
		    recalculate: function () {
		        // if(this.options.nodeItem == undefined){
		        // window.console.error("recalculate before init is not allowed");
		        // return;
		        // }
		        this.calculate(this.element, this.options);
		    },
		    calculate: function (el, options) {
		        var plugin = this;
		    },

		    initialize: function (el, options) {
		       // var plugin = this;
		        plugin.populateComponentsTable(el, options.data);
		    },

		    reinitialize: function () {
		        if (this.options.nodeItem == undefined) {
		            window.console.error("reinitialize before init is not allowed");
		            return;
		        }
		        this.initialize(this.element, this.options);
		    },

		        initiInstallSetComponentTable: function (tableid) {

		              var oTab = $(tableid).dataTable({
		                    oLanguage: {
		                        sEmptyTable: Localizer.getString('hpsum.common.installSetNoCompFound'),
		                        sSearch: Localizer.getString('hpsum.common.search')
		                    },
		                    bPaginate: false,
		                    bProcessing: false,
		                    bFilter: false,
		                    bSort: true,
		                    bAutoWidth: false,
		                    bInfo: false,
		                    bRetrieve: false,
		                    bDestroy: true,
		                    aoColumns:
                            [ 
                                 {
                                     mDataProp: 'updatedby', fnRender: function (oObj) {
                                         var updatedByString = "";
                                         for (var idx = 0; idx < oObj.aData.updatedby.length; idx++) {
                                             updatedByString = updatedByString + oObj.aData.updatedby[idx] + ',';
                                         }
                                         return updatedByString.slice(0, -1);
                                     }
                                 },
                                  {
                                      mDataProp: 'name', fnRender: function (oObj) {
                                          return oObj.aData.name;
                                      }
                                  },
                                  {
                                      mDataProp: 'version', fnRender: function (oObj) {
                                          return oObj.aData.version;
                                      }
                                  },
                                  {
                                      mDataProp: 'type', fnRender: function (oObj) {
                                          return oObj.aData.type;
                                      }
                                  },
                                  {
                                      mDataProp: 'file', fnRender: function (oObj) {
                                          return oObj.aData.file;
                                      }
                                  },
                                {
                                    mDataProp: 'state', fnRender: function (oObj) {
                                        return oObj.aData.state;
                                    }
                                },
                                
                                 {
                                     mDataProp: 'activates', fnRender: function (oObj) {
                                         return oObj.aData.activates;
                                     }
                                 }

                            ],
		                    fnCreatedRow: function (nRow, aData, iDataIndex) {
		                        nRow.className += aData.name;
		                    },
		                    fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
		                        return nRow;
		                    },
		                    "fnDrawCallback": function (oSettings) {
		                        if (oSettings.aiDisplay.length == 0) {
		                            return;
		                        }
		                    },
		                    "aaSorting": [[0, 'asc']],
		                    "sDom": 'lfr<"giveHeight"t>ip'
		                });
		            
		            
		           
		    
		    },

		        populateComponentsTable: function (id, args) {
		             
		            
		           var  data=args.data;
		          
		           $(id).empty();
 
		           
		               $(id).append('<table id="hpsum-comps-' + tempID + '-table"><thead><tr style="background-color:lightgrey;"><td><b>' +
                           Localizer.getString('hpsum.common.installSetUpdatedBy') + '</b></td><td><b>' +
                           Localizer.getString('hpsum.common.installSetName') + '</b></td><td><b>' +
                           Localizer.getString('hpsum.common.installSetCompVersion') + '</b></td><td><b>' +
                           Localizer.getString('hpsum.common.installSetCompType') + '</b></td><td><b>' +
                           Localizer.getString('hpsum.common.installSetCompFileName') + '</b></td><td><b>' +
                           Localizer.getString('hpsum.common.installSeCompState') + '</b></td><td><b>' +
                           Localizer.getString('hpsum.common.installSetCompActivates') + '</b></td><td></td><td></td></tr></thead></table>');
		          
		         this.initiInstallSetComponentTable(currentTableId);
		         var componentsTable = $(currentTableId).dataTable();

		        if ($(currentTableId).length) {
		            componentsTable.fnClearTable();
		        }
		      
		        iloTasklistlength = 0;;
		        iloTasklistArr = [];
		      
		      
		        if (data && data.hapi && data.hapi.ilotasks!=undefined && data.hapi.ilotasks.ilotask!=undefined) {
		            iloTasklistlength = data.hapi.ilotasks.ilotask.length;
		        

		        
		     

                       for (var idx = 0; idx < iloTasklistlength; idx++) {

                           var updlist = "";
                           var activateby="";
                           for (var updby = 0; updby < data.hapi.ilotasks.ilotask[idx].updatedby.length; updby++) {
                               if (updby != 0 && updby != data.hapi.ilotasks.ilotask[idx].updatedby.length)
                                   updlist = updlist + ",";
                               updlist = updlist + data.hapi.ilotasks.ilotask[idx].updatedby[updby];
                           }

                           if (updlist.indexOf("Uefi") !== -1)
                               activateby="After reboot";
                           else
                               activateby="Immediately";


                          var item;
                          
		                item = [{
		                    id: data.hapi.ilotasks.ilotask[idx].id,
		                    name: data.hapi.ilotasks.ilotask[idx].name,
		                    state: data.hapi.ilotasks.ilotask[idx].state,
		                    file: data.hapi.ilotasks.ilotask[idx].component_name,
		                    type: data.hapi.ilotasks.ilotask[idx].type,
		                    version: data.hapi.ilotasks.ilotask[idx].version,
		                    activates: activateby,
		                    updatedby:data.hapi.ilotasks.ilotask[idx].updatedby//[updby]
		                }];
		          
		            if ($(currentTableId).length) {
		                componentsTable.fnAddData(item);
		            }

		        }
		    }
                   

		             
		        
		    },

		    destroy: function (el) {
		        $(this.element).removeClass('hpsumAddiLOTaskDetails');
		        $.removeData(this.element, "plugin_" + pluginName);
		    }
		};


        

        // A really lightweight plugin wrapper around the constructor,
        // preventing against multiple instantiations
        $.fn[pluginName] = function (options) {
            var instance;
             
            if (typeof options === 'string') {
                // call method
                var args = Array.prototype.slice.call(arguments, 1);
                this.each(function () {
                    instance = $.data(this, "plugin_" + pluginName);
                    if (!instance) {
                        if (options.match(/destroy/i)) {
                            if (window.console) {
                                window.console.error("cannot call methods on hpsumAddiLOTaskDetails prior to initialization; " +
                                    "attempted to call method '" + options + "'");
                            }
                        }
                        return;
                    }
                    if (!$.isFunction(instance[options]) || options.charAt(0) === "_") {
                        if (window.console) {
                            window.console.error("no such method '" + options + "' for hpsumAddiLOTaskDetails instance");
                        }
                        return;
                    }
                    // apply method
                    instance[options].call(instance, args);
                });
            }
            else {
                return this.each(function () {
                     
                    if (!$.data(this, "plugin_" + pluginName)) {
                        $.data(this, "plugin_" + pluginName, new Plugin(this, options));
                    }
	           else if(options.command.match(/populateComponentsTable/i))
	        	plugin.populateComponentsTable(this,options);

                });
            }
        };
    }(jQuery));
});

