define(['hpsum/presenter/node/NodePresenter',
		'hp/core/EventDispatcher',
		'hp/core/Localizer', 
		'jquery', 
		'hp/lib/jquery.hpDonut',
		'hpsum/view/node/jquery.hpsumInstallables',	
		'hp/lib/jquery.hpToggle',
		'hpsum/view/node/jquery.hpsumSchedule'], 
function(presenter,EventDispatcher, localizer) {"use strict";
	(function($) {
		// Create the defaults once
		var pluginName = "hpsumDeployNode",
		optApplicable = 0,
		recoApplicable = 0,
		critApplicable = 0,
		critInstallNeeded = 0,
		recoInstallNeeded = 0,
		optInstallNeeded = 0,
		unknownApplicable = 0,
		donutCriticalUpdates = 0,
		donutRecoUpdates = 0,
		donutOptUpdates = 0,
		donutNonCateUpdates = 0,
		unknownInstallNeeded = 0,
		totalApplicableComponents = 0,
		gradient = 0,
		complianceColors = "green,orange,red",
		compCriticalityDetails = {},
		compDepTimeDetails = {},
		BLCompReqDiskSpace = {},
		APCompReqDiskSpace = {},
		baselineDetails = [],
		deploymentTime = 0,
		requiredDiskSpace = 0,
		selectedComponents = [],
		easyModeContainer = '',
		nodeName= "",
		nodeType= "",
		nodeItem="",
		rebootDelay = 1,
		rebootDelayChanged = false,
		formStateView = null,
		plugin = null,
		failedDepCount = 0,
		baselineDetailsContainer = '',
		criticalityDetailsContainer = '',
		toggleButtonContainer = '',
		simplyToggle = false,
		mode = 'easy',
		expertModeContainerIds = [],
		nodeAttributes = null,
		isConfigPasswordRequired = false,
		isFIPSEnabled = false,
		downgrade = false,
		rewrite = false,
		software = true,
		firmware = true,
		forcesoftware = false,
		forcefirmware = false,
		nondisruptive = false,
		skipdependency = 'OMITHOST',
		isEasyModeRendered = false,
		encryptionKeyChanged = false,
		cleanuponexit = false,
		cleanupallonexit = false,
		easyModeRebootValue = 0, 
		minEncryptionKeyLength = 7,
		BASELINE_OVERVIEW_SIZE_AP = '#hpsum-baseline-overview-version-size_ap',
		BASELINE_OVERVIEW_SIZE_BL = '#hpsum-baseline-overview-version-size_bl',
        defaults = {
            nodeItem: null
        };

		
		
		// The actual plugin constructor
		function Plugin( element, options ) {
			
			this.element = element;

			// jQuery has an extend method which merges the contents of two or
			// more objects, storing the result in the first object. The first object
			// is generally empty as we don't want to alter the default options for
			// future instances of the plugin
			this.options = $.extend( {}, defaults, options );
			this.dispatcher = new EventDispatcher();
			this._defaults = defaults;
			this._name = pluginName;

			this.init();
		}

		Plugin.prototype = {
			init: function() {
				$(this.element).addClass('hpsumDeployNode');
				if(this.options.command =='init')
				{
					formStateView = this.options.args.formStateView;
					easyModeContainer = 'hpsum-node-deploy-easy-mode';
					baselineDetailsContainer = 'hpsum-node-deploy-baseline-details';
					criticalityDetailsContainer = 'hpsum-node-deploy-criticality-widget';
					toggleButtonContainer = 'hpsum-node-deploy-toggle-button';
					expertModeContainerIds = this.options.args.expertModeContainerIds;
					plugin = this;
					var html = '<div id="hpsum-node-deploy-criticality-widget" style="width:350px;height:450px;float:left;margin-left:20px;"></div>'+
					'<div id="hpsum-node-deploy-baseline-details" style="width:200px;float:left;margin-left:240px;"></div>'+
					'<div id="hpsum-node-deploy-toggle-button"></div>'+
					'<div id="hpsum-node-deploy-easy-mode" style="width:500px; float:left; margin-left:35px;height:300px; margin-top:15px"></div>';
					$("#"+plugin.element.id).html(html);
				}
			},
			destroy: function(el){
					$(this.element).removeClass('hpsumDeployNode');
					$.removeData(this.element, "plugin_" + pluginName);
			},
			
			renderBaselineData : function(item)
			{
				simplyToggle = false;
				formStateView.setMessage({
						 summary: localizer.getString('hpsum.easymode.dataPopulationInProgress'),
						 changing: true,
						status: 'warning'
				});
				var nodeData = item.nodes[0].nodeItem;
				if(nodeData.node_state == 'UAN'){
					plugin.calculateBaselineDetails(item);
				}
				else if(nodeData.node_state == 'REMOTE_STAGING_UAN')
				{	
					nodeItem = item.nodes[0].nodeItem;
					var baselines = item.baselines.baselines.baseline;
					
				for(var baselineCount=0; baselineCount < baselines.length; baselineCount++)
					{
						var baseline = baselines[baselineCount];
						baselineDetails[baselineCount] = {
							'name' : baseline.baseline_name,
							'version' : baseline.baseline_version,
							'size' : baseline.baseline_size
							};
					}
				var comp_info = item.baselines.component_info;
					donutCriticalUpdates = parseInt(comp_info.Critical);
					donutRecoUpdates = parseInt(comp_info.Recommended);
					donutOptUpdates = parseInt(comp_info.Optional);
					donutNonCateUpdates = parseInt(comp_info.Unknown);;
					totalApplicableComponents= donutCriticalUpdates + donutRecoUpdates +
											donutOptUpdates + donutNonCateUpdates;	
				}
					plugin.renderCriticalityDetails(item);
					plugin.renderBaselineDetails();
				formStateView.reset();
			},
			
			calculateBaselineDetails : function (item)
			{
	
				var baselines = item.baselines.baseline;
				optApplicable = 0;
				recoApplicable = 0;
				critApplicable = 0;
				unknownApplicable = 0;
				critInstallNeeded = 0,
				recoInstallNeeded = 0,
				optInstallNeeded = 0,
				unknownInstallNeeded = 0,
				donutCriticalUpdates = 0,
				donutRecoUpdates = 0,
				donutOptUpdates = 0,
				donutNonCateUpdates = 0,
				deploymentTime = 0;
				totalApplicableComponents = 0;
				failedDepCount = 0;
				compCriticalityDetails = {};
				nodeItem = item.nodes[0].nodeItem;
				nodeName = item.nodes[0].nodeItem.name;
				nodeType = item.nodes[0].nodeItem.type; 
				isConfigPasswordRequired = item.nodes[0].nodeItem.is_config_password_required;
				isFIPSEnabled = nodeItem.fips_enabled;
				selectedComponents = [];
				baselineDetails = [],
				BLCompReqDiskSpace = {},
				APCompReqDiskSpace = {};
				for(var baselineCount=0; baselineCount < baselines.length; baselineCount++)
					{
						var baseline = baselines[baselineCount];
						baselineDetails[baselineCount] = {
							'name' : baseline.baseline_name,
							'version' : baseline.baseline_version,
							'size' : baseline.baseline_size
							};
						if(baseline.hasOwnProperty('components') == true)
						{
							var components = baseline.components.component;
							totalApplicableComponents = totalApplicableComponents + components.length;
							for(var componentCount = 0; componentCount < components.length; componentCount++)
							{		
							if(components[componentCount].selected == true && components[componentCount].has_failed_dependencies == true)	
								{
									failedDepCount = failedDepCount + 1;
								}
								compDepTimeDetails[components[componentCount].file_name] = components[componentCount].deployment_time;
								if(components[componentCount].required_disk_space_kb != ""){
									if(baseline.baseline_id.indexOf("BP_ABL") == -1){
										BLCompReqDiskSpace[components[componentCount].file_name] = components[componentCount].required_disk_space_kb;	
									}
									else{
										APCompReqDiskSpace[components[componentCount].file_name] = components[componentCount].required_disk_space_kb;	
									}
								}
								var criticality = components[componentCount].criticality;
								compCriticalityDetails[components[componentCount].file_name] = criticality;
								if(criticality == "Optional")
								{
									optApplicable = optApplicable +1;
									if(components[componentCount].outside_of_compliance_level == true )
									{
											optInstallNeeded = optInstallNeeded + 1;
									}
									if(components[componentCount].selected == true )
									{
											donutOptUpdates = donutOptUpdates + 1;
											selectedComponents.push(components[componentCount].file_name);
									}
								}
								else if(criticality == "Recommended")
								{
									recoApplicable = recoApplicable +1;
									if(components[componentCount].outside_of_compliance_level == true)
									{
											recoInstallNeeded = recoInstallNeeded + 1;
									}
									if(components[componentCount].selected == true )
									{
											donutRecoUpdates = donutRecoUpdates + 1;
											selectedComponents.push(components[componentCount].file_name);
									}
								}
								else if(criticality == "Critical")
								{
									critApplicable = critApplicable+1;
									if(components[componentCount].outside_of_compliance_level == true)
									{
											critInstallNeeded = critInstallNeeded + 1;
									}
									if(components[componentCount].selected == true )
									{
											donutCriticalUpdates = donutCriticalUpdates + 1;
											selectedComponents.push(components[componentCount].file_name);
									}
								}
								else
								{
									unknownApplicable = unknownApplicable+1;
									if(components[componentCount].outside_of_compliance_level == true)
									{
											unknownInstallNeeded = unknownInstallNeeded + 1;
									}
									if(components[componentCount].selected == true ){
											donutNonCateUpdates = donutNonCateUpdates + 1;
											selectedComponents.push(components[componentCount].file_name);
									}
								}
								
								if(components[componentCount].selected == true)
								{
									deploymentTime = deploymentTime + components[componentCount].deployment_time;
								}
							}
						}
					}
				gradient = 0;
				var critValue = 0;
				var recoValue = 0;
				if(critApplicable != 0)
				 {
					 critValue = (critInstallNeeded / critApplicable)*33;
				 }
				  if(recoApplicable != 0)
				 {
					 recoValue = ((recoInstallNeeded+unknownInstallNeeded) / (recoApplicable+unknownApplicable)) * 33;
				 }
				  if(optApplicable != 0)
				 {
				 var optValue = (optInstallNeeded /optApplicable) * 33;
				 }	
				  if (critValue > 1)
				  {
					   gradient = critValue + 66;
				  }
				  else if(recoValue > 1)
				  {
					 gradient = recoValue + 33;
				  }
				  else
				  {
				   gradient = optValue;
				  }
				  //multiplying gradient by 2 as horizontal compliance bar width= 200px
				  gradient = gradient*2;
			},
			
			resetToggle : function()
            {
				 var idPrepender = '';
				 idPrepender = toggleButtonContainer + "_";
				 if($('#'+idPrepender+'hpsum-toggle').attr('checked') == "checked")                         
				 {
				 $('#'+idPrepender+'hpsum-toggle').removeAttr("checked");
				 simplyToggle = true;        
				 $('#'+idPrepender+'hpsum-toggle').trigger('change');
				 }
				 mode = 'easy';
				 $('#'+easyModeContainer).show();
				 plugin.handleExpertModeDisplay('hide');
             },
			 
			 getEasyModeScheduleDateTimeFromSchedulePlugin : function(item)
			 {
				item.dateTime = $('#'+easyModeContainer+'_hpsum-schedule-plugin-easy-mode-test1').hpsumSchedule('getScheduledDateTime');
			 },
			
			/* this method is to set the schedule for easy-mode <needed in case of staged deploy>. Calling the validate method of schedule plugin,
			to enable the error in easy-mode container.*/
			validateScheduleDateTimeFromSchedulePlugin : function(item)
			{
				var result = $('#' + easyModeContainer + '_hpsum-schedule-plugin-easy-mode-test1').hpsumSchedule('validateUserEnteredTime', item.localDateTime, item.scheduleDateTime);
				item.isValid = result;/* this item.isValid will be checked at the caller method */			
			},
			
			renderToggleButton : function(item)
			{
				var nodeState = "" ;
				if(item.hasOwnProperty("nodes")) {
					nodeState = item.nodes[0].nodeItem.node_state;
				}
				var idPrepender = toggleButtonContainer + "_";
				var proceedMessage = localizer.getString('hpsum.common.proceedMessage');
				var  proceed = localizer.getString('hpsum.common.proceed');
				var cancel = localizer.getString('hpsum.common.button.cancel');
				var switchmode = localizer.getString('hpsum.common.switchMode');
				var html = '<div style="width:120px;float:left;margin-left:35px; margin-top:20px;">'+
								'<input id="'+idPrepender+'hpsum-toggle" type="checkbox" style="float:left; width:100px;" />'+
							'</div>'+				 
				 '<div style="width:250px;float:left;margin-left:-35px; margin-top:18px;">'+
					'<label>'+localizer.getString('hpsum.easymode.ToggleButton')+' </label>'+
				 '</div>'+
				 '<div id="'+idPrepender+'easy-expert-mode-switch-dialog" style="display:none; min-width: 300px;">'+
					'<p id="confirmMessage"></p>'+
					'<p>'+switchmode+'</p>'+
					'<br/>' +
					'<br/>' +
					'<div style="text-align:center">'+
					'<button id="'+idPrepender+'easy-expert-mode-switch-dialog-proceed" class="hp-primary" ">'+proceed+'</button>'+
					'<button id="'+idPrepender+'easy-expert-mode-switch-dialog-cancel" class="hp-button" style="margin-left:20px;">'+cancel+'</button>'+
					'</div>'+
				'</div>';
				$('#'+toggleButtonContainer).html(html);	
				$('#'+idPrepender+'hpsum-toggle').hpToggle({checked: '&nbsp;&nbsp;On&nbsp;&nbsp;', unchecked: '&nbsp;&nbsp;Off&nbsp;&nbsp;'});
			
			},
			setToggleButtonState : function (args) {
				var state =  args.state;
				var idPrepender = toggleButtonContainer + "_";
				$('#'+idPrepender+'hpsum-toggle').off('change', plugin.hideeasymode);
				if(state == 'disabled')
				{		
					$('#'+idPrepender+'hpsum-toggle').attr("disabled", "disabled");
					$('#'+idPrepender+'hpsum-toggle').hpToggle('disable');
				}else {
					$('#'+idPrepender+'hpsum-toggle').removeAttr("disabled");
					$('#'+idPrepender+'hpsum-toggle').hpToggle('enable');
					$('#'+idPrepender+'hpsum-toggle').on('change', plugin.hideeasymode);
					
				}
				if(state == 'disabled')
				{		
					$('#'+idPrepender+'hpsum-toggleText').addClass("hp-unset");
					$('#'+idPrepender+'hpsum-toggle-hpToggle').parent().attr('tooltip', localizer.getString('hpsum.easymode.notApplicableForStaging')).hpTooltip();
					$('#'+idPrepender+'hpsum-toggle-hpToggle li.hp-off').addClass("hp-unset");
					$('#'+idPrepender+'hpsum-toggle-hpToggle li.hp-off').css("color","#737373");
				}
				else {
					$('#'+idPrepender+'hpsum-toggleText').removeClass("hp-unset");
					$('#'+idPrepender+'hpsum-toggle-hpToggle').parent().removeAttr('tooltip');
					$('#'+idPrepender+'hpsum-toggle-hpToggle').parent().removeClass("hp-tooltipped");
					$('#'+idPrepender+'hpsum-toggle-hpToggle').parent().removeAttr('data-tooltip');
					$('#'+idPrepender+'hpsum-toggle-hpToggle li.hp-off').removeClass("hp-unset");
				}
				
				if(state == 'enable')
				{
					$('#'+idPrepender+'hpsum-toggle').hpToggle('enable');
				}
			},
			
			toggleToAdvanceModeWithoutConfirmation : function () {
				var idPrepender = toggleButtonContainer + "_";
				simplyToggle = true;
				if($('#'+idPrepender+'hpsum-toggle').attr('checked') != "checked") 
				{					
					$('#'+idPrepender+'hpsum-toggle').attr("checked","checked");
					$('#'+idPrepender+'hpsum-toggle').trigger('change');
					plugin.ChangeMode(true);
					$('#'+idPrepender+'hpsum-toggle').attr("disabled", "disabled");
					$('#'+idPrepender+'hpsum-toggle').hpToggle('disable');
					
					$("#schedule").hpsumSchedule('selectScheduled');
				}
				
			},
			
			
			hideeasymode : function() 
			{
				if(simplyToggle == false)
				{
					var hasAnythingChanged = false;
					if( easyModeRebootValue != 0 || rewrite || downgrade || nondisruptive || (firmware != software) || forcefirmware || forcesoftware || (skipdependency != 'OMITHOST') || encryptionKeyChanged || cleanuponexit || cleanupallonexit) //from easy to expert mode
					{
						hasAnythingChanged = true;
					}
					else if(plugin.options.getNoChangeFlag()) // IN EXPERT MODE, Check for modification.
					{
						hasAnythingChanged = true;
					}
					
					if(!hasAnythingChanged)
					{						
						plugin.ToggleModeWithReset();
					}
					else
					{						
						plugin.showswitchresetdialog();						
					}
				}
				else
				{
					simplyToggle = false;
				}
			},
			
			handleExpertModeDisplay : function(action)
			{
				for(var containerIdIndex =0;containerIdIndex < expertModeContainerIds.length;containerIdIndex++)
				{
					var containerId = expertModeContainerIds[containerIdIndex];
					if(action == 'hide')
					{
						$("#"+containerId).hide();
					}
					else if(action == 'show')
					{
						$("#"+containerId).show();
					}
				}
			},
			
			ToggleModeWithReset : function()
			{
				if(plugin.options.hasOwnProperty("setCurrentAction"))
				{
					var changemode = 'changemode';
					plugin.options.setCurrentAction(changemode);
				}
				plugin.reset();
				if(plugin.options.hasOwnProperty("repopulateInstallSet"))
				{
					//repopulateInstallSet the installable again to reset the selection-deselection
					plugin.options.repopulateInstallSet();				
				}
				
				if(plugin.options.hasOwnProperty("resetAssociatedNodes"))
				{
					//resetAssociatedNodes  reset selected associated nodes to reset the associated nodes selection. 
					plugin.options.resetAssociatedNodes();			
				}
			},
			
			showswitchresetdialog : function() {
					var idPrepender = toggleButtonContainer + "_";
					var navDialog = null;
					if (! navDialog) {
                        navDialog = $('#'+idPrepender+'easy-expert-mode-switch-dialog');
                        navDialog.dialog({
                            autoOpen: false,
                            draggable: false,
                            modal: true,
                            resizable: false,
                            dialogClass: 'hp-simple-dialog'
                            });          
                        $('#'+idPrepender+'easy-expert-mode-switch-dialog-proceed', navDialog).on('click', function (ev) {
							plugin.ToggleModeWithReset();
                            
							$('#'+idPrepender+'easy-expert-mode-switch-dialog-proceed', navDialog).off('click');
							$('#'+idPrepender+'easy-expert-mode-switch-dialog-cancel', navDialog).off('click');
							navDialog.dialog('close');        
                        });
						
                        $('#'+idPrepender+'easy-expert-mode-switch-dialog-cancel', navDialog).on('click', function (ev) {
							  if($('#'+idPrepender+'hpsum-toggle').attr('checked') == "checked")					
								  $('#'+idPrepender+'hpsum-toggle').removeAttr("checked");
							   else if($('#'+idPrepender+'hpsum-toggle').attr('checked') != "checked")
								  $('#'+idPrepender+'hpsum-toggle').attr("checked","checked");
								 simplyToggle = true;
								 $('#'+idPrepender+'easy-expert-mode-switch-dialog-proceed', navDialog).off('click');
								 $('#'+idPrepender+'easy-expert-mode-switch-dialog-cancel', navDialog).off('click');
							$('#'+idPrepender+'hpsum-toggle').trigger('change');
							navDialog.dialog('close');
						});
					}
					var modeName = '';
					if(mode == 'easy')
						modeName = 'Easy';
					else
						modeName = 'Advanced';
					$("#confirmMessage").text(localizer.getString('hpsum.easymode.confirmMessage',[modeName]));
                    navDialog.dialog('open');	
			},
			
			ChangeMode : function(toggleToAdv) {
				var idPrepender = toggleButtonContainer + "_";
				if($('#'+idPrepender+'hpsum-toggle').attr('checked') === "checked" || toggleToAdv == true){
								mode = 'expert';
								/*
								*Note:Please do not move this line of code and make it common for easy and expert mode. 
								*even if they seems code duplication, this is done for purpose of avoiding unwanted rendering of easy mode on pause-resume.As we are setting mode here, this is used from nodeDeploy page to check for mode and then render the easy mode contents.
								*/
								if(plugin.options.hasOwnProperty("setCurrentModeValue"))
								{
									plugin.options.setCurrentModeValue(mode);
								}
								$('#'+easyModeContainer).hide();
								plugin.handleExpertModeDisplay('show');
								plugin.options.updateExpertModefields();	
							}
							else {
								mode = 'easy';
								if(plugin.options.hasOwnProperty("setCurrentModeValue"))
								{
									plugin.options.setCurrentModeValue(mode);
								}
								$('#'+easyModeContainer).show();
								plugin.handleErrorConditions();
								plugin.handleExpertModeDisplay('hide');
								rebootDelayChanged = true;
								plugin.updateRebootDelay();						
							}
			},
			renderBaselineDetails : function()
			{
				var idPrepender = '';
						
						idPrepender = baselineDetailsContainer + "_";
						var html = '<div style="border: 2px solid #cccccc;width:400px;height: 180px;float:right;padding-top:5px;"><li id="'+idPrepender+'hpsum-baseline-overview" class="hp-stacked-panel">'+
						'<li style="padding-top:10px;padding-left:20px;">'+
									'<label id="hpsum-baseline-overview" style="width:330px;margin-top:5px;text-align:left;padding-left:5px;font-weight:bold;" rel="localize[hpsum-baseline-overview]" >'+localizer.getString('hpsum.easymode.EstimatedDeploymentTime')+' </label><label id="'+idPrepender+'estimated_time"></label>';
								if(baselineDetails.length == 1)
								{
								html = html + '<br/><br/></li>';
								}
								else
								html = html + '<br/></li>';
							
							for(var baselineCount=0; baselineCount < baselineDetails.length; baselineCount++)
							{ 
								html = html + 
								'<li style="padding-top:10px;padding-left:20px;">' +
									'<label for="hpsum-baseline-overview-name" style="width:250px;text-align:left;padding-left:5px;font-weight:bold;" >'+baselineDetails[baselineCount].name+'</label>'+
									'</li>' +
								'<li style="padding-top:10px;padding-left:20px;">' +
									'<label for="hpsum-baseline-total-size" style="text-align:left;padding-left:5px;">'+ localizer.getString('hpsum.easymode.totalSize') +  baselineDetails[baselineCount].size + '</label>' + 
									'</li>' +
								'<li style="padding-top:10px;padding-left:20px;">';
								
								if(baselineDetails[baselineCount].name == "Additional Package"){
									html = html + '<label id="hpsum-baseline-overview-version-size_ap"';
								}
								else{
									html = html + '<label id="hpsum-baseline-overview-version-size_bl"';
								}
								html = html+ 'style="text-align:left;padding-left:5px;"'+
																'rel="localize[hpsum-baseline-overview-version-size]"></label></li>';
									
							}
							
							html = html +'</li></div>'					
						$('#'+baselineDetailsContainer).html(html);	
						this.renderDeploymentTime(deploymentTime);
			},
			
			renderCriticalityDetails : function(item)
			{
					var nodeState = "" ;
					if(item && item.hasOwnProperty("nodes")) {
						nodeState = item.nodes[0].nodeItem.node_state;
						nodeType = item.nodes[0].nodeItem.type;
						nodeName = item.nodes[0].nodeItem.name;
					}
					var idPrepender = '';
					var titlemsg='';
					idPrepender = criticalityDetailsContainer  + "_";
					if(nodeState == 'REMOTE_STAGING_UAN')
						titlemsg = localizer.getString('hpsum.easymode.componentsSelectedForStaging') ;
					else {
						titlemsg = localizer.getString('hpsum.easymode.componentsSelectedForUpdate') ;
					}
					var totalcomponents = donutCriticalUpdates + donutRecoUpdates + donutOptUpdates + donutNonCateUpdates;
					var html = '<div style="width:350px;height:530px;border: 2px solid #cccccc;">'+
					'<div style=margin-left:50px;font-weight:bold;font-size:100%;margin-top:15px;">' +
						'<label> '+totalcomponents+ " "+ titlemsg + '</label>' +
					'</div>'+
					'<div id="'+idPrepender+'node-deploy-donut" style="width:150px;height:100px;margin-left:100px;margin-top:15px;float:left"></div>'+
					'<div id="'+idPrepender+'node-deploy-collapsible-details" style="margin-left:50px;margin-top:150px;height:130px;padding-top:15px;">'+
					'<div id="'+idPrepender+'node-deploy-collapsible">'+
						'<label>'+localizer.getString('hpsum.easymode.nodeType')+'</label>'+
						'<label style="font-weight:bold;font-size:115%;">'+nodeType+'</label>'+
						'<br></br>' +
						'<label>'+localizer.getString('hpsum.easymode.nodeIPDNS')+'</label>'+
						'<label style="font-weight:bold;font-size:115%;">'+nodeName+'</label>'+
						'<div style="margin-left:50px;">' + 
							'<ol>'+
							'<li style="margin-top: 20px;"><div style="width:13px;height:13px;background:red;float:left;margin-right: 7px;"></div>'+localizer.getString('hpsum.easymode.CriticalUpdates')+' '+donutCriticalUpdates+'</li>'+
							'<li style="margin-top: 20px;"><div style="width:13px;height:13px;background:orange;float:left;margin-right: 7px;"></div>'+localizer.getString('hpsum.easymode.RecommendedUpdates')+' '+donutRecoUpdates+'</li>'+
							'<li style="margin-top: 20px;"><div style="width:13px;height:13px;background:green;float:left;margin-right: 7px;"></div>'+localizer.getString('hpsum.easymode.OptionalUpdates')+' '+donutOptUpdates+'</li>'+
							'<li style="margin-top: 20px;"><div style="width:13px;height:13px;background:skyblue;float:left;margin-right: 7px;"></div>'+localizer.getString('hpsum.easymode.NonCategorized')+' '+donutNonCateUpdates+'</li>'+
							'</ol>'+
						'</div>'+ 
					'</div>'+
					'</div>';
					var compliancehtml ="";
					if(nodeState == 'REMOTE_STAGING_UAN')
					{	
						compliancehtml = '<div id="'+idPrepender+'details" style="width:auto;margin-top:100px;">'+
						'<div style="margin-left:5px;margin-top:-10px;">'+
						'<div style=margin-left:10px;font-weight:bold;font-size:100%;margin-top:20px;">' +
						'<label class="hp-unset">'+localizer.getString('hpsum.easymode.ComplianceLevel')+'</label>'+
						'</div>' +
							'<div class="hp-unset" style="float:left;margin-left:25px;margin-top:75px;position:relative;">'+localizer.getString('hpsum.easymode.Compliant')+ '</div>' + 
							'<div class="hp-unset" style="float:right;margin-right:25px;margin-top:75px;position:relative;">'+localizer.getString('hpsum.easymode.NonCompliant')+'</div>'+
							'<div class="gradient" style="border: 2px solid #aaaaaa;height: 30px;width:200px;margin-left:60px;margin-top:30px;'+
							'background-color: lightgrey;"></div></div>'+
						'</div></div>';
					
					}
					else {
						compliancehtml = '<div id="'+idPrepender+'details" style="width:auto;margin-top:100px;">'+
						'<div style="margin-left:5px;margin-top:-10px;">'+
						'<div style=margin-left:10px;font-weight:bold;font-size:100%;margin-top:20px;">' +
						'<label>'+localizer.getString('hpsum.easymode.ComplianceLevel')+'</label>'+
						'</div>' +
							'<div style="float:left;margin-left:25px;margin-top:75px;position:relative;">'+localizer.getString('hpsum.easymode.Compliant')+'</div><div class="gradient" style="border: 2px solid #aaaaaa;height: 30px;width:200px;margin-left:60px;margin-top:30px;'+
							'background-color: green;'+
							'background-image:linear-gradient(to right ,'+ complianceColors +');">'+
							'</div>'+
							'<div id ="'+idPrepender+'horizontal-bar" style="width:3px;height:30px;background-color:brown;left:60px;position:relative;top:-32px;"></div>'+
							'<div id ="'+idPrepender+'upper-triangle" style="width:0;height:0;border-left:4px solid transparent;border-right:4px solid transparent;border-top: 6px solid black;position:relative;top:-69px;left:58px;"></div>'+
							
							'<div id ="'+idPrepender+'lower-triangle" style="width:0;height:0;border-left:4px solid transparent;border-right:4px solid transparent;border-bottom: 6px solid black;position:relative;top:-36px;left:58px;"></div>'+
							'<div style="position:relative;top:-31px;left:225px;">'+localizer.getString('hpsum.easymode.NonCompliant')+'</div></div>'+
						'</div>'+
						'</div>';
					}
					html += compliancehtml;
					$('#'+criticalityDetailsContainer).html(html);
					var left = 60;
					 $('#'+idPrepender+'horizontal-bar').css("left",left+gradient+2+"px");
					 $('#'+idPrepender+'upper-triangle').css("left",left+gradient+"px");
					 $('#'+idPrepender+'lower-triangle').css("left",left+gradient+"px");
					 
					 if(donutCriticalUpdates ==0 && donutRecoUpdates ==0 && donutOptUpdates ==0 && donutNonCateUpdates ==0)
					 {
								 $.hpDonut($('#'+idPrepender+'node-deploy-donut'), [
											{label: {value: 0, text: localizer.getString('hpsum.easymode.noUpdatesRequired')}, data: 100, color: "grey"}
											]);
					 }
					 
					 else
					 {
					 $.hpDonut($('#'+idPrepender+'node-deploy-donut'), [
                     {label: {value: donutCriticalUpdates, text: ""}, data: (donutCriticalUpdates/totalApplicableComponents)*100, color: "red"},
                     {label: {value: donutRecoUpdates, text: ""}, data: (donutRecoUpdates/totalApplicableComponents)*100, color: "orange"},
					 {label: {value: donutOptUpdates, text: ""}, data: (donutOptUpdates/totalApplicableComponents)*100, color: "green"},
					 {label: {value: donutNonCateUpdates, text: ""}, data: (donutNonCateUpdates/totalApplicableComponents)*100, color: "skyblue"}
                 ]);
				 }
				 if(nodeState == 'REMOTE_STAGING_UAN')
					{
						$('#'+idPrepender+'details').attr('tooltip', localizer.getString('hpsum.easymode.notApplicableForStaging')).hpTooltip();
						$('#'+idPrepender+'node-deploy-donut').attr('tooltip', localizer.getString('hpsum.easymode.StagingDonutHelp')).hpTooltip();
						$('#hpsum-node-deploy-stage-schdule').show();
					}
					else {
						$('#'+idPrepender+'details').attr('tooltip', localizer.getString('hpsum.easymode.ComplianceHelp')).hpTooltip();
						$('#'+idPrepender+'node-deploy-donut').attr('tooltip', localizer.getString('hpsum.easymode.DonutHelp')).hpTooltip();
						$('#hpsum-node-deploy-stage-schdule').hide();
					}
				 
			},
			
			onSelectionChange : function(item)
			{
				selectedComponents = item.selectedComponents.component;
				donutCriticalUpdates = 0;
				donutRecoUpdates = 0;
				donutOptUpdates = 0;
				donutNonCateUpdates = 0;
				var criticality = '';
				
				for (var selComps = 0; selComps < selectedComponents.length; selComps++)
				{
					criticality = compCriticalityDetails[selectedComponents[selComps]];

					if(compCriticalityDetails[selectedComponents[selComps]] == "Optional")
					{
						donutOptUpdates = donutOptUpdates +1;
					}
					else if(compCriticalityDetails[selectedComponents[selComps]] == "Recommended")
					{
						donutRecoUpdates = donutRecoUpdates +1;
					}
					else if(compCriticalityDetails[selectedComponents[selComps]] == "Critical")
					{
						donutCriticalUpdates = donutCriticalUpdates +1;
					}
					else
					{
						donutNonCateUpdates = donutNonCateUpdates+1;
					}
				}
				failedDepCount = item.selectedComponents.failed_dependency;
				plugin.updateDeploymentTime();
				plugin.updateRequiredDiskSpace();
				if(mode == 'easy')
				{
					plugin.handleErrorConditions();
				}
			},
			
			/*
			function to update deployment time on selection change of components.
			*/
			updateDeploymentTime: function()
			{
				deploymentTime = 0;
				for (var selComps = 0; selComps < selectedComponents.length; selComps++)
				{
					deploymentTime = deploymentTime + compDepTimeDetails[selectedComponents[selComps]];
				}
				this.renderDeploymentTime(deploymentTime);
			},
			
			/*
			function to update required disk space on selection change of components.
			*/
			updateRequiredDiskSpace: function()
			{
				var BLRequiredDiskSpaceKb = 0;
				var APRequiredDiskSpaceKb = 0;
				var BLSelectedCompsCount = 0;
				var APSelectedCompsCount = 0;
				for (var selComps = 0; selComps < selectedComponents.length; selComps++)
				{
					if(BLCompReqDiskSpace.hasOwnProperty(selectedComponents[selComps]))
					{
						BLRequiredDiskSpaceKb = BLRequiredDiskSpaceKb + parseFloat(BLCompReqDiskSpace[selectedComponents[selComps]]);
						BLSelectedCompsCount++;
					}
					else if(APCompReqDiskSpace.hasOwnProperty(selectedComponents[selComps]))
					{
						APRequiredDiskSpaceKb = APRequiredDiskSpaceKb + parseFloat(APCompReqDiskSpace[selectedComponents[selComps]]);
						APSelectedCompsCount++;
					}
				}				
				for(var baselineCount=0; baselineCount < baselineDetails.length; baselineCount++){
					
					if(baselineDetails[baselineCount].name =="Additional Package"){
						this.renderRequiredDiskSpace(APSelectedCompsCount, APRequiredDiskSpaceKb, BASELINE_OVERVIEW_SIZE_AP);
					}
					else{
						this.renderRequiredDiskSpace(BLSelectedCompsCount, BLRequiredDiskSpaceKb, BASELINE_OVERVIEW_SIZE_BL);
					}
				}			
			},
			
			/*
			function to convert the deployment time to the expected format and set the value on UI.
			*/
			renderDeploymentTime: function(deploymentTime)
			{	
				var idPrepender = '';		
				idPrepender = baselineDetailsContainer + "_";
				if(nodeItem.node_state == 'REMOTE_STAGING_UAN'){
					$('#'+idPrepender+'estimated_time').html(' n/a');
					$('#'+idPrepender+'estimated_time').addClass("hp-unset");
					$('#hpsum-baseline-overview').addClass("hp-unset");
				}
				else {
					var date = new Date(null);
					date.setHours(0);
					date.setMinutes(0);
					date.setSeconds(deploymentTime); // specify value for SECONDS here
					var timeToString = date.toTimeString().substr(0, 8);
					var splitTime = timeToString.split(':');
					var count = 0;
					var timeUnit = [localizer.getString('hpsum.easymode.hours') ,localizer.getString('hpsum.easymode.minutes') ,localizer.getString('hpsum.easymode.seconds')];
					var time = "";
					for(var splitCount = 0;splitCount < splitTime.length; splitCount++)
					{
						if(splitTime[splitCount] != '00')
						{
							time = time + splitTime[splitCount]+ " " + timeUnit[splitCount] + " ";
							if(count ==1)
								break;
							count++;
						}							
					}
					if(time == "")
					{
						time = "0 Minute";
					}
					$('#'+idPrepender+'estimated_time').html(time);
				}
			},
			
			
		renderRequiredDiskSpace: function(selectedCompsCount, requiredDiskSpace, elemId)
			{			
				var size = "",bldetails = "";
				var sizeType = ["KB" ,"MB" , "GB"];
				var decimalIndex = -1,index = 0;
								
				while(requiredDiskSpace > 1024)
				{
					requiredDiskSpace = requiredDiskSpace/1024;
					index ++;
				}
				size =  requiredDiskSpace.toString();
				decimalIndex = size.indexOf('.');
				if(decimalIndex > 0){
					size = size.substr(0, decimalIndex+3);
				}
				size =  size + " " + sizeType[index];
				bldetails = localizer.getString('hpsum.easymode.selectedComponents') + selectedCompsCount + ', ' + localizer.getString('hpsum.easymode.size') + size;
				$(elemId).html(bldetails);					
			},
			
			
			
			/*
			function to show/hide conditional sections on easy mode based on the node type.
			*/
			displayEasyModeContents: function(item)
			{
				if(item.hasOwnProperty('nodeType'))
					nodeType = item.nodeType;
				else
					nodeType = item;
				if(nodeType != null)
				{
					if(nodeType.match(/Windows|Linux|hpux|vmware/i))
					{
						 $('#'+easyModeContainer+'_disruptive-and-nondisruptive').show();
						 $('#'+easyModeContainer+'_skip-failed-dep-components').css('margin-top','0px');
					}
					else
					{
						$('#'+easyModeContainer+'_disruptive-and-nondisruptive').hide();
						$('#'+easyModeContainer+'_skip-failed-dep-components').css('margin-top','20px');
						
					}
					if(nodeType.match(/virtual_connect/i))
					{
						//REVISIT Enable this check later, to handle FIPS MODE Checks.
						if(isConfigPasswordRequired) {
							$('#'+easyModeContainer+'_hpsum-node-deploy-vc-encryption-easy-mode').show();
						 }
					}
					else
					{
						$('#'+easyModeContainer+'_hpsum-node-deploy-vc-encryption-easy-mode').hide();
					}
				
					if(nodeType.match(/integrityilo/i))
					{
						$('#'+easyModeContainer+'_hpsum-reboot-to-activate-options-easy-mode').show();
						
					}
					else 
					{
						$('#'+easyModeContainer+'_hpsum-reboot-to-activate-options-easy-mode').hide();
					}
					
					if(nodeType == "switch")
					{
						$('#'+easyModeContainer+'_hpsum-node-easymode-downgrade').prop('disabled',"disabled");
						$('#'+easyModeContainer+'_label-easymode-downgrade').css("color","#aaaaaa");
						$('#'+easyModeContainer+'_hpsum-node-easymode-swicthwarning').show();					
					} else if (nodeType.match(/OA/i) && isFIPSEnabled)
					{
						$('#'+easyModeContainer+'_hpsum-node-easymode-downgrade').prop('disabled',"disabled");
						$('#'+easyModeContainer+'_label-easymode-downgrade').css("color","#aaaaaa");
						
						$('#'+easyModeContainer+'_hpsum-node-easymode-rewrite').prop('disabled',"disabled");
						$('#'+easyModeContainer+'_label-easymode-rewrite').css("color","#aaaaaa");
						
						$('#'+easyModeContainer+'_hpsum-node-easymode-oafipswarning').show();					
					}
					else
					{
						$('#'+easyModeContainer+'_hpsum-node-easymode-downgrade').prop('disabled',"");
						$('#'+easyModeContainer+'_label-easymode-downgrade').css("color","");
						
						$('#'+easyModeContainer+'_hpsum-node-easymode-rewrite').prop('disabled',"");
						$('#'+easyModeContainer+'_label-easymode-rewrite').css("color","");
						
						$('#'+easyModeContainer+'_hpsum-node-easymode-swicthwarning').hide();
						$('#'+easyModeContainer+'_hpsum-node-easymode-oafipswarning').hide();
					}
					
					// Show verbose logging in easy mode only in case of windows node for Staged deploy
					if (!(nodeType.match(/Windows/i)))
					{
						$('#'+easyModeContainer+'_verbose_logging').hide();
					}
					else
					{
						if (nodeItem.node_state.match(/^UAN$/i))
						{
							$('#'+easyModeContainer+'_verbose_logging').hide();
						}
						else
						{
							$('#'+easyModeContainer+'_verbose_logging').show();
						}
					}
				}
			},
			
			/*
			function to render easy mode.
			*/
			addEasyMode: function(item) 
			{
				var idPrepender = easyModeContainer + "_";	
				mode = 'easy';
				var html ='<div>'+
						 '<div id="'+idPrepender+'easy-mode-installation-options">'+
						 '<li id="'+idPrepender+'hpsum-baseline-overview" class="hp-stacked-panel">'+
							 '<li style="margin-top:30px;font-weight:bold;font-size:110%;"> <label for="'+idPrepender+'hpsum-baseline-overview" ">'+localizer.getString('hpsum.easymode.InstallationOptions')+'</label>' + '</li>' +
								 '<li style="width:430px;">' +
									 '<input id="'+idPrepender+'hpsum-node-easymode-downgrade" type="checkbox" style="width:20px;margin-top:20px;"/>'+
									 '<label for = "'+idPrepender+'hpsum-node-easymode-downgrade" id="'+idPrepender+'label-easymode-downgrade">'+localizer.getString('hpsum.easymode.EnableDowngrade')+'</label>'+
									 '<input id="'+idPrepender+'hpsum-node-easymode-rewrite" type="checkbox" style="width:20px;"/>'+
									 '<label for = "'+idPrepender+'hpsum-node-easymode-rewrite" id="'+idPrepender+'label-easymode-rewrite">'+localizer.getString('hpsum.easymode.EnableRewrite')+'</label>'+
									 '<div style="box-sizing: border-box; padding: 10px;background-color: #fffdd7;color: black;white-space: normal;display:none;" id="'+idPrepender+'hpsum-node-easymode-vmwarewarning"> ' +
										'<label for = "'+idPrepender+'hpsum-node-easymode-vmwarewarning">'+localizer.getString('hpsum.easymode.VMwareWarning')+'</label>' +
                                     '</div>' +
									 '<div style="box-sizing: border-box; padding: 10px;background-color: #fffdd7;color: black;white-space: normal;display:none;" id="'+idPrepender+'hpsum-node-easymode-swicthwarning"> ' +
										'<label for = "'+idPrepender+'hpsum-node-easymode-swicthwarning">'+localizer.getString('hpsum.easymode.SwitchWarning')+'</label>' +
                                     '</div>' +
						             '<div style="box-sizing: border-box; padding: 10px;background-color: #fffdd7;color: black;white-space: normal;display:none;" id="'+idPrepender+'hpsum-node-easymode-oafipswarning"> ' +
										'<label for = "'+idPrepender+'hpsum-node-easymode-oafipswarning">'+localizer.getString('hpsum.node.OAFIPSForceWarning')+'</label>' +
                                     '</div>' +
								 '</li>' +
								 '</div>'+
								 '<li id="'+idPrepender+'skip-failed-dep-components" class="hp-stacked-panel">'+
								 		'<input id="'+idPrepender+'hpsum-node-easymode-skipdependency" type="checkbox" style="width:20px;" />'+
										'<label for = "'+idPrepender+'hpsum-node-easymode-skipdependency" id="'+idPrepender+'label-skip-failed-dep-components" style="padding-left:2px;">'+localizer.getString('hpsum.easymode.SkipDependencies')+'</label>'+
								 '</li>' +
								 '<li id="'+idPrepender+'cleanup-onexit-after-deploy" class="hp-stacked-panel">'+
								 		'<input id="'+idPrepender+'hpsum-node-easymode-cleanuponexit" type="checkbox" style="width:20px;" />'+
										'<label for = "'+idPrepender+'hpsum-node-easymode-cleanuponexit" id="'+idPrepender+'label-cleanup-onexit-after-deploy" style="padding-left:2px;">'+localizer.getString('hpsum.easymode.cleanuponexit')+'</label>'+
								 '</li>' +
								 '<li id="'+idPrepender+'cleanupall-onexit-after-deploy" class="hp-stacked-panel">'+
								 		'<input id="'+idPrepender+'hpsum-node-easymode-cleanupallonexit" type="checkbox" style="width:20px;" />'+
										'<label for = "'+idPrepender+'hpsum-node-easymode-cleanupallonexit" id="'+idPrepender+'label-cleanupall-onexit-after-deploy" style="padding-left:2px;">'+localizer.getString('hpsum.easymode.cleanupallonexit')+'</label>'+
								 '</li>' +
								 '<li id="'+idPrepender+'verbose_logging" class="hp-stacked-panel">' + '<input id="easy-hpsum-comp-verbose-checkbox" type="checkbox" style="width:20px;"/>'+
                                                                '<label id="easy-hpsum-comp-verbose-descr" style="padding-left:2px;">' +localizer.getString('hpsum.node.compVerboseLog') + '</label>'+
									'</li>' +
								 '<ol id="'+idPrepender+'disruptive-and-nondisruptive" style="display:none">' +
									 '<li style="width:400px; margin-top:30px; margin-left:6px">' +
										'<input id="'+idPrepender+'hpsum-node-easymode-disruptive" type="radio" name="easy-mode" checked="checked"  style="display:none;"/>'+
										 '<label for = "'+idPrepender+'hpsum-node-easymode-disruptive">'+localizer.getString('hpsum.easymode.DeployDisruptive')+'</label>'+
									 '</li>' +
								
									 '<li style="width:385px;margin-top:5px; margin-left:35px;">' +
										'<id="'+idPrepender+'hpsum-node-easymode-selectwhentoreboot"/>'+
										'<label for = "'+idPrepender+'hpsum-node-easymode-selectwhentoreboot">'+localizer.getString('hpsum.easymode.SelectWhenToReboot')+'</label>'+
									 '</li>' +
										
									 '<li id="'+idPrepender+'slider-container" style="margin-left:24px;width:400px;height:70px;margin-top:-15px;">' +
										'<div style="width:20px;margin-top:30px;margin-left:10px;">' +
										'</br>'+
										'<label id = "'+idPrepender+'hpsum-node-easymode-neverreboot" style="margin-top:10px;">'+localizer.getString('hpsum.easymode.NeverReboot')+'</label>'+
										'</div>' +
										'<div id="'+idPrepender+'slider" style="width:250px;margin-left:60px;margin-top:-25px;"/><div id="value" style="margin-left:170px;margin-top:3px;"></div>'+
										'<div style="margin-left:185px;margin-top:-15px;display:none;" id="reboot-sufix">mins</div>' +
										'<div style="margin-left:320px;margin-top:-30px;" >' +
										'<label id = "'+idPrepender+'hpsum-node-easymode-Mins60">'+localizer.getString('hpsum.easymode.Mins60')+'</label>'+
										'</div>' +
									 '</li>' +
									 
									
									 '<li id="hpsum-getrid-of-me" style="width:400px;margin-top:20px; display:none;">' +
										 '<input id="'+idPrepender+'hpsum-node-easymode-nondisruptive" type="radio" name="easy-mode"/>'+
										 '<label for = "'+idPrepender+'hpsum-node-easymode-nondisruptive">'+localizer.getString('hpsum.easymode.DeployNonRebootOnly')+'</label>'+
									 '</li>' +
								 '</ol>' +
									'<div id="'+idPrepender+'hpsum-node-deploy-vc-encryption-easy-mode" style="margin-top:25px;display:none;float:left;">' +
                                        '<label for="'+idPrepender+'hpsum-node-deploy-vc-encryption-easy-mode" style="font-size:100%; font-weight:bold;">'+localizer.getString('hpsum.easymode.VCFIPSEncryption')+'</label>'+
											'<br></br>' +
											'<label>'+localizer.getString('hpsum.easymode.VCFIPSEncryptionKey')+' </label>'+
											'<input id="' + idPrepender + 'hpsum-node-vc-encryption-key" style="margin-left:25px;" type="password" maxlength="255" autocomplete="off" />' +
											'<br></br>' +
											'<div style="max-height: 70px;" class="hp-message-container">'+
												'<label style="max-height: 70px; word-wrap: break-word; white-space: normal; display: block;" class="hp-error">'+localizer.getString('hpsum.easymode.VCFIPSKeyHelp')+'</label>'+
											'</div>'+
										
									'</div>' +
									
									'<div id="'+idPrepender+'hpsum-reboot-to-activate-options-easy-mode" style="margin-top:25px;display:none;">' +
										'<label for="'+idPrepender+'hpsum-reboot-to-activate-options-easy-mode" style="font-size:100%; font-weight:bold;">Reboot Options</label>' +
										'<ol style="margin-top:20px;" >' +
											'<li>' +
												'<label for="'+idPrepender+'hpsum-activate-selection_easy_mode">'+localizer.getString('hpsum.easymode.RebootActivateFirmware')+'</label>' +
												'<select id="'+idPrepender+'hpsum-activate-selection_easy_mode" style="margin-left:25px; class="hp-selsect require-analysis">' +
												'<option value = "NO">No</option>' +
												'<option value = "YES">Yes</option>' +
												'</select>' +
											'</li>'	+	
										'</ol>' +
									'</div>' +

									'<div id="'+idPrepender+'hpsum-schedule-starttime-label" style="padding-left: 15px;margin-top:5px;display:none;">' + 
									'<ol>' +
										'<label id="'+idPrepender+'for="'+idPrepender+'hpsum-schedule-starttime-label" ">'+localizer.getString('hpsum.server.scheduleStartTime')+'</label>' +
										'<ol>' +
									'</div>' +

									'<div id="'+idPrepender+'hpsum-schedule-plugin-easy-mode-test1" style="padding-left: 15px;margin-top:5px;display:none;">' + 
									'</div>' +
									

							'</li></div>'
								
					$('#' + easyModeContainer).html(html);
					
					$('#'+idPrepender+'hpsum-schedule-plugin-easy-mode-test1').hpsumSchedule({
						enableButton: function(){
                        	$("#hpsum-node-deploy-ok").removeAttr("disabled");                        
                    	},
                    	disableButton: function(){
                        	$("#hpsum-node-deploy-ok").attr("disabled", "disabled");
                    	}
                    });


					if(item.nodes[0].nodeItem.node_state == 'REMOTE_STAGING_UAN')
					{
						$('#'+idPrepender+'hpsum-schedule-starttime-label').show();
					 	$('#'+idPrepender+'hpsum-schedule-plugin-easy-mode-test1').show();

					 	$('#'+idPrepender+'hpsum-schedule-plugin-easy-mode-test1').hpsumSchedule('setTimeinSchedulePlugin',nodeItem.local_date_time,nodeItem.schedule_date_time);
                	    $('#'+idPrepender+'hpsum-schedule-plugin-easy-mode-test1').hpsumSchedule('setMasterNodeTimer',nodeItem.local_date_time);

                	    if(nodeItem.schedule_date_time != ""){
                			$('#'+idPrepender+'hpsum-schedule-plugin-easy-mode-test1').hpsumSchedule('selectScheduled');
                		} else {
							$('#'+idPrepender+'hpsum-schedule-plugin-easy-mode-test1').hpsumSchedule('selectImmediately');
                		}
					 		
					}
					else
					{
						$('#'+idPrepender+'hpsum-schedule-starttime-label').hide();
					 	$('#'+idPrepender+'hpsum-schedule-plugin-easy-mode-test1').hide();
					}
					$('#'+idPrepender+'slider').slider({
						value: 0,
						min: 0,
						max: 60,
						orientation: "horizontal",
						slide: function (event, ui) {
							if(ui.value == 0)
							{
								$("#value").text('Never');
								$("#reboot-sufix").hide();                                
								easyModeRebootValue = 0;
							}
							else
							{
								$("#value").text(ui.value);
								$("#reboot-sufix").show();                                
								easyModeRebootValue = ui.value;
							}
						}	
					});
					$("#value").text('Never');
					var nodeType = item.nodes[0].nodeItem.type; 
					plugin.displayEasyModeContents(nodeType);
					isEasyModeRendered = true;
					if(nodeAttributes != null)
					{
						plugin.loadAttributes(nodeAttributes);
					}
					
					$('#'+idPrepender+'hpsum-node-easymode-rewrite').click(function () { 
						firmware = true;
						software = true;
						rewrite =  $('#'+idPrepender+'hpsum-node-easymode-rewrite').is(':checked');
							if(rewrite)
							{
								forcefirmware = true;
								forcesoftware = true;
							}
							else
							{
								if(downgrade == false)
								{
									forcefirmware = false;
									forcesoftware = false;
								}
							}
						if(plugin.options.hasOwnProperty("applyInstallationOptions"))
						{							
							plugin.options.applyInstallationOptions();							
						}
						rebootDelayChanged = false;
					});
					$('#'+idPrepender+'hpsum-node-easymode-downgrade').click(function () {
						firmware = true;
						software = true;
						downgrade =  $('#'+idPrepender+'hpsum-node-easymode-downgrade').is(':checked');
						if(downgrade)
							{
								forcefirmware = true;
								forcesoftware = true;
							}
							else
							{
								if(rewrite == false)
								{
									forcefirmware = false;
									forcesoftware = false;
								}
							}
						if(plugin.options.hasOwnProperty("applyInstallationOptions"))
						{
							plugin.options.applyInstallationOptions();
						}
						rebootDelayChanged = false;
					});

					$('#'+idPrepender+'hpsum-node-easymode-disruptive').click(function () { 
						nondisruptive = false;
						if(plugin.options.hasOwnProperty("applyInstallationOptions"))
						{
							plugin.options.applyInstallationOptions();
						}
					});
					
					$('#'+idPrepender+'hpsum-node-easymode-nondisruptive').click(function () { 
						nondisruptive = true;
						if(plugin.options.hasOwnProperty("applyInstallationOptions"))
						{
							plugin.options.applyInstallationOptions();
						}
						rebootDelayChanged = false;
					});
					
					$('#'+idPrepender+'hpsum-node-easymode-cleanuponexit').click(function () { 						
						var flag  =  $('#'+idPrepender+'hpsum-node-easymode-cleanuponexit').is(':checked');
						if(flag)
						{
							cleanuponexit = true;
						}
						else 
						{
							cleanuponexit = false;
						}
					});
					
					$('#'+idPrepender+'hpsum-node-easymode-cleanupallonexit').click(function () { 
						
						var flag  =  $('#'+idPrepender+'hpsum-node-easymode-cleanupallonexit').is(':checked');
						if(flag)
						{
							cleanupallonexit = true;
						}
						else 
						{
							cleanupallonexit = false;
						}
					});
					
					$('#'+idPrepender+'hpsum-node-easymode-skipdependency').click(function () { 
						var flag =  $('#'+idPrepender+'hpsum-node-easymode-skipdependency').is(':checked');
						if(flag)
						{
							skipdependency = 'OMITCOMPONENT';
						}
						else
						{
							skipdependency = 'OMITHOST';
						}
						if(plugin.options.hasOwnProperty("applyInstallationOptions"))
						{
							plugin.options.applyInstallationOptions();
						}
						rebootDelayChanged = false;
					});
					
					
					
					//keypress is for handling enter key and  keyup is for handling backspace and delete keys 
					//which is in turn used to get the no of characters in encryption key
					$('#'+idPrepender+'hpsum-node-vc-encryption-key').on('keypress keyup', function(event) {
						var keyCode = (event.keyCode ? event.keyCode : event.which);
						if (keyCode == 13) {	// keyCode == 13 is the 'Enter' key
							// Do not allow default action as it causes a refresh
							event.preventDefault();
							return;
						}
						if($('#'+idPrepender+'hpsum-node-vc-encryption-key').val().length > 0)
						{
							encryptionKeyChanged = true;
						}
						else
						{
							encryptionKeyChanged = false;
						}
						plugin.handleErrorConditions();
						rebootDelayChanged = false;						
						
					});
			},
			
			
			/*
			function to handle warning message for 'skip components with failed dependency'
			1. show message in case components with failed dependency are present on easy mode
			2. hide above message in case checkbox is selected
			3. clear the message when we switch to advanced mode
			*/
			handleErrorConditions : function()
			{
				 var idPrepender = easyModeContainer + '_';
				 var disableDeploy = false;
				 var chk_skipdependency = ($('#'+idPrepender+'hpsum-node-easymode-skipdependency').is(':checked'));
				 var resetform = true;
				 var summary = '';
				if(nodeItem.node_state !='REMOTE_STAGING_UAN')
				{
					 //disabled skip-failed-dep checkbox in case no components with failed dep present in the installset.
					 if(failedDepCount > 0)
					 {
						 $('#'+idPrepender+'hpsum-node-easymode-skipdependency').prop('disabled', "");
						 $('#'+idPrepender+'label-skip-failed-dep-components').css("color","");
					 }
					 else
					 {
						 if(!$('#'+idPrepender+'hpsum-node-easymode-skipdependency').is(':checked'))
						 {
							$('#'+idPrepender+'hpsum-node-easymode-skipdependency').prop('disabled', "disabled");
							$('#'+idPrepender+'label-skip-failed-dep-components').css("color","#aaaaaa");
						 }
					 }
				 				 
					 if(selectedComponents.length < 1)
					 {
						disableDeploy = true;
						resetform = false;

						summary = localizer.getString('hpsum.easymode.NoComponentsToDeploy') ;
					 }
					 
					 if(!chk_skipdependency )
					 {
						if(failedDepCount > 0) {
							disableDeploy = true;
							resetform = false;
							summary = localizer.getString('hpsum.easymode.SkipDependencyWarning');
						}	
					 }
								
					//add logic to decide if deploy should be enabled/disabled due to encryption key validation
					if(isConfigPasswordRequired && $('#'+idPrepender+'hpsum-node-vc-encryption-key').val().length <=minEncryptionKeyLength)
					{
						disableDeploy = true;
						summary = localizer.getString('hpsum.advanceMode.InvalidEncryptionKey');
					}
				}
				
				if(selectedComponents.length < 1)
				 {
					disableDeploy = true;
					resetform = false;
					summary = localizer.getString('hpsum.easymode.NoComponentsToDeploy') ;
				 }
				
				var item = {
						 disableDeploy : disableDeploy,
						 formStateViewMessage : summary
						 };
						
					 this.options.shouldEnableDeployment(item);
			},
			
			/*
			load attributes to retain the last saved attribute selection. We may go away from this function as we are planning to reset the attribute selection to mode change. Work - TBD
			*/
			loadAttributes : function(item)
			{
				nodeAttributes = item;
				if(item != null && isEasyModeRendered)
				{
					var idPrepender = easyModeContainer + '_';
					if(item.hasOwnProperty("installationOptions"))
					{
						var installationOptions = item.installationOptions;
						//set downgrade
						downgrade = installationOptions.downgrade;
						$('#'+idPrepender+'hpsum-node-easymode-downgrade').prop('checked', downgrade);
						//set rewrite
						rewrite = installationOptions.rewrite;
						$('#'+idPrepender+'hpsum-node-easymode-rewrite').prop('checked', rewrite);
						if(installationOptions.nondisruptive == true)
						{
							nondisruptive = true;
							$('#'+idPrepender+'hpsum-node-easymode-nondisruptive').prop('checked', true);
							$('#'+idPrepender+'hpsum-node-easymode-disruptive').prop('checked', false);
							$('#'+easyModeContainer + '_'+'slider').slider( "option", "disabled", true );
							$('#'+easyModeContainer + '_'+'slider-container').css("color","#aaaaaa");							
						}
						else
						{
							nondisruptive = false;
							$('#'+idPrepender+'hpsum-node-easymode-nondisruptive').prop('checked', false);
							$('#'+idPrepender+'hpsum-node-easymode-disruptive').prop('checked', true);
							$('#'+easyModeContainer + '_'+'slider').slider( "option", "disabled", false );
							$('#'+easyModeContainer + '_'+'slider-container').css("color","");
						}
						
						if(installationOptions.skipCompsWithDepFailure == "OMITCOMPONENTS")
						{
							$('#'+idPrepender+'hpsum-node-easymode-skipdependency').prop('checked', true);
							skipdependency = "OMITCOMPONENT";
						}
						else
						{
							$('#'+idPrepender+'hpsum-node-easymode-skipdependency').prop('checked', false);
							skipdependency = "OMITHOST";
						}
						
						// Hide cleanup all option for localhost and device type nodes. It only for Windows and Linux remote nodes
						if ((nodeType.match(/windows|linux/i) && nodeItem.ip === 'localhost') || nodeType.match(/hpux|vmware|virtual_connect|ipdu|OA|ilo|switch|SAS_SWITCH|moonshot|integrityilo/i)) {
							$('#'+idPrepender+'cleanupall-onexit-after-deploy').hide();
						}
						else{
							$('#'+idPrepender+'cleanupall-onexit-after-deploy').show();
						}
						
						// Set default to unchecked 
						$('#'+idPrepender+'hpsum-node-easymode-cleanupallonexit').prop('checked', cleanupallonexit);
						$('#'+idPrepender+'hpsum-node-easymode-cleanuponexit').prop('checked', cleanuponexit);
						
						software = installationOptions.software;
						firmware = installationOptions.firmware;
						forcesoftware = installationOptions.forcesoftware;
						forcefirmware = installationOptions.forcefirmware;
						if (nodeType.match(/vmware/i)) {
							if(installationOptions.rewrite == true)
							{
								$('#'+idPrepender+'hpsum-node-easymode-vmwarewarning').show();
							}
							else {
								$('#'+idPrepender+'hpsum-node-easymode-vmwarewarning').hide();
							}
						}
						else
						{
							$('#'+idPrepender+'hpsum-node-easymode-vmwarewarning').hide();
						}
							
						if( rebootDelayChanged == true) {
							// Convert the delay into minutes before displaying.
							if( installationOptions.rebootAction == 'Never') {
								rebootDelay = '0';
							} else {
								rebootDelay = (installationOptions.rebootDelay)/60;
							}
							plugin.updateRebootDelay();
						}
					}
				}
			},
			
			/*
			function to 
			1. mark if reboot delay is changed.
			2. show Never in case reboot delay selected == 0
			*/
			updateRebootDelay : function()
			{
				var idPrepender = easyModeContainer + '_';
				$('#'+idPrepender+'slider').slider('value', rebootDelay);
				if(rebootDelay == 0)
				{
					$("#value").text('Never');
					$("#reboot-sufix").hide();
				}
				else
				{
					$("#value").text(rebootDelay);
					$("#reboot-sufix").show();
				}
				
				rebootDelayChanged = false;
				$('#'+easyModeContainer+'_hpsum-node-vc-encryption-key').val('');
				$('#'+idPrepender+'hpsum-node-easymode-cleanuponexit').prop('checked', false);
				$('#'+idPrepender+'hpsum-node-easymode-cleanupallonexit').prop('checked', false);
			},
			
			isRebootDelayChanged : function(item) {	
				if(item.delayChanged == true)
				{
					rebootDelayChanged = true;	
				}
				else
				{
					rebootDelayChanged = false;	
				}	
			},	

			setEasyScheduleOptions : function(args) {	
				if(args.item.node_state == 'REMOTE_STAGING_UAN')
				{
					$('#'+easyModeContainer+'_hpsum-schedule-starttime-label').show();

				 	$('#'+easyModeContainer+'_hpsum-schedule-plugin-easy-mode-test1').show();
				 	$('#'+easyModeContainer+'_hpsum-schedule-plugin-easy-mode-test1').hpsumSchedule('setTimeinSchedulePlugin',args.item.local_date_time,args.item.schedule_date_time);
                	$('#'+easyModeContainer+'_hpsum-schedule-plugin-easy-mode-test1').hpsumSchedule('setMasterNodeTimer',args.item.local_date_time);

                	if(args.item.schedule_date_time != "")
                	{
                		$('#'+easyModeContainer+'_hpsum-schedule-plugin-easy-mode-test1').hpsumSchedule('selectScheduled');
                	} else {
						$('#'+easyModeContainer+'_hpsum-schedule-plugin-easy-mode-test1').hpsumSchedule('selectImmediately');
                	}
				 	
				}
				 else
				 {

				 	$('#'+easyModeContainer+'_hpsum-schedule-starttime-label').hide();
				 	$('#'+easyModeContainer+'_hpsum-schedule-plugin-easy-mode-test1').hide();
				 }
			},
			
			/*
			function to access installation options selected by user.
			Method called from parent page to access values to send to engine.
			*/
			getInstallationOptionsEasyMode: function(item) {
				var nodeItem = item.nodeItem;
				var ForceOptions = item.ForceOptions;
				ForceOptions.hapi.installation_option ={};
				ForceOptions.hapi.installation_option.rewrite = rewrite;
				ForceOptions.hapi.installation_option.downgrade = downgrade;
				ForceOptions.hapi.installation_option.nondisruptive = nondisruptive;
				ForceOptions.hapi.failed_dependency_handling = skipdependency;
				ForceOptions.hapi.installation_option.software = software;
				ForceOptions.hapi.installation_option.firmware = firmware;
				ForceOptions.hapi.installation_option.forcesoftware = forcesoftware;
				ForceOptions.hapi.installation_option.forcefirmware = forcefirmware;
			},
			resetplugindefaults : function() {
					downgrade = false;
					rewrite = false;
					software = true;
					firmware = true;
					forcesoftware = false;
					forcefirmware = false;
					nondisruptive = false;
					cleanuponexit = false;
					cleanupallonexit = false;
					skipdependency = 'OMITHOST';
			},
				
			// Reset() sets all the attributes back to defaults in case of Change of mode and click of
			// cancel. The defaults are re-intialized for easy mode here and applyInstallationOptions()
			// is called to do the setatrributes.
			// Expert mode defaults are taken care in the getInstallationOptions() and Easy mode defaults are
			// handled in getInstallationOptionsEasyMode() which simply reads these default values.
			// Also the attributes are reset only in case the user has made any selections.
			// firmware != software condition is used for handling upgrade firmware/software from advanced mode.
			reset : function(item) {
				var forceReset = false;
				if(item != undefined)
				{
					forceReset = item.forceReset;
				}
				if( rewrite || downgrade || nondisruptive || (firmware != software) || (skipdependency != 'OMITHOST') || forceReset == true)
				{
					downgrade = false;
					rewrite = false;
					software = true;
					firmware = true;
					forcesoftware = false;
					forcefirmware = false;
					nondisruptive = false;
					skipdependency = 'OMITHOST';
					
					if(plugin.options.hasOwnProperty("applyInstallationOptions"))
					{
							plugin.options.applyInstallationOptions();
					}
					
				}
				else
				{
					plugin.options.handleResetAction();
				}
				
				//reset other values:
				cleanuponexit = false;
				cleanupallonexit = false;
				easyModeRebootValue = 0; // reset reboot selected variable value.
				encryptionKeyChanged = false; 
			},
			
			/*
			function to access VC related options.
			*/
			getVCOptionsEasyMode: function(item) {
				var idPrepender = easyModeContainer + '_';
				var optiondetails = item.optiondetails;
				optiondetails.hapi.vc_encryption_settings ={};
				optiondetails.hapi.vc_encryption_settings.vc_encryption_key = $('#'+idPrepender+'hpsum-node-vc-encryption-key').val();
			},
			
			/*
			function to access ILO related options.
			*/
			getILOActivationOptionsEasyMode: function(item) {
				var idPrepender = easyModeContainer + '_';
				var optiondetails = item.optiondetails;
				var tmp = $('#'+idPrepender+'hpsum-activate-selection_easy_mode').val();
				if( tmp == 'NO') {
					optiondetails.hapi.activate_sfw = false;
				} else {
					optiondetails.hapi.activate_sfw = true;
				}
			},
			/*
			function to access reboot options.
			*/
			getRebootOptionsEasyMode: function(item) {
				var idPrepender = easyModeContainer + '_';
				var optiondetails = item.optiondetails;
				optiondetails.hapi.reboot_options ={};	
				if ( $("#value").text() == 'Never' ) {
					optiondetails.hapi.reboot_options.action = 'Never';
					optiondetails.hapi.reboot_options.delay = 60;
				}
				else {
					optiondetails.hapi.reboot_options.action = 'If Needed';
					//Convert the delay to seconds as the engine requires it in the seconds format.
					optiondetails.hapi.reboot_options.delay = $("#value").text()*60; 
				} 	
				optiondetails.hapi.reboot_options.message = '';
			},
			
			/*
			function to get clean up on exit options.
			*/
			getCleanUpOnExitOptionsEasyMode: function(item) {
				var idPrepender = easyModeContainer + '_';
				item.nodeItem.cleanup_onexit = $('#'+idPrepender+'hpsum-node-easymode-cleanuponexit').prop('checked');
				var isNone = $('#'+idPrepender+'hpsum-node-easymode-cleanupallonexit').css('display');
				if ( "none" != isNone && $('#'+idPrepender+'hpsum-node-easymode-cleanupallonexit').prop('checked') ){
					item.nodeItem.cleanupall_onexit = true;
				}
				else{
					item.nodeItem.cleanupall_onexit = false;
				}
			},
			
			getVerboseOptionsEasyMode: function(item) {
				var idPrepender = easyModeContainer + '_';
				var optiondetails = item.optiondetails;
				optiondetails.hapi.verbose = '';
				
				if($('#'+easyModeContainer+'_verbose_logging').is(':checked'))
				{
					optiondetails.hapi.verbose = true;
				}
				else
				{	
					optiondetails.hapi.verbose = false;
				}
			},
		},
		
		
		// A really lightweight plugin wrapper around the constructor,
		// preventing against multiple instantiations
		$.fn[pluginName] = function ( options ) {
			
    	var instance;
		
		if ( typeof options === 'string' ) { 
                // call method
                var args = Array.prototype.slice.call( arguments, 1 );
				 this.each(function() {
                    instance = $.data( this, "plugin_" + pluginName );
                    if ( !instance ) {
                        if (window.console) {
                            window.console.error( "cannot call methods on hpInstallables prior to initialization; " +
                                "attempted to call method '" + options + "'" );
                        }
                        return;
                    }
                    if ( !$.isFunction( instance[options] ) || options.charAt(0) === "_" ) {
                        if (window.console) {
                            window.console.error( "no such method '" + options + "' for hpInstallables instance" );
                        }
                        return;
                    }
                    // apply method
                   	instance[ options ].call( instance, args );
                });  
              }
               else{
				   
        return this.each(function () {
            if (!$.data(this, "plugin_" + pluginName)) {
                $.data(this, "plugin_" + pluginName, new Plugin( this, options ));
               }
			  else {
			  	instance = $.data( this, "plugin_" + pluginName );
				instance[ options.command ].call( instance, options.args );
			  }

        });
        }
    };
	}(jQuery));
});
	
