define(['hpsum/presenter/node/NodePresenter',                                
                                'hp/core/EventDispatcher',
                                'hp/core/Localizer',
                                'hp/view/DialogView',
                                'text!hpsumpages/node/installset_dialog.html',
								'text!hpsumpages/node/delete_confirm.html',
                                'hpsum/view/node/jquery.hpsumInstallSetComponents',
                                'jquery',
                                'hp/lib/jquery.hpStatus',
                                'lib/jquery.dataTables',
                                'hp/lib/jquery.hpCollapsible',
                                'hp/lib/jquery.hpToggle'],
function (presenter, EventDispatcher, Localizer, DialogView, installsetDialogHtml, deleteConfirmHtml) {
    "use strict";
    (function ($) {
        // Create the defaults once
        var pluginName = "hpsumInstallSets",
defaults = {
    nodeItem: null
};
        var l_data = null;
        var l_el = null;
        var l_nodeItem = null;        
        var sortDirection = 'desc', sortColumn = 2;
        var plugin;
        var isDeployOption = false;
        var DELETE_INSTALLSET_BUTTON = "#installset-delete-button";
        var CLOSE_BUTTON = "#installset_delete-close-button";
        var DELETE_FLASH_DIALOG = "#hpsum-delete-installset-dialog";
        var DELETING_SPINNER = "#hpsum-delete-spinner";
        var INSTALLSET_HEADER = "#installset-Header";
        var dataForDelete = null;
        var recoveryisSet = false;
        var installsetAsbaseline = false;        
        // The actual plugin constructor
        function Plugin(element, options) {
            this.element = element;

            // jQuery has an extend method which merges the contents of two or
            // more objects, storing the result in the first object. The first object
            // is generally empty as we don't want to alter the default options for
            // future instances of the plugin
            this.options = $.extend({}, defaults, options);
            this._defaults = defaults;
            this._name = pluginName;

            this.init();
			
        }
		

        Plugin.prototype = 
		{
            init: function () {
                $(this.element).addClass('hpsumInstallSets');
                plugin = this;
                if (this.options.command == 'init')
				{
                    this.initialize(this.element, this.options);
				}
            },       

            initDeployInstallSetTable: function (tableid) {
                var oTab = $(tableid).dataTable({
                    oLanguage: {
                        sEmptyTable: Localizer.getString("hpsum.common.noApplicableinstallsetsFound")
                    },
                    bPaginate: false,
                    bProcessing: false,
                    bSort: true,
                    bAutoWidth: true,
                    bFilter: false,
                    bInfo: false,
                    bRetrieve: false,
                    bDestroy: false,
                    //aaData: data,
                    aoColumns:
                    [
                        {
                            mDataProp: 'delete', sWidth: 20
                        },
                        {
                            mDataProp: 'name', sWidth: 200
                        },
                        
                        {
                            mDataProp: 'description', fnRender: function (oObj) {
                                return oObj.aData.description;
                            }, sWidth: 350
                        },
                        {
                            mDataProp: 'date', fnRender: function (oObj) {
                                return oObj.aData.date;
                            }, sWidth: 120
                        },
                        {
                            mDataProp: 'size', fnRender: function (oObj) {
                                var installset_size = (oObj.aData.size / 1024);
                                if (installset_size > 1024) {
                                    installset_size = installset_size / 1024;
                                    installset_size = installset_size.toFixed(2);
                                    installset_size = installset_size + 'MB';
                                }
                                else {
                                    installset_size = installset_size.toFixed(2);
                                    installset_size = installset_size + 'KB';
                                }
                                return installset_size;
                            }, sWidth: 10
                        },
                        {
                            mDataProp: 'isRecoverySet', fnRender: function (oObj) {
                                var isRecoverySetvalue = "No";
                                if (oObj.aData.isRecoverySet == true) {
                                    isRecoverySetvalue = "Yes";
                                }
                                return isRecoverySetvalue;
                            }, sWidth: 20
                        },
                        {
                            mDataProp: 'installset_id', "bVisible": false,
                            fnRender: function (oObj) {
                                var installset_id = oObj.aData.installset_id;
                                return installset_id;
                            }, sWidth: 0
                        }
                    ],
                    fnCreatedRow: function (nRow, aData, iDataIndex) {
                        nRow.className += aData.installset_id;
                    },
                    //aaSorting : [],
                    fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                        return nRow;
                    },
                    "fnDrawCallback": function (oSettings) {
                        if (oSettings.aiDisplay.length == 0) {
                            return;
                        }
                    },
                    "aaSorting": [[3, 'asc']],
                    "sDom": 'lfr<"giveHeight"t>ip'

                });

            },
            initInstallSetTable: function (tableid) {
                var oTab = $(tableid).dataTable({
                    oLanguage: {
                        sEmptyTable: Localizer.getString("hpsum.common.noApplicableinstallsetsFound")
                    },
                    bPaginate: false,
                    bProcessing: false,
                    bSort: true,
                    bAutoWidth: true,
                    bFilter: false,
                    bInfo: false,
                    bRetrieve: false,
                    bDestroy: false,
                    //aaData: data,
                    aoColumns:
                    [
                        {
                            mDataProp: 'name', sWidth: "40%"
                        },
                        {
                            mDataProp: 'description', fnRender: function (oObj) {
                                return oObj.aData.description;
                            }, sWidth: "60%"
                        },
                        {
                            mDataProp: 'installset_id', "bVisible": false,
                            fnRender: function (oObj) {
                                var installset_id = oObj.aData.installset_id;
                                return installset_id;
                            }, sWidth: "0%"
                        }
                    ],
                    fnCreatedRow: function (nRow, aData, iDataIndex) {
                        nRow.className += aData.installset_id;
                    },
                    //aaSorting : [],
                    fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                        return nRow;
                    },
                    "fnDrawCallback": function (oSettings) {
                        if (oSettings.aiDisplay.length == 0) {
                            return;
                        }
                    },
                    "aaSorting": [[0, 'asc']],
                    "sDom": 'lfr<"giveHeight"t>ip'

                });

            },

            populateInstallSet: function (data, id, nodeItem) 
            {
                var hapiTag = "hapi";
                var installsetsTag = "installsets";
                if (data.length == 0 && id == undefined && nodeItem == undefined) {
                    data = l_data;
                    id = l_el;
                    nodeItem = l_nodeItem;
                }
                
                var deployflag = false, analysisflag = false;
				var currtableId = '#hpsum-ilo-installables-' + nodeItem.node_id + '-table';		

				$(id).empty();				
				if (data.hasOwnProperty(hapiTag) && data.hapi.hasOwnProperty(installsetsTag)) {
				    if (isDeployOption) {
				        $(id).append('<table id="hpsum-ilo-installables-' + nodeItem.node_id + '-table"><thead><tr><td><b>' +
                            Localizer.getString('hpsum.common.installSetDelete') + '</b></td><td><b>' +
                            Localizer.getString('hpsum.common.installSetName') + '</b></td><td><b>' +
                            Localizer.getString('hpsum.common.installSetDesc') + '</b></td><td><b>' +
                            Localizer.getString('hpsum.common.installSetDate') + '</b></td><td><b>' +
                            Localizer.getString('hpsum.common.installSetSize') + '</b></td><td><b>' +
                            Localizer.getString('hpsum.common.installSetIsRecoverySet') + '</b></td><td></td></tr></thead></table>');

				        plugin.initDeployInstallSetTable(currtableId); //initialize for deploy action.
				    }
				    else {
				        $(id).append('<table id="hpsum-ilo-installables-' + nodeItem.node_id + '-table" style="width:95%;"><thead><tr><td style="word-wrap: break-word; white-space: nowrap;"><b>' +
                           Localizer.getString('hpsum.common.installSetName') + '</b></td><td style="word-wrap: break-word; white-space: nowrap;"><b>' +
                           Localizer.getString('hpsum.common.installSetDesc') + '</b></td><td></td></tr></thead></table>');

				        plugin.initInstallSetTable(currtableId); //initialize for overview action.
				    }
				    // if()

				    var currTable = $(currtableId).dataTable();

				    if ($(currtableId).length) {
				        currTable.fnClearTable();
				    }

				    var installsetslist = data.hapi.installsets;
				    var installsetAdded = {}, installsetsCount = 0;
				    var installsetId = "id";
				    if (currTable && installsetslist) {
				        for (var count = 0; count < installsetslist.installset.length; count++) {
				            var currinstallset = installsetslist.installset[count];
				            if (currinstallset.hasOwnProperty(installsetId)) {
				                //add all the selected installsets							
				                if (installsetAdded[currinstallset.id] != true) {
				                    var installset_id = currinstallset.id, installset_name = ' (' + installset_id + ')';
				                    var installset_name = currinstallset.name;
				                    var deleteString = "";
				                    if (installset_name != "" && !currinstallset.iloinstallset_state.match(/clearing/i)) {
										installset_name = '<a href="javascript:void(0);" class="company-a">' + installset_name + '</a>';
				                    }
									if (isDeployOption)
									{
				                        if (currinstallset.isRecoverySet == true || currinstallset.isRecoverySet == "Yes") {
				                            deleteString = "";
				                        }
				                        else {
				                            deleteString = '<input id="delete_installset-' + installset_id + '" type=checkbox>';
				                        }
				                    }
				                    var installsetItem = [{
				                        'installset_id': currinstallset.id,
				                        'name': installset_name,
				                        'description': currinstallset.description,
				                        'date': currinstallset.date,
				                        'size': currinstallset.size,
				                        'isRecoverySet': currinstallset.isRecoverySet,
				                        'delete': deleteString,
				                        'installset_name': currinstallset.name
				                    }];
				                    if ($(currtableId).length) {
				                        currTable.fnAddData(installsetItem);
				                    }
				                    installsetAdded[currinstallset.id] = true;									
				                }

				            }
				        }
				    }
				    $('.tooltip').hpTooltip();
				    $('.hp-ellipsis').hpEllipsis();


				    $(currtableId + " tbody tr").click(function (e) {
				        var srcElem;
				        var tableid = '#hpsum-ilo-installables-' + nodeItem.node_id + '-table';
				        var data = $(tableid).dataTable().fnGetData(this);
				        var installSetDetailsId = 'A';
				        var deleteInstallSetId = 'delete_installset-' + data.installset_id;
				        var deleteExistingInstallsetId = 'delete_installset-checkbox-' + data.installset_id;
				        if (data != null) {
				            //Check if firefox or (chrome and IE)
				            if (e.srcElement)
				                srcElem = e.srcElement;//Chrome and IE
				            else {
				                srcElem = e.target;//Firefox
				            }

				            if (srcElem.tagName == installSetDetailsId) {
				                plugin.showinstallsetDialogBox(nodeItem, data.installset_id);
				                return;
				            }
				            else if (srcElem.id == deleteExistingInstallsetId) {
				                return;
				            }
				        }
				    });
				}
				else {
				    $(id).html(Localizer.getString('hpsum.common.noApplicableinstallsetsFound'));
				}
				
            },

            showDeletingFlash: function(item){
                $(DELETE_FLASH_DIALOG).dialog({
                    modal: true,
                    dialogClass: 'hp-splash-dialog',
                    position: "center",
                    draggable: false,
                    resizable: false,
			        show : 'fade',
					closeOnEscape: false,
			        width : 400
                });

                if (item.hasOwnProperty('installset_id') && item.installset_id.match(/Unreferenced_Components/i)) {
                    $('#hpsum-wait-message').text(Localizer.getString('hpsum.common.unrefCompDeleteInProgress'));
                }
                else {
                    $('#hpsum-wait-message').text(Localizer.getString('hpsum.common.installsetDeleteInProgress'));
                }

                $(DELETING_SPINNER).show();
            },
            
            closeDeletingFlash: function ()
            {
                $(DELETING_SPINNER).hide();
                $(DELETE_FLASH_DIALOG).dialog().dialog('destroy');
            },

            CanInstallsetBeDeleted: function()
            {
                var msg = "";
                if (recoveryisSet) {
                    msg = Localizer.getString("hpsum.common.installsetCannotDelete");
                }
                else if (installsetAsbaseline && l_nodeItem.node_phase.match(/Inventory|Analyzing|Deploying/i)) {
                    msg = Localizer.getString("hpsum.common.installsetCannotDeleteDuetoInProgressState", [l_nodeItem.node_phase]);
                }                               
                return msg;
            },

            onDeleteInstallsetButtonClick: function () {
                var msg = plugin.CanInstallsetBeDeleted();
                if(msg != "")
                {
                    $(DELETE_INSTALLSET_BUTTON).attr('tooltip', msg).hpTooltip();
                    return;
                }
                else {
                    $(DELETE_INSTALLSET_BUTTON).removeClass('hp-tooltipped').removeAttr('tooltip data-tooltip');
                    plugin.showDeleteConfirmDialogBox(l_nodeItem, dataForDelete);
                }
            },
            showinstallsetDialogBox: function (nodeItem, installsetid) {
                //First sent getinstallsetData
                var item = {
					node_id: nodeItem.node_id,
                    installset_id: installsetid
                };
                presenter.getInstallSetDetails(item, {
                    success: function (data) {
                        dataForDelete = data;
                        var installsetDialogContents = $(installsetDialogHtml);
                        Localizer.localizeDom(installsetDialogContents);

                        if (dataForDelete.hapi.hasOwnProperty('installset') && dataForDelete.hapi.installset.id.match(/Unreferenced_Components/i)) {
                            $(INSTALLSET_HEADER, installsetDialogContents).html(Localizer.getString('hpsum.common.iLOUnrefComponents'));
                        } else {
                            $(INSTALLSET_HEADER, installsetDialogContents).html(Localizer.getString('hpsum.common.iLOInstallSetDetails'));
                        }

						//show installset dialog
                        var dialog = new DialogView();
                        dialog.init({
                            contents: installsetDialogContents,
                            ok: function (elem) {
                                
                            },
                            cancel: function () {
                                return true;
                            }
                        });
                        if (!isDeployOption) {
                            $(DELETE_INSTALLSET_BUTTON).show(); //delete button will be only for overview page IS details
                            $(DELETE_INSTALLSET_BUTTON).unbind('click').bind('click', plugin.onDeleteInstallsetButtonClick);
                            if (nodeItem.hasOwnProperty('baselines') && nodeItem.baselines.length > 0 && nodeItem.baselines[0] == data.hapi.installset.id) {
                                installsetAsbaseline = true;
                            }
                            else {
                                installsetAsbaseline = false;
                            }
                        }
                        else
                        {
                            $(DELETE_INSTALLSET_BUTTON).hide(); ////delete button will not be for deploy page IS details
                        }
                        var stringMb = 'MB', stringYes = "Yes", stringNo = "No", stringTrue = true;
                        var installset = data.hapi.installset;
                        var sumComponentsCount = 0;
						var uefiComponentsCount = 0;
						var iLOComponentsCount = 0;
						var installset_size = (installset.size / 1024);
						if (installset_size > 1024) {
						    installset_size = installset_size / 1024;
						    installset_size = installset_size.toFixed(2);
						    installset_size = installset_size + 'MB';
						}
						else {
						    installset_size = installset_size.toFixed(2);
						    installset_size = installset_size + 'KB';
						}
						
						var isRecoverySetvalue = stringNo;
						if (installset.isRecoverySet == stringTrue || installset.isRecoverySet == stringYes) {
						    isRecoverySetvalue = stringYes;
						}
						var msg = "";
						if (installset.isRecoverySet === true)
						{						    
						    //add tooltip saying cannot delete
						    recoveryisSet = true;						   
						}
						else
						{
						    recoveryisSet = false;
						}
						msg = plugin.CanInstallsetBeDeleted();
						if (msg != "")
						{
						    $(DELETE_INSTALLSET_BUTTON).attr('tooltip', msg).hpTooltip();
                            //cannot add disabled property because, disable will not show up the tooltip. 
						    $(DELETE_INSTALLSET_BUTTON).addClass('sum-disable-button-props');
						}
						else
						{
						    $(DELETE_INSTALLSET_BUTTON).removeClass('hp-tooltipped').removeAttr('tooltip data-tooltip');
						    $(DELETE_INSTALLSET_BUTTON).attr("disabled", false); //this will remove the manual color settings done above. 
						}
                        //caclulate components.
						var INSTALLSET_DIALOG_TITLE = "#installset_dialog_title";
						var INSTALLSET_DESC = "#hpsum-installset-desc";
						var INSTALLSET_COMP_TOTAL = "#hpsum-installset-ComponentsTotal";
						var INSTALLSET_SIZE = "#hpsum-installset-size";
						var INSTALLSET_ISRECOVERYSET = "#hpsum-installset-isrecoveryset";
						var INSTALLSET_SUM_COMPS = "#hpsum-installset-sumcomps";
						var INSTALLSET_UEFI_COMPS = "#hpsum-installset-ueficomps";
						var INSTALLSET_ILO_COMPS = "#hpsum-installset-ilocomps";
						var INSTALLSET_COMPTABLE_TITLE = "#installset_table_title";
						var INSTALLSET_COMP_TABLE = "#hpsum_installset_components";
						var INSTALLSET_ILO_NEEDS_REBOOT_LABEL = "#hpsum-needs-reboot-ilo-label";
						var INSTALLSET_UEFI_NEEDS_REBOOT_LABEL = "#hpsum-needs-reboot-uefi-label";
						var INSTALLSET_DATECREATED = "#hpsum-installset-datecreated";
						for (var eachcomp = 0; eachcomp < installset.components.component.length; eachcomp++)
						{
						    var updatedByList = installset.components.component[eachcomp].updatedby;
						    if (updatedByList[0].match(/UEFI/i)) {
						        uefiComponentsCount++;
						    } else if (updatedByList[0].match(/SUM\/iSUT/i)) {
						        sumComponentsCount++;
						    } else if (updatedByList[0].match(/ILO/i)) {
						        iLOComponentsCount++;
						    }
						}

						if (iLOComponentsCount > 0)
						{
						    $(INSTALLSET_ILO_NEEDS_REBOOT_LABEL).show();
						    $(INSTALLSET_ILO_NEEDS_REBOOT_LABEL).html('<b>' + Localizer.getString("hpsum.common.installsetCompNeedsReboot") + '</b>');
						}
						else
						{
						    $(INSTALLSET_ILO_NEEDS_REBOOT_LABEL).hide();
						}

						if (uefiComponentsCount > 0) {
						    $(INSTALLSET_UEFI_NEEDS_REBOOT_LABEL).show();
						    $(INSTALLSET_UEFI_NEEDS_REBOOT_LABEL).html('<b>' + Localizer.getString("hpsum.common.installsetCompNeedsReboot") + '</b>');
						}
						else {
						    $(INSTALLSET_UEFI_NEEDS_REBOOT_LABEL).hide();
						}
						$(INSTALLSET_DIALOG_TITLE, installsetDialogContents).html(installset.name);
						$(INSTALLSET_DESC, installsetDialogContents).html(' <b>' + installset.description + '</b>');
						$(INSTALLSET_COMP_TOTAL, installsetDialogContents).html('<b>' + installset.components.component.length + '</b>');
						$(INSTALLSET_SIZE, installsetDialogContents).html(installset_size);
						$(INSTALLSET_ISRECOVERYSET, installsetDialogContents).html(isRecoverySetvalue);
						$(INSTALLSET_DATECREATED, installsetDialogContents).html(' <b>' + installset.date + '</b>');
						$(INSTALLSET_SUM_COMPS, installsetDialogContents).html('<b>' + sumComponentsCount + '</b>');
						$(INSTALLSET_UEFI_COMPS, installsetDialogContents).html('<b>' + uefiComponentsCount + '</b>');
						$(INSTALLSET_ILO_COMPS, installsetDialogContents).html('<b>' + iLOComponentsCount + '</b>');						
                        // populate components table.
						var options = {
						    command: 'init',
						    data: data
						};
						var INSTALLSET_COMPTABLE_TITLE = "#installset_table_title";
						$(INSTALLSET_COMPTABLE_TITLE, installsetDialogContents).html(Localizer.getString('hpsum.common.installSetTitle'));
                        //Call plugin to show the component list
						$(INSTALLSET_COMP_TABLE, installsetDialogContents).hpsumInstallSetComponents(options);
						
                    },
                    error: function () {

                    }
                });
            },
			
			onOkButton: function(item)
			{
			    //check if we need to show spinning wheel. 
			    plugin.showDeletingFlash(item);
				presenter.clearInstallSetItem(item, {
                           success : onItemClearSuccess,
							error : onItemClearError
                        });
                        
			},
			showDeleteConfirmDialogBox: function (nodeItem, data) {
			    var contents = $(deleteConfirmHtml);
                var INSTALLSET_DELETE_NODE_ELEMENT = "#hpsum-delete-node";
                var DELETE_CONTENT_ELEMENT = "#hpsum-delete-schedule-info";
                var DELETE_TITLE = "#hpsum-nodes-delete-title";
                $(INSTALLSET_DELETE_NODE_ELEMENT, contents).hide();
                var contentForDelete = "";

                if (installsetAsbaseline)
                {
                    if (l_nodeItem.group != "") {
                        contentForDelete = "<p>" + Localizer.getString('hpsum.common.installsetWarningDuetoGroup') + "<p/>";
                    }
                    else {
                        contentForDelete = "<p>" + Localizer.getString('hpsum.common.installsetDeleteWarningMessage') + "<p/>";
                    }
                }
                if (data.hapi.hasOwnProperty('installset') && data.hapi.installset.id.match(/Unreferenced_Components/i)) {
                    contentForDelete = "<p>" + Localizer.getString('hpsum.common.unrefCompDeleteConfirm') + "<p/>" + contentForDelete;
                } else {
                contentForDelete = "<p>" + Localizer.getString('hpsum.common.installsetDeleteConfirm') + "<p/>" + contentForDelete;
                }
                
              
                
				$(DELETE_TITLE, contents).text(
							Localizer.getString('core.deleteConfirm.title', [presenter.selectionLabel()]));
				$(DELETE_CONTENT_ELEMENT, contents).html(contentForDelete);
				
                Localizer.localizeDom(contents);
				 var item = {
					node_id: nodeItem.node_id,
                    installset_id: data.hapi.installset.id,
					installset_name: data.hapi.installset.name
                };
                //show installset dialog
                var dialog = new DialogView();
                dialog.init({
                    contents: contents,
                    ok: function (elem) {            
                        plugin.onOkButton(item);                        
                        //return true;
                    },
                    cancel: function () {
                        $(this).dialog('close');
                    }
                });
            },
			
            reinitialize: function () {
                if (this.options.nodeItem == undefined) {
                    window.console.error("reinitialize before init is not allowed");
                    return;
                }
                this.initialize(this.element, this.options);

            },

            initialize: function (el, options) {

                presenter.getInstallSets(options.nodeItem, {                    
                success: function (data) {                    
                        l_data = data;
                        l_el = el;
                        l_nodeItem = options.nodeItem;
                        isDeployOption = options.isDeleteExistingItem;
                        plugin.populateInstallSet(data, el, options.nodeItem);    						
                    },
                    error: function (data) {
                        plugin.onPopulateError(el);
                    }
                });
            },
            onPopulateError: function (el) {
                el.text("GetInstallSets failed for this node");
                plugin.options.onPopulateInstallSet(options.nodeItem.node_id);
				
            },
            destroy: function (el) {
                $(this.element).removeClass('hpsumInstallSets');
                $.removeData(this.element, "plugin_" + pluginName);
            }           
        };
		
		function installsetGetStatus(item)
		{
			var timer = setTimeout(function(){
				presenter.getInstallSetStatus(item, {
					success : function(data) {
						if(data.hapi.iloinstallset_status.iloinstallset_id.match(item.installset_id)){
							if(data.hapi.iloinstallset_status.iloinstallset_state.match(/clearing/i))
							{
								//Keep waiting till node state is UAN
								installsetGetStatus(item);
							}
							else if(data.hapi.iloinstallset_status.iloinstallset_state.match(/cleared/i))
							{
								clearTimeout(timer);
								timer = '';
								deleteinstallset(item);
							}
							else if(data.hapi.iloinstallset_status.iloinstallset_state.match(/alive/i))
							{	
								clearTimeout(timer);
								timer = '';
							}
							else if(data.hapi.iloinstallset_status.iloinstallset_state.match(/error/i))
							{	
								clearTimeout(timer);
								timer = '';
								plugin.closeDeletingFlash();
								$(CLOSE_BUTTON).trigger('click');
							}
						}
					},
					error : function(errorInfo) {
						clearTimeout(timer);
						timer = '';
					}
				});	
			}, 3000);
		}
			
		function onItemClearSuccess(data, item) {
			installsetGetStatus(item);
		}
		
		function closeDeleteFlashAndPopulateIS(data, item)
		{
		    plugin.closeDeletingFlash();
		    $(CLOSE_BUTTON).trigger('click');
		    plugin.populateInstallSet(data, l_el, item);
		}

		function deleteinstallset(item){
			//var plugin = this;
			presenter.removeInstallSetItem(item, {
			   success : function(data){
				    presenter.getInstallSets(item, {
				        success: function (data) {
				            if (installsetAsbaseline) {
				                //get node status, if state transition is over, go ahead and close the splash.
				                var progressTimer = setInterval(function () {

				                    presenter.getNodeStatus(l_nodeItem, {
				                        success: function (data) {
				                            if (data.hapi.node_status.node_state === "IDLE") {
				                                clearInterval(progressTimer);
				                                closeDeleteFlashAndPopulateIS(data, item);
				                            }
				                        },
				                        error: function (errorInfo) {
				                            clearInterval(progressTimer);
				                            closeDeleteFlashAndPopulateIS(data, item);
				                        }
				                    });
				                }, 3000);
				            }
		                        else {
				                closeDeleteFlashAndPopulateIS(data, item);
				            }
				        },
                    error: function (data) {
						closeDeleteFlashAndPopulateIS(data, item);
                        plugin.onPopulateError(l_el);
                    }
                });
			   },
				error : onItemClearError
			});
		}
            /**
             * @private
             */
        function onItemClearError(errorMessage, item) {
            //notificationsView.add({summary:errorMessage}, true);
        }
			
        // A really lightweight plugin wrapper around the constructor,
        // preventing against multiple instantiations
        $.fn[pluginName] = function (options) {
            var instance;
            if (typeof options === 'string') {
                // call method
                var args = Array.prototype.slice.call(arguments, 1);
                this.each(function () {
                    instance = $.data(this, "plugin_" + pluginName);
                    if (!instance) {
                        if (!options.match(/destroy/i)) {
                            if (window.console) {
                                window.console.error("cannot call methods on hpInstallSets prior to initialization; " +
                                    "attempted to call method '" + options + "'");
                            }
                        }
                        return;
                    }
                    if (!$.isFunction(instance[options]) || options.charAt(0) === "_") {
                        if (window.console) {
                            window.console.error("no such method '" + options + "' for hpInstallSets instance");
                        }
                        return;
                    }
                    // apply method
                    instance[options].call(instance, args);
                });
            }
            else {
                return this.each(function () {
                    if (!$.data(this, "plugin_" + pluginName)) {
                        $.data(this, "plugin_" + pluginName, new Plugin(this, options));
                    }

                });
            }
        };


    } (jQuery));
});

