define(['hpsum/presenter/node/NodePresenter',
                                'hpsum/presenter/baseline/BaselinePresenter',
                                'hp/core/EventDispatcher',
                                'hp/core/Localizer', 
                                'hp/view/DialogView',
                                'text!hpsumpages/node/component_dialog.html',   
                                'jquery', 
                                'hp/lib/jquery.hpStatus',
                                'lib/jquery.dataTables',
                                'hp/lib/jquery.hpCollapsible',
                                'hp/lib/jquery.hpToggle'], 
function(presenter,baselinePresenter, EventDispatcher, localizer,DialogView,componentDialogHtml) {"use strict";
                (function($) {
                                // Create the defaults once
                                var pluginName = "hpsumInstallables",
        defaults = {
            nodeItem: null
        };
                                var selectedRows = [];
                                var failed_dep_count = 0;
                                var sortDirection = 'desc', sortColumn = 3;
								var l_data = null;
								var l_el = null;
								var l_nodeItem = null;
								var GOLD_PIC_FAMILY = 'FBWC', SubTypeQLogic = 'QLOGIC', SubTypeGoldPIC = 'GOLDPIC';
								var REBOOT_REQ_DETAILS_REQUIRED = "Required",
									REBOOT_REQ_DETAILS_NO = "No",
									REBOOT_REQ_DETAILS_YES = "yes",
									REBOOT_REQ_DETAILS_OPTIONAL = "Optional",
									REBOOT_REQ_DETAILS_ENVIRONMENTDEPENDENT = "Environment Dependent",
									REBOOT_DEFAULT_NO = false,
									REBOOT_DEFAULT_YES = true;
                                function initInstallReviewTable(tableid) {
                                                var oTab = $(tableid).dataTable({
                                                                oLanguage : {
                                                                                sEmptyTable : localizer.getString("hpsum.node.noApplicableComponentsFound"),
                    sSearch: localizer.getString("hpsum.common.search")
                                                                },
                                                                bPaginate : false,
                                                                bProcessing : true,
                                                                bFilter : true,
                                                                bSort : true,
                                                                bAutoWidth : false,
                                                                bInfo : false,
                                                                bRetrieve : true,
                                                                bDestroy : true,
                                                                //aaData: data,
                                                                aoColumns : [
                                                                {mDataProp: 'group_id', "bVisible": false},
                                                                {
                                                                                mDataProp : 'selected'
                                                                },
                                                                {
                                                                 mDataProp : 'name',
																	 fnRender: function (oObj) {
																		 var name =oObj.aData.name;
																		 var compid = oObj.aData.component_id;
																		 compid.replace(/(:|\.)/g,'_');                     if (oObj.aData.sig_file_exists.match(/No/i)){                                                                    return '<div id="hpsum-' + compid + '-packageStr" class="">' + name + '</br> <img src="/img/hp-piano/status-warning.png"/   <b><label id="hpsum-' + compid + '-sig_file_missing_warning" align="center" class="">' + localizer.getString("hpsum.common.compsigMissingMessage") + '</label></b></div>';                                                                                                                               }
                                        else{
	return  '<div id="hpsum-'+ compid +'-packageStr" class="">'+ name + '</div>'                                                                                                                              }											}
																}, {
                                                                                                mDataProp : 'status',
                                                                                }, {
                                                                                    mDataProp : 'product_type',
                                                                                    fnRender: function (oObj) {
                                                                                        
                                                                                        switch (oObj.aData.product_type.toUpperCase()) {
                                                                                            case 'FIRMWARE':
                                                                                                return localizer.getString("hpsum.common.firmware");
                                                                                            case 'DRIVER':
                                                                                                return localizer.getString("hpsum.common.driver");
                                                                                            case 'PCI':
                                                                                                return localizer.getString("hpsum.common.pci");
                                                                                            case 'UTILITY':
                                                                                                return localizer.getString("hpsum.common.utility");
                                                                                            case 'SOFTWARE':
                                                                                                return localizer.getString("hpsum.common.software");
                                                                                            default:
                                                                                                
                                                                                                return oObj.aData.product_type;

                                                                                        }
                                                                                    }
                                                                                                }, {
                                                                                                mDataProp : 'product_sub_type',
                                                                                                    fnRender: function (oObj) {
                                                                                    
                                                                                                        switch (oObj.aData.product_sub_type.toUpperCase()) {
                                                                                                            case "RECOMMENDED": return localizer.getString("hpsum.common.recommended"); break;
                                                                                                            case "OPTIONAL": return localizer.getString("hpsum.node.optional"); break;
                                                                                                            case "CRITICAL": return localizer.getString("hpsum.common.critical"); break;
                                                                                                            case "UNKNOWN": return localizer.getString("hpsum.baseline.custom.unknown"); break;
                                                                                                            
                                                                                                            default:
                                                                                                                    return oObj.aData.product_sub_type;
                                                                                                        }

                                                                                                    }
                                                                                                }, {
                                                                                                                mDataProp : 'installed_version',
                                                                                                                fnRender: function(oObj){
                                                                                                                                var version = oObj.aData.installed_version;
                                                                                                                                var device_info = oObj.aData.device_info;
                                                                                                                                if((version == '') && (device_info != ''))
                                                                                                                                    return '<a id="device_info" href="javascript:void(0);" class ="company-a">' + localizer.getString('hpsum.common.viewDetails') + '</a>';
                                                                                                                                else
                                                                                                                                                return version;
                                                                                                                }
                                                                                                                
                                                                                                }, {
                                                                                                                mDataProp : 'active_version',
                                                                                                                fnRender: function(oObj){
                                                                                                                                var version = oObj.aData.active_version;
                                                                                                                                var device_info = oObj.aData.device_info;
                                                                                                                                if((version == '') && (device_info != ''))
                                                                                                                                    return '<a id="device_info" href="javascript:void(0);" class ="company-a">' + localizer.getString('hpsum.common.viewDetails') + '</a>';
                                                                                                                                else
                                                                                                                                                return version;
                                                                                                                },
                                                                                                                "bVisible": false
                                                                                                                
                                                                                                }, {
                                                                                                                mDataProp : 'available_version',
                                                                                                                fnRender: function (oObj) {
                                                                                                                                var version = oObj.aData.available_version;
                                                                                                                                return '<a id="revision_history" href="javascript:void(0);" class="company-a">' + version+ '</a>';
                                                                                                                }														
                                                                                                }, 
																								{
                                                                                                                mDataProp : 'reboot_required',
                                                                                                                fnRender: function (oObj) {
																													var compId = oObj.aData.component_id;
																													compId = compId.replace(/(:|\.)/g,'_');
																													switch (oObj.aData.reboot_required) {
                                                                                                                            case REBOOT_REQ_DETAILS_REQUIRED:
                                                                                                                               return  '<div id="hpsum-'+ compId + '" align="center" class=""><div>'+ localizer.getString("hpsum.common.reboot_details.value.required") +'</div></div>'; break;
																															case REBOOT_REQ_DETAILS_OPTIONAL:
																																return '<div id="hpsum-'+ compId + '" align="center" class="">' + localizer.getString("hpsum.common.reboot_details.value.optional") +'</div>'; break;
																															case REBOOT_REQ_DETAILS_ENVIRONMENTDEPENDENT:
																																return '<div id="hpsum-'+ compId + '" align="center" class="">' + localizer.getString("hpsum.common.reboot_details.value.environmentdependent") +'</div>'; break;
																															case REBOOT_REQ_DETAILS_NO:
																																return '<div id="hpsum-'+ compId + '" align="center" class="">' + localizer.getString("hpsum.common.reboot_details.value.no") +'</div>'; break;
																															case REBOOT_DEFAULT_YES:
																																return '<div id="hpsum-'+ compId + '" align="center" class="">' + localizer.getString("hpsum.common.reboot_details.value.required") +'</div>'; break;
																															default :
																																return '<div id="hpsum-'+ compId + '" align="center" class="">' + localizer.getString("hpsum.common.reboot_required.value.no") +'</div>'; break;
                                                                                                                }	
																												}																												
                                                                                                }, 
                                                                                                
                                                                                                //{mDataProp: 'has_failed_dependencies'},
                                                                                                {mDataProp: 'comp_installable_type', "bVisible": false},
                                                                                                {mDataProp: 'baseline_details', "bVisible": false}, 
                                                                                                {
                                                                                                                mDataProp : 'file_name',
                                                                                                                "bVisible" : false
                                                                                                }, {
                                                                                                                mDataProp : 'component_id',
                                                                                                                "bVisible" : false
                                                                                                }, {
                                                                                                                mDataProp : 'failed_deps',
                                                                                                                "bVisible" : false
                                                                                                },                                                                                                 
                                                                                                {mDataProp: 'group_name', "bVisible": false}, 
                                                                                                {
                                                                                                                mDataProp : 'device_info',
                                                                                                                "bVisible" : false
                                                                },
																{mDataProp: 'need_prereqinstall', "bVisible": false}],
                                                                fnCreatedRow:function(nRow, aData, iDataIndex){
                                                                                if(aData.status.match(/ok|selected/i))
                                                                                                                                nRow.className += ' hp-selected ' + aData.group_id;
                                                                                                else{
                                                                                                                                if(aData.status.match(/selectable/i))
                                                                                                                                                nRow.className += ' ' + aData.group_id;
                                                                                                                                else
                                                                                                                                                nRow.className += ' hp-disabled ' + aData.group_id;
                                                                                                                }
                                                                },
                                                                //aaSorting : [],
                                                                fnRowCallback : function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                                                                                //nRow.className += ' ' + aData.group_id;
                                                                                return nRow;
                                                                },
                                                                "fnDrawCallback": function ( oSettings ) {
                                                                                if ( oSettings.aiDisplay.length == 0 )
                                                                                {
                                                                                                return;
                                                                                }
                                                                                
                                                                                var nTrs = $(tableid + ' tbody tr');
                                                                                var iColspan = nTrs[0].getElementsByTagName('td').length;
                                                                                var sLastGroup = "";
                                                                                for ( var i=0 ; i<nTrs.length ; i++ )
                                                                                {
                                                                                                var iDisplayIndex = oSettings._iDisplayStart + i;
                                                                                                var sGroup = oSettings.aoData[ oSettings.aiDisplay[iDisplayIndex] ]._aData.group_id;
                                                                                                var sGroupName = oSettings.aoData[ oSettings.aiDisplay[iDisplayIndex] ]._aData.group_name;
                                                                                                if(sGroup == ''){
                                                                                                                sLastGroup = sGroup;
                                                                                                                continue;
                                                                                                }
                                                                                                if ( sGroup != sLastGroup )
                                                                                                {
                                                                                                                var nGroup = document.createElement( 'tr' );
                                                                                                                nGroup.className='hp-disabled';
                                                                                                                var nCell = document.createElement( 'td' );
                                                                                                                nCell.colSpan = iColspan;
                                                                                                                nCell.className = "group";
                                                                                                                nCell.innerHTML = '<b>' + sGroupName + '</b>';
                                                                                                                nGroup.appendChild( nCell );
                                                                                                                nTrs[i].parentNode.insertBefore( nGroup, nTrs[i] );
                                                                                                                sLastGroup = sGroup;
                                                                                                }
                                                                                }
                                                                                $('.group').css({'background-color': '#dddddd'});
                                },
                                "aaSortingFixed": [[ 0, 'asc' ]],
                                "aaSorting": [[ sortColumn, sortDirection ]], //by default, the sorting is done on Ready to proceed column
                                "sDom": 'lfr<"giveHeight"t>ip'
                                                });

                                                $(tableid + ' tbody tr').first().addClass('hp-selected');
                                                
                                    $(tableid).unbind('sort').bind('sort', function (e, dt) {
                                                    sortDirection = dt.aaSorting[0][1];
                                                    sortColumn = dt.aaSorting[0][0];
                                                });
                                }
    // The actual plugin constructor
    function Plugin( element, options ) {
        this.element = element;

        // jQuery has an extend method which merges the contents of two or
        // more objects, storing the result in the first object. The first object
        // is generally empty as we don't want to alter the default options for
        // future instances of the plugin
        this.options = $.extend( {}, defaults, options );
                                this.dispatcher = new EventDispatcher();
        this._defaults = defaults;
        this._name = pluginName;

        this.init();
    }

    Plugin.prototype = {

        init: function() {
                                                $(this.element).addClass('hpsumInstallables');
                                                if(this.options.command =='init')
                                this.calculate(this.element, this.options);

        },
        getComponents:function(el){
                if(this.options.nodeItem == null)
                                return false;
                var nodeItem = this.options.nodeItem;				
                var tableid = '#hpsum-otu-installables-' + nodeItem.node_id+ '-table';
                var currTable= $(tableid).dataTable();
                                                var componentsList = {
                                                                hapi : {
                                                                                components : {
                                                                                                component : []
                                                                                }
                                                                }
                                                };
                                                var rowsSelected = currTable.fnGetNodes();;
                                                //rowsSelected contains the entire list of components to be installed.
                for (var tmp = 0; tmp < rowsSelected.length; tmp++) {
                                                                var compData = currTable.fnGetData(rowsSelected[tmp]._DT_RowIndex);
                                                                if(compData == null)
                                                                                continue;
                                                                var bselected = false, bforce = false;

                                                                if (rowsSelected[tmp].className.indexOf('hp-selected') != -1)
                                                                                bselected = true;
                                                                else
                                                                                bselected = false;
                                                                if (bselected && rowsSelected[tmp].firstChild.firstChild) 
                                                                {
                                                                                if ($(rowsSelected[tmp]).find("li:first")[0].innerHTML.match(localizer.getString("hpsum.oneTouchUpdate.forced"))){
                                                                                                bforce = true;
                                                                                }
                                                                }
                                                                var item = {
                                                                                component_name : compData.file_name,
                                                                                selected : bselected,
                                                                                force : bforce
                                                                };

                                                                componentsList.hapi.components.component.push(item);
                                                }
                return componentsList;
        },
        getSelectedComponents: function (id) {
            
                 if(id == null)
                                return false;
                var tableid = '#hpsum-otu-installables-' + id+ '-table';
                var currTable= $(tableid).dataTable();
				var sigFileMissingCount = 0;
				var need_prereqinstall=0;
                var selectedList = {
                    failed_dependency: 0, is_sigfile_available: "NA", is_typec_comp_selected : false,need_prereqinstall:false,
                                                                                component:[]};
                if($(tableid).length == 0)
                                return selectedList;
                var rowsSelected = currTable.fnGetNodes();
                var typeCCompSelectedCount = 0;
                for (var tmp = 0; tmp < rowsSelected.length; tmp++) {
                                                                var compData = currTable.fnGetData(rowsSelected[tmp]._DT_RowIndex);
                                                                if (rowsSelected[tmp].className.indexOf('hp-selected') != -1){
                                                                                if(compData){
                                                                                selectedList.component.push(compData.file_name);
                                                                        if (compData.failed_deps != '') {
                                                                                                selectedList.failed_dependency++;
                                                                                }
                                                                        if (compData.sig_file_exists.match(/No/i)) {
																			sigFileMissingCount++;
                                                                        }
																		if(compData.need_prereqinstall==true)
																		{
																			need_prereqinstall++;
																		}
                                                                        if (compData.hasOwnProperty('comp_installable_type')) {
                                                                            if ((compData.comp_installable_type.length == 1) && compData.comp_installable_type[0].match(/C/i)) {
                                                                                typeCCompSelectedCount++;
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                                                
                                                }
												if(sigFileMissingCount > 0)
												{
													selectedList.is_sigfile_available = false;
												}
												else
												{
													selectedList.is_sigfile_available = true;
												}
												if (typeCCompSelectedCount > 0)
												{
												    selectedList.is_typec_comp_selected = true;
												}
												else {
												    selectedList.is_typec_comp_selected = false;
												}
												if(need_prereqinstall>0)
												{
													selectedList.need_prereqinstall =true;
												}
                                                return selectedList;  },
		
		setUpdatedList: function(item)
		{
			if(this.options.hasOwnProperty("onUpdatedList"))
			{
				this.options.onUpdatedList(item);
			}
		},
		
        populateInstallSet: function(data,id, nodeItem){
                if(data.length == 0 && id == undefined && nodeItem == undefined)
				{
					data = l_data;
					id = l_el;
					nodeItem = l_nodeItem;
				}
				var plugin =this;
                var deployflag = false, analysisflag = false, fips_mode = false;
				if(data.hasOwnProperty("hapi") && data.hapi.hasOwnProperty("baselines"))
				{
					this.setUpdatedList(data.hapi.baselines);
				}
                                                failed_dep_count = 0;
                    
                                                $(id).empty();
                                                this._defaults.nodeItem =nodeItem;
												$(id).append('<div class="hp-notify hp-notify-warning" id="uefi-compselection-warning">'  + localizer.getString("hpsum.node.uefiCompSelectionWarning") + '</div>');
												$(id).append('<div class="hp-notify hp-notify-warning" id="esxi-downgrade-compselection-warning">'  + localizer.getString("hpsum.node.EsxiDowngradeCompSelectionWarning") + '</div>');
												$(id).append('<div><b>'+localizer.getString("hpsum.oneTouchUpdate.totalComponentsApplicable")+'<label style="width:100px;" id="applicable-component-number-' + nodeItem.node_id+'"></label></b></div><br>');
                                                $(id).append('<div><b>'+localizer.getString("hpsum.oneTouchUpdate.totalComponentsSuggested")+'<label style="width:100px;" id="suggested-component-number-' + nodeItem.node_id+'"></label></b></div><br>');
                                                $(id).append('<div><b>'+localizer.getString("hpsum.oneTouchUpdate.totalComponentsSelected")+'<label style="width:100px" id="selected-component-number-' + nodeItem.node_id+'"></label></b></div><br>');
												$(id).append('<input id="hpsum-selectall-comp" type="checkbox" style="padding-left:10px;display:none;" />' +  
												'<label id="hpsum-selectall-comp-lbl" for="hpsum-selectall-comp" style="padding-right:100px;display:none;">' + localizer.getString("hpsum.oneTouchUpdate.selectAll") + '</label>'); 
												$(id).append('<input id="hpsum-deselectall-comp" type="checkbox" style="padding-left:10px;display:none;" />' + 		
												'<label id="hpsum-deselectall-comp-lbl" for="hpsum-deselectall-comp" style="display:none" >' + localizer.getString("hpsum.oneTouchUpdate.deselectAll") + '</label>');
                                                $(id).append('<table class="hp-selectable" id="hpsum-otu-installables-' + nodeItem.node_id + '-table"><thead><tr><td></td><td><b>'+
                                                                                                                                localizer.getString("hpsum.oneTouchUpdate.selectComponents") + '</b></td><td><b>' + 
                                                                                                                                localizer.getString("hpsum.oneTouchUpdate.packageStr") + '</b></td><td><b>' + 
                                                                                                                                localizer.getString("hpsum.oneTouchUpdate.statusStr") + '</b></td><td><b>' +
                                                                                                                                localizer.getString("hpsum.oneTouchUpdate.reports.type") + '</b></td><td><b>' +
                                                                                                                                localizer.getString("hpsum.oneTouchUpdate.criticality") + '</b></td><td><b>' + 
                                                                                                                                localizer.getString("hpsum.oneTouchUpdate.installedVersion") + '</b></td><td><b>' + 
                                                                                                                                localizer.getString("hpsum.oneTouchUpdate.activeVersion") + '</b></td><td><b>' + 
                                                                                                                                localizer.getString("hpsum.oneTouchUpdate.availableVersion") + '</b></td><td><b>' +
                                                                                                                                localizer.getString("hpsum.common.rebootRequired") + '</b></td><td><b>' +
                                                                                                                                localizer.getString("hpsum.node.sigFileExists") + '</b></td><td></td><td></td><td></td><td></td></tr></thead></table>');
                                                initInstallReviewTable('#hpsum-otu-installables-' + nodeItem.node_id + '-table');
                                                var currtableId = '#hpsum-otu-installables-' + nodeItem.node_id + '-table';
                                                var currTable = $('#hpsum-otu-installables-' + nodeItem.node_id + '-table').dataTable();
												var SELECTALL_COMP = '#hpsum-selectall-comp';
												var SELECTALL_COMP_LBL = '#hpsum-selectall-comp-lbl';
												var DESELECTALL_COMP = '#hpsum-deselectall-comp'
												var DESELECTALL_COMP_LBL = '#hpsum-deselectall-comp-lbl';
                                                if($(currtableId).length)
                                                                currTable.fnClearTable();
                                                var baselineslist = data.hapi.baselines;
                                                var componentMap = {}, componentAdded = {}, compCount = 0;
                                                var sigFileExists = "NA";
                                                if (currTable && baselineslist) {
                                                                for (var j = 0; j < baselineslist.baseline.length; j++) {
                                                                                var currbaseline = baselineslist.baseline[j];
                                                                                if (currbaseline.hasOwnProperty("components")) {
																								//Display Select/Deselect All Checkbox
																								$(SELECTALL_COMP).show();
																								$(DESELECTALL_COMP).show();
																								$(SELECTALL_COMP_LBL).show();
																								$(DESELECTALL_COMP_LBL).show();
                                                                                                var comps = currbaseline.components.component;
                                                                                                for (var k = 0; k < comps.length; k++){
                                                                                                                var comp = comps[k];
																												if ((comp.product_family_name.toUpperCase() === GOLD_PIC_FAMILY) && ((comp.product_sub_type.toUpperCase() === SubTypeQLogic) || (comp.product_sub_type.toUpperCase() === SubTypeGoldPIC)))
																												{
																													var group_id= GOLD_PIC_FAMILY + SubTypeGoldPIC;
																												} else {
																													var group_id= comp.product_family_name + comp.product_sub_type;
																												}
                                                                                                                var comp_id_redefined = comp.component_id.replace(/\./g,'_');
                                                                                                                if(componentMap[group_id] == undefined )
                                                                                                                                componentMap[group_id] = comp_id_redefined;
                                                                                                                else
                                                                                                                                componentMap[group_id] += comp_id_redefined;
                                                                                                }
																								compCount += comps.length;
                                                                                }
                                                                }
                                                                $("#applicable-component-number-" + nodeItem.node_id+"").text(compCount);
                                                                for (var j = 0; j < baselineslist.baseline.length; j++) {
                                                                                var currbaseline = baselineslist.baseline[j];
                                                                                if (currbaseline.hasOwnProperty("components")) {
                                                                                                var comps = currbaseline.components.component;
                                                                                                
                                                                                                var baseline_details= {baseline_id:currbaseline.baseline_id,
                                                                                                                location_id:currbaseline.location_id  };
                                                                                                //first add all the selected components
                                                                                                for (var k = 0; k < comps.length; k++) {
                                                                                                                var comp = comps[k];
                                                                                                                if(componentAdded[comp.component_id]!=true)
                                                                                                                {
																												fips_mode = false;
                                                                                                                var stat = '', forcetoggle = '', comp_id = comp.component_id, comp_name = ' (' + comp_id + ')', selectedtoggle = '', isSelected = '';
                                                                                                                var comp_id_refined = comp_id.replace(/\./g,'_');

                                                                                                                if(comp.selected){
                                                                                                                                stat = '<div class="hp-status"><div class="hp-status-value hp-status-ok tooltip" tooltip="'+localizer.getString("hpsum.node.readyToProceedToolTip")+'"><span class="hp-value">ok</span></div></div>';
                                                                                                                                isSelected = 'selected';
                                                                                                                                if(comp.is_forced == true)
                                                                                                                                                forcetoggle = '<input id="toggle-' + comp_id_refined + '-' + nodeItem.node_id + '" type="checkbox" checked/>';
                                                                                                                                else
                                                                                                                                                selectedtoggle = '<input id="selectToggle-' + comp_id_refined + '-' + nodeItem.node_id + '" type="checkbox" checked/>';
                                                                                                                }
                                                                                                                else {
                                                                                                                    stat = '<div id="selectable" class="hp-status"><div class="hp-status-value tooltip hp-status-disabled" tooltip="' + localizer.getString("hpsum.node.compUpToDateToolTip") + '"><span class="hp-value">disabled</span></div></div>';
                                                                                                                                if (comp.is_forcible === true)
                                                                                                                                                forcetoggle = '<input id="toggle-' + comp_id_refined + '-' + nodeItem.node_id + '" type="checkbox" />';
                                                                                                                                else if(comp.is_selectable == true)
                                                                                                                                                selectedtoggle = '<input id="selectToggle-' + comp_id_refined + '-' + nodeItem.node_id + '" type="checkbox" />';
                                                                                                                                else
                                                                                                                                                selectedtoggle = '<input id="selectToggle-' + comp_id_refined + '-' + nodeItem.node_id + '" type="checkbox" disabled />';
                                                                                                                }
                                                                                                                
                                                                                                                if(forcetoggle != '')
                                                                                                                                selectedtoggle = forcetoggle;
                                                                                                                
                                                                                                                var failed_deps = '';

																																																																											if (comp.sig_file_present.match(/No/i)) {
																																																																											    stat = '<div id="' + isSelected + '" class="hp-status"><div class="hp-status-value tooltip hp-status-warning" tooltip="' + localizer.getString("hpsum.node.CompSigToolTip") + '"><span class="hp-value">warning</span></div></div>'
																												} 
	
                                                                                                                if (comp.has_failed_dependencies === true) {
                                                                                                                    stat = '<div id="' + isSelected + '" class="hp-status"><div class="hp-status-value tooltip hp-status-error" tooltip="' + localizer.getString("hpsum.node.dependencyErrorsToolTip") + '"><span class="hp-value">error</span></div></div>';
                                                                                                                                failed_deps = comp.failed_dependencies.failed_dependency;
                                                                                                                                
                                                                                                                                //disable deploy button if failed dependency component is selected
																																// Failed dependency count should be only for selected component
                                                                                                                                if(comp.selected){
																																	failed_dep_count++;
                                                                                                                                    deployflag = false;
																																}
                                                                                                                }
																												
                                                                                                          if ((comp.product_family_name.toUpperCase() === GOLD_PIC_FAMILY) && ((comp.product_sub_type.toUpperCase() === SubTypeQLogic) || (comp.product_sub_type.toUpperCase() === SubTypeGoldPIC)))
																												{
																													var group_id= GOLD_PIC_FAMILY + SubTypeGoldPIC;
					 																							} else {
																													var group_id= comp.product_family_name + comp.product_sub_type;
																												}
                                                                                                                var group_name = '';
                                                                                                                var componentName  = comp.name + comp_name;
                                                                                                                if(componentMap[group_id] === comp_id_refined){
                                                                                                                                group_id  = '';
                                                                                                                                group_name ='';
                                                                                                                }
                                                                                                                else{
                                                                                                                                group_id = componentMap[group_id];
                                                                                                                                group_name = comp.name;
                                                                                                                                componentName = comp_id;
                                                                                                                                
                                                                                                                }
                                                                                                                var installedVersion ='', activeVersion='';
                                                                                                                if(nodeItem.type.match(/ilo_federation/i)){
                                                                                                                                var installedVersion ='';
                                                                                                                                if(comp.hasOwnProperty("installed_versions_list")){
                                                                                                                                                if(comp.installed_versions_list.hasOwnProperty("installed_version")) {
                                                                                                                                                                for(var it=0; it < comp.installed_versions_list.installed_version.length; it++ ) {
                                                                                                                                                                                if(it != 0)
                                                                                                                                                                                                installedVersion += ', ';
                                                                                                                                                                                installedVersion += comp.installed_versions_list.installed_version[it];
                                                                                                                                                                }              
                                                                                                                                                }
                                                                                                                                //else
                                                                                                                                                //installedVersion = comp.installed_version;
                                                                                                                                }

                                                                                                                                var re = new RegExp(comp.installed_version, "g");
                                                                                                                                if(!installedVersion.match(re))
                                                                                                                                                installedVersion += ", " + comp.installed_version;
                                                                                                                                installedVersion= "\<div class=\"hp-ellipsis\"\  style=\"width:100px; color:#00B388\">"+ installedVersion +"\<\/div\>";
                                                                                                                                activeVersion= "\<div class=\"hp-ellipsis\"\  style=\"width:100px; color:#00B388\">"+ installedVersion +"\<\/div\>";
                                                                                                                }
                                                                                                                else{
                                                                                                                                installedVersion = comp.installed_version;
                                                                                                                                activeVersion = comp.active_version;
                                                                                                                }
																							
                                                                                                                var reboot_required;
													
																												if(comp.reboot_details.length == 0)
																												{
																													if(comp.reboot_required == REBOOT_DEFAULT_YES){
                                                                                                                            reboot_required = comp.reboot_required;
																													}
																													else if (comp.reboot_required == REBOOT_DEFAULT_NO){
                                                                                                                            reboot_required = comp.reboot_required;
																													}
																												}
																												else{
																													for( var reb = 0; reb < comp.reboot_details.length; reb++) {
																													 if(comp.reboot_details[reb].value == REBOOT_REQ_DETAILS_NO){
																														 reboot_required = comp.reboot_details[reb].value;
																													 }
																													 else if(comp.reboot_details[reb].value == REBOOT_REQ_DETAILS_REQUIRED){
																														 reboot_required = comp.reboot_details[reb].value ;
																													 }
																													 else if(comp.reboot_details[reb].value == REBOOT_REQ_DETAILS_OPTIONAL){
																															reboot_required = comp.reboot_details[reb].value;
																													 }
																													 else if(comp.reboot_details[reb].value == REBOOT_REQ_DETAILS_ENVIRONMENTDEPENDENT){
																															reboot_required = comp.reboot_details[reb].value;
																													 }
																													 else if(comp.reboot_details[reb].value == REBOOT_REQ_DETAILS_YES){
																															reboot_required = comp.reboot_details[reb].value;
																													 }
																												}
																												}
                                                                                                                    //read flag from engine and assign value for this field. 
																												sigFileExists = comp.hasOwnProperty('sig_file_present') ? comp.sig_file_present : "NA"; //false;
																												var comp_installable_type = "";
																												comp_installable_type = comp.hasOwnProperty('component_installable_type') ? comp.component_installable_type : "NA";
																												var compItem = [{
                                                                                                                                'group_id': group_id,
                                                                                                                                'name' : componentName,
                                                                                                                                'status' : stat,
                                                                                                                                'product_type' : comp.product_type,
                                                                                                                                'product_sub_type' : comp.criticality,
                                                                                                                                'installed_version' : installedVersion,
                                                                                                                                'active_version' : activeVersion,
                                                                                                                                'available_version' : comp.available_version,
                                                                                                                                'reboot_required' : reboot_required,
                                                                                                                                'sig_file_exists': sigFileExists,
                                                                                                                                //'has_failed_dependencies': currbaseline.components.component[k].has_failed_dependencies,
                                                                                                                                'force' : forcetoggle,
                                                                                                                                'baseline_details' : baseline_details,
                                                                                                                                'file_name' : comp.file_name,
                                                                                                                                'component_id' : comp.component_id,
                                                                                                                                'failed_deps' : failed_deps,
                                                                                                                                'group_name':group_name,
                                                                                                                                'selected': selectedtoggle,
                                                                                                                                'comp_installable_type' : comp_installable_type,
                                                                                                                                'device_info' : (comp.hasOwnProperty('device_info')) ? comp.device_info : '',
																																'need_prereqinstall':comp.need_prereqinstall
                                                                                                                }];
																												
                                                                                                                if($(currtableId).length)
                                                                                                                                currTable.fnAddData(compItem);
																															
                                                                                                                if (forcetoggle != ""){
                                                                                                                                $('#toggle-' + comp_id_refined + '-' + nodeItem.node_id).hpToggle({
                                                                                                                                                unchecked : localizer.getString("hpsum.oneTouchUpdate.force"),
                                                                                                                                                checked : localizer.getString("hpsum.oneTouchUpdate.forced")
                                                                                                                                });
                                                                                                                }
                                                                                                                if (selectedtoggle != "") 
                                                                                                                                if(comp.is_selectable == false && comp.is_forcible ==  false){
																																				fips_mode = true;
                                                                                                                                                $('#selectToggle-' + comp_id_refined + '-' + nodeItem.node_id).hpToggle({
                                                                                                                                                unchecked : localizer.getString("hpsum.common.disabled"),
                                                                                                                                                checked : localizer.getString("hpsum.common.disabled")
                                                                                                                                });
																																	var warning_message = '';
																																	if(this.options.hasOwnProperty("onShowWarning")) {
																																		if(comp.product_family_name.toUpperCase() === "MCP_SWITCH") {
																																					warning_message = localizer.getString("hpsum.moonshot.switchCompDisabledWarning");
																																		}
																																		else if (comp.product_family_name.toUpperCase() === "MOONSHOT") {
																																					warning_message = localizer.getString("hpsum.moonshot.moonshotCompDisabledWarning");
																																		}
                                                                                                                                        else if (comp.product_family_name.toUpperCase() === "SDFLEX") {
                                                                                                                                                    warning_message = localizer.getString("hpsum.sdflex.sdflexCompDisabledWarning");
                                                                                                                                        }
																																	this.options.onShowWarning(warning_message);
																																	}
																																	
                                                                                                                                }
                                                                                                                                else {
                                                                                                                                $('#selectToggle-' + comp_id_refined + '-' + nodeItem.node_id).hpToggle({
                                                                                                                                                unchecked : localizer.getString("hpsum.oneTouchUpdate.select"),
                                                                                                                                                checked : localizer.getString("hpsum.oneTouchUpdate.selected")
                                                                                                                                });
                                                                                                                                }
																														
																														if(comp.reboot_details.length == 0){
																															if(comp.reboot_required == REBOOT_DEFAULT_NO)
																																$('#hpsum-'+comp_id_refined).attr('tooltip',localizer.getString('hpsum.common.reboot_required.text.no')).hpTooltip();
																															else  if(comp.reboot_required == REBOOT_DEFAULT_YES)
																																$('#hpsum-'+comp_id_refined).attr('tooltip',localizer.getString('hpsum.common.reboot_required.text.yes')).hpTooltip();
																															}
																														else{
																															for( var reb = 0; reb < comp.reboot_details.length; reb++) {
																																if(comp.reboot_details[reb].value == REBOOT_REQ_DETAILS_REQUIRED)
																																	$('#hpsum-'+comp_id_refined).attr('tooltip',localizer.getString('hpsum.common.reboot_details.text.Required')).hpTooltip();
																																if(comp.reboot_details[reb].value == REBOOT_REQ_DETAILS_NO)
																																	$('#hpsum-'+comp_id_refined).attr('tooltip',localizer.getString('hpsum.common.reboot_details.text.No')).hpTooltip();
																																else if(comp.reboot_details[reb].value == REBOOT_REQ_DETAILS_OPTIONAL)
																																	$('#hpsum-'+comp_id_refined).attr('tooltip',localizer.getString('hpsum.common.reboot_details.text.Optional')).hpTooltip();
																																else if(comp.reboot_details[reb].value == REBOOT_REQ_DETAILS_ENVIRONMENTDEPENDENT)
																																	$('#hpsum-'+comp_id_refined).attr('tooltip',localizer.getString('hpsum.common.reboot_details.text.EnvironmentDependent')).hpTooltip();
																																else if(comp.reboot_details[reb].value == REBOOT_REQ_DETAILS_YES)
																																	$('#hpsum-'+comp_id_refined).attr('tooltip',localizer.getString('hpsum.common.reboot_required.text.yes')).hpTooltip();
																														
																																}	
																														}																															
                                                                                                                                componentAdded[comp.component_id] = true;
                                                                                                                }
                                                                                                                }
                                                                                                }
                                                                                }
                                                                                }
																				$('.tooltip').hpTooltip();
                                                                                $('.hp-ellipsis').hpEllipsis();
                                                                                //selectedRows = $('#hpsum-otu-installables-'+ nodeItem.node_id +'-table'+ ' tbody tr');
                                                                                
                                                                                $(currtableId + " tbody tr").click(function(e) {
																				
                                                                                                var srcElem;
                                                                                                                                                //Check if firefox or (chrome and IE)
                                                                                                if (e.srcElement) {
                                                                                                                                                                srcElem = e.srcElement;
                                                                                                                                                                                //Chrome and IE
                                                                                                                                                } else {
                                                                                                                                                                srcElem = e.target;
                                                                                                                                                                //Firefox
                                                                                                                                                }
                                                                                                                                                if(srcElem.id == 'revision_history'){
                                                                                                                                                                var data = currTable.fnGetData(this);
                                                                                                                                                                plugin.showRevisionHistory(data);
                                                                                                                                                                
                                                                                                                                                                return;  
                                                                                                                                                }
                                                                                                                                                else if (srcElem.id == 'device_info'){
                                                                                                                                                                var data = currTable.fnGetData(this);
                                                                                                                                                                var componentsList = {
                                                                                                                                                                                hapi : {
                                                                                                                                                                                                components : {
                                                                                                                                                                                                                component : []
                                                                                                                                                                                                }
                                                                                                                                                                                }
                                                                                                                                                                };
                                                                                                                                                                var item = {
                                                                                                                                                                                component_id : data.component_id,
                                                                                                                                                                                file_name : data.file_name,
                                                                                                                                                                                component_log : '',
                                                                                                                                                                                failed_deps : data.failed_deps,
                                                                                                                                                                                device_info : data.device_info
                                                                                                                                                                };
                                                                                                                                                                componentsList.hapi.components.component.push(item);
                                                                                                                                                                plugin.showComponentDialog(nodeItem,componentsList);
                                                                                                                                                                return;  
                                                                                                                                                }
                                                                                                                                                

                                                                                                                                                if($('.hp-toggle',$(this)).attr("disabled") == "disabled")
                                                                                                                                                                return;
                                                                                                                                                var data = currTable.fnGetData(this);
                                                                                                                                                var clickedCellIndex = srcElem.cellIndex;
                                                                                                                                                if (clickedCellIndex === undefined && data.force != "") {
                                                                                                                                                             
                                                                                                                                                                var forceid = data.force.split('"');
                                                                                                                                                                forceid ='#'+ forceid[1];//+'-hpToggle';
                                                                                                                                                                if(srcElem.innerHTML.match(/Selected/i)){
                                                                                                                                                                                $(forceid).removeAttr('checked');
                                                                                                                                                                                $(forceid).trigger('change');
                                                                                                                                                                             
                                                                                                                                                                } else if(srcElem.innerHTML.match(/Select/i)){
                                                                                                                                                                                $(forceid).prop('checked', true);
                                                                                                                                                                                $(forceid).trigger('change');
                                                                                                                                                                               
                                                                                                                                                                }																																								
                                                                                                                                                               // $('#selected-component-number').text(selected_comp);
                                                                                                                                                                analysisflag = false;
                                                                                                                                                                //$(MULTI_ANALYSIS_BTN).attr("disabled", false);
                                                                                                                                                                                deployflag = true;
                                                                                                                                                                                //$(MULTI_DEPLOY_BTN).attr("disabled", true);
                                                                                                                                                                
                                                                                                                                                                var selectforceid = data.selected.split('"');
                                                                                                                                                                selectforceid ='#'+selectforceid[1];//+'-hpToggle';
                                                                                                                                                                
                                                                                                                                                                if(srcElem.className =='hp-on')
                                                                                                                                                                {
                                                                                                                                                                                if(data.force != '')
                                                                                                                                                                                $(this).addClass('hp-disabled');
                                                                                                                                                                                $(this).removeClass('hp-selected');
                                                                                                                                                                                $(selectforceid).removeAttr('checked');
                                                                                                                                                                }
                                                                                                                                                                else {//row highlighting
                                                                                                                                                                                if(srcElem.className.match(/hp-status-value/i))
                                                                                                                                                                                {
                                                                                                                                                                                                var data = currTable.fnGetData(this);
                                                                                                                                                                                                var componentsList = {
                                                                                                                                                                                                                hapi : {
                                                                                                                                                                                                                                components : {
                                                                                                                                                                                                                                component : []
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                }
                                                                                                                                                                                                };
                                                                                                                                                                                                var item = {
                                                                                                                                                                                                                component_id : data.component_id,
                                                                                                                                                                                                                component_log : '',
                                                                                                                                                                                                                file_name : data.file_name,
                                                                                                                                                                                                                failed_deps : data.failed_deps,
                                                                                                                                                                                                                device_info : data.device_info,
                                                                                                                                                                                                                component_desc: data.name
                                                                                                                                                                                                };
                                                                                                                                                                                                componentsList.hapi.components.component.push(item);
                                                                                                                                                                                                plugin.showComponentDialog(nodeItem,componentsList);
                                                                                                                                                                                                return;
                                                                                                                                                                                }
                                                                                                                                                                                if(srcElem.className.match(/hp-status/i))
                                                                                                                                                                                {
                                                                                                                                                                                     if ($(this).hasClass('hp-disabled')) 
                                                                                                                                                                                                                return;   
                                                                                                                                                                                }
                                                                                                                                                                                $(this).removeClass('hp-disabled');
                                                                                                                                                                                $(this).addClass('hp-selected');
                                                                                                                                                                                $(selectforceid).prop('checked', true);
                                                                                                                                                                                
                                                                                                                                                                                if(data.group_id != ''){
                                                                                                                                                                                                var group = '.' + data.group_id;
                                                                                                                                                                                //var group ='.groupName';
                                                                                                                                                                                                $(group).each(function(item){
                                                                                                                                                                                                                var rdata = currTable.fnGetData(this);
                                                                                                                                                                                                                if(rdata == data)
                                                                                                                                                                                                                                return;
                                                                                                                                                                                                                $(this).removeClass('hp-selected');
                                                                                                                                                                                                                $(this).addClass('hp-disabled');
                                                                                                                                                                                                                if(rdata.force != ''){
                                                                                                                                                                                                                                var id = rdata.force.split('"');
                                                                                                                                                                                                                                id='#'+id[1];//+'-hpToggle';
                                                                                                                                                                $(id).removeAttr('checked');
                                                                                                                                                                $(id).trigger('change');
                                                                                                                                                                                                                }
																																																				if(rdata.selected != ''){
                                                                                                                                                                                                                                var id = rdata.selected.split('"');
                                                                                                                                                                                                                                id='#'+id[1];//+'-hpToggle';
                                                                                                                                                                $(id).removeAttr('checked');
                                                                                                                                                                $(id).trigger('change');
                                                                                                                                                                                                                }
                                                                                                                                                                                                                
                                                                                                                                                                                                });
                                                                                                                                                                                }
                                                                                                                                                                }
                                                                                                                                                                $(selectforceid).trigger('change');
                                                                                                                                                                plugin.setChanged(nodeItem.node_id, true,compCount);
                                                                                                                                                                return;
                                                                                                                                                }

                                                                                                                                                //Select toggle button changes 
                                                                                                                                                var selectid = data.selected.split('"');
                                                                                                                                                selectid='#'+selectid[1];//+'-hpToggle';
                                                                                                                                                if ($(this).hasClass('hp-selected')) {
                                                                                                                                                                $(selectid).removeAttr('checked');
                                                                                                                                                }
                                                                                                                                                else {
                                                                                                                                                                $(selectid).prop('checked', true);
                                                                                                                                                }
                                                                                                                                                $(selectid).trigger('change');
                                                                                                                                                
                                                                                                                                                //toggle row selection
                                                                                                                                                                if(data.group_id != ''){
                                                                                                                                                                                var group = '.' + data.group_id;
                                                                                                                                                                                
                                                                                                                                                                                $(group).each(function(item){
                                                                                                                                                                                                var rdata = currTable.fnGetData(this);
                                                                                                                                                                                                if(rdata == data)
                                                                                                                                                                                                                return;
                                                                                                                                                                                                $(this).removeClass('hp-selected');
                                                                                                                                                                                                if(rdata.force != ''){
                                                                                                                                                                                                                var id = rdata.force.split('"');
                                                                                                                                                                                                                id='#'+id[1];//+'-hpToggle';
                                                                                                                                                $(id).removeAttr('checked');
                                                                                                                                                $(id).trigger('change');
                                                                                                                                                                                                }
                                                                                                                                                                                                if (rdata.selected != '') {
                                                                                                                                                                                                    var id = rdata.selected.split('"');
                                                                                                                                                                                                    id = '#' + id[1];//+'-hpToggle';
                                                                                                                                                                                                    $(id).removeAttr('checked');
                                                                                                                                                                                                    $(id).trigger('change');
                                                                                                                                                                                                }
                                                                                                                                                                                                                
                                                                                                                                                                                });
                                                                                                                                                                }
                                                                                                                                                $(this).toggleClass('hp-selected');
                                                                                                                                                plugin.setChanged(nodeItem.node_id, true,compCount);
                                                                                                                                                //                $(MULTI_ANALYSIS_BTN).attr("disabled", false);
                                                                                                                                                //                $(MULTI_DEPLOY_BTN).attr("disabled", true);
                                                                                                                                });
                                                                                                                $(currtableId + " tbody tr").dblclick(function(e) {
                                                                                                                                                var data = currTable.fnGetData(this);
                                                                                                                                                var componentsList = {
                                                                                                                                                                hapi : {
                                                                                                                                                                                components : {
                                                                                                                                                                                                component : []
                                                                                                                                                                                }
                                                                                                                                                                }
                                                                                                                                                };
                                                                                                                                                var item = {
                                                                                                                                                                component_id : data.component_id,
                                                                                                                                                                component_log : '',
                                                                                                                                                                file_name : data.file_name,
                                                                                                                                                                failed_deps : data.failed_deps,
                                                                                                                                                                device_info : data.device_info,
                                                                                                                                                                component_desc: data.name
                                                                                                                                                };
                                                                                                                                                componentsList.hapi.components.component.push(item);
                                                                                                                                                plugin.showComponentDialog(nodeItem,componentsList);
                                                                                                                                });
																/************************************************/  
                                                                 // QXCR1001441728
																 //Select all components
                                                                $(SELECTALL_COMP).click(function(){
                                                                if ($(SELECTALL_COMP)[0].checked == true){
																	$(DESELECTALL_COMP)[0].disabled = false;
                                                                    $(DESELECTALL_COMP)[0].checked = false;
																	$(SELECTALL_COMP)[0].disabled = true;
                                                                   	
																	var COMPONENTS_TABLE = '#hpsum-otu-installables-' + nodeItem.node_id + '-table';
																	var dataList = $(COMPONENTS_TABLE).dataTable().fnGetData();
																																																			
																	for (var compDoneCount =0 ; compDoneCount < dataList.length ; compDoneCount++)
																	{
																		if(!fips_mode)
																		{
																			var selectid = dataList[compDoneCount].selected.split('"');
																				selectid = '#'+selectid[1];
																				$(selectid).prop('checked', true);
																				$(selectid).trigger('change');
																				$(COMPONENTS_TABLE + ' tbody tr').addClass('hp-selected');
																		}
																																				
																	}
																																
																	plugin.setChanged(nodeItem.node_id, true,compCount);	
                                                                }
                                                                });
																//DeSelect all components
                                                                 $(DESELECTALL_COMP).click(function(){
                                                                 if ($(DESELECTALL_COMP)[0].checked == true){
                                                                    $(SELECTALL_COMP)[0].disabled = false;
																	$(SELECTALL_COMP)[0].checked = false;
																	$(DESELECTALL_COMP)[0].disabled = true;

																	var COMPONENTS_TABLE = '#hpsum-otu-installables-' + nodeItem.node_id + '-table';
																	$(COMPONENTS_TABLE + ' tbody tr').removeClass('hp-selected');
																	var dataList = $(COMPONENTS_TABLE).dataTable().fnGetData();
																	
																	for (var compDoneCount =0 ; compDoneCount < dataList.length ; compDoneCount++)
																	{
																		var selectid = dataList[compDoneCount].selected.split('"');
																		selectid='#'+selectid[1];
																		$(selectid).removeAttr('checked');
																		$(selectid).trigger('change');
																		
																	}
																	plugin.setChanged(nodeItem.node_id, true,compCount);
                                                                                                                               
                                                                }
                                                                });
																						
                                                                /******************************************************/var componentList = this.getSelectedComponents(nodeItem.node_id);
												var suggested_comp;
												suggested_comp = componentList.component.length;
												$("#suggested-component-number-" +nodeItem.node_id+"").text(suggested_comp);																																	
                                                                plugin.setChanged(nodeItem.node_id, false,compCount);
                                                                plugin.installsetChanged(nodeItem.node_id);
																
												if ((nodeItem.type != undefined && nodeItem.type.match(/ilo5/i)) && (nodeItem.os_installed != undefined && !nodeItem.os_installed.match(/Windows/i))) {
													$('#uefi-compselection-warning').css("display","block");
													$('#uefi-compselection-warning').show();
													if ((nodeItem.os_installed != undefined && nodeItem.os_installed.match(/VMware ESXi/i)) && (nodeItem.os_version != undefined && nodeItem.os_version.match(/7.0.0/i))){
														$('#esxi-downgrade-compselection-warning').css("display","block");
														$('#esxi-downgrade-compselection-warning').show();
													}
												}
												else{
													$('#uefi-compselection-warning').css("display","none");
													$('#uefi-compselection-warning').hide();
													$('#esxi-downgrade-compselection-warning').css("display","none");
													$('#esxi-downgrade-compselection-warning').hide();
												}
                                },
                                failedDependencyCount: function(el) {
                                return failed_dep_count;
                                },
                                setChanged: function(id, value,compCount){
                                                var componentList = this.getSelectedComponents(id);
												var selected_comp;
												selected_comp = componentList.component.length;
												$("#selected-component-number-" +id+"").text(selected_comp);
												var SELECTALL_COMP = '#hpsum-selectall-comp';
												var DESELECTALL_COMP = '#hpsum-deselectall-comp'
												if (componentList.failed_dependency > 0)
												{
												    value = false;
												}
												else
												{
												    value = true;
												}
												if(selected_comp == compCount)
												{
													$(SELECTALL_COMP)[0].checked = true;
													$(SELECTALL_COMP)[0].disabled = true;
													$(DESELECTALL_COMP)[0].disabled = false;
													$(DESELECTALL_COMP)[0].checked = false;
												}
												else if(selected_comp == 0)
												{
														$(DESELECTALL_COMP)[0].checked = true;
														$(DESELECTALL_COMP)[0].disabled = true;
														$(SELECTALL_COMP)[0].disabled = false;
														$(SELECTALL_COMP)[0].checked = false;
												}
												else
												{
														$(SELECTALL_COMP)[0].checked = false;
														$(DESELECTALL_COMP)[0].checked = false;
														$(SELECTALL_COMP)[0].disabled = false;
														$(DESELECTALL_COMP)[0].disabled = false;
														
												}
												var COMPONENTS_TABLE = '#hpsum-otu-installables-' + id + '-table';
												var dataList = $(COMPONENTS_TABLE).dataTable().fnGetData();
												for (var compDoneCount =0 ; compDoneCount < dataList.length ; compDoneCount++)
																	{
																	var selectid = dataList[compDoneCount].selected.split('"');
																	if(selectid.length > 4 && selectid[4].match(/Disabled/i)){							
																				$(SELECTALL_COMP)[0].disabled = true;
																				break;
																			}
																	}

                                                this.options.onSelectionChanged(id,value,componentList);
                                },
                                installsetChanged: function(node_id){
                                                this.options.onPopulateInstallSet(node_id);
                                },
                                showRevisionHistory: function(data){
                                                //First sent getComponentData
                                                var item = {baseline_id:data.baseline_details.baseline_id,
                                                                                                location_id:data.baseline_details.location_id,
                                                                                                component_id:data.component_id,
                                                                                                filter: "revision_history"
                                                                                                };
                                                baselinePresenter.getComponentData(item,{
                                                                success:function(data) {
                                                                var componentDialogContents  =$(componentDialogHtml);
                localizer.localizeDom(componentDialogContents);
                //show component dialog
                var dialog = new DialogView();
                dialog.init({contents: componentDialogContents,
                    ok: function (elem) {
                        return true;
                    },
                    cancel: function () {
                    }
                });
                var component= data.hapi.component_data;
                $('#component_title',componentDialogContents).html(localizer.getString("hpsum.oneTouchUpdate.componentDetailsFor", [component.component_file_name]));
                                                                $('#hpsum-ok-button',componentDialogContents).hide();
                $('#hpsum-comp-fail-dep',componentDialogContents).hide();
                            $('#hpsum-comp-inst-notes',componentDialogContents).show();
                            $('#hpsum-device-list-div',componentDialogContents).empty();
                                                                $('#hpsum-comp-user-options', componentDialogContents).hide();
                                                                $('#hpsum-device-list',componentDialogContents).hide();
                                                                $('#hpsum-component-id',componentDialogContents).html(component.package_name);
                                                                var revision= component.revision_history.revision;
                                                                var htmlContents='';
                                                                for(var i=0; i<revision.length; i++){
                                                                                var version = revision[i].version;
                                                                                if(revision[i].revision != '')
                                                                                                version += '('+ revision[i].revision + ')';
                                                                                htmlContents+='<div class="hp-collapsible"><label>'+ version+ '</label>';
                                                                                var enhancement, fixes;
                                                                                enhancement = revision[i].enhancement;
                                                                                                                fixes = revision[i].fixes;
                                                                                                                if(enhancement == '')
                                                                                                                                enhancement =  'None';
                                                                                                                if(fixes == '')
                                                                                                                                fixes ='None'
                                                                                                                
                                                                                                
                                                                                htmlContents+='<div><b><u>Enhancements</u></b></br>'+enhancement+ '</br>'+
                                                                                                                                '<b><u>Fixes</u></b></br>' + fixes+ '</br></div></div>';
                                                                }
                                                                $('#hpsum-component-installation-notes').html(htmlContents);
                                                                $('.hp-collapsible',componentDialogContents).hpCollapsible();
                                                                $('.hp-collapsible',componentDialogContents).hpCollapsible('expand'); 
                                                                },
                                                                error:function(){
                                                                                
                                                                }
                                                });
                                },
                                showComponentDialog:function(nodeItem, data) {
                var componentDialogContents  =$(componentDialogHtml);
                                                                var plugin =this;
                localizer.localizeDom(componentDialogContents);
                //show component dialog
                var dialog = new DialogView();
                dialog.init({contents: componentDialogContents,
                    ok: function (elem) {
                                                                                                var compOptions =  {
                                                                                                                                                hapi: {
                                                                                                                                                                comp_name : data.hapi.components.component[0].file_name,
                                                                                                                                                                device_info : {
                                                                                                                                                                                takes_effect : '',
                                                                                                                                                                                user_options : {
                                                                                                                                                                                                user_option : []
                                                                                                                                                                                },
                                                                                                                                                                                devices : {
                                                                                                                                                                                                device : []
                                                                                                                                                                                }
                                                                                                                                                                }
                                                                                                                                                }
                                                                                                                                };
                                                                                                                                
                                                                                                                                var immediate_flag = true;
                                                                                                                                var deferred_flag = false;
                                                                                                                                for (var idx = 0; idx<deferred_device.length; idx++)
                                                                                                                                {
                                                                                                                                                var device = {
                                                                                                                                                                device_id : deferred_device[idx][0].deviceid,
                                                                                                                                                                isSelected : deferred_device[idx][0].isSelected
                                                                                                                                                }
                                                                                                                                                if(deferred_device[idx][0].isSelected)
                                                                                                                                                                deferred_flag = true;
                                                                                                                                                compOptions.hapi.device_info.devices.device.push(device);
                                                                                                                                }
                                                                                                                                
                                                                                                                                for (var idx = 0; idx<immediate_device.length; idx++)
                                                                                                                                {
                                                                                                                                                var device = {
                                                                                                                                                                device_id : immediate_device[idx][0].deviceid,
                                                                                                                                                                isSelected : immediate_device[idx][0].isSelected
                                                                                                                                                }
                                                                                                                                                if(!immediate_device[idx][0].isSelected)
                                                                                                                                                                immediate_flag = false;
                                                                                                                                                compOptions.hapi.device_info.devices.device.push(device);
                                                                                                                                }
                                                                                                                                for(var idx = 0; idx < user_options.length; idx++)
                                                                                                                                {
                                                                                                                                                var isChecked = $('#user_option'+idx)[0].checked ? "true" : "false";
                                                                                                                                                var options = {
                                                                                                                                                                name: user_options[idx][0].name,
                                                                                                                                                                value: isChecked
                                                                                                                                                }
                                                                                                                                                compOptions.hapi.device_info.user_options.user_option.push(options);
                                                                                                                                }
                                                                                                                                if(immediate_flag && !deferred_flag)
                                                                                                                                                compOptions.hapi.device_info.takes_effect = "immediate";
                                                                                                                                else
                                                                                                                                                compOptions.hapi.device_info.takes_effect = "deferred";
                                                                                                                                presenter.setDeviceInfo(nodeItem, compOptions, {
                                                                                                                                                success : function() {},
                                                                                                                                                error : function() {}
                                                                                                                                });
                        return true;
                    },
                    cancel: function () {
                    }
                });
                
                if(data.hapi.components.component[0].hasOwnProperty('failed_deps'))
                {
                    $('#component_title',componentDialogContents).html(localizer.getString("hpsum.oneTouchUpdate.componentDetails"));
                                if(data.hapi.components.component.length > 0)
                                {
                                                $('#hpsum-comp-fail-dep',componentDialogContents).show();
                                                                                                $('#hpsum-ok-button',componentDialogContents).hide();
                                                $('#hpsum-comp-inst-notes',componentDialogContents).hide();
                                                                                                $('#hpsum-comp-user-options', componentDialogContents).hide();
                                                $('#hpsum-component-id',componentDialogContents).html(data.hapi.components.component[0].component_id);
                                                                                                $('#hpsum-component-help-id').html(data.hapi.components.component[0].component_desc);
                                                                                                
                                                                                                var id= $('#hpsum-component-failed-dep',componentDialogContents);
                                                this.initFailedDependencyTable(id);
                                                
                                                var oFailedDepTable = $(id).dataTable();
                                                
                                                if(oFailedDepTable) {
                                                                                                                oFailedDepTable.fnClearTable();
                                                                for(var i=0; i < data.hapi.components.component[0].failed_deps.length; i++)
                                                                {
                                                                                var item =  [
                                                                                                                                                {
                                                                                                                                                                failed_dependency: data.hapi.components.component[0].failed_deps[i]
                                                                                                                                                }
                                                                                                                                ];
                                                                                oFailedDepTable.fnAddData(item);
                                                                }
                                                }
                                                
                                                                                                if(data.hapi.components.component[0].hasOwnProperty('device_info') && data.hapi.components.component[0].device_info.hasOwnProperty('user_options'))
                                                                                                {
                                                                                                                var immediate_device = [];
                                                                                                                var deferred_device = [];
                                                                                                                var user_options = [];
                                                                                                                var userOptions = {
                                                                                                                                                hapi: {
                                                                                                                                                                comp_name : data.hapi.components.component[0].file_name
                                                                                                                                                }
                                                                                                                };
                                                                                                                presenter.getDeviceInfo (nodeItem, userOptions, {
                                                                                                                                success: function(item) {
                                                                                                                                                $('#hpsum-comp-user-options', componentDialogContents).show();
                                                                                                                                                $('#hpsum-ok-button',componentDialogContents).show();
                                                                                                                                                
                                                                                                                                                var htmlContents = '<ul>';
                                                                                                                                                
                                                                                                                                                for(var idx = 0; idx < item.hapi.device_info.user_options.user_option.length; idx++)
                                                                                                                                                {
                                                                                                                                                                htmlContents += "<li><input type=checkbox id = user_option"+idx+">"+ item.hapi.device_info.user_options.user_option[idx].name +"</li>"
                                                                                                                                                }
                                                                                                                                                htmlContents += "</ul>";
                                                                                                                                                $('#hpsum-component-user-options').html(htmlContents);
                                                                                                                                                
                                                                                                                                                for(var idx = 0; idx < item.hapi.device_info.user_options.user_option.length; idx++)
                                                                                                                                                {
                                                                                                                                                                if(item.hapi.device_info.user_options.user_option[idx].value === "true")
                                                                                                                                                                                $('#user_option'+idx)[0].checked = true;
                                                                                                                                                                else
                                                                                                                                                                                $('#user_option'+idx)[0].checked = false;
                                                                                                                                                                
                                                                                                                                                                var optionitem = [{name : item.hapi.device_info.user_options.user_option[idx].name,
                                                                                                                                                                                                                                value : $('#user_option'+idx)[0].checked
                                                                                                                                                                                                                                }];

                                                                                                                                                                user_options.push(optionitem);
                                                                                                                                                }
                                                                                                                                                if(item.hapi.device_info.hasOwnProperty('devices'))
                                                                                                                                                {
                                                                                                                                                                $('#hpsum-device-list-div',componentDialogContents).empty();
                                                                                                                                                                
                                                                                                                                                                $('#hpsum-device-list',componentDialogContents).show();

                                                                                                                                                                var enable_select;
                                                                                                                                                                
                                                                                                                                                                if(item.hapi.device_info.hasOwnProperty('enable_device_select'))
                                                                                                                                                                                enable_select = item.hapi.device_info.enable_device_select;
                                                                                                                                                                
                                                                                                                                                                $('#hpsum-device-list-div').append('<ul style="padding-left:300px;"><li><input type=checkbox id=all_immediate>'+ localizer.getString('hpsum.node.allImmediate')+'</li><li><input type=checkbox id=all_deferred>'+ localizer.getString('hpsum.node.allDeferred')+'</li></ul>');
                                                                                                                                                                if(enable_select === "false")
                                                                                                                                                                {
                                                                                                                                                                                $('#all_immediate')[0].disabled = true;
                                                                                                                                                                                $('#all_deferred')[0].disabled = true;
                                                                                                                                                                }
                                                                                                                                                                for(var devInd=0; devInd < item.hapi.device_info.devices.device.length; devInd++)
                                                                                                                                                                {
                                                                                                                                                                                var device = item.hapi.device_info.devices.device[devInd];
                                                                                                                                                                                
                                                                                                                                                                                // Use index as table id instead of including device id in case of multiple devices with the same ID
                                                                                                                                                                                // Not sure why use device id, save it into attribute so that could find it if need.
                                                                                                                                                                                var devid = 'deviceid="' + device.device_id.replace(/\W/g, '-') + '"';
                                                                                                                                                                                var headertableid = 'hpsum-devices-header-table-' + devInd;
                                                                                                                                                                                $('#hpsum-device-list-div').append('<table id="' + headertableid + '" ' + devid + '><thead><tr><td></td><td></td><td></td></tr></thead></table>');
                                                                                                                                                                                
                                                                                                                                                                                plugin.initDevicesHeaderTable('#' + headertableid);
                                                                                                                                                                                
                                                                                                                                                                                var headerTable = $('#' + headertableid).dataTable();
                                                                                                                                                                                
                                                                                                                                                                                var headeritem = [{deviceid: "Controller ID: " + device.device_id, 
                                                                                                                                                                                                                                productid: "Product ID: " + device.product_id 
                                                                                                                                                                                                                                }];
                                                                                                                                                                                                                                                                
                                                                                                                                                                                headerTable.fnAddData(headeritem);
                                                                                                                                                                                
                                                                                                                                                                                //replace white spaces with - as element id should not have white spaces
                                                                                                                                                                                var rowtableid = 'hpsum-devices-rows-table-' + devInd; 
                                                                                                                                                                                $('#hpsum-device-list-div',componentDialogContents).append('<table class="hp-selectable" id="' + rowtableid + '" ' + devid + '><thead><tr><td>'+localizer.getString('hpsum.oneTouchUpdate.select')+'</td><td>'+localizer.getString('hpsum.common.type')+'</td><td>'+localizer.getString('hpsum.common.statusStr')+'</td><td>'+localizer.getString('hpsum.oneTouchUpdate.activeVersion')+'</td><td>'+localizer.getString('hpsum.oneTouchUpdate.availableVersion')+'</td><td>'+localizer.getString('hpsum.oneTouchUpdate.activation')+'</td><td>'+localizer.getString('hpsum.common.rebootRequired')+'</td></tr></thead></table>');

                                                                                                                                                                                plugin.initSDDevicesRowTable('#' + rowtableid);
                                                                                                                                                                                
                                                                                                                                                                                var rowTable = $('#' + rowtableid).dataTable();
                                                                                                                                                                                
                                                                                                                                                                                for(var fwInd=0; fwInd < device.fw_item.length; fwInd++)
                                                                                                                                                                                {
                                                                                                                                                                                                var fwitem = device.fw_item[fwInd];
                                                                                                                                                                                                
                                                                                                                                                                                                var rowitem = [{ select:'',
                                                                                                                                                                                                                                                type: fwitem.type, 
                                                                                                                                                                                                                                                fw_item_status: fwitem.fw_item_status,
                                                                                                                                                                                                                                                active_version: fwitem.active_version,
                                                                                                                                                                                                                                                version: fwitem.version,
                                                                                                                                                                                                                                                activation: fwitem.takes_effect === "deferred" ? "Deferred" : "Immediate",
                                                                                                                                                                                                                                                enable_selection: enable_select,
                                                                                                                                                                                                                                                devindex: devInd,
                                                                                                                                                                                                                                                fwindex: fwInd
                                                                                                                                                                                                                                                }];
                                                                                                                                                                                                                                                                                
                                                                                                                                                                                                rowTable.fnAddData(rowitem);
                                                                                                                                                                                                                
                                                                                                                                                                                                if(device.IsSelected)
                                                                                                                                                                                                                $('#device_id'+devInd)[0].checked = true;
                                                                                                                                                                                                else
                                                                                                                                                                                                                $('#device_id'+devInd)[0].checked = false;
                                                                                                                                                                                                                
                                                                                                                                                                                                if(enable_select === "true")
                                                                                                                                                                                                                $('#device_id'+devInd)[0].disabled = false;
                                                                                                                                                                                                else
                                                                                                                                                                                                                $('#device_id'+devInd)[0].disabled = true;
                                                                                                                                                                                                
                                                                                                                                                                                                var device_options =[{deviceid:device.device_id,
                                                                                                                                                                                                                                                                deviceindex:devInd,      
                                                                                                                                                                                                                                                                takes_effect:fwitem.takes_effect,
                                                                                                                                                                                                                                                                isSelected:$('#device_id'+devInd)[0].checked
                                                                                                                                                                                                                                                                }];
                                                                                                                                                                                
                                                                                                                                                                                                if(fwitem.takes_effect === "deferred")
                                                                                                                                                                                                                deferred_device.push(device_options);
                                                                                                                                                                                                else
                                                                                                                                                                                                                immediate_device.push(device_options);
                                                                                                                                                                                }
                                                                                                                                                                                $('#device_id'+devInd).click (function (e) {
                                                                                                                                                                                                var checked = this.checked;
                                                                                                                                                                                                var devindex = parseInt(this.id.substring(9,12));
                                                                                                                                                                                                var deferred_flag = true;
                                                                                                                                                                                                var immediated_flag = true;
                                                                                                                                                                                                
                                                                                                                                                                                                // QXCR1001374655 - dataset is undefined in IE. This is an IE specific change hence 
                                                                                                                                                                                                // using the getAtrribute to fetch the value. 
                                                                                                                                                                                                
                                                                                                                                                                                                if( this.dataset == undefined ) {
                                                                                                                                                                                                                this.dataset = this.getAttribute('data-model');
                                                                                                                                                                                                }
                                                                                                                                                                                                if(this.dataset.model === "Deferred")
                                                                                                                                                                                                {
                                                                                                                                                                                                                for (var idx = 0; idx < deferred_device.length; idx++)
                                                                                                                                                                                                                {
                                                                                                                                                                                                                                if(deferred_device[idx][0].deviceindex === devindex)
                                                                                                                                                                                                                                                deferred_device[idx][0].isSelected = checked;
                                                                                                                                                                                                                                if(deferred_device[idx][0].isSelected !== checked)
                                                                                                                                                                                                                                                deferred_flag = false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if(deferred_flag)
                                                                                                                                                                                                                                $('#all_deferred')[0].checked = checked;
                                                                                                                                                                                                                else if(!checked && !deferred_flag)
                                                                                                                                                                                                                                $('#all_deferred')[0].checked = false;
                                                                                                                                                                                                }
                                                                                                                                                                                                else
                                                                                                                                                                                                {
                                                                                                                                                                                                                for (var idx = 0; idx < immediate_device.length; idx++)
                                                                                                                                                                                                                {
                                                                                                                                                                                                                                if(immediate_device[idx][0].deviceindex === devindex)
                                                                                                                                                                                                                                                immediate_device[idx][0].isSelected = checked;
                                                                                                                                                                                                                                if(immediate_device[idx][0].isSelected !== checked)
                                                                                                                                                                                                                                                immediated_flag = false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if(immediated_flag)
                                                                                                                                                                                                                                $('#all_immediate')[0].checked = checked;
                                                                                                                                                                                                                else if(!checked && !immediated_flag)
                                                                                                                                                                                                                                $('#all_immediate')[0].checked = false;
                                                                                                                                                                                                }
                                                                                                                                                                                });
                                                                                                                                                                                
                                                                                                                                                                                if(enable_select === "true")
                                                                                                                                                                                {
                                                                                                                                                                                                $('#' + rowtableid + " tbody tr").click( function( e ) {
                                                                                                                                                                                                                
                                                                                                                                                                                                                var data = rowTable.fnGetData( this );
                                                                                                                                                                                                                
                                                                                                                                                                                                                //toggle row selection              
                                                                                                                                                                                                                $(this).toggleClass('hp-selected');
                                                                                                                                                                                                });
                                                                                                                                                                                }
                                                                                                                                                                }
                                                                                                                                                                var immediated_flag = true;
                                                                                                                                                                var deferred_flag = true;
                                                                                                                                                                if(immediate_device.length > 0)
                                                                                                                                                                {
                                                                                                                                                                                var device_checked = immediate_device[0][0].isSelected;
                                                                                                                                                                                for (var idx = 0; idx < immediate_device.length; idx++)
                                                                                                                                                                                {
                                                                                                                                                                                                if(immediate_device[idx][0].isSelected !== device_checked)
                                                                                                                                                                                                                immediated_flag = false;
                                                                                                                                                                                }
                                                                                                                                                                                if(immediated_flag)
                                                                                                                                                                                                $('#all_immediate')[0].checked = device_checked;
                                                                                                                                                                                else if(!device_checked && !immediate_flag)
                                                                                                                                                                                                $('#all_immediate')[0].checked = false;
                                                                                                                                                                }
                                                                                                                                                                else
                                                                                                                                                                                $('#all_immediate')[0].disabled = true;
                                                                                                                                                                if(deferred_device.length > 0)
                                                                                                                                                                {
                                                                                                                                                                                device_checked = deferred_device[0][0].isSelected;
                                                                                                                                                                                for (var idx = 0; idx < deferred_device.length; idx++)
                                                                                                                                                                                {
                                                                                                                                                                                                if(deferred_device[idx][0].isSelected !== device_checked)
                                                                                                                                                                                                                deferred_flag = false;
                                                                                                                                                                                }
                                                                                                                                                                                if(deferred_flag)
                                                                                                                                                                                                $('#all_deferred')[0].checked = device_checked;
                                                                                                                                                                                
                                                                                                                                                                }
                                                                                                                                                                else
                                                                                                                                                                                $('#all_deferred')[0].disabled = true;
                                                                                                                                                                $('#all_immediate').click(function(e){
                                                                                                                                                                                var checked = this.checked;
                                                                                                                                                                                for (var idx = 0; idx < immediate_device.length; idx++)
                                                                                                                                                                                {
                                                                                                                                                                                                var devInd = immediate_device[idx][0].deviceindex;
                                                                                                                                                                                                $('#device_id'+devInd)[0].checked = checked;
                                                                                                                                                                                                immediate_device[idx][0].isSelected = checked;
                                                                                                                                                                                }
                                                                                                                                                                });
                                                                                                                                                                
                                                                                                                                                                $('#all_deferred').click(function(e){
                                                                                                                                                                                var checked = this.checked;
                                                                                                                                                                                for (var idx = 0; idx < deferred_device.length; idx++)
                                                                                                                                                                                {
                                                                                                                                                                                                var devInd = deferred_device[idx][0].deviceindex;
                                                                                                                                                                                                $('#device_id'+devInd)[0].checked = checked;
                                                                                                                                                                                                deferred_device[idx][0].isSelected = checked;
                                                                                                                                                                                }
                                                                                                                                                                });
                                                                                                                                                }
                                                                                                                                                else
                                                                                                                                                {
                                                                                                                                                                $('#hpsum-device-list-div',componentDialogContents).empty();
                                                                                                                                                                $('#hpsum-device-list',componentDialogContents).hide();
                                                                                                                                                }
                                                                                                                                },
                                                                                                                                error : function(){
                                                                                                                                }
                                                                                                                });
                                                                                                }
                                                //this is for textarea
                                                //$('#hpsum-component-failed-dep').val(data.hapi.components.component[0].failed_deps);
                                                
                                                                                                else if(data.hapi.components.component[0].hasOwnProperty('device_info') && data.hapi.components.component[0].device_info.hasOwnProperty('devices'))
                                                                                                {
                                                                                                                $('#hpsum-device-list-div',componentDialogContents).empty();
                                                                                                                
                                                                                                                $('#hpsum-device-list',componentDialogContents).show();
                                                                                                                
                                                                                                                for(var devInd=0; devInd < data.hapi.components.component[0].device_info.devices.device.length; devInd++)
                                                                                                                {
                                                                                                                                var device = data.hapi.components.component[0].device_info.devices.device[devInd];
                                                                                                                                
                                                                                                                                // Use index as table id instead of including device id in case of multiple devices with the same ID
                                                                                                                                // Not sure why use device id, save it into attribute so that could find it if need.
                                                                                                                                var devid = 'deviceid="' + device.device_id.replace(/\W/g, '-') + '"';
                                                                                                                                var headertableid = 'hpsum-devices-header-table-' + devInd;
                                                                                                                                $('#hpsum-device-list-div').append('<table id="' + headertableid + '" ' + devid + '><thead><tr><td></td><td></td><td></td></tr></thead></table>');
                                                                                                                                
                                                                                                                                this.initDevicesHeaderTable('#' + headertableid);
                                                                                                                                
                                                                                                                                var headerTable = $('#' + headertableid).dataTable();
                                                                                                                                
                                                                                                                                var item = [{deviceid: device.device_id, 
                                                                                                                                productid: device.product_id 
                                                                                                                                }];
                                                                                                                                                                
                                                                                                                                headerTable.fnAddData(item);
                                                                                                                                
                                                                                                                                //replace white spaces with - as element id should not have white spaces
                                                                                                                                var rowtableid = 'hpsum-devices-rows-table-' + devInd; 
                                                                                                                                $('#hpsum-device-list-div',componentDialogContents).append('<table class="hp-selectable" id="' + rowtableid + '" ' + devid + '><thead><tr><td>'+localizer.getString('hpsum.common.type')+'</td><td>'+localizer.getString('hpsum.common.statusStr')+'</td><td>'+localizer.getString('hpsum.oneTouchUpdate.activeVersion')+'</td><td>'+localizer.getString('hpsum.oneTouchUpdate.availableVersion')+'</td></tr></thead></table>');

                                                                                                                                this.initDevicesRowTable('#' + rowtableid);
                                                                                                                                
                                                                                                                                var rowTable = $('#' + rowtableid).dataTable();
                                                                                                                                
                                                                                                                                for(var fwInd=0; fwInd < device.fw_item.length; fwInd++)
                                                                                                                                {
                                                                                                                                                var fwitem = device.fw_item[fwInd];
                                                                                                                                                
                                                                                                                                                var rowitem = [{type: fwitem.type, 
                                                                                                                                                fw_item_status: fwitem.fw_item_status,
                                                                                                                                                active_version: fwitem.active_version,
                                                                                                                                                version: fwitem.version 
                                                                                                                                                }];
                                                                                                                                                                                
                                                                                                                                                rowTable.fnAddData(rowitem);
                                                                                                                                }
                                                                                                                }
                                                                                                }
                                                                                                else
                                                                                                {
                                                                                                                $('#hpsum-device-list-div',componentDialogContents).empty();
                                                                                                                $('#hpsum-device-list',componentDialogContents).hide();
                                                                                                }
                                            }
                                                }
                            
            },
            initDevicesHeaderTable:function(tableid) {
                
                var oTab = $(tableid).dataTable({
                                                                                oLanguage: {
                                                                                                                                sEmptyTable: localizer.getString("hpsum.node.noItemsFound"),
                    sSearch: localizer.getString("hpsum.common.search")
                                                                                                                   },
                                                                    bPaginate : false,
                                                                    bProcessing : false,
                                                                    bFilter : false,
                                                                    bSort : false,
                                                                    bAutoWidth : false,
                                                                    bInfo : false,
                                                                    bRetrieve : true,
                                                                    bDestroy : true,
                                                                    aoColumns : [
                                                                                {mDataProp: 'deviceid'},
                                                                                {mDataProp: 'productid'}
                                                                        ],
                                                                    aaSorting: [],
                                                                    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                                                                       return nRow;
                                                                    }
                                                                    });
                                                
                                                                $(tableid + ' tbody tr').first().addClass('hp-selected');
                                                },
                                                
                                                //Initialize component device info row table 
            initDevicesRowTable:function(tableid) {
                
                var oTab = $(tableid).dataTable({
                                                                                oLanguage: {
                                                                                                                                sEmptyTable: localizer.getString("hpsum.node.noItemsFound"),
                    sSearch: localizer.getString("hpsum.common.search")
                                                                                                                   },
                                                                    bPaginate : false,
                                                                    bProcessing : false,
                                                                    bFilter : false,
                                                                    bSort : false,
                                                                    bAutoWidth : false,
                                                                    bInfo : false,
                                                                    bRetrieve : true,
                                                                    bDestroy : true,
                                                                    aoColumns : [
                                                                                {mDataProp: 'type'},
                                                                                {mDataProp: 'fw_item_status'},
                                                                                {mDataProp: 'active_version'},
                                                                                {mDataProp: 'version'}
                                                                        ],
                                                                    aaSorting: [],
                                                                    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                                                                        return nRow;
                                                                    }
                                                                    });
                                                
                                                                $(tableid + ' tbody tr').first().addClass('hp-selected');
                                                },
                                                initSDDevicesRowTable:function(tableid) {
                
                var oTab = $(tableid).dataTable({
                                                                                oLanguage: {
                                                                                                                                sEmptyTable: "",
                                                                                    sSearch: localizer.getString('hpsum.common.search')
                                                                                                                   },
                                                                    bPaginate : false,
                                                                    bProcessing : false,
                                                                    bFilter : false,
                                                                    bSort : false,
                                                                    bAutoWidth : false,
                                                                    bInfo : false,
                                                                    bRetrieve : true,
                                                                    bDestroy : true,
                                                                    aoColumns : [
                                                                                                {
                                                                                                mDataProp: 'select',
                                                                                                                fnRender: function(oObj){
                                                                                                                                return "<input id = device_id"+oObj.aData.devindex+" type=checkbox data-model="+oObj.aData.activation+">";
                                                                                                                }
                                                                                                },
                                                                                {mDataProp: 'type'},
                                                                                {mDataProp: 'fw_item_status'},
                                                                                {mDataProp: 'active_version'},
                                                                                {mDataProp: 'version'},
                                                                                                {mDataProp: 'activation'},
                                                                                                {mDataProp: 'enable_selection', "bVisible": false},
                                                                                                {mDataProp: 'devindex', "bVisible": false},
                                                                                                {mDataProp: 'fwindex', "bVisible": false}
                                                                        ],
                                                                    aaSorting: [],
                                                                    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                                                                        return nRow;
                                                                    }
                                                                    });
                                                
                                                                $(tableid + ' tbody tr').first().addClass('hp-selected');
                                                },
                                recalculate:function() {
                                                if(this.options.nodeItem == undefined){
                                                                window.console.error("recalculate before init is not allowed");
                                                                return;
                                                }
                                                this.calculate(this.element,this.options);
                                                
                                },
                
        calculate: function(el, options) {
                var plugin =this;
           presenter.getbaseline(options.nodeItem, {
                                                                                                success : function(data) {
																											    l_data = data;
																												l_el = el;
																												l_nodeItem = options.nodeItem;
                                                                                                                plugin.populateInstallSet(data, el, options.nodeItem);
                                                                                                                if (typeof (plugin.options.onSelectionCompleted) == 'function')
                                                                                                                                plugin.options.onSelectionCompleted();
                                                                                                },
                                                                                                error : function(data){ 
                                                                                                                plugin.onPopulateError(el);
                                                                                                }
                                                                                });
        },
        onPopulateError : function(el){
                el.text("GetUpdatelist failed for this node");
				plugin.options.onPopulateInstallSet(options.nodeItem.node_id);
        },
        destroy: function(el){
                                $(this.element).removeClass('hpsumInstallables');
                                $.removeData(this.element, "plugin_" + pluginName);
        },
                    //Initialize component device info row table 
        initFailedDependencyTable:function(tableid) {
                
                var oTab = $(tableid).dataTable({
                                                                                oLanguage: {
                                                                                                                                sEmptyTable: localizer.getString("hpsum.node.noItemsFound"),
                    sSearch: localizer.getString("hpsum.common.search")
                                                                                                                   },
                                                                    bPaginate : false,
                                                                    bProcessing : false,
                                                                    bFilter : false,
                                                                    bSort : false,
                                                                    bAutoWidth : false,
                                                                    bInfo : false,
                                                                    bRetrieve : true,
                                                                    bDestroy : true,
                                                                    aoColumns : [
                                                                                {mDataProp: 'failed_dependency'}
                                                                        ],
                                                                    aaSorting: [],
                                                                    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                                                                        return nRow;
                                                                    }
                                                                    });
                                                
                                                //            $(tableid + ' tbody tr').first().addClass('hp-selected');
                                                }
       
                                
        
    };

    // A really lightweight plugin wrapper around the constructor,
    // preventing against multiple instantiations
    $.fn[pluginName] = function ( options ) {
                var instance;
                if ( typeof options === 'string' ) { 
                // call method
                var args = Array.prototype.slice.call( arguments, 1 );
                                                                this.each(function() {
                    instance = $.data( this, "plugin_" + pluginName );
                    if (!instance) {
                        if (!options.match(/destroy/i)) {
                            if (window.console) {
                                window.console.error("cannot call methods on hpInstallables prior to initialization; " +
                                    "attempted to call method '" + options + "'");
                            }
                        }
                        return;
                    }
                    if ( !$.isFunction( instance[options] ) || options.charAt(0) === "_" ) {
                        if (window.console) {
                            window.console.error( "no such method '" + options + "' for hpInstallables instance" );
                        }
                        return;
                    }
                    // apply method
                                instance[ options ].call( instance, args );
                });  
              }
               else{
        return this.each(function () {
            if (!$.data(this, "plugin_" + pluginName)) {
                $.data(this, "plugin_" + pluginName, new Plugin( this, options ));
               }

        });
        }
    };


}(jQuery));
});
                
