//                                    OM
/******************************************************************************
 * @file jquery.hpsumWarnings.js
 *
 *
 * @section LICENSE
 *
 * HPE Confidential
 * Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
 *
 * @section DESCRIPTION
 *
 * This is a plugin for the showing the Warnings/Alerts found by node.
 *
 *
 *******************************************************************************/
define(['hp/core/Localizer',
        'jquery',
        'hp/lib/jquery.hpStatus',
        'hp/lib/jquery.hpToggle'],
function(localizer) {
    "use strict";
    //Lets create the plugin.
    (function($) {

        //Adding the plugin as jquery extension.
        $.fn.hpsumWarnings = function(item, action_required, id) {
            //Write the plugin here
			var warnings = item.warnings || [];
			if (warnings.length > 0) {
				$('#hpsum-warnings-collapsible').removeClass('hp-collapsed');
			}
			var html = "";
			
				if((action_required) && (warnings.length > 0)) {
					var nid = id ? 'id="' + id + '"' : "";
					html += '<div class="hpsum-warning" style = "background-image:none; background-color:#f9f980;"><label><input class="useWEBEMcheckbox ignorewarnings" type="checkbox" ' + nid + ' />' + localizer.getString('hpsum.common.ignoreWarnings') + '</label></br>';
				}
			
			for (var len = 0; len < warnings.length; len++) {
				if(action_required)
				{
					html += '<div><label>' + warnings[len].message.replace(/\n/gi, "<br />") + '</label></div>';
				}
				else{
					if(warnings[len].message!="")
					html += '<div class="hpsum-warning"><label>' + warnings[len].message.replace(/\n/gi, "<br />") + '</label></div>';
				}		
			}
			html += '<br /><br />';

			
			$(this).html(html);
			
			var DEPLOY = '#hpsum-node-deploy-ok';
			var FORMSTATEVIEWMSG = '#hp-form-message-id';
			$('.ignorewarnings').on('change', function(){
				if ($(DEPLOY)[0]) {
				    if ($(this).is(':checked')) {
				        $(DEPLOY).attr("disabled", $(DEPLOY).attr("disabled_org") == 1);
					    if ($(DEPLOY).attr("disabled_org") == 0) {					        
					        $(FORMSTATEVIEWMSG)[0].style.visibility = 'hidden';
					    }
					    else {
					        $(FORMSTATEVIEWMSG)[0].style.visibility = 'visible';
					    }
					} else {
				        $(DEPLOY).attr("disabled", true);
				        $(FORMSTATEVIEWMSG)[0].style.visibility = 'visible';
					}
				}
			});
			
			var SAVE = '#hpsum-assoc-node-deploy-analysis';
			$('.ignorewarnings').on('change', function(){
				if ($(SAVE)[0]) {
					if ($(this).is(':checked')) {
						$(SAVE).attr("disabled", $(SAVE).attr("disabled_org") == 1);
					} else {
						$(SAVE).attr("disabled", true);
					}
				}
			});
			
        };
    }(jQuery));
});