
var OFFLINE_EXIT_BUTTON = '#hpsum-offline-exit';
var INVENTORY_BASELINE_TABLE = '#hpsum-otu-inventory-baseline';
var OKBUTTON = '#hpsum-action-ok-button';
var ILOTASKWARNING="#hpsum-displayprogresstask-warning";
var session = "";

function SetSession(parsession) {
    session = parsession;
}
 
function closeBrowser() {
    window.open('', '_self', '');
    window.close();
}
function onExitButton() {

    var guimode = session.getProperty("gui_mode");
    if (guimode !== "offline_automatic" &&
        guimode !== "offline_interactive" && guimode !== "express") {
        /* In case of Online case and not express we need to route to the welcome screen only */
        router.go('/welcome', 'canceled guided update');
    }
    else {
        /* in rest cases SHUTDOWN the SUM engine */
        logOffSession();
    }

}
   function EnableDisableOfflineExitButton(enableFlag)
{
       
                var l_GUImode = session.getProperty("gui_mode");
                if (l_GUImode === "offline_interactive" || l_GUImode === "offline_automatic")
                {
                    if (enableFlag)
                    {
                        $(OFFLINE_EXIT_BUTTON).removeClass('hp-disabled').addClass('company-a');
                        $(OFFLINE_EXIT_BUTTON).unbind('click').bind('click', onExitButton);
                    }
                    else
                    {
                        $(OFFLINE_EXIT_BUTTON).addClass('hp-disabled');
                        $(OFFLINE_EXIT_BUTTON).unbind('click');
                    }    
                }
                
            }
			
			 function logOffSession(data, handlers) {

                var closeHandlers = {
                    success: function () {
                        session.eraseAll();
                        if (handlers && handlers.success) {
                            handlers.success({});
                        }
                        window.document.write("SUM engine has shut down. Please restart the engine to log in.");
                        closeBrowser();
                    },
                    error: function () {
                        Log.error("Error shutting down the engine");
                    }
                };

                var shutdownData = {
                    hapi: {
                        force: 'false'
                    }
                };
                session.shutDown(shutdownData, closeHandlers);
                Log.info("initiated shutdown");

            }
	
	    function shutdownService(data) 
			{			
				var timeOut = setTimeout(function(){logOffSession(data)},10000);				
			}
			
			function handleExpressExit(data)
			{
				var guimode = session.getProperty("gui_mode");
				if(guimode === "express" ) {
					shutdownService(data);
				}
			}


			function enableAbortButton(step) {
                //don't enable abort abutton as we are deprecating the abort feature. 
			    //$('#step' + step + 'Abort').removeClass("hp-button hp-secondary hp-disabled").addClass("hp-button hp-secondary");
			}

			function disableAbortButton(step) {
			    $('#step' + step + 'Abort').removeClass("hp-button hp-secondary").addClass("hp-button hp-secondary hp-disabled");
			}

			function enableNextButton(step) {
			    if ($(".ignorewarnings")[0]) {
			        $(".ignorewarnings").attr("nextclass", "hp-button hp-primary");
			        $(".ignorewarnings").attr("nextid", '#step' + step + 'Next');
			    }
			    $('#step' + step + 'Next').removeClass("hp-button hp-primary hp-secondary hp-disabled");
			    if ($(".ignorewarnings")[0] && !$(".ignorewarnings").is(':checked')) {
			        $('#step' + step + 'Next').addClass("hp-button hp-secondary hp-disabled");
			    } else {
			        $('#step' + step + 'Next').addClass("hp-button hp-primary");
			    }
			}

			function disableNextButton(step) {
			    if ($(".ignorewarnings")[0]) {
			        $(".ignorewarnings").attr("nextclass", "hp-button hp-secondary hp-disabled");
			        $(".ignorewarnings").attr("nextid", '#step' + step + 'Next');
			    }
			    $('#step' + step + 'Next').removeClass("hp-button hp-primary hp-secondary hp-disabled");
			    $('#step' + step + 'Next').addClass("hp-button hp-secondary hp-disabled");
			}

			function enableResetButton(step) {
			    $('#step' + step + 'Reset').removeClass("hp-button hp-secondary hp-disabled").addClass("hp-button hp-secondary");
			}

			function disableResetButton(step) {
			    $('#step' + step + 'Reset').addClass("hp-button hp-secondary hp-disabled");
			}

			function enableBackButton(step) {
			    $('#step' + step + 'Prev').removeClass("hp-button hp-secondary hp-disabled").addClass("hp-button hp-secondary");
			}

			function disableBackButton(step) {
			    $('#step' + step + 'Prev').removeClass("hp-button hp-secondary").addClass("hp-button hp-secondary hp-disabled");
			}


			function disableAnalyzeButton(step) {
			    $('#step' + step + 'Analyze').addClass("hp-button hp-secondary hp-disabled");

			    //enable Deploy button if analyze button is disabled and vice versa
			    //before enabling Deploy button, make sure no failed dependency components are selected.. TODO
			    //enableNextButton(step);
			}

			function enableRebootButton(step) {
			    $('#step' + step + 'Reboot').show();
			    $('#step' + step + 'Reboot').removeClass("hp-button hp-secondary hp-disabled").addClass("hp-button hp-secondary");
			}

			function disableRebootButton(step) {
			    $('#step' + step + 'Reboot').removeClass("hp-button hp-secondary").addClass("hp-button hp-secondary hp-disabled");
			}

			function hideAllButtons(step) {
			    var parent = $('#step' + step + 'commands');

			    //Only show the Abort and Reset buttons and hide all other buttons
			    parent.find('.hp-button').each(function () {
			        if (!($(this).attr('id').match(/abort/i) || $(this).attr('id').match(/reset/i)))
			            $(this).hide();
			    });
			}

			function enableMainDialogOkButton()
			{
			   // $('#hpsum-action-ok-button', actionDialogContents).unbind('click').bind('click', onOkButton);
			    $(OKBUTTON).removeClass("hp-button hp-primary hp-disabled").addClass("hp-button hp-primary");
			    $(OKBUTTON).removeAttr("disabled");
			}

			function disableMainDialogOkButton()
			{
			    //$('#hpsum-action-ok-button', actionDialogContents).unbind('click');//.bind('click', onOkButton);
			    $(OKBUTTON).removeClass("hp-button hp-primary").addClass("hp-button hp-primary hp-disabled");
			    $(OKBUTTON).removeAttr("enable");
			    $(OKBUTTON).attr("disabled", "disabled");
			}


			function hideiLOtaskwarnings()
			{
			    $(ILOTASKWARNING).empty();
			}

			function displayiLOtaskwarnings(localizer,glbtaskinprogress)
			{
			    $(ILOTASKWARNING).empty();
			    $(ILOTASKWARNING).append('<label><font color=red>' + localizer.getString('hpsum.oneTouchUpdate.taskinprogresswarning_1') + glbtaskinprogress + localizer.getString('hpsum.oneTouchUpdate.taskinprogresswarning_2') + '</label>')
			    $(ILOTASKWARNING).show();
			}



			function showAllButtons(step) {
			    var parent = $('#step' + step + 'commands');

			    parent.find('.hp-button').each(function () {
			        $(this).show();
			    });
			}


			function showWizardStep(step) {
			    $('#step' + step).show();
			}

			function hideWizardStep(step) {
			    $('#step' + step).hide();
			}



