// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
//One Touch Update View
//Initial Version
define(['hp/view/AssociationAddView',
        'hp/view/DialogView',
        'hpsum/overwrite/iLODialogView',
        'hp/view/FormStateView',
        'hp/core/Router',
        'hpsum/presenter/baseline/BaselinePresenter',
        'hpsum/presenter/node/NodePresenter',
        'hp/services/REST',
        'hp/model/Session',
        'hp/core/Localizer',
        'hp/services/Log',
        'text!hpsumpages/one-touch-update/reboot_confirm.html',
        'hp/view/NotificationsView',
        'text!hpsumpages/one-touch-update/ilotasks.html',
        'jquery',
        'hpsum/view/node/jquery.hpsumInstallables',
        'hpsum/view/node/jquery.hpsumInstallResults',
        'hpsum/view/node/jquery.hpsumAddNodeDetails',
        'hpsum/view/node/jquery.hpsumAddiLOTaskDetails',
        'hpsum/view/node/jquery.hpsumWarnings',
        'hpsum/view/node/jquery.hpsumInstallSetComponents',
        'hp/lib/jquery.hpPanels',
        'hp/lib/jquery.hpSelect',
        'lib/wizard',
        'hp/lib/jquery.hpCollapsible',
        'hp/lib/jquery.hpDropMenu',
        'hp/lib/jquery.hpProgressBar',
        'lib/jquery.validate',
        'hp/lib/jquery.hpSearchCombo',
        'hp/lib/jquery.hpStackedPanels',
        'hp/lib/jquery.hpToggle',
        'hpsum/view/one-touch-update/OneTouchUpdateHeaderFunctions'
],
    function (AssociationAddView, DialogView, iLODialogView, FormStateView, router, BaselinePresenter, NodePresenter,rest, session, localizer, Log, rebootConfirmHtml, NotificationsView, ilotaskshtml) {
        "use strict";

    var OneTouchUpdateView = (function() {

            var VIEW = '#one-touch-page';
            var PANELS = '.hp-panels';
            var DELTA_BASE = '#hpsum-home-delta-base';
            var NODES_TABLE = '#nodes';
            var ADD_NODES = '#hpsum-nodes-add';
            var NODES_MESSAGE = '#hpsum-nodes-message';
            var BASELINES_TABLE = '#baselines';
            var ADD_BASELINES = '#hpsum-baselines-add';
            var BASELINES_MESSAGE = '#hpsum-baselines-message';
            var ACTION_DIALOG = '#hpsum-action-dialog';
            var PREREQS_DIALOG = '#hpsum-pre-reqs-dialog',
                PREREQS_DIALOG_BUTTON_OK = '#hpsum-prereqs-ok-button',
                PREREQS_DIALOG_BUTTON_NO = '#hpsum-prereqs-no-button',
                PREREQS_DIALOG_BUTTON_CANCEL = '#hpsum-prereqs-cancel-button',
                PREREQS_DIALOG_CHECKBOX = '#hpsum-node-edit-install-prereqs-checkbox',
                PREREQS_DIALOG_RETRY_LABEL = '#hpsum-otu-prereqs-retry',
                PREREQS_DIALOG_CB_DIV = '#hpsum-node-edit-install-prereqs-div';

				var ILO_CREDENTIALS_DIALOG = '#hpsum-ilo-credentials-dialog';
				var CAC_ERROR_DIALOG = '#hpsum-cac-error-dialog';
			var INSTALL_PREREQS_CHECKBOX = '#hpsum-node-inventory-install-prereqs-checkbox';
            var INVENTORY_BASELINE_TABLE = '#hpsum-otu-inventory-baseline',
                INVENTORY_NODE_TABLE = '#hpsum-otu-inventory-node',
                INSTALLPROGRESS_TABLE = '#hpsum-otu-install-progress',
                COMPONENT_DIALOG = '#hpsum-component-dialog',
                SPLASH_DIALOG = '#hpsum-splash-dialog',
                SPLASH_DIALOG_ILO = '#hpsum-splash-dialog_ilo',
                SPLASH_DIALOG_PREREQS = '#hpsum-splash-dialog-pre-reqs',
                SPLASH_SPINNER = '#hpsum-splash-spinner',
                AUTOMATIC_UPDATE_CONFIRM = '#automatic-confirmation-dialog',
                HP_MAIN_MENU_CONTROL = '#hp-main-menu-control',
                HP_SEARCH_CONTROL = '#hp-search-control',
                HP_SESSION_CONTROL = '#hp-session-control',
                HP_ACTIVITY_CONTROL = '#hp-activity-control',
                HPSUM_OTU_ACTIONS = '#hpsum-otu-actions',
                SUM_PENDINGLIST_TABLE = '#hpsum-pendinglist-table-div';
            var OTU_ADVANCE_ACTION = '#hpsum-otu-advance-action';
	    var OTU_ADVANCE_REPORTS = 'hpsum-otu-advance-reports';
            var OFFLINE_EXIT_BUTTON = '#hpsum-offline-exit';
			var OKBUTTON 	 = '#hpsum-otu-ilo-ok',
    		CANCELBUTTON = '#hpsum-otu-ilo-cancel',
    		ILO_USERNAME = '#hpsum-otu-ilo-username',
       		ILO_PASSWORD = '#hpsum-otu-ilo-password',
			ILO_DIALOG_TEXT = '#hpsum-otu-ilo-dialog-text',
			CAC_SECURITY_TITLE = '#hpsum-ilo-cac-security-title',
			CAC_DIALOG_TEXT  =  '#hpsum-otu-cac-text',
			CAC_OKBUTTON 	= '#hpsum-otu-cac-ok';
			
            var HCODE_F_CHIF_NEEDED = 44, /* directly related to CHCode::F_CHIF_NEEDED of engine */
                HCODE_F_CHIF_INSTALL = 45, /* CHIF is needed on the server, user has opted to install it but installation failed.*/
                HCODE_F_CHIF_SIGNATURE_VERIFICATION_FAILED = 46, /* Signature verification failed for CHIF driver component */
				HCODE_F_CAC_MODE_ENABLED = 48,					/*CAC is enabled on iLO of the Gen 10 Server*/
				HCODE_F_HIGHSECURITY_MODE = 49,					/*iLO is in one of the high security mode*/
                HCODE_F_CHIF_REBOOT_NEEDED = 51,
                HCODE_F_CHIF_COMMUNICATE_AFTER_CHIF_INSTALL = 52,
				HCODE_F_INVALID_ILO_CREDENTIALS = 53,			/*User provided incorrect iLO Credentials */
				HCODE_F_BIOS_PASSWORD_ENABLED = 54;				/*BIOS password is enabled. iLO credentials are required to proceed further*/
				
           
		   	var SAVE_INSTALL_SET_CHECBOX = '#saveinstallsetcheckbox',
			UPDATE_RECOVERY_SET_CHECKBOX = '#hpsum-update-recovery-set-checkbox',
			UPDATE_RECOVERY_SET_DESCR = '#hpsum-update-recovery-set-descr',
			UPDATE_RECOVERY_ILO_CRDENTIALS_DETAILS = '#hpsum-ilo-credentials-for-recovery-details',
			UPDATE_RECOVERY_ILO_USERNAME = '#hpsum-recovery-ilo-username',
			UPDATE_RECOVERY_ILO_USERNAME_ERR = '#hpsum-recovery-ilo-username-err',
			UPDATE_RECOVERY_ILO_PASSWORD = '#hpsum-recovery-ilo-password',
			UPDATE_RECOVERY_ILO_PASSWORD_ERR = '#hpsum-recovery-ilo-password-err';
			
			var ILO_MIN_MAJOR_VER_FOR_UPDATE_REC_SET = 1, //Mininum iLO firmware version for update recovery set 1.30
			ILO_MIN_MINOR_VER_FOR_UPDATE_REC_SET = 30;
			
		   var SUM_HELP='#sum-help';
				
            var prereqsnotificationsView = null;
            var globaldata;
	        var  globaldata_for_recoveryset;
            var globalNodeID;
            var globalisGen10 = false;
            var globaliloQData = "";
            var glbdata;
            var globaldataforprereq = "";
            var glbSelectedbaseline;
            var baselines = '',
                hotfixes = '';
            var newBaseline = null,
                newHotFix = null;
            var isGuidedUpdateWithBaselines = false;
            var nodeChanges = [];
            var bInAnalysis = false;
            var iloTasklistlength = 0;
            var STEP_INVENTORY = 0, STEP_REVIEW = 1, STEP_DEPLOY = 2;

            var NOTIFY_STATUSES = {error: 'error', warning: 'warning', unknown: 'info'};
            var selectionChange = false;
            var deployToDo = false;
            var ESCAPE_KEY_CODE = 27;
            var isTPMPresent = false;
            var NodeDataItem;
            var renderRreReqsDialog = false;
			var renderiLOCredDialog = false;
			var renderiLOCACDialog = false;
            var isinstallset = false;
            var isbaseline = false;
            var installSetID=null;
            var numberofinstallsetandBL = 0;
            var bShowTaskQueue = false;
            var retries = 0;
            var iSScreenChanged = false;
            var isRefreshStarted = false;
            var bPrereqsInstalled = false;
            var bisPrereqsreq = false;
            var glbtaskinprogress = "";
            var glbscheddatentime = "";
            var splashrunning = false;
            var installsetoptdisabled = false;
            var disableDeploy = false;
            var glbTaskState = "";
            var glbExceptionState = false;
            var glbIsSaveInstallSet = false;
            var onlyiLOwarning = false;
            var isCompSelected = false;
            var defaultBL_offlineauto = "";
            var deployStarted = false;
            var ignoreWarningChecked = false;
            var showCompsigWarning = false;
            var globalCompsigPresent = false;
            var globalTypeCcompSelected = false;
            var isIgnoreWarningClicked = false;
			var isHighSecurity = false;
			var isBIOSPasswordSet = false;
			var isInvalidiLOCredentials = false;
			var okButtonValueSet = false;
			var gIsUpdateRecoverySet = false,
				recoveryiLOUsername = "",
				recoveryiLOPassword = "",			
				gIsRecoveryiLOCredentialsRequired = false,
				isTaskScheduled = false;
            var optiondetails = {
                hapi: {
                    ilo_management_options: {
                        save_install_set: false
                    }
                }
            };

            var deployiloupdatesdetail = {
                hapi: {
                    baselines: {
                        baseline: 'iLO_queued_updates'

                    }
                }
            };


            /**
             * Disabling all the features excluding one touch update in offline mode.
             */

            var guimode = session.getProperty("gui_mode");

            if (guimode === "offline_automatic" || guimode === "offline_interactive" || guimode === "express") {

                $(HP_MAIN_MENU_CONTROL).addClass('hp-disabled');
                $(HP_SEARCH_CONTROL).css('display', 'none');
                $(HP_SESSION_CONTROL).css('display', 'none');
                $(HP_ACTIVITY_CONTROL).css('display', 'none');
            }


            /**
             * Constructor
             */
            function OneTouchUpdateView() {

                var associationsNodesTable = null;
                var associationsBaselinesTable = null;
                var allNodes = [], allBaselines = [];
                var currNodes = [], currBaselines = [];
                var actionDialogContents;
                var actiondialogilotasks;
                var ilotasksdlgitemContents;
				var iloCredDialogContents;
				var cacDialogContents;
                var preReqsDialogContents;
                var bModeInteractive = false, bModeNonInteractive = false, bInProgress = false;
                var baselineIterator, nodeIterator;
                var progressTimer, bBaselineInventoryDone;
                var componentLogDialogContents;
                var bLoadMulti = false;
                var actiondialog;
                var preReqDialog;
				var iloCredDialog;
				var cacDialog;
                var abortButtonPressed = false;
                var bStartDeploy = false;
                var gnodeNodeSettings = [];
                var iLOwarninglength = 0;
                var gnodeWarnings = "";
                var notificationsView = new NotificationsView();
                var status, summary, details;
                var notificationsCleared = true;
                var modeValue, nodeValue;
                var autoConfDialogContents, autoConfDialog;
                var selectedNode;
                var nodeadded;
                
               
                SetSession(session);
                function getIndexSuccess(data) {
                                     
                    $(ACTION_DIALOG).hide();
                    allNodes = [];
                    currNodes = [];

                     
                    if (data.hapi.output_data.nodes.node.node_name === 'localhost') {
                           
                        NodeDataItem = data.hapi.output_data.nodes.node;
                        //add node of not already added
                        if (NodeDataItem.node_state.match(/idle/i) &&
                            NodeDataItem.node_phase.match(/InActive/i)) {

                                //add node and proceed
                                NodePresenter.addItem({
                                    name: "localhost"
                                }, true, {
                                    success: onItemAddSuccess,
                                    error: onItemAddError
                                });

                            }//check if its CHIF related error,If CHIF related prompt for prereq installation
                            else if (NodeDataItem.node_state.match(/idle/i) &&
                               NodeDataItem.node_phase.match(/unknown/i)) {

                                if (splashrunning) {
                                    closeAnalysisSplashforGen10();
                                }
                                if (isCHIFRelatedError(NodeDataItem.node_status_hcode)) {
                                    installPreReqs();
                                    /* go to prereqs control path only if the add node failed due to prereqs things.*/
                                }
								else if(NodeDataItem.node_status_hcode == HCODE_F_CAC_MODE_ENABLED)
								{								
									showiLOCACHighSecurityDialog();
									return;
								}
								else if(NodeDataItem.node_status_hcode == HCODE_F_HIGHSECURITY_MODE)
								{		
								if(guimode == "offline_automatic" || guimode == "express")
								{
									isHighSecurity = true;
									showiLOCACHighSecurityDialog();
								}
								else
								{
									showiLOCredentialsDialog();
								}
									return;
								}
								else if(NodeDataItem.node_status_hcode == HCODE_F_BIOS_PASSWORD_ENABLED)
								{
									isBIOSPasswordSet = true;
									if(guimode == "offline_automatic" || guimode == "express")
									{									
										showiLOCACHighSecurityDialog();
									}
									else
									{
										showiLOCredentialsDialog();
									}	
									return;
								}
								else if(NodeDataItem.node_status_hcode == HCODE_F_INVALID_ILO_CREDENTIALS)
								{
								isInvalidiLOCredentials = true;
								if(guimode == "express")
								{
									showiLOCACHighSecurityDialog();
								}
								else
								{
									showiLOCredentialsDialog();
								}
									return;
								}
                                else {
                                    $(ACTION_DIALOG).show();
                                }

                            }
                            else {
							//Node is added and is in UAN state
                                if (preReqDialog) {
                                    preReqDialog.cancel();
                                }

                                if (!globalisGen10 && splashrunning)
                                    closeAnalysisSplashforGen10();
                                $(ACTION_DIALOG).show();
                            }
                        }
                  
                   
                nodeValue='one';
                    if (!bisPrereqsreq) {
                        nodeOptions(nodeValue);
                    }
                }

                function onItemAddSuccess() {

                    var progressTimer = setInterval(function () {
                        var nodeItems = {node_id: NodeDataItem.node_id};
                        NodePresenter.getNodeData(nodeItems, {
                            success: function (data) {
                                if (data.hapi.node_phase.match(/unknown/i)) {
                                    clearInterval(progressTimer);

                                    if (isCHIFRelatedError(data.hapi.node_status_hcode)) {
                                        installPreReqs();
                                        /* go to prereqs control path only if the add node failed due to prereqs things.*/
                                    }
									if(data.hapi.node_status_hcode == HCODE_F_CAC_MODE_ENABLED)
										   {								
												showiLOCACHighSecurityDialog();
												return;
										   }
									else if(data.hapi.node_status_hcode == HCODE_F_HIGHSECURITY_MODE)
									{			
												if(guimode == "offline_automatic" || guimode == "express")
												{
													isHighSecurity = true;
													showiLOCACHighSecurityDialog();
												}
												else
												{
													showiLOCredentialsDialog();
												}
												return;
									}
									else if(data.hapi.node_status_hcode == HCODE_F_BIOS_PASSWORD_ENABLED)
									{			
												isBIOSPasswordSet = true;
												if(guimode == "offline_automatic" || guimode == "express")
												{													
													showiLOCACHighSecurityDialog();
												}
												else
												{
													showiLOCredentialsDialog();
												}
												return;
									}
									else if(data.hapi.node_status_hcode == HCODE_F_INVALID_ILO_CREDENTIALS)
									{	
												isInvalidiLOCredentials = true;
												if(guimode == "express")
												{
													showiLOCACHighSecurityDialog();
												}
												else
												{
													showiLOCredentialsDialog();
												}
												return;
									}
                                    else {
                                        clearInterval(progressTimer);
                                        if (splashrunning) {
                                            closeAnalysisSplashforGen10();
                                        }
                                        $(ACTION_DIALOG).show();
                                    }
                                    return;
                                }
                                else if (data.hapi.node_phase.match(/UserActionNeeded/i)) {
                                    clearInterval(progressTimer);
                                    if (splashrunning) {
                                        closeAnalysisSplashforGen10();
                                    }
                                    $(ACTION_DIALOG).show();
                                    return;
                                }
                            },
                            error: function () {
                                clearInterval(progressTimer);
                                return;
                            }
                        });
                    }, 5000);

                }

                function onItemAddError() {
                     
                }

                function installPreReqs() {
                    showPreReqDialog();
                }

                function getAllNodesError(error) {

                }

               
                function getBaselineError(error) {

                }
              function populateInstallSetTable(nodeid,nodes)
				{
	
					$('#all-installables').append('<div class="hp-collapsible" id="hpsum-otu-node-' + nodeid + '-installset"><label><b>' + nodes.node_name + ' ' + localizer.getString("hpsum.oneTouchUpdate.applicableComponents")+ '</b></label><div><div id=installsets class= hp-stacked-panel></div>');
					$("#installsets").append('<div id="installsetmgmtoption"></label ><br><label><b>' +
						localizer.getString("hpsum.oneTouchUpdate.iLoInstallsetmgmtoption") +
						'</b></label></div><br><div id=installsetChkBox ><input id="saveinstallsetcheckbox"  type="checkbox"  /><label>' + localizer.getString("hpsum.node.saveInstallSets")
						+ '</div>' +						
						'<div id="hpsum-update-recovery-set-details"><input id="hpsum-update-recovery-set-checkbox"  type="checkbox"  /><label id="hpsum-update-recovery-set-descr">' + localizer.getString("hpsum.node.updateRecoverySet") + '</label>'
                         + '</div>' +
						'<div id="hpsum-ilo-credentials-for-recovery-details" style="margin-left:10px">' +
							'<h3><b><label>' + localizer.getString("hpsum.node.iLOCredentials") + '</label></b></h3>' +
							'<div id="hpsum-ilo-credentials-for-recovery-desc" style="padding:0;" <label>' + localizer.getString("hpsum.node.updateRecoverySetiLOCredentialsRequired") + '</label></div>' +
							'<div style="margin-top:10px; margin-bottom:10px;" id="hpsum-node-ilo-credential-note" <label>' + localizer.getString("hpsum.node.iloRecoveryCredentialsNote") + '</label></div>' +
								'<table class="hp-column" style="margin-top:0px;">' +
									'<tbody>' +																
									'<tr class="hp-column-item">' +
										'<td><label>' + localizer.getString("hpsum.common.username") + '</label></td>' +
										'<td><input id="hpsum-recovery-ilo-username" type="text" align="left" class="required hp-error" maxlength="255" autocomplete="off"/></td>' +
										'<td><label id="hpsum-recovery-ilo-username-err" for="hpsum-recovery-ilo-username" class="hp-error">' + localizer.getString("hpsum.node.nodeUsername") + '</label></td>' +
									'</tr>' +
									'<tr class="hp-column-item">' +											
										'<td><label>' + localizer.getString("hpsum.common.password") + '</label></td>' +
										'<td><input id="hpsum-recovery-ilo-password" type="password" class="required hp-error" maxlength="255" autocomplete="off"/></td>' +
										'<td><label id="hpsum-recovery-ilo-password-err" for="hpsum-recovery-ilo-password" class="hp-error">' +  localizer.getString("hpsum.node.nodePassword") + '</label></td>' +
									'</tr>' +
									'</tbody>' +
								'</table>' +
						'</div>');						
								
				}
                

                function RePopulateiLoTaskTable(NodeID, ilolistdata) {
                  
                    var options = {
                        command: 'populateComponentsTable',
                        nodeid: NodeID,
                        data: ilolistdata
                    };

                    $(SUM_PENDINGLIST_TABLE).hpsumAddiLOTaskDetails(options);
                }

                function RefreshiLOTaskQ(NodeID, ilolistdata, data) {
                    isRefreshStarted = true;
                    var item = {
                        node_id: NodeID
                    }
                    setTimeout(function () {
                        NodePresenter.getTaskQuequeList(item, {
                                success: function (ilolistdata) {


                                    var taskQlength = 0;
                                    if (ilolistdata && ilolistdata.hapi && ilolistdata.hapi.ilotasks != undefined && ilolistdata.hapi.ilotasks.ilotask != undefined)
                                        taskQlength = ilolistdata.hapi.ilotasks.ilotask.length;
                                    var isInProgress = IsTaskinProgress(ilolistdata);

                                    if (isInProgress) {

                                   displayiLOtaskwarnings(localizer,glbtaskinprogress);
                                    disableMainDialogOkButton();

                                    }
                                    else {
                                        if (glbExceptionState == true) {
                                            if (guimode == "offline_automatic" && iSScreenChanged != true) {

                                                offlineAutomaticUpdateWithoutTaskQ(NodeID, ilolistdata, data);
                                                if (actiondialog)
                                                    actiondialog.cancel();

                                            }

                                        hideiLOtaskwarnings();
                                        

                                        //enable disable the OK button based on task queue radio choice
                                        if ($("input[name='install-option']:checked").val() == 'TaskQueue') {
                                            
                                            disableMainDialogOkButton()
                                        }
                                        else if ($("input[name='install-option']:checked").val() == 'BL') {
                                            if (!okButtonValueSet)
                                                enableMainDialogOkButton();
                                        }

                                        }
                                        else if (taskQlength == 0) {
                                            if (guimode == "offline_automatic" && iSScreenChanged != true) {


                                                offlineAutomaticUpdateWithoutTaskQ(NodeID, ilolistdata, data);

                                                if (actiondialog)
                                                    actiondialog.cancel();

                                        }
                                        else if (guimode != "offline_automatic") {
                                            hideiLOtaskwarnings();

                                            $("#baseline").attr("checked", true);
                                            $("#baseline").attr('enabled', 'enabled');
                                            $("#taskqueue").attr('disabled', 'disabled');
                                            $('#hpsum-localhost').show();
                                            $('#hpsum-pendinglist-table-div').hide();
                                            $('#iLOQueuedComponents').hide();
                                            if (!okButtonValueSet) {
                                                $('#iLOUpdateMsg').hide();
                                                enableMainDialogOkButton();
                                            }

                                        }

                                    }
                                    else {

                                            hideiLOtaskwarnings();
                                            if (!okButtonValueSet)
                                                enableMainDialogOkButton();


                                        }

                                    }


                                    if (iSScreenChanged !== true) {
                                        if (ilolistdata && ilolistdata.hapi && ilolistdata.hapi.ilotasks != undefined && ilolistdata.hapi.ilotasks.ilotask != undefined && ilolistdata.hapi.ilotasks.ilotask.length != 0)
                                            RefreshiLOTaskQ(NodeID, ilolistdata, data);
                                        RePopulateiLoTaskTable(NodeID, ilolistdata);
                                    }
                                }, error: function () {

                                }
                            }
                        );
                    }, 30000);
                }

            
                function IsTaskinProgress(data) {

                    var bInProgress = false;
                    var tasklength = 0;
                    if (data && data.hapi && data.hapi.ilotasks != undefined && data.hapi.ilotasks.ilotask != undefined)
                        tasklength = data.hapi.ilotasks.ilotask.length;

                    if (tasklength > 0) {
                        var taskState = data.hapi.ilotasks.ilotask[0].state;


                        if ("InProgress" === taskState) {
                            bInProgress = true;
                            glbtaskinprogress = data.hapi.ilotasks.ilotask[0].name;
                            glbscheddatentime = data.hapi.ilotasks.ilotask[0].scheduledatetime;


                        }
                        else if ('Expired' == taskState || 'Exception' == taskState || 'Complete' == taskState || 'Canceled' == taskState)
                        {
                                glbTaskState = taskState;
                                glbExceptionState = true;


                        }
                 

                    }
                    return bInProgress;
                }

               

              

                function offlineAutomaticUpdateWithoutTaskQ(NodeID, ilolistdata, data) {
                    iSScreenChanged = true;
                   
                    $(SUM_PENDINGLIST_TABLE).hpsumAddiLOTaskDetails('init');


                    var options = {
                        command: 'populateComponentsTable',
                        nodeid: NodeID,
                        data: ilolistdata
                    };

                    $(SUM_PENDINGLIST_TABLE).hpsumAddiLOTaskDetails(options);
                    $("#hpsum-localhost").hpsumAddNodeDetails('init');


                    $("#hpsum-otu-action-mode").hide();
                    $("#hpsum-action-exit-button").show();
                    $("#hpsum-action-cancel-button").hide();

                    var item = {
                        enableAssignBaselineCheckbox: true,
                        showAssignedBaselines: true,
                        baselineSelectionChanged: onBaselineSelectionChanged,
                        baselineLabel: localizer.getString('hpsum.node.addBaselineOptionalGU')
                    };
                    var options = {
                        command: 'addBaseline',
                        args: item
                    };

                    $("#hpsum-localhost").hpsumAddNodeDetails(options);
                    var item = {
                        isGuidedUpdate: true,
                        data: data.hapi,
                        node_id: NodeID,
                        isGen10: 1,
                        installset: [],
                        baseline: []
                    };


                    //The command 'loadBaselines' is created by merging both the functions
                    //"getAllBaselines" and "loadBaselinedata" to handle asynchronous ajax call by
                    //using JQuery deferred object
                    var options = {
                        command: 'loadBaselines',
                        args: item
                    };

                    $("#hpsum-localhost").hpsumAddNodeDetails(options);


                    onDeployInstallSetButton();


                }


                function GetiLOtaskDetailsnDisplay(NodeID, ilolistdata, data) {

                    var Gen10 = 0;

                    if (globalisGen10)
                        Gen10 = 1;

                    if (ilolistdata && ilolistdata.hapi && ilolistdata.hapi.ilotasks != undefined && ilolistdata.hapi.ilotasks.ilotask != undefined)
                        iloTasklistlength = ilolistdata.hapi.ilotasks.ilotask.length;
                    else
                        iloTasklistlength = 0;

                    globaliloQData = ilolistdata;


                    if (iloTasklistlength > 0) {

                        var isInProgress = IsTaskinProgress(ilolistdata);

						var startAfter = ilolistdata.hapi.ilotasks.ilotask[0].scheduledatetime;
                        showActionDialog();

                        $(SUM_PENDINGLIST_TABLE).hpsumAddiLOTaskDetails('init');


                        var options = {
                            command: 'populateComponentsTable',
                            nodeid: NodeID,
                            data: ilolistdata
                        };

                        $(SUM_PENDINGLIST_TABLE).hpsumAddiLOTaskDetails(options);
                        $("#hpsum-localhost").hpsumAddNodeDetails('init');


                        $("#baseline").attr("checked", true);
                        $('#baseline').attr('enabled', 'enabled');
                        $('#hpsum-localhost').show();
                        $('#hpsum-pendinglist-table-div').hide();
                        $('#iLOQueuedComponents').hide();


                        if (guimode == "offline_automatic" || guimode == "offline_interactive") {

                            $("#hpsum-otu-action-mode").hide();
                            $("#hpsum-action-exit-button").show();
                            $("#hpsum-action-cancel-button").hide();


                        }


                        if (isInProgress) {

                           
                            displayiLOtaskwarnings(localizer,glbtaskinprogress);
                            disableMainDialogOkButton();

                        }
                        else {
                            hideiLOtaskwarnings();
                            if (!okButtonValueSet)
                                enableMainDialogOkButton();

                        }
                        $("#iLOUpdateMsg").show();


                        $("#hpsum-ilotaskListDetailsMessage").empty();
						var msg = localizer.getString('hpsum.oneTouchUpdate.updatependingilodetails_1');
						if(startAfter != ""){
							isTaskScheduled = true;
							msg = localizer.getString('hpsum.oneTouchUpdate.updatescheduleilodetails_1');
							$('#hpsum-warning-label').text(localizer.getString('hpsum.oneTouchUpdate.updatescheduledinilo'));
						}

                        $("#hpsum-ilotaskListDetailsMessage").append('<label >' + msg + '</label>');

                        var item = {
                            enableAssignBaselineCheckbox: true,
                            showAssignedBaselines: true,
                            baselineSelectionChanged: onBaselineSelectionChanged,
                            baselineLabel: localizer.getString('hpsum.node.addBaselineOptionalGU')
                        };
                        var options = {
                            command: 'addBaseline',
                            args: item
                        };

                        $("#hpsum-localhost").hpsumAddNodeDetails(options);
                        var item = {
                            isGuidedUpdate: true,
                            data: data.hapi,
                            node_id: NodeID,
                            isGen10: Gen10,
                            installset: [],
                            baseline: []
                        };


                        //The command 'loadBaselines' is created by merging both the functions
                        //"getAllBaselines" and "loadBaselinedata" to handle asynchronous ajax call by
                        //using JQuery deferred object
                        var options = {
                            command: 'loadBaselines',
                            args: item
                        };

                        $("#hpsum-localhost").hpsumAddNodeDetails(options);


                        setTimeout(function () {


                            if (item != undefined && item.baseline != undefined && item.baseline.length != 0)
                                defaultBL_offlineauto = item.baseline[0].url;


                        }, 500);
                       
                        if (glbExceptionState == true && guimode == "offline_automatic") {
                            onDeployInstallSetButton();
                            actiondialog.cancel();

                        }


                        if (guimode == "offline_automatic") {
                            $('#hpsum-localhost').hide();

                        }
                    }
                    else if ((guimode != "offline_automatic") && (guimode != "express") && iloTasklistlength == 0)//ABSSUM028
                    {


                        showActionDialog();
                        $(SUM_PENDINGLIST_TABLE).hpsumAddiLOTaskDetails('init');


                        var options = {
                            command: 'populateComponentsTable',
                            nodeid: NodeID,
                            data: ilolistdata
                        };

                        $(SUM_PENDINGLIST_TABLE).hpsumAddiLOTaskDetails(options);
                        $("#hpsum-localhost").hpsumAddNodeDetails('init');
                        if (guimode == "offline_automatic" || guimode == "offline_interactive") {
                            $("#hpsum-otu-action-mode").hide();
                            $("#hpsum-ilotask_mode").hide();
                            $("#hpsum-addpadding").append("<li style=padding-top:110px></li>");


                        }
                        $("#hpsum-ilotaskListDetailsMessage").empty();


                        $("#hpsum-ilotaskListDetailsMessage").append('<label >' + localizer.getString('hpsum.oneTouchUpdate.updatependingilodetails_1') + '</label>');//+ localizer.getString('hpsum.oneTouchUpdate.updatependingilodetails_2') + localizer.getString('hpsum.oneTouchUpdate.updatependingilodetails_4')

                        var item = {
                            enableAssignBaselineCheckbox: true,
                            showAssignedBaselines: true,
                            baselineSelectionChanged: onBaselineSelectionChanged,
                            baselineLabel: localizer.getString('hpsum.node.addBaselineOptionalGU')
                        };
                        var options = {
                            command: 'addBaseline',
                            args: item
                        };

                        $("#hpsum-localhost").hpsumAddNodeDetails(options);

                        if (!okButtonValueSet) {
                            $('#iLOUpdateMsg').hide();
                        }
                        $('#baseline').attr('enabled', 'enabled');
                        $("#baseline").attr("checked", true);
                        $("#taskqueue").attr('disabled', 'disabled');


                        $('#hpsum-localhost').show();
                        $('#hpsum-pendinglist-table-div').hide();
                        $('#iLOQueuedComponents').hide();


                        var item = {
                            isGuidedUpdate: true,
                            data: data.hapi,
                            node_id: NodeID,
                            isGen10: Gen10
                        };


                        //The command 'loadBaselines' is created by merging both the functions
                        //"getAllBaselines" and "loadBaselinedata" to handle asynchronous ajax call by
                        //using JQuery deferred object
                        var options = {
                            command: 'loadBaselines',
                            args: item
                        };

                        $("#hpsum-localhost").hpsumAddNodeDetails(options);

                        if (guimode == "offline_automatic" || guimode == "offline_interactive") {

                            $("#hpsum-otu-action-mode").hide();
                            $("#hpsum-action-exit-button").show();
                            $("#hpsum-action-cancel-button").hide();


                        }


                        setTimeout(function () {
                            numberofinstallsetandBL = getBLandInstallset();


                            if (numberofinstallsetandBL == 0)
                            {
                                disableMainDialogOkButton();
                              
                            }


                        }, 1000);

                    } else if ((guimode == "offline_automatic" || (guimode == "express")) && iloTasklistlength == 0) {
                        showActionDialog();
                        offlineAutomaticUpdateWithoutTaskQ(NodeID, ilolistdata, data);
                        actiondialog.cancel();
                    }
                    else {
                        if (guimode != "offline_automatic" && guimode != "offline_interactive" && guimode != "express") {
                            showActionDialog();
                            $("#hpsum-localhost").hpsumAddNodeDetails('init');
                            var item = {
                                enableAssignBaselineCheckbox: true,
                                showAssignedBaselines: true,
                                baselineSelectionChanged: onBaselineSelectionChanged,
                                baselineLabel: localizer.getString('hpsum.node.addBaselineOptionalGU')
                            };
                            var options = {
                                command: 'addBaseline',
                                args: item
                            };
                            $("#hpsum-localhost").hpsumAddNodeDetails(options);

                            var item = {
                                isGuidedUpdate: true,
                                data: data.hapi,
                                node_id: NodeID,
                                isGen10: 0

                            };


                            //The command 'loadBaselines' is created by merging both the functions
                            //"getAllBaselines" and "loadBaselinedata" to handle asynchronous ajax call by
                            //using JQuery deferred object
                            var options = {
                                command: 'loadBaselines',
                                args: item
                            };

                            $("#hpsum-localhost").hpsumAddNodeDetails(options);
                        }
                    }


                }


                function DisplayIloTaskQ(data, nodeID) {

                    var NodeID;
                    var Gen10 = 0;
                    if (!nodeID && data && data.hapi)
                        NodeID = data.hapi.node_status.node_id;
                    if (NodeID == null)
                        NodeID = nodeID;
                    if (globalisGen10)
                        Gen10 = 1;
                    var item = {
                        node_id: NodeID
                    }

                    NodePresenter.getTaskQuequeList(item, {
                        success: function (ilolistdata) {
                            
                                GetiLOtaskDetailsnDisplay(NodeID, ilolistdata, data);

                            if (!isRefreshStarted && iSScreenChanged != true)
                                RefreshiLOTaskQ(NodeID, ilolistdata, data);

                        },
                        error: function (msg) {

                           GetiLOtaskDetailsnDisplay(NodeID, ilolistdata, data);

                        }
                    });


                }


            
                function loadNodes() {
                                     
                    var nodeItem = { node_id: 'N1localhost' };
                    var handlers = {
                        success: function (data) {
                            getIndexSuccess(data);


                        },
                        error: function (errorInfo) {
                            getAllNodesError(errorInfo);
                        }
                    };
                   
                  // NodePresenter.getAllNodes(handlers);
                   NodePresenter.getDedicatedNode(nodeItem,handlers);
                }

                function resetattributes() {

                    var nodes = [];
                    nodes = NodePresenter.getNodesForAdvOptions();
                    var attributes = {
                        hapi: {
                            verbose: false,
                            ignore_warnings: false,
                            reboot_options: {
                                delay: "60",
                                action: "Never",
                                message: "Reboot at user request after deploy"
                            },
                            installation_option: {
                                downgrade: false,
                                rewrite: false,
                                force: false,
                                software: true,
                                firmware: true
                            }
                        }
                    };
                    //Resetting the installation option for localhost
                    NodePresenter.setattribute(nodes[0], attributes, {
                        success: function (data) {
                            initReset();
                        },
                        error: function (data) {
                            initReset();
                        }
                    });
                }

                function btnNextClicked(i) {


                    switch (i) {
                        case 0:

                            initNodeSettings();

                            if (bModeNonInteractive)
                                return 0;

                            $("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step");
                            $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step-selected");
                            $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step");

                            return 1;
                        case 1:
                            deployToDo = true;

                             

                            if (selectionChange == true &&
                                bModeNonInteractive == false) {
                                //if no changes to component selection, go directly to deploy
                                btnAnalyzeClicked(STEP_REVIEW, true);
                                return -1;
                            }

                            if (globalisGen10) {
                                if (bModeNonInteractive || (guimode === "offline_automatic"))
                                {

                                    initDeploy();
                                }
                                else
                                {
                                   
                                    if (bModeInteractive)
                                       $('#step' + STEP_REVIEW + 'Next').addClass("hp-button hp-primary");

                                    initDeploy();

                                }


                            }//gen10
                            else
                            {
                                //if no changes to component selection, go directly to deploy
                                initDeploy();
                            }

                            return 2;
                        case 2:
                            $("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step");
                            $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
                            $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step-selected");
                            //handle Reboot functionality here
                            break;
                    }
                }

                function btnPrevClicked(i) {
                    switch (i) {
                        case 1:
                            $("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step-selected");
                            $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
                            $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step");
                            return 0;
                        case 2:

                            $("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step-selected");
                            $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
                            $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step");
                            //Handle reset functionality here as the name of the button is changed reset in this step
                            initReset();
                            window.location.reload();
                            return 0;

                        case 3:
                            $("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step");
                            $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
                            $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step-selected");
                            break;
                    }
                }

                function abortBaselines(step) {
                    //not yet implemented in baseline manager.. so not functional
                }



                function abortNodes(step) {

                    var nodes = [];
                    var op_status;
                    var oNodeTable;
                     
                    if (step == 0) {
                        //iterate through node inventory table
                        //if node is in inventory state, then only send abort command
                        oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();

                        if (oNodeTable)
                            nodes = oNodeTable.fnGetData(0);
                    }
                    else if (step == 2) {
                        oNodeTable = $(INSTALLPROGRESS_TABLE).dataTable();

                        if (oNodeTable)
                            nodes = oNodeTable.fnGetData(0);
                    }

                    //check the current state and send abort command if require
                  
                        var list = nodes.node_uri.split("/");
                        var nodeid = list[4];
                        op_status = nodes.op_status;

                        if (op_status === "inprogress") {
                            if (step == STEP_INVENTORY)
                                oNodeTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.inventoryAbortInProgress"), 0, 4);
                            else if (step == STEP_DEPLOY)
                                oNodeTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.deployAbortInProgress"), 0, 4);
                            NodePresenter.abortNode(nodeid, {
                                row: 0,
                                node_id: nodeid,
                                success: function (data) {
                                    if (data.hapi.hcode == 0) {
                                        oNodeTable.fnUpdate('abort_success', this.row, 6);
                                        oNodeTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.userAborted"), this.row, 2);
                                        oNodeTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>', this.row, 0);
                                        var timer = setInterval(function (index) {
                                            var oNodeTable;
                                            if (index == undefined) {
                                                index = 0;
                                            }
                                            if (step == STEP_INVENTORY) {
                                                oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
                                            }
                                            else if (step == STEP_DEPLOY) {
                                                oNodeTable = $(INSTALLPROGRESS_TABLE).dataTable();
                                            }
                                            if (oNodeTable)
                                                var nodesAdded = oNodeTable.fnGetData(0);
                                            var uri = nodesAdded.node_uri;
                                            var vals = uri.split("/");
                                            var node_id = vals[4];
                                            var nodeItem = {node_id: node_id};
                                            NodePresenter.getNodeStatus(nodeItem, {
                                                success: function (data) {
                                                    if (data.hapi.node_status !== "undefined") {
                                                        if (data.hapi.node_status.node_state.match(/idle/i)) {
                                                            clearInterval(timer);
                                                            if (step == STEP_INVENTORY) {
                                                                oNodeTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.nodeInventoryAborted"), index, 4);
                                                                enableResetButton(step);


                                                            }
                                                            else if (step == STEP_DEPLOY) {
                                                                oNodeTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.nodeDeployAborted"), index, 4);
                                                                enableResetButton(step);


                                                            }
                                                            EnableDisableOfflineExitButton(true);
                                                            //enable exit button post abort completion
                                                            if (guimode === "offline_interactive" || guimode === "offline_automatic") {
                                                                enableRebootButton(step);
                                                            }
                                                            else if (guimode === "offline_automatic") {
                                                                enableRebootButton(step);
                                                            }
                                                            $('#install-progress-' + node_id).hpProgressBar(100);
                                                        }
                                                    }
                                                },
                                                error: function (errorInfo) {
                                                    clearInterval(timer);
                                                }
                                            });
                                        }, 3000, this.row);
                                    }
                                    else {
                                        oNodeTable.fnUpdate('abort_error', this.row, 6);
                                        oNodeTable.fnUpdate(data.hapi.hmessage, this.row, 2);
                                        oNodeTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">ok</span></div></div>', this.row, 0);
                                    }
                                    $('#node-progress-' + this.node_id).hpProgressBar(0);
                                },
                                error: function (errorinfo) {
                                    oNodeTable.fnUpdate('abort_error', this.row, 6);
                                    oNodeTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.userAbortedError"), this.row, 2);
                                    oNodeTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
                                    $('#node-progress-' + this.node_id).hpProgressBar(100);
                                }
                            });
                        }
       
                }

                //Handle abort functionality here
                function btnAbortClicked(i) {

                    //Baseline abort is not yet implemented in engine
                    abortBaselines(i);
                   
                    //issue abort command for each node. Based on the result, update the node state column
                    abortNodes(i);

                    //Disable the next button since we aborted the process.
                    disableNextButton(i);
                    disableAbortButton(i);

                    abortButtonPressed = true;

                    if (globalisGen10)
                        enableResetButton(STEP_INVENTORY);
                }

                function rebootNodes(step) {
                    //Issue reboot command activate to all the nodes
                    //Later on this needs to be enhanced based on node return code (when it is available in REST API)

                     
                    var nodes = [];
                    var op_status;
                    var oNodeTable;

                    if (step == STEP_INVENTORY && guimode === "offline_interactive") {
                        oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
                    }
                    else if (step == STEP_DEPLOY) {
                        oNodeTable = $(INSTALLPROGRESS_TABLE).dataTable();
                    }
                    if (oNodeTable)
                        nodes = oNodeTable.fnGetData(0);
					if(nodes)
					{
                        var i = 0;
                            var list = nodes.node_uri.split("/");
                            var nodeid = list[4];
                            op_status = nodes.op_status;

                            if (op_status == "done" || op_status == "done_error" || op_status == "abort_success") 
							{
                                /* In case of offline_automatic, when deployment is finished with error, user can click on 'reboot'
                                 In that case, we do not do the reboot of the system but only shut down the HSPUM service and so control is handed over to boot environment for rebooting.
                                 */
                                if (guimode === "offline_automatic") {
                                    logOffSession();
                                }
                                else {
                                    NodePresenter.rebootNode(nodeid, {
                                        row: i,
                                        node_id: nodeid,
                                        success: function (data) {
                                            if (data.hapi.hcode == 0) {
                                                oNodeTable.fnUpdate(localizer.getString('hpsum.RebootConfirm.node'), this.row, 2);
                                            }
                                            else {
                                                oNodeTable.fnUpdate(data.hapi.hmessage, this.row, 2);
                                            }
                                        },
                                        error: function (errorinfo) {
                                            oNodeTable.fnUpdate(localizer.getString('hpsum.RebootConfirm.errorReboot'), this.row, 2);
                                        }
                                    });
                                }
                            }
                    
                    }
                    /*
                     Below else if case is required for 'reboot' button on offline_automatic case clicked while warning is presented to user OR on inventory, if no applicable components are present, then 'Reboot' option is presented to the user.
                     In this case installation is not started, $(INSTALLPROGRESS_TABLE) table will not be populated with node data.
                     */
                    else if (guimode === "offline_automatic") {
                        logOffSession();
                    }
                }

                //Handle reboot functionality here
                function btnFinishClicked(step) {

                    var contents = $(rebootConfirmHtml);
                    localizer.localizeDom(contents);
                    $('#hpsum-otu-reboot-title', contents).text(
                        localizer.getString('hpsum.RebootConfirm.title'));

                    var dialogView = new DialogView();
                    dialogView.init({
                        contents: contents,
                        ok: function () {
                            rebootNodes(step);
                        },
                        cancel: function () {
                            return;
                        }
                    });
                }

                function btnResetClicked(step) {

                    if (!$('#step' + step + 'Reset').hasClass("hp-disabled")) {
                        resetattributes();
                        window.location.reload();
                        showActionDialog();
                    }
                }

               

                function showAnalysisSplash() {

                    $(SPLASH_DIALOG).dialog({
                        modal: true,
                        position: "center",
                        draggable: false,
                        resizable: false,
                        show: 'fade',
                        dialogClass: 'hp-splash-dialog',
                        width: 400
                    });

                    $(SPLASH_SPINNER).show();
                }

                function closeAnalysisSplash() {
                    $(SPLASH_SPINNER).hide();
                    $(SPLASH_DIALOG).dialog('destroy');
                }

                function showAnalysisSplashforGen10() {


                    $(SPLASH_DIALOG_ILO).dialog({
                        modal: true,
                        position: "center",
                        draggable: false,
                        resizable: false,
                        show: 'fade',
                        dialogClass: 'hp-splash-dialog',
                        width: 400
                    });

                    $(SPLASH_SPINNER).show();
                    splashrunning = true;
                }

                function closeAnalysisSplashforGen10() {
                    $(SPLASH_SPINNER).hide();
                    $(SPLASH_DIALOG_ILO).dialog('destroy');
                    splashrunning = false;
                }

                function showPreReqsSplash() {

                    $(SPLASH_DIALOG_PREREQS).dialog({
                        modal: true,
                        position: "center",
                        draggable: false,
                        resizable: false,
                        show: 'fade',
                        dialogClass: 'hp-splash-dialog',
                        width: 400
                    });

                    $(SPLASH_SPINNER).show();
                }

                function closePreReqsSplash() {
                    $(SPLASH_SPINNER).hide();
                    $(SPLASH_DIALOG_PREREQS).dialog('destroy');
                }


                

                function btnAnalyzeClicked(step, bdeploy) {


                    var nodes ;//= [];
                    var op_status;
                    var oNodeTable;
                  //  var i = 0;
                    bInAnalysis = true;

                    //iterate through node inventory table
                    //if node is in inventory state, then only send abort command
                    oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();

                    if (oNodeTable)
                        nodes = oNodeTable.fnGetData(0);

                        var breturn = true;
                        var opstatus = nodes.op_status;
                        if (opstatus === "done")
                        {
                                breturn = false;
                        }
                       

                        if (breturn)
                            return;
                
                    showAnalysisSplash();
                   
                    var nodesprocessed = 0;
                   
                    var list = nodes.node_uri.split("/");
                        var nodeid = list[4];
                        op_status = nodes.op_status;

                        if (op_status === "done") {
                            var inst = $('#hpsum-otu-node-' + nodeid + '-installable').data('plugin_hpsumInstallables');
                            var componentsList = inst.getComponents();
                            var item = {node_id: nodeid};

                            oNodeTable.fnUpdate('analyze_inprogress', 0, 6);
                            nodesprocessed++;

                            NodePresenter.analysis(item, componentsList, {
                                node_id: nodeid,
                                success: function (data) {
                                    analyzeSuccess(data, this.node_id);
                                },
                                error: function (errorInfo) {
                                    analyzeError(errorInfo);
                                }
                            });
                        }
                    
                    if (nodesprocessed == 0) {
                        closeAnalysisSplash();
                        disableAnalyzeButton(STEP_REVIEW);
                        return;
                    }

                    var NodesDone = false;

                    var progressTimer = setInterval(function () {
                         
                        oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();

                        if (oNodeTable)
                            nodes = oNodeTable.fnGetData(0);
                                                
                            var uri = nodes.node_uri;
                            var vals = uri.split("/");
                            var nodeid = vals[4];
                            var index = 0;
                            var op_status = nodes.op_status;

                            //if current operation status is started, then only start the inventory, otherwise no need to start inventory
                            if (op_status === "analyze_inprogress") {
                                 
                                rest.getURI(uri + "/getstatus", {
                                    row: index,
                                    node_id: nodeid,
                                    success: function (data) {

                                        if (data.hapi.node_status.node_state === "ANALYSIS") {

                                        }
                                        else if (data.hapi.node_status.node_state === "UAN") {
                                             
                                            oNodeTable.fnUpdate('done', this.row, 6);

                                            NodesDone=true;
                                        }
                                        else if (data.hapi.node_status.node_state === "ERROR") {

                                            oNodeTable.fnUpdate('done', this.row, 6);

                                            NodesDone=true;
                                        }
                                        else if (data.hapi.node_status.node_state === "PENDING_FW_UPDATE") {

                                            oNodeTable.fnUpdate('done', this.row, 6);

                                            NodesDone=true;
                                        }
                                    },
                                    error: function (errorInfo) {

                                    }
                                });
                            }
                       

                        if (NodesDone ==true) {
                            //stop the timer
                            clearInterval(progressTimer);
                            progressTimer = null;

                            //show install review for all the nodes
                            initInstallReview(bdeploy);

                            closeAnalysisSplash();

                        }

                    }, 3000);
                }

                function analyzeSuccess(data, nodeid) {

                }

                function analyzeError(error) {
                    $(SPLASH_SPINNER).hide();
                    $(SPLASH_DIALOG).dialog('destroy');
                }

               
                function validateStep(i) {
                    switch (i) {
                        case 1:  /*alert('This is validated by index'); */
                            return true;
                        default:
                            return true;
                    }
                }

                function validateByTitle(title) {
                    switch (title) {
                        case 'test':  /*alert('This is validated by title');*/
                            return true;
                        default:
                            return true;
                    }
                }

           
                function showActionDialog() {



                    //show action dialog
                    actiondialog = new DialogView();
                    actiondialog.init({
                        contents: actionDialogContents,
                        ok: function (elem) {
                        },
                        cancel: function () {
                        }
                    });


                    if (globalisGen10) {
                        if (guimode !== "offline_automatic" &&
                            guimode !== "offline_interactive") {
                            actiondialog.setMessage({
                                summary: localizer.getString("hpsum.oneTouchUpdate.selectModeTypeDeployment"),
                                status: "ok",
                                details: localizer.getString("hpsum.oneTouchUpdate.moreDetails"),
                                actions: ""/*[linkTargetBuilder.makeLink('Edit device',
                                 '/device/item1', 'edit', 'device')]*/
                            }, true);

                            $("#hpsum-action-exit-button").hide();
                        }

                        if (guimode == "offline_automatic") {


                            $('#baseline_label').show();
                            $('#baselineinstallsetlabel').hide();

                        }
                        else {
                            $('#baseline_label').hide();
                            $('#baselineinstallsetlabel').show();
                        }
                    }
                    else {

                        actiondialog.setMessage({
                            summary: localizer.getString("hpsum.oneTouchUpdate.selectModeTypeDeployment"),
                            status: "ok",
                            details: localizer.getString("hpsum.oneTouchUpdate.moreDetails"),
                            actions: ""/*[linkTargetBuilder.makeLink('Edit device',
                             '/device/item1', 'edit', 'device')]*/
                        }, true);
                        $("#hpsum-action-exit-button").hide();

                    }
					
                    $('#hpsum-action-ok-button', actionDialogContents).unbind('click').bind('click', onOkButton);
                    $('#hpsum-action-cancel-button', actionDialogContents).unbind('click').bind('click', onCancelButton);
                    $('#hpsum-action-exit-button', actionDialogContents).unbind('click').bind('click', onExitButton);
                }

			function onExitButton()
			{
				
				if(guimode !== "offline_automatic" &&
                    guimode !== "offline_interactive" && guimode !== "express")
                {
                    /* In case of Online case and not express we need to route to the welcome screen only */
                    router.go('/welcome', 'canceled guided update');
                }
                else
                {
                    /* in rest cases SHUTDOWN the SUM engine */
				logOffSession();
                }
			
			}
                function updatePrereqsNotifErrorStatus() {
                    if (!prereqsnotificationsView) {
                        prereqsnotificationsView = new NotificationsView();
                        prereqsnotificationsView.init($(PREREQS_DIALOG));
                    }
                    prereqsnotificationsView.clear();

                    prereqsnotificationsView.add({
                        status: NOTIFY_STATUSES["error"],
                        summary: globaldata.hapi.node_status,
                        timestamp: null,
                        changing: false,
                        details: ""

                    });


                }

                function showPreReqDialog() {
                    //show prereqs dialog
                    if (renderRreReqsDialog) {
                        preReqDialog.cancel();
                    }

                    preReqDialog = new DialogView();
                    preReqDialog.init({
                        contents: preReqsDialogContents,
                        ok: function (elem) {
                        },
                        cancel: function () {
                        }
                    });
                    updatePrereqsNotifErrorStatus();
                    if (globaldata.hapi.node_status_hcode == HCODE_F_CHIF_NEEDED) {
                        $(PREREQS_DIALOG_CHECKBOX, preReqsDialogContents).unbind('click').bind('click', onPrereqsCBClicked);
                        $(PREREQS_DIALOG_BUTTON_OK, preReqsDialogContents).show();
                        $(PREREQS_DIALOG_BUTTON_CANCEL, preReqsDialogContents).show();
                        $(PREREQS_DIALOG_BUTTON_NO, preReqsDialogContents).hide();


                        $(PREREQS_DIALOG_BUTTON_OK, preReqsDialogContents).unbind('click').bind('click', onPreReqsOkButton);
                        $(PREREQS_DIALOG_BUTTON_CANCEL, preReqsDialogContents).unbind('click').bind('click', onPreReqCancelButton);
                        $(PREREQS_DIALOG_BUTTON_NO, preReqsDialogContents).unbind('click').bind('click', onPrereqsNOClicked);


                        $(PREREQS_DIALOG_RETRY_LABEL, preReqsDialogContents).hide();
                        enableDisableYesButton(false);
                    }
                    else if (globaldata.hapi.node_status_hcode == HCODE_F_CHIF_REBOOT_NEEDED) {
                        /* no need to show retry . Cancel will be renamed to OK. Other buttons hidden. On Click go to welcome screen*/
                        prereqsNoRetryErrorDialog();
                    }
                    else {
                        prereqsRetryScenario();
                    }

                    renderRreReqsDialog = true;
                }

                function isCHIFRelatedError(data) {
                    data = parseInt(data);
                    switch (data) {
                        case HCODE_F_CHIF_NEEDED:
                        case HCODE_F_CHIF_INSTALL:
                        case HCODE_F_CHIF_SIGNATURE_VERIFICATION_FAILED:
                        case HCODE_F_CHIF_REBOOT_NEEDED:
                        case HCODE_F_CHIF_COMMUNICATE_AFTER_CHIF_INSTALL:
                            return true;
                        default:
                            return false;
                    }
                }

                function prereqsRetryScenario() {
                    $(PREREQS_DIALOG_BUTTON_OK, preReqsDialogContents).val(" " + localizer.getString("hpsum.common.button.yes") + " ");
                    $(PREREQS_DIALOG_BUTTON_NO, preReqsDialogContents).show();
                    $(PREREQS_DIALOG_CB_DIV, preReqsDialogContents).hide();
                    $(PREREQS_DIALOG_RETRY_LABEL, preReqsDialogContents).show();

                    $(PREREQS_DIALOG_CHECKBOX, preReqsDialogContents).unbind('click').bind('click', onPrereqsCBClicked);
                    $(PREREQS_DIALOG_BUTTON_OK, preReqsDialogContents).unbind('click').bind('click', onPreReqsOkButton);
                    $(PREREQS_DIALOG_BUTTON_NO, preReqsDialogContents).unbind('click').bind('click', onPrereqsNOClicked);
                    $(PREREQS_DIALOG_BUTTON_CANCEL, preReqsDialogContents).unbind('click').bind('click', onPreReqCancelButton);
                    enableDisableYesButton(true);
                }

                /* some error where no Retry messgae is needed, call this function */
                function prereqsNoRetryErrorDialog() {
                    $(PREREQS_DIALOG_BUTTON_OK, preReqsDialogContents).hide();
                    $(PREREQS_DIALOG_BUTTON_NO, preReqsDialogContents).hide();
                    $(PREREQS_DIALOG_CB_DIV, preReqsDialogContents).hide();
                    $(PREREQS_DIALOG_RETRY_LABEL, preReqsDialogContents).hide();
                    $(PREREQS_DIALOG_BUTTON_CANCEL, preReqsDialogContents).val(" " + localizer.getString("hpsum.common.button.ok") + " ");
                    $(PREREQS_DIALOG_BUTTON_CANCEL, preReqsDialogContents).unbind('click').bind('click', onPreReqCancelButton);

                }

                function onPrereqsNOClicked() {
                    preReqDialog.cancel();
                }


                function onPrereqsCBClicked() {
                    if ($(PREREQS_DIALOG_CHECKBOX, preReqsDialogContents).is(':checked')) {
                        $('#hpsum-node-edit-install-prereqs-warning', preReqsDialogContents).hide();
                        enableDisableYesButton(true);
                    }
                    else {
                        $('#hpsum-node-edit-install-prereqs-warning', preReqsDialogContents).show();
                        enableDisableYesButton(false);
                    }

                }


                function onPreReqsOkButton() {
                    //on click on OK, install prerequisites
                    showPreReqsSplash();
					var NodeDataItem = {node_id: globalNodeID};
                    var editOptions = {
                        hapi: {
                            install_prereqs: true
                        }
                    };
                    //setting install_prereqs attribute to true
                    NodePresenter.setattribute(NodeDataItem, editOptions, {
                        success: onPrereqsSuccess,
                        error: onPrereqsInstallError
                    });

                }


                function onPrereqsSuccess() {
                    //getdata call
                    var progressTimer = setInterval(function () {
                        var nodeItems = {node_id: NodeDataItem.node_id};
                        NodePresenter.getNodeData(nodeItems, {
                            success: function (data) {
                                globaldata = data;
                                if (data.hapi.node_phase.match(/UserActionNeeded/i)) {
                                    clearInterval(progressTimer);
                                    successfullyInstalledPrereq();
                                    return;
                                }
                                else if (data.hapi.node_phase.match(/unknown/i)) {
                                    clearInterval(progressTimer);
                                    updatePrereqsNotifErrorStatus();
                                    enableDisableYesButton(false);
                                    onPrereqsInstallError();
                                    return;
                                }
                            },
                            error: function () {
                                clearInterval(progressTimer);
                                onPrereqsInstallError();
                                return;
                            }
                        });
                    }, 5000);
                }

                function successfullyInstalledPrereq() {
                    bPrereqsInstalled = true;
                    closePreReqsSplash();
                    preReqDialog.cancel();

                    if (globaldataforprereq != "") {

                        if (!splashrunning)
                            showAnalysisSplashforGen10();

                        WaitUntilIdle(globaldataforprereq);
                    }

                    else
                        $(ACTION_DIALOG).show();
                }

                function onPrereqsInstallError() {
                    closePreReqsSplash();
                    prereqsRetryScenario();

                }


    

                function onPendingIloTaskButton() {

                    iSScreenChanged = true;
                    bShowTaskQueue = true;
                    actiondialog.cancel();

                    var item = {
                        node_id: globalNodeID
                    };


                    NodePresenter.setattribute(item, deployiloupdatesdetail, {
                        success: function () {
                            optiondetails.hapi.ilo_management_options.save_install_set = false;


                            NodePresenter.setattribute(item, optiondetails, {
                                success: function () {

                                    initDeploy();
                                },
                                error: function () {
                                }
                            });


                        },
                        error: function () {
                        }
                    });


                }

                function enableAdvanceOptions() {
                    $(OTU_ADVANCE_ACTION).removeClass('hp-disabled');
                    $(OTU_ADVANCE_ACTION).addClass('company-a');

                }

               
                function onDeployInstallSetButton() {

                    iSScreenChanged = true;
                    modeValue = $('input[name="mode-option"]:checked').val();
                    nodeValue = $('input[name="node-option"]').val();
                    
					
                   
                    var validBaseline = getBaselineData(nodeValue);

                    if (validBaseline) {

                        if (glbSelectedbaseline.installset) {
                            isinstallset = true;
                            bShowTaskQueue = true;
                            /* to show task queue plugin while in install in progress.*/
                            installSetID = glbSelectedbaseline.id;
                            enableAdvanceOptions();
                        }
                        else {
                            isbaseline = true;
                            enableAdvanceOptions();
                        }

                    }

                    var isValid = true;


                    isValid = validateIPdetails(nodeValue);
                    bInProgress = false;
                    if (validBaseline && isValid) {

                      
					  LocalHostGuidedUpdate(isinstallset, installSetID,isGuidedUpdateWithBaselines)
                      actiondialog.cancel();
                    }


                }


                function onOkButton() {


                    if (globalisGen10) {

                        if ($("input[name='install-option']:checked").val() == 'BL') {

                            onDeployInstallSetButton();

                        }
                        if ($("input[name='install-option']:checked").val() == 'TaskQueue') {

                            onPendingIloTaskButton();
                        }


                    }
                    else {

                         
                        enableAdvanceOptions();

                        modeValue = $('input[name="mode-option"]:checked').val();
                        //nodeValue = $('input[name="node-option"]:checked').val();
                        nodeValue = $('input[name="node-option"]').val();

                        var validBaseline = getBaselineData(nodeValue);
                        var isValid = true;

                        isValid = validateIPdetails(nodeValue);
                        bInProgress = false;
                        if (validBaseline && isValid) {
                            if (modeValue === "non-interactive-mode") {
                                autoConfDialog = new DialogView();
                                autoConfDialog.init({
                                    contents: autoConfDialogContents,
                                    ok: function (elem) {

									 
									LocalHostGuidedUpdate(isinstallset, installSetID,isGuidedUpdateWithBaselines)
                                                          },
                                    cancel: function () {
                                        initReset();
                                        window.location.reload();
                                    }
                                });
                            } else {
                                
								 
								LocalHostGuidedUpdate(isinstallset, installSetID,isGuidedUpdateWithBaselines)
                               
                            }
                            actiondialog.cancel();
                        }
                    }
                }

                function onPreReqCancelButton() {
                    if (actiondialog)
                        actiondialog.cancel();

                    if (guimode !== "offline_automatic" &&
                        guimode !== "offline_interactive" && guimode !== "express") {
                        router.go('/welcome', 'canceled guided update');
                    }
                }

                function onCancelButton() {

                    iSScreenChanged = true;

                    if (guimode !== "offline_automatic" &&
                        guimode !== "offline_interactive" && guimode !== "express") {
                        router.go('/welcome', 'canceled guided update');
                    }
                }


                function indexLocation(data) {

                    var i;
                    var oTable = $(INVENTORY_BASELINE_TABLE).dataTable();
		        oTable.fnClearTable();;
                    //iterate through baselines and add them into baselines wizard table
                    for (i = 0; i < data.hapi.output_data.baselines.baseline.length; i += 1) {
                        var item = [{
                            status: '<div class="hp-status hp-changing"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div><div class="hp-status-changing"></div></div>',
                            baseline_name: data.hapi.output_data.baselines.baseline[i].baseline_name,
                            baseline_status: localizer.getString("hpsum.oneTouchUpdate.baselineAdded"),
                            baseline_progress: '<div id="baseline-progress' + i + '" style="height:15px"></div>',
                            baseline_details: '',
                            baseline_uri: data.hapi.output_data.baselines.baseline[i].baseline_uri,
                            op_status: "started"
                        }];

                        //add baseline into baseline inventory table of step1 of wizard
                        oTable.fnAddData(item);

                        $('#baseline-progress' + i).hpProgressBar(0);
                    }

                    baselineIterator -= baselineIterator;
                }

                function onaddLocationSuccess(location, data, isExpressLocation) {
                    var canBeProceeded = false;
                    if (data.hapi.hcode != 0) {
                        onaddLocationError(location, data.hapi.hmessage);
                        return;
                    }

                    var isBundleInvProgress = false;
                    var location_id = data.hapi.command.output_data.location_id;
                    //check whether any bundle under the location inventory is going on and then perform inventory on the location
                    var uri = "/Session/" + session.getToken() + "/Baseline/location/" + location_id + "/index";
                    rest.getURI(uri, {
                        success: function (data) {
                             if (data.hapi.output_data.hasOwnProperty("baselines")) {
                                var baselines = [];
                                baselines = data.hapi.output_data.baselines.baseline;
                                //Check the state of the baselines and set the isBundleInvProgress flag to true.
                                for (var ind = 0; ind < baselines.length; ind++) {
                                    var baselineInfo = baselines[ind];
                                    if (baselineInfo != undefined && baselineInfo.hasOwnProperty("baseline_uri") && baselineInfo.baseline_state != 'inventory_completed') {
                                        isBundleInvProgress = true;
                                    }
                                }
                            }
                            if (!isBundleInvProgress) {
                                //process the output and request for inventory of location
                                var uri = "/Session/" + session.getToken() + "/Baseline/location/" + location_id + "/inventory";

                                rest.getURI(uri,
                                    {
                                        success: function (dataLocSuccess) {
                                            //using timer here as sometimes index command will not provide any output if inventory is issued before
                                            //inventory command take some time to get the result
                                            //so checking until we get something out of index command
                                            var uri = "/Session/" + session.getToken() + "/Baseline/location/" + location_id + "/getstatus";
                                            var timerGetstatus = setInterval(function () {
                                                rest.getURI(uri.replace("inventory", "getstatus"),
                                                    {
                                                        success: function (data) {
                                                            if (data.hapi.location_state == "inventory_completed") {
                                                                canBeProceeded = true;
                                                                clearInterval(timerGetstatus);
                                                                if (data.hapi.total_no_of_bundle > 1) {
                                                                    var error = localizer.getString("hpsum.oneTouchUpdate.moreBundles") + location + localizer.getString("hpsum.oneTouchUpdate.onlyOneAllowed");
                                                                    onaddLocationError(localizer.getString("hpsum.oneTouchUpdate.addBaseline"), error);
                                                                    canBeProceeded = false;
                                                                }
                                                                if (canBeProceeded == true) {
                                                                    rest.getURI(uri.replace("getstatus", "index"),
                                                                        {
                                                                            success: function (dataIndex) {
                                                                                if (dataIndex.hapi.output_data.baselines.baseline.length > 0) {
                                                                                    indexLocation(dataIndex);
                                                                                    clearInterval(timerGetstatus);
                                                                                }
                                                                                else {
                                                                                    clearInterval(timerGetstatus);
                                                                                    onaddLocationError(localizer.getString("hpsum.oneTouchUpdate.additionalPackage"), (localizer.getString("hpsum.oneTouchUpdate.noCompFound") + " " + location));
                                                                                    if (isExpressLocation == false) {
                                                                                        enableResetButton(STEP_INVENTORY);
                                                                                    }
                                                                                }
                                                                                //otherwise also check whether inventory is completed or still in progress
                                                                            },
                                                                            error: function (error) {
                                                                                clearInterval(timerGetstatus);
                                                                                handleExpressExit();
                                                                            }
                                                                        });
                                                                }
                                                            }
                                                        },
                                                        error: function (data) {
                                                            onaddLocationError(location, localizer.getString("hpsum.oneTouchUpdate.failedToAddBaseline"));
                                                            clearInterval(timerGetstatus);
                                                            canBeProceeded = true;
                                                        }
                                                    });
                                            }, 15000);
                                        },
                                        error: function (errorInfo) {
                                            onaddBaselineError(location_id, errorInfo);
                                            handleExpressExit(data);
                                        }
                                    });
                            }
                            else {
                                if (data.hapi.output_data.baselines.baseline.length > 0) {
                                    indexLocation(data);
                                }
                            }
                        },
                        error: function (data) {
                        }
                    });
                }

                function onaddLocationError(location_id, error) {
                    //handle error condition
                    var oTable = $(INVENTORY_BASELINE_TABLE).dataTable();
                     
                    oTable.fnClearTable();

                    var item = [{
                        status: '<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>',
                        baseline_name: location_id,
                        baseline_status: localizer.getString("hpsum.oneTouchUpdate.failedToAddBaseline"),
                        baseline_progress: '',
                        baseline_details: error,
                        baseline_uri: location_id,
                        op_status: 'error'
                    }];

                    bInProgress = false;

                    //add baseline into baseline inventory table of step1 of wizard
                    oTable.fnAddData(item);
                    var data = {
                        hapi: {
                            message: error
                        }
                    };
                    handleExpressExit(data);
                    enableResetButton(STEP_INVENTORY);
                    var guimode = session.getProperty("gui_mode");
                    if (guimode == "offline_interactive")
                        enableRebootButton(STEP_INVENTORY);
                }

                function onaddNodeSuccess(node_name, node_type, data) {


                     
                    //process the output and request for inventory of location
                    var oTable = $(INVENTORY_NODE_TABLE).dataTable();

                    var item = [{
                        status: '<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>',
                        node_name: node_name,
                        node_status: localizer.getString("hpsum.oneTouchUpdate.addedNode"),
                        node_progress: '<div id="node-progress-' + data.hapi.node_id + '" style="height:15px"></div>',
                        node_details: '',
                        node_uri: "/Session/" + session.getToken() + "/node/" + data.hapi.node_id,
                        op_status: "started",
                        progress: 0,
                        node_type: node_type
                    }];

                    //add node into node inventory table of step1 of wizard
                    oTable.fnAddData(item);

                    $('#node-progress-' + data.hapi.node_id).hpProgressBar(0);
                    NodePresenter.setNodeForAdvOptions({node_name: node_name, node_id: data.hapi.node_id});

                    nodeIterator -= nodeIterator;
                }

                function onaddNodeError(node_name, error) {
                    //handle error condition
                    var oTable = $(INVENTORY_NODE_TABLE).dataTable();

                    var item = [{
                        status: '<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>',
                        node_name: node_name,
                        node_status: localizer.getString("hpsum.oneTouchUpdate.failedToAddNode"),
                        node_progress: '',
                        node_details: localizer.getString("hpsum.common.status.error"),
                        node_uri: node_name,
                        op_status: 'error',
                        progress: 0
                    }];

                    //add node into node inventory table of step1 of wizard
                    oTable.fnAddData(item);
                    handleExpressExit();
                }





                
                //  A common function for onetouchguidedupdate and startonetouchupdate
                function LocalHostGuidedUpdate(isInstallSet, installSetID, isGuidedupdate) {
                    
                   
                    var error_condition = false;
                    if (bInProgress == true)
                        return;

                    bStartDeploy = false;

                    //get the selected mode, node option, baselines, nodes
                    var nodes = [], baselines = [];

                    baselineIterator = 0;
	                nodeIterator = 0;

                    //Flag is set to indicate one touch update is in progress
                    bInProgress = true;
                    //Initialize the wizard steps
                    showWizardStep(STEP_INVENTORY);
                    hideWizardStep(STEP_REVIEW);
                    hideWizardStep(STEP_DEPLOY);

                    //Disable next button by default till inventory is done
                    disableNextButton(STEP_INVENTORY);
                    //disable abort button, enable when inventory is in progress
                    disableAbortButton(STEP_INVENTORY);
                    //disable reset button, enable after inventory is completed
                    disableResetButton(STEP_INVENTORY);

                    if (!isGuidedupdate)
                        $('#hpsum-otu-advance-action').removeClass('hp-disabled');

                    var guimode = session.getProperty("gui_mode");
                    var l_expLoc = session.getProperty("express_location");
                    bBaselineInventoryDone = false; //update this to true after all baselines inventory is done



                    if (isInstallSet) {
                        var item = {
                            node_id: 'N1localhost',
                            installset_id: installSetID
                        };
                        NodePresenter.getInstallSetDetails(item, {
                            success: function (data) {

                                if (data.hapi.installset.components) {
                                    var componentcount = 0;
                                    componentcount = data.hapi.installset.components.component.length;
                                    var item = [{
                                        status: '',
                                        baseline_name: localizer.getString('hpsum.node.noItemsFoundInstallsetInventory') + ' ' + localizer.getString('hpsum.oneTouchUpdate.componentsinInstallset') + ' ' + componentcount,
                                        baseline_status: '',
                                        baseline_progress: '',
                                        baseline_details: '',
                                        baseline_uri: '',
                                        op_status: ""
                                    }];

                                    var oTmpTable = $(INVENTORY_BASELINE_TABLE).dataTable();
                                     oTmpTable.fnClearTable();//new clear
                                    oTmpTable.fnAddData(item);
                                    ;

                                }
                            },
                            error: function () {
                            }

                        });


                    }


                    var isExpressLocation = false;
                    if (typeof (l_expLoc) == "undefined") {
                        isExpressLocation = false;
                    }
                    else {
                        isExpressLocation = true;
                    }

                    if (modeValue != undefined) {


                        if (modeValue === "interactive-mode") {
                            bModeInteractive = true;
                            bModeNonInteractive = false;

                            showAllButtons(STEP_INVENTORY);
                        }
                        else if (modeValue === "non-interactive-mode") {
                            bModeInteractive = false;
                            bModeNonInteractive = true;

                            hideAllButtons(STEP_INVENTORY);
                        }

                        if (isGuidedupdate && globalisGen10 && (guimode === "offline_automatic" || guimode === "express"))
                            hideAllButtons(STEP_INVENTORY);

                    }
                    else if (guimode && modeValue === undefined) {
                        //add default localhost into the list
                        nodes.push({
                            node: "localhost",
                            descr: '',
                            uri: "",
                            uname: "",
                            pwd: ""
                        });

                        //add default baseline into the list
                        baselines.push({
                            baseline: "default",
                            descr: 'default',
                            uri: "default",
                            name: "default"
                        });

                        if (guimode === "offline_automatic" || guimode === "express") {
                            bModeNonInteractive = true;
                            bModeInteractive = false;

                            hideAllButtons(STEP_INVENTORY);
                        }
                        else if (guimode === "offline_interactive") {
                            bModeNonInteractive = false;
                            bModeInteractive = true;
                            showAllButtons(STEP_INVENTORY);
                        }
                    }

                    if (isGuidedupdate) {
                        var baselineassigned = false;
                        baselines = [];
                        if (newHotFix != null && newHotFix != "") {
                            baselineassigned = true;
                            baselines.push({
                                baseline: newHotFix.name,
                                descr: '',
                                uri: newHotFix.uri,
                                name: ''
                            });
                        }
                        if (newBaseline != null && newBaseline != '') {
                            baselineassigned = true;
                            baselines.push({
                                baseline: newBaseline.name,
                                descr: '',
                                uri: newBaseline.uri,
                                name: ''
                            });
                        }
                        if (!baselineassigned) {
                            baselines.push({
                                baseline: "default",
                                descr: 'default',
                                uri: "default",
                                name: "default"
                            });
                        }
                        if (nodeValue === "one") {
                            //add localhost into the nodes list
                            nodes = [];
                            nodes.push({
                                node: "localhost",
                                descr: '',
                                uri: "",
                                uname: "",
                                pwd: ""
                            });
                        }
                       else {
                            var oBaselineTable = $(BASELINES_TABLE).dataTable();
                            var oNodeTable = $(NODES_TABLE).dataTable();

                            if (oNodeTable)
                                nodes = oNodeTable.fnGetData(0);
                            if (oBaselineTable)
                                baselines = oBaselineTable.fnGetData();
                        }
                    }


                    var oTable = $(INVENTORY_BASELINE_TABLE).dataTable();
                    oTable.fnClearTable();

                    oTable = $(INVENTORY_NODE_TABLE).dataTable();
                    oTable.fnClearTable();

                    //add all the baselines and node
                    var ind;

                    if (!isInstallSet)//dont add baseline if its an installset
                    {

                        for (ind = 0; ind < baselines.length; ind++) {
                            var uri = baselines[ind].uri;
                            //if the baseline is not already added, then only add it, otherwise just add it to the table and check the status and issue inventory
                            if (uri === "default") {
                                baselineIterator++;
                                if (isExpressLocation == true) {
                                    uri = l_expLoc;
                                }
                                rest.postObject("Session/" + session.getToken() + "/Baseline/add",
                                    {
                                        hapi: {uri: uri, locationtype: 'local'}
                                    }, "",
                                    {
                                        location: uri,
                                        success: function (data) {
                                            onaddLocationSuccess(this.location, data, isExpressLocation);
                                        },
                                        error: function (errorInfo) {
                                            onaddLocationError(baselines[ind].baseline, errorInfo);
                                        }
                                    }, {});
                            }
                            else {
                                var item = [{
                                    status: '<div class="hp-status hp-changing"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div><div class="hp-status-changing"></div></div>',
                                    baseline_name: baselines[ind].baseline,
                                    baseline_status: localizer.getString("hpsum.oneTouchUpdate.baselineAdded"),
                                    baseline_progress: '<div id="baseline-progress' + ind + '" style="height:15px"></div>',
                                    baseline_details: '',
                                    baseline_uri: baselines[ind].uri,
                                    op_status: "started"
                                }];

                                var oTmpTable = $(INVENTORY_BASELINE_TABLE).dataTable();
                                
                                //add baseline into baseline inventory table of step1 of wizard
                                oTmpTable.fnAddData(item);

                                $('#baseline-progress' + ind).hpProgressBar(0);
                            }
                        }

                    }//ifnotinstallset end
                    //add nodes

                        ind = 0;
                        nodeIterator++;
                        var nodename = nodes[ind].node;
                        var nodetype = nodes[ind].descr;
                        var uri = nodes[ind].uri;
                        var item;

                    //for localhost or default node
                    if (uri === "") {
                       
                            item = {
                                ip: nodes[ind].node,
                                name: nodes[ind].node,
                                type: 'unknown',
                                use_current_credentials: true
                            };

                    }
                    else {
                        //node already added in the node screen
                        item = { ip: nodes[ind].node, name: nodes[ind].node, skip_prereqs: false };
                    }
                    if (!isGuidedupdate)
                    item.skip_prereqs = true;
					
					var NodeDataItem = {node_id: globalNodeID};
					var bIsInstallPreReqsChecked = ($(INSTALL_PREREQS_CHECKBOX).is(':checked'));
					if((guimode == "offline_automatic" || guimode == "express") || (!globalisGen10 && guimode == "offline_interactive")){
						bIsInstallPreReqsChecked = true;
					}
					
					var editOptions = {
						hapi: {
							skip_prereqs: (!bIsInstallPreReqsChecked)
						}
					};
                    //setting install_prereqs attribute to true
						NodePresenter.setattribute(NodeDataItem, editOptions, {
							success: function (data) {
                                    },
                                    error: function (data) {
                                    },
						});
					
                    var localNodeItem = { node_id: globalNodeID };
                    NodePresenter.getNodeData(localNodeItem, {
                        success: function (data) {
                            if (data.hapi.node_state.match(/idle/i) && (data.hapi.node_phase.match(/InActive/i) || data.hapi.node_phase.match(/unknown/i))) {
                                /* call add node only IFF satisfies above condition */
                                setTimeout(function () {
									
                                    if (isGuidedupdate) {
                                        rest.postObject("Session/" + session.getToken() + "/node/add",
                                            {
                                                hapi: item
                                            }, "",
                                            {
                                                node_name: nodename,
                                                node_type: nodetype,
                                                success: function (data) {
                                                    onaddNodeSuccess(this.node_name, this.node_type, data);
                                                },
                                                error: function (errorInfo) {
                                                    onaddNodeError(this.node_name, errorInfo);
                                                }
                                            }, {});
                                    }
                                    else {

                                        rest.postObject("Session/" + session.getToken() + "/node/add",
                                            {
                                                hapi: item
                                            }, "",
                                            {
                                                node_name: nodename,
                                                node_type: nodetype,
                                                skip_prereqs: true,
                                                success: function (data) {
                                                    onaddNodeSuccess(this.node_name, this.node_type, data);
                                                },
                                                error: function (errorInfo) {
                                                    onaddNodeError(this.node_name, errorInfo);
                                                }
                                            }, {});
                                    }
                                }, 250);

                                }
                                else {
                                    /* node is already in added and active state. Lets just show this on GUI */
                                    onaddNodeSuccess(nodename, nodetype, data);

                                }
                            },
                            error: function () {
                            }
                        });

                  
                    var baselinesAdded = [], nodesAdded = [], baselinesList = [];
                    var remaining = 100;
                    var bBaselinesDoneCount = 0;
                    var bNodesDoneCount = 0, baselineCount = 0;
                    //check the progress of inventory operation every 2 secs
                    //progressTimer = setInterval(checkProgress(), 2000);
                    nodeadded = false;
                    var oBaselineTable = $(INVENTORY_BASELINE_TABLE).dataTable();
                    if (oBaselineTable)
                        baselines = oBaselineTable.fnGetData();
                    for (var i = 0; i < baselines.length; i++) {
                        var uri = baselines[i].baseline_uri;
                        var sub = uri.search("/location/");
                        baselinesList[baselineCount++] = uri.substr(sub);
                    }


                    if (isGuidedupdate) {
                         
                        var timer = setInterval(function () {
                            var oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
                            if (oNodeTable)
                                nodesAdded = oNodeTable.fnGetData(0);


                            var uri = nodesAdded.node_uri;
                            var vals = uri.split("/");
                            var node_id = vals[4];
                            var nodeItem = { node_id: node_id };
                            NodePresenter.getNodeStatus(nodeItem, {
                                success: function (data) {
                                    if (data.hapi.node_status !== "undefined") {
                                        if (!data.hapi.node_status.node_phase.match(/initialize/i)) {
                                            clearInterval(timer);
                                            nodeadded = true;
                                            //ilotimer = 0;
                                            //presenter.refreshIndexResults();
                                        }
                                        else {
                                            var TableName = '#hpsum-otu-inventory-node tr';
                                            $(TableName)[1].cells[0].innerHTML = '<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>';

                                        }
                                    }
                                },
                                error: function (errorInfo) {
                                    clearInterval(timer);
                                }
                            });
                        }, 3000);
                    }

                    progressTimer = setInterval(function () {

                        if (bModeNonInteractive)
                            hideAllButtons(STEP_INVENTORY);
                        
                        if (!isInstallSet) {
                            if (baselineIterator === 0 && bBaselineInventoryDone === false)//skip incase of installset aswell as skip add baseline
                            {
                                var oBaselineTable = $(INVENTORY_BASELINE_TABLE).dataTable();
                                

                                if (remaining > 10)
                                    remaining -= 10;

                                if (oBaselineTable)
                                    baselinesAdded = oBaselineTable.fnGetData();
                                //start inventory for each baseline
                                for (var i = 0; i < baselinesAdded.length; i++) {
                                    uri = baselinesAdded[i].baseline_uri;
                                    index = i;
                                    op_status = baselinesAdded[i].op_status;

                                    //if currest operation status is started, then only start the inventory, otherwise no need to start inventory
                                    if (op_status === "started") {

                                        if (oBaselineTable) {
                                            oBaselineTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', index, 0);
                                            oBaselineTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryInProgress"), index, 2);
                                            oBaselineTable.fnUpdate('inprogress', index, 6);
                                            $('#baseline-progress' + index).hpProgressBar(1);
                                        }

                                        //disable exit button on start of baseline inventory
                                        EnableDisableOfflineExitButton(false);
                                        rest.getURI(baselinesAdded[i].baseline_uri + "/inventory", {
                                            row: index,
                                            success: function (data) {

                                                var oTmpTable = $(INVENTORY_BASELINE_TABLE).dataTable();
                                                //update status
                                                if (oTmpTable) {
                                                    oTmpTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
                                                    oTmpTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryInProgress"), this.row, 2);
                                                    oTmpTable.fnUpdate('inprogress', this.row, 6);
                                                }

                                                //update progress
                                                $('#baseline-progress' + this.row).hpProgressBar(1);
                                            },
                                            error: function (errorInfo) {
                                                //checkBaselineInventoryError(uri, index, errorInfo);
                                                handleExpressExit();
                                            }
                                        });
                                    }
                                    else if (op_status === "inprogress") {

                                        rest.getURI(uri + "/getstatus", {
                                            row: index,
                                            success: function (data) {
                                                //get the row index for the applicable baseline
                                                if (data.hapi.baseline_state === "inventory_in_progress" || data.hapi.baseline_state === "manifest_component_processing") {
                                                    var currprogress = (data.hapi.baseline_state_detail.current_progress / data.hapi.baseline_state_detail.total_no_component) * 100;
                                                    $('#baseline-progress' + this.row).hpProgressBar(currprogress);

                                                    oBaselineTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
                                                    oBaselineTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryInProgress"), this.row, 2);
                                                    var detail = data.hapi.baseline_state_detail.detail + " (" + data.hapi.baseline_state_detail.current_progress + "/" + data.hapi.baseline_state_detail.total_no_component + ")";
                                                    oBaselineTable.fnUpdate(detail, this.row, 4);
                                                    oBaselineTable.fnUpdate('inprogress', this.row, 6);
                                                }
                                                else if (data.hapi.baseline_state === "inventory_completed") {
                                                    var indx = 0;
                                                    $('#baseline-progress' + this.row).hpProgressBar(100);
                                                    var uri_new = '/location/' + data.hapi.location_id + '/bundle/' + data.hapi.baseline_id;
                                                    for (indx = 0; indx < baselinesList.length; indx++) {
                                                        if (baselinesList[indx] == uri_new) {
                                                            //remove the inventory completed baseline from baseline list and update the count
                                                            baselinesList.splice(indx, 1);
                                                            baselineCount--;
                                                            break;
                                                        }
                                                    }

                                                    oBaselineTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>', this.row, 0);
                                                    oBaselineTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryCompleted"), this.row, 2);
                                                    oBaselineTable.fnUpdate(localizer.getString("hpsum.baseline.show.totalComponents") + ' ' + data.hapi.baseline_state_detail.total_no_component, this.row, 4);
                                                    oBaselineTable.fnUpdate('done', this.row, 6);
                                                    //enable exit button after baseline inventory is finished
                                                    EnableDisableOfflineExitButton(true);
                                                    bBaselinesDoneCount++;
                                                }
                                                else if (data.hapi.baseline_state === "inventory_Failed") {


                                                    var detail = '</br><a id="hpsum-startover-failed-inventory">' + localizer.getString("hpsum.common.startOver") + '</a>';
                                                    var details = data.hapi.baseline_state_detail.detail + detail;
                                                    oBaselineTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
                                                    oBaselineTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryFailed"), this.row, 2);
                                                    oBaselineTable.fnUpdate(details, this.row, 4);
                                                    oBaselineTable.fnUpdate('Failed', this.row, 6);
                                                    enableAbortButton(STEP_INVENTORY);
                                                    enableResetButton(STEP_INVENTORY);
                                                }
                                                else if (data.hapi.baseline_state === "inventory_needed") {
                                                    oBaselineTable.fnUpdate('started', this.row, 6);
                                                }
                                            },
                                            error: function (errorInfo) {
                                                handleExpressExit();
                                            }
                                        });

                                    }
                                }
                                if ((bBaselinesDoneCount >= baselinesAdded.length) && (!baselineCount))
                                    bBaselineInventoryDone = true;


                            }
                        }//skiped incase of installset

                        $('#hpsum-startover-failed-inventory').click(function () {
                            initReset();
                            window.location.reload();
                        });
                        //check if all the nodes are added successfully, we can carry on with the inventory operation
                        //This can be started after completing the baseline inventory

                        if (isInstallSet) bBaselineInventoryDone = true;
                        if (!isGuidedupdate) nodeadded = true;
                        if (nodeIterator === 0 && nodeadded && bBaselineInventoryDone) {
                            var oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
                            var oBaselineTable = $(INVENTORY_BASELINE_TABLE).dataTable();
                            var itemBaselines = {baselines: {baseline: [], remove_existing_baselines:'true'}};
                            var uri, index, op_status, node_id;

                            if (oBaselineTable)
                                baselinesAdded = oBaselineTable.fnGetData();
                             
                            if (oNodeTable)
                                nodesAdded = oNodeTable.fnGetData(0);
                            if (isGuidedupdate) {
                                for (var j = 0; j < baselinesAdded.length; j++) {
                                    var baselineid, paths;
                                    paths = baselinesAdded[j].baseline_uri.split("/");
                                    baselineid = paths[5] + "/" + paths[7];
                                    itemBaselines.baselines.baseline.push(baselineid);
                                }
                            }
                            //start inventory for each baseline
                            var i = 0;
                            
                                uri = nodesAdded.node_uri;
                                var vals = uri.split("/");
                                node_id = vals[4];
                                index = i;
                                op_status = nodesAdded.op_status;
                                var currprogress = nodesAdded.progress;

                            //if current operation status is started, then only start the inventory, otherwise no need to start inventory
                            if (op_status === "started") {

                                if (!isGuidedupdate) {

                                    //get the available baselines and pass it to node inventory
                                    var itemBaselines = { baselines: { baseline: [] } };
                                    for (var j = 0; j < baselinesAdded.length; j++) {
                                        var baselineid, paths;
                                        paths = baselinesAdded[j].baseline_uri.split("/");
                                        baselineid = paths[5] + "/" + paths[7];
                                        itemBaselines.baselines.baseline.push(baselineid);
                                    }

                                }

                                    var oTable = $(INVENTORY_NODE_TABLE).dataTable();
                                    rest.getURI(uri + "/getstatus", {
                                        row: index,
                                        success: function (data) {
                                            if (data.hapi.node_status.node_state === "INVENTORY" || data.hapi.node_status.node_state === "SELFINVENTORY") {
                                                enableAbortButton(STEP_INVENTORY);
                                                //update status
                                                if (oTable) {
                                                    oTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
                                                    oTable.fnUpdate(localizer.getString("hpsum.baseline.nodeInventoryInProgress"), this.row, 2);
                                                    oTable.fnUpdate('inprogress', this.row, 6);
                                                }
                                            }
                                            else if ((data.hapi.node_status.node_phase != "Initialize")) {
                                                oNodeTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', index, 0);
                                                oNodeTable.fnUpdate(localizer.getString("hpsum.baseline.nodeInventoryInProgress"), index, 2);
                                                $('#node-progress-' + node_id).hpProgressBar(1);
                                                oNodeTable.fnUpdate('inprogress', index, 6);


                                                if (installSetID == null) {
                                                    var object = {
                                                        hapi: itemBaselines
                                                    };
                                                }
                                                else {
                                                    var object = {
                                                        hapi: {
                                                            baselines: {

                                                                baseline: installSetID,
																remove_existing_baselines:'true'
                                                            }
                                                        }
                                                    };
                                                }

                                                rest.postObject(uri + "/inventory",
                                                    object,
                                                    "",
                                                    {
                                                        nodeid: node_id,
                                                        row: index,
                                                        success: function (data) {


                                                            //as starting node inventory, disable exit button
                                                            EnableDisableOfflineExitButton(false);
                                                            enableAbortButton(STEP_INVENTORY);
                                                            //update status
                                                            if (oTable) {
                                                                oTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
                                                                oTable.fnUpdate(localizer.getString("hpsum.baseline.nodeInventoryInProgress"), this.row, 2);
                                                                oTable.fnUpdate('inprogress', this.row, 6);
                                                            }

                                                            //move progress bar
                                                            $('#node-progress-' + this.nodeid).hpProgressBar(1);
                                                            oTable.fnUpdate(1, this.row, 7);

                                                            if (data.hapi.hcode != 0) {
                                                                oTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
                                                                oTable.fnUpdate(data.hapi.hmessage, this.row, 4);
                                                                oTable.fnUpdate(localizer.getString("hpsum.baseline.nodeInventoryFailed"), this.row, 2);

                                                                oTable.fnUpdate('done_error', this.row, 6);
                                                                $('#node-progress-' + this.nodeid).hpProgressBar(100);
                                                                oTable.fnUpdate(100, this.row, 7);
                                                                error_condition = true;
                                                                bNodesDoneCount++;
                                                            }

                                                            //Not required. Will remove later after verifying
                                                            //checkNodeInventorySuccess(uri, index, data);
                                                        },
                                                        error: function (errorInfo) {
                                                            checkNodeInventoryError(this.uri, this.row, errorInfo);
                                                        }
                                                    }, {});
                                            }
                                        },
                                        error: function (errorInfo) {
                                            checkNodeInventoryError(this.uri, this.row, errorInfo);
                                        }
                                    });
                                }
                                else if (op_status === "inprogress") {

                                    rest.getURI(uri + "/getstatus", {
                                        uri: nodesAdded.node_uri,
                                        nodeid: node_id,
                                        row: index,
                                        progress: currprogress,
                                        success: function (data) {

                                            //get the row index for the applicable node
                                            var oTable = $(INVENTORY_NODE_TABLE).dataTable();

                                            oTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);

                                            if (data.hapi.node_status.node_state === "INVENTORY") {
                                                if (this.progress < 50) {
                                                    $('#node-progress-' + data.hapi.node_status.node_id).hpProgressBar(this.progress + 2);
                                                    oTable.fnUpdate(this.progress + 2, this.row, 7);
                                                }
                                                oTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
                                                oTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryInProgress"), this.row, 2);
                                                oTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);
                                                oTable.fnUpdate('inprogress', this.row, 6);
                                            }
                                            else if (data.hapi.node_status.node_state === "SELFINVENTORY") {
                                                if (this.progress < 95) {
                                                    $('#node-progress-' + data.hapi.node_status.node_id).hpProgressBar(this.progress + 2);
                                                    oTable.fnUpdate(this.progress + 2, this.row, 7);
                                                }
                                                oTable.fnUpdate('<div class="hp-status hp-changing"><div class="hp-status-changing"></div></div>', this.row, 0);
                                                oTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryInProgress"), this.row, 2);
                                                oTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);
                                                oTable.fnUpdate('inprogress', this.row, 6);
                                            }
                                            else if (data.hapi.node_status.node_state === "UAN") {
                                                $('#node-progress-' + data.hapi.node_status.node_id).hpProgressBar(100);
                                                oTable.fnUpdate(100, this.row, 7);

                                                oTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>', this.row, 0);
                                                oTable.fnUpdate(localizer.getString("hpsum.baseline.show.hostInventoryCompleted"), this.row, 2);
                                                oTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);


                                                oTable.fnUpdate('done', this.row, 6);
                                                bNodesDoneCount++;
                                                //getupdatelist to check the number of components

                                            if (!isInstallSet) {
                                                NodePresenter.getUpdateList(data.hapi.node_status.node_id, {
                                                    success: function (data) {
                                                        var compcount = 0;
                                                        for (var i = 0; i < data.hapi.baselines.baseline.length; i++) {
                                                            if (data.hapi.baselines.baseline[i].hasOwnProperty("components")) {
                                                                compcount += data.hapi.baselines.baseline[i].components.component.length;
                                                            }
                                                        }
                                                        if (compcount == 0) {
                                                            error_condition = true;
                                                            if (!isGuidedupdate)
                                                                oTable.fnUpdate(localizer.getString("hpsum.node.noApplicableComponentsFound"), 0, 4);
                                                        }
                                                    },
                                                    error: function (data) {
                                                        handleExpressExit();
                                                    }
                                                });
                                            }
                                            else {


                                                var item = {
                                                    node_id: globalNodeID,
                                                    installset_id: installSetID
                                                };
                                                NodePresenter.getInstallSetDetails(item, {
                                                    success: function (data) {
                                                        if (data.hapi.installset.components && data.hapi.installset.components.component.length) {
                                                            var componentcount = 0;
                                                            componentcount = data.hapi.installset.components.component.length;
                                                            if (componentcount == 0)
                                                                error_condition = true;
                                                        }
                                                    },
                                                    error: function (data) {
                                                        handleExpressExit();
                                                    }
                                                });
                                            }
                                        }
                                        else if (data.hapi.node_status.node_state === "ERROR") {
                                            $('#node-progress-' + data.hapi.node_status.node_id).hpProgressBar(100);
                                            oTable.fnUpdate(100, this.row, 7);

                                            oTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
                                            oTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryError"), this.row, 2);
                                            oTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);
                                            oTable.fnUpdate('done_error', this.row, 6);
                                            error_condition = true;
                                            bNodesDoneCount++;
                                            enableRebootButton(STEP_INVENTORY);
                                            EnableDisableOfflineExitButton(true);
                                            if (!isGuidedupdate)
                                                disableNextButton(STEP_INVENTORY);
                                        }
                                        else if (data.hapi.node_status.node_state === "PENDING_FW_UPDATE") {
                                            $('#node-progress-' + data.hapi.node_status.node_id).hpProgressBar(100);
                                            oTable.fnUpdate(100, this.row, 7);

                                            oTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
                                            oTable.fnUpdate(localizer.getString("hpsum.baseline.show.inventoryError"), this.row, 2);
                                            oTable.fnUpdate(localizer.getString("hpsum.integrityilo.activateOnNodeScreen"), this.row, 4);
                                            oTable.fnUpdate('done_error', this.row, 6);

                                            bNodesDoneCount++;
                                        }
                                    },
                                    error: function (errorInfo) {
                                        handleExpressExit();
                                    }
                                });
                            }
                            else if (op_status === "abort_error" || op_status === "abort_success") {
                                $('#node-progress-' + node_id).hpProgressBar(100);
                                oNodeTable.fnUpdate(100, index, 7);
                                bNodesDoneCount++;
                            }

                            if (bNodesDoneCount >= 1) {
                                //stop the timer once everything is done
                                clearInterval(progressTimer);
                                clearNotifications();

                                disableAbortButton(0);


                                if (abortButtonPressed) {
                                    // Clear this indicator so that if startOneTouchUpdate gets called again,
                                    // it won't think the abort button was pressed for the current iteration.
                                    abortButtonPressed = false;
                                }
                                // The process was not aborted so get ready for the next step.
                                else {
				var guimode = session.getProperty("gui_mode");
                                    if (isGuidedupdate) {
                                        if (guimode === "offline_interactive")
                                            enableRebootButton(STEP_INVENTORY);

                                        if (globalisGen10) {
                                            enableNextButton(STEP_INVENTORY);
                                            enableResetButton(STEP_INVENTORY);

                                        //Enable Actions
                                        $(HPSUM_OTU_ACTIONS).show();


                                        if (bModeNonInteractive || guimode === "offline_automatic" || guimode === "express") {

                                            if (error_condition == true) {
                                                disableRebootButton(STEP_DEPLOY);
                                                disableNextButton(STEP_INVENTORY);
                                                handleExpressExit();
                                                if (guimode === "offline_automatic")
                                                    enableRebootButton(STEP_INVENTORY);

                                            }
                                            else
                                                btnNextClicked(STEP_INVENTORY);


                                        }
                                        else {

                                            EnableDisableOfflineExitButton(true);


                                            if (error_condition == true) {
                                                disableRebootButton(STEP_DEPLOY);
                                                disableNextButton(STEP_INVENTORY);
                                                handleExpressExit();
                                            }


                                        }

                                    }
                                    else {


                                        enableNextButton(STEP_INVENTORY);
                                        enableResetButton(STEP_INVENTORY);
                                        //Enable Actions
                                        $(HPSUM_OTU_ACTIONS).show();
                                        if (error_condition == true) {
                                            disableRebootButton(STEP_DEPLOY);
                                            disableNextButton(STEP_INVENTORY);
                                        }
                                        //go to deploy step
                                        if (bModeNonInteractive && error_condition == false) {

                                            $("#step0Next").click();
                                        }

                                        }

                                    }
                                    else {
                                        enableNextButton(STEP_INVENTORY);
                                        enableResetButton(STEP_INVENTORY);
                                        var guimode = session.getProperty("gui_mode");
                                        //enable exit button after node inventory is finished
                                        EnableDisableOfflineExitButton(true);
                                        if (guimode === "offline_interactive" || guimode === "offline_automatic") {
                                            enableRebootButton(STEP_INVENTORY);
                                        }
                                        //Enable Actions
                                        $(HPSUM_OTU_ACTIONS).show();
                                        if (error_condition == true) {
                                            disableRebootButton(STEP_DEPLOY);
                                            disableNextButton(STEP_INVENTORY);
                                            handleExpressExit();
                                        }
                                        //go to deploy step


                                        if (bModeNonInteractive) {
                                            if (error_condition == false) {
                                                $("#step0Next").click();
                                            }
                                            else {
                                                enableRebootButton(STEP_INVENTORY);
                                            }
                                        }
                                    }
                                    // Remove reports option from menu for offline mode
                                     if (guimode === "offline_interactive"){
										var items = $(HPSUM_OTU_ACTIONS).children('.hp-options').children();
											for (var id = 0; id < items.length; id++) {
												if ($(items[id]).children().attr('id') === OTU_ADVANCE_REPORTS){
													$(items[id]).remove();
													break;
												}
											}
                                     }
                                }
                            }
                        }

                    }, 3000);




                }


           

                function onSelectionCompleted() {
                    if (bInAnalysis) {
                        if (globalisGen10) {

                            var componentCount = 0;
                            var failedComponentCount = 0;
                            var comsigfilepresent = true;
                            //for (var idx = 0; idx < nodeChanges.length; idx++) {
                                componentCount += nodeChanges[0].component_length;
                                failedComponentCount += nodeChanges[0].failed_dependency_cnt;
                                comsigfilepresent = nodeChanges[0].is_sigfile_available;
                           // }
                            //Check if any component is selected.Validy of the component is done at later state during displaying warnings
                            if (componentCount > 0 && (failedComponentCount == 0 )) {
                                enableNextButton(STEP_REVIEW);
                                isCompSelected = true;
                            }
                            else {
                                isCompSelected = false;
                                disableNextButton(STEP_REVIEW);
                            }

                        }
                        else {
                            var componentCount = 0;
                            var failedComponentCount = 0;
                         
                                componentCount += nodeChanges[0].component_length;
                                failedComponentCount += nodeChanges[0].failed_dependency_cnt;
                            
                            if (componentCount > 0 && failedComponentCount == 0) {
                                enableNextButton(STEP_REVIEW);
                                isCompSelected = true;
                            }
                            else {
                                disableNextButton(STEP_REVIEW);
                                isCompSelected = false;
                            }
                        }
                        disableAnalyzeButton(STEP_REVIEW);

                        bInAnalysis = false;
                    }

                }
				
				
				
				
 function GetWarnings( id, value, componentList, isSaveInstallsetenabled, ignoreWarningChecked)
{

      var iscomsigfilepresnt = componentList.is_sigfile_available;
      var typeCcompSelected = componentList.is_typec_comp_selected;
	  var isSaveInstallsetenabled = $('#saveinstallsetcheckbox')[0].checked;
	  var skip_prereqs = gnodeNodeSettings[0].item.skip_prereqs;
	  globalCompsigPresent = iscomsigfilepresnt;
      globalTypeCcompSelected = typeCcompSelected;
	  var warningMsg = "";
      isCompSelected = false;
	    disableDeploy = false;
		
	    var returnval={
	        bStartDeploy:bStartDeploy,
		deployToDo:deployToDo,
		disableDeploy:disableDeploy,
		isCompSelected:isCompSelected,
		selectionChange:selectionChange,
		showCompsigWarning:showCompsigWarning,
		warningMsg:warningMsg
		}
		
              
		if (componentList.component.length > 0 )
		{
			if((componentList.failed_dependency > 0 )) 
			{
				disableDeploy = true;
			}
			else
			{
				isCompSelected = true;
			}				
	   
			if ((isSaveInstallsetenabled && iscomsigfilepresnt == false) || ( typeCcompSelected && !iscomsigfilepresnt))
			{
				disableDeploy = true;
				deployToDo=false;
				showCompsigWarning = true;
				warningMsg = localizer.getString('hpsum.advanceMode.deployDisabledDueToMissingSigFile');
			}
			else if (componentList.failed_dependency > 0  && componentList.need_prereqinstall && skip_prereqs)
			{
				warningMsg = localizer.getString("hpsum.advanceMode.DeployDisabledAsNoPrereqInstallPermission");
			}
			else 
			{
				showCompsigWarning = false;
				warningMsg = "";
			}

			if(gIsRecoveryiLOCredentialsRequired)
			{
				disableDeploy = true;
				warningMsg = localizer.getString("hpsum.advanceMode.deployDisabledDueToiLOCredentialsReqd");
			}
        }
		else
		{
			showCompsigWarning = false;
			warningMsg = "";
			disableDeploy = true;
			deployToDo=false;
			isCompSelected=false;

		}
		if (value == true)
		{
			selectionChange = true;
		}
	 
	 
	 returnval={
		
	     bStartDeploy:bStartDeploy,
		deployToDo:deployToDo,
		disableDeploy:disableDeploy,
		isCompSelected:isCompSelected,
		selectionChange:selectionChange,
		showCompsigWarning:showCompsigWarning,
		warningMsg:warningMsg
		
		}
	 if(disableDeploy)
	 disableNextButton(STEP_REVIEW);
	 else
	 enableNextButton(STEP_REVIEW);
	 
 return returnval;
 }

 function onSelectionChanged(id, value, componentList) {

      
                    if (globalisGen10) {

                        var warningsArr = [];

                        var warningMsgItemServerWarning = {
                            type: "server",
                            message: gnodeWarnings

                    }
                    warningsArr.push(warningMsgItemServerWarning);
                    var isSaveInstallsetenabled = $('#saveinstallsetcheckbox')[0].checked;
                    var returnval=GetWarnings( id, value, componentList, isSaveInstallsetenabled, ignoreWarningChecked);
                        

                        if (returnval.warningMsg != "") {
                            var warningMsgItem = {
                                type: "server",
                                message:returnval.warningMsg

                            }

                            warningsArr.push(warningMsgItem);

                        }
                        var warningItem = {
                            warnings: warningsArr
                        }

                        if (gnodeWarnings == "") {
                            $('#hpsum-warning-messages').hpsumWarnings(warningItem, false);
                        }
                        else if (gnodeWarnings != "") {

                            //Display the combined warning
                            $('#hpsum-warning-messages').hpsumWarnings(warningItem, true);


                            //Retain the user selection
                            if (ignoreWarningChecked) {
                                $(".ignorewarnings").attr('checked', true);
                            }

                        //Enable deploy  when ignore warning is checked & there are no component signature file missing warning to show
                        if (!returnval.disableDeploy && ignoreWarningChecked && !returnval.showCompsigWarning) {
                            enableNextButton(STEP_REVIEW);
                        }


                        }
						
						
						if (nodeChanges.length > 0 && nodeChanges[0].node_id == id) {
                                nodeChanges[0].component_length = componentList.component.length;
                                nodeChanges[0].failed_dependency_cnt = componentList.failed_dependency;
                            }
                            if (nodeChanges[0].failed_dependency_cnt > 0)
                                deployToDo = false;

                   //if user choose to deploy & selected component has failed dependency then halt the deployment & display review page with dependency failure marked against the component
                 if (returnval.bStartDeploy && deployToDo) {
                        showWizardStep(STEP_DEPLOY);
                        hideWizardStep(STEP_REVIEW);
                        $("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step");
                        $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
                        $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step-selected");
                               
                        initDeploy();
                    }
							
                      

                    }
                    else {
                        if (componentList.component.length > 0 && componentList.failed_dependency == 0) {
                            enableNextButton(STEP_REVIEW);
                            isCompSelected = true;
                        }
                        else {
                            isCompSelected = false;
                        }
                        if (value == true) {
                            selectionChange = true;

                            if (componentList.component.length == 0) {
                                disableNextButton(STEP_REVIEW);
                            }
                            else {
                                enableNextButton(STEP_REVIEW);
                            }

                        }
                        else {

                            if (componentList.component.length <= 0 || componentList.failed_dependency > 0) {
                                bStartDeploy = false;
                                disableNextButton(STEP_REVIEW);
                            }
                        }
                    
                            if (nodeChanges.length > 0 && nodeChanges[0].node_id == id) {
                                nodeChanges[0].component_length = componentList.component.length;
                                nodeChanges[0].failed_dependency_cnt = componentList.failed_dependency;
                            }
                            if (nodeChanges[0].failed_dependency_cnt > 0)
                                deployToDo = false;
               

                        if (componentList.component.length > 0 && componentList.failed_dependency == 0) {
                            // enableNextButton(STEP_REVIEW);
                            if (bStartDeploy) {
                                showWizardStep(STEP_DEPLOY);
                                hideWizardStep(STEP_REVIEW);
                                $("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step");
                                $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
                                $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step-selected");
                                initDeploy();
                            }
                        }
                    }


                }

                function onPopulateInstallSet() {
                    if (deployToDo) {
                     //initDeploy();
                    }
                }

                function initInstallReview(bdeploy) {
                    var oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();

                    var nodes = [];
                    bStartDeploy = bdeploy;

                    //disable deploy button by default. Enable only if some components are ready for installation
                    disableNextButton(STEP_REVIEW);
                    //disable analyze button by default. Enable only if component selection or force option changed
                    disableAnalyzeButton(STEP_REVIEW);
                    showWizardStep(STEP_REVIEW);
                    hideWizardStep(STEP_INVENTORY);
                    hideWizardStep(STEP_DEPLOY);

                    nodeChanges = [];
                     
                    $('#all-installables').empty();

                    if (oNodeTable)
                        nodes = oNodeTable.fnGetData(0);
                  
                    var list = nodes.node_uri.split("/");
                        var nodeid = list[4];
                        var op_status = nodes.op_status;
                        var nodetype = nodes.node_type;

                        if (globalisGen10) {
                            nodeChanges = nodeChanges.concat({
                                node_id: nodeid,
                                component_length: 0,
                                failed_dependency_cnt: 0,
                                is_sigfile_available: true
                            });

                        }
                        else {
                            nodeChanges = nodeChanges.concat({
                                node_id: nodeid,
                                component_length: 0,
                                failed_dependency_cnt: 0
                            });
                        }
                                  

                        var gnodeInd = 0;
                        //for (gnodeInd = 0; gnodeInd < gnodeNodeSettings.length; gnodeInd++) {

                            if (gnodeNodeSettings[gnodeInd].node_id == nodeid) {


                                var warninglength = gnodeNodeSettings[gnodeInd].item.warnings.length;


                                for (var len = 0; len < warninglength; len++) {

                                    var warningtype = gnodeNodeSettings[gnodeInd].item.warnings[len].type;
                                    if (warningtype.match(/ilo/i)) {
                                        gnodeNodeSettings[gnodeInd].item.warnings[len].type = "";
                                        gnodeNodeSettings[gnodeInd].item.warnings[len].message = "";
                                        iLOwarninglength++;


                                    }


                                }
                                if (gnodeNodeSettings[gnodeInd].item.warnings.length == iLOwarninglength && iLOwarninglength != 0) {

                                    onlyiLOwarning = true;

                                    $('#hpsum-warning-messages').hpsumWarnings(gnodeNodeSettings[gnodeInd].item, false);
                                }
                                else {
                                    $('#hpsum-warning-messages').hpsumWarnings(gnodeNodeSettings[gnodeInd].item, true);
                                }


                            }
              
                        $("#hpsum-warning-messages").change(function (e) {


                            var id = $(this).attr("nextid");
                            $(id).removeClass("hp-button hp-primary hp-secondary hp-disabled");

                            if ($(".ignorewarnings").is(':checked') == true) {
                                ignoreWarningChecked = true;
                                $(id).addClass($(this).attr("nextclass"));

                                //Enable Deploy button when its not gen10 & component is selected
                                //Enable Deploy button when its Gen10 & component is selected(or installset is selected) && the selected component doesnot have missing compsig file when save to installset is enabled.
                                if ((!globalisGen10 && isCompSelected) || (globalisGen10 && bModeInteractive ) && (isCompSelected || isinstallset) && (!(glbIsSaveInstallSet && !globalCompsigPresent))) {
                                    enableNextButton(STEP_REVIEW);
                                }

                                //Disable deploy if there are type c component selected and there compsig file is missing.

                        if (globalisGen10 && isCompSelected && !globalCompsigPresent && globalTypeCcompSelected) {
                            disableNextButton(STEP_REVIEW);
                        }
					
                    }
                    else {

                                ignoreWarningChecked = false;
                                $(id).addClass("hp-button hp-secondary hp-disabled");
                                //Disable deploy when ignore warning is false for Gen10 & non Gen10 Server
                                if (!globalisGen10 || globalisGen10 && bModeInteractive) {
                                    disableNextButton(STEP_REVIEW);

                                }
                            }

                            var options = {hapi: {}};
                            options.hapi.ignore_warnings = $(".ignorewarnings").is(':checked');
                            var nodeItem = {node_id: gnodeNodeSettings[0].node_id};

                            //Double events are getting generated in single click of check box,Handle this with a variable
                            if (isIgnoreWarningClicked == false) {
                                isIgnoreWarningClicked = true;
                                NodePresenter.setattribute(nodeItem, options, {
                                    success: function () {
                                        isIgnoreWarningClicked = false;
                                    },
                                    error: function () {
                                        isIgnoreWarningClicked = false;
                                    }
                                });

                            }
                        });
						

						
function operateDeployButtonForUpdateRecovery()
{
	var disableDeploy = false;
	var warningsArr = [];

    var warningMsgItemServerWarning = {
		type: "server",
		message: gnodeWarnings
    }
	warningsArr.push(warningMsgItemServerWarning);
	
	if (gIsRecoveryiLOCredentialsRequired)
	{
		disableDeploy = true;
		var warningMsgItem = {
			type: "server",
			message:localizer.getString("hpsum.advanceMode.deployDisabledDueToiLOCredentialsReqd")
		}

		warningsArr.push(warningMsgItem);
		//iLO credentials are required. disable deploy button.
		disableNextButton(STEP_REVIEW);
	}
	var warningItem = {
		warnings: warningsArr
	}
	if (gnodeWarnings == "")
	{
		$('#hpsum-warning-messages').hpsumWarnings(warningItem, false);
    }
	else if (gnodeWarnings != "")
	{
		//Display the combined warning
		$('#hpsum-warning-messages').hpsumWarnings(warningItem, true);
		
			//Retain the user selection
		if (ignoreWarningChecked) {
			$(".ignorewarnings").attr('checked', true);
		}
		else{
			disableDeploy = true;
		}
	}

	//Enable deploy  when ignore warning is checked & there are no component signature file missing warning to show
	//and a component is selected for deployment or the baseline selected is an installset
	if (!disableDeploy && !showCompsigWarning && ( isinstallset || isCompSelected )) {
		enableNextButton(STEP_REVIEW);
	}	
}


$(UPDATE_RECOVERY_SET_CHECKBOX).live('click', function (ev) {						
	var nodeItem = globaldata_for_recoveryset.hapi;
	if($(UPDATE_RECOVERY_SET_CHECKBOX).is(':checked'))
	{
		gIsUpdateRecoverySet = true;
		if (!nodeItem.ilo_credentials_available)
		{
			$(UPDATE_RECOVERY_ILO_CRDENTIALS_DETAILS).show();
			$(UPDATE_RECOVERY_ILO_USERNAME).val("");
			$(UPDATE_RECOVERY_ILO_USERNAME).removeClass('hp-error');
			$(UPDATE_RECOVERY_ILO_USERNAME_ERR).hide();
			$(UPDATE_RECOVERY_ILO_PASSWORD).val("");
			$(UPDATE_RECOVERY_ILO_PASSWORD).removeClass('hp-error');
			$(UPDATE_RECOVERY_ILO_PASSWORD_ERR).hide();
			
			gIsRecoveryiLOCredentialsRequired = true;
		}
	}
	else
	{
		$(UPDATE_RECOVERY_ILO_CRDENTIALS_DETAILS).hide();
		gIsUpdateRecoverySet = false;
		gIsRecoveryiLOCredentialsRequired = false;
	}
	operateDeployButtonForUpdateRecovery();
});

$(UPDATE_RECOVERY_ILO_USERNAME).live('keyup', function (ev) {
	if ($(UPDATE_RECOVERY_ILO_USERNAME).val() == "")
	{
		$(UPDATE_RECOVERY_ILO_USERNAME).addClass('hp-error');
		$(UPDATE_RECOVERY_ILO_USERNAME_ERR).show();
		gIsRecoveryiLOCredentialsRequired = true;
	}
	else{
		recoveryiLOUsername = $(UPDATE_RECOVERY_ILO_USERNAME).val();
		$(UPDATE_RECOVERY_ILO_USERNAME).removeClass('hp-error');
		$(UPDATE_RECOVERY_ILO_USERNAME_ERR).hide();
		if ($(UPDATE_RECOVERY_ILO_PASSWORD).val() == "")
		{
			gIsRecoveryiLOCredentialsRequired = true;							
		}
		else
		{
			gIsRecoveryiLOCredentialsRequired = false;
		}
	}
	operateDeployButtonForUpdateRecovery();
});
				
$(UPDATE_RECOVERY_ILO_PASSWORD).live('keyup', function (ev) {
	if ($(UPDATE_RECOVERY_ILO_PASSWORD).val() == "")
	{		
		$(UPDATE_RECOVERY_ILO_PASSWORD).addClass('hp-error');
		$(UPDATE_RECOVERY_ILO_PASSWORD_ERR).show();
		gIsRecoveryiLOCredentialsRequired = true;
	}
	else{
		recoveryiLOPassword = $(UPDATE_RECOVERY_ILO_PASSWORD).val();
		$(UPDATE_RECOVERY_ILO_PASSWORD).removeClass('hp-error');
		$(UPDATE_RECOVERY_ILO_PASSWORD_ERR).hide();
		if ($(UPDATE_RECOVERY_ILO_USERNAME).val() == "")
		{
			gIsRecoveryiLOCredentialsRequired = true;							
		}
		else
		{
			gIsRecoveryiLOCredentialsRequired = false;
		}
	}
	operateDeployButtonForUpdateRecovery();
});		
				
				
 $('#saveinstallsetcheckbox').live('click', function (ev) {

                    var warningsArr = [];
                    var warningMsg = "";                               
                    var warningMsgItemServerWarning = {
                        type: "server",
                        message: gnodeWarnings

                    }
                                
                    warningsArr.push(warningMsgItemServerWarning);
								
                    if ($('#saveinstallsetcheckbox')[0].checked == true) 
                    {

                        glbIsSaveInstallSet = true;
						
						//validate and enable option for updating recovery set
						validateToUpdateRecoverySet();
							  
                        if (globalCompsigPresent == false)
                        {
                            warningMsg = localizer.getString('hpsum.advanceMode.deployDisabledDueToMissingSigFile');
                            disableNextButton(STEP_REVIEW);
                            showCompsigWarning=true;
                        }

                                    
                    }
                    else									
                    {
                                    
                        glbIsSaveInstallSet = false;
						
						//disable option for updating recovery set
						validateToUpdateRecoverySet();
						
                        if (globalTypeCcompSelected && !globalCompsigPresent) {
                            warningMsg = localizer.getString('hpsum.advanceMode.deployDisabledDueToMissingSigFile');
                            disableNextButton(STEP_REVIEW);
                        }
                        else if(isCompSelected)
                            enableNextButton(STEP_REVIEW);

                    }

                    if (warningMsg != "") {
                        var warningMsgItem = {
                            type: "server",
                            message: warningMsg

                        }

                        warningsArr.push(warningMsgItem);
                    }
                    var warningItem = {
                        warnings: warningsArr
                    }


                    if (gnodeWarnings == "") 
                    {
                        //Display the component signature file missing warnings
                        $('#hpsum-warning-messages').hpsumWarnings(warningItem, false);
                    }
                    else if (gnodeWarnings != "") 
                    {
                        //Display the combined warning
                        $('#hpsum-warning-messages').hpsumWarnings(warningItem, true);

                                

                        //Retain the user selection
                        if (ignoreWarningChecked)
                        {
                            $(".ignorewarnings").attr('checked', true);
                        }
                        //Enable deploy  when ignore warning is checked & component is selected
                        //Do not enable when there are  missing compsig file component & save component is selected
                        if (ignoreWarningChecked && isCompSelected && (!globalCompsigPresent && !glbIsSaveInstallSet))
                        {
                            enableNextButton(STEP_REVIEW);
                        }


                        //Disable deploy if there are type c component selected and there compsig file is missing.
                        if (ignoreWarningChecked && isCompSelected && !globalCompsigPresent && globalTypeCcompSelected) {
                            disableNextButton(STEP_REVIEW);
                        }
                    }


                            });

                        if (!globalisGen10) {                                                                                                   //nodes[i].node_name
                            $('#all-installables').append('<div class="hp-collapsible" id="hpsum-otu-node-' + nodeid + '-installset"><label><b>' + nodes.node_name + ' ' + localizer.getString("hpsum.oneTouchUpdate.applicableComponents") + '</b></label><div>');
                            $('#hpsum-otu-node-' + nodeid + '-installset').append('<div id="hpsum-otu-node-' + nodeid + '-installable"></div>');
                            var node_Item = {node_id: nodeid, type: nodetype};
                            var options = {
                                command: 'init',
                                nodeItem: node_Item,
                                onSelectionChanged: onSelectionChanged,
                                onSelectionCompleted: onSelectionCompleted,
                                onPopulateInstallSet: onPopulateInstallSet
                            };

                            //call Installables plug-in
                            $('#hpsum-otu-node-' + nodeid + '-installable').hpsumInstallables(options);

                            $('#hpsum-otu-node-' + nodeid + '-installset').hpCollapsible();
                            $('#hpsum-otu-node-' + nodeid + '-installset').hpCollapsible("expand");

                        }
                        else {


                                populateInstallSetTable(nodeid,nodes);
								validateToUpdateRecoverySet();
                           
                            if (isinstallset) {
								
								
                                $('#installsettable').hide();
                                $("#installsetChkBox").hide();
                                $("#installsetmgmtoption").hide();
							   
							 
                                var item = {
                                    node_id: globalNodeID,//'N1localhost',
                                    installset_id: installSetID
                                };
                                NodePresenter.getInstallSetDetails(item, {


                                    success: function (data) {

                                        var stringYes = "Yes", stringNo = "No", stringTrue = true;
                                        var installset = data.hapi.installset;
                                        var sumComponentsCount = 0;
                                        var uefiComponentsCount = 0;
                                        var iLOComponentsCount = 0;
                                        var installset_size = (installset.size / 1024);
                                        if (installset_size > 1024) {
                                            installset_size = installset_size / 1024;
                                            installset_size = installset_size.toFixed(2);
                                            installset_size = installset_size + 'MB';
                                        }
                                        else {
                                            installset_size = installset_size.toFixed(2);
                                            installset_size = installset_size + 'KB';
                                        }

                                        var isRecoverySetvalue = stringNo;
                                        if (installset.isRecoverySet == stringTrue || installset.isRecoverySet == stringYes) {
                                            isRecoverySetvalue = stringYes;
                                        }
                                        //caclulate components.
                                        var INSTALLSET_DIALOG_TITLE = "#installset_dialog_title";
                                        var INSTALLSET_NAME = "#hpsum-installset-name";
                                        var INSTALLSET_COMP_TOTAL = "#hpsum-installset-ComponentsTotal";
                                        var INSTALLSET_SIZE = "#hpsum-installset-size";
                                        var INSTALLSET_ISRECOVERYSET = "#hpsum-installset-isrecoveryset";
                                        var INSTALLSET_SUM_COMPS = "#hpsum-installset-sumcomps";
                                        var INSTALLSET_UEFI_COMPS = "#hpsum-installset-ueficomps";
                                        var INSTALLSET_ILO_COMPS = "#hpsum-installset-ilocomps";
                                        var INSTALLSET_COMPTABLE_TITLE = "#installset_table_title";
                                        var INSTALLSET_COMP_TABLE = "#hpsum_installset_components";
                                        var INSTALLSET_ILO_NEEDS_REBOOT_LABEL = "#hpsum-needs-reboot-ilo-label";
                                        var INSTALLSET_UEFI_NEEDS_REBOOT_LABEL = "#hpsum-needs-reboot-uefi-label";
                                        for (var eachcomp = 0; eachcomp < installset.components.component.length; eachcomp++) {
                                            var updatedByList = installset.components.component[eachcomp].updatedby;
                                            if (updatedByList[0].match(/UEFI/i)) {
                                                uefiComponentsCount++;
                                            } else if (updatedByList[0].match(/SUM\/iSUT/i)) {
                                                sumComponentsCount++;
                                            } else if (updatedByList[0].match(/ILO/i)) {
                                                iLOComponentsCount++;
                                            }
                                        }

                                        if (iLOComponentsCount > 0) {
                                            $(INSTALLSET_ILO_NEEDS_REBOOT_LABEL).show();
                                            $(INSTALLSET_ILO_NEEDS_REBOOT_LABEL).html('<b>' + localizer.getString("hpsum.common.installsetCompNeedsReboot") + '</b>');
                                        }
                                        else {
                                            $(INSTALLSET_ILO_NEEDS_REBOOT_LABEL).hide();
                                        }

                                        if (uefiComponentsCount > 0) {
                                            $(INSTALLSET_UEFI_NEEDS_REBOOT_LABEL).show();
                                            $(INSTALLSET_UEFI_NEEDS_REBOOT_LABEL).html('<b>' + localizer.getString("hpsum.common.installsetCompNeedsReboot") + '</b>');
                                        }
                                        else {
                                            $(INSTALLSET_UEFI_NEEDS_REBOOT_LABEL).hide();
                                        }
                                        $(INSTALLSET_DIALOG_TITLE).html(installset.name);
                                        $(INSTALLSET_NAME).html(' <b>' + installset.name + '</b>');
                                        $(INSTALLSET_COMP_TOTAL).html('<b>' + installset.components.component.length + '</b>');
                                        $(INSTALLSET_SIZE).html(installset_size);
                                        $(INSTALLSET_ISRECOVERYSET).html(isRecoverySetvalue);
                                        $(INSTALLSET_SUM_COMPS).html('<b>' + sumComponentsCount + '</b>');
                                        $(INSTALLSET_UEFI_COMPS).html('<b>' + uefiComponentsCount + '</b>');
                                        $(INSTALLSET_ILO_COMPS).html('<b>' + iLOComponentsCount + '</b>');
                                        $(INSTALLSET_COMPTABLE_TITLE).html(localizer.getString('hpsum.common.installSetDetails'));

                                        // populate components table.
                                        var options = {
                                            command: 'init',
                                            data: data
                                        };

                                        
                                        $(INSTALLSET_COMPTABLE_TITLE).html(localizer.getString('hpsum.common.installSetDetails'));
                                        //Call plugin to show the component list
                                        $(INSTALLSET_COMP_TABLE).hpsumInstallSetComponents(options);
                                        $('#installsettable').show();


                                        var warninglength = gnodeNodeSettings[0].item.warnings.length;

                                        if (bModeInteractive && (warninglength == 0 || onlyiLOwarning)) {
                                            $('#step' + STEP_REVIEW + 'Next').removeClass("hp-button hp-secondary hp-disabled hp-primary");
                                            $('#step' + STEP_REVIEW + 'Next').addClass("hp-button hp-primary");
                                        }

                                        if (iloTasklistlength == 0) {
                                            installsetoptdisabled = true;
                                        }

                                    },
                                    error: function () {
                                    }


                                });

                            
                            }
                            else {
                        
						//$('#installsettable').hide();
                        if (iloTasklistlength == 0) {
                            installsetoptdisabled = true;
                        }
                        $('#hpsum-otu-node-' + nodeid + '-installset').append('<div id="hpsum-otu-node-' + nodeid + '-installable"></div>');
                        var node_Item = {node_id: nodeid, type: nodetype};
                        var options = {
                            command: 'init',
                            nodeItem: node_Item,
                            onSelectionChanged: onSelectionChanged,
                            onSelectionCompleted: onSelectionCompleted,
                            onPopulateInstallSet: onPopulateInstallSet
                        };

                                //call Installables plug-in
                                $('#hpsum-otu-node-' + nodeid + '-installable').hpsumInstallables(options);

                                $('#hpsum-otu-node-' + nodeid + '-installset').hpCollapsible();
                                $('#hpsum-otu-node-' + nodeid + '-installset').hpCollapsible("expand");

                                //enableNextButton(STEP_REVIEW);
                                if (guimode != "offline_automatic")
                                    enableNextButton(STEP_REVIEW);

                            }


                            //if offline automatic mode disable installset option
                            if (guimode === "offline_automatic") {
                                //$("#installsetoptionsradio").hide();
                                $("#installsetChkBox").hide();
                                $("#installsetmgmtoption").hide();
                                installsetoptdisabled = true;
                            }
                            modeValue = $('input[name="mode-option"]:checked').val();
                            if (modeValue === "non-interactive-mode") {
                                $("#installsetChkBox").hide();
                                $("#installsetmgmtoption").hide();
                                
                            }
                        }

                }


                /*
				 *  Function to validate update recovery set option
				 */
				 function validateToUpdateRecoverySet() {
					
					var nodeItem = globaldata_for_recoveryset.hapi;
					$(UPDATE_RECOVERY_SET_DESCR).text(localizer.getString('hpsum.node.updateRecoverySet'));
					$(UPDATE_RECOVERY_SET_CHECKBOX).attr('disabled', true);
					$(UPDATE_RECOVERY_SET_DESCR).addClass('sum-disable-color-grey');							
					$(UPDATE_RECOVERY_ILO_CRDENTIALS_DETAILS).hide();
					$(UPDATE_RECOVERY_SET_CHECKBOX)[0].checked = false;
					
					//If "Save Install Set" option is not selected then just disable UpdateRecoverySet option and return.
					//No need to check for other conditions
					//check below condition only in case of regular baseline
					if(!$(SAVE_INSTALL_SET_CHECBOX).is(':checked')&& !isinstallset)
					{								
						$(UPDATE_RECOVERY_SET_DESCR).attr('tooltip', localizer.getString('hpsum.node.updateRecDisableSaveInstallSetNotSelected')).hpTooltip();
						return;
					}
												
					var ilo_firm_ver = nodeItem.node_ilo_firmware_version.split(".");					
					var ilo_major_ver = parseInt(ilo_firm_ver[0]);
					var ilo_minor_ver = parseInt(ilo_firm_ver[1]);
					
					if(ilo_major_ver < ILO_MIN_MAJOR_VER_FOR_UPDATE_REC_SET || (ilo_major_ver == ILO_MIN_MAJOR_VER_FOR_UPDATE_REC_SET && ilo_minor_ver < ILO_MIN_MINOR_VER_FOR_UPDATE_REC_SET))
					{						
						//Disable "UpdateRecoverySet". Minimum iLO firmware version required is 1.30.
						$(UPDATE_RECOVERY_SET_DESCR).attr('tooltip', localizer.getString('hpsum.node.updateRecSetDisableiLOVerErr')).hpTooltip();
					}
					else if (nodeItem.ilo_credentials_available && !nodeItem.authorized_to_update_recovery_set)
					{
						//Disable "UpdateRecoverySet". Not authorized to update recovery set.
						$(UPDATE_RECOVERY_SET_DESCR).attr('tooltip', localizer.getString('hpsum.node.updateRecSetDisableAuthenticationErr')).hpTooltip();
					}
					else if (!nodeItem.node_recovery_set_present)
					{
						//Disable "UpdateRecoverySet". Currently not recovery set present.
						$(UPDATE_RECOVERY_SET_DESCR).attr('tooltip', localizer.getString('hpsum.node.updateRecSetDisableNoRecoverySetPresent')).hpTooltip();
					}
					else if (!nodeItem.recovery_component_present)
					{
						//Disable "UpdateRecoverySet". No component to update recovery set is present in current install set.
						//iLO, CPLD, BIOS, IE and ME components can update recovery set if processor type is Intel.
						//iLO, CPLD and BIOS components can update recovery set if processor type is AMD.
						$(UPDATE_RECOVERY_SET_DESCR).attr('tooltip', localizer.getString('hpsum.node.updateRecSetDisableNoRecoveryComponentPresent')).hpTooltip();
					}							
					else
					{
						//all good. Enable "UpdateRecoverySet" option.								
						$(UPDATE_RECOVERY_SET_CHECKBOX).attr('disabled', false);
						$(UPDATE_RECOVERY_SET_DESCR).removeClass('sum-disable-color-grey');
						$(UPDATE_RECOVERY_SET_DESCR).attr('tooltip', '').hpTooltip(); //required to remove the previous hover over message
					}
				 }
				 
				 
				/*
                 *  initNodeSettings() : Initialize node settings for each node
                 *  Calls getdata to retrieve settings
                 */
                function initNodeSettings() {

                    var dataDeferred = $.Deferred();
                    var optionsDeferred = $.Deferred();
                     
                    $('#all-installables').empty();

                    var oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();

                    var nodes = [];

                    if (oNodeTable)
                        nodes = oNodeTable.fnGetData(0);

                    if (gnodeNodeSettings.length <= 0) {
                      
                            var list = nodes.node_uri.split("/");
                            var nodeid = list[4];
                            var op_status = nodes.op_status;
                           
						  
                            var nodeItem = {node_id: nodeid};

                            var nodeSetting = {node_id: nodeid, nodename: ''};

                            gnodeNodeSettings.push(nodeSetting);

                            //getdata for the node
                            NodePresenter.getNodeData(nodeItem, {
                                nodeid: nodeid,
                                success: function (data) {

                                    if (gnodeNodeSettings.length <= 0) {
                                        dataDeferred.resolve();
                                        return;
                                    }
									globaldata_for_recoveryset=data;

                                    var gnodeInd = 0;
                                    gnodeNodeSettings[0].nodename = data.hapi.name;
                                    isTPMPresent = data.hapi.tpm_state;
                                    var isSuperdome = data.hapi.superdome;

                                    dataDeferred.resolve();
                                    //getattributes for the node
                                    NodePresenter.otheroption(nodeItem, {
                                        nodeid: nodeid,
                                        success: function (data) {

                                            if (gnodeNodeSettings.length <= 0) {
                                                optionsDeferred.resolve();
                                                return;
                                            }

                                            var gnodeInd = 0;
                                            gnodeNodeSettings[gnodeInd].item = data.hapi;

                                            var warninglength = gnodeNodeSettings[gnodeInd].item.warnings.length;


                                            for (var len = 0; len < warninglength; len++) {
                                               var warningtype = gnodeNodeSettings[gnodeInd].item.warnings[len].type;

                                                if (warningtype.match(/ilo/i)) {

                                                    gnodeNodeSettings[gnodeInd].item.warnings[len].type = "";
                                                    gnodeNodeSettings[gnodeInd].item.warnings[len].message = "";											//gnodeNodeSettings[gnodeInd].item.warnings.length=gnodeNodeSettings[gnodeInd].item.warnings.length-1;
                                                    iLOwarninglength++;

                                                }


                                            }

                                            if (gnodeNodeSettings[gnodeInd].item.warnings.length == iLOwarninglength && iLOwarninglength != 0) {
                                                onlyiLOwarning = true;

                                            }

                                            if (gnodeNodeSettings[gnodeInd].item.warnings && gnodeNodeSettings[gnodeInd].item.warnings.length > 0) {
                                                if (guimode === "express") {
                                                    if (gnodeNodeSettings[gnodeInd].item.ignore_warnings === true) {
                                                        gnodeWarnings = "";
														ignoreWarningChecked = true;
                                                    }
                                                    else if (gnodeNodeSettings[gnodeInd].item.Server_settings.tpm_bypass === true
                                                        && (onlyiLOwarning || isTPMPresent === true)) {
                                                        gnodeWarnings = "";
                                                    }
                                                    else {
                                                        for (var idx = 0; idx < gnodeNodeSettings[gnodeInd].item.warnings.length; idx++)
                                                            gnodeWarnings = gnodeWarnings.concat(gnodeNodeSettings[gnodeInd].item.warnings[idx].message, '<br/>').replace(/\n/g, "\n<br />");
                                                    }
                                                }
                                                else if (isSuperdome === true && bModeNonInteractive) {
                                                    
                                                    if (gnodeNodeSettings[gnodeInd].item.ignore_warnings === true) {
                                                        gnodeWarnings = "";
                                                        ignoreWarningChecked = true;
                                                    }
                                                    else if ((gnodeNodeSettings[gnodeInd].item.warnings.length == 1 && isTPMPresent === true) || onlyiLOwarning) {
                                                        gnodeWarnings = "";
                                                        ignoreWarningChecked = true;
                                                    }
                                                    else {
                                                        for (var idx = 0; idx < gnodeNodeSettings[gnodeInd].item.warnings.length; idx++)
                                                            gnodeWarnings = gnodeWarnings.concat(gnodeNodeSettings[gnodeInd].item.warnings[idx].message, '<br/>').replace(/\n/g, "\n<br />");
                                                    }
                                                    if (ignoreWarningChecked) {
                                                        var options = { hapi: {} };
                                                        options.hapi.tpm_bypass = ignoreWarningChecked;
                                                        var nodeItem = { node_id: gnodeNodeSettings[0].node_id };
                                                        NodePresenter.setattribute(nodeItem, options, {
                                                            success: function () { },
                                                            error: function () { }
                                                        });
                                                    }
												}
                    
                                                else {
                                                    if (onlyiLOwarning) {
                                                        gnodeWarnings = "";
                                                    }
                                                    else {
                                                        for (var idx = 0; idx < gnodeNodeSettings[gnodeInd].item.warnings.length; idx++)
                                                            gnodeWarnings = gnodeWarnings.concat(gnodeNodeSettings[gnodeInd].item.warnings[idx].message, '<br/>').replace(/\n/g, "\n<br />");
                                                    }
                                                }
                                            }


                                            optionsDeferred.resolve();
                                        },
                                        error: function (errorInfo) {
                                            optionsDeferred.resolve();
                                        }
                                    });
                                },
                                error: function (errorInfo) {
                                    dataDeferred.resolve();

                                }
                            });
                     
                    }
                    else {
                        //getnodedata and otheroption rest calls are already done previously, hence no need call these calls again
                        dataDeferred.resolve();
                        optionsDeferred.resolve();
                    }
                    var gui_mode = session.getProperty("gui_mode");

                    $.when(dataDeferred, optionsDeferred).done(function () {
                        //dont show install review and go directly to deploy if non-interactive mode
                        if (bModeNonInteractive || (globalisGen10 && gui_mode == "offline_automatic" || guimode == "express")) {
                            $("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step");
                            $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
                            $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step-selected");
                            showWizardStep(STEP_DEPLOY);
                            hideWizardStep(STEP_REVIEW);
                            hideWizardStep(STEP_INVENTORY);
                            //need to omit the failed_dependency components
                            omitfaileddep();
                        }
                        else {
                            //show review screen with applicable components to user
                            initInstallReview(false);
                        }
                    });
                }

                //Have to do OMITCOMPONENT for the components having failed_dependency and then go for deploy
                function omitfaileddep() {

                var oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
                var nodes = [];
                if (oNodeTable)
                    nodes = oNodeTable.fnGetData(0);
               
                    var list = nodes.node_uri.split("/");
                    var nodeid = list[4];
                    var nodeItem = {node_id: nodeid};
                    NodePresenter.getUpdateList(nodeid, {
                        success: function (data) {
                            var failedcount = 0;
                            for (var blcount = 0; blcount < data.hapi.baselines.baseline.length; blcount++) {
                                if (data.hapi.baselines.baseline[blcount].hasOwnProperty("components")) {
                                    var comps = data.hapi.baselines.baseline[blcount].components.component;
                                    for (var compcount = 0; compcount < comps.length; compcount++) {
                                        var comp = comps[compcount];
                                        if (comp.has_failed_dependencies === true)
                                            failedcount++;
                                    }
                                }
                            }
                            if (failedcount > 0) {
                                var faileddep = {
                                    hapi: {
                                        failed_dependency_handling: "OMITCOMPONENT"
                                    }
                                };
                                NodePresenter.setattribute(nodeItem, faileddep, {
                                    success: function (data) {
                                    },
                                    error: function (data) {
                                    },
                                });
                            }
                        },
                        error: function (data) {
                        }
                    });
                    setTimer(nodes);
               
            }

            function setTimer(nodes) {
                var timer = setTimeout(function () {
                    var uri = nodes.node_uri;
                    rest.getURI(uri + '/getstatus', {
                        success: function (data) {
                            if (data.hapi.node_status.node_state === "ANALYSIS") {
                                //Keep waiting till node state is UAN
                                setTimer(nodes);
                            }
                            else if (data.hapi.node_status.node_state === "UAN") {
                                clearTimeout(timer);
                                timer = '';
                                initDeploy();
                            }
                            else if (data.hapi.node_status.node_state === "ERROR") {
                                clearTimeout(timer);
                                timer = '';
                            }
                        },
                        error: function (errorInfo) {
                            clearTimeout(timer);
                            timer = '';
                        }
                    });
                }, 3000);
            }

                function logOffSession(data, handlers) {

                    var closeHandlers = {
                        success: function () {
                            session.eraseAll();
                            if (handlers && handlers.success) {
                                handlers.success({});
                            }
                            window.document.write("SUM engine has shut down. Please restart the engine to log in.");
                            closeBrowser();
                        },
                        error: function () {
                            Log.error("Error shutting down the engine");
                        }
                    };

                    var shutdownData = {
                        hapi: {
                            force: 'false'
                        }
                    };
                    session.shutDown(shutdownData, closeHandlers);
                    Log.info("initiated shutdown");

            }

           
            

                function recalculateInstallReview() {

                    var nodes = [];
                    var oNodeTable;
                    var NodesDone= false;

                    bInAnalysis = true;

                    showAnalysisSplash();

                    var progressTimer = setInterval(function () {

                        oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
                         
                        if (oNodeTable)
                            nodes = oNodeTable.fnGetData(0);

                        //start inventory for each baseline
                       
                            var uri = nodes.node_uri;
                            var vals = uri.split("/");
                            var nodeid = vals[4];
                            var index = 0;
                         
                            //check whether the current node status is UAN before calling getupdatelist.. need to make sure node is not still in analysis phase
                            rest.getURI(uri + "/getstatus", {
                                row: index,
                                node_id: nodeid,
                                success: function (data) {

                                    if (data.hapi.node_status.node_state === "ANALYSIS") {

                                    }
                                    else if (data.hapi.node_status.node_state === "UAN") {
                                        NodesDone= true;
                                    }
                                    else if (data.hapi.node_status.node_state === "ERROR") {
                                       NodesDone= true;
                                    }
                                    else if (data.hapi.node_status.node_state === "PENDING_FW_UPDATE") {
                                        NodesDone= true;
                                    }
                                },
                                error: function (errorInfo) {

                                }
                            });

                       
                        if (NodesDone== true) {

                            //stop the timer
                            clearInterval(progressTimer);

                            //show install review for all the nodes
                            initInstallReview(false);

                            closeAnalysisSplash();
                        }

                    }, 3000);

                }

                function setAttributesforGen10(nowarningswhileDeploy) {

                    var item = {
                        node_id: globalNodeID
                    };
                    var ignorewarn = false;
                    var saveinstallset = false;					
                    var cleartaskq = false;
                    bShowTaskQueue = true;
                    if (ignoreWarningChecked || nowarningswhileDeploy || onlyiLOwarning)
                        ignorewarn = true;
                   

                    if (isinstallset || isbaseline)
					{

                        cleartaskq = true;

                        if (bModeNonInteractive || (guimode === "offline_automatic"))
                            saveinstallset = false;
                        else {
                            if (glbIsSaveInstallSet == true)
                                saveinstallset = true;
                            }					
                    }
                    else {
                        saveinstallset = false;

                    }

                    var optiondetails_iLO = {
                        hapi: {
                            ignore_warnings: ignorewarn,
                            ilo_management_options: {
                                save_install_set: saveinstallset,
								update_existing_recoveryset: gIsUpdateRecoverySet,
								ilo_username: recoveryiLOUsername,
								ilo_password: recoveryiLOPassword,
                                clear_ilo_update_list: cleartaskq

                            }
                        }

                    };


                    if (!deployStarted) {
                        deployStarted = true;
                        NodePresenter.setattribute(item, optiondetails_iLO, {
                            success: function () {
                                 
                                startDeploy();
                            },
                            error: function () {
                            }
                        });
                    }


                }


                function initDeploy() {

                    $("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step");
                    $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
                    $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step-selected");
                    

                    var oTable = $(INSTALLPROGRESS_TABLE).dataTable();

                    showWizardStep(STEP_DEPLOY);
                    hideWizardStep(STEP_REVIEW);
                    hideWizardStep(STEP_INVENTORY);

                    if (bModeNonInteractive) {
                        hideAllButtons(STEP_DEPLOY);
                    }
                    else {
                        showAllButtons(STEP_DEPLOY);
                        disableBackButton(STEP_DEPLOY);
                        //Adding disable code as by default abort button is in enabled state. 
                        disableAbortButton(STEP_DEPLOY);
                    }
                    var guimode = session.getProperty("gui_mode");
                    disableResetButton(STEP_DEPLOY);
                    disableRebootButton(STEP_DEPLOY);

                    if (guimode === "offline_automatic") {
                        $(HPSUM_OTU_ACTIONS).hide();
                    }
                     
                    oTable.fnClearTable();

                    //clear if any static or previous install results
                    $("#all-installresults").empty();

                    //disable abort button if the selected baseline is installset,.
                    if (globalisGen10 && isinstallset) {
                        disableAbortButton(STEP_DEPLOY);
                    }
                    else {
                        enableAbortButton(STEP_DEPLOY);
                    }

//show the warning checkbox in deploy page when there is non iLO warning

                    if ((bModeNonInteractive || (globalisGen10 && (guimode == "offline_automatic" || guimode == "express"))) && gnodeWarnings.length > 0) {
                        if (globalisGen10 && onlyiLOwarning) {
                             setAttributesforGen10(true);
                        }
                        else {

                            notificationsView.add({
                                status: NOTIFY_STATUSES["warning"],
                                summary: localizer.getString("hpsum.oneTouchUpdate.warningsSummary"),
                                details: gnodeWarnings + '<div><label><input class="useWEBEMcheckbox ignorewarnings-automatic" type="checkbox" />' + localizer.getString('hpsum.common.ignoreWarnings') + '</label></div>'
                            });
                        }

                        notificationsView.pause();
                        disableAbortButton(STEP_DEPLOY);
                        enableResetButton(STEP_DEPLOY);
                        enableRebootButton(STEP_DEPLOY);
                        if (guimode === "offline_interactive" || guimode == "offline_automatic" || guimode == "express") {
                            /* Show the Exit button, as operation paused due to warnings. Note: Not to show in online non express case.*/
                            $('#hp-exit-control').show();
                            $(OFFLINE_EXIT_BUTTON).removeClass('hp-disabled').addClass('company-a');
                        }
                        }

                    else {
                       
                        if (globalisGen10)
                            setAttributesforGen10(false);
                        else
                            startDeploy();
                    }

                    $('.ignorewarnings-automatic').on('change', function () {
                        var ignore_warnings = $(".ignorewarnings-automatic").is(':checked');
                        if (ignore_warnings == true) {
                            $('#step' + STEP_DEPLOY + 'Reboot').hide();
                            var options = {hapi: {}};
                            options.hapi.ignore_warnings = ignore_warnings;
                            var nodeItem = {node_id: gnodeNodeSettings[0].node_id};
                            NodePresenter.setattribute(nodeItem, options, {
                                success: function () {
                                   
                                    if (globalisGen10)
                                        setAttributesforGen10(true);
                                    else
                                        startDeploy();
                                },
                                error: function () {
                                }
                            });
                            notificationsView.resume();
                            notificationsView.clear();
                        }
                    });
                }


                function startDeploy() {

                    var oNodeTable = $(INVENTORY_NODE_TABLE).dataTable();
                    var nodes = [];
                    var index=0;
                    if (oNodeTable)
                        nodes = oNodeTable.fnGetData(0);
                    var NodesDoneCount = 0;
                    var NodesErrorCount = 0;


                if (globalisGen10 && (nodes==null ||nodes.length == 0)) {

                        var nodearr = {
                            length: 1,
                            node_name: 'localhost',
                            node_uri: "/Session/" + session.getToken() + "/node/N1localhost",
                            op_status: "done"

                        };


                    nodes = nodearr;
                }
                   
                    var list = nodes.node_uri.split("/");
                        var nodeid = list[4];

                        //if node is in error state, then dont add it for deploy
                        //if node inventory is not successful or user aborted then dont show it in review
                        //if (nodes[i].op_status != "done")
                        //    continue;
                        var oTable = $(INSTALLPROGRESS_TABLE).dataTable();
                        //add node into the install progress table
                        var item = [{
                            status: '<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>',
                            node_name: nodes.node_name,
                            node_status: localizer.getString("hpsum.oneTouchUpdate.deploymentInProgress"),
                            node_progress: '<div id="install-progress-' + nodeid + '" style="height:15px"></div>',
                            node_details: '',
                            node_uri: nodes.node_uri,
                            op_status: "inprogress", //"started",
                            node_id: nodeid,
                            progress: 0
                        }];

                        //add node into node inventory table of step1 of wizard
                        oTable.fnAddData(item);
                        $("#install-progress-" + nodeid).hpProgressBar(5);
                        /* Code to show install in progress task queue*/

                        //start deploy
                        rest.getURI(nodes.node_uri + "/deploy",
                            {
                                row: index,
                                node_id: nodeid,
                                success: function (data) {
                                    deployToDo = false;
                                    if (globalisGen10 && isinstallset) {
                                        disableAbortButton(STEP_DEPLOY);
                                    }
                                    else {
                                        enableAbortButton(STEP_DEPLOY);
                                    }
                                    var guimode = session.getProperty("gui_mode");
                                    //disable exit button on start of deploy
                                    EnableDisableOfflineExitButton(false);
                                    disableResetButton(STEP_DEPLOY);
                                    // Disable the Actions Drop Down Menu when the Deployment is in progress
                                    $(HPSUM_OTU_ACTIONS).addClass('hp-disabled');
                                    if (guimode === "express") {
                                        /* in express install case, if operation would have paused to satrt deploy due to warnings,
                                         EXIT button must have been enabled there. So after deploy starts Disable and Hide it here */
                                        $(OFFLINE_EXIT_BUTTON).addClass('hp-disabled');
                                        $(OFFLINE_EXIT_BUTTON).unbind('click');
                                        $(OFFLINE_EXIT_BUTTON).hide();
                                    }
                                },
                                error: function (errorInfo) {
                                    deployToDo = false;
                                    handleExpressExit();

                                }
                            });
                        var progressTimer = setInterval(function () {
                            
                            var nodesAdded;
                            var oProgressTable = $(INSTALLPROGRESS_TABLE).dataTable();

                            if (oProgressTable)
                                nodesAdded = oProgressTable.fnGetData(0);
                             
                            //start inventory for each baseline
                            
                            var uri = nodesAdded.node_uri;
                                var vals = uri.split("/");
                                var nodeid = vals[4];
                                var index = 0;
                               
                                var op_status = nodesAdded.op_status;
                                var currprogress = nodesAdded.progress;
                                //if current operation status is started, then only start the inventory, otherwise no need to start inventory
                                if (op_status === "inprogress") {

                                    rest.getURI(uri + "/getstatus", {
                                        row: index,
                                        node_id: nodeid,
                                        progress: currprogress,
                                        success: function (data) {
                                             
                                            if (data.hapi.node_status.node_state === "INSTALL" || data.hapi.node_status.node_state === "INSTALLFROMILOTASKQUEUE" || data.hapi.node_status.node_state === "INSTALLFROMRECOVERYSET") {
                                                if (this.progress < 95) {
                                                    $('#install-progress-' + this.node_id).hpProgressBar(this.progress + 2);
                                                    oProgressTable.fnUpdate(this.progress + 2, this.row, 8);
                                                }

                                                oProgressTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.deploymentInProgress"), this.row, 2);
                                                oProgressTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);
                                                oProgressTable.fnUpdate('inprogress', this.row, 6);
                                            }
                                            else if (data.hapi.node_status.node_state === "INSTALLDONE") {
                                                $('#install-progress-' + this.node_id).hpProgressBar(100);
                                                oProgressTable.fnUpdate(100, this.row, 8);
                                                //Error if the node return code is < 0 means -1/-2/-3
                                                if (data.hapi.node_status.return_code < 0) {
                                                    oProgressTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
                                                    oProgressTable.fnUpdate(localizer.getString("hpsum.node.installDoneWithErrors"), this.row, 2);
                                                    oProgressTable.fnUpdate('done_error', this.row, 6);


                                                } else {
                                                    oProgressTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>', this.row, 0);
                                                    oProgressTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.deploymentCompleted"), this.row, 2);
                                                    oProgressTable.fnUpdate('done', this.row, 6);


                                                }

                                                if (bShowTaskQueue) {
													
                                                    var NodeID = globalNodeID;
                                                    initDeployResults(NodeID, data.hapi.node_status.node_name);


                                                }
                                                EnableDisableOfflineExitButton(true);

                                                oProgressTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);

                                                NodesDoneCount++;
                                            }
                                            else if (data.hapi.node_status.node_state === "ERROR") {
                                                $('#install-progress-' + this.node_id).hpProgressBar(100);
                                                oProgressTable.fnUpdate(100, this.row, 8);

                                                oProgressTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
                                                oProgressTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.deploymentError"), this.row, 2);
                                                oProgressTable.fnUpdate(data.hapi.node_status.node_status, this.row, 4);
                                                oProgressTable.fnUpdate('done_error', this.row, 6);
                                                NodesDoneCount++;
                                                NodesErrorCount++;
                                                EnableDisableOfflineExitButton(true);
                                            }
                                            else {
                                                //for any other state, consider as done with error
                                                $('#install-progress-' + this.node_id).hpProgressBar(100);
                                                oProgressTable.fnUpdate(100, this.row, 8);
                                                oProgressTable.fnUpdate('<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>', this.row, 0);
                                                oProgressTable.fnUpdate(localizer.getString("hpsum.oneTouchUpdate.deploymentError"), this.row, 2);
                                                oProgressTable.fnUpdate('', this.row, 4);
                                                oProgressTable.fnUpdate('done_error', this.row, 6);
                                                NodesDoneCount++;
                                            }
                                        },
                                        error: function (errorInfo) {
                                        }
                                    });
                                }
                            
                            if (NodesDoneCount >= 1) {
                                //stop the timer
                                clearInterval(progressTimer);

                                $('#hpsum-otu-advance-action').addClass('hp-disabled');

                                showAllButtons(STEP_DEPLOY);
                                enableBackButton(STEP_DEPLOY);
                                enableResetButton(STEP_DEPLOY);
                                disableAbortButton(STEP_DEPLOY);
                                enableRebootButton(STEP_DEPLOY);
                                // Enable the Actions Drop Down Menu when the deployment has been completed
                                $(HPSUM_OTU_ACTIONS).removeClass('hp-disabled');


                                if ((NodesErrorCount == 0)) {
                                    EnableDisableOfflineExitButton(true);
                                }

                                if (!bShowTaskQueue)/* in case task queue no need to show this */
                                {
                                    initDeployResults(nodesAdded.node_id, nodesAdded.node_name);
                                    
                                }


                                //if offline automatic mode, then reboot the server
                                var guimode = session.getProperty("gui_mode");
                                if (guimode === "offline_automatic" && op_status == "done") {
                                    // Just shut down HP SUM and let the boot environment take care of rebooting the server
                                    var handlers = {
                                        success: function () {
                                            var newWindow = window.open('', '_self', '');
                                            newWindow.close();
                                        },
                                        error: function () {
                                            var newWindow = window.open('', '_self', '');
                                            newWindow.close();
                                            Log.error("Failed to shutdown Smart Update Manager");
                                        }
                                    };

                                    var shutdownData = {
                                        hapi: {
                                            force: 'false'
                                        }
                                    };
                                    session.shutDown(shutdownData, handlers);
                                }                                
                                else if (guimode === "offline_interactive" && (op_status == "done" || op_status == "done_error")) {
                                    disableResetButton(STEP_DEPLOY);
                                }
                                handleExpressExit();
                            }

                        }, 3000);

                }

                function onCompGetLogsSuccess(data) {
                    showComponentDialog(data);
                }

                function onCompGetLogsError(error) {
                }

                function showComponentDialog(data) {

                    //show component dialog
                    var dialog = new DialogView();
                    dialog.init({
                        contents: componentLogDialogContents,
                        ok: function (elem) {
                            return true;
                        },
                        cancel: function () {
                        }
                    });

                    if (data.hapi.components.component[0].hasOwnProperty('failed_deps')) {
                        $('#component_title').html(localizer.getString("hpsum.oneTouchUpdate.componentDetails"));
                        if (data.hapi.components.component.length > 0) {
                            $('#hpsum-comp-fail-dep').show();
                            $('#hpsum-comp-inst-notes').hide();
                            $('#hpsum-component-id').html(data.hapi.components.component[0].component_id);


                            initFailedDependencyTable('#hpsum-component-failed-dep');

                            var oFailedDepTable = $('#hpsum-component-failed-dep').dataTable();

                            if (oFailedDepTable) {
                                 
                                oFailedDepTable.fnClearTable();
                                for (var i = 0; i < data.hapi.components.component[0].failed_deps.length; i++) {
                                    var item = [
                                        {
                                            failed_dependency: data.hapi.components.component[0].failed_deps[i]
                                        }
                                    ];
                                    oFailedDepTable.fnAddData(item);
                                }
                            }

                            //this is for textarea
                            //$('#hpsum-component-failed-dep').val(data.hapi.components.component[0].failed_deps);

                            if (data.hapi.components.component[0].hasOwnProperty('device_info') && data.hapi.components.component[0].device_info.hasOwnProperty('devices')) {
                                $('#hpsum-device-list-div').empty();

                                $('#hpsum-device-list').show();

                                for (var devInd = 0; devInd < data.hapi.components.component[0].device_info.devices.device.length; devInd++) {
                                    var device = data.hapi.components.component[0].device_info.devices.device[devInd];

                                    //replace white spaces with - as element id should not have white spaces
                                    var headertableid = 'hpsum-devices-header-table-' + device.device_id.replace(/\s+/g, '-').replace(/\./g, '_');
                                    $('#hpsum-device-list-div').append('<table id="' + headertableid + '"><thead><tr><td></td><td></td><td></td></tr></thead></table>');

                                    initDevicesHeaderTable('#' + headertableid);

                                    var headerTable = $('#' + headertableid).dataTable();

                                    var item = [{
                                        deviceid: device.device_id,
                                        productid: device.product_id
                                    }];

                                    headerTable.fnAddData(item);

                                    //replace white spaces with - as element id should not have white spaces
                                    var rowtableid = 'hpsum-devices-rows-table-' + device.device_id.replace(/\s+/g, '-').replace(/\./g, '_');
                                    $('#hpsum-device-list-div').append('<table class="hp-selectable" id="' + rowtableid + '"><thead><tr><td>' + localizer.getString("hpsum.common.type") + '</td><td>' + localizer.getString("hpsum.common.statusStr") + '</td><td>' + localizer.getString("hpsum.node.activeVersion") + '</td><td>' + localizer.getString("hpsum.node.availableVersion") + '</td></tr></thead></table>');

                                    initDevicesRowTable('#' + rowtableid);

                                    var rowTable = $('#' + rowtableid).dataTable();

                                    for (var fwInd = 0; fwInd < device.fw_item.length; fwInd++) {
                                        var fwitem = device.fw_item[fwInd];

                                        var rowitem = [{
                                            type: fwitem.type,
                                            fw_item_status: fwitem.fw_item_status,
                                            active_version: fwitem.active_version,
                                            version: fwitem.version
                                        }];

                                        rowTable.fnAddData(rowitem);
                                    }

                                    $('#' + rowtableid + " tbody tr").click(function (e) {

                                        var data = rowTable.fnGetData(this);

                                        //toggle row selection
                                        $(this).toggleClass('hp-selected');
                                    });
                                }
                            }
                            else {
                                $('#hpsum-device-list-div').empty();
                                $('#hpsum-device-list').hide();
                            }
                        }
                    }
                    else {

                        //reset the component id and log text before showing
                        $('#hpsum-component-id').html('');
                        $('#hpsum-component-installation-notes').val('');

                        $('#component_title').html(localizer.getString("hpsum.oneTouchUpdate.deploymentLog"));
                        if (data.hapi.components.component.length > 0) {
                            $('#hpsum-comp-inst-notes').show();
                            $('#hpsum-comp-fail-dep').hide();
                            $('#hpsum-device-list').hide();
                            $('#hpsum-component-id').html(data.hapi.components.component[0].component_id);
                            $('#hpsum-component-installation-notes').val(data.hapi.components.component[0].component_log);
                        }
                    }

                }

                function initDeployResults(node_id, node_name) {
                     
                    $('.hpsumInstallables').hpsumInstallables('destroy');

                    $("#all-installresults").empty();
                    $('#all-installresults').append('<div class="hp-collapsible" id="hpsum-otu-node-' + node_id + '-installresult"><label>' + node_name + ' - ' + localizer.getString('hpsum.oneTouchUpdate.deploymentResults') + '</label><div>');


                    $('#hpsum-otu-node-' + node_id + '-installresult').hpsumInstallResults();
                    $('#hpsum-otu-node-' + node_id + '-installresult').hpsumInstallResults('viewLogHandler', {
                        success: function (data) {
                            onCompGetLogsSuccess(data);
                        },
                        error: function (data) {
                            onCompGetLogsError(data);
                        }
                    });

                    $('#hpsum-otu-node-' + node_id + '-installresult').hpsumInstallResults("setNodeId", node_id);
                    $('#hpsum-otu-node-' + node_id + '-installresult').hpsumInstallResults("populateTable");
                }

                //Reset functionality
                function initReset() {
                    var oTable;
                    //clear all the tables

                     
                    oTable = $(INVENTORY_BASELINE_TABLE).dataTable();
                    oTable.fnClearTable();
                    $('.hpsumInstallables').hpsumInstallables('destroy');

                    oTable = $(INVENTORY_NODE_TABLE).dataTable();
                    oTable.fnClearTable();

                    oTable = $(INSTALLPROGRESS_TABLE).dataTable();
                    oTable.fnClearTable();

                    //Initialize the wizard steps
                    showWizardStep(STEP_INVENTORY);
                    hideWizardStep(STEP_REVIEW);
                    hideWizardStep(STEP_DEPLOY);

                    //re-initialize bread crumbs
                    $("#hpsum-step1").attr("class", "hpsum-bread-crumbs-step-selected");
                    $("#hpsum-step2").attr("class", "hpsum-bread-crumbs-step");
                    $("#hpsum-step3").attr("class", "hpsum-bread-crumbs-step");

                    bInProgress = false;
                    abortButtonPressed = false;

                
                    loadNodes();

                    //disable Actions menu in the beginning
                    $(HPSUM_OTU_ACTIONS).hide();

                    //reset global gnodeNodeSettings array
                    gnodeNodeSettings = [];

                }

      

                function selectComponents() {
                    if ($('#chkboxheader').attr('checked')) {
                        $('.chkboxcomp').attr('checked', true);
                    }
                    else {
                        $('.chkboxcomp').attr('checked', false);
                    }
                }

                

                function toggleExpansion(row) {
                    if (row.hasClass('hp-expanded')) {
                        $('> td > .hp-collapser', row).removeClass('hp-active');
                        row.removeClass('hp-expanded');
                        row.next().hide();
                    } else {
                        $('> td > .hp-collapser', row).addClass('hp-active');
                        row.addClass('hp-expanded');
                        if ($('.hp-plot', row.next()).children().length === 0) {
                            //initStatistics(row.next());
                        }
                        row.next().show();
                    }
                }

                //Initializes baseline and node inventory tables
                function initInventoryTables() {
                   

                    var oTab = $(INVENTORY_BASELINE_TABLE).dataTable({
                        oLanguage: {
                            sEmptyTable: localizer.getString('hpsum.node.noItemsFound')
                        },
                        bPaginate: false,
                        bProcessing: true,
                        bFilter: false,
                        bSort: false,
                        bAutoWidth: false,
                        bInfo: false,
                        bRetrieve: true,
                        bDestroy: true,
                        //aaData: data,
                        aoColumns: [
                            {
                                mDataProp: 'status',
                                sClass: '<div class="hp-status hp-changing"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div><div class="hp-status-changing"></div></div>'
                            },
                            {mDataProp: 'baseline_name'},
                            {mDataProp: 'baseline_status'},
                            {mDataProp: 'baseline_progress', sClass: '<div id="baseline-progress"></div>'},
                            {mDataProp: 'baseline_details'},
                            {mDataProp: 'baseline_uri', "bVisible": false},
                            {mDataProp: 'op_status', "bVisible": false}],
                        aaSorting: [[0, "asc"]],
                        fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                            //$(nRow).attr('id', aData.component_file_name);
                            return nRow;
                        }
                    });//.rowReordering().addClass('hp-reorderable');

                    $(INVENTORY_BASELINE_TABLE + ' tbody tr').first().addClass('hp-selected');

                     
                    var oTab = $(INVENTORY_NODE_TABLE).dataTable({
                        oLanguage: {
                            sEmptyTable: localizer.getString('hpsum.node.noItemsFound')
                        },
                        bPaginate: false,
                        bProcessing: true,
                        bFilter: false,
                        bSort: false,
                        bAutoWidth: false,
                        bInfo: false,
                        bRetrieve: true,
                        bDestroy: true,
                        //aaData: dataNode,
                        aoColumns: [
                            {
                                mDataProp: 'status',
                                sClass: '<div class="hp-status hp-changing"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div><div class="hp-status-changing"></div></div>'
                            },
                            {mDataProp: 'node_name'},
                            {mDataProp: 'node_status'},
                            {mDataProp: 'node_progress', sClass: '<div id="node-progress"></div>'},
                            {mDataProp: 'node_details'},
                            {mDataProp: 'node_uri', "bVisible": false},
                            {mDataProp: 'op_status', "bVisible": false},
                            {mDataProp: 'progress', "bVisible": false},
                            {mDataProp: 'node_type', "bVisible": false}],
                        aaSorting: [[0, "asc"]],
                        fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                             
                            //$(nRow).attr('id', aData.component_file_name);
                            return nRow;
                        }
                    });

                    $(INVENTORY_NODE_TABLE + ' tbody tr').first().addClass('hp-selected');
                }

                //Initialize component device info row table
                function initFailedDependencyTable(tableid) {

                    var oTab = $(tableid).dataTable({
                        oLanguage: {
                            sEmptyTable: localizer.getString('hpsum.node.noItemsFound'),
                            sSearch: localizer.getString('hpsum.common.search')
                        },
                        bPaginate: false,
                        bProcessing: false,
                        bFilter: false,
                        bSort: false,
                        bAutoWidth: false,
                        bInfo: false,
                        bRetrieve: true,
                        bDestroy: true,
                        aoColumns: [
                            {mDataProp: 'failed_dependency'}
                        ],
                        aaSorting: [],
                        fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                            return nRow;
                        }
                    });

                    $(tableid + ' tbody tr').first().addClass('hp-selected');
                }

                //Initialize component device info row table
                function initDevicesHeaderTable(tableid) {

                    var oTab = $(tableid).dataTable({
                        oLanguage: {
                            sEmptyTable: localizer.getString('hpsum.node.noItemsFound'),
                            sSearch: localizer.getString('hpsum.common.search')
                        },
                        bPaginate: false,
                        bProcessing: false,
                        bFilter: false,
                        bSort: false,
                        bAutoWidth: false,
                        bInfo: false,
                        bRetrieve: true,
                        bDestroy: true,
                        aoColumns: [
                            {mDataProp: 'deviceid'},
                            {mDataProp: 'productid'}
                        ],
                        aaSorting: [],
                        fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                            return nRow;
                        }
                    });

                    $(tableid + ' tbody tr').first().addClass('hp-selected');
                }

                //Initialize component device info row table
                function initDevicesRowTable(tableid) {

                    var oTab = $(tableid).dataTable({
                        oLanguage: {
                            sEmptyTable: localizer.getString('hpsum.node.noItemsFound'),
                            sSearch: localizer.getString('hpsum.common.search')
                        },
                        bPaginate: false,
                        bProcessing: false,
                        bFilter: false,
                        bSort: false,
                        bAutoWidth: false,
                        bInfo: false,
                        bRetrieve: true,
                        bDestroy: true,
                        aoColumns: [
                            {mDataProp: 'type'},
                            {mDataProp: 'fw_item_status'},
                            {mDataProp: 'active_version'},
                            {mDataProp: 'version'}
                        ],
                        aaSorting: [],
                        fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                            return nRow;
                        }
                    });

                    $(tableid + ' tbody tr').first().addClass('hp-selected');
                }

                function initDeployProgressTable() {
                    
                    var oTab = $(INSTALLPROGRESS_TABLE).dataTable({
                        bPaginate: false,
                        bProcessing: true,
                        bFilter: false,
                        bSort: false,
                        bAutoWidth: false,
                        bInfo: false,
                        bRetrieve: true,
                        bDestroy: true,
                        //aaData: data,
                        aoColumns: [
                            {
                                mDataProp: 'status',
                                sClass: '<div class="hp-status hp-changing"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div><div class="hp-status-changing"></div></div>'
                            },
                            {mDataProp: 'node_name'},
                            {mDataProp: 'node_status'},
                            {mDataProp: 'node_progress', sClass: '<div id="install-progress"></div>'},
                            {mDataProp: 'node_details'},
                            {mDataProp: 'node_uri', "bVisible": false},
                            {mDataProp: 'op_status', "bVisible": false},
                            {mDataProp: 'node_id', "bVisible": false},
                            {mDataProp: 'progress', "bVisible": false}],
                        aaSorting: [[0, "asc"]],
                        fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                            //$(nRow).attr('id', aData.component_file_name);
                            return nRow;
                        }
                    });

                    $(INSTALLPROGRESS_TABLE + ' tbody tr').first().addClass('hp-selected');

                }

                function initDeployResultsTable(tableid) {

                    var oTab = $(tableid).dataTable({
                        oLanguage: {
                            sEmptyTable: localizer.getString("hpsum.node.noApplicableComponentsFound"),
                            sSearch: localizer.getString('hpsum.common.search')
                        },
                        bPaginate: false,
                        bProcessing: true,
                        bRetrieve: true,
                        bDestroy: true,
                        bFilter: true,
                        bSort: true,
                        bAutoWidth: false,
                        bInfo: false,
                        //aaData: data,
                        aoColumns: [
                            {
                                mDataProp: 'status',
                                sClass: '<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>'
                            },
                            {mDataProp: 'component_id'},
                            {mDataProp: 'name'},
                            {mDataProp: 'installation_result'},
                            {mDataProp: 'view_log', "bVisible": false},
                            {mDataProp: 'node_uri', "bVisible": false},
                            {mDataProp: 'op_status', "bVisible": false}],
                        aaSorting: [[0, "asc"]],
                        fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                            //$(nRow).attr('id', aData.component_file_name);
                            return nRow;
                        }
                    });

                    $(tableid + ' tbody tr').first().addClass('hp-selected');

                    $(tableid + " tbody tr").click(function (e) {
                        var data = oTab.fnGetData(this);
                    });
                }

                function getBLandInstallset() {


                    var BASELINE_DIV = "#hpsum-localhost";
                    var inst = $(BASELINE_DIV).data('plugin_hpsumAddNodeDetails');
                    var baseline_options = inst.getInstallsetandBL();

                    return baseline_options
                }

                function getBaselineData(nodeValue) {
                     
                    var BASELINE_DIV;
                    if (nodeValue === "one")
                        BASELINE_DIV = "#hpsum-localhost";
                 
                     
                    var inst = $(BASELINE_DIV).data('plugin_hpsumAddNodeDetails');
                    var baseline_options = inst.getSelectedBaseline();
                    if (baseline_options) {
                        newHotFix = baseline_options.newHotFix;
                        newBaseline = baseline_options.newBaseline;
                        glbSelectedbaseline = newBaseline;

                        if (newHotFix != null || newBaseline != null)
                        {
                            isGuidedUpdateWithBaselines = true;
                        }
                        else
                            isGuidedUpdateWithBaselines = false;

                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }

                

                function validateIPdetails(value) {

                    var isValid = true;
                    if (value === "one")
                        isValid = true;
                    else {
                        isValid = false;
                        $("#hpsum-existing-node-err").html("Required");
                        $("#hpsum-existing-node-err").show();
                    }

                    return isValid;
                }

                function nodeOptions(value) {
                    var DIV_ID;
                    var nodeItem = { node_id: 'N1localhost' };;
                     
                    if (value && value.target)
                        value = value.target.value;
                    if (value == "one") {
                        $("#hpsum-localhost").show();
                        DIV_ID = "#hpsum-localhost";
                        
                            
                    }
                   

                    if (value != "three" && nodeItem.node_id != '') {
                        NodePresenter.getNodeData(nodeItem, {
                            success: function (data) {

                                var item = {
                                    isGuidedUpdate: true,
                                    data: data.hapi
                                };
                                //The command 'loadBaselines' is created by merging both the functions
                                //"getAllBaselines" and "loadBaselinedata" to handle asynchronous ajax call by
                                //using JQuery deferred object
                                var options = {
                                    command: 'loadBaselines',
                                    args: item
                                };
                                $(DIV_ID).hpsumAddNodeDetails(options);
                            },
                            error: function () {
                            }
                        });
                    }
                }

                /**
                 * @public
                 */
                this.pause = function () {

                    // $(SUM_PENDINGLIST_TABLE).hpsumAddiLOTaskDetails('destroy');
                };

                this.resume = function () {

                    if (bInProgress == false) {
                        if (bisPrereqsreq && !bPrereqsInstalled) {
                            if (!splashrunning)
                                showAnalysisSplashforGen10();
                            WaitUntilIdle(globalNodeID);

                        }
                        else if (!bisPrereqsreq && globalisGen10) {

                            initReset();

                           
                            //load nodes list. This is used to display in action dialog nodes table
                            loadNodes();

                            //disable Actions menu in the beginning
                            $(HPSUM_OTU_ACTIONS).hide();

                            //reset global gnodeNodeSettings array
                            gnodeNodeSettings = [];
                            var nodeItem = {node_id: globalNodeID};

                            NodePresenter.getNodeData(nodeItem, {
                                success: function (data) {

                                    glbdata = data;
                                    DisplayIloTaskQ(data, data.hapi.node_id);
                                },
                                error: function () {
                                }
                            });
                        }
                        else if (!globalisGen10 && !bisPrereqsreq) {

                            initReset();
                           
                            //load nodes list. This is used to display in action dialog nodes table
                            loadNodes();

                            //disable Actions menu in the beginning
                            $(HPSUM_OTU_ACTIONS).hide();

                            //reset global gnodeNodeSettings array
                            gnodeNodeSettings = [];
                            showActionDialog();


                        }


                        //document.getElementById("interactive-mode").checked = true;

                        bStartDeploy = false;
                        $('#hpsum-otu-inventory-baseline-collapse').show();
                        $('#hpsum-otu-action-title-message').text(localizer.getString("hpsum.oneTouchUpdate.baselineNodeInvTitle"));
                    }
                    else {
                        if (window.bRefreshReview == true && $('#hpsum-step2')[0].className == "hpsum-bread-crumbs-step-selected") {
                            recalculateInstallReview();
                            window.bRefreshReview = false;
                        }
                    }
                   
                };

         
                function getBaselinesSuccess(searchResults) {
                    baselines = $.grep(searchResults, function (option, index) {
                        return !(option.name.match(new RegExp('^Additional', 'i')));
                    });
                    hotfixes = $.grep(searchResults, function (option, index) {
                        return (option.name.match(new RegExp('^Additional', 'i')));
                    });

                }

                function getBaselinesError(msg) {

                }

                function enableDisableYesButton(enable) {
                    if (enable) {
                        $(PREREQS_DIALOG_BUTTON_OK, preReqsDialogContents).unbind('click').bind('click', onPreReqsOkButton);
                        $(PREREQS_DIALOG_BUTTON_OK).removeClass("hp-button hp-primary hp-disabled").addClass("hp-button hp-primary");
                    }
                    else {
                        $(PREREQS_DIALOG_BUTTON_OK, preReqsDialogContents).unbind('click');
                        $(PREREQS_DIALOG_BUTTON_OK).removeClass("hp-button hp-primary").addClass("hp-disabled");
                    }
                }


                function WaitUntilIdle(data) {

                    var timer = setTimeout(function () {
                        var nodeItem = {node_id: data};
                        NodePresenter.getNodeData(nodeItem, {
                            success: function (data) {
                                globaldata = data;
                                if (data.hapi.node_phase.match(/Initialize/i) && !data.hapi.node_state.match(/ILO_TASK_INPROGRESS/i)) {
                                    //Keep waiting till node state is not unknown

                                    WaitUntilIdle(data.hapi.node_id);
                                }
                                else if (data.hapi.node_state.match(/idle/i) &&
                                    data.hapi.node_phase.match(/unknown/i)) {

                                    if (splashrunning)
                                        closeAnalysisSplashforGen10();
                                    clearTimeout(timer);
                                    timer = '';
                                    bisPrereqsreq = true;
                                    if (preReqsDialogContents == undefined)
                                        preReqsDialogContents = $(PREREQS_DIALOG).detach().show();

                                    NodeDataItem = data.hapi;
                                    globalNodeID = data.hapi.node_id;
                                    globaldataforprereq = data.hapi.node_id;
                                    if (isCHIFRelatedError(NodeDataItem.node_status_hcode)) {
                                        installPreReqs();
                                        /* go to prereqs control path only if the add node failed due to prereqs things.*/
                                    }
								if(NodeDataItem.node_status_hcode == HCODE_F_CAC_MODE_ENABLED)
								{								
									showiLOCACHighSecurityDialog();
									return;
								}
								else if(NodeDataItem.node_status_hcode == HCODE_F_HIGHSECURITY_MODE)
								{								
									if(guimode == "offline_automatic" || guimode == "express")
									{	
										isHighSecurity = true;
										showiLOCACHighSecurityDialog();
									}
									else
									{ 
										showiLOCredentialsDialog();
									}
									return;
								}
								else if(NodeDataItem.node_status_hcode == HCODE_F_BIOS_PASSWORD_ENABLED)
								{								
									isBIOSPasswordSet = true;
									if(guimode == "offline_automatic" || guimode == "express")
									{										
										showiLOCACHighSecurityDialog();
									}
									else
									{ 
										showiLOCredentialsDialog();
									}
									return;
								}
								else if(NodeDataItem.node_status_hcode == HCODE_F_INVALID_ILO_CREDENTIALS)
								{
									isInvalidiLOCredentials = true;
									if(guimode == "express")
									{
										showiLOCACHighSecurityDialog();
									}
									else
									{
										showiLOCredentialsDialog();
									}
									return;
								}
                                    else {
                                        bisPrereqsreq = false;
                                        globalNodeID = data.hapi.node_id;

                                        if (splashrunning) {
                                            closeAnalysisSplashforGen10();
                                        }
                                        globalisGen10 = false;
                                        if (timer) {
                                            clearTimeout(timer);
                                            timer = '';
                                        }
                                        Initialize();
                                    }
                                }
                                else {

                                    bisPrereqsreq = false;
                                    globalNodeID = data.hapi.node_id;

                                    if (splashrunning)
                                        closeAnalysisSplashforGen10();
                                    
                                    // Even though server generation is identified based on show_baseline_or_installset flag to decide to show or hide 'baseline or installset' UI option
                                    // For OEM server data.hapi.show_baseline_or_installset flag will be false for offline mode but true for online
                                    // For non-OEM server data.hapi.show_baseline_or_installset will true for online and offline
                                    if (data.hapi.server_generation >= 10){
                                        globalisGen10 = data.hapi.show_baseline_or_installset;
									}


                                    clearTimeout(timer);
                                    timer = '';
                                    Initialize();

                                }
                            },
                            error: function (errorInfo) {
                                clearTimeout(timer);
                                timer = '';
                            }
                        });
                    }, 1000);
                }

                function GetServerinfoandNodeID() {

		   //Send skip_prereqs=false by default for automatic, for interactive mode this flag can be changed in setattributes based on user selection
                    var item = {ip: 'localhost', name: 'localhost', skip_prereqs: false}; 
                    var nodename = 'localhost';
                    var nodetype = 'windows';
                    var NodeID = 'N1localhost';
                     
                    var uri = '/session/' + session.getToken() + '/node/' + NodeID + '/index';
                    rest.getURI(uri, {
                        success: function (data) {
                            var node_state = data.hapi.output_data.nodes.node.node_state;
                            var node_phase = data.hapi.output_data.nodes.node.node_phase;

                            if (node_state == undefined || node_phase == undefined || node_state.match(/Idle/i) && node_phase.match(/InActive/i)) {
                                rest.postObject("Session/" + session.getToken() + "/node/add",
                                    {
                                        hapi: item
                                    }, "",
                                    {
                                        node_name: nodename,
                                        node_type: nodetype,
                                        success: function (data) {
                                            NodePresenter.setNodeForAdvOptions({
                                                node_name: nodename,
                                                node_id: data.hapi.node_id
                                            });

                                            WaitUntilIdle(data.hapi.node_id);


                                        },
                                        error: function (errorInfo) {
                                            onaddNodeError(this.node_name, errorInfo);

                                        }

                                    }, {});
                            }
                            else {
                                NodePresenter.setNodeForAdvOptions({
                                    node_name: nodename,
                                    node_id: data.hapi.output_data.nodes.node.node_id
                                });
                                WaitUntilIdle(data.hapi.output_data.nodes.node.node_id);

                            }
                        }, error: function () {
                        }
                    });
                    showAnalysisSplashforGen10();
                }

                this.init = function () {

			 
			$('#installsettable').hide();
                $('input[name=install-option]:radio').change(function () {

                        if ($("input[name='install-option']:checked").val() == 'BL') {
                            $('#hpsum-localhost').show();
                            $('#hpsum-pendinglist-table-div').hide();
                            $('#iLOQueuedComponents').hide();
							$('#hpsum-action-ok-button').val(localizer.getString('hpsum.common.button.ok'));


                        if (glbExceptionState) {
                            //enable the ok button when task queue is in exception state and baseline radio is checked
                            if (!okButtonValueSet)
                                enableMainDialogOkButton();

                            }
                            if (guimode == "offline_automatic") {

                                $("#hpsum-localhost_hpsum-gu-node-baseline").text(defaultBL_offlineauto);
                                $('#hpsum-localhost_hpsum-node-assign-baseline-li').hide();
                                $('#hpsum-localhost_hpsum-node-assign-baseline').attr("disabled", "disabled");
                                $('#hpsum-localhost').hide();
                            }

                        }
                        if ($("input[name='install-option']:checked").val() == 'TaskQueue') {
							if(isTaskScheduled){
								$('#hpsum-action-ok-button').val("Run Now");
							}
                        if (glbExceptionState) {
                           
                            disableMainDialogOkButton();

                            }

                            $('#hpsum-localhost').hide();
                            $('#hpsum-pendinglist-table-div').show();
                            $('#iLOQueuedComponents').show();
                        }
                    });
                    GetServerinfoandNodeID();
                    $(OFFLINE_EXIT_BUTTON).addClass('hp-disabled'); /// disable now enable when needed
                    $(OFFLINE_EXIT_BUTTON).unbind('click').bind('click', onExitButton);
                    updateUserInterfaceForOEM();
                };


                function ExecuteGen10Functionality() {


                    var nodeItem = {node_id: globalNodeID}


                    NodePresenter.getNodeData(nodeItem, {
                        success: function (data) {


                            DisplayIloTaskQ(data, data.hapi.node_id);
                            if (splashrunning)
                                closeAnalysisSplashforGen10();

                        },
                        error: function () {
                            onaddNodeError(this.node_name, errorInfo);
                        }
                    });


                    showAnalysisSplashforGen10();


                }

                function Initialize() {

                    window.bRefreshReview = false;
                    $(DELTA_BASE).hpSelect();
                    document.title = localizer.getString("hpsum.oneTouchUpdate.title");
                    $('#hpsum-otu-action-title-message').text(localizer.getString("hpsum.oneTouchUpdate.baselineNodeInvTitle"));
                    $('#hpsum-otu-inventory-baseline-collapse').show();

                    $('.hp-details-actions').hpDropMenu();


                    //Disable Actions until the Inventory finishes
                    $(HPSUM_OTU_ACTIONS).hide();

                    actionDialogContents = $(ACTION_DIALOG).detach().show();
                    ilotasksdlgitemContents = $(ACTION_DIALOG).detach().show();
                    autoConfDialogContents = $(AUTOMATIC_UPDATE_CONFIRM).detach().show();

                    preReqsDialogContents = $(PREREQS_DIALOG).detach().show();

					iloCredDialogContents = $(ILO_CREDENTIALS_DIALOG).detach().show();
					cacDialogContents = $(CAC_ERROR_DIALOG).detach().show();

		    $("#installsettable").hide();
                    //Initialize wizard tables
                    initInventoryTables();
                    initDeployProgressTable();

                    
                    //load nodes list. This is used to display in action dialog nodes table
                     
                    loadNodes();


                    $(actionDialogContents).keydown(function (e) {
                        if (e.which === ESCAPE_KEY_CODE || e.keyCode === ESCAPE_KEY_CODE) {
                            onCancelButton();
                        }
                    });

                    var setting = {
                        ctrls: $("#wizard section"), //Structure for Steps
                        deployButtonTitle: localizer.getString("hpsum.node.doDeploy"),
                        nextButtonTitle: localizer.getString("hpsum.common.next"),
                        nextButtonCss: 'hp-button hp-primary',
                        callBack: btnNextClicked,
                        previousButtonTitle: localizer.getString("hpsum.common.back"),
                        callBackPrev: btnPrevClicked,
                        previousButtonCss: 'hp-button hp-secondary',
                        finishButtonTitle: localizer.getString("hpsum.oneTouchUpdate.reboot"),
                        callFinish: btnFinishClicked,
                        finishButtonCss: 'hp-button hp-primary',
                        abortButtonTitle: localizer.getString("hpsum.common.abort"),
                        callAbort: btnAbortClicked,
                        abortButtonCss: 'hp-button hp-secondary',
                        resetButtonTitle: localizer.getString("hpsum.common.startOver"),
                        callReset: btnResetClicked,
                        resetButtonCss: 'hp-button hp-secondary',
                        analyzeButtonTitle: localizer.getString("hpsum.oneTouchUpdate.analyze"),
                        callAnalyze: btnAnalyzeClicked,
                        analyzeButtonCss: 'hp-button hp-secondary',
                        validateWizardStep: validateStep,
                        validateWizardByTitle: validateByTitle,
                        initStep: '0'
                    };

                    showWizardScreen(setting);

                    //////////////////////////////////////////////////////////////////////////////////////
                    //The following lines are commented for HPSUM 6.0.0 as we are not supporting multiple nodes/baselines options
                    //This code avoid showing of Nodes and Baseliens tables for selection
                    //These lines can be uncommented in future release when we need multiple nodes/baselines support in Guided update
                    //$('input:radio[name=node-option]', actionDialogContents).click(onNodeOptionChange);
                    //$('input:radio[name=mode-option]', actionDialogContents).click(onModeChange);
                    //////////////////////////////////////////////////////////////////////////////////////

                    //if offline interactive or automatic, then no need to show action dialog
                    //one touch update shall happen with default values for local host and default working directory
                    //get the property from guimode cookie
                    var guimode = session.getProperty("gui_mode");

                    if (guimode === "offline_automatic" ||
                        guimode === "offline_interactive" || guimode === "express") {
                        $('#hp-exit-control').show();//Show it. Will hide conditionally.

                        if (guimode === "offline_automatic" || guimode === "express") {

                            hideAllButtons(STEP_INVENTORY);
                        }
                        if (guimode === "express") {
                            $('#hp-exit-control').hide();
                        }
                        else if (guimode === "offline_interactive" || guimode === "offline_automatic") {
                            var handlers = {
                                success: function () {
                                    var newWindow = window.open('', '_self', '');
                                    newWindow.close();
                                },
                                error: function () {
                                    var newWindow = window.open('', '_self', '');
                                    newWindow.close();
                                    Log.error("Failed to shutdown Smart Update Manager");
                                }
                            };
                            /*$("#hpsum-offline-exit").click(function() {
                             var shutdownData = { hapi: {
                             force: 'false'
                             }};
                             session.shutDown(shutdownData, handlers);
                             });*/
                        }


                        if (globalisGen10) {

                            ExecuteGen10Functionality();


                        }
                        else {

                            LocalHostGuidedUpdate(false, null, false);
                            if (!okButtonValueSet) {
                                $('#iLOUpdateMsg').hide();
                            }
                            $('#BLorInstallset').hide();
                            $('#iLOQueuedComponents').hide();

                        }


                    }
                    else {
                        //We will not show exit button in online Local guide update
                        $('#hp-exit-control').hide();


                        if (!globalisGen10) {
                            showActionDialog();
                            if (!okButtonValueSet) {
                                $('#iLOUpdateMsg').hide();
                            }
                            $('#BLorInstallset').hide();
                            $('#iLOQueuedComponents').hide();
                            $(ACTION_DIALOG).hide();
                        }
                        else
                        {
                            ExecuteGen10Functionality();
                        }


                    }


                    $(".hp-collapsible").hpCollapsible();
                    $(".hp-collapsible").hpCollapsible("expand");

                    $('#chkboxheader').on('click', selectComponents);

                    $(VIEW + ' .hp-status').hpStatus();
                    $(VIEW).on('click', 'td > .hp-collapser', function (ev) {
                        toggleExpansion($(this).parents('tr').first());
                    });

                    componentLogDialogContents = $(COMPONENT_DIALOG).detach().show();
                    $('input[name="node-option"]').click(nodeOptions);
                 
                    $("#hpsum-localhost").hpsumAddNodeDetails('init');
                     
                   
                    var item = {
                        enableAssignBaselineCheckbox: true,
                        showAssignedBaselines: true,
                        baselineSelectionChanged: onBaselineSelectionChanged,
                        baselineLabel: localizer.getString('hpsum.node.addBaselineOptionalGU')
                    };
                    var options = {
                        command: 'addBaseline',
                        args: item
                    };
                    $("#hpsum-localhost").hpsumAddNodeDetails(options);
                    

                    //Notification area added
                    notificationsView.init({
                        context: $(VIEW),
                        allLocation: '#/node/show/activity',
                        resource: NodePresenter.resource()
                    });
                };

                function clearNotifications() {
                    if (notificationsCleared === false) {
                        notificationsView.remove({
                            status: status,
                            summary: summary,
                            details: details
                        });
                        notificationsView.clear();
                        notificationsCleared = true;
                    }
                }
				
			function updateUserInterfaceForOEM()
			{
				var sessionDataHandlers = {
					success : function(data) {
						// if hcode is 0 then session is alive and set session cookies
						if(data.hapi.hcode == 0) {
							var mfg = data.hapi.manufacturer;
							session.saveManufacturer(mfg);
							if (mfg != "HP") {
								//Hide the HP copyright
								$('.hp-confidential').hide();
							}						
						}
						else
						{
							// if session is expired or any other error, then goto login page
							session.eraseAll();
							document.location.href = "/#/login";
						}
					},
					error : function(jqXHR) {
						// getsessiondata failed, so goto login page
						session.eraseAll();
						document.location.href = "/#/login";
					}
				};

				//get session data and set user and login details for the session
				session.getSessionData(sessionDataHandlers);
			}
			
			function showiLOCredentialsDialog() 
			{
				if(renderiLOCredDialog)
				{
					iloCredDialog.cancel();
            }

				if(iloCredDialogContents == undefined)
				{
						 iloCredDialogContents = $(ILO_CREDENTIALS_DIALOG).detach().show();
				}
		
				if(isInvalidiLOCredentials == false)
				{
					var credMessage = "";
					if (isBIOSPasswordSet)
					{
						credMessage = localizer.getString("hpsum.oneTouchUpdate.iloBIOSPasswordEnabled");
					}
					else
					{
						credMessage = localizer.getString("hpsum.oneTouchUpdate.iloHighSecurityMode");
					}
					$(ILO_DIALOG_TEXT,iloCredDialogContents).html(credMessage + localizer.getString("hpsum.oneTouchUpdate.enteriLOCredentials"));
				}
				else{
					$(ILO_DIALOG_TEXT,iloCredDialogContents).html(localizer.getString("hpsum.oneTouchUpdate.iLOInvalidCredentials"));
				}	

				iloCredDialog = new DialogView();
				iloCredDialog.init({contents: iloCredDialogContents,
					ok: function (elem) {
					},
					cancel: function () {
					}
				});

				$(OKBUTTON,iloCredDialogContents).attr('disabled', true);
				$(ILO_USERNAME,iloCredDialogContents).val("");
				$(ILO_PASSWORD,iloCredDialogContents).val("");
				$(ILO_USERNAME,iloCredDialogContents).keyup(validateiLOCredentials);
				$(ILO_PASSWORD,iloCredDialogContents).keyup(validateiLOCredentials);
				$(OKBUTTON,iloCredDialogContents).unbind('click').bind('click', oniLOCredOkButton);
				$(CANCELBUTTON,iloCredDialogContents).unbind('click').bind('click', oniLOCredCancelButton);
				
				renderiLOCredDialog = true;
			}
			
			function oniLOCredOkButton()
			{
				if(validateiLOCredentials())
				{
					var iloCredentials =  {
                    	hapi: {
						
								ilo_username : $(ILO_USERNAME).val(),
								ilo_password : $(ILO_PASSWORD).val()			
							}
                    };
				
				NodePresenter.setattribute(NodeDataItem, iloCredentials, {
                        success : onSubmitSuccess,
                        error : onSubmitError
                    });
				showAnalysisSplashforGen10();
				}
			}
			
			function validateiLOCredentials() 
			{
				var success = true;
            	if($(ILO_USERNAME).val() == ''){
					$(OKBUTTON).attr("disabled", true);
            		success= false;
            	}
            	if($(ILO_PASSWORD).val() == ''){
            		$(OKBUTTON).attr("disabled", true);
            		success= false;
            	}
				if( $(ILO_USERNAME).val() != '' && $(ILO_PASSWORD).val() != '' )
				{
					$(OKBUTTON).attr("disabled", false);
					success = true;
				}
            	return success;
			}
			
			function onSubmitError(errorMessage) {
				$(OKBUTTON,iloCredDialogContents).attr('disabled','disabled');
				$(CANCELBUTTON,iloCredDialogContents).trigger('click');
			}
			
			function oniLOCredCancelButton() {
				if(iloCredDialog)
				{
					iloCredDialog.cancel();
				}
				 
				if(guimode !== "offline_automatic" &&
					guimode !== "offline_interactive" && guimode !== "express")
				{
					router.go('/welcome', 'canceled guided update');
				}
				else					
				{
						EnableDisableOfflineExitButton(true);
						$(HPSUM_OTU_ACTIONS).hide();
				}
			}
			
			function onSubmitSuccess() {
				var progressTimer = setInterval(function () {		
					var nodeItems = { node_id: NodeDataItem.node_id };
						NodePresenter.getNodeData(nodeItems, {
									success : function(data) {
										if(data.hapi.node_phase.match(/UserActionNeeded/i))
										{
											clearInterval(progressTimer);
											iloCredDialog.cancel();
											isInvalidiLOCredentials = false;
											if(globaldataforprereq!="")
												WaitUntilIdle(globaldataforprereq);
											else
												$(ACTION_DIALOG).show();
											return;
										}
										else if (data.hapi.node_phase.match(/unknown/i)) {
										    clearInterval(progressTimer);
										    oniLOCredUpdateError();
										    return;
										}
									},
									error:function(){
										clearInterval(progressTimer);
										oniLOCredUpdateError();
										return;
									}
								});
					},5000);			
			}
			
			
			function oniLOCredUpdateError()
            {
				if(iloCredDialog)
				{
					iloCredDialog.cancel();
				}
				isInvalidiLOCredentials = false;
				WaitUntilIdle(globaldataforprereq);
            }
			
			function showiLOCACHighSecurityDialog() 
			{
				if(renderiLOCACDialog)
				{
					cacDialog.cancel();
				}
				if(cacDialogContents == undefined)
				{
					cacDialogContents = $(CAC_ERROR_DIALOG).detach().show();
				}
				
				var node_name = "localhost";
				var titleMessage = "";
				var credMessage = "";
				var suggestMessage = "";
				
				if (isBIOSPasswordSet)
				{
					titleMessage = "BIOS Password Enabled";
					credMessage = localizer.getString("hpsum.oneTouchUpdate.iloBIOSPasswordEnabled");
					suggestMessage = localizer.getString("hpsum.oneTouchUpdate.iloBIOSPasswordEnabledOffline");					
				}
				else
				{
					titleMessage = "High Security Mode";
					credMessage = localizer.getString("hpsum.oneTouchUpdate.iloHighSecurityMode");
					suggestMessage = localizer.getString("hpsum.oneTouchUpdate.iloHighSecurityModeOffline");
				}
				
				if(isHighSecurity || isBIOSPasswordSet)
				{
					$(CAC_SECURITY_TITLE,cacDialogContents).text(titleMessage);
					if( guimode == "offline_automatic" )
					{
						$(CAC_DIALOG_TEXT,cacDialogContents).html(credMessage + suggestMessage);
					}
					else if( guimode == "express" )
					{
						$(CAC_DIALOG_TEXT,cacDialogContents).html(credMessage + localizer.getString("hpsum.oneTouchUpdate.iloHighSecurityModeExpress"));
					}
				}
				else if(isInvalidiLOCredentials)
				{
					$(CAC_SECURITY_TITLE,cacDialogContents).text(localizer.getString("hpsum.node.iLOCredentials"));
					$(CAC_DIALOG_TEXT,cacDialogContents).html(localizer.getString("hpsum.oneTouchUpdate.iLOInvalidCredentials"));
				}
				else
				{
					$(CAC_SECURITY_TITLE,cacDialogContents).text("CAC Mode");
					$(CAC_DIALOG_TEXT,cacDialogContents).html(localizer.getString("hpsum.oneTouchUpdate.iLOCACError"));
				}
				
				cacDialog = new DialogView();
				cacDialog.init({contents: cacDialogContents,
					ok: function (elem) {
					},
					cancel: function () {
					}
				});

				$(CAC_OKBUTTON,cacDialogContents).attr('disabled', false);
				$(CAC_OKBUTTON,cacDialogContents).unbind('click').bind('click', onCACErrButton);
				
				renderiLOCACDialog = true;
				
				if(guimode == "express")
				{
					handleExpressExit();
				}
			}
			
			function onCACErrButton() 
			{
				if(cacDialog)
				{
					cacDialog.cancel();
				}
				
				isHighSecurity = false;
				isBIOSPasswordSet = false;
				isInvalidiLOCredentials = false;
				
				if(guimode !== "offline_automatic" &&
					guimode !== "offline_interactive" && guimode !== "express")
				{
					router.go('/welcome', 'canceled guided update');
				}
				else
				{
					if(guimode == "express")
					{
						handleExpressExit();
					}
					else
					{
						EnableDisableOfflineExitButton(true);
						$(HPSUM_OTU_ACTIONS).hide();
					}
				}
			}

			function onBaselineSelectionChanged(isRecoverySet)
			{
			    var msg = "";
			    $("#hpsum-ilotaskListDetailsMessage").empty();
			    if (iloTasklistlength > 0) {
			        $('#hpsum-warning-label').show();
			        msg = localizer.getString('hpsum.oneTouchUpdate.updatependingilodetails_1');
			        msg = msg + '<br />';
			    }
			    else
			    {
			        $("#iLOUpdateMsg").hide();
			        $('#hpsum-warning-label').hide();
			    }
			    if(isRecoverySet)
			    {			        
			        $("#iLOUpdateMsg").show();
			        disableMainDialogOkButton();
			        okButtonValueSet = true;
			        msg = msg + '<br />' + localizer.getString('hpsum.oneTouchUpdate.okBtnDisabledDueRecoverySet');
			    }
			    else
			    {
			        enableMainDialogOkButton();
			        okButtonValueSet = false;
			    }
			    $("#hpsum-ilotaskListDetailsMessage").append('<label >' + msg + '</label>');
			}

          }

        return new OneTouchUpdateView();
    }());
    
    return OneTouchUpdateView;
});
