// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type (SD2DeployView)
 * This is a view class for Custom Baseline Add menu option.
 */
define(['hpsum/presenter/node/NodePresenter',
    'hp/core/UrlFragment',
    'hp/core/Router',
    'hp/core/Notifications',
    'hp/core/HelpMenu',
    'hp/model/Session',
    'hp/services/REST',
    'hp/core/Localizer',
    'jquery',
    'hpsum/view/node/jquery.hpsumInstallables',	
    'hpsum/view/node/jquery.hpsumWarnings', 
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'lib/jquery.dataTables.rowReordering',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpToggle',	
	'hp/lib/jquery.hpSearchCombo'],

function(presenter, urlFragment, router, notifications, helpMenu, session, rest, localizer) {"use strict";

    var SD2DeployView = ( function() {

            var DEPLOY = '#hpsum-sd2-deploy-ok',
            ANALYSIS = '#hpsum-sd2-deploy-analysis',
            CANCEL = '#hpsum-sd2-deploy-close',
            PANEL_SELECTOR = '#hpsum-deploy-panel-selector',
            FIRST_ANCHOR = PANEL_SELECTOR + ' a[href]:first',
            PANELS = '#hpsum-sd2-deploy-panels',
            DESCR = '#hpsum-sd2-deploy-descr',
            TYPE = '#hpsum-sd2-deploy-type',
            GROUP = '#hpsum-sd2-deploy-group',
            ROUTE_PREFIX = '/node/sdx/deploy',
            NONECHECKBOX = '.nonecheckbox',
            DOWNGRADECHKBOXCOMP = '.downgradechkbox',
            ANALYSIS_ERRORS = '#hpsum-sd2-analysis-errors',
            UPDATE_TYPE = '#sd2-update-type',
            PARTITION_TABLE = '#sd2-partitions',
            BLADE_TABLE = '#sd2-blades',
            COMPLEX_TABLE = '#sd2-complex',
            REBOOT_TABLE = '#sd2-reboot',
            SPLASH_DIALOG = '#hpsum-splash-dialog',
			SPLASH_SPINNER = '#hpsum-splash-spinner',
			REBOOT_DELAY_SEC = '60';
			
            /**
             * Constructor
             */
            function SD2DeployView() {

				
                var nodeItem = null;
				var isSelectionChanged = false;
				var hasOptionDetailsSet = false;
                var componentsList = {
                    hapi : {
                        components : {
                            component : []
                        }
                    }
                }

                var installationoptions = {                    
					firmware :true,
					software :true,
					force : false,
                    downgrade : false,
                    rewrite : false
                };

                var sd2_options = {
                    ignore_warnings : false,
                    update_type : 'ALL',
                    device_list : '',
                    reboot_list : ''
                }

                var optiondetails = {
                    hapi : {
                        reboot_options : {
                            reboot : 'No',
                            delay : REBOOT_DELAY_SEC,
                            description : 'Reboot at user request after deploy '
                        },
                        installation_option : {
							firmware :true,
							software :true,
                            downgrade : false,
                            rewrite : false,
                            force : false
                        },
                        sd2_device_selections : {
                            ignore_warnings : false,
                            update_type : 'ALL',
                            device_list : '',
                            reboot_list : ''
                        }
                    }
                }
				
                var displayBaselineError = false;
				var deployTodo = false;
				var hasOptionsdetailsSet = false;
				
				
                function onItemChange(item) {
				
                    reset();
                    nodeItem = item.hapi;

                    if (nodeItem) {
                        
                        if(!(nodeItem.node_state.match(/uan/i) || nodeItem.node_state.match(/analysis/i))) {
                            $(CANCEL).trigger('click');
                        }
                        
                        //If the user has deleted the baseline then we cannot proceed to deploy
                        //so we display a message that there is no available baseline and exit
                        if (nodeItem.baselines.length == 0 && !displayBaselineError) {
                            displayBaselineError = true;
                            $("<div></div>").dialog({
                                buttons : {
                                    "Ok" : function() {
													
                                        displayBaselineError = false;
                                        $(this).dialog("close");
                                        $(CANCEL).trigger('click');
                                    }
                                },
                                close : function(event, ui) {
												
                                    $(this).remove();
                                },
                                resizable : false,
                                title : localizer.getString("hpsum.node.doDeploy"),
                                modal : true
                            }).text("No baseline available to proceed with deployment");
                        }

                        $(DESCR).text(nodeItem.name);
                        $(TYPE).text(nodeItem.type);
                        $(GROUP).text(nodeItem.group);

                        if (nodeItem.analysis_errors == '') {
                            $(ANALYSIS_ERRORS).removeClass('hpsum-error-area');
                            $(ANALYSIS_ERRORS).text('None');
                        } else {
                            $(ANALYSIS_ERRORS).text(nodeItem.analysis_errors);
							$(ANALYSIS_ERRORS).addClass('hpsum-error-area');
                            $('#hpsum-sd2-deploy-analysis-errors-collapsible').removeClass('hp-collapsed')
                        }

						$('#hpsum-warning-messages').hpsumWarnings(nodeItem, true);
						$('.ignorewarnings').on('change', function(){
							if ($(DEPLOY)[0]) {
								if ($(this).is(':checked')) {
									$(DEPLOY).attr("disabled", $(DEPLOY).attr("disabled_org") == 1);
								} else {
									$(DEPLOY).attr("disabled", true);
								}
							}
						});

                        if (nodeItem.node_state === 'UAN') {
                  
                        } else if (nodeItem.node_state === 'INSTALLDONE') {
                            $(DEPLOY).attr("disabled", true);
                   
                        } else {
                            $(DEPLOY).attr("disabled", false);
                      
                        }

                        populateSelectDevices(nodeItem);

                        var options = {
                            command : 'init',
                            nodeItem : nodeItem,
                            onSelectionChanged : onSelectionChanged,
							onPopulateInstallSet:onPopulateInstallSet

                        };
                        $('#all-baselines').hpsumInstallables(options);

                        presenter.otheroption(nodeItem, {
                            success : populateOtherOptions,
                            error : onPopulateError
                        });
                    
                    } else {
                        notifications.show("Please select correct node", 'error');
                        $(DESCR).text("");
                        $(TYPE).text("");
                        $(GROUP).text("");
                        $(DEPLOY).attr("disabled", true);
                        $(ANALYSIS).attr("disabled", true);
                        $(CANCEL).trigger('click');
                    }
                }

                function onSelectionChanged(id, value, componentList) {
				
                    if (value == true) {
                        isSelectionChanged = true;
                        $(DEPLOY).attr("disabled", true);
                    } 
                      
                        if (componentList.component.length > 0 && componentList.failed_dependency == 0) {
                            $(DEPLOY).attr("disabled", false);
							
							
                        } else  {
                            $(DEPLOY).attr("disabled", true);
                        }
					
					// Block deploy button if there is any unchecked ignore warnings checkbox
					// save disabled status to enable recovery it if ignore warnings changed
					$(DEPLOY).attr("disabled_org", $(DEPLOY)[0].disabled ? 1:0);
					if ($(".ignorewarnings")[0] && !$(".ignorewarnings").is(':checked')) {
						$(DEPLOY).attr("disabled", true);
					}
                    
                }
				function onPopulateInstallSet()
				{
				
					if(isSelectionChanged && hasOptionDetailsSet){
					
					
                    presenter.analysis(nodeItem, componentsList, {
                        node_id : nodeItem.node_id,
                        success : function(data) {
									
                            analyzeSuccess(data, this.node_id);
							
                        },
                        error : function(errorInfo) {
									
                            analyzeError(errorInfo);
							
                        }
                    });
					  var progressTimer = setInterval(function() {
                        var node_uri = "/Session/" + session.getToken() + "/node/" + nodeItem.node_id;
                        rest.getURI(node_uri + "/getstatus", {
                            success : function(data) {
                                nodeItem.node_state = data.hapi.node_status.node_state;
                                if (data.hapi.node_status.node_state === "ANALYSIS") {
                                } else if (data.hapi.node_status.node_state === "UAN") {
									 
									if(deployTodo)
										onDeploy();
									deployTodo = false;
									clearInterval(progressTimer);
                                    closeAnalysisSplash();
                                    isSelectionChanged = false;
									hasOptionDetailsSet = false;
                                } else if (data.hapi.node_status.node_state === "ERROR") {
                                    clearInterval(progressTimer);
                                    closeAnalysisSplash();
                                }
                            },
                            error : function(errorInfo) {
                            }
                        });
                    }, 3000);
					
					}
					else if(hasOptionDetailsSet || isSelectionChanged)
					{
				
						if(deployTodo)
						{
							onDeploy();
							hasOptionDetailsSet = false;
							isSelectionChanged = false;	
							deployTodo = false;
						}
					closeAnalysisSplash();
					}
					
					
				}
               

                 function showAnalysisSplash()
			{
				$(SPLASH_DIALOG).dialog({
			        modal : true,
			        position : "center",
			        draggable : false,
			        resizable : false,
			        show : 'fade',
					dialogClass : 'hp-splash-dialog',
			        width : 400
			    });
				
				$(SPLASH_SPINNER).show();	
			}
			
                function closeAnalysisSplash() {
								
                    $(SPLASH_SPINNER).hide();
                    $(SPLASH_DIALOG).dialog('destroy');
                }
		
                function populateSelectDevices(item) {

                    //Populate the complex device table
                    var cplxDetail = $('<tr></tr>').html('<td><input class=\"select-complex require-analysis\" type=\"checkbox\"></td><td>' + item.firmware_version + '</td>')
                    $(COMPLEX_TABLE).append(cplxDetail);

                    //Populate the partition device table
                    if (item.npar_list.length > 0) {
                        for (var i = 0; i < item.npar_list.length; i++) {
                            var npar = item.npar_list[i];
                            var installedFW, activeFW;

                            for (var j = 0; j < npar.FWVersionEx.length; j++) {
                                var fw = npar.FWVersionEx[j];
                                if (fw.FWVersionType == 3 && fw.FWVersion != "Unknown") {
                                    activeFW = fw.FWVersion;
                                } else if (fw.FWVersionType == 4) {
                                    installedFW = fw.FWVersion;
                                }
                            }

                            var nparVal = 'npar' + npar.Number;

                            var nparDetail = $('<tr></tr>').html('<td><input class=\"select-partition require-analysis\" type=\"checkbox\" value=\"' + nparVal + '\"></td><td>' + npar.Name + '</td><td>' + installedFW + '</td><td>' + activeFW + '</td>');
                            $(PARTITION_TABLE).append(nparDetail);
                        }
                    } else {
                        var nparDetail = $('<tr></tr>').html('<td align=\"center\" colspan=\"3\">No available Partitions</td>');
                        $(PARTITION_TABLE).append(nparDetail);
                    }

                    //Populate the blade partition table
                    if (item.unassigned_blade_list.length > 0) {
                        for (var i = 0; i < item.unassigned_blade_list.length; i++) {
                            var device = item.unassigned_blade_list[i];
                            var complexFw, partitionFW, bladeName, bladeValue;

                            bladeValue = 'blade' + device.Enclosure + '/' + device.Bay;
                            bladeName = 'Enc ' + device.Enclosure + ', Bay' + device.Bay;

                            for (var k = 0; k < device.FWVersionEx.length; k++) {
                                var fw = device.FWVersionEx[k];

                                if (fw.FWVersionType == 0) {
                                    complexFw = fw.FWVersion;
                                } else if (fw.FWVersionType == 2) {
                                    partitionFW = fw.FWVersion;
                                }
                            }

                            var bladeDetail = $('<tr></tr>').html('<td><input class=\"select-blade require-analysis\" type=\"checkbox\" value=\"' + bladeValue + '"></td><td>' + bladeName + '</td><td>' + complexFw + '</td><td>' + partitionFW + '</td>');
                            $(BLADE_TABLE).append(bladeDetail);
                        }
                    } else {
                        //No unassigned Blades
                        var bladeDetail = $('<tr></tr>').html('<td align=\"center\" colspan=\"4\">No unassigned Blades</td>');
                        $(BLADE_TABLE).append(bladeDetail);
                    }

                    //Populate the active partition reboot table
                    if (item.npar_list.length > 0) {
                        for (var i = 0; i < item.npar_list.length; i++) {
                            var partition = item.npar_list[i];

                            var parVal = 'npar' + partition.Number;

                            if (partition.Status == 0) {
                                var rebootDetail = $('<tr></tr>').html('<td><input class=\"reboot-partition require-analysis\" type=\"checkbox\" value=\"' + parVal + '\"></td><td>' + partition.Name + '</td>')
                            }
                            $(REBOOT_TABLE).append(rebootDetail);
                        };
                    } else {
                        var rebootDetail = $('<tr></tr>').html('<td>No active Partitions</td>');
                        $(REBOOT_TABLE).append(rebootDetail);
                    }

                    $(".select-partition").on('click', function() {
									
                        $(".all-sd2-partitions").removeAttr("checked");
                        updatePartitionRebootSelection();
                        });
                }

                function setoptiondetails() {

					if((optiondetails.hapi.installation_option.downgrade != $(DOWNGRADECHKBOXCOMP).is(':checked')) ||
                    (optiondetails.hapi.installation_option.force != optiondetails.hapi.installation_option.downgrade) ||
                    (optiondetails.hapi.sd2_device_selections.update_type != $(UPDATE_TYPE).val()) ||
                    (optiondetails.hapi.sd2_device_selections.ignore_warnings != $(".ignorewarnings").is(':checked')))
					{
						hasOptionDetailsSet = true;
					}
                    optiondetails.hapi.installation_option.downgrade = $(DOWNGRADECHKBOXCOMP).is(':checked');
                    optiondetails.hapi.installation_option.force = optiondetails.hapi.installation_option.downgrade;
                    optiondetails.hapi.sd2_device_selections.update_type = $(UPDATE_TYPE).val();
                    optiondetails.hapi.sd2_device_selections.ignore_warnings = $(".ignorewarnings").is(':checked');

					
                    var deviceList = '';

                    $("input:checkbox.select-partition:checked").each(function() {
									
                        deviceList = deviceList + $(this).val() + ',';
					});

                    $("input:checkbox.select-blade:checked").each(function() {
									
                        deviceList = deviceList + $(this).val() + ',';
					});

                    optiondetails.hapi.sd2_device_selections.device_list = deviceList.substring(0, deviceList.lastIndexOf(','));

                    var rebootList = '';

                    $("input:checkbox.reboot-partition:checked").each(function() {
									
                        rebootList = rebootList + $(this).val() + ',';
						
                    });

                    optiondetails.hapi.sd2_device_selections.reboot_list = rebootList.substring(0, rebootList.lastIndexOf(','));
					
                }

                /**
                 * @private
                 * Call presenter's onAnalysis() to check for dependencies for a selected component/baseline to the node
                 */

                function onAnalysis() {
				
				
                    
                    var inst = $('#all-baselines').data('plugin_hpsumInstallables');
					componentsList = inst.getComponents();
					
					setoptiondetails(nodeItem);
					if(isSelectionChanged || hasOptionDetailsSet)
					showAnalysisSplash();
					if(isSelectionChanged && hasOptionDetailsSet)
					{
						
						 //populate the option details into the optiondetails object from UI
						presenter.setattribute(nodeItem, optiondetails, {
						success : function(data){
						
						onsetattributeSuccess();
						},
                        error : function(data) {
						hasOptionDetailsSet = false;
						onsetattributeerror();
						}
						});
					}
					else if (hasOptionDetailsSet) {
                    //populate the option details into the optiondetails object from UI
						presenter.setattribute(nodeItem, optiondetails, {
						success : function(data){
						
						onsetattributeSuccess();
						},
                        error : function(data) {
						hasOptionDetailsSet = false;
						onsetattributeerror();
						}
						});
					}
					else if(isSelectionChanged) {
					deployTodo = true;
                    presenter.analysis(nodeItem, componentsList, {
                        node_id : nodeItem.node_id,
                        success : function(data) {
								
                            analyzeSuccess(data, this.node_id);
							
                        },
                        error : function(errorInfo) {
							isSelectionChanged = false;			
                            analyzeError(errorInfo);
							
                        }
                    });
					}
					else {
					onDeploy();
					}
					
					
					
					
                    var progressTimer = setInterval(function() {
									
                        var node_uri = "/Session/" + session.getToken() + "/node/" + nodeItem.node_id;
                        rest.getURI(node_uri + "/getstatus", {
                            success : function(data) {
											
                                nodeItem.node_state = data.hapi.node_status.node_state;
                                if (data.hapi.node_status.node_state === "ANALYSIS") {
                                } else if (data.hapi.node_status.node_state === "UAN") {
                                    clearInterval(progressTimer);
                                    $('#all-baselines').hpsumInstallables('recalculate');
                                 
                                    
                                } else if (data.hapi.node_status.node_state === "ERROR") {
                                    clearInterval(progressTimer);
                                    closeAnalysisSplash();
                                }
                            },
                            error : function(errorInfo) {
											
                            }
                        });
                    }, 3000);
					
                }
				

                function onsetattributeSuccess() {
						deployTodo = true;
						presenter.getNodeData(nodeItem, {
                        success : onItemChange
                    });
                
				}

                function onsetattributeerror(errorMessage) {
					deployTodo = false;
					analyzeError(errorMessage);
					
                }

                function analyzeSuccess(data, nodeid) {
					
						deployTodo = true;
						 
					
					}
                function analyzeError(error) {
					deployTodo = false;				
                    $(SPLASH_SPINNER).hide();
                    $(SPLASH_DIALOG).dialog('destroy');
                }

                /**
                 * @private
                 * Call presenter's deploy() to deploy  a selected component/baseline to the node
                 */
                function onDeploy() {
								
                    if (nodeItem && nodeItem.node_state === 'UAN') {
                        presenter.deploy(nodeItem, {
                            success : onDeploySuccess,
                            error : onDeployError
                        });
                    }
                }

                /**
                 * @private
                 */
                function onDeploySuccess(item) {
								
                    $(CANCEL).trigger('click');
                }

                /**
                 * @private
                 */
                function onDeployError(errorMessage) {
								
                    notifications.show(errorMessage, 'error');
                    $(ANALYSIS).attr("disabled", true);
                    $(DEPLOY).attr("disabled", true);
                    $(CANCEL).trigger('click');

                }

                function changeLocation(location) {
								
                    if (location.length > ROUTE_PREFIX.length) {
                        $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                    } else {
                        $(PANELS).hpStackedPanels('setFirstPanel');
                    }
                }

                /**
                 * @private
                 */
                function onPopulateError(errorMessage) {
								
                    notifications.show(errorMessage, 'error');
                  //  $(ANALYSIS).attr("disabled", true);
				  
                    $(DEPLOY).attr("disabled", true);
                    $(CANCEL).trigger('click');
                }

                function populateOtherOptions(data) {
				
                    if (data && data.hasOwnProperty("hapi")) {

                        if (data.hapi.hasOwnProperty("installation_option") && data.hapi.installation_option) {
                            installationoptions.downgrade = data.hapi.installation_option.downgrade;
                            installationoptions.force = data.hapi.installation_option.force;
                        }

                        if (data.hapi.hasOwnProperty("sd2_device_selections") && data.hapi.sd2_device_selections) {
                            sd2_options.ignore_warnings = data.hapi.sd2_device_selections.ignore_warnings;
                            sd2_options.update_type = data.hapi.sd2_device_selections.update_type;
                            sd2_options.device_list = data.hapi.sd2_device_selections.device_list;
                            sd2_options.reboot_list = data.hapi.sd2_device_selections.reboot_list;
                        }
                    }

                    $('#sd2-update-type').val(sd2_options.update_type);
                    updateSelectDevices(sd2_options.update_type);

                    $(DOWNGRADECHKBOXCOMP).attr('checked', installationoptions.downgrade);
                }

                function updateSelectDevices(val) {

                    if (val == "ALL") {
                        $(".all-sd2-partitions").attr("disabled", "disabled").attr("checked", "checked");
                        $(".select-partition").attr("disabled", "disabled").attr("checked", "checked");
                        $(".all-sd2-blades").attr("disabled", "disabled").attr("checked", "checked");
                        $(".select-blade").attr("disabled", "disabled").attr("checked", "checked");
                        $(".select-complex").attr("disabled", "disabled").attr("checked", "checked");
                        $(".reboot-partition").removeAttr("disabled");
                    } else if (val == "COMPLEX") {
                        $(".all-sd2-partitions").attr("disabled", "disabled").removeAttr("checked");
                        $(".all-sd2-blades").attr("disabled", "disabled").removeAttr("checked");
                        $(".select-partition").attr("disabled", "disabled").removeAttr("checked");
                        $(".select-blade").attr("disabled", "disabled").removeAttr("checked");
                        $(".select-complex").attr("disabled", "disabled").attr("checked", "checked");
                        $(".reboot-partition").attr("disabled", "disabled").removeAttr("checked");
                    } else if (val == "PARTITIONS") {
                        $(".all-sd2-partitions").removeAttr("disabled checked");
                        $(".all-sd2-blades").removeAttr("disabled checked");
                        $(".select-partition").removeAttr("disabled checked");
                        $(".select-blade").removeAttr("disabled checked");
                        $(".select-complex").attr("disabled", "disabled").removeAttr("checked");
                        $(".reboot-partition").attr("disabled", "disabled").removeAttr("checked");;

                        var selDevices = sd2_options.device_list.split(',');
                        for (var i = 0; i < selDevices.length; i++) {
                            var currDevice = selDevices[i];

                            $('.select-partition').each(function() {
											
                                if ($(this).val() == currDevice) {
                                    $(this).attr("checked", "checked");
                                }
                            });

                            $('.select-blade').each(function() {
											
                                if ($(this).val() == currDevice) {
                                    $(this).attr("checked", "checked");
                                }
                            });
                        }
                        updatePartitionRebootSelection();
                    }

                    var rebootDevices = sd2_options.reboot_list.split(',');
                    for (var i = 0; i < rebootDevices.length; i++) {
                        var rDev = rebootDevices[i];

                        $('.reboot-partition').each(function() {
										
                            if ($(this).val() == rDev) {
                                $(this).attr("checked", "checked");
                            }
                        });
                    }
                }

                function updateAllsd2PartitionSelection() {
				
                    if ($(".all-sd2-partitions").is(':checked')) {
                        $(".select-partition").attr("checked", "checked");
                    } else {
                        $(".select-partition").removeAttr("checked");
                    }
                    updatePartitionRebootSelection();
                }

                function updateAllsd2BladesSelection() {
				
                    if ($(".all-sd2-blades").is(':checked')) {
                        $(".select-blade").attr("checked", "checked");
                    } else {
                        $(".select-blade").removeAttr("checked");
                    }

                }

                function updatePartitionRebootSelection() {
				
                    $('input:checkbox.select-partition').each(function() {
									
                        if(this.checked) {
                            $('input:checkbox.reboot-partition[value="' + $(this).val() + '"]').removeAttr("disabled");
                        }
                    });
                    
                    $('input:checkbox.select-partition:not(:checked)').each(function() {
									
                        $('input:checkbox.reboot-partition[value="' + $(this).val() + '"]').attr("disabled", "disabled").removeAttr("checked");
                    });
                }

                /**
                 * @private
                 */
                function reset() {
				
                    $(NONECHECKBOX).attr('checked', false);
                    $(DOWNGRADECHKBOXCOMP).attr('checked', false);
                    $('#all-baselines').html('');
                    $(COMPLEX_TABLE).html('');
                    $(PARTITION_TABLE).html('');
                    $(BLADE_TABLE).html('');
                    $(REBOOT_TABLE).html('');
                }

                /**
                 * @public
                 */
                this.resume = function() {
				
                    presenter.on("itemChange", onItemChange);
                    $(PANELS).hpStackedPanels('resume');
                    reset();
                };

                this.pause = function() {
                    presenter.off("itemChange", onItemChange);
                    $('.hpsumInstallables').hpsumInstallables('destroy');
                    $(PANELS).hpStackedPanels('pause');
                };

                /**
                 * @public
                 * Initialization funtion for the object
                 * All the controls actions are initialized in this function.
                 */
                this.init = function() {
				
                 
                    $(DEPLOY).live('click', function(ev) {
									
                        onAnalysis.call(this);
                        ev.preventDefault();
                    });
                   
                    $(CANCEL).click(function () {
									
                        router.go(urlFragment.replaceView(router.location(), 'show'));
                    });
                    
                    $(PANELS).hpStackedPanels({
                        panelSelector : PANEL_SELECTOR
                    });
                    $(UPDATE_TYPE).selectBox({autoWidth: false});
                    $(".hp-collapsible").hpCollapsible();
					
                    $(DEPLOY).attr("disabled", true);

                    $(UPDATE_TYPE).change(function() {
                        var val = $(this).find('option:selected').val();
                        updateSelectDevices(val);
                    });

                    $(".all-sd2-partitions").on('click', updateAllsd2PartitionSelection);
					
                    $(".all-sd2-blades").on('click', updateAllsd2BladesSelection);
					
                    router.watch('Node SDX Deploy section', ROUTE_PREFIX + '.*', {
                        parent : ROUTE_PREFIX,
                        change : changeLocation
                    });

                    this.resume();
                };
            }

            return SD2DeployView;
        }());

    return new SD2DeployView();
});
