// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['hpsum/presenter/server/ServerPresenter',
    'hp/view/DialogView',
    'hp/core/Localizer',
    'text!hpsumpages/server/edit_bios.html',
    'jquery',
    'lib/jquery.selectBox'],
function(presenter, DialogView, localizer, editBiosHtml) { "use strict";

    var ServerEditBiosView = (function() {
      
        var OK = '#tour-server-edit-ok';
        var CANCEL = '#tour-server-edit-cancel';
        var FORM = '#tour-server-edit-bios-form';
        
        /**
         * Constructor
         */
        function ServerEditBiosView() {
            
            var html;
            
            function onRowClick(event) {
                var row = $(this);
                var nextRow;
                
                // can't handle selectBox when changing details visibility
                if (! $(event.target).hasClass('selectBox') &&
                    $(event.target).parents('.selectBox').length === 0 &&
                    ! row.hasClass('hp-header') && ! row.hasClass('hp-details')) {
                    $('tr.hp-details', html).hide();
                    $('tr.hp-active', html).removeClass('hp-active');
                    row.toggleClass('hp-active');
                    nextRow = row.next();
                    if (nextRow.hasClass('hp-details')) {
                        nextRow.show();
                    }
                }
            }
          
            function onSelectionChange(selection) {
            }
            
            function onOk() {
                presenter.setBios(); /// TODO
            }
            
            this.resume = function () {
                html = $(editBiosHtml);
                localizer.localizeDom(html);
            
                $('.hp-select', html).selectBox({autoWidth: false});
                $('.hp-details', html).hide();
                $('#tour-server-bios-settings', html).
                    on('click', 'tr', onRowClick);
                var dialogView = new DialogView();
                dialogView.init({contents: html, ok: onOk});
            };
            
            this.pause = function () {
            };
          
            /**
             * @public
             */
            this.init = function () {
            };
        }

        return new ServerEditBiosView();
    }());
    
    return ServerEditBiosView;
});
