// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['hp/view/DetailsShowView',
    'hpsum/presenter/server/ServerPresenter',
    'hp/view/DialogView',
    'hp/core/UrlFragment',
    'hp/core/LinkTargetBuilder',
    'hp/view/NotificationsView',
    'hp/core/Localizer',
    'text!hpsumpages/server/delete_confirm.html',
    'jquery',
    'hp/lib/date',
    'hp/lib/jquery.hpDropMenu',
    'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpCollapsible'],
function(DetailsShowView, presenter, DialogView, urlFragment,
    linkTargetBuilder, NotificationsView, localizer, deleteConfirmHtml) { "use strict";

    var ServerShowView = (function() {
      
        var VIEW = '#tour-server-show';
        var SELECTOR = '#tour-server-panel-selector';
        var HEADER = '#tour-server-show .hp-details-header';
        var TITLE = '#tour-server-details-title';
        var STATUS = '#tour-server-details-status';
        var ACTIONS = '.hp-details-actions';
        var DELETE_ACTION = '#tour-server-delete-action';
        var DELETE_TITLE = '#tour-server-delete-title';
        var NOTIFY_STATUSES = {error:'error', warning:'warning', unknown:'info'};
      
        /**
         * Constructor
         */
        function ServerShowView() {
          
            var detailsShowView = new DetailsShowView();
            var notificationsView = new NotificationsView();
            var deleteInProgress = false;
            var notificationsCleared = false;
                
            function clearNotifications() {
                if (! notificationsCleared) {
                    notificationsCleared = true;
                    notificationsView.clear();
                }
            }
            
            function onItemChange(item) {
                clearNotifications();
                item = item.hapi;
                if (item) {
                    $(HEADER).removeClass('hp-show-changing');
                    if(item.node_state != '')
                   		$(ACTIONS).removeClass('hp-disabled');
                    $(TITLE).removeClass('hp-unavailable');
                    $(TITLE).text(item.name);
                    $(STATUS).removeClass('hp-unavailable');
                    $(STATUS).hpStatus(item.node_status, item.changing);
                        
                    if (item.node_state.match(/idle/i)) {
                    	item.status = localizer.getString('hpsum.common.doActionInventory');
                    	var summary = localizer.getString('hpsum.common.doActionInventory');
                    	 var details =    '<p>' + item.name + ': ' + item.status + '.</p>' + '<a href="#/node/inventory">' + localizer.getString('hpsum.common.doInventory') + '</a>';
                        notificationsView.add({
                            status: NOTIFY_STATUSES[item.status],
                            summary: summary,
                            details: details
                        });
                       }
                } else {
                    $(TITLE).text('');
                    $(STATUS).hpStatus('unknown');
                    $(STATUS + ' span').text('');
                }
            }

            function onItemError(errorMessage) {
            }
            
            function onSelectionChange(selection) {
                notificationsCleared = false;
                clearNotifications();
                urlFragment.replaceHrefUris(HEADER,
                    selection.uris, selection.multiSelectId);
                if ($(HEADER).hasClass('hp-show-init')) {
                    $(HEADER).removeClass('hp-show-init');
                } else {
                    $(HEADER).addClass('hp-show-changing');
                    $(ACTIONS).addClass('hp-disabled');
                }
            }
            
            function onAggregateChange(aggregate) {
                $(TITLE).text(aggregate.count + " Servers");
                $(STATUS).hide();
                notificationsCleared = false;
                clearNotifications();
            }
            
            function onItemDeleteSuccess(item_name) {
                notificationsView.add({summary: "Deleted"}, true);
                deleteInProgress = false;
            }

            /**
             * @private
             */
            function onItemDeleteError(errorMessage) {
                notificationsView.add({summary:errorMessage}, true);
                deleteInProgress = false;
            }

            /**
             * @private
             */
            function onDeleteItem(ev) {
                if (! deleteInProgress) {
                    deleteInProgress = true;
                    
                    var contents = $(deleteConfirmHtml);
                    localizer.localizeDom(contents);
                    $(DELETE_TITLE, contents).text(
                        localizer.getString('hpsum.common.deleteArg',
                            [presenter.selectionLabel()]));
                    
                    var dialogView = new DialogView();
                    dialogView.init({contents: contents,
                        ok: function () {
                            if (presenter.selectionLabel() === 'server 10') {
                                return false;
                            } else {
                                presenter.deleteSelectedItems({
                                    success : onItemDeleteSuccess,
                                    error : onItemDeleteError
                                });
                            }
                        },
                        cancel: function () {
                            deleteInProgress = false;
                        }
                    });
                }
                
                ev.preventDefault();
            }
            
            this.resume = function () {
                notificationsCleared = false;
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("aggregateChange", onAggregateChange);
                presenter.on("itemChange", onItemChange);
                presenter.on("itemError", onItemError);
                if (notificationsView.resume) {
                    notificationsView.resume();
                }
            };
            
            this.pause = function () {
                presenter.off("selectionChange", onSelectionChange);
                presenter.off("aggregateChange", onAggregateChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
                if (notificationsView.resume) {
                    notificationsView.pause();
                }
            };
          
            /**
             * @public
             */
            this.init = function() {
                
                detailsShowView.init($(SELECTOR));
                notificationsView.init({context: $(VIEW),
                    allLocation: '#/server/show/activity',
                    resource: presenter.resource()});
      
                $(ACTIONS).hpDropMenu();
                $('#tour-activity-actions').hide();
                
                $(DELETE_ACTION).bind('click', onDeleteItem);
                
                this.resume();
            };
            
        }

        return new ServerShowView();
    }());
    
    return ServerShowView;
});
