// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['hpsum/presenter/settings/HpsumSettingsPresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/view/FormStateView',
    'hp/core/Notifications',
    'jquery',
    'hp/lib/jquery.hpToggle'],
function(presenter, router, urlFragment, FormStateView, notifications) { "use strict";

    var HpsumSettingsEditView = (function() {
      
        var FORM = '#tour-settings-edit-form';
        var OK = '#tour-settings-edit-ok';
        var CANCEL = '#tour-settings-edit-cancel';
        var NEW_HOTEL = '#tour-new-hotel';
        var HOTELS = '#tour-hotels';
        var TEMPLATE = '#tour-hotel-template';
        var ENTER = 13;
      
        /**
         * Constructor
         */
        function HpsumSettingsEditView() {
            
            var hotelTemplate;
            var locationTemplate;
            var formStateView = new FormStateView();
            
            function removeLocation(ev) {
                $(this).closest('tr').remove();
            }
          
            function addLocation() {
                var input = $(this).closest('.hp-form-input');
                var location = locationTemplate.clone();
                $('.tour-location-name', location).
                    text($('.tour-new-location-name', input).val());
                $('table tbody', input).append(location);
                $('.hp-close', location).click(removeLocation);
            }
            
            function onKeyDown(ev) {
                if (ENTER === ev.which) {
                    addLocation.call(this);
                }
            }
          
            function removeHotel(ev) {
                $(this).closest('.hp-form-item').remove();
                var hotelCount = $('.hp-form-item').length;
                if (hotelCount > 0) {
                    formStateView.update('tour-hotels', "Hotels", hotelCount);
                } else {
                    formStateView.unUpdate('tour-hotels', "Hotels");
                }
            }
            
            function addHotel() {
                var hotel = hotelTemplate.clone();
                $('.tour-remove-hotel', hotel).click(removeHotel);
                $('.tour-add-location', hotel).click(addLocation);
                $('.tour-new-location-name', hotel).keydown(onKeyDown);
                locationTemplate = $('.tour-location-template', hotel).
                    removeClass('tour-location-template').remove().show();
                $(HOTELS).append(hotel);
                formStateView.update('tour-hotels', "Hotels", $('.hp-form-item').length, 0);
            }
            
            this.resume = function () {
                $('#tour-settings-latency').val(presenter.getLatency());
            };
            
            /**
             * @public
             */
            this.init = function () {
              
                $('#tour-toggle').hpToggle({checked : 'Enabled', unchecked : 'Disabled'});
                
                hotelTemplate = $(TEMPLATE).remove().attr('id', '').show();
                
                formStateView.init({form: FORM});
                    
                $(OK).click(function(ev) {
                    presenter.setLatency($('#tour-settings-latency').val());
                    ev.preventDefault();
                    formStateView.reset();
                    $(CANCEL).trigger('click');
                });
                
                $(NEW_HOTEL).click(addHotel);
                
                this.resume();
            };
        }

        return new HpsumSettingsEditView();
    }());
    
    return HpsumSettingsEditView;
});
