// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['hpsum/presenter/switch/SwitchPresenter',
    'hp/core/Router',
    'hp/core/Notifications',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpToggle'],
function(presenter, router, notifications, localizer) { "use strict";

    var SwitchAddView = (function() {
      
        var ADD = '#tour-switch-add',
            CANCEL = '#tour-switch-add-cancel',
            RESET = "#tour-switch-reset",
            PANEL_SELECTOR = '#tour-switch-add-panel-selector',
            FIRST_ANCHOR = PANEL_SELECTOR + ' a[href]:first',
            PANELS = '#tour-switch-add-panels',
            TITLE = '#tour-switch-details-title',
            ERROR = '#tour-switch-details-error',
            NAME = '#tour-switch-name',
            SELECT = '.hp-select',
            SEARCHER = '#tour-switch-searcher',
            COLLAPSE = '#tour-switch-collapse',
            TOGGLE = '#tour-switch-toggle',
            RELATIONS = '#tour-switch-relations',
            RELATIONS_SEARCH = '#tour-switch-relations-search',
            ADD_RELATION = '#tour-switch-relations-add',
            ROUTE_PREFIX = '/switch/add';
            
        /**
         * Constructor
         */
        function SwitchAddView() {
          
            var addInProgress = false,
                relations = [];
          
            function reset() {
                $(NAME).val("");
                $(NAME).focus();
                addInProgress = false;
            }
            
            function resetCancel() {
                reset();
                if (presenter.haveItems()) {
                    $(CANCEL).show();
                } else {
                    $(CANCEL).hide();
                }
            }
            
            function onItemAddSuccess(item) {
                var alertMsg = localizer.getString('hpsum.switchUI.added') + " " + item.name;
                notifications.show(alertMsg, 'ok');
                resetCancel();
                addInProgress = false;
            }

            /**
             * @private
             */
            function onItemAddError(errorMessage) {
                notifications.show(errorMessage, 'error');
                addInProgress = false;
            }

            /**
             * @private
             */
            function onAddItem() {
                if(! addInProgress) {
                    addInProgress = true;
                    presenter.addItem({name: $(NAME).val(),
                        uri: '/switch/item-' + (new Date()).getTime(), status: 'ok'}, {
                        success : onItemAddSuccess,
                        error : onItemAddError
                    });
                }

                return false;
            }
            
            function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }
          
            /**
             * @public
             */
            this.resume = function () {
            };
            
            this.pause = function () {
            };
            
            this.init = function() {
              
                // add some dummy relations
                relations = [["Aunt"], ["Cousin"], ["Uncle"]];
                
                $(RELATIONS).dataTable({
                    bPaginate : false,
                    //bFilter : false,
                    bInfo : false,
                    oLanguage: {
                        sEmptyTable: localizer.getString('hpsum.node.noItemsFound'),
                        sSearch: localizer.getString('hpsum.common.search')
                    },
                    aaData: relations,
                    aoColumns: [{sTitle: "Name"}]
                });
                
                $(SELECT).selectBox({autoWidth: false});
                
                $(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });
                
                //$(SEARCHER).flexbox({
                  //  results: [
                    //    {id: 1, name: "First"},
                      //  {id: 2, name: "Second"},
                      //  {id: 3, name: "Third"}
                   // ]
                //}, {arrowClass: 'ffb-search-icon'});
                
                $(TOGGLE).hpToggle({checked: 'Enabled', unchecked: 'Disabled'});
                
                $(COLLAPSE).hpCollapsible();
                
                $(ADD).live('click', function(ev) {
                    onAddItem.call(this);
                    ev.preventDefault();
                });
                $(RESET).live('click', function() {
                    reset.call();
                });
                
                router.watch('switch add section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
                
                this.resume();
            };
        }

        return new SwitchAddView();
    }());
    
    return SwitchAddView;
});
