// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['hpsum/presenter/switch/SwitchPresenter',
    'jquery',
    'hp/lib/jquery.hpStatus'],
function(presenter) { "use strict";

    var SwitchOverviewMultiView = (function() {
      
        var ROOT = '#tour-switch-overview-multi';
        
        /**
         * Constructor
         */
        function SwitchOverviewMultiView() {
          
            function onAggregateChange(aggregate) {
                $.each(['error', 'warning', 'ok', 'unknown', 'disabled'], function (index, status) {
                    var context = $('.hp-status-count-' + status);
                    $('.hp-status-count', context).html(aggregate.status[status]);
                    if (aggregate.status[status]) {
                        $('.hp-status', context).removeClass('hp-unset');
                    } else {
                        $('.hp-status', context).addClass('hp-unset');
                    }
                });
            }
          
            /**
             * @public
             */
            this.pause = function () {
                presenter.off("aggregateChange", onAggregateChange);
            };
            
            this.resume = function () {
                presenter.on("aggregateChange", onAggregateChange);
            };
            
            this.init = function() {
                $(ROOT + ' .hp-status').hpStatus();
                this.resume();
            };
            
        }

        return new SwitchOverviewMultiView();
    }());
    
    return SwitchOverviewMultiView;
});
